Ext.ux.suncode.ActionAcceptButtonActionWindow = function( config ) {
    var windowWidth = Ext.getBody().getViewSize().width * 0.5;

    config = Ext.apply( {
        modal: true,
        width: windowWidth,
        autoScroll: true,
        title: getTranslation( 'Definicja akcji' ),
        items: [ new Ext.ux.suncode.ActionAcceptButtonActionPanel( config ) ],
        closable: true,
        tbar: new Ext.Toolbar( {
            buttons: [ {
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'save' ),
                tooltip: getTranslation( 'Zapisz' ),
                handler: this.saveForm,
                scope: this
            }, new Ext.ux.suncode.CloseWindowButton( {
            	win: this
            } ) ]
        } )
    }, config );

    Ext.ux.suncode.ActionAcceptButtonActionWindow.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.ActionAcceptButtonActionWindow, Ext.Window, {
    initComponent: function() {
        Ext.ux.suncode.ActionAcceptButtonActionWindow.superclass.initComponent.call( this );
    },
    saveForm: function() {
        this.actionDefPanel.saveForm();
    },
    closeWindow: function() {
        this.close();
    }
} );

Ext.ux.suncode.ActionAcceptButtonActionPanel = function( config ) {
    var actionNode = config.actionNode;
    var activityNode = config.activityNode;
    var variables = activityNode.parentNode.attributes.variables;
    var formalParameters = activityNode.parentNode.attributes.formalParameters;

    var attributionsStore = new Ext.data.Store( {
        reader: new Ext.data.JsonReader( {
            fields: Ext.data.Record.create( [ {
                name: 'varId',
                type: 'string'
            }, {
                name: 'value',
                type: 'string'
            } ] )
        } )
    } );

    var conditionsStore = new Ext.data.Store( {
        reader: new Ext.data.JsonReader( {
            fields: Ext.data.Record.create( [ {
                name: 'varId',
                type: 'string'
            }, {
                name: 'operator',
                type: 'string'
            }, {
                name: 'value',
                type: 'string'
            } ] )
        } )
    } );

    if ( actionNode ) {
        attributionsStore.loadData( actionNode.attributes.action.attributions );
        attributionsStore.commitChanges();
        conditionsStore.loadData( actionNode.attributes.action.conditions );
        conditionsStore.commitChanges();
    }

    var allVariablesChooser = new Ext.ux.suncode.AllVariablesChooser( {
        variables: variables,
        formalParameters: formalParameters
    } );
    var allVariablesChooser2 = new Ext.ux.suncode.AllVariablesChooser( {
        variables: variables,
        formalParameters: formalParameters
    } );
    var valuesChooser = new Ext.ux.suncode.AcceptButtonActionValuesChooser();
    var operatorsChooser = new Ext.ux.suncode.OperatorsChooser();

    config = Ext.apply( {
        autoHeight: true,
        frame: false,
        border: false,
        bodyCssClass: 'x-Module-container-padding',
        ref: 'actionDefPanel',
        items: [ {
            xtype: 'editorgrid',
            height: 250,
            store: attributionsStore,
            title: getTranslation( 'Przypisania' ),
            ref: 'attributionsGrid',
            enableColumnResize: true,
            columnLines: true,
            autoScroll: true,
            frame: false,
            colModel: new Ext.grid.ColumnModel( {
                defaults: {
                    sortable: false,
                    menuDisabled: true
                },
                columns: [ {
                    id: 'varId',
                    header: getTranslation( 'Zmienna' ),
                    dataIndex: 'varId',
                    align: 'left',
                    editor: allVariablesChooser,
                    renderer: Ext.util.Format.ComboBoxRenderer( allVariablesChooser )
                }, {
                    id: 'value',
                    header: getTranslation( 'Wartość' ),
                    dataIndex: 'value',
                    align: 'left',
                    editor: valuesChooser,
                    renderer: Ext.util.Format.ComboBoxRenderer( valuesChooser )
                } ]
            } ),
            viewConfig: new Ext.grid.GridView( {
                forceFit: true
            } ),
            sm: new Ext.grid.RowSelectionModel( {
                singleSelect: true
            } ),
            tbar: new Ext.Toolbar( {
                items: [ '->', {
                    xtype: 'button',
                    cls: 'x-btn-icon',
                    icon: getPluginImgPath( 'add' ),
                    tooltip: getTranslation( 'Dodaj' ),
                    handler: function() {
                        var grid = this.ownerCt.ownerCt;
                        var store = grid.getStore();
                        var a = store.recordType;
                        var rec = new a( {
                            varId: '',
                            value: ''
                        } );
                        grid.stopEditing();
                        store.add( rec );
                        store.commitChanges();
                    }
                }, {
                    xtype: 'button',
                    cls: 'x-btn-icon',
                    icon: getPluginImgPath( 'delete' ),
                    tooltip: getTranslation( 'Usuń' ),
                    handler: function() {
                        var grid = this.ownerCt.ownerCt;
                        var selModel = grid.getSelectionModel();
                        var rows = selModel.getSelections();
                        if ( rows.length == 0 ) {
                            showWarn( getTranslation( 'Wybierz przypisanie do usunięcia.' ) );
                            return;
                        }
                        removeRowAndMarkNext( grid, rows[0] );
                        grid.getView().refresh();
                    }
                } ]
            } ),
            listeners: {
                afteredit: function( e ) {
                    e.record.commit();
                }
            }
        }, {
            xtype: 'editorgrid',
            height: 250,
            store: conditionsStore,
            title: getTranslation( 'Warunki przypisania' ),
            ref: 'conditionsGrid',
            enableColumnResize: true,
            columnLines: true,
            autoScroll: true,
            frame: false,
            colModel: new Ext.grid.ColumnModel( {
                defaults: {
                    sortable: false,
                    menuDisabled: true
                },
                columns: [ {
                    id: 'varId',
                    header: getTranslation( 'Zmienna' ),
                    dataIndex: 'varId',
                    align: 'left',
                    editor: allVariablesChooser2,
                    renderer: Ext.util.Format.ComboBoxRenderer( allVariablesChooser2 )
                }, {
                    id: 'operator',
                    header: getTranslation( 'Operator' ),
                    dataIndex: 'operator',
                    align: 'center',
                    editor: operatorsChooser,
                    renderer: Ext.util.Format.ComboBoxRenderer( operatorsChooser )
                }, {
                    id: 'value',
                    header: getTranslation( 'Wartość' ),
                    dataIndex: 'value',
                    align: 'left',
                    editor: new Ext.form.TextField( {
                        inputType: 'text',
                        stripCharsRe: /\'/g
                    } ),
                    renderer: conditionValueRenderer
                } ]
            } ),
            viewConfig: new Ext.grid.GridView( {
                forceFit: true
            } ),
            sm: new Ext.grid.RowSelectionModel( {
                singleSelect: true
            } ),
            tbar: new Ext.Toolbar( {
                items: [ '->', {
                    xtype: 'button',
                    cls: 'x-btn-icon',
                    icon: getPluginImgPath( 'add' ),
                    tooltip: getTranslation( 'Dodaj' ),
                    handler: function() {
                        var grid = this.ownerCt.ownerCt;
                        var store = grid.getStore();
                        var a = store.recordType;
                        var rec = new a( {
                            varId: '',
                            operator: '',
                            value: ''
                        } );
                        grid.stopEditing();
                        store.add( rec );
                        store.commitChanges();
                    }
                }, {
                    xtype: 'button',
                    cls: 'x-btn-icon',
                    icon: getPluginImgPath( 'delete' ),
                    tooltip: getTranslation( 'Usuń' ),
                    handler: function() {
                        var grid = this.ownerCt.ownerCt;
                        var selModel = grid.getSelectionModel();
                        var rows = selModel.getSelections();
                        if ( rows.length == 0 ) {
                            showWarn( getTranslation( 'Wybierz warunek przypisania do usunięcia.' ) );
                            return;
                        }
                        removeRowAndMarkNext( grid, rows[0] );
                        grid.getView().refresh();
                    }
                } ]
            } ),
            listeners: {
                afteredit: function( e ) {
                    e.record.commit();
                }
            }
        } ]
    }, config );

    Ext.ux.suncode.ActionAcceptButtonActionPanel.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.ActionAcceptButtonActionPanel, Ext.FormPanel, {
    initComponent: function() {
        Ext.ux.suncode.ActionAcceptButtonActionPanel.superclass.initComponent.call( this );
    },
    saveForm: function() {
        var activityNode = this.initialConfig.activityNode;
        var processNode = activityNode.parentNode;
        var attributionsStore = this.attributionsGrid.getStore();
        var conditionsStore = this.conditionsGrid.getStore();
        var attributions = new Array();
        var conditions = new Array();

        if ( attributionsStore.getCount() == 0 ) {
            showWarn( getTranslation( 'Podaj przypisania.' ) );
            return null;
        }

        for ( var i = 0; i < attributionsStore.getCount(); i++ ) {
            var attribution = attributionsStore.getAt( i );
            var varId = attribution.get( 'varId' );

            if ( Ext.isEmpty( varId ) ) {
                showWarn( getTranslation( 'Uzupełnij poprawnie przypisania.' ) );
                return null;
            }

            var attributionDef = {
                varId: varId,
                value: attribution.get( 'value' )
            };

            attributions.push( attributionDef );
        }

        for ( var i = 0; i < conditionsStore.getCount(); i++ ) {
            var condition = conditionsStore.getAt( i );
            var varId = condition.get( 'varId' );
            var operator = condition.get( 'operator' );
            var value = condition.get( 'value' );

            if ( Ext.isEmpty( varId ) || Ext.isEmpty( operator ) ) {
                showWarn( getTranslation( 'Uzupełnij poprawnie warunki przypisania.' ) );
                return null;
            }

            var conditionDef = {
                varId: varId,
                operator: operator,
                value: value
            };

            conditions.push( conditionDef );
        }

      var attributionWarnings = new Array();

      if ( !Ext.isEmpty( attributions ) ) {
        Ext.each( attributions, function ( attribution, index, allAttributions ) {
          var variable = processNode.findVariable( attribution.value );

          if ( !Ext.isEmpty( variable ) ) {
            attributionWarnings.push( attribution.value );
          }
        } );
      }

      if ( !Ext.isEmpty( attributionWarnings ) ) {
        var warning = getTranslation( 'Następujące wartości przypisania są identyczne z identyfikatorem zmiennej procesu:' );

        Ext.each( attributionWarnings, function ( attributionWarning, index, allAttributionWarnings ) {
          warning += '<br>';
          warning += '- ';
          warning += attributionWarning;
        } );

        warning += '<br><br>';
        warning += getTranslation( 'Czy chcesz kontynuować?' );

        Ext.Msg.show( {
          title: '<font weight="bold">' + getTranslation( 'Uwaga' ) + '</font>',
          msg: warning,
          buttons: {
            yes: getTranslation( 'Kontynuuj' ),
            cancel: getTranslation( 'Anuluj' )
          },
          fn: function( buttonId ) {
            switch ( buttonId ) {
              case 'yes':
                this.executeSaveForm( attributions, conditions );
                break;
              default:
                break;
            }
          },
          icon: Ext.Msg.WARNING,
          scope: this
        } );
      } else {
        this.executeSaveForm( attributions, conditions );
      }
    },
    executeSaveForm: function( attributions, conditions ) {
      var treePanel = this.initialConfig.treePanel;
      var actionNode = this.initialConfig.actionNode;
      var actionObj = new Object();
      actionObj = Ext.apply( {
        attributions: attributions,
        conditions: conditions
      }, actionObj );

      if ( actionNode ) {
        actionNode.setText( getActionAcceptButtonActionNodeText( attributions, conditions ) );
        actionNode.attributes.action = actionObj;
      } else {
        treePanel.getRootNode().appendChild( {
          text: getActionAcceptButtonActionNodeText( attributions, conditions ),
          icon: getPluginImgPath( 'action' ),
          leaf: true,
          action: actionObj
        } );
      }

      this.ownerCt.closeWindow();
    }
} );