function showProcessVariableDefinition( processDefId, varId ) {
    var packagePanel = Ext.getCmp( 'package_panel' );
    var processNode = packagePanel.findProcess( processDefId );
    var variable = processNode.findVariable( varId );

    if ( !Ext.ux.suncode.IntegrationComponentService.validateVariableEdit( variable ) ) {
      showWarn( getTranslation( 'Komponent dynamicznej listy o identyfikatorze' )
          + ' ' + variable.definition.id + ' ' + getTranslation( 'nie istnieje' ) + '.' );
      return;
    }

    var win = new Ext.ux.suncode.VariableDefWindow( {
        variable: variable,
        processNode: processNode
    } );
    win.show();
}

function showActivityDefinition( processDefId, activityDefId ) {
    var packagePanel = Ext.getCmp( 'package_panel' );
    var activityNode = packagePanel.findActivity( processDefId, activityDefId );

    showActivityProperties( {
      activityNode: activityNode
    } );
}