Ext.ux.suncode.ProcessSpecificationWindow = function( config ) {
    var windowWidth = Ext.getBody().getViewSize().width * 0.5;
    var processNode = config.processNode;
    var processDefId = processNode.attributes.processDefId;
    var processName = processNode.attributes.processName;
    var processNameTranslation = getXpdlProcessNameTranslation( processDefId, processName );
    var winTitle = getTranslation( 'Specyfikacja procesu' ) + ' ' + processNameTranslation;

    config = Ext.apply( {
        windowWidth: windowWidth
    }, config );

    config = Ext.apply( {
        modal: true,
        width: windowWidth,
        title: winTitle,
        items: [ new Ext.ux.suncode.ProcessSpecificationTabPanel( config ) ],
        closable: true,
        tbar: new Ext.Toolbar( {
            buttons: [ {
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'save' ),
                tooltip: getTranslation( 'Zapisz' ),
                handler: this.saveForm,
                scope: this
            }, new Ext.ux.suncode.CloseWindowButton( {
            	win: this
            } ) ]
        } )
    }, config );

    Ext.ux.suncode.ProcessSpecificationWindow.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.ProcessSpecificationWindow, Ext.Window, {
    initComponent: function() {
        Ext.ux.suncode.ProcessSpecificationWindow.superclass.initComponent.call( this );

        this.on( 'beforeshow', lockHotkeys );
        this.on( 'beforeclose', unlockHotkeys );
    },
    saveForm: function() {
        this.processSpecificationPanel.saveForm();
    },
    closeWindow: function() {
        this.close();
    }
} );

Ext.ux.suncode.ProcessSpecificationTabPanel = function( config ) {
    config = Ext.apply( {
        panelHeight: Ext.getBody().getViewSize().height * 0.8
    }, config );

    config = Ext.apply( {
        border: false,
        ref: 'processSpecificationPanel',
        enableTabScroll: true,
        activeTab: 0,
        autoHeight: true,
        items: [ new Ext.ux.suncode.AssumptionsAndScopePanel( config ), new Ext.ux.suncode.ActivitiesOrderPanel( config ),
                 new Ext.ux.suncode.DatabaseTableSpecificationsPanel( config ), new Ext.ux.suncode.IntegrationSpecificationsPanel( config ),
                 new Ext.ux.suncode.ProgrammingTaskSpecificationsPanel( config ), new Ext.ux.suncode.ScheduledTaskSpecificationsPanel( config ),
                 new Ext.ux.suncode.DocumentClassSpecificationsPanel( config ), new Ext.ux.suncode.DocumentLinkSpecificationsPanel( config ),
                 new Ext.ux.suncode.ProjectExclusionSpecificationsPanel( config ), new Ext.ux.suncode.AttachmentSpecificationsPanel( config ) ]
    }, config );

    Ext.ux.suncode.ProcessSpecificationTabPanel.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.ProcessSpecificationTabPanel, Ext.TabPanel, {
    initComponent: function() {
        Ext.ux.suncode.ProcessSpecificationTabPanel.superclass.initComponent.call( this );
    },
    saveForm: function() {
        if ( !( this.assumptionsAndScopePanel.getForm().isValid() && this.assumptionsAndScopePanel.analysisTeamPanel.isValid()
                        && this.assumptionsAndScopePanel.projectTeamPanel.isValid() ) ) {
          this.activate( this.assumptionsAndScopePanel );
          return;
        }

        var processNode = this.initialConfig.processNode;
        var assumptionsAndScope = this.assumptionsAndScopePanel.readAssumptionsAndScope();
        var activitiesOrder = this.activitiesOrderPanel.readActivitiesOrder();
        Ext.ux.suncode.DocumentationService.setAssumptionsAndScope( processNode, assumptionsAndScope );
        Ext.ux.suncode.DocumentationService.setActivitiesOrder( processNode, activitiesOrder );

        Ext.getCmp( 'main_panel' ).setSaved( false );
        this.ownerCt.closeWindow();
    }
} );

Ext.ux.suncode.AssumptionsAndScopePanel = function( config ) {
    var processNode = config.processNode;
    var processDefId = processNode.attributes.processDefId;
    var processName = processNode.attributes.processName;
    var processNameTranslation = getXpdlProcessNameTranslation( processDefId, processName );
    var specification = processNode.attributes.specification;
    var mainPanel = Ext.getCmp( 'main_panel' );
    var animationsOn = mainPanel.getAnimationsOn();

    config = Ext.apply( {
        title: getTranslation( 'Założenia i zakres wdrożenia' ),
        labelWidth: config.windowWidth * 0.4,
        frame: false,
        border: false,
        bodyCssClass: 'x-Module-container-padding',
        autoScroll: true,
        boxMinHeight: config.panelHeight,
        boxMaxHeight: config.panelHeight,
        ref: 'assumptionsAndScopePanel',
        items: [ {
            xtype: 'displayfield',
            anchor: '95%',
            fieldLabel: getTranslation( 'Nazwa procesu' ),
            value: processNameTranslation
        }, {
          xtype: 'textfield',
          name: 'clientName',
          anchor: '95%',
          fieldLabel: getTranslation( 'Nazwa klienta' ),
          allowBlank: false,
          blankText: getTranslation( 'Pole jest wymagane' )
        }, {
            xtype: 'textfield',
            name: 'systemLink',
            anchor: '95%',
            fieldLabel: getTranslation( 'Link do systemu' )
        }, {
            xtype: 'textfield',
            name: 'processInitiationMethod',
            anchor: '95%',
            fieldLabel: getTranslation( 'Sposób inicjacji procesu' ),
            allowBlank: false,
            blankText: getTranslation( 'Pole jest wymagane' )
        }, {
            xtype: 'panel',
            layout: 'accordion',
            layoutConfig: {
                animate: animationsOn,
                fill: false
            },
            style: {
                marginBottom: '5px'
            },
            bodyStyle: {
                border: 0
            },
            autoWidth: true,
            items: [ new Ext.ux.suncode.TeamSpecificationPanel( {
                title: getTranslation( 'Skład zespołu przeprowadzającego analizę procesu' ),
                ref: '../analysisTeamPanel',
                team: specification.assumptionsAndScope.analysisTeam
            } ), new Ext.ux.suncode.TeamSpecificationPanel( {
                title: getTranslation( 'Skład zespołu wykonującego' ),
                ref: '../projectTeamPanel',
                team: specification.assumptionsAndScope.projectTeam
            } ) ]
        }, new Ext.ux.suncode.SpecificationDescriptionArea( {
          processNode: processNode,
          title: getTranslation( 'Ogólny opis procesu' ),
          fieldName: 'generalProcessDescription',
          description: specification.assumptionsAndScope.generalProcessDescription
        } ), new Ext.ux.suncode.SpecificationDescriptionArea( {
          processNode: processNode,
          title: getTranslation( 'Opis powiadomień mailowych' ),
          fieldName: 'emailNotificationsDescription',
          description: specification.assumptionsAndScope.emailNotificationsDescription
        } ), {
            xtype: 'numberfield',
            name: 'processesPerMonth',
            anchor: '95%',
            fieldLabel: getTranslation( 'Szacowana liczba procesów na miesiąc' ),
            allowDecimals: false,
            allowNegative: false,
            allowBlank: false,
            blankText: getTranslation( 'Pole jest wymagane' ),
            listeners: {
                blur: this.onNumberFieldBlur
            }
        }, {
            xtype: 'numberfield',
            name: 'usersInProcess',
            anchor: '95%',
            fieldLabel: getTranslation( 'Szacowana liczba osób biorących udział w procesie' ),
            allowDecimals: false,
            allowNegative: false,
            allowBlank: false,
            blankText: getTranslation( 'Pole jest wymagane' ),
            listeners: {
                blur: this.onNumberFieldBlur
            }
        } ]
    }, config );

    Ext.ux.suncode.AssumptionsAndScopePanel.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.AssumptionsAndScopePanel, Ext.FormPanel, {
    initComponent: function() {
        Ext.ux.suncode.AssumptionsAndScopePanel.superclass.initComponent.call( this );

        this.on( 'afterrender', this.onAfterRender, this );
    },
    onAfterRender: function() {
        var processNode = this.initialConfig.processNode;
        var specification = processNode.attributes.specification;
        this.getForm().setValues( specification.assumptionsAndScope );
    },
    onNumberFieldBlur: function( field ) {
        var value = field.getValue();

        if ( value === '' ) {
            field.setValue( 0 );
        }
    },
    readAssumptionsAndScope: function() {
        var values = this.getForm().getValues();
        values = Ext.apply( {
            analysisTeam: this.analysisTeamPanel.readTeam(),
            projectTeam: this.projectTeamPanel.readTeam()
        }, values );

        return values;
    }
} );

Ext.ux.suncode.TeamSpecificationPanel = function( config ) {
    config = Ext.apply( {
        layout: 'column',
        frame: false,
        border: false,
        bodyCssClass: 'x-Module-container-padding',
        collapsed: true,
        items: [ new Ext.ux.suncode.TeamMembersPanel( {
            title: getTranslation( 'Po stronie firmy' ),
            ref: 'companySideMembers',
            teamMembers: config.team.companySideMembers,
            style: 'padding-right: 5px'
        } ), new Ext.ux.suncode.TeamMembersPanel( {
            title: getTranslation( 'Po stronie klienta' ),
            ref: 'clientSideMembers',
            teamMembers: config.team.clientSideMembers
        } ) ]
    }, config );

    Ext.ux.suncode.TeamSpecificationPanel.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.TeamSpecificationPanel, Ext.Panel, {
    initComponent: function() {
        Ext.ux.suncode.TeamSpecificationPanel.superclass.initComponent.call( this );
    },
    isValid: function() {
        return ( this.companySideMembers.isValid() && this.clientSideMembers.isValid() );
    },
    readTeam: function() {
        var team = new Object();
        team = Ext.apply( {
            companySideMembers: this.companySideMembers.readMembers(),
            clientSideMembers: this.clientSideMembers.readMembers()
        }, team );

        return team;
    }
} );

Ext.ux.suncode.TeamMembersPanel = function( config ) {
    var store = new Ext.data.Store( {
        data: config.teamMembers,
        reader: new Ext.data.JsonReader( {
            fields: Ext.data.Record.create( [ {
                name: 'name',
                type: 'string'
            } ] )
        } )
    } );

    config = Ext.apply( {
        columnWidth: 0.5,
        height: 150,
        store: store,
        columnLines: true,
        autoScroll: true,
        frame: false,
        colModel: new Ext.grid.ColumnModel( {
            defaults: {
                sortable: true,
                menuDisabled: false
            },
            columns: [ {
                id: 'name',
                header: getTranslation( 'Członek' ),
                dataIndex: 'name',
                align: 'left',
                editor: {
                    xtype: 'textfield'
                }
            } ]
        } ),
        viewConfig: new Ext.ux.suncode.StandardGridView( {
            emptyText: getTranslation( 'Brak członków' )
        } ),
        sm: new Ext.grid.RowSelectionModel( {
            singleSelect: true
        } ),
        tbar: new Ext.Toolbar( {
            items: [ '->', {
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'add' ),
                tooltip: getTranslation( 'Dodaj członka' ),
                handler: function() {
                    var grid = this.ownerCt.ownerCt;
                    var store = grid.getStore();
                    var v = store.recordType;
                    var rec = new v( {
                        name: ''
                    } );
                    grid.stopEditing();
                    store.add( rec );
                    store.commitChanges();
                }
            }, {
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'delete' ),
                tooltip: getTranslation( 'Usuń członka' ),
                handler: function() {
                    var grid = this.ownerCt.ownerCt;
                    var selModel = grid.getSelectionModel();
                    var rows = selModel.getSelections();
                    if ( rows.length == 0 ) {
                        showWarn( getTranslation( 'Wybierz członka do usunięcia.' ) );
                        return;
                    }
                    removeRowAndMarkNext( grid, rows[0] );
                    grid.getView().refresh();
                }
            } ]
        } ),
        listeners: {
            validateedit: function( e ) {
                var grid = e.grid;
                var store = grid.getStore();
                var cm = grid.getColumnModel();
                var colIndex = e.column;
                var value = e.value;

                if ( cm.getColumnId( colIndex ) == 'name' && !Ext.isEmpty( value ) && store.findExact( 'name', value ) != -1 ) {
                    showWarn( getTranslation( 'Członek został już dodany.' ) );
                    return false;
                }
            },
            afteredit: function( e ) {
                e.record.commit();
            }
        }
    }, config );

    Ext.ux.suncode.TeamMembersPanel.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.TeamMembersPanel, Ext.grid.EditorGridPanel, {
    initComponent: function() {
        Ext.ux.suncode.TeamMembersPanel.superclass.initComponent.call( this );
    },
    isValid: function() {
        var valid = new Array();
        var store = this.getStore();

        store.each( function( rec ) {
            var name = rec.get( 'name' );

            if ( Ext.isEmpty( name ) ) {
                showWarn( getTranslation( 'Uzupełnij poprawnie tabelę członków zespołu.' ) );
                valid = false;
                return false;
            }
        } );

        return valid;
    },
    readMembers: function() {
        var members = new Array();
        var store = this.getStore();

        store.each( function( rec ) {
            members.push( {
                name: rec.get( 'name' )
            } );
        } );

        return members;
    }
} );

Ext.ux.suncode.ActivitiesOrderPanel = function( config ) {
    var processNode = config.processNode;
    var specification = processNode.attributes.specification;

    config = Ext.apply( {
        title: getTranslation( 'Kolejność zadań' ),
        labelWidth: config.windowWidth * 0.4,
        frame: false,
        border: false,
        bodyCssClass: 'x-Module-container-padding',
        autoScroll: true,
        boxMinHeight: config.panelHeight,
        boxMaxHeight: config.panelHeight,
        ref: 'activitiesOrderPanel',
        items: [ new Ext.ux.suncode.ActivitiesOrderTypesChooser( {
          anchor: '95%',
          value: specification.activitiesOrder.type,
          listeners: {
            scope: this,
            select: this.onTypeSelect
          }
        } ), new Ext.ux.suncode.ActivitiesSequencePanel( {
        	anchor: '95%',
        	hidden: specification.activitiesOrder.type !== this.CUSTOM_TYPE_ORDER,
        	processNode: processNode,
        	sequence: specification.activitiesOrder.sequence
        } ) ]
    }, config );

    Ext.ux.suncode.ActivitiesOrderPanel.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.ActivitiesOrderPanel, Ext.FormPanel, {
    initComponent: function() {
        Ext.ux.suncode.ActivitiesOrderPanel.superclass.initComponent.call( this );
    },
    CUSTOM_TYPE_ORDER: 'CUSTOM',
    onTypeSelect: function( combo, record, index ) {
        var type = combo.getValue();
        var activitiesSequencePanel = this.activitiesSequencePanel;

        if ( !Ext.isEmpty( type ) && combo.isValid() && type === this.CUSTOM_TYPE_ORDER ) {
        	activitiesSequencePanel.show();
        	activitiesSequencePanel.setHeight( this.getHeight() - 60 );
        } else {
        	activitiesSequencePanel.hide();
        }
    },
    readActivitiesOrder: function() {
      var values = new Object();
      values = Ext.apply( {
        type: this.activitiesOrderTypesItem.getValue(),
        sequence: this.activitiesSequencePanel.readSequence()
      }, values );

      return values;
    }
} );

Ext.ux.suncode.ActivitiesOrderTypesChooser = function( config ) {
    var types = [ [ 'ADDITION', getTranslation( 'W kolejności dodawania' ) ], [ 'AZ_ASC', getTranslation( 'Alfabetyczna rosnąco' ) ],
                    [ 'AZ_DESC', getTranslation( 'Alfabetyczna malejąco' ) ], [ 'CUSTOM', getTranslation( 'Własna' ) ] ];

    config = Ext.apply( {
        ref: 'activitiesOrderTypesItem',
        name: 'type',
        fieldLabel: getTranslation( 'Kolejność zadań' ),
        triggerAction: 'all',
        mode: 'local',
        forceSelection: true,
        store: new Ext.data.ArrayStore( {
            fields: [ 'type', 'typeName' ],
            data: types
        } ),
        valueField: 'type',
        displayField: 'typeName',
        hiddenName: 'type',
        resizable: true,
        allowBlank: false,
        blankText: getTranslation( 'Pole jest wymagane' ),
        editable: false
    }, config );

    Ext.ux.suncode.ActivitiesOrderTypesChooser.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.ActivitiesOrderTypesChooser, Ext.form.ComboBox, {
    initComponent: function() {
        Ext.ux.suncode.ActivitiesOrderTypesChooser.superclass.initComponent.call( this );
    }
} );

Ext.ux.suncode.ActivitiesSequencePanel = function( config ) {
	var processNode = config.processNode;
    
    var store = new Ext.data.Store( {
        data: config.sequence,
        reader: new Ext.data.JsonReader( {
            fields: Ext.data.Record.create( [ {
                name: 'activityDefId',
                type: 'string'
            } ] )
        } )
    } );
    
    var activitiesChooser = new Ext.ux.suncode.ActivitiesChooser( {
        processNode: processNode,
        acceptedTypes: [ Ext.ux.suncode.Constants.ACTIVITY, Ext.ux.suncode.Constants.ROUTE,
                         Ext.ux.suncode.Constants.TOOL, Ext.ux.suncode.Constants.SUBFLOW ]
    } );

    config = Ext.apply( {
        ref: 'activitiesSequencePanel',
        height: 500,
        store: store,
        columnLines: true,
        autoScroll: true,
        frame: false,
        enableDragDrop: true,
        ddGroup: 'dd_sequence',
        ddScope: this,
        colModel: new Ext.grid.ColumnModel( {
            defaults: {
                sortable: false,
                menuDisabled: true
            },
            columns: [ new Ext.grid.RowNumberer(), {
                id: 'activityDefId',
                header: getTranslation( 'Nazwa zadania' ),
                dataIndex: 'activityDefId',
                align: 'left',
                renderer: Ext.util.Format.ComboBoxRenderer( activitiesChooser )
            }, {
                id: 'activityDefIdPreview',
                header: getTranslation( 'Identyfikator zadania' ),
                dataIndex: 'activityDefIdPreview',
                align: 'left',
                renderer: function(value, metaData, record, rowIndex, colIndex, store) {
                    return record.get( 'activityDefId' );
                 }
            } ]
        } ),
        viewConfig: new Ext.ux.suncode.StandardGridView( {
            emptyText: getTranslation( 'Brak zadań' )
        } ),
        sm: new Ext.grid.RowSelectionModel( {
            singleSelect: true,
            listeners: {
                beforerowselect: function( sm, i, ke, row ) {
                	var activityDefId = row.get( 'activityDefId' );
                	var activityNode = processNode.findChild( 'activityDefId', activityDefId );
                	var activityName = activityNode.attributes.activityName;
                		
                    sm.grid.ddText = '<b style="font-size: 12px;">' + activityName + '</b>';
                }
            }
        } ),
        tbar: new Ext.Toolbar( {
            items: [ '->', {
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'up' ),
                tooltip: getTranslation( 'Przesuń w górę' ),
                handler: this.moveUp,
                scope: this
            }, {
            	cls: 'x-btn-icon',
                icon: getPluginImgPath( 'down' ),
                tooltip: getTranslation( 'Przesuń w dół' ),
                handler: this.moveDown,
                scope: this
            } ]
        } ),
        listeners: {
            scope: this,
            render: function( grid ) {
                new Ext.dd.DropTarget( grid.getEl(), {
                    ddGroup: 'dd_sequence',
                    copy: false,
                    grid: grid,
                    notifyOver: notifyOverGrid,
                    notifyDrop: function( dd, e, data ) {
                        notifyDropGrid( dd, e, data, function( sindex, dindex ) {
                          dd.grid.getView().refresh();
                        } );
                    }
                } );
            }
        }
    }, config );

    Ext.ux.suncode.ActivitiesSequencePanel.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.ActivitiesSequencePanel, Ext.grid.GridPanel, {
    initComponent: function() {
        Ext.ux.suncode.ActivitiesSequencePanel.superclass.initComponent.call( this );
        
        this.on( 'afterrender', this.onAfterRender, this );
    },
    onAfterRender: function() {
    	this.setHeight( this.ownerCt.getHeight() - 60 );
    },
    moveUp: function() {
    	var activity = this.getSelectedActivity();
        if ( !activity ) {
            return;
        }
        
        var store = this.getStore();
        var index = store.indexOf( activity );
        
        if ( index > 0 ) {
        	store.removeAt( index );
        	store.insert( index - 1, [ activity ] );
        	this.getSelectionModel().selectRow( index - 1 );
        	this.getView().refresh();
        }
    },
    moveDown: function() {
    	var activity = this.getSelectedActivity();
        if ( !activity ) {
            return;
        }
        
        var store = this.getStore();
        var index = store.indexOf( activity );
        
        if ( index < store.getCount() - 1 ) {
        	store.removeAt( index );
        	store.insert( index + 1, [ activity ] );
        	this.getSelectionModel().selectRow( index + 1 );
        	this.getView().refresh();
        }
    },
    getSelectedActivity: function() {
        var activity = this.getSelectionModel().getSelected();
        if ( !activity ) {
            showWarn( getTranslation( 'Wybierz zadanie.' ) );
            return null;
        }
        return activity;
    },
    readSequence: function() {
    	var sequence = new Array();
        var store = this.getStore();

        store.each( function( rec ) {
        	sequence.push( {
                activityDefId: rec.get( 'activityDefId' )
            } );
        } );

        return sequence;
    }
} );

Ext.ux.suncode.DatabaseTableSpecificationsPanel = function( config ) {
    var processNode = config.processNode;
    var specification = processNode.attributes.specification;

    var store = new Ext.data.Store( {
        data: specification.databaseTableSpecifications,
        reader: new Ext.data.JsonReader( {
            fields: Ext.data.Record.create( [ {
                name: 'name',
                type: 'string'
            }, {
                name: 'databaseType',
                type: 'string'
            }, {
                name: 'location',
                type: 'string'
            } ] )
        } )
    } );

    config = Ext.apply( {
        title: getTranslation( 'Tabele baz danych' ),
        height: config.panelHeight,
        store: store,
        enableColumnResize: true,
        columnLines: true,
        autoScroll: true,
        border: false,
        layout: 'fit',
        colModel: new Ext.grid.ColumnModel( {
            defaults: {
                sortable: true,
                menuDisabled: false
            },
            columns: [ {
                id: 'name',
                header: getTranslation( 'Nazwa' ),
                dataIndex: 'name',
                align: 'left'
            }, {
                id: 'databaseType',
                header: getTranslation( 'Typ bazy danych' ),
                dataIndex: 'databaseType',
                align: 'left'
            }, {
                id: 'location',
                header: getTranslation( 'Lokalizacja' ),
                dataIndex: 'location',
                align: 'left'
            } ]
        } ),
        viewConfig: new Ext.ux.suncode.StandardGridView( {
            emptyText: getTranslation( 'Brak tabel' )
        } ),
        sm: new Ext.grid.RowSelectionModel( {
            singleSelect: true
        } ),
        tbar: new Ext.Toolbar( {
            items: [ '->', {
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'add' ),
                tooltip: getTranslation( 'Dodaj tabelę' ),
                handler: this.addDatabaseTable,
                scope: this
            }, {
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'edit' ),
                tooltip: getTranslation( 'Edytuj tabelę' ),
                handler: this.editDatabaseTable,
                scope: this
            }, {
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'delete' ),
                tooltip: getTranslation( 'Usuń tabelę' ),
                handler: this.removeDatabaseTable,
                scope: this
            } ]
        } ),
        listeners: {
            scope: this,
            rowdblclick: function( grid, rowIndex, e ) {
                this.editDatabaseTable();
            }
        }
    }, config );

    Ext.ux.suncode.DatabaseTableSpecificationsPanel.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.DatabaseTableSpecificationsPanel, Ext.grid.GridPanel, {
    initComponent: function() {
        Ext.ux.suncode.DatabaseTableSpecificationsPanel.superclass.initComponent.call( this );
    },
    addDatabaseTable: function() {
        var win = new Ext.ux.suncode.DatabaseTableSpecificationWindow( {
            processNode: this.initialConfig.processNode,
            saveTo: this,
            varRecord: this.getStore().recordType
        } );
        win.show();
    },
    editDatabaseTable: function() {
        var databaseTable = this.getSelectedDatabaseTable();
        if ( !databaseTable ) {
            return;
        }

        var processNode = this.initialConfig.processNode;
        var name = databaseTable.get( 'name' );
        var win = new Ext.ux.suncode.DatabaseTableSpecificationWindow( {
            databaseTable: Ext.ux.suncode.DocumentationService.getDatabaseTable( processNode, name ),
            processNode: this.initialConfig.processNode,
            saveTo: this,
            varRecord: databaseTable
        } );
        win.show();
    },
    removeDatabaseTable: function() {
        var databaseTable = this.getSelectedDatabaseTable();
        if ( !databaseTable ) {
            return;
        }

        var processNode = this.initialConfig.processNode;
        var name = databaseTable.get( 'name' );
        Ext.ux.suncode.DocumentationService.deleteDatabaseTable( processNode, name );
        removeRowAndMarkNext( this, databaseTable );
    },
    getSelectedDatabaseTable: function() {
        var databaseTable = this.getSelectionModel().getSelected();
        if ( !databaseTable ) {
            showWarn( getTranslation( 'Wybierz tabelę.' ) );
            return null;
        }
        return databaseTable;
    }
} );

Ext.ux.suncode.IntegrationSpecificationsPanel = function( config ) {
    var processNode = config.processNode;
    var specification = processNode.attributes.specification;

    var store = new Ext.data.Store( {
        data: specification.integrationSpecifications,
        reader: new Ext.data.JsonReader( {
            fields: Ext.data.Record.create( [ {
                name: 'name',
                type: 'string'
            }, {
                name: 'systemName',
                type: 'string'
            }, {
                name: 'integrationMethod',
                type: 'string'
            } ] )
        } )
    } );

    config = Ext.apply( {
        title: getTranslation( 'Integracje' ),
        height: config.panelHeight,
        store: store,
        enableColumnResize: true,
        columnLines: true,
        autoScroll: true,
        border: false,
        layout: 'fit',
        colModel: new Ext.grid.ColumnModel( {
            defaults: {
                sortable: true,
                menuDisabled: false
            },
            columns: [ {
                id: 'name',
                header: getTranslation( 'Nazwa' ),
                dataIndex: 'name',
                align: 'left'
            }, {
                id: 'systemName',
                header: getTranslation( 'Nazwa systemu' ),
                dataIndex: 'systemName',
                align: 'left'
            }, {
                id: 'integrationMethod',
                header: getTranslation( 'Metoda integracji' ),
                dataIndex: 'integrationMethod',
                align: 'left'
            } ]
        } ),
        viewConfig: new Ext.ux.suncode.StandardGridView( {
            emptyText: getTranslation( 'Brak integracji' )
        } ),
        sm: new Ext.grid.RowSelectionModel( {
            singleSelect: true
        } ),
        tbar: new Ext.Toolbar( {
            items: [ '->', {
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'add' ),
                tooltip: getTranslation( 'Dodaj integrację' ),
                handler: this.addIntegration,
                scope: this
            }, {
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'edit' ),
                tooltip: getTranslation( 'Edytuj integrację' ),
                handler: this.editIntegration,
                scope: this
            }, {
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'delete' ),
                tooltip: getTranslation( 'Usuń integrację' ),
                handler: this.removeIntegration,
                scope: this
            } ]
        } ),
        listeners: {
            scope: this,
            rowdblclick: function( grid, rowIndex, e ) {
                this.editIntegration();
            }
        }
    }, config );

    Ext.ux.suncode.IntegrationSpecificationsPanel.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.IntegrationSpecificationsPanel, Ext.grid.GridPanel, {
    initComponent: function() {
        Ext.ux.suncode.IntegrationSpecificationsPanel.superclass.initComponent.call( this );
    },
    addIntegration: function() {
        var win = new Ext.ux.suncode.IntegrationSpecificationWindow( {
            processNode: this.initialConfig.processNode,
            saveTo: this,
            varRecord: this.getStore().recordType
        } );
        win.show();
    },
    editIntegration: function() {
        var integration = this.getSelectedIntegration();
        if ( !integration ) {
            return;
        }

        var processNode = this.initialConfig.processNode;
        var name = integration.get( 'name' );
        var win = new Ext.ux.suncode.IntegrationSpecificationWindow( {
            integration: Ext.ux.suncode.DocumentationService.getIntegration( processNode, name ),
            processNode: this.initialConfig.processNode,
            saveTo: this,
            varRecord: integration
        } );
        win.show();
    },
    removeIntegration: function() {
        var integration = this.getSelectedIntegration();
        if ( !integration ) {
            return;
        }

        var processNode = this.initialConfig.processNode;
        var name = integration.get( 'name' );
        Ext.ux.suncode.DocumentationService.deleteIntegration( processNode, name );
        removeRowAndMarkNext( this, integration );
    },
    getSelectedIntegration: function() {
        var integration = this.getSelectionModel().getSelected();
        if ( !integration ) {
            showWarn( getTranslation( 'Wybierz integrację.' ) );
            return null;
        }
        return integration;
    }
} );

Ext.ux.suncode.ProgrammingTaskSpecificationsPanel = function( config ) {
    var processNode = config.processNode;
    var specification = processNode.attributes.specification;

    var store = new Ext.data.Store( {
        data: specification.programmingTaskSpecifications,
        reader: new Ext.data.JsonReader( {
            fields: Ext.data.Record.create( [ {
                name: 'name',
                type: 'string'
            }, {
                name: 'type',
                type: 'string'
            }, {
                name: 'executionLocation',
                type: 'string'
            } ] )
        } )
    } );

    var typesChooser = new Ext.ux.suncode.ProgrammingTaskTypesChooser( {} );
    var activitiesChooser = new Ext.ux.suncode.ActivitiesChooser( {
        processNode: processNode,
        acceptedTypes: [ Ext.ux.suncode.Constants.ACTIVITY, Ext.ux.suncode.Constants.TOOL ]
    } );

    config = Ext.apply( {
        title: getTranslation( 'Zadania programistyczne' ),
        height: config.panelHeight,
        store: store,
        enableColumnResize: true,
        columnLines: true,
        autoScroll: true,
        border: false,
        layout: 'fit',
        colModel: new Ext.grid.ColumnModel( {
            defaults: {
                sortable: true,
                menuDisabled: false
            },
            columns: [ {
                id: 'name',
                header: getTranslation( 'Nazwa' ),
                dataIndex: 'name',
                align: 'left'
            }, {
                id: 'type',
                header: getTranslation( 'Typ zadania' ),
                dataIndex: 'type',
                align: 'left',
                renderer: Ext.util.Format.ComboBoxRenderer( typesChooser )
            }, {
                id: 'executionLocation',
                header: getTranslation( 'Miejsce wykonania' ),
                dataIndex: 'executionLocation',
                align: 'left',
                renderer: Ext.util.Format.ComboBoxRenderer( activitiesChooser )
            } ]
        } ),
        viewConfig: new Ext.ux.suncode.StandardGridView( {
            emptyText: getTranslation( 'Brak zadań programistycznych' )
        } ),
        sm: new Ext.grid.RowSelectionModel( {
            singleSelect: true
        } ),
        tbar: new Ext.Toolbar( {
            items: [ '->', {
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'add' ),
                tooltip: getTranslation( 'Dodaj zadanie programistyczne' ),
                handler: this.addProgrammingTask,
                scope: this
            }, {
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'edit' ),
                tooltip: getTranslation( 'Edytuj zadanie programistyczne' ),
                handler: this.editProgrammingTask,
                scope: this
            }, {
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'delete' ),
                tooltip: getTranslation( 'Usuń zadanie programistyczne' ),
                handler: this.removeProgrammingTask,
                scope: this
            } ]
        } ),
        listeners: {
            scope: this,
            rowdblclick: function( grid, rowIndex, e ) {
                this.editProgrammingTask();
            }
        }
    }, config );

    Ext.ux.suncode.ProgrammingTaskSpecificationsPanel.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.ProgrammingTaskSpecificationsPanel, Ext.grid.GridPanel, {
    initComponent: function() {
        Ext.ux.suncode.ProgrammingTaskSpecificationsPanel.superclass.initComponent.call( this );
    },
    addProgrammingTask: function() {
        var win = new Ext.ux.suncode.ProgrammingTaskSpecificationWindow( {
            processNode: this.initialConfig.processNode,
            saveTo: this,
            varRecord: this.getStore().recordType
        } );
        win.show();
    },
    editProgrammingTask: function() {
        var programmingTask = this.getSelectedProgrammingTask();
        if ( !programmingTask ) {
            return;
        }

        var processNode = this.initialConfig.processNode;
        var name = programmingTask.get( 'name' );
        var win = new Ext.ux.suncode.ProgrammingTaskSpecificationWindow( {
            programmingTask: Ext.ux.suncode.DocumentationService.getProgrammingTask( processNode, name ),
            processNode: this.initialConfig.processNode,
            saveTo: this,
            varRecord: programmingTask
        } );
        win.show();
    },
    removeProgrammingTask: function() {
        var programmingTask = this.getSelectedProgrammingTask();
        if ( !programmingTask ) {
            return;
        }

        var processNode = this.initialConfig.processNode;
        var name = programmingTask.get( 'name' );
        Ext.ux.suncode.DocumentationService.deleteProgrammingTask( processNode, name );
        removeRowAndMarkNext( this, programmingTask );
    },
    getSelectedProgrammingTask: function() {
        var programmingTask = this.getSelectionModel().getSelected();
        if ( !programmingTask ) {
            showWarn( getTranslation( 'Wybierz zadanie programistyczne.' ) );
            return null;
        }
        return programmingTask;
    }
} );

Ext.ux.suncode.ScheduledTaskSpecificationsPanel = function( config ) {
    var processNode = config.processNode;
    var specification = processNode.attributes.specification;

    var store = new Ext.data.Store( {
        data: specification.scheduledTaskSpecifications,
        reader: new Ext.data.JsonReader( {
            fields: Ext.data.Record.create( [ {
                name: 'name',
                type: 'string'
            }, {
                name: 'className',
                type: 'string'
            }, {
                name: 'methodName',
                type: 'string'
            } ] )
        } )
    } );

    config = Ext.apply( {
        title: getTranslation( 'Zadania zaplanowane' ),
        height: config.panelHeight,
        store: store,
        enableColumnResize: true,
        columnLines: true,
        autoScroll: true,
        border: false,
        layout: 'fit',
        colModel: new Ext.grid.ColumnModel( {
            defaults: {
                sortable: true,
                menuDisabled: false
            },
            columns: [ {
                id: 'name',
                header: getTranslation( 'Nazwa' ),
                dataIndex: 'name',
                align: 'left'
            }, {
                id: 'className',
                header: getTranslation( 'Nazwa klasy' ),
                dataIndex: 'className',
                align: 'left'
            }, {
                id: 'methodName',
                header: getTranslation( 'Nazwa metody' ),
                dataIndex: 'methodName',
                align: 'left'
            } ]
        } ),
        viewConfig: new Ext.ux.suncode.StandardGridView( {
            emptyText: getTranslation( 'Brak zadań zaplanowanych' )
        } ),
        sm: new Ext.grid.RowSelectionModel( {
            singleSelect: true
        } ),
        tbar: new Ext.Toolbar( {
            items: [ '->', {
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'add' ),
                tooltip: getTranslation( 'Dodaj zadanie zaplanowane' ),
                handler: this.addScheduledTask,
                scope: this
            }, {
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'edit' ),
                tooltip: getTranslation( 'Edytuj zadanie zaplanowane' ),
                handler: this.editScheduledTask,
                scope: this
            }, {
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'delete' ),
                tooltip: getTranslation( 'Usuń zadanie zaplanowane' ),
                handler: this.removeScheduledTask,
                scope: this
            } ]
        } ),
        listeners: {
            scope: this,
            rowdblclick: function( grid, rowIndex, e ) {
                this.editScheduledTask();
            }
        }
    }, config );

    Ext.ux.suncode.ScheduledTaskSpecificationsPanel.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.ScheduledTaskSpecificationsPanel, Ext.grid.GridPanel, {
    initComponent: function() {
        Ext.ux.suncode.ScheduledTaskSpecificationsPanel.superclass.initComponent.call( this );
    },
    addScheduledTask: function() {
        var win = new Ext.ux.suncode.ScheduledTaskSpecificationWindow( {
            processNode: this.initialConfig.processNode,
            saveTo: this,
            varRecord: this.getStore().recordType
        } );
        win.show();
    },
    editScheduledTask: function() {
        var scheduledTask = this.getSelectedScheduledTask();
        if ( !scheduledTask ) {
            return;
        }

        var processNode = this.initialConfig.processNode;
        var name = scheduledTask.get( 'name' );
        var win = new Ext.ux.suncode.ScheduledTaskSpecificationWindow( {
            scheduledTask: Ext.ux.suncode.DocumentationService.getScheduledTask( processNode, name ),
            processNode: this.initialConfig.processNode,
            saveTo: this,
            varRecord: scheduledTask
        } );
        win.show();
    },
    removeScheduledTask: function() {
        var scheduledTask = this.getSelectedScheduledTask();
        if ( !scheduledTask ) {
            return;
        }

        var processNode = this.initialConfig.processNode;
        var name = scheduledTask.get( 'name' );
        Ext.ux.suncode.DocumentationService.deleteScheduledTask( processNode, name );
        removeRowAndMarkNext( this, scheduledTask );
    },
    getSelectedScheduledTask: function() {
        var scheduledTask = this.getSelectionModel().getSelected();
        if ( !scheduledTask ) {
            showWarn( getTranslation( 'Wybierz zadanie zaplanowane.' ) );
            return null;
        }
        return scheduledTask;
    }
} );

Ext.ux.suncode.DocumentClassSpecificationsPanel = function( config ) {
  var processNode = config.processNode;
  var specification = processNode.attributes.specification;

  var store = new Ext.data.Store( {
    data: specification.documentClassSpecifications,
    reader: new Ext.data.JsonReader( {
      fields: Ext.data.Record.create( [ {
        name: 'name',
        type: 'string'
      }, {
        name: 'description',
        type: 'string'
      } ] )
    } )
  } );

  config = Ext.apply( {
    title: getTranslation( 'Klasy dokumentów' ),
    height: config.panelHeight,
    store: store,
    enableColumnResize: true,
    columnLines: true,
    autoScroll: true,
    border: false,
    layout: 'fit',
    colModel: new Ext.grid.ColumnModel( {
      defaults: {
        sortable: true,
        menuDisabled: false
      },
      columns: [ {
        id: 'name',
        header: getTranslation( 'Nazwa' ),
        dataIndex: 'name',
        align: 'left'
      }, {
        id: 'description',
        header: getTranslation( 'Opis' ),
        dataIndex: 'description',
        align: 'left',
        sortable: false,
        renderer: function( value, metaData, record, rowIndex, colIndex, store ) {
          if ( !Ext.isEmpty( value ) ) {
            metaData.attr = 'ext:qtip="' + value + '"';
            return wrapColumnValue( value.ellipse( 150 ) );
          } else {
            return '';
          }
        }
      } ]
    } ),
    viewConfig: new Ext.ux.suncode.StandardGridView( {
      emptyText: getTranslation( 'Brak klas dokumentów' )
    } ),
    sm: new Ext.grid.RowSelectionModel( {
      singleSelect: true
    } ),
    tbar: new Ext.Toolbar( {
      items: [ '->', {
        cls: 'x-btn-icon',
        icon: getPluginImgPath( 'add' ),
        tooltip: getTranslation( 'Dodaj klasę dokumentów' ),
        handler: this.addDocumentClass,
        scope: this
      }, {
        cls: 'x-btn-icon',
        icon: getPluginImgPath( 'edit' ),
        tooltip: getTranslation( 'Edytuj klasę dokumentów' ),
        handler: this.editDocumentClass,
        scope: this
      }, {
        cls: 'x-btn-icon',
        icon: getPluginImgPath( 'delete' ),
        tooltip: getTranslation( 'Usuń klasę dokumentów' ),
        handler: this.removeDocumentClass,
        scope: this
      } ]
    } ),
    listeners: {
      scope: this,
      rowdblclick: function( grid, rowIndex, e ) {
        this.editDocumentClass();
      }
    }
  }, config );

  Ext.ux.suncode.DocumentClassSpecificationsPanel.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.DocumentClassSpecificationsPanel, Ext.grid.GridPanel, {
  initComponent: function() {
    Ext.ux.suncode.DocumentClassSpecificationsPanel.superclass.initComponent.call( this );
  },
  addDocumentClass: function() {
    var win = new Ext.ux.suncode.DocumentClassSpecificationWindow( {
      processNode: this.initialConfig.processNode,
      saveTo: this,
      varRecord: this.getStore().recordType
    } );
    win.show();
  },
  editDocumentClass: function() {
    var documentClass = this.getSelectedDocumentClass();
    if ( !documentClass ) {
      return;
    }

    var processNode = this.initialConfig.processNode;
    var name = documentClass.get( 'name' );
    var win = new Ext.ux.suncode.DocumentClassSpecificationWindow( {
      documentClass: Ext.ux.suncode.DocumentationService.getDocumentClass( processNode, name ),
      processNode: this.initialConfig.processNode,
      saveTo: this,
      varRecord: documentClass
    } );
    win.show();
  },
  removeDocumentClass: function() {
    var documentClass = this.getSelectedDocumentClass();
    if ( !documentClass ) {
      return;
    }

    var processNode = this.initialConfig.processNode;
    var name = documentClass.get( 'name' );
    Ext.ux.suncode.DocumentationService.deleteDocumentClass( processNode, name );
    removeRowAndMarkNext( this, documentClass );
  },
  getSelectedDocumentClass: function() {
    var documentClass = this.getSelectionModel().getSelected();
    if ( !documentClass ) {
      showWarn( getTranslation( 'Wybierz klasę dokumentów.' ) );
      return null;
    }
    return documentClass;
  }
} );

Ext.ux.suncode.DocumentLinkSpecificationsPanel = function( config ) {
  var processNode = config.processNode;
  var specification = processNode.attributes.specification;

  var store = new Ext.data.Store( {
    data: specification.documentLinkSpecifications,
    reader: new Ext.data.JsonReader( {
      fields: Ext.data.Record.create( [ {
        name: 'name',
        type: 'string'
      }, {
        name: 'description',
        type: 'string'
      } ] )
    } )
  } );

  config = Ext.apply( {
    title: getTranslation( 'Zestawy dokumentów' ),
    height: config.panelHeight,
    store: store,
    enableColumnResize: true,
    columnLines: true,
    autoScroll: true,
    border: false,
    layout: 'fit',
    colModel: new Ext.grid.ColumnModel( {
      defaults: {
        sortable: true,
        menuDisabled: false
      },
      columns: [ {
        id: 'name',
        header: getTranslation( 'Nazwa' ),
        dataIndex: 'name',
        align: 'left'
      }, {
        id: 'description',
        header: getTranslation( 'Opis' ),
        dataIndex: 'description',
        align: 'left',
        sortable: false,
        renderer: function( value, metaData, record, rowIndex, colIndex, store ) {
          if ( !Ext.isEmpty( value ) ) {
            metaData.attr = 'ext:qtip="' + value + '"';
            return wrapColumnValue( value.ellipse( 150 ) );
          } else {
            return '';
          }
        }
      } ]
    } ),
    viewConfig: new Ext.ux.suncode.StandardGridView( {
      emptyText: getTranslation( 'Brak zestawów dokumentów' )
    } ),
    sm: new Ext.grid.RowSelectionModel( {
      singleSelect: true
    } ),
    tbar: new Ext.Toolbar( {
      items: [ '->', {
        cls: 'x-btn-icon',
        icon: getPluginImgPath( 'add' ),
        tooltip: getTranslation( 'Dodaj zestaw dokumentów' ),
        handler: this.addDocumentLink,
        scope: this
      }, {
        cls: 'x-btn-icon',
        icon: getPluginImgPath( 'edit' ),
        tooltip: getTranslation( 'Edytuj zestaw dokumentów' ),
        handler: this.editDocumentLink,
        scope: this
      }, {
        cls: 'x-btn-icon',
        icon: getPluginImgPath( 'delete' ),
        tooltip: getTranslation( 'Usuń zestaw dokumentów' ),
        handler: this.removeDocumentLink,
        scope: this
      } ]
    } ),
    listeners: {
      scope: this,
      rowdblclick: function( grid, rowIndex, e ) {
        this.editDocumentLink();
      }
    }
  }, config );

  Ext.ux.suncode.DocumentLinkSpecificationsPanel.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.DocumentLinkSpecificationsPanel, Ext.grid.GridPanel, {
  initComponent: function() {
    Ext.ux.suncode.DocumentLinkSpecificationsPanel.superclass.initComponent.call( this );
  },
  addDocumentLink: function() {
    var win = new Ext.ux.suncode.DocumentLinkSpecificationWindow( {
      processNode: this.initialConfig.processNode,
      saveTo: this,
      varRecord: this.getStore().recordType
    } );
    win.show();
  },
  editDocumentLink: function() {
    var documentLink = this.getSelectedDocumentLink();
    if ( !documentLink ) {
      return;
    }

    var processNode = this.initialConfig.processNode;
    var name = documentLink.get( 'name' );
    var win = new Ext.ux.suncode.DocumentLinkSpecificationWindow( {
      documentLink: Ext.ux.suncode.DocumentationService.getDocumentLink( processNode, name ),
      processNode: this.initialConfig.processNode,
      saveTo: this,
      varRecord: documentLink
    } );
    win.show();
  },
  removeDocumentLink: function() {
    var documentLink = this.getSelectedDocumentLink();
    if ( !documentLink ) {
      return;
    }

    var processNode = this.initialConfig.processNode;
    var name = documentLink.get( 'name' );
    Ext.ux.suncode.DocumentationService.deleteDocumentLink( processNode, name );
    removeRowAndMarkNext( this, documentLink );
  },
  getSelectedDocumentLink: function() {
    var documentLink = this.getSelectionModel().getSelected();
    if ( !documentLink ) {
      showWarn( getTranslation( 'Wybierz zestaw dokumentów.' ) );
      return null;
    }
    return documentLink;
  }
} );

Ext.ux.suncode.ProjectExclusionSpecificationsPanel = function( config ) {
  var processNode = config.processNode;
  var specification = processNode.attributes.specification;

  var store = new Ext.data.Store( {
    data: specification.projectExclusionSpecifications,
    reader: new Ext.data.JsonReader( {
      fields: Ext.data.Record.create( [ {
        name: 'name',
        type: 'string'
      }, {
        name: 'contents',
        type: 'string'
      } ] )
    } )
  } );

  config = Ext.apply( {
    title: getTranslation( 'Wyłączenia z projektu' ),
    height: config.panelHeight,
    store: store,
    enableColumnResize: true,
    columnLines: true,
    autoScroll: true,
    border: false,
    layout: 'fit',
    colModel: new Ext.grid.ColumnModel( {
      defaults: {
        sortable: true,
        menuDisabled: false
      },
      columns: [ {
        id: 'name',
        header: getTranslation( 'Nazwa' ),
        dataIndex: 'name',
        align: 'left'
      }, {
        id: 'contents',
        header: getTranslation( 'Treść' ),
        dataIndex: 'contents',
        align: 'left',
        sortable: false,
        renderer: function( value, metaData, record, rowIndex, colIndex, store ) {
          if ( !Ext.isEmpty( value ) ) {
            metaData.attr = 'ext:qtip="' + value + '"';
            return wrapColumnValue( value.ellipse( 150 ) );
          } else {
            return '';
          }
        }
      } ]
    } ),
    viewConfig: new Ext.ux.suncode.StandardGridView( {
      emptyText: getTranslation( 'Brak wyłączeń z projektu' )
    } ),
    sm: new Ext.grid.RowSelectionModel( {
      singleSelect: true
    } ),
    tbar: new Ext.Toolbar( {
      items: [ '->', {
        cls: 'x-btn-icon',
        icon: getPluginImgPath( 'add' ),
        tooltip: getTranslation( 'Dodaj wyłączenie z projektu' ),
        handler: this.addProjectExclusion,
        scope: this
      }, {
        cls: 'x-btn-icon',
        icon: getPluginImgPath( 'edit' ),
        tooltip: getTranslation( 'Edytuj wyłączenie z projektu' ),
        handler: this.editProjectExclusion,
        scope: this
      }, {
        cls: 'x-btn-icon',
        icon: getPluginImgPath( 'delete' ),
        tooltip: getTranslation( 'Usuń wyłączenie z projektu' ),
        handler: this.removeProjectExclusion,
        scope: this
      } ]
    } ),
    listeners: {
      scope: this,
      rowdblclick: function( grid, rowIndex, e ) {
        this.editProjectExclusion();
      }
    }
  }, config );

  Ext.ux.suncode.ProjectExclusionSpecificationsPanel.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.ProjectExclusionSpecificationsPanel, Ext.grid.GridPanel, {
  initComponent: function() {
    Ext.ux.suncode.ProjectExclusionSpecificationsPanel.superclass.initComponent.call( this );
  },
  addProjectExclusion: function() {
    var win = new Ext.ux.suncode.ProjectExclusionSpecificationWindow( {
      processNode: this.initialConfig.processNode,
      saveTo: this,
      varRecord: this.getStore().recordType
    } );
    win.show();
  },
  editProjectExclusion: function() {
    var projectExclusion = this.getSelectedProjectExclusion();
    if ( !projectExclusion ) {
      return;
    }

    var processNode = this.initialConfig.processNode;
    var name = projectExclusion.get( 'name' );
    var win = new Ext.ux.suncode.ProjectExclusionSpecificationWindow( {
      projectExclusion: Ext.ux.suncode.DocumentationService.getProjectExclusion( processNode, name ),
      processNode: this.initialConfig.processNode,
      saveTo: this,
      varRecord: projectExclusion
    } );
    win.show();
  },
  removeProjectExclusion: function() {
    var projectExclusion = this.getSelectedProjectExclusion();
    if ( !projectExclusion ) {
      return;
    }

    var processNode = this.initialConfig.processNode;
    var name = projectExclusion.get( 'name' );
    Ext.ux.suncode.DocumentationService.deleteProjectExclusion( processNode, name );
    removeRowAndMarkNext( this, projectExclusion );
  },
  getSelectedProjectExclusion: function() {
    var projectExclusion = this.getSelectionModel().getSelected();
    if ( !projectExclusion ) {
      showWarn( getTranslation( 'Wybierz wyłączenie z projektu.' ) );
      return null;
    }
    return projectExclusion;
  }
} );

Ext.ux.suncode.AttachmentSpecificationsPanel = function( config ) {
  var processNode = config.processNode;
  var specification = processNode.attributes.specification;

  var store = new Ext.data.Store( {
    data: specification.attachmentSpecifications,
    reader: new Ext.data.JsonReader( {
      fields: Ext.data.Record.create( [ {
        name: 'id',
        type: 'string'
      }, {
        name: 'fileName',
        type: 'string'
      }, {
        name: 'name',
        type: 'string'
      }, {
        name: 'description',
        type: 'string'
      } ] )
    } )
  } );

  config = Ext.apply( {
    title: getTranslation( 'Załączniki' ),
    height: config.panelHeight,
    store: store,
    enableColumnResize: true,
    columnLines: true,
    autoScroll: true,
    border: false,
    layout: 'fit',
    colModel: new Ext.grid.ColumnModel( {
      defaults: {
        sortable: true,
        menuDisabled: false
      },
      columns: [ {
        id: 'id',
        dataIndex: 'id',
        hidden: true,
        hideable: false
      }, {
        id: 'fileName',
        dataIndex: 'fileName',
        hidden: true,
        hideable: false
      }, {
        id: 'name',
        header: getTranslation( 'Nazwa' ),
        dataIndex: 'name',
        align: 'left'
      }, {
        id: 'description',
        header: getTranslation( 'Opis' ),
        dataIndex: 'description',
        align: 'left',
        sortable: false,
        renderer: function( value, metaData, record, rowIndex, colIndex, store ) {
          if ( !Ext.isEmpty( value ) ) {
            metaData.attr = 'ext:qtip="' + value + '"';
            return wrapColumnValue( value.ellipse( 150 ) );
          } else {
            return '';
          }
        }
      } ]
    } ),
    viewConfig: new Ext.ux.suncode.StandardGridView( {
      emptyText: getTranslation( 'Brak załączników' )
    } ),
    sm: new Ext.grid.RowSelectionModel( {
      singleSelect: true
    } ),
    tbar: new Ext.Toolbar( {
      items: [ '->', {
        cls: 'x-btn-icon',
        icon: getPluginImgPath( 'download' ),
        tooltip: getTranslation( 'Pobierz załącznik' ),
        handler: this.downloadAttachment,
        scope: this
      }, {
        cls: 'x-btn-icon',
        icon: getPluginImgPath( 'add' ),
        tooltip: getTranslation( 'Dodaj załącznik' ),
        handler: this.addAttachment,
        scope: this
      }, {
        cls: 'x-btn-icon',
        icon: getPluginImgPath( 'edit' ),
        tooltip: getTranslation( 'Edytuj załącznik' ),
        handler: this.editAttachment,
        scope: this
      }, {
        cls: 'x-btn-icon',
        icon: getPluginImgPath( 'delete' ),
        tooltip: getTranslation( 'Usuń załącznik' ),
        handler: this.removeAttachment,
        scope: this
      } ]
    } ),
    listeners: {
      scope: this,
      rowdblclick: function( grid, rowIndex, e ) {
        this.editAttachment();
      }
    }
  }, config );

  Ext.ux.suncode.AttachmentSpecificationsPanel.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.AttachmentSpecificationsPanel, Ext.grid.GridPanel, {
  initComponent: function() {
    Ext.ux.suncode.AttachmentSpecificationsPanel.superclass.initComponent.call( this );
  },
  downloadAttachment: function() {
    var attachment = this.getSelectedAttachment();
    if ( !attachment ) {
      return;
    }

    var processNode = this.initialConfig.processNode;
    var attachmentDirectory = processNode.attributes.attachmentDirectory;
    var fileName = attachment.get( 'fileName' );

    downloadAttachment( attachmentDirectory, fileName );
  },
  addAttachment: function() {
    var win = new Ext.ux.suncode.AttachmentSpecificationWindow( {
      processNode: this.initialConfig.processNode,
      saveTo: this,
      varRecord: this.getStore().recordType
    } );
    win.show();
  },
  editAttachment: function() {
    var attachment = this.getSelectedAttachment();
    if ( !attachment ) {
      return;
    }

    var processNode = this.initialConfig.processNode;
    var id = attachment.get( 'id' );
    var win = new Ext.ux.suncode.AttachmentSpecificationWindow( {
      attachment: Ext.ux.suncode.DocumentationService.getAttachment( processNode, id ),
      processNode: this.initialConfig.processNode,
      saveTo: this,
      varRecord: attachment
    } );
    win.show();
  },
  removeAttachment: function() {
    var attachment = this.getSelectedAttachment();
    if ( !attachment ) {
      return;
    }

    var processNode = this.initialConfig.processNode;
    var attachmentDirectory = processNode.attributes.attachmentDirectory;
    var fileName = attachment.get( 'fileName' );

    Ext.Ajax.request( {
      url: 'api/documentation/deleteAttachment',
      method: 'GET',
      params: {
        attachmentDirectory: attachmentDirectory,
        fileName: fileName
      },
      scope: this,
      success: function( response, opts ) {
        if ( parseBoolean( response.responseText ) ) {
          var id = attachment.get( 'id' );
          Ext.ux.suncode.DocumentationService.deleteAttachment( processNode, id );
          removeRowAndMarkNext( this, attachment );
        } else {
          showWarn( getTranslation( 'Wystąpił błąd.' ) );
        }
      },
      failure: function( response, opts ) {
        showWarn( getTranslation( 'Wystąpił błąd.' ) );
      }
    } );
  },
  getSelectedAttachment: function() {
    var attachment = this.getSelectionModel().getSelected();
    if ( !attachment ) {
      showWarn( getTranslation( 'Wybierz załącznik.' ) );
      return null;
    }
    return attachment;
  }
} );