Ext.ux.suncode.CustomField = function( config ) {
    var preview = this.buildPreview( config.arrayInitializer, config.readOnly );
    var editor = this.buildEditor( config );
    var items = new Array();
    items.push( preview );
    items.push( editor );

    if ( this.shouldBuildColumnCheckbox( config.inArray ) ) {
    	var text = this.buildColumnCheckboxText( config.columnCheckboxEnabled, config.customValue, config.processNode );
    	var field = this.buildColumnCheckboxField( config.columnCheckboxEnabled, config.customValue, config.processNode );
    	config = Ext.apply( {
    		columnCheckboxItems: [ text, field ]
      }, config );
    	
    	items.push( text );
    	items.push( field );
    }
    if ( this.shouldBuildColorPickerMenuButtons( config.binded, config.readOnly, config.isColorPicker, config.arrayInitializer ) ) {
        var colorPickerButton = this.buildColorPickerMenuButton();
        var resetColorButton = this.buildResetColorMenuButton();
        config = Ext.apply( {
        	colorPickerMenuButton: colorPickerButton,
          resetColorMenuButton: resetColorButton
        }, config );

        items.push( colorPickerButton );
        items.push( resetColorButton );
    }
    if ( this.shouldBuildVariablesMenuButton( config.binded, config.readOnly, config.type, config.isColorPicker, config.arrayInitializer ) ) {
        var button = this.buildVariablesMenuButton();
        config = Ext.apply( {
            variablesMenuButton: button
        }, config );

        items.push( button );
    }
    if ( this.shouldBuildFunctionsMenuButton( config.binded, config.readOnly, config.isColorPicker, config.arrayInitializer ) ) {
        var button = this.buildFunctionsMenuButton();
        config = Ext.apply( {
            functionsMenuButton: button
        }, config );

        items.push( button );
    }
    if ( this.shouldBuildSwitchValuesMenuButtons( config.inArray, config.arrayInitializer ) ) {
      var upButton = this.buildSwitchValueUpMenuButton( config.hideSwitchValueUpButton );
      var downButton = this.buildSwitchValueDownMenuButton( config.hideSwitchValueDownButton );
      config = Ext.apply( {
        switchValueUpMenuButton: upButton,
        switchValueDownMenuButton: downButton
      }, config );

      items.push( upButton );
      items.push( downButton );
    }
    if ( this.shouldBuildAddFieldMenuButton( config.inArray, config.readOnly ) ) {
        var button = this.buildAddFieldMenuButton( config.hideAddButton );
        config = Ext.apply( {
            addFieldMenuButton: button
        }, config );

        items.push( button );
    }
    if ( this.shouldBuildRemoveFieldMenuButton( config.inArray, config.readOnly, config.arrayInitializer ) ) {
        var button = this.buildRemoveFieldMenuButton();
        config = Ext.apply( {
            removeFieldMenuButton: button
        }, config );

        items.push( button );
    }

    config = Ext.apply( {
        fieldLabel: this.buildFieldLabel( config, config.notEmpty ),
        preview: preview,
        editor: editor,
        menuWindow: null,
        functionsMenu: false,
        variablesMenu: false,
        onEnterTaskBlocked: false,
        isDisabled: false,
        items: items
    }, config );

    Ext.ux.suncode.CustomField.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.CustomField, Ext.form.CompositeField, {
    initComponent: function() {
        Ext.ux.suncode.CustomField.superclass.initComponent.call( this );

        this.on( 'afterrender', this.onAfterRender, this );
        this.on( 'destroy', this.resetMenuWindow, this );
    },
    FUNCTION_TYPE: 'function',
    VARIABLE_TYPE: 'variable',
    INTEGER_TYPE: 'integer',
    FLOAT_TYPE: 'float',
    DATE_TYPE: 'date',
    DATETIME_TYPE: 'datetime',
    BOOLEAN_TYPE: 'boolean',
    STRING_TYPE: 'string',
    DEFAULT_TYPE: 'string',
    FLOAT_TYPE_DECIMAL_SEPARATOR: ',',
    FLOAT_TYPE_THOUSAND_SEPARATOR: ' ',
    FLOAT_TYPE_PRECISION: 10,
    FUNCTION_PREFIX: '#',
    VARIABLE_PREFIX: '$',
    OPTIONS_MENU_WINDOW_MIN_WIDTH: 700,
    HINT_INFO_TYPE: 'INFO',
    HINT_SUCCESS_TYPE: 'SUCCESS',
    HINT_ERROR_TYPE: 'ERROR',
    DEFAULT_PREVIEW_HEIGHT: 42,
    switchToPreviewModeTask: null,
    onAfterRender: function() {
    	this.switchToPreviewMode();
    	this.executeOnAfterRenderFunction();

      if ( this.initialConfig.disabled ) {
        this.disableField();
      }
    },
    executeOnAfterRenderFunction: function() {
      var onAfterRenderFunction = this.initialConfig.onAfterRenderFunction;

      if ( Ext.isFunction( onAfterRenderFunction ) ) {
        var fieldOptions = this.buildFieldFunctionOptions();
        onAfterRenderFunction.apply( window, [ fieldOptions ] );
      }
    },
    buildPreview: function( arrayInitializer, readOnly ) {
        return new Ext.BoxComponent( {
            flex: 1,
            hidden: true,
            autoEl: {
                tag: 'div',
                'class': ( arrayInitializer || readOnly ) ? 'x-form-text x-Module-disabled' : 'x-form-text'
            },
            listeners: {
            	scope: this,
            	afterrender: this.onPreviewAfterRender
            }
        } );
    },
    onPreviewAfterRender: function( preview ) {
    	if ( !this.initialConfig.arrayInitializer ) {
    		var previewEl = preview.getEl();
        	previewEl.on( 'contextmenu', this.onPreviewContextMenu, this );
    	}
    },
    addPreviewContextMenuListener: function() {
    	var previewEl = this.preview.getEl();
    	previewEl.on( 'contextmenu', this.onPreviewContextMenu, this );
    },
    removePreviewContextMenuListener: function() {
    	var previewEl = this.preview.getEl();
    	previewEl.un( 'contextmenu', this.onPreviewContextMenu, this );
    },
    onContextMenu: function ( e ) {
      Ext.ux.suncode.Clipboard.getIntegrationComponentParameterValue( function( value ) {
        var menu = this.buildCopyPasteContextMenu( value );
        showMenu( menu, e );
      }, this );
    },
    onPreviewContextMenu: function( e, t, o ) {
      this.onContextMenu( e );
    },
    buildCopyPasteContextMenu: function( clipboardParameterValue ) {
    	return new Ext.menu.Menu( {
    		items: this.buildCopyPasteContextMenuItems( clipboardParameterValue )
    	} );
    },
    buildCopyPasteContextMenuItems: function( clipboardParameterValue ) {
      var currentValue = this.customValue;

      return [ {
        xtype: 'menuitem',
        cls: 'x-btn-text-icon',
        icon: getPluginImgPath( 'copy' ),
        text: getTranslation( 'Kopiuj wartość' ),
        disabled: !this.isNonEmptyValue( currentValue ),
        listeners: {
          scope: this,
          click: this.onCopyValue
        }
      }, {
        xtype: 'menuitem',
        cls: 'x-btn-text-icon',
        icon: getPluginImgPath( 'paste' ),
        text: getTranslation( 'Wklej wartość' ),
        clipboardParameterValue: clipboardParameterValue,
        disabled: !this.isNonEmptyValue( clipboardParameterValue ),
        listeners: {
          scope: this,
          click: this.onPasteValue
        }
      }, {
        xtype: 'menuitem',
        cls: 'x-btn-text-icon',
        icon: getPluginImgPath( 'paste' ),
        text: getTranslation( 'Wklej specjalnie' ),
        listeners: {
          scope: this,
          click: this.onPasteSpecial
        }
      } ];
    },
    onCopyValue: function( menuItem, e ) {
    	Ext.ux.suncode.Clipboard.setIntegrationComponentParameterValue( this.customValue );
    },
    onPasteValue: function( menuItem, e ) {
      var value = menuItem.clipboardParameterValue;

      this.validateAndPasteValue( value );
    },
    validateAndPasteValue: function( value ) {
      if ( this.validateValueTypeCompatibility( value ) && this.validateMissingVariables( value ) ) {
        this.executePasteValue( value );
      }
    },
    validateValueTypeCompatibility: function( value ) {
      var editor = this.editor;
      var errorMessage = '';

      if ( this.isNonEmptyValue( value ) ) {
        if ( value.type === this.FUNCTION_TYPE
            && editor.getType() !== this.FUNCTION_TYPE
            && !Ext.isEmpty( value.value ) ) {
          var mainPanel = Ext.getCmp( 'main_panel' );
          var systemFunction = mainPanel.getSystemFunction( value.value.name, value.value.parameterTypes );

          if ( !Ext.isEmpty( systemFunction ) ) {
            var editorType = editor.getType();
            var inArray = editor.getInArray();

            if ( !( systemFunction.returnType === editorType || ( systemFunction.returnType === editorType + '[]' && inArray ) ) ) {
              errorMessage = this.buildTypesIncompatibilityErrorMessage( systemFunction.returnType );
            } else if ( Ext.ux.suncode.IntegrationComponentService.doesValueBreakAccessibilityRule(
                value, this.initialConfig.systemFunctionsAccessibility ) ) {
              errorMessage = getTranslation( 'Niezgodność przeznaczenia funkcji.' );
            }
          } else {
            errorMessage = this.buildCopiedFunctionDoesNotExistErrorMessage();
          }
        } else if ( value.type === this.VARIABLE_TYPE
            && editor.getType() !== this.VARIABLE_TYPE
            && !Ext.isEmpty( value.value ) ) {
          var id = value.value;

          if ( id.startsWith( Ext.ux.suncode.IntegrationComponentService.CONTEXT_VARIABLE_ID_PREFIX ) ) {
            var contextVariable = this.getContextVariable( id );

            if ( !Ext.isEmpty( contextVariable ) ) {
              if ( contextVariable.type !== editor.getType() ) {
                errorMessage = this.buildTypesIncompatibilityErrorMessage( contextVariable.type );
              }
            } else {
              errorMessage = this.buildCopiedVariableDoesNotExistErrorMessage();
            }
          } else {
            var variable = this.getVariable( id );
            var typesMatrix = Ext.ux.suncode.IntegrationComponentService.VARIABLE_TYPES_MATRIX;

            if ( !Ext.isEmpty( variable ) ) {
              var variableType = typesMatrix[variable.type];

              if ( variableType !== editor.getType() ) {
                errorMessage = this.buildTypesIncompatibilityErrorMessage( variableType );
              }
            } else {
              errorMessage = this.buildCopiedVariableDoesNotExistErrorMessage();
            }
          }
        } else if ( value.type !== editor.getType() ) {
          errorMessage = this.buildTypesIncompatibilityErrorMessage( value.type );
        }
      }

      if ( Ext.isEmpty( errorMessage ) ) {
        return true;
      } else {
        showWarn( errorMessage );
        return false;
      }
    },
    buildTypesIncompatibilityErrorMessage: function( pastedType ) {
      var msg = getTranslation( 'Niezgodność typów.' );
      msg += '<br>';
      msg += getTranslation( 'Oczekiwany typ' );
      msg += getTranslation( ': <b>' );
      msg += Ext.ux.suncode.IntegrationComponentService.getParameterTypeTranslation( this.editor.getType() );
      msg += '</b><br>';
      msg += getTranslation( 'Wklejany typ' );
      msg += getTranslation( ': <b>' );
      msg += Ext.ux.suncode.IntegrationComponentService.getParameterTypeTranslation( pastedType );
      msg += '</b>';

      return msg;
    },
    buildCopiedFunctionDoesNotExistErrorMessage: function() {
      var msg = getTranslation( 'Kopiowana funkcja nie istnieje w systemie.' );
      msg += ' ';
      msg += getTranslation( 'Brak możliwości sprawdzenia zgodności typów.' );

      return msg;
    },
    buildCopiedVariableDoesNotExistErrorMessage: function() {
      var msg = getTranslation('Kopiowana zmienna nie istnieje w systemie.');
      msg += ' ';
      msg += getTranslation('Brak możliwości sprawdzenia zgodności typów.');

      return msg;
    },
    validateMissingVariables: function( value ) {
      var validatorFunction = this.initialConfig.missingVariablesValidatorFunction;

      if ( Ext.isFunction( validatorFunction ) ) {
        var validatorScope = !Ext.isEmpty( this.initialConfig.missingVariablesValidatorScope ) ?
            this.initialConfig.missingVariablesValidatorScope : window;
        return validatorFunction.apply( validatorScope, [ value ] );
      } else {
        return true;
      }
    },
    executePasteValue: function( value ) {
    	this.customValue = value;
    	this.storeParentWindowAsUnsaved();
    	this.switchToPreviewMode();
    	this.afterPasteValue( value );
    },
    onPasteSpecial: function() {
      var win = new Ext.ux.suncode.PasteSpecialWindow( {
        pasteSpecialFunction: function( value ) {
          this.validateAndPasteValue( value );
        },
        pasteSpecialScope: this,
        messageType: Ext.ux.suncode.Clipboard.integrationComponentParameterValueMessageType
      } );
      win.show();
    },
    buildEditor: function( config ) {
    	if ( config.isCombobox ) {
    		return this.buildComboboxEditor( config );
    	}
    	
        switch ( config.type ) {
            case this.INTEGER_TYPE:
                return this.buildIntegerEditor( config );
            case this.FLOAT_TYPE:
                return this.buildFloatEditor( config );
            case this.DATE_TYPE:
                return this.buildDateEditor( config );
            case this.DATETIME_TYPE:
                return this.buildDateTimeEditor( config );
            case this.BOOLEAN_TYPE:
                return this.buildBooleanEditor( config );
            case this.FUNCTION_TYPE:
            	return this.buildFunctionEditor( config );
            case this.VARIABLE_TYPE:
                return this.buildVariableEditor( config );
            default:
                return this.buildStringEditor( config );
        }
    },
    buildComboboxEditor: function( config ) {
    	var baseConfig = null;
    	
    	if ( config.comboboxConfig.remote ) {
    		baseConfig = this.buildRemoteComboboxEditorBaseConfig( config );
    	} else {
    		baseConfig = this.buildLocalComboboxEditorBaseConfig( config );
    	}
    	
    	return new Ext.form.ComboBox( baseConfig );
    },
    buildLocalComboboxEditorBaseConfig: function( config ) {
    	var comboboxConfig = config.comboboxConfig;
    	var baseConfig = this.buildComboboxEditorBaseConfig( config );
    	baseConfig = Ext.apply( baseConfig, {
    		triggerAction: 'all',
			mode: 'local',
			minChars: comboboxConfig.minChars,
			store: new Ext.data.Store( {
				data: comboboxConfig.values,
				reader: new Ext.data.JsonReader( {
					fields: Ext.data.Record.create( [ {
						name: 'id',
						type: 'string'
					}, {
						name: 'display',
						type: 'string'
					}, {
						name: 'description',
						type: 'string'
					} ] )
				} )
			} ),
			valueField: 'id',
			displayField: 'display',
			forceSelection: comboboxConfig.forceSelection,
			tpl: new Ext.XTemplate( '<tpl for=".">', '<div class="x-Module-comboTemplateItem">', '<div><font '
				+ getTemplateStyle() + '><b>' + getTranslation( 'Wartość' ) + ': '
				+ '</b></font><span>{display}</span></div>', '<div><font ' + getTemplateStyle() + '><b>'
				+ getTranslation( 'Opis' ) + ': ' + '</b></font><span>{description}</span></div></div>',
				'<tpl if="xindex !== xcount">', '<hr ' + getHRLineStyle() + '>', '</tpl>', '</tpl>' ).compile(),
			itemSelector: 'div.x-Module-comboTemplateItem',
			resizable: true,
			value: comboboxConfig.value,
			blockInvalidValueWarn: true
        } );
    	
    	return baseConfig;
    },
    buildRemoteComboboxEditorBaseConfig: function( config ) {
    	var comboboxConfig = config.comboboxConfig;
    	var url = comboboxConfig.url;
    	var staticUrl = Ext.isString( url ) ? url : '';
    	var record = Ext.data.Record.create( comboboxConfig.fields );
    	var store = new Ext.data.JsonStore( {
            proxy: new Ext.data.HttpProxy( {
                method: 'GET',
                url: Suncode.context( 'pwe' ).contextPath + '/' + staticUrl
            } ),
            reader: new Ext.data.JsonReader( {
                fields: record
            } ),
            autoDestroy: true,
            batch: true,
            fields: record,
            root: 'data',
            totalProperty: 'total',
            baseParams: {
                start: 0,
                limit: comboboxConfig.pageSize
            },
            remoteSort: comboboxConfig.remoteSort,
            sortInfo: comboboxConfig.sort,
            listeners: {
              scope: this,
              beforeload: function( store, options ) {
                if ( Ext.isFunction( url ) ) {
                  var urlOptions = this.buildFieldFunctionOptions();
                  var newUrl = url.apply( window, [ urlOptions ] );

                  if ( Ext.isString( newUrl ) ) {
                    var proxy = store.proxy;
                    proxy.setUrl( Suncode.context( 'pwe' ).contextPath + '/' + newUrl, true );
                  }
                }
              }
            }
        } );
    	
    	var baseConfig = this.buildComboboxEditorBaseConfig( config );
    	baseConfig = Ext.apply( baseConfig, {
            triggerAction: 'all',
            mode: 'remote',
            minChars: comboboxConfig.minChars,
            store: store,
            valueField: comboboxConfig.valueField,
            displayField: comboboxConfig.displayField,
            forceSelection: comboboxConfig.forceSelection,
            resizable: true,
            pageSize: comboboxConfig.pageSize,
			blockInvalidValueWarn: true
    	} );
    	
    	if ( Ext.isArray( comboboxConfig.template ) ) {
    		var tpl = '<tpl for="."><div class="x-Module-comboTemplateItem">';
    		
    		Ext.each( comboboxConfig.template, function( item, index, items ) {
    			tpl += '<div><font ';
    			tpl += getTemplateStyle();
    			tpl += '><b>';
    			tpl += item.label;
    			tpl += ': ';
    			tpl += '</b></font><span>{';
    			tpl += item.field;
    			tpl += '}</span></div>';
    		} );
    		
    		tpl += '</div><tpl if="xindex !== xcount"><hr ';
    		tpl += getHRLineStyle();
    		tpl += '></tpl></tpl>';
    		
    		baseConfig = Ext.apply( baseConfig, {
                tpl: new Ext.XTemplate( tpl ).compile(),
                itemSelector: 'div.x-Module-comboTemplateItem'
        	} );
    	}

    	return baseConfig;
    },
    buildComboboxEditorBaseConfig: function( config ) {
    	var baseConfig = this.buildEditorBaseConfig( config );
    	baseConfig.listeners = Ext.apply( baseConfig.listeners, {
    		beforequery: this.onComboboxEditorBeforeQuery,
            select: this.onComboboxEditorSelect
        } );
    	
    	return baseConfig;
    },
    onComboboxEditorBeforeQuery: function( queryEvent ) {
      delete queryEvent.combo.lastQuery;

    	return !this.hasMenuWindow(); 
    },
    onComboboxEditorSelect: function( combo, record, index ) {
    	this.blockOnEnterTask();
    	this.setCustomValue( this.editor.getType(), combo.getValue() );
        this.delayFunction( this.unblockOnEnterTask, 100 );
        this.afterSetValue();
        this.executeOnSelectFunction( this.getFormattedValue( this.customValue, true ) );
    },
    buildFieldFunctionOptions: function() {
      var options = new Object();
      var editor = this.editor;

      if ( editor.getInArray() && !Ext.isEmpty( this.array ) ) {
        var array = this.array;

        options = Ext.apply( options, {
          rowIndex: array.getRowIndex( this )
        } );
      }

      return options;
    },
    buildIntegerEditor: function( config ) {
        var baseConfig = this.buildEditorBaseConfig( config );
        baseConfig = Ext.apply( baseConfig, {
            allowDecimals: false,
            validationEvent: false,
            preventSetValueValidation: true,
            initEvents: function() {
                Ext.form.NumberField.superclass.initEvents.call( this );
            },
            setValue: function( v ) {
                return Ext.form.NumberField.superclass.setValue.call( this, v );
            }
        } );

        return new Ext.form.NumberField( baseConfig );
    },
    buildFloatEditor: function( config ) {
        var baseConfig = this.buildEditorBaseConfig( config );
        baseConfig = Ext.apply( baseConfig, {
            decimalSeparator: this.FLOAT_TYPE_DECIMAL_SEPARATOR,
            decimalPrecision: this.FLOAT_TYPE_PRECISION,
            validationEvent: false,
            preventSetValueValidation: true,
            initEvents: function() {
                Ext.form.NumberField.superclass.initEvents.call( this );
            },
            setValue: function( v ) {
                return Ext.form.NumberField.superclass.setValue.call( this, v );
            }
        } );

        return new Ext.form.NumberField( baseConfig );
    },
    buildDateEditor: function( config ) {
    	var me = this;
        var baseConfig = this.buildEditorBaseConfig( config );
        baseConfig.listeners = Ext.apply( baseConfig.listeners, {
            select: this.onDateEditorSelect,
            change: this.onDateEditorChange
        } );
        baseConfig = Ext.apply( baseConfig, {
            format: 'Y-m-d',
            validationEvent: false,
            preventSetValueValidation: true,
            setValue: function( date ){
            	if ( Ext.isDate( date ) ) {
            		return Ext.form.DateField.superclass.setValue.call( this, this.formatDate( this.parseDate( date ) ) );
            	} else {
            		return Ext.form.DateField.superclass.setValue.call( this, date );
            	}
            },
            initEvents: function() {
                Ext.form.DateField.superclass.initEvents.call( this );
                this.keyNav = new Ext.KeyNav( this.el, {
                    'down': function( e ) {
                    	if ( !me.hasMenuWindow() ) {
                    		this.onTriggerClick();
                    	}
                    },
                    scope: this,
                    forceKeyDown: true
                } );
            }
        } );

        return new Ext.form.DateField( baseConfig );
    },
    onDateEditorSelect: function( editor, date ) {
        this.setDateTypeValue( date );
    },
    onDateEditorChange: function( editor, newDate, oldDate ) {
    	this.setDateTypeValue( newDate );
    },
    setDateTypeValue: function( date ) {
    	this.setCustomValue( this.DATE_TYPE, date.getTime() );
        this.afterSetValue();
    },
    buildDateTimeEditor: function( config ) {
        var baseConfig = this.buildEditorBaseConfig( config );
        baseConfig.listeners = Ext.apply( baseConfig.listeners, {
            afterrender: this.onDateTimeEditorAfterRender,
            change: this.onDateTimeEditorChange
        } );
        baseConfig = Ext.apply( baseConfig, {
            format: 'Y-m-d H:i:s',
            onTriggerClick: function() {
                return false;
            },
            validationEvent: false,
            preventSetValueValidation: true,
            setValue: function( date ){
            	if ( Ext.isDate( date ) ) {
            		return Ext.form.DateField.superclass.setValue.call( this, this.formatDate( this.parseDate( date ) ) );
            	} else {
            		return Ext.form.DateField.superclass.setValue.call( this, date );
            	}
            }
        } );

        return new Ext.form.DateField( baseConfig );
    },
    onDateTimeEditorAfterRender: function( editor ) {
        var me = this;
        Calendar.setup( {
            inputField: editor.getId(),
            button: editor.getEl().up( '.x-form-field-wrap', true ).down( '.x-form-date-trigger' ).id,
            ifFormat: '%Y-%m-%d %H:%M:%S',
            singleClick: true,
            showsTime: true,
            timeFormat: '24',
            onSelect: function onSelect( calendar ) {
                editor.setValue( calendar.date );
                me.setCustomValue( me.DATETIME_TYPE, calendar.date.getTime() );

                if ( calendar.params.singleClick && calendar.dateClicked ) {
                    calendar.callCloseHandler();
                    me.afterSetValue();
                }
            },
            onClose: function( calendar ) {
                calendar.hide();
                editor.focus();
            }
        } );
    },
    onDateTimeEditorChange: function( editor, newDate, oldDate ) {
    	this.setCustomValue( this.DATETIME_TYPE, newDate.getTime() );
    	this.afterSetValue();
    },
    buildBooleanEditor: function( config ) {
        var baseConfig = this.buildEditorBaseConfig( config );
        baseConfig.listeners = Ext.apply( baseConfig.listeners, {
        	beforeshowmenuwindow: this.onBooleanEditorBeforeShowMenuWindow,
        	beforequery: this.onBooleanEditorBeforeQuery,
            select: this.onBooleanEditorSelect
        } );
        baseConfig = Ext.apply( baseConfig, {
            blockInvalidValueWarn: true
        } );

        return new Ext.ux.suncode.CustomFormBooleanChooser( baseConfig );
    },
    onBooleanEditorBeforeShowMenuWindow: function() {
    	var editor = this.editor;
    	
    	if ( editor.isExpanded() ) {
    		editor.collapse();
    	}
    },
    onBooleanEditorBeforeQuery: function( queryEvent ) {
    	return !this.hasMenuWindow();
    },
    onBooleanEditorSelect: function( combo, record, index ) {
    	this.blockOnEnterTask();
    	this.setCustomValue( this.BOOLEAN_TYPE, combo.getValue() );
        this.delayFunction( this.unblockOnEnterTask, 100 );
        this.afterSetValue();
    },
    buildFunctionEditor: function( config ) {
    	var baseConfig = this.buildEditorBaseConfig( config );

        return new Ext.form.TextField( baseConfig );
    },
    buildVariableEditor: function( config ) {
        var baseConfig = this.buildEditorBaseConfig( config );

        return new Ext.form.TextField( baseConfig );
    },
    blockOnEnterTask: function() {
        this.onEnterTaskBlocked = true;
    },
    unblockOnEnterTask: function() {
        this.onEnterTaskBlocked = false;
    },
    buildStringEditor: function( config ) {
        var baseConfig = this.buildEditorBaseConfig( config );

        return new Ext.form.TextField( baseConfig );
    },
    buildEditorBaseConfig: function( config ) {
        return {
            type: !Ext.isEmpty( config.type ) ? config.type : this.DEFAULT_TYPE,
            inArray: config.inArray,
            isCombobox: config.isCombobox,
            isColorPicker: config.isColorPicker,
            flex: 1,
            enableKeyEvents: true,
            listeners: {
                scope: this,
                afterrender: this.onEditorAfterRender,
                blur: this.onEditorBlur,
                keydown: this.onEditorKeyDown,
                keyup: this.onEditorKeyUp,
                specialkey: this.onEditorSpecialKey
            },
            getType: function() {
                return this.type;
            },
            getInArray: function() {
            	return this.inArray;
            },
            getIsCombobox: function() {
            	return this.isCombobox;
            },
            getIsColorPicker: function() {
            	return this.isColorPicker;
            }
        };
    },
    shouldBuildColumnCheckbox: function( inArray ) {
    	return inArray;
    },
    buildColumnCheckboxText: function( columnCheckboxEnabled, value, processNode ) {
    	return new Ext.BoxComponent( {
            autoEl: {
                tag: 'div',
                'class': 'x-Module-customFieldColumnCheckboxText',
                cn: [ {
                    tag: 'span',
                    html: getTranslation( 'Kolumna' ) + ': '
                } ]
            },
            hidden: !( columnCheckboxEnabled && this.isVariableTableValue( value, processNode ) )
        } );
    },
    buildColumnCheckboxField: function( columnCheckboxEnabled, value, processNode ) {
    	var isVariableTableValue = this.isVariableTableValue( value, processNode );
    	
    	return new Ext.form.Checkbox( {
    		inputValue: 'true',
    		hidden: !( columnCheckboxEnabled && isVariableTableValue ),
    		checked: ( columnCheckboxEnabled && isVariableTableValue ) ? value.wholeColumn : false,
    		listeners: {
    			scope: this,
    			check: this.onColumnCheckboxCheck
    		}
        } );
    },
    onColumnCheckboxCheck: function( field, checked ) {
    	if ( checked ) {
    		this.customValue = Ext.apply( this.customValue, {
        		wholeColumn: true
        	} );
    	} else {
    		delete this.customValue.wholeColumn;
    	}
    },
    shouldBuildColorPickerMenuButtons: function( binded, readOnly, isColorPicker, arrayInitializer ) {
    	if ( !( binded || readOnly ) && isColorPicker && !arrayInitializer ) {
            return true;
        } else {
            return false;
        }
    },
    buildColorPickerMenuButton: function() {
      return new Ext.Button( {
        cls: 'x-btn-icon',
        icon: getPluginImgPath( 'color_wheel' ),
        handler: this.onColorPickerMenuButtonClick,
        scope: this
      } );
    },
    shouldBuildResetColorMenuButton: function( binded, readOnly, isColorPicker, arrayInitializer ) {
    	if ( !( binded || readOnly ) && isColorPicker && !arrayInitializer ) {
            return true;
        } else {
            return false;
        }
    },
    buildResetColorMenuButton: function() {
      return new Ext.Button( {
        cls: 'x-btn-icon',
        icon: getPluginImgPath( 'clear' ),
        handler: this.onResetColorMenuButtonClick,
        scope: this
      } );
    },
    shouldBuildVariablesMenuButton: function( binded, readOnly, type, isColorPicker, arrayInitializer ) {
    	if ( !( binded || readOnly ) && type !== this.FUNCTION_TYPE && !isColorPicker && !arrayInitializer ) {
            return true;
        } else {
            return false;
        }
    },
    buildVariablesMenuButton: function() {
      return new Ext.Button( {
        cls: 'x-btn-icon',
        icon: getPluginImgPath( 'variable' ),
        handler: this.onVariablesMenuButtonClick,
        scope: this
      } );
    },
    shouldBuildFunctionsMenuButton: function( binded, readOnly, isColorPicker, arrayInitializer ) {
    	if ( !( binded || readOnly ) && !isColorPicker && !arrayInitializer ) {
            return true;
        } else {
            return false;
        }
    },
    buildFunctionsMenuButton: function() {
      return new Ext.Button( {
        cls: 'x-btn-icon',
        icon: getPluginImgPath( 'function' ),
        handler: this.onFunctionsMenuButtonClick,
        scope: this
      } );
    },
    shouldBuildSwitchValuesMenuButtons: function( inArray, arrayInitializer) {
      return inArray && !arrayInitializer;
    },
    buildSwitchValueUpMenuButton: function( hidden ) {
      return new Ext.Button( {
        cls: 'x-btn-icon',
        icon: getPluginImgPath( 'up' ),
        hidden: hidden,
        handler: this.onSwitchValueUpMenuButtonClick,
        scope: this
      } );
    },
    buildSwitchValueDownMenuButton: function( hidden ) {
      return new Ext.Button( {
        cls: 'x-btn-icon',
        icon: getPluginImgPath( 'down' ),
        hidden: hidden,
        handler: this.onSwitchValueDownMenuButtonClick,
        scope: this
      } );
    },
    shouldBuildAddFieldMenuButton: function( inArray, readOnly ) {
        return inArray && !readOnly;
    },
    buildAddFieldMenuButton: function( hidden ) {
      return new Ext.Button( {
        cls: 'x-btn-icon',
        icon: getPluginImgPath( 'add' ),
        hidden: hidden,
        handler: this.onAddFieldMenuButtonClick,
        scope: this
      } );
    },
    shouldBuildRemoveFieldMenuButton: function( inArray, readOnly, arrayInitializer ) {
    	return inArray && !readOnly && !arrayInitializer;
    },
    buildRemoveFieldMenuButton: function() {
      return new Ext.Button( {
        cls: 'x-btn-icon',
        icon: getPluginImgPath( 'delete' ),
        handler: this.onRemoveFieldMenuButtonClick,
        scope: this
      } );
    },
    onColorPickerMenuButtonClick: function( button, e ) {
    	this.showColorPicker( e );
    },
    onResetColorMenuButtonClick: function( button, e ) {
    	this.resetColor();
    },
    onVariablesMenuButtonClick: function( button, e ) {
    	this.onMenuButtonClick( this.VARIABLE_PREFIX );
        this.showVariablesMenuWindow();
    },
    onFunctionsMenuButtonClick: function( button, e ) {
    	this.onMenuButtonClick( this.FUNCTION_PREFIX );
        this.showFunctionsMenuWindow();
    },
    onAddFieldMenuButtonClick: function( button, e ) {
        this.resetMenuWindow();
        this.addField();
    },
    onRemoveFieldMenuButtonClick: function( button, e ) {
        this.resetMenuWindow();
        this.removeField();
    },
    onSwitchValueUpMenuButtonClick: function( button, e ) {
      this.resetMenuWindow();
      this.switchValueUp( false );
    },
    onSwitchValueDownMenuButtonClick: function( button, e ) {
      this.resetMenuWindow();
      this.switchValueDown( false );
    },
    onMenuButtonClick: function( postfix ) {
    	this.switchToEditionMode();
    	var editor = this.editor;
    	editor.setValue( editor.getRawValue() + postfix );
    },
    addPreviewClickListener: function() {
        var previewEl = this.preview.getEl();
        previewEl.on( 'click', this.switchToEditionMode, this );
    },
    removePreviewClickListener: function() {
        var previewEl = this.preview.getEl();
        previewEl.un( 'click', this.switchToEditionMode, this );
    },
    registerTooltipForPreview: function() {
        var element = this.preview.getEl();
        this.registerTooltipForElement( element );
    },
    registerTooltipForElement: function( element ) {
        if ( this.shouldRegisterTooltipForElement() ) {
            Ext.QuickTips.register( {
                target: element,
                text: getTranslation( 'Kliknij w celu edycji' )
            } );
        }
    },
    registerTooltipForCloseButton: function( element ) {
        if ( this.shouldRegisterTooltipForElement() ) {
            Ext.QuickTips.register( {
                target: element,
                text: getTranslation( 'Usuń wartość' )
            } );
        }
    },
    shouldRegisterTooltipForElement: function() {
        return Ext.getCmp( 'main_panel' ).getShowTooltips();
    },
    unregisterTooltipForPreview: function() {
        var element = this.preview.getEl();
        this.unregisterTooltipForElement( element );
    },
    unregisterTooltipForElement: function( element ) {
        Ext.QuickTips.unregister( element );
    },
    buildFieldLabel: function( config, notEmpty ) {
    	var label = !Ext.isEmpty( config.name ) ? config.name : '';
    	var extras = '';
    	
    	if ( notEmpty || !config.optional ) {
    		extras += '<span class="x-Module-required-field-label">*</span>';
    	}
    	
    	if ( !Ext.isEmpty( config.description ) ) {
    		extras += '<img onmouseover=\"new Function(showFieldTooltip(this, \'' + config.description.replaceAll( '\'', '\\\'' )
	            + '\', \'tip_on\'))\" onmouseout=\"new Function(hideFieldTooltip(this, \'tip_off\'))\" src="'
	            + getPluginImgPath( 'tip_off' ) + '" height="12" width="12">';
    	}
    	
    	if ( !Ext.isEmpty( extras ) ) {
    		var idx = label.lastIndexOf( ' ' );
    		
    		if ( idx != -1 && idx < label.length - 1 ) {
    			var lastWord = label.substring( idx + 1 );
    			label = label.substring( 0, idx );
    			extras = lastWord + ' ' + extras;
    		}
    		
    		label += ' <span class="x-Module-nowrap">';
    		label += extras;
    		label += '</span>';
    	}
    	
    	return label;
    },
    handleValueForPreview: function() {
        var value = this.customValue;

        if ( this.isNonEmptyValue( value ) ) {
        	var editor = this.editor;
        	
        	if ( editor.getIsCombobox() && value.type === this.STRING_TYPE ) {
        		this.buildPreviewElValue( this.formatComboboxValue( value.value ) );
        	} else if ( editor.getIsColorPicker() && value.type === this.STRING_TYPE ) {
        		this.setColorPickerPreviewElColor( value.value );
        	} else {
        		switch ( value.type ) {
	                case this.INTEGER_TYPE:
	                	this.buildPreviewElValue( this.formatNumber( value.value, 0 ) );
	                    break;
	                case this.FLOAT_TYPE:
	                	this.buildPreviewElValue( this.formatNumber( value.value, this.FLOAT_TYPE_PRECISION ) );
	                    break;
	                case this.DATE_TYPE:
	                	this.buildPreviewElValue( this.formatDate( value.value, 'Y-m-d' ) );
	                    break;
	                case this.DATETIME_TYPE:
	                	this.buildPreviewElValue( this.formatDate( value.value, 'Y-m-d H:i:s' ) );
	                    break;
	                case this.BOOLEAN_TYPE:
	                	this.buildPreviewElValue( this.formatBoolean( value.value ) );
	                    break;
	                case this.VARIABLE_TYPE:
	                	this.buildLabelForVariablePreview();
	                    break;
	                case this.FUNCTION_TYPE:
	                    this.buildLabelForFunctionPreview();
	                    break;
	                default:
	                	this.buildPreviewElValue( value.value );
	                    break;
        		}
        	}
        }
    },
    buildPreviewElValue: function( value ) {
    	var previewEl = this.preview.getEl();
    	previewEl.createChild( this.buildPreviewElChild( value ) );
    },
    buildPreviewElChild: function( value ) {
    	return {
    		tag: 'span',
            'class': 'x-Module-customFieldTextSpan',
            html: Ext.util.Format.htmlEncode( value )
    	};
    },
    setColorPickerPreviewElColor: function( color ) {
    	var previewEl = this.preview.getEl();
    	previewEl.setStyle( 'background', color );
    },
    buildLabelForVariablePreview: function() {
    	this.buildLabelForComponentPreview( false );
    },
    buildLabelForFunctionPreview: function() {
    	this.buildLabelForComponentPreview( true );
    },
    buildLabelForComponentPreview: function( isFunction ) {
    	var value = this.customValue;
    	var extraCls = isFunction ? 'x-Module-customFieldFunctionSpan' : 'x-Module-customFieldVariableSpan';
    	var editFn = isFunction ? this.onEditFunction : this.onEditVariable;
        var previewEl = this.preview.getEl();
        var labelEl = previewEl.createChild( {
            tag: 'span',
            tabindex: -1,
            'class': this.buildPreviewLabelElClass( extraCls )
        } );
        
        if ( isFunction ) {
	        labelEl.on( 'contextmenu', this.onFunctionLabelElContextMenu, this );
        }
        
        var textEl = labelEl.createChild( {
            tag: 'a',
            tabindex: 0,
            'class': this.buildPreviewTextElClass(),
            html: Ext.util.Format.htmlEncode(
            		isFunction ? this.buildFunctionPreviewText( value ) : this.getFormattedValue( value, false ) )
        } );

        if ( !( this.binded || this.readOnly ) ) {
            this.registerTooltipForElement( textEl );
            textEl.on( 'keyup', this.onTextElKeyUp, this, {
                editFn: editFn
            } );
            textEl.on( 'click', editFn, this );
            Ext.apply( textEl, {
                editFn: editFn
            } );
            var removeEl = labelEl.createChild( {
                tag: 'span',
                tabindex: -1,
                'class': 'x-Module-customFieldCloseSpan'
            } );
            removeEl.on( 'click', this.onRemoveMenuOption, this, {
                labelEl: labelEl
            } );
            this.registerTooltipForCloseButton( removeEl );
        } else {
            textEl.on( 'keyup', this.onTextElKeyUp, this );
        }
        
        if ( this.typeVisible ) {
    		this.buildTypePreview( labelEl );
    		labelEl.addClass( 'x-Module-customFieldTypeAbbreviationSpace' );
    	}
    },
    buildPreviewLabelElClass: function( extraCls ) {
        var cls = ( this.binded || this.readOnly ) ? 'x-Module-readOnlyCustomFieldComponentSpan' : 'x-Module-customFieldComponentSpan';
        cls += ' ' + extraCls;

        return cls;
    },
    buildPreviewTextElClass: function() {
        var cls = ( this.binded || this.readOnly ) ? 'x-Module-readOnlyCustomFieldComponentEdit' : 'x-Module-customFieldComponentEdit';

        return cls;
    },
    onFunctionLabelElContextMenu: function( e, t, o ) {
    	e.stopEvent();

      Ext.ux.suncode.Clipboard.getIntegrationComponentParameterValue( function( value ) {
        var menu = this.buildFunctionLabelElContextMenu( value );
        showMenu( menu, e );
      }, this );
    },
    buildFunctionLabelElContextMenu: function( clipboardParameterValue ) {
    	var items = this.buildCopyPasteContextMenuItems( clipboardParameterValue );
    	items.push( {
			xtype: 'menuitem',
            cls: 'x-btn-text-icon',
            icon: getPluginImgPath( 'function' ),
            text: getTranslation( 'Podgląd funkcji' ),
            listeners: {
            	scope: this,
            	click: this.onShowFunctionPreviewMenu
            }
		} );
    	
    	return new Ext.menu.Menu( {
    		items: items
    	} );
    },
    onShowFunctionPreviewMenu: function( menuItem, e ) {
    	var value = this.customValue;
    	
    	if ( this.isNonEmptyValue( value ) ) {
    		var editor = this.editor;
    		var position = this.getPosition();
    		var menu = new Ext.ux.suncode.FunctionPreviewMenu( {
        		value: value,
        		contextVariables: this.initialConfig.contextVariables,
            processNode: this.initialConfig.processNode,
            returnType: editor.getType(),
            inArray: editor.getInArray(),
            accessibility: this.initialConfig.systemFunctionsAccessibility,
            availableVariables: this.initialConfig.availableVariables,
            missingVariablesValidatorFunction: this.initialConfig.missingVariablesValidatorFunction,
            missingVariablesValidatorScope: this.initialConfig.missingVariablesValidatorScope,
            validateFieldFunction: this.initialConfig.validateFieldFunction,
            validateFieldScope: this.initialConfig.validateFieldScope,
        		getVariableNameFunction: this.getVariableName,
        		getVariableNameScope: this,
        		customField: this
        	} );
    		menu.showAt( [ position[0], position[1] + 25 ] );
    	}
    },
    buildFunctionPreviewText: function( value ) {
      var functionName = value.value.name;
      var functionParameterTypes = value.value.parameterTypes;
      var mainPanel = Ext.getCmp( 'main_panel' );
      var systemFunction = mainPanel.getSystemFunction( functionName, functionParameterTypes );
      var functionReg = Ext.ux.suncode.IntegrationComponentService
        .getSystemFunctionRegistration( functionName, functionParameterTypes, systemFunction.parameters, systemFunction.returnType );

      if ( this.functionPrettyFormat && !Ext.isEmpty( functionReg ) && Ext.isFunction( functionReg.toPrettyText ) ) {
        var toPrettyTextFunc = functionReg.toPrettyText;
        var parameterValues = this.buildParameterValuesForToPrettyTextFunction( value.value.parameters, systemFunction.parameters );
        var parameterTypes = this.buildParameterTypesForToPrettyTextFunction( functionParameterTypes, systemFunction.parameters );

        var previewText = toPrettyTextFunc.apply( window, [ parameterValues, parameterTypes ] );

        return previewText === null ? this.buildFunctionFormattedValue( value ) : previewText;
      } else {
        return this.buildFunctionFormattedValue( value );
      }
    },
    buildFunctionFormattedValue: function( value ) {
    	var formattedValue = value.value.name;
        formattedValue += '(';
        formattedValue += this.getFormattedValue( value.value.parameters, false, true, true );
        formattedValue += ')';
        
        return formattedValue;
    },
    buildParameterValuesForToPrettyTextFunction: function( parameters, parameterDefinitions ) {
    	var parameterValues = new Object();
    	
    	if ( Ext.isArray( parameters ) ) {
            Ext.each( parameters, function( parameter, index, allParameters ) {
            	var parameterDefinition = parameterDefinitions[index];
            	var parameterId = parameterDefinition.id;
            	var parameterValue = this.buildParameterValueForToPrettyTextFunction( parameter );
            	
            	parameterValues[parameterId] = parameterValue;
            }, this );
        }
    	
    	return parameterValues
    },
    buildParameterValueForToPrettyTextFunction: function( parameter ) {
    	if ( Ext.isArray( parameter ) ) {
    		var parameterValues = new Array();
    		
    		Ext.each( parameter, function( value, index, values ) {
            	var parameterValue = this.buildParameterValueForToPrettyTextFunction( value );
            	parameterValues.push( parameterValue );
            }, this );
    		
    		return parameterValues;
    	} else {
    		switch ( parameter.type ) {
	        	case this.VARIABLE_TYPE:
	        		return this.getVariableName( parameter.value );
	            case this.FUNCTION_TYPE:
	            	return this.buildFunctionPreviewText( parameter );
	            default:
	            	return parameter.value;
	    	}
    	}
    },
    buildParameterTypesForToPrettyTextFunction: function( types, parameterDefinitions ) {
      var parameterTypes = new Object();

      if ( Ext.isArray( types ) ) {
        Ext.each( types, function( type, index, allTypes ) {
          var parameterDefinition = parameterDefinitions[index];
          var parameterId = parameterDefinition.id;

          parameterTypes[parameterId] = type;
        }, this );
      }

      return parameterTypes
    },
    onTextElKeyUp: function( e, t, o ) {
        var key = e.getKey();

        if ( key == e.ENTER && Ext.isFunction( o.editFn ) ) {
            var editFn = o.editFn;
            editFn.apply( this, [ e, t, o ] );
        } else if ( key == e.TAB ) {
            e.preventDefault();
            this.focusNextField( e.shiftKey );
        }
    },
    onRemoveMenuOption: function( e, t, o ) {
        o.labelEl.remove();
        var editor = this.editor;
        if ( editor.getType() === this.BOOLEAN_TYPE ) {
          this.setCustomValue( this.BOOLEAN_TYPE, false );
        } else {
          this.clearCustomValue();
        }
        this.storeParentWindowAsUnsaved();
        this.setPreviewBehaviour();
        this.afterResetValue();
    },
    clearCustomValue: function() {
        var editor = this.editor;

        if ( editor.getInArray() ) {
          this.setCustomValue( editor.getType(), null );
        } else {
          this.customValue = undefined;
        }
    },
    buildTypePreview: function( labelEl ) {
      var value = this.customValue;
      var abbreviation = '';

      switch ( value.type ) {
        case this.VARIABLE_TYPE:
          abbreviation = this.getVariableTypeAbbreviation( value.value );
          break;
        case this.FUNCTION_TYPE:
          var returnTypeAbbreviation = this.getFunctionReturnTypeAbbreviation( value.value );
          abbreviation = this.buildProperFunctionReturnType( returnTypeAbbreviation );
          break;
        default:
          abbreviation = Ext.ux.suncode.UtilService.DEFAULT_TYPE_ABBREVIATION;
          break;
      }

      var typeEl = labelEl.createChild( {
        tag: 'span',
        tabindex: -1,
        'class': 'x-Module-customFieldTypeAbbreviationSpan',
        html: Ext.util.Format.htmlEncode( abbreviation )
      }, labelEl.down( '.x-Module-customFieldCloseSpan' ) );
    },
    getVariableTypeAbbreviation: function( id ) {
    	var variable = this.getVariableOrContextVariable( id );
    	
    	if ( !Ext.isEmpty( variable ) ) {
    		var abbreviation = Ext.ux.suncode.UtilService.getTypeAbbreviation( variable.type );
        	
        	if ( variable.placement === 'table' ) {
        		abbreviation += '[]';
        	}
        	
            return abbreviation;
        } else {
            return Ext.ux.suncode.UtilService.DEFAULT_TYPE_ABBREVIATION;
        }
    },
    getFunctionReturnTypeAbbreviation: function( func ) {
      var mainPanel = Ext.getCmp( 'main_panel' );
      var systemFunction = mainPanel.getSystemFunction( func.name, func.parameterTypes );

      if ( !Ext.isEmpty( systemFunction ) ) {
        return Ext.ux.suncode.UtilService.getTypeAbbreviation( systemFunction.returnType );
      } else {
        return Ext.ux.suncode.UtilService.DEFAULT_TYPE_ABBREVIATION;
      }
    },
    buildProperFunctionReturnType: function( returnType ) {
      var editor = this.editor;

      if ( editor.getType() == this.FUNCTION_TYPE || editor.getType() == this.VARIABLE_TYPE ) {
        return returnType;
      } else {
        var properReturnType = editor.getType();

        if ( returnType.endsWith( '[]' ) ) {
          properReturnType += '[]';
        }

        return properReturnType;
      }
    },
    onEditFunction: function( e, t, o ) {
    	if ( !this.isDisabled ) {
	        var value = this.customValue;
	        var currentParameters = value.value.parameters;
	
	        if ( !Ext.isEmpty( currentParameters ) ) {
	        	var editor = this.editor;
	            var position = this.getPosition();
	            var win = new Ext.ux.suncode.FunctionParametersWindow( {
	                functionName: value.value.name,
	                functionParameterTypes: value.value.parameterTypes,
	                contextVariables: this.initialConfig.contextVariables,
	                processNode: this.initialConfig.processNode,
	                returnType: editor.getType(),
	                inArray: editor.getInArray(),
	                accessibility: this.initialConfig.systemFunctionsAccessibility,
	                previousWindow: this.initialConfig.previousWindow,
                  availableVariables: this.initialConfig.availableVariables,
                  validateFieldFunction: this.initialConfig.validateFieldFunction,
                  validateFieldScope: this.initialConfig.validateFieldScope,
                  missingVariablesValidatorFunction: this.initialConfig.missingVariablesValidatorFunction,
                  missingVariablesValidatorScope: this.initialConfig.missingVariablesValidatorScope,
	                customField: this,
	                currentParameters: currentParameters,
	                xPos: position[0],
	                y: position[1] + 25
	            } );
	            win.show();
	        }
    	}

        return false;
    },
    onEditVariable: function( e, t, o ) {
    	if ( !this.isDisabled ) {
    		this.switchToEditionMode();
            this.showVariablesMenuWindow( this.customValue.value );
    	}
        return false;
    },
    formatComboboxValue: function( value ) {
    	var formattedValue = new String( value );

    	if ( !Ext.isEmpty( this.initialConfig.comboboxConfig.values ) ) {
    		Ext.each( this.initialConfig.comboboxConfig.values, function( val, index, vals ) {
    			if ( val.id === value ) {
    				formattedValue = val.display;
    			}
    		} );
    	} else {
    		var editor = this.editor;
    		var store = editor.getStore();
        var currentIndex = store.find( editor.valueField, formattedValue );
    		
    		if ( currentIndex != -1 ) {
          var record = store.getAt( currentIndex );
    			formattedValue = record.get( editor.displayField );
    		} else if ( !Ext.isEmpty( store.proxy ) ) {
          store.baseParams[editor.queryParam] = formattedValue;
          store.load( {
            params: editor.getParams( formattedValue ),
            scope: this,
            callback: function( records, options, success ) {
              if ( success && !Ext.isEmpty( records ) ) {
                var index = store.find( editor.valueField, new String( value ) );

                if ( index != -1 ) {
                  var record = store.getAt( index );
                  var previewValue = record.get( editor.displayField );
                  this.resetPreview();
                  this.buildPreviewElValue( previewValue );
                }
              }
            }
          } );

          if ( this.initialConfig.comboboxConfig.forceSelection ) {
            formattedValue = '';
          }
    		}
    	}
    	
    	return formattedValue;
    },
    formatNumber: function( number, decimalPrecision ) {
        var numberFormat = this.buildNumberFormat( decimalPrecision );
        var formattedNumber = Ext.util.Format.number( number, numberFormat );
        formattedNumber =  formattedNumber.replace( new RegExp( '[,]', 'g' ), this.FLOAT_TYPE_THOUSAND_SEPARATOR )
        		.replace( new RegExp( '[.]', 'g' ), this.FLOAT_TYPE_DECIMAL_SEPARATOR );
        
        if ( formattedNumber.match( new RegExp( '[' + this.FLOAT_TYPE_DECIMAL_SEPARATOR + ']', 'g' ) ) ) {
        	formattedNumber = formattedNumber.replace( new RegExp( '0+$', 'g' ), '' )
        		.replace( new RegExp( '[' + this.FLOAT_TYPE_DECIMAL_SEPARATOR + ']$', 'g' ), '' );
        }
        
        return formattedNumber;
    },
    buildNumberFormat: function( decimalPrecision ) {
        var format = '0,000';

        if ( decimalPrecision > 0 ) {
            format += '.';

            for ( var i = 0; i < decimalPrecision; i++ ) {
                format += '0';
            }
        }

        return format;
    },
    formatDate: function( timestamp, dateFormat ) {
        return new Date( timestamp ).format( dateFormat );
    },
    formatBoolean: function( boolean ) {
    	if ( boolean === true ) {
    		return getTranslation( 'Tak' );
    	} else if ( boolean === false ) {
    		return getTranslation( 'Nie' );
    	} else {
    		return '';
    	}
    },
    handleValueForEditor: function() {
        var formattedValue = this.getFormattedValue( this.customValue, true );
        this.editor.setValue( formattedValue );
    },
    getFormattedValue: function( value, edition, skipComboboxCheck, skipSquareBrackets ) {
        var formattedValue = '';

        if ( Ext.isArray( value ) ) {
            var subElements = new Array();

            Ext.each( value, function( element, index, array ) {
                subElements.push( this.getFormattedValue( element, edition, true, false ) );
            }, this );
            
            if ( !skipSquareBrackets ) {
            	formattedValue += '[' + subElements.join( ',' ) + ']';
            } else {
            	formattedValue += subElements.join( ',' );
            }
        } else if ( this.isNonEmptyValue( value ) ) {
        	var editor = this.editor;
        	
        	if ( !skipComboboxCheck && editor.getIsCombobox() && value.type === this.STRING_TYPE ) {
        		if ( edition ) {
                    formattedValue = value.value;
                } else {
                    formattedValue = this.formatComboboxValue( value.value );
                }
        	} else if ( editor.getIsColorPicker() ) {
        		formattedValue = '';
        	} else {
	            switch ( value.type ) {
	                case this.DATE_TYPE:
	                	if ( edition ) {
	                        formattedValue = new Date( value.value );
	                    } else {
	                        formattedValue = this.formatDate( value.value, 'Y-m-d' );
	                    }
	                    break;
	                case this.DATETIME_TYPE:
	                    if ( edition ) {
	                        formattedValue = new Date( value.value );
	                    } else {
	                        formattedValue = this.formatDate( value.value, 'Y-m-d H:i:s' );
	                    }
	                    break;
	                case this.BOOLEAN_TYPE:
	                    if ( edition ) {
	                        formattedValue = value.value;
	                    } else {
	                        formattedValue = this.formatBoolean( value.value );
	                    }
	                    break;
	                case this.VARIABLE_TYPE:
	                    if ( edition ) {
	                        formattedValue += this.VARIABLE_PREFIX;
	                        formattedValue += value.value;
	                    } else {
	                        formattedValue += this.getVariableName( value.value );
	                    }
	                    break;
	                case this.FUNCTION_TYPE:
	                    if ( edition ) {
	                        formattedValue += this.FUNCTION_PREFIX;
	                        formattedValue += value.value.name;
	                    } else {
	                        formattedValue += this.buildFunctionPreviewText( value );
	                    }
	                    break;
	                default:
	                    formattedValue = value.value;
	                    break;
	            }
        	}
        }

        return formattedValue;
    },
    getVariableName: function( id ) {
    	var variable = this.getVariableOrContextVariable( id );
    	
    	if ( !Ext.isEmpty( variable ) ) {
            return variable.name;
        } else {
            return id;
        }
    },
    getVariableOrContextVariable: function( id ) {
    	if ( id.startsWith( Ext.ux.suncode.IntegrationComponentService.CONTEXT_VARIABLE_ID_PREFIX ) ) {
    		return this.getContextVariable( id );
    	} else {
            return this.getVariable( id );
    	}
    },
    getVariable: function( id, processNode ) {
    	processNode = processNode ? processNode : this.initialConfig.processNode;
        var variable = processNode.findVariable( id );
        
        if ( !Ext.isEmpty( variable ) ) {
        	return variable;
        } else {
        	return processNode.findFormalParam( id );
        }
    },
    getContextVariable: function( id ) {
    	var result = null;
    	var contextVariables = this.initialConfig.contextVariables;
    	
    	if ( !Ext.isEmpty( contextVariables ) ) {
    		Ext.each( contextVariables, function( contextVariable, index, allContextVariables ) {
    			if ( contextVariable.id === id ) {
    				result = contextVariable;
    				return false;
    			}
    		} );
    	}
    	
    	return result;
    },
    onEditorAfterRender: function( editor ) {
    	var editorEl = editor.getEl();
    	editorEl.on( 'contextmenu', this.onEditorContextMenu, this );
    	
    	if ( this.isBooleanEditor() ) {
    		var value = this.customValue;
    		var checked = this.isNonEmptyValue( value ) ? value.value : false;
    		
    		if ( Ext.isFunction( this.ownerCt.handleCheckboxBindedFields ) ) {
    			this.ownerCt.handleCheckboxBindedFields( this.getFieldId(), checked );
    		}
    	}
    },
    onEditorContextMenu: function( e, t, o ) {
      this.onContextMenu( e );
    },
    onEditorBlur: function() {
    	if ( this.hasMenuWindow() ) {
    		this.switchToPreviewModeTask = this.delayFunction( this.switchToPreviewMode, 50 );
    	} else {
    		this.switchToPreviewMode();
    	}
    	
    	this.executeOnBlurFunction( this.getFormattedValue( this.customValue, true ) );
    },
    executeOnBlurFunction: function( value ) {
    	var onBlurFunction = this.initialConfig.onBlurFunction;

      if ( Ext.isFunction( onBlurFunction ) ) {
        var onBlurOptions = this.buildFieldFunctionOptions();
        onBlurFunction.apply( this, [ value, onBlurOptions ] );
      }
    },
    onEditorKeyDown: function( field, e ) {
    	var key = e.getKey();
    	
    	if ( this.hasMenuWindow() ) {
    		if ( key == e.DOWN ) {
                var onDownFunc = this.menuWindow.onDown;

                if ( Ext.isFunction( onDownFunc ) ) {
                    onDownFunc.apply( this.menuWindow, [] );
                }
            } else if ( key == e.UP ) {
                var onUpFunc = this.menuWindow.onUp;

                if ( Ext.isFunction( onUpFunc ) ) {
                    onUpFunc.apply( this.menuWindow, [] );
                }
            }
    	}
    },
    onEditorKeyUp: function( field, e ) {
        var key = e.getKey();
        var isVariableEditor = this.isVariableEditor();
        var isFunctionEditor = this.isFunctionEditor();
        var editor = this.editor;
        var inArray = editor.getInArray();
        var isCombobox = editor.getIsCombobox();

        if ( this.hasMenuWindow() ) {
            if ( key == e.ENTER ) {
                var chooseMenuOptionFunc = this.menuWindow.chooseMenuOption;

                if ( Ext.isFunction( chooseMenuOptionFunc ) ) {
                    chooseMenuOptionFunc.apply( this.menuWindow, [] );
                }
            } else if ( key == e.ESC ) {
                this.resetMenuWindow();
                this.setCurrentValue( true );
            } else if ( !( key == e.UP || key == e.DOWN || key == e.SHIFT ) ) {
                this.onEditorKeyUpForMenuWindow();
            }
        } else if ( key == e.ESC ) {
            this.switchToPreviewMode();
        } else if ( key == e.ENTER ) {
            var onEnterTask = this.initialConfig.onEnterTask;

            if ( !Ext.isEmpty( onEnterTask ) && this.isOnEnterTaskNotBlocked() ) {
                onEnterTask.run();
            }
        } else if ( ( isFunctionEditor || ( e.shiftKey && key == e.THREE ) )
        		&& this.editor.fireEvent( 'beforeshowmenuwindow' ) !== false ) {
            this.showFunctionsMenuWindow();

            if ( isFunctionEditor ) {
                this.onEditorKeyUpForMenuWindow();
            }
        } else if ( !isFunctionEditor && ( isVariableEditor || ( e.shiftKey && key == e.FOUR ) )
        		&& this.editor.fireEvent( 'beforeshowmenuwindow' ) !== false ) {
            this.showVariablesMenuWindow();
            
            if ( isVariableEditor ) {
                this.onEditorKeyUpForMenuWindow();
            }
        } else if( inArray && !isCombobox && e.altKey && key == e.UP ) {
            var array = this.array;

            array.switchValueUp( this, true );
        } else if( inArray && !isCombobox && e.altKey && key == e.DOWN ) {
            var array = this.array;

            array.switchValueDown( this, true );
        } else {
            this.setCurrentValue( false );
        }
    },
    setCurrentValue: function( checkCustomValueType ) {
    	var isVariableEditor = this.isVariableEditor();
        var isFunctionEditor = this.isFunctionEditor();
        
    	if ( !( isVariableEditor || isFunctionEditor ) ) {
	    	var editor = this.editor;
	        var editorValue = this.isComboboxEditor()
                && ( Ext.isEmpty( editor.getRawValue() ) || !this.initialConfig.comboboxConfig.forceSelection ) ?
	        		editor.getRawValue() : editor.getValue();
	        var value = editorValue !== '' ? editorValue : null;
          var type = checkCustomValueType && this.isNonEmptyValue( this.customValue ) ?
              this.customValue.type : editor.getType();

          if ( !Ext.isEmpty( value ) ) {
            switch (type) {
              case this.VARIABLE_TYPE:
                value = this.substringValue(value, this.VARIABLE_PREFIX);
                break;
              case this.FUNCTION_TYPE:
                value = this.substringValue(value, this.FUNCTION_PREFIX);
                break;
              default:
                break;
            }
          }

	        this.setCustomValue( type, value );
	        this.executeOnChangeFunction( value );
    	}
    },
    getCustomValue: function() {
      return this.customValue;
    },
    setCustomValue: function( type, value ) {
    	this.customValue = {
    		type: type,
	        value: value
	    };
    	this.storeParentWindowAsUnsaved();
    },
    executeOnChangeFunction: function( value ) {
		var onChangeFunction = this.initialConfig.onChangeFunction;

		if ( Ext.isFunction( onChangeFunction ) ) {
		  var onChangeOptions = this.buildFieldFunctionOptions();
			onChangeFunction.apply( this, [ value, onChangeOptions ] );
		}
	},
	executeOnSelectFunction: function( value ) {
		var onSelectFunction = this.initialConfig.onSelectFunction;

		if ( Ext.isFunction( onSelectFunction ) ) {
      var onSelectOptions = this.buildFieldFunctionOptions();
			onSelectFunction.apply( this, [ value, onSelectOptions ] );
		}
	},
    getMenuText: function() {
        var editor = this.editor;
        var value = editor.getRawValue();
        var index = 0;

        if ( this.functionsMenu ) {
            index = value.lastIndexOf( this.FUNCTION_PREFIX );
        } else if ( this.variablesMenu ) {
            index = value.lastIndexOf( this.VARIABLE_PREFIX );
        }

        if ( index != -1 ) {
            return value.substring( index + 1 );
        } else if ( this.isFunctionEditor() ) {
            return value;
        } else if ( this.isVariableEditor() ) {
            return value;
        } else {
            this.resetMenuWindow();

            return '';
        }
    },
    onEditorKeyUpForMenuWindow: function() {
        var menuText = this.getMenuText();
        var handleMenuTextFunc = !Ext.isEmpty( this.menuWindow ) ? this.menuWindow.handleMenuText : null;

        if ( Ext.isFunction( handleMenuTextFunc ) ) {
            handleMenuTextFunc.apply( this.menuWindow, [ menuText ] );
        }
    },
    isOnEnterTaskNotBlocked: function() {
        return !this.onEnterTaskBlocked;
    },
    isVariableEditor: function() {
        var editor = this.editor;

        return editor.getType() == this.VARIABLE_TYPE;
    },
    isFunctionEditor: function() {
    	var editor = this.editor;

        return editor.getType() == this.FUNCTION_TYPE;
    },
    isComboboxEditor: function() {
    	var editor = this.editor;
    	
    	return editor.getIsCombobox();
    },
    isBooleanEditor: function() {
    	var editor = this.editor;
    	
    	return editor.getType() == this.BOOLEAN_TYPE;
    },
    onEditorSpecialKey: function( field, e ) {
        var key = e.getKey();

        if ( key == e.TAB ) {
            e.preventDefault();
            this.focusNextField( e.shiftKey );
        }
    },
    focusNextField: function( reverse ) {
        var otherField = reverse ? this.previous : this.next;

        if ( !Ext.isEmpty( otherField ) ) {
            this.onEditorBlur();
            otherField.focusField( reverse );
        } else if ( this.inArray && !Ext.isEmpty( this.array ) ) {
            this.onEditorBlur();
            var array = this.array;
            array.focusNextField( reverse );
        }
    },
    switchToEditionMode: function() {
    	if ( !this.isDisabled ) {
    		this.analyzeError();
    		this.clearSwitchToPreviewModeTask();
        	this.resetMenuWindow();
            this.handleValueForEditor();
            var preview = this.preview;
            var editor = this.editor;
            preview.hide();
            editor.show();
            this.doLayout();
            editor.focus();
    	}
    },
    switchToPreviewMode: function() {
    	  this.clearSwitchToPreviewModeTask();
        this.resetMenuWindow();
        this.resetPreview();
        this.handleValueForPreview();
        this.setPreviewBehaviour();
        this.validatePreviewField();
        var preview = this.preview;
        var editor = this.editor;
        preview.show();
        editor.hide();
        this.adjustPreviewHeight();
    },
    clearSwitchToPreviewModeTask: function() {
    	if ( !Ext.isEmpty( this.switchToPreviewModeTask ) ) {
    		this.switchToPreviewModeTask.cancel();
    		this.switchToPreviewModeTask = null;
    	}
    },
    resetPreview: function() {
    	var previewEl = this.preview.getEl();
    	var editor = this.editor;
    	
    	if ( editor.getIsColorPicker() ) {
    		previewEl.setStyle( 'background', '' );
    	} else {
            var childNodes = previewEl.dom.childNodes;

            if ( !Ext.isEmpty( childNodes ) ) {
                Ext.each( childNodes, function( child, index, children ) {
                    var element = Ext.get( child );
                    element.remove();
                } );
            }
    	}
    },
    setPreviewBehaviour: function() {
        var value = this.customValue;

        if ( this.binded || this.readOnly || this.arrayInitializer || this.isColorPicker ) {
            this.removePreviewClickListener();
            this.unregisterTooltipForPreview();
        } else {
            if ( this.isNonEmptyValue( value ) ) {
                switch ( value.type ) {
                    case this.FUNCTION_TYPE:
                    case this.VARIABLE_TYPE:
                        this.removePreviewClickListener();
                        this.unregisterTooltipForPreview();
                        break;
                    default:
                        this.addPreviewClickListener();
                        this.registerTooltipForPreview();
                        break;
                }
            } else {
                this.addPreviewClickListener();
                this.registerTooltipForPreview();
            }
        }
    },
    validatePreviewField: function() {
        var validateFieldFunction = this.initialConfig.validateFieldFunction;

        if ( Ext.isFunction( validateFieldFunction ) ) {
            var result = this.validateWithCustomFunction();

            if ( !result.valid ) {
              this.markError();
            }
        }
    },
    adjustPreviewHeight: function() {
      var editor = this.editor;

      if ( editor.getInArray() && !Ext.isEmpty( this.array ) ) {
        var array = this.array;
        var table = array.table;

        if ( !Ext.isEmpty( table ) ) {
          var rowIndex = array.getRowIndex( this );
          table.adjustPreviewHeightForRow( rowIndex );
          return;
        }
      }

      var newPreviewHeight = this.calculateNewPreviewHeight();
      this.setPreviewHeight( newPreviewHeight );
    },
    calculateNewPreviewHeight: function() {
      var preview = this.preview;
      var labelEl = this.getLabelEl();

      if ( !Ext.isEmpty( labelEl ) ) {
        var labelElHeight = labelEl.getHeight();

        if ( labelElHeight + 2 > this.DEFAULT_PREVIEW_HEIGHT ) {
          return labelElHeight + 2;
        } else {
          return this.DEFAULT_PREVIEW_HEIGHT;
        }
      } else {
        return this.DEFAULT_PREVIEW_HEIGHT;
      }
    },
    setPreviewHeight: function( height ) {
      var preview = this.preview;
      preview.setHeight( height );
      this.ownerCt.doLayout();
      this.doLayout();
    },
    showFunctionsMenuWindow: function() {
        this.beforeShowMenuWindow();
        var position = this.getPosition();
        var fieldWidth = this.getWidth();
        var editor = this.editor;
        var win = new Ext.ux.suncode.FunctionsMenuWindow( {
            x: position[0],
            y: position[1] + 25,
            width: fieldWidth > this.OPTIONS_MENU_WINDOW_MIN_WIDTH ? fieldWidth : this.OPTIONS_MENU_WINDOW_MIN_WIDTH,
            contextVariables: this.initialConfig.contextVariables,
            processNode: this.initialConfig.processNode,
            customField: this,
            returnType: editor.getType(),
            inArray: editor.getInArray(),
            accessibility: this.initialConfig.systemFunctionsAccessibility,
            recommendations: this.initialConfig.recommendedSystemFunctions,
            previousWindow: this.initialConfig.previousWindow,
            availableVariables: this.initialConfig.availableVariables,
            validateFieldFunction: this.initialConfig.validateFieldFunction,
            validateFieldScope: this.initialConfig.validateFieldScope,
            missingVariablesValidatorFunction: this.initialConfig.missingVariablesValidatorFunction,
            missingVariablesValidatorScope: this.initialConfig.missingVariablesValidatorScope,
            listeners: {
            	scope: this,
            	show: this.onShowMenuWindow,
            	move: this.onMoveMenuWindow
            }
        } );
        win.show();
        this.menuWindow = win;
        this.functionsMenu = true;
    },
    showVariablesMenuWindow: function( id ) {
        this.beforeShowMenuWindow();
        var position = this.getPosition();
        var fieldWidth = this.getWidth();
        var editor = this.editor;
        var contextVariables = this.isVariableEditor() ? null : this.initialConfig.contextVariables;
        var win = new Ext.ux.suncode.VariablesMenuWindow( {
            x: position[0],
            y: position[1] + 25,
            width: fieldWidth > this.OPTIONS_MENU_WINDOW_MIN_WIDTH ? fieldWidth : this.OPTIONS_MENU_WINDOW_MIN_WIDTH,
            contextVariables: contextVariables,
            processNode: this.initialConfig.processNode,
            customField: this,
            variableId: id,
            variableType: editor.getType(),
            acceptTable: editor.getInArray() || this.tableVariableAllowed,
            inArray: editor.getInArray(),
            disableVariableDuplication: this.initialConfig.disableVariableDuplication,
            availableVariables: this.initialConfig.availableVariables,
            listeners: {
            	scope: this,
            	show: this.onShowMenuWindow,
            	move: this.onMoveMenuWindow
            }
        } );
        win.show();
        this.menuWindow = win;
        this.variablesMenu = true;
    },
    beforeShowMenuWindow: function() {
        this.resetMenuWindow();
    },
    onShowMenuWindow: function( win ) {
    	fitWindowToView( win, function( x ) {
			return ( Ext.getBody().getWidth() - win.getWidth() );
		}, function( y ) {
			return ( y - win.getHeight() - 25 );
		} );
    },
    onMoveMenuWindow: function( win, x, y ) {
    	this.resetMenuWindow();
        this.setCurrentValue( true );
    },
    resetMenuWindow: function() {
        if ( this.hasMenuWindow() ) {
            this.menuWindow.close();
            delete this.menuWindow;
            this.menuWindow = null;
            this.functionsMenu = false;
            this.variablesMenu = false;
        }
    },
    hasMenuWindow: function() {
        return !Ext.isEmpty( this.menuWindow );
    },
    setFunction: function( name, parameters, parameterTypes ) {
    	this.setCustomValue( this.FUNCTION_TYPE, {
            name: name,
            parameters: parameters,
            parameterTypes: parameterTypes
        } );
        this.afterSetValue();
        this.afterSetFunctionValue();
    },
    setVariable: function( id ) {
    	this.setCustomValue( this.VARIABLE_TYPE, id );
        this.afterSetValue();
        this.afterSetVariableValue();
    },
    afterSetValue: function() {
        this.switchToPreviewMode();
        if ( this.isLabeledField() ) {
            this.focusLabeledField();
        }
        this.executeOnChangeFunction( this.getFormattedValue( this.customValue, true ) );
    },
    afterSetFunctionValue: function() {
    	if ( Ext.isArray( this.columnCheckboxItems ) ) {
    		this.hideColumnCheckboxItems();
    	}
    },
    afterSetVariableValue: function() {
    	if ( this.shouldShowColumnCheckboxItems() ) {
    		this.showColumnCheckboxItems();
    	}
    },
    shouldShowColumnCheckboxItems: function() {
    	return ( Ext.isArray( this.columnCheckboxItems ) && this.columnCheckboxEnabled && this.isVariableTableValue( this.customValue ) );
    },
    afterResetValue: function() {
    	if ( Ext.isArray( this.columnCheckboxItems ) ) {
    		this.hideColumnCheckboxItems();
    	}
    },
    afterPasteValue: function( value ) {
    	if ( Ext.isArray( this.columnCheckboxItems ) ) {
	    	if ( this.columnCheckboxEnabled && this.isVariableTableValue( value ) ) {
	    		this.showColumnCheckboxItems();
	    	} else {
	    		this.hideColumnCheckboxItems();
	    	}
    	}
    },
    showColumnCheckboxItems: function() {
    	Ext.each( this.columnCheckboxItems, function( item, index, items ) {
			item.show();
		} );
    	
    	this.doLayout();
    },
    hideColumnCheckboxItems: function() {
    	Ext.each( this.columnCheckboxItems, function( item, index, items ) {
			item.hide();
			
			if ( item.getXType() === 'checkbox' ) {
				item.setValue( false );
			}
		} );
    	
    	this.doLayout();
    },
    addField: function( preventFocus ) {
        var array = this.array;

        if ( !Ext.isEmpty( array ) && Ext.isFunction( array.addField ) ) {
            array.addField( this, preventFocus );
        }
    },
    switchValueUp: function( focus ) {
      var array = this.array;

      if ( !Ext.isEmpty( array ) && Ext.isFunction( array.switchValueUp ) ) {
        array.switchValueUp( this, focus );
      }
    },
    switchValueDown: function( focus ) {
      var array = this.array;

      if ( !Ext.isEmpty( array ) && Ext.isFunction( array.switchValueDown ) ) {
        array.switchValueDown( this, focus );
      }
    },
    showSwitchValueUpMenuButton: function() {
      var button = this.getSwitchValueUpMenuButton();

      if ( !Ext.isEmpty( button ) ) {
        button.show();
      }
    },
    hideSwitchValueUpMenuButton: function() {
      var button = this.getSwitchValueUpMenuButton();

      if ( !Ext.isEmpty( button ) ) {
        button.hide();
      }
    },
    getSwitchValueUpMenuButton: function() {
      return this.switchValueUpMenuButton;
    },
    showSwitchValueDownMenuButton: function() {
      var button = this.getSwitchValueDownMenuButton();

      if ( !Ext.isEmpty( button ) ) {
        button.show();
      }
    },
    hideSwitchValueDownMenuButton: function() {
      var button = this.getSwitchValueDownMenuButton();

      if ( !Ext.isEmpty( button ) ) {
        button.hide();
      }
    },
    getSwitchValueDownMenuButton: function() {
      return this.switchValueDownMenuButton;
    },
    showAddFieldMenuButton: function() {
        var button = this.getAddFieldMenuButton();

        if ( !Ext.isEmpty( button ) ) {
            button.show();
        }
    },
    hideAddFieldMenuButton: function() {
        var button = this.getAddFieldMenuButton();

        if ( !Ext.isEmpty( button ) ) {
            button.hide();
        }
    },
    getAddFieldMenuButton: function() {
        return this.addFieldMenuButton;
    },
    showRemoveFieldMenuButton: function() {
        var button = this.getRemoveFieldMenuButton();

        if ( !Ext.isEmpty( button ) ) {
            button.show();
        }
    },
    hideRemoveFieldMenuButton: function() {
        var button = this.getRemoveFieldMenuButton();

        if ( !Ext.isEmpty( button ) ) {
            button.hide();
        }
    },
    getRemoveFieldMenuButton: function() {
        return this.removeFieldMenuButton;
    },
    removeField: function() {
        var array = this.array;

        if ( !Ext.isEmpty( array ) && Ext.isFunction( array.removeField ) ) {
            array.removeField( this );
        }
    },
    setNext: function( field ) {
        this.next = field;
    },
    setPrevious: function( field ) {
        this.previous = field;
    },
    getFieldId: function() {
        return this.initialConfig.fieldId;
    },
    getFieldName: function() {
      if ( this.inArray && !Ext.isEmpty( this.array ) ) {
        var array = this.array;

        return array.getFieldName();
      } else {
        return this.initialConfig.name;
      }
    },
    getFieldValue: function() {
    	return this.customValue;
    },
    getSimpleFieldValue: function( asString ) {
    	var customValue = this.customValue;
    	var editor = this.editor;
    	
    	if ( editor.getIsColorPicker() && this.isNonEmptyValue( customValue ) ) {
    		return customValue.value;
    	}
    	
    	var value = this.getFormattedValue( customValue, !asString );
    	
    	if ( !Ext.isEmpty( value ) && !asString ) {
    		switch ( customValue.type ) {
            	case this.VARIABLE_TYPE:
            		value = this.substringValue( value, this.VARIABLE_PREFIX );
            		break;
            	case this.FUNCTION_TYPE:
            		value = this.substringValue( value, this.FUNCTION_PREFIX );
            		break;
            	default:
            		break;
    		}
    	}
    	
    	return value;
    },
    substringValue: function( value, prefix ) {
    	var index = value.lastIndexOf( prefix );
    	
    	if ( index != -1 ) {
            return value.substring( index + 1 );
        } else {
        	return value;
        }
    },
    setFieldValue: function( value ) {
    	var editor = this.editor;
    	
    	if ( editor.getType() === this.VARIABLE_TYPE && !Ext.isEmpty( value ) ) {
    		var variable = this.getVariable( value );
    		
    		if ( Ext.isEmpty( variable ) ) {
    			return;
    		}
    	}
    	
    	this.setCustomValue( editor.getType(), value );
    	this.switchToPreviewMode();
    	this.executeOnChangeFunction( this.getFormattedValue( this.customValue, true ) );
    },
    resetFieldValue: function( silent ) {
        this.clearCustomValue();
        this.storeParentWindowAsUnsaved();
        this.switchToPreviewMode();
        this.afterResetValue();
        
        if ( !silent ) {
        	this.executeOnChangeFunction( this.getFormattedValue( this.customValue, true ) );
        }
    },
    showFieldHint: function ( hint, type ) {
      this.hideFieldHint();

      if ( !this.errorEl ) {
        var color = 'black';
        type = type || this.HINT_INFO_TYPE;

        switch ( type ) {
          case this.HINT_SUCCESS_TYPE:
            color = 'green';
            break;
          case this.HINT_ERROR_TYPE:
            color = 'red';
            break;
          default:
            break;
        }

        var fieldEl = this.getEl();
        this.errorEl = fieldEl.createChild( {
          style: 'font-size: 12px; padding: 4px; color: ' + color + ';'
        } );
        this.on( 'resize', this.alignErrorEl, this );
        this.on( 'destroy', function() {
          Ext.destroy( this.errorEl );
        }, this );
      }

      this.alignErrorEl();
      this.errorEl.update( hint );
      Ext.form.Field.msgFx[this.msgFx].show( this.errorEl, this );
    },
    hideFieldHint: function () {
      if ( this.errorEl ) {
        Ext.form.Field.msgFx[this.msgFx].hide( this.errorEl, this );
        Ext.destroy( this.errorEl );
        this.errorEl = null;
      }
    },
    validateField: function() {
      var value = this.customValue;

      if ( !( this.initialConfig.binded
          || ( !this.notEmpty && this.initialConfig.optional )
          || this.isNonEmptyValue( value ) ) ) {
        return {
          valid: false,
          errorMessage: this.buildEmptyFieldErrorMessage()
        };
      }

      var validateFieldFunction = this.initialConfig.validateFieldFunction;

      if ( Ext.isFunction( validateFieldFunction ) ) {
        var validationResult = this.validateWithCustomFunction();

        if ( validationResult.valid === false && validationResult.preventGlobalMarkError ) {
          this.markError();
        }

        return validationResult;
      } else {
        return {
          valid: true
        };
      }
    },
    validateWithCustomFunction: function() {
        var value = this.customValue;
        var validateFieldFunction = this.initialConfig.validateFieldFunction;
        var validateFieldScope = !Ext.isEmpty( this.initialConfig.validateFieldScope ) ? this.initialConfig.validateFieldScope : window;
        var fieldConfig = {
          name: this.getFieldName()
        };

        return validateFieldFunction.apply( validateFieldScope, [ fieldConfig, value ] );
    },
    isNonEmptyValue: function( value ) {
        return ( Ext.isDefined( value ) && !Ext.isEmpty( value ) && !Ext.isEmpty( value.value, true ) && value.value !== '' );
    },
    buildEmptyFieldErrorMessage: function() {
      return !Ext.isEmpty( this.initialConfig.emptyErrorMessage )
          ? this.initialConfig.emptyErrorMessage
          : getTranslation( 'Podaj wartość pola' ) + ': <b>' + this.getFieldName() + '</b>.'
    },
    isVariableTableValue: function( value, processNode ) {
    	if ( this.isNonEmptyValue( value ) && value.type === this.VARIABLE_TYPE ) {
    		var variable = this.getVariable( value.value, processNode );
    		
    		return ( !Ext.isEmpty( variable ) && variable.placement === 'table' );
    	} else {
    		return false;
    	}
    },
    focusField: function() {
        if ( this.isLabeledField() ) {
          this.focusLabeledField();
        } else {
          this.focusNonLabeledField();
        }
    },
    isLabeledField: function() {
        var value = this.customValue;
        var previewEl = this.preview.getEl();

        return ( Ext.isDefined( value ) && ( value.type == this.FUNCTION_TYPE || value.type == this.VARIABLE_TYPE ) &&
        		!Ext.isEmpty( previewEl ) && !Ext.isEmpty( previewEl.child( 'span' ) ) );
    },
    focusLabeledField: function() {
        var textEl = this.getPreviewTextEl();
        
        if ( !Ext.isEmpty( textEl ) ) {
        	textEl.focus( 100 );
        }
    },
    getPreviewTextEl: function() {
        var binded = this.binded;
        var readOnly = this.readOnly;
        var preview = this.preview;
        var previewEl = preview.getEl();
        var labelEl = ( binded || readOnly ) ? previewEl.down( '.x-Module-readOnlyCustomFieldComponentSpan' ) :
        	previewEl.down( '.x-Module-customFieldComponentSpan' );

        if ( !Ext.isEmpty( labelEl ) ) {
        	return ( binded || readOnly ) ? labelEl.down( '.x-Module-readOnlyCustomFieldComponentEdit' ) :
            	labelEl.down( '.x-Module-customFieldComponentEdit' );
        } else {
        	return null;
        }
    },
    focusNonLabeledField: function() {
        this.switchToEditionMode();
    },
    delayFunction: function( fn, delay ) {
        var task = new Ext.util.DelayedTask( fn, this );
        task.delay( delay );
        
        return task;
    },
    show: function() {
    	Ext.form.CompositeField.superclass.show.call( this );
    	this.getEl().show();
        this.doLayout();
    },
    isReadOnly: function() {
    	return this.initialConfig.readOnly;
    },
    disableField: function() {
    	var editor = this.editor;
    	
    	if ( editor.isVisible() ) {
    		this.switchToPreviewMode();
    	}
    	
        if ( !this.initialConfig.arrayInitializer ) {
        	this.removePreviewContextMenuListener();
        }
        
        Ext.each( this.getAvailableButtons(), function( button, index, buttons ) {
        	if ( !Ext.isEmpty( button ) ) {
        		button.hide();
        	}
        } );
        
        var preview = this.preview;
        var previewEl = preview.getEl();
        previewEl.addClass( 'x-Module-disabled' );
        var textEl = this.getPreviewTextEl();
        
        if ( !Ext.isEmpty( textEl ) ) {
        	this.unregisterTooltipForElement( textEl );
        }
        
        this.unregisterTooltipForPreview();
        this.isDisabled = true;
        this.doLayout();
    },
    enableField: function() {
        if ( !this.initialConfig.arrayInitializer ) {
        	this.addPreviewContextMenuListener();
        }
        
        Ext.each( this.getAvailableButtons(), function( button, index, buttons ) {
        	if ( !Ext.isEmpty( button ) ) {
        		button.show();
        	}
        } );
        
        var preview = this.preview;
        var previewEl = preview.getEl();
        previewEl.removeClass( 'x-Module-disabled' );
        var textEl = this.getPreviewTextEl();
        
        if ( !Ext.isEmpty( textEl ) && !( this.binded || this.readOnly ) ) {
        	this.registerTooltipForElement( textEl );
        }
        
        this.registerTooltipForPreview();
        this.isDisabled = false;
        this.doLayout();
    },
    getAvailableButtons: function() {
    	return [ this.colorPickerMenuButton, this.resetColorMenuButton, this.variablesMenuButton, this.functionsMenuButton,
    	         this.switchValueUpMenuButton, this.switchValueDownMenuButton, this.addFieldMenuButton, this.removeFieldMenuButton,
    	         this.preview.getEl().child( 'span.x-Module-customFieldCloseSpan' ) ];
    },
    setNotEmpty: function( notEmpty ) {
    	this.notEmpty = notEmpty;
    	
    	if ( !this.inArray ) {
    		this.setFieldLabel( this.buildFieldLabel( this.initialConfig, notEmpty ) );
    	}
    },
    hasValueOfType: function( typeOfValue, array ) {
    	var value = this.customValue;
    	
    	if ( Ext.isDefined( value ) ) {
    		var result = value.type === typeOfValue;
    		
    		if ( result && array && typeOfValue === this.VARIABLE_TYPE ) {
    			var variable = this.getVariable( value.value );
    			
    			return !Ext.isEmpty( variable ) && variable.placement === 'table';
    		} else {
    			return result;
    		}
    	} else {
    		return false;
    	}
    },
    getFunctionReturnType: function() {
    	var value = this.customValue;
    	
    	if ( Ext.isDefined( value ) && value.type === this.FUNCTION_TYPE && !Ext.isEmpty( value.value ) ) {
        var mainPanel = Ext.getCmp( 'main_panel' );
        var systemFunction = mainPanel.getSystemFunction( value.value.name, value.value.parameterTypes );

        if ( !Ext.isEmpty( systemFunction ) ) {
          return this.buildProperFunctionReturnType( systemFunction.returnType );
        } else {
          return null;
        }
    	} else {
    		return null;
    	}
    },
    getVariableType: function() {
    	var value = this.customValue;
    	
    	if ( Ext.isDefined( value ) && value.type === this.VARIABLE_TYPE ) {
    		var variable = this.getVariable( value.value );
    		
    		if ( !Ext.isEmpty( variable ) ) {
    			var typesMatrix = Ext.ux.suncode.IntegrationComponentService.VARIABLE_TYPES_MATRIX;
    			var type = typesMatrix[variable.type];
    			
    			if ( variable.placement === 'table' ) {
    				type += '[]';
            	}
    			
    			return type;
    		} else {
    			return null;
    		}
    	} else {
    		return null;
    	}
    },
    markError: function() {
    	var preview = this.preview;
        var previewEl = preview.getEl();
        previewEl.addClass( 'x-Module-errorField' );
    },
    unmarkError: function() {
    	var preview = this.preview;
        var previewEl = preview.getEl();
        
        if ( !Ext.isEmpty( previewEl ) ) {
        	previewEl.removeClass( 'x-Module-errorField' );
        }
    },
    analyzeError: function() {
    	var array = this.array;
    	
    	if ( this.inArray && !Ext.isEmpty( array ) ) {
            array.analyzeError();
        } else {
        	this.unmarkError();
        }
    },
    showType: function() {
    	this.typeVisible = true;
    	var labelEl = this.getLabelEl();
    	
    	if ( !Ext.isEmpty( labelEl ) ) {
    		var typeEl = labelEl.down( '.x-Module-customFieldTypeAbbreviationSpan' );
    		
    		if ( Ext.isEmpty( typeEl ) ) {
    			this.buildTypePreview( labelEl );
    		}
    		
    		labelEl.addClass( 'x-Module-customFieldTypeAbbreviationSpace' );
    	}
    },
    hideType: function() {
    	this.typeVisible = false;
    	var labelEl = this.getLabelEl();
    	
    	if ( !Ext.isEmpty( labelEl ) ) {
        var typeEl = labelEl.down( '.x-Module-customFieldTypeAbbreviationSpan' );

        if ( !Ext.isEmpty( typeEl ) ) {
          typeEl.remove();
        }
    		
    		labelEl.removeClass( 'x-Module-customFieldTypeAbbreviationSpace' );
    	}
    },
    prettyFormatFunction: function() {
      this.toggleFunctionPrettyFormat( true );
    },
    unformatFunction: function() {
      this.toggleFunctionPrettyFormat( false );
    },
    toggleFunctionPrettyFormat: function( prettyFormat ) {
      this.functionPrettyFormat = prettyFormat;
      var value = this.customValue;

      if ( this.isNonEmptyValue( value ) && value.type === this.FUNCTION_TYPE ) {
        var previewTextEl = this.getPreviewTextEl();

        if ( !Ext.isEmpty( previewTextEl ) ) {
          var html = Ext.util.Format.htmlEncode( this.buildFunctionPreviewText( value ) );
          previewTextEl.update( html );
        }
      }
    },
    getLabelEl: function() {
    	var labelEl = this.getVariablePreviewEl();
    	
    	if ( !Ext.isEmpty( labelEl ) ) {
    		return labelEl;
    	} else {
    		return this.getFunctionPreviewEl();
    	}
    },
    getVariablePreviewEl: function() {
    	var previewEl = this.preview.getEl();

      if ( !Ext.isEmpty( previewEl ) ) {
        return previewEl.down( '.x-Module-customFieldVariableSpan' );
      } else {
        return null;
      }
    },
    getFunctionPreviewEl: function() {
    	var previewEl = this.preview.getEl();

      if ( !Ext.isEmpty( previewEl ) ) {
        return previewEl.down('.x-Module-customFieldFunctionSpan');
      } else {
        return null;
      }
    },
    setTableVariableAllowed: function( tableVariableAllowed ) {
		this.tableVariableAllowed = tableVariableAllowed;
		var value = this.customValue;
		
		if ( !tableVariableAllowed && !this.inArray && Ext.isDefined( value ) && value.type === this.VARIABLE_TYPE ) {
			var variable = this.getVariable( value.value );
    		
    		if ( !Ext.isEmpty( variable ) && variable.placement === 'table' ) {
    			this.resetFieldValue( false );
    		}
		}
	},
	setColumnCheckboxEnabled: function( columnCheckboxEnabled ) {
		this.columnCheckboxEnabled = columnCheckboxEnabled;
		var value = this.customValue;
		
		if ( columnCheckboxEnabled ) {
			var processNode = this.initialConfig.processNode;
			
			if ( this.isVariableTableValue( this.customValue, processNode ) ) {
				this.showColumnCheckboxItems();
			}
		} else {
			if ( !Ext.isEmpty( this.customValue ) ) {
				delete this.customValue.wholeColumn;
			}

			this.hideColumnCheckboxItems();
		}
	},
	showColorPicker: function( e ) {
		closeColorChooser();

        var me = this;
        var editor = this.editor;
        var value = this.customValue;
        var colorChooser = new Ext.ux.suncode.ColorChooser( {
            title: getTranslation( 'Kolor' ),
            e: e,
            color: this.isNonEmptyValue( value ) ? value.value : '',
            saveFunction: function( color ) {
                me.setCustomValue( editor.getType(), color );
                me.afterSetValue();
            }
        } );
        colorChooser.show();
	},
	resetColor: function() {
		  var previewEl = this.preview.getEl();
    	previewEl.setStyle( 'background', '' );
      this.clearCustomValue();
      this.storeParentWindowAsUnsaved();
	},
    getComboboxApi: function() {
    	var form = null;
    	var array = this.array;

    	if ( !Ext.isEmpty( array ) ) {
    		var table = array.table;

    		if ( !Ext.isEmpty( table ) ) {
    		  return this.getComboboxApiFromComponent( table.ownerCt );
    		} else {
          return this.getComboboxApiFromComponent( array.ownerCt );
    		}
    	} else {
        return this.getComboboxApiFromComponent( this.ownerCt );
    	}

    	return null;
    },
    getComboboxApiFromComponent: function( component ) {
        while ( component && !Ext.isFunction( component.getComboboxApi ) ) {
          component = component.ownerCt;
        }

        return component.getComboboxApi( this.editor );
    }
} );

Ext.ux.suncode.ArrayCustomField = function( config ) {
    var items = new Array();
    var customValues = config.customValues;
    var customFieldDef = config.customFieldDef;
    customFieldDef = Ext.apply( customFieldDef, this.buildDefaultSubFieldConfig() );

    if ( !Ext.isEmpty( customValues ) && Ext.isArray( customValues ) ) {
        var previous = null;

        Ext.each( customValues, function( value, index, values ) {
            var conf = Ext.apply( new Object(), customFieldDef );
            conf = Ext.apply( conf, {
            	hideSwitchValueUpButton: index === 0 || customFieldDef.readOnly,
              hideSwitchValueDownButton: ( index === values.length - 1 ) || customFieldDef.readOnly,
              hideAddButton: ( index !== values.length - 1 ) || customFieldDef.readOnly,
              customValue: value
            } );

            var field = new Ext.ux.suncode.CustomField( conf );

            if ( !Ext.isEmpty( previous ) ) {
                field = Ext.apply( field, {
                    previous: previous
                } );

                previous = Ext.apply( previous, {
                    next: field
                } );
            }

            items.push( field );
            previous = field;
        } );
    } else {
    	var conf = Ext.apply( new Object(), customFieldDef );
        conf = Ext.apply( conf, {
          hideSwitchValueUpButton: false,
          hideSwitchValueDownButton: false,
        	hideAddButton: false,
        	arrayInitializer: true
        } );

        items.push( new Ext.ux.suncode.CustomField( conf ) );
    }

    config = Ext.apply( {
    	frame: false,
    	border: false,
        fieldLabel: this.buildFieldLabel( config, config.notEmpty ),
        defaults: {
            cls: 'x-Module-arrayCustomFieldItem'
        },
        isArrayField: true,
        blocked: false,
        items: items
    }, config );

    Ext.ux.suncode.ArrayCustomField.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.ArrayCustomField, Ext.Panel, {
    initComponent: function() {
        Ext.ux.suncode.ArrayCustomField.superclass.initComponent.call( this );

        this.on( 'afterrender', this.onAfterRender, this );
    },
    onAfterRender: function() {
      if ( this.initialConfig.disabled ) {
        this.disableField();
      }
    },
    buildDefaultSubFieldConfig: function() {
        return {
            array: this,
            inArray: true
        };
    },
    buildFieldLabel: function( config, notEmpty ) {
      if ( Ext.isEmpty( config.name ) ) {
        return '';
      }

      var label = config.name;

      if ( notEmpty || config.arrayMinLength > 0 ) {
        label += ' <span class="x-Module-required-field-label">*</span>';
    	}
    	
    	if ( !Ext.isEmpty( config.description ) ) {
    		return addTooltipToField( label, config.description );
    	} else {
    		return label;
    	}
    },
    switchValueUp: function( field, focus ) {
      var pos = this.getRowIndex( field );

      if ( pos > 0 ) {
        var table = this.table;

        if ( !Ext.isEmpty( table ) && Ext.isFunction( table.switchValuesUp ) ) {
          table.switchValuesUp( pos );
        } else {
          this.executeSwitchValueUp( pos );
        }

        if ( focus ) {
          field.focusNextField( true );
        }
      }
    },
    executeSwitchValueUp: function( pos ) {
      this.switchValues( pos, pos - 1 );
    },
    switchValueDown: function( field, focus ) {
      var pos = this.getRowIndex( field );

      if ( pos < this.getArraySize() - 1 ) {
        var table = this.table;

        if ( !Ext.isEmpty( table ) && Ext.isFunction( table.switchValuesDown ) ) {
          table.switchValuesDown( pos );
        } else {
          this.executeSwitchValueDown( pos );
        }

        if ( focus ) {
          field.focusNextField( false );
        }
      }
    },
    getArraySize: function() {
      return this.items.getCount();
    },
    executeSwitchValueDown: function( pos ) {
      this.switchValues( pos, pos + 1 );
    },
    addField: function( field, preventFocus ) {
      var table = this.table;
      var pos = this.getRowIndex( field );

      if ( !Ext.isEmpty( table ) && Ext.isFunction( table.addFields ) ) {
        table.addFields( pos, preventFocus );
      } else {
        this.executeAddField( pos, preventFocus );
      }

      if ( field.arrayInitializer ) {
        this.removeField( field );
      }

      if ( this.hidden ) {
        this.show();
        this.hide();
      }
    },
    executeAddField: function( pos, preventFocus ) {
      var field = this.items.itemAt( pos );

      if ( !Ext.isEmpty( field ) ) {
        var readOnly = field.isReadOnly();
        var customFieldDef = this.initialConfig.customFieldDef;
        var conf = Ext.apply( new Object(), customFieldDef );
        conf = Ext.apply( conf, this.buildDefaultSubFieldConfig() );
        conf = Ext.apply( conf, {
          hideSwitchValueUpButton: field.arrayInitializer || readOnly,
          hideSwitchValueDownButton: true,
          hideAddButton: readOnly,
          customValue: {
            type: customFieldDef.type,
            value: null
          }
        } );

        if ( !readOnly ) {
          field.showSwitchValueDownMenuButton();
          field.hideAddFieldMenuButton();
        }

        var newField = new Ext.ux.suncode.CustomField( conf );
        this.insert( pos + 1, newField );
        this.doLayout();
        this.ownerCt.doLayout();

        field.setNext( newField );
        newField.setPrevious( field );

        if ( !preventFocus ) {
          newField.focusField();
        }

        this.executeOnAddFieldFunction( pos + 1 );
      }
    },
    executeOnAddFieldFunction: function( position ) {
      var onAddFieldFunction = this.initialConfig.onAddFieldFunction;

      if ( Ext.isFunction( onAddFieldFunction ) ) {
        onAddFieldFunction.apply( this, [ position ] );
      }
    },
    addArrayInitializer: function() {
    	var customFieldDef = this.initialConfig.customFieldDef;
    	var conf = Ext.apply( new Object(), customFieldDef );
    	conf = Ext.apply( conf, this.buildDefaultSubFieldConfig() );
    	conf = Ext.apply( conf, {
          hideSwitchValueUpButton: false,
          hideSwitchValueDownButton: false,
        	hideAddButton: false,
        	arrayInitializer: true
        } );
        
        var newField = new Ext.ux.suncode.CustomField( conf );
        this.add( newField );
        this.doLayout();
        this.ownerCt.doLayout();
    },
    removeField: function( field ) {
    	var table = this.table;
    	var pos = this.getRowIndex( field );
    	
    	if ( !Ext.isEmpty( table ) && Ext.isFunction( table.removeFields ) ) {
    		table.removeFields( pos );
    	} else {
    		this.executeRemoveField( pos );
    	}
    },
    executeRemoveField: function( pos ) {
      var field = this.items.itemAt( pos );

      if ( !Ext.isEmpty( field ) ) {
        this.remove( field );
        var firstField = this.items.first();
        var lastField = this.items.last();

        if ( !Ext.isEmpty( firstField ) ) {
          firstField.hideSwitchValueUpMenuButton();
        }

        if ( !Ext.isEmpty( lastField ) ) {
          lastField.hideSwitchValueDownMenuButton();

          if ( !lastField.isReadOnly() ) {
            lastField.showAddFieldMenuButton();
          }
        }

        this.doLayout();
        this.ownerCt.doLayout();

        if ( this.items.getCount() == 0 ) {
          this.addArrayInitializer();
        } else if ( pos === this.items.getCount() ) {
          lastField.setNext( null );
        } else if ( pos === 0 ) {
          var currPosField = this.items.itemAt( pos );
          currPosField.setPrevious( null );
        } else {
          var prevPosField = this.items.itemAt( pos - 1 );
          var currPosField = this.items.itemAt( pos );
          prevPosField.setNext( currPosField );
          currPosField.setPrevious( prevPosField );
        }

        var onChangeFunction = field.onChangeFunction;

        if ( Ext.isFunction( onChangeFunction ) && !field.arrayInitializer ) {
          var onChangeOptions = this.buildFieldFunctionOptions( pos );
          onChangeFunction.apply( this, [ field.getFieldValue(), onChangeOptions ] );
        }
      }
    },
    buildFieldFunctionOptions: function( rowIndex ) {
      var options = new Object();
      options = Ext.apply( options, {
        rowIndex: rowIndex
      } );

      return options;
    },
    resetFields: function() {
    	this.items.each( function( field, index, length ) {
    		this.removeField( field );
    	}, this );
    	
    	this.doLayout();
        this.ownerCt.doLayout();
    },
    getFieldId: function() {
        return this.initialConfig.fieldId;
    },
    getFieldName: function() {
        return this.initialConfig.name;
    },
    getFieldValue: function() {
        var values = new Array();

        this.items.each( function( field ) {
        	if ( !field.arrayInitializer ) {
        		values.push( field.getFieldValue() );
        	}
        } );

        return values;
    },
    getSimpleFieldValue: function( asString ) {
        var values = new Array();

        this.items.each( function( field ) {
        	if ( !field.arrayInitializer ) {
        		values.push( field.getSimpleFieldValue( asString ) );
        	}
        } );

        return values;
    },
    setFieldValue: function( value ) {
    	if ( Ext.isArray( value ) ) {
    		Ext.each( value, function( oneValue, index, allValues ) {
    			var field = this.items.itemAt( index );
    			
    			if ( !Ext.isEmpty( field ) && !field.arrayInitializer ) {
    				field.setFieldValue( oneValue );
    			} else {
    				return false;
    			}
    		}, this );
    	} else {
    		var field = this.items.first();
    		
    		if ( !field.arrayInitializer ) {
    			field.setFieldValue( value );
    		}
    	}
    },
    resetFieldValue: function( silent ) {
    	this.items.each( function( field ) {
    		if ( Ext.isFunction( field.resetFieldValue ) ) {
    			field.resetFieldValue( silent );
    		} else {
    			field.setValue( null );
    		}
        } );
    },
    validateField: function() {
      var arrayMinLength = this.initialConfig.arrayMinLength;
      var validationResult = {
        valid: true
      };

      if ( arrayMinLength > 0 ) {
        var length = this.items.getCount();

        if ( length == 1 && this.items.first().arrayInitializer ) {
          length = 0;
        }

        if ( arrayMinLength > length ) {
          validationResult = {
            valid: false,
            errorMessage: getTranslation( 'Minimalna wymagana ilość wartości pola to' ) + ': ' + arrayMinLength
          };
        }
      } else {
        this.items.each( function( field ) {
          if ( !field.arrayInitializer || this.notEmpty ) {
            var res = field.validateField();

            if ( res.valid === false ) {
              validationResult = res;
              return false;
            }
          }
        }, this );
      }

      return validationResult;
    },
    focusField: function( reverse ) {
        var field = reverse ? this.items.last() : this.items.first();
        
        if ( field.arrayInitializer ) {
        	this.focusNextField( reverse );
        } else {
        	field.focusField( reverse );
        }
    },
    focusNextField: function( reverse ) {
        var otherField = reverse ? this.previous : this.next;

        if ( !Ext.isEmpty( otherField ) ) {
            otherField.focusField( reverse );
        }
    },
    isReadOnly: function() {
    	var customFieldDef = this.initialConfig.customFieldDef;
    	
    	return customFieldDef.readOnly;
    },
    disableField: function() {
    	this.items.each( function( field ) {
            if ( !field.arrayInitializer ) {
            	field.disableField();
            }
        } );
    },
    enableField: function() {
    	this.items.each( function( field ) {
            if ( !field.arrayInitializer ) {
            	field.enableField();
            }
        } );
    },
    setNotEmpty: function( notEmpty ) {
    	this.items.each( function( field ) {
            if ( Ext.isFunction( field.setNotEmpty ) ) {
            	field.setNotEmpty( notEmpty );
            }
        } );
    	
    	this.notEmpty = notEmpty;
    	this.initialConfig.customFieldDef.notEmpty = notEmpty;
    	this.setFieldLabel( this.buildFieldLabel( this.initialConfig, notEmpty ) );
    },
    hasValueOfType: function( typeOfValue, array, position ) {
    	var has = false;
    	
    	if ( Ext.isNumber( position ) ) {
    		var field = this.items.itemAt( position );
    		
    		if ( !Ext.isEmpty( field ) && Ext.isFunction( field.hasValueOfType ) ) {
    			has = field.hasValueOfType( typeOfValue, array );
    		}
    	} else {
    		this.items.each( function( field ) {
				if ( Ext.isFunction( field.hasValueOfType ) ) {
            		has = field.hasValueOfType( typeOfValue, array );
            		
                    if ( !has ) {
                    	return false;
                    }
				} else {
	    			has = false;
	    			return false;
	    		}
            } );
    	}
    	
    	return has;
    },
    getFunctionReturnType: function( position ) {
    	var result = null;
    	
    	if ( Ext.isNumber( position ) ) {
    		var field = this.items.itemAt( position );
    		
    		if ( !Ext.isEmpty( field ) && Ext.isFunction( field.getFunctionReturnType ) ) {
    			result = field.getFunctionReturnType();
    		}
    	} else {
    		result = new Array();
    		
    		this.items.each( function( field ) {
				if ( Ext.isFunction( field.getFunctionReturnType ) ) {
					result.push( field.getFunctionReturnType() );
				} else {
					result.push( null );
	    		}
            } );
    	}
    	
    	return result;
    },
    getVariableType: function( position ) {
    	var result = null;
    	
    	if ( Ext.isNumber( position ) ) {
    		var field = this.items.itemAt( position );
    		
    		if ( !Ext.isEmpty( field ) && Ext.isFunction( field.getVariableType ) ) {
    			result = field.getVariableType();
    		}
    	} else {
    		result = new Array();
    		
    		this.items.each( function( field ) {
				if ( Ext.isFunction( field.getVariableType ) ) {
					result.push( field.getVariableType() );
				} else {
					result.push( null );
	    		}
            } );
    	}
    	
    	return result;
    },
    markError: function( position ) {
    	if ( Ext.isNumber( position ) ) {
    		var field = this.items.itemAt( position );
    		
    		if ( !Ext.isEmpty( field ) && Ext.isFunction( field.markError ) ) {
    			field.markError();
    		}
    	} else {
    		this.items.each( function( field ) {
    			if ( Ext.isFunction( field.markError ) ) {
    				field.markError();
    			}
    		} );
    	}
    },
    unmarkError: function() {
    	this.items.each( function( field ) {
			if ( Ext.isFunction( field.unmarkError ) ) {
				field.unmarkError();
			}
        } );
    },
    showFieldHint: function( hint, type ) {
      this.items.each( function( field ) {
        if ( Ext.isFunction( field.showFieldHint ) ) {
          field.showFieldHint( hint, type );
        }
      } );
    },
    hideFieldHint: function() {
      this.items.each( function( field ) {
        if ( Ext.isFunction( field.hideFieldHint ) ) {
          field.hideFieldHint();
        }
      } );
    },
    analyzeError: function() {
    	var table = this.table;
    	
    	if ( !Ext.isEmpty( table ) ) {
    		table.analyzeError();
    	} else {
    		this.unmarkError();
    	}
    },
    showType: function() {
      this.initialConfig.customFieldDef.typeVisible = true;

      this.items.each( function( field ) {
        if ( !field.arrayInitializer ) {
          field.showType();
        }
      } );
    },
    hideType: function() {
      this.initialConfig.customFieldDef.typeVisible = false;

      this.items.each( function( field ) {
        if ( !field.arrayInitializer ) {
          field.hideType();
        }
      } );
    },
    prettyFormatFunction: function() {
      this.initialConfig.customFieldDef.functionPrettyFormat = true;

      this.items.each( function( field ) {
        if ( !field.arrayInitializer ) {
          field.prettyFormatFunction();
        }
      } );
    },
    unformatFunction: function() {
      this.initialConfig.customFieldDef.functionPrettyFormat = false;

      this.items.each( function( field ) {
        if ( !field.arrayInitializer ) {
          field.unformatFunction();
        }
      } );
    },
    setColumnCheckboxEnabled: function( columnCheckboxEnabled ) {
    	this.initialConfig.customFieldDef.columnCheckboxEnabled = columnCheckboxEnabled;
    	
    	this.items.each( function( field ) {
            if ( !field.arrayInitializer ) {
            	field.setColumnCheckboxEnabled( columnCheckboxEnabled );
            }
        } );
    },
    setBlocked: function( blocked ) {
    	this.blocked = blocked;
    	
    	if ( blocked ) {
    		this.items.each( function( field ) {
          field.hideSwitchValueUpMenuButton();
          field.hideSwitchValueDownMenuButton();
    			field.hideAddFieldMenuButton();
    			field.hideRemoveFieldMenuButton();
			} );
    	} else {
    		this.items.each( function( field, index, length ) {
          if ( index != 0 ) {
            field.showSwitchValueUpMenuButton();
          }

    			if ( index == length -1 ) {
    				field.showAddFieldMenuButton();
    			} else {
            field.showSwitchValueDownMenuButton();
          }
    			
    			field.showRemoveFieldMenuButton();
			} );
    	}
    	
    	this.doLayout();
        this.ownerCt.doLayout();
    },
    getRowIndex: function( field ) {
      return this.items.indexOf( field );
    },
    switchValues: function( firstIndex, secondIndex ) {
      var firstField = this.items.itemAt( firstIndex );
      var secondField = this.items.itemAt( secondIndex );

      if ( !Ext.isEmpty( firstField ) && !Ext.isEmpty( secondField ) ) {
        var firstFieldValue = firstField.getCustomValue();
        var secondFieldValue = secondField.getCustomValue();

        firstField.customValue = secondFieldValue;
        firstField.switchToPreviewMode();
        secondField.customValue = firstFieldValue;
        secondField.switchToPreviewMode();
      }
    },
    getComboboxApi: function() {
    	var me = this;
    	
    	return {
    		addValues: function( values ) {
    			me.items.each( function( field ) {
    				var api = field.getComboboxApi();
    				api.addValues( values );
                } );
    			
    			var comboboxConfig = me.initialConfig.customFieldDef.comboboxConfig;
    			
    			if ( this._shouldUpdateComboboxConfigValues( comboboxConfig, values ) ) {
    				values = Ext.isArray( values ) ? values : [ values ]; 
    				comboboxConfig.values = comboboxConfig.values.concat( values );
    			}
    		},
    		setValues: function( values ) {
    			me.items.each( function( field ) {
    				var api = field.getComboboxApi();
    				api.setValues( values );
                } );
    			
    			var comboboxConfig = me.initialConfig.customFieldDef.comboboxConfig;
    			
    			if ( this._shouldUpdateComboboxConfigValues( comboboxConfig, values ) ) {
    				values = Ext.isArray( values ) ? values : [ values ]; 
    				clearArray( comboboxConfig.values );
    				comboboxConfig.values = comboboxConfig.values.concat( values );
    			}
    		},
    		setUrl: function( url ) {
    			me.items.each( function( field ) {
    				var api = field.getComboboxApi();
    				api.setUrl( url );
                } );
    			
    			var comboboxConfig = me.initialConfig.customFieldDef.comboboxConfig;
    			
    			if ( this._shouldUpdateComboboxConfigUrl( comboboxConfig, url ) ) {
    				comboboxConfig.url = url;
    			}
    		},
    		setForceSelection: function( forceSelection ) {
    			me.items.each( function( field ) {
    				var api = field.getComboboxApi();
    				api.setForceSelection( forceSelection );
                } );
    			
    			var comboboxConfig = me.initialConfig.customFieldDef.comboboxConfig;
    			comboboxConfig.forceSelection = forceSelection;
    		},
    		_shouldUpdateComboboxConfigValues: function( comboboxConfig, values ) {
    			return ( Ext.isArray( values ) || Ext.isObject( values ) ) && !Ext.isEmpty( comboboxConfig )
    				&& !Ext.isEmpty( comboboxConfig.values ) && !comboboxConfig.remote;
    		},
    		_shouldUpdateComboboxConfigUrl: function( comboboxConfig, url ) {
    			return Ext.isString( url ) && !Ext.isEmpty( comboboxConfig ) && comboboxConfig.remote;
    		}
    	}
    }
} );

Ext.ux.suncode.TableCustomField = function( config ) {
	var items = new Array();
	var fields = config.fields;
	
	if ( !Ext.isEmpty( fields ) ) {
		Ext.each( fields, function( field, index, allFields ) {
			field = Ext.apply( field, {
				table: this
			} );
			
			items.push( {
				xtype: 'panel',
				frame: false,
		    	border: false,
		    	labelAlign: 'top',
		    	layout: 'form',
		    	cls: 'x-Module-customFieldPadding',
		    	columnWidth: 1/fields.length,
		    	items: [ field ]
			} );
		}, this );
	}
	
    config = Ext.apply( {
    	frame: false,
    	border: false,
    	layout: 'column',
    	isTableField: true,
    	blocked: false,
    	items: items
    }, config );

    Ext.ux.suncode.TableCustomField.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.TableCustomField, Ext.Panel, {
    initComponent: function() {
        Ext.ux.suncode.TableCustomField.superclass.initComponent.call( this );
        
        this.on( 'afterrender', this.onAfterRender, this );
    },
    DEFAULT_PREVIEW_HEIGHT: 42,
    GREATEST_PREVIEW_HEIGHT_LIMIT: 1000,
    previewHeightAdjustmentBlocked: true,
    onAfterRender: function() {
    	this.hideMenuButtons();

      if ( this.initialConfig.disabled ) {
        this.disableField();
      }
    },
    getFieldId: function() {
    	return this.initialConfig.tableId;
    },
    switchValuesUp: function( position ) {
      this.items.each( function( panel, index, length ) {
        var array = panel.items.first();
        array.executeSwitchValueUp( position );
      }, this );
    },
    switchValuesDown: function( position ) {
      this.items.each( function( panel, index, length ) {
        var array = panel.items.first();
        array.executeSwitchValueDown( position );
      }, this );
    },
    addFields: function( position, preventFocus ) {
    	this.items.each( function( panel, index, length ) {
    		var array = panel.items.first();
    		array.executeAddField( position, preventFocus );
    	}, this );
    	
    	this.hideMenuButtons();
      this.setMenuButtonsVisibility();
    	this.recalculateWidths();
    },
    removeFields: function( position ) {
    	this.items.each( function( panel, index, length ) {
    		var array = panel.items.first();
    		array.executeRemoveField( position );
    	}, this );
    	
    	this.hideMenuButtons();
      this.setMenuButtonsVisibility();
    },
    hideMenuButtons: function() {
    	this.items.each( function( panel, index, length ) {
    		var stopIndex = this.blocked ? length : length - 1;
    		
    		if ( index < stopIndex ) {
          var array = panel.items.first();

    			array.items.each( function( arrayItem ) {
            arrayItem.hideSwitchValueUpMenuButton();
            arrayItem.hideSwitchValueDownMenuButton();
    				arrayItem.hideAddFieldMenuButton();
    				arrayItem.hideRemoveFieldMenuButton();
    			} );
    		}
    	}, this );
    	
    	this.doLayout();
      this.ownerCt.doLayout();
    },
    resetFieldValue: function( silent ) {
    	this.items.each( function( panel ) {
    		var array = panel.items.first();
    		
    		array.resetFieldValue( silent );
    	} );
    },
    getParametersValues: function() {
    	var values = new Object();
    	
    	this.items.each( function( panel ) {
    		var array = panel.items.first();
    		
            if ( array.isParameterField ) {
            	var id = array.getFieldId();
                var value = array.getFieldValue();

                values[id] = value;
            }
    	} );
    	
    	return values;
    },
    getParametersValuesAsArray: function() {
    	var values = new Array();
    	
    	this.items.each( function( panel ) {
    		var array = panel.items.first();
    		
            if ( array.isParameterField ) {
                values.push( array.getFieldValue() );
            }
    	} );
    	
    	return values;
    },
    validateField: function() {
        var validationResult = {
          valid: true
        };

        this.items.each( function( panel ) {
          var array = panel.items.first();
          var res = array.validateField();

          if ( res.valid === false ) {
            if ( !res.preventGlobalMarkError ) {
              array.markError();
            }

            showWarn( res.errorMessage );
            validationResult = res;
            return false;
          }
        } );

        return validationResult;
    },
    hasField: function( fieldId ) {
    	var has = false;
    	
    	this.items.each( function( panel ) {
    		var array = panel.items.first();
    		
    		if ( Ext.isFunction( array.getFieldId ) && array.getFieldId() === fieldId ) {
    			has = true;
                return false;
            }
    	} );
    	
    	return has;
    },
    getFieldPosition: function( fieldId ) {
    	var position = -1;
    	
    	Ext.each( this.items.items, function( panel, index, panels ) {
    		var array = panel.items.first();
    		
    		if ( Ext.isFunction( array.getFieldId ) && array.getFieldId() === fieldId ) {
    			position = index;
                return false;
            }
        } );
    	
    	return position;
    },
    getField: function( fieldId ) {
    	var field = null;
    	
    	this.items.each( function( panel ) {
    		var array = panel.items.first();
    		
    		if ( Ext.isFunction( array.getFieldId ) && array.getFieldId() === fieldId ) {
            	field = array;
                return false;
            }
    	} );
    	
    	return field;
    },
    getArraySize: function() {
    	if ( this.items.getCount() > 0 ) {
    		var panel = this.items.first();
    		var array = panel.items.first();
        	
        	return array.items.getCount();
    	} else {
    		return 0;
    	}
    },
    focusField: function( reverse ) {
    	if ( this.items.getCount() > 0 ) {
    		var panel = reverse ? this.items.last() : this.items.first();
            var array = panel.items.first();
            array.focusField( reverse );
    	}
    },
    isReadOnly: function() {
    	var fields = this.initialConfig.fields;
    	var readOnly = true;
    	
    	if ( !Ext.isEmpty( fields ) ) {
    		Ext.each( fields, function( field, index, allFields ) {
    			var customFieldDef = field.customFieldDef;
    	    	
    			if ( !customFieldDef.readOnly ) {
    				readOnly = false;
    				return false;
    			}
    		} );
    	}
    	
    	return readOnly;
    },
    getArrayFieldAtPos: function( position ) {
    	var wrapper = this.items.first();
		var array = wrapper.items.first();
		position = !Ext.isEmpty( position ) ? position : array.items.getCount() - 1;
		
		return array.items.itemAt( position );
    },
    getArray: function( fieldId ) {
    	var array = null;
    	
    	this.items.each( function( panel ) {
    		var currentArray = panel.items.first();
    		
    		if ( currentArray.getFieldId() === fieldId ) {
    			array = currentArray;
    			return false;
    		}
    	}, this );
    	
    	return array;
    },
    disableField: function() {
    	this.items.each( function( panel ) {
    		var array = panel.items.first();
    		array.disableField();
    	} );
    },
    enableField: function() {
    	this.items.each( function( panel ) {
    		var array = panel.items.first();
    		array.enableField();
    	} );
    },
    recalculateWidths: function() {
    	var fieldSpace = 2;
    	var itemsCount = this.getVisibleItemsCount();
    	var width = Math.floor( ( this.getWidth() - ( itemsCount - 1 ) * fieldSpace ) / itemsCount ) - 1;
    	this.setVisibleItemsWidth( width );
    },
    getVisibleItemsCount: function() {
    	var itemsCount = 0;
    	
    	this.items.each( function( item ) {
			if ( !item.hidden ) {
				itemsCount++;
			}
		} );
    	
    	return itemsCount;
    },
    setVisibleItemsWidth: function( width ) {
    	this.items.each( function( item ) {
			if ( !item.hidden ) {
				item.setWidth( width );
			}
		} );
    },
    setBlocked: function( blocked ) {
    	this.blocked = blocked;
    	var array = this.getLastArray();
    	
    	if ( Ext.isFunction( array.setBlocked ) ) {
			array.setBlocked( blocked );
			
			this.doLayout();
            this.ownerCt.doLayout();
        }
    },
    getLastArray: function() {
    	var panel = this.items.last();
    	
		return panel.items.first();
    },
    setNotEmpty: function( notEmpty ) {
    	this.items.each( function( panel ) {
    		var array = panel.items.first();
    		
    		if ( Ext.isFunction( array.setNotEmpty ) ) {
    			array.setNotEmpty( notEmpty );
            }
    	} );
    },
    hasValueOfType: function( typeOfValue, array, position ) {
    	var has = false;
    	
    	this.items.each( function( panel ) {
    		var array = panel.items.first();
    		
    		if ( Ext.isFunction( array.hasValueOfType ) ) {
    			has = array.hasValueOfType( typeOfValue, array, position );
        		
                if ( !has ) {
                	return false;
                }
    		} else {
    			has = false;
    			return false;
    		}
        } );
    	
    	return has;
    },
    markError: function( position ) {
    	this.items.each( function( panel ) {
    		var array = panel.items.first();
    		
    		if ( Ext.isFunction( array.markError ) ) {
    			array.markError( position );
    		}
        } );
    },
    unmarkError: function( position ) {
    	this.items.each( function( panel ) {
    		var array = panel.items.first();
    		
    		if ( Ext.isFunction( array.unmarkError ) ) {
    			array.unmarkError();
    		}
        } );
    },
    showFieldHint: function( hint, type ) {
      this.items.each( function( panel ) {
        var array = panel.items.first();

        if ( Ext.isFunction( array.showFieldHint ) ) {
          array.showFieldHint( hint, type );
        }
      } );
    },
    hideFieldHint: function( position ) {
      this.items.each( function( panel ) {
        var array = panel.items.first();

        if ( Ext.isFunction( array.hideFieldHint ) ) {
          array.hideFieldHint();
        }
      } );
    },
    analyzeError: function() {
    	this.unmarkError();
    },
    showType: function() {
    	this.items.each( function( panel ) {
    		var array = panel.items.first();
    		array.showType();
    	} );
    },
    hideType: function() {
    	this.items.each( function( panel ) {
    		var array = panel.items.first();
    		array.hideType();
    	} );
    },
    prettyFormatFunction: function() {
      this.items.each( function( panel ) {
        var array = panel.items.first();
        array.prettyFormatFunction();
      } );
    },
    unformatFunction: function() {
      this.items.each( function( panel ) {
        var array = panel.items.first();
        array.unformatFunction();
      } );
    },
    setColumnCheckboxEnabled: function( columnCheckboxEnabled ) {
    	this.items.each( function( panel ) {
    		var array = panel.items.first();
    		array.setColumnCheckboxEnabled( columnCheckboxEnabled );
    	} );
    },
    rebuildFieldDefinition: function( definition ) {
      if ( Ext.isEmpty( definition ) ) {
        return new Object();
      } else if ( Ext.isString( definition ) ) {
        return {
          id: definition
        };
      } else {
        return definition;
      }
    },
    setMenuButtonsVisibility: function() {
      var firstVisibleFound = false;

      for ( var i = this.items.items.length - 1; i >= 0; i-- ) {
        var field = this.items.itemAt( i );

        if ( field.isVisible() ) {
          if ( firstVisibleFound ) {
            var arrayField = field.items.first();
            arrayField.items.each( function( item, index, length ) {
              if ( index != 0 ) {
                item.hideSwitchValueUpMenuButton();
              }

              if ( index == length -1 ) {
                item.hideAddFieldMenuButton();
              } else {
                item.hideSwitchValueDownMenuButton();
              }

              item.hideRemoveFieldMenuButton();
            } );
          } else {
            firstVisibleFound = true;
            var arrayField = field.items.first();
            arrayField.items.each( function( item, index, length ) {
              if ( index != 0 ) {
                item.showSwitchValueUpMenuButton();
              }

              if ( index == length -1 ) {
                item.showAddFieldMenuButton();
              } else {
                item.showSwitchValueDownMenuButton();
              }

              item.showRemoveFieldMenuButton();
            } );
          }
        }
      }

      if ( firstVisibleFound ) {
        this.doLayout();
        this.ownerCt.doLayout();
      }
    },
    adjustPreviewHeights: function() {
        for ( var i = 0; i < this.getArraySize(); i++ ) {
          this.adjustPreviewHeightForRow( i );
        }
    },
    adjustPreviewHeightForRow: function( rowIndex ) {
      if ( !this.previewHeightAdjustmentBlocked ) {
        var greatestHeight = this.calculatePreviewGreatestHeight(rowIndex);
        var loopCounter = 0;

        while (greatestHeight > this.GREATEST_PREVIEW_HEIGHT_LIMIT) {
          sleep(100);
          greatestHeight = this.calculatePreviewGreatestHeight(rowIndex);
          loopCounter++;

          if ( loopCounter > 3 ) {
            greatestHeight = 0;
            break;
          }
        }

        if (greatestHeight != 0) {
          this.items.each(function (panel, index, length) {
            var array = panel.items.first();
            var rowField = array.items.itemAt(rowIndex);

            if (!Ext.isEmpty(rowField)) {
              rowField.setPreviewHeight(greatestHeight);
            }
          }, this);
        }
      }
    },
    calculatePreviewGreatestHeight: function( rowIndex ) {
      var greatestHeight = 0;

      this.items.each( function( panel, index, length ) {
        var array = panel.items.first();
        var rowField = array.items.itemAt( rowIndex );

        if ( !Ext.isEmpty( rowField ) ) {
          var rowFieldNewPreviewHeight = rowField.calculateNewPreviewHeight();

          if ( greatestHeight < rowFieldNewPreviewHeight ) {
            greatestHeight = rowFieldNewPreviewHeight;
          }
        }
      }, this );

      return greatestHeight;
    },
    getApiVersion2: function() {
    	var me = this;
    	
    	return {
    		addField: function( definition, position ) {
    			definition = me.rebuildFieldDefinition( definition );
    			position = !Ext.isEmpty( position ) ? position : me.items.getCount();
    			var listeners = definition.listeners;
    			definition = Ext.apply( definition, {
    				array: true,
    				text: definition.name,
    				notEmpty: Ext.isDefined( definition.notEmpty ) ? definition.notEmpty : me.notEmpty,
            onAfterRender: !Ext.isEmpty( listeners ) ? listeners.afterrender : null,
    				onChange: !Ext.isEmpty( listeners ) ? listeners.change : null,
    	    	    onBlur: !Ext.isEmpty( listeners ) ? listeners.blur : null,
    	    		onAddField: !Ext.isEmpty( listeners ) ? listeners.addfield : null
    			} );
    			this._applyArrayFields( definition, position );
    		},
    		addCombobox: function( definition, position ) {
    			definition = !Ext.isEmpty( definition ) ? definition : new Object();
    			position = !Ext.isEmpty( position ) ? position : me.items.getCount();
    			var listeners = definition.listeners;
    			var remote = definition.remote;
    			var sort = new Object();
    			if ( Ext.isArray( definition.sort ) && !Ext.isEmpty( definition.sort ) ) {
    				var sortInfo = definition.sort[0];
    				sort = Ext.apply( sort, {
    					field: sortInfo.property,
						direction: sortInfo.direction
    				} );
    			} else if ( Ext.isObject( definition.sort ) ) {
    				var sortInfo = definition.sort;
    				sort = Ext.apply( sort, {
    					field: sortInfo.property,
						direction: sortInfo.direction
    				} );
    			}
    			definition = Ext.apply( definition, {
    				isArrayCombobox: true,
    				text: definition.name,
    				notEmpty: Ext.isDefined( definition.notEmpty ) ? definition.notEmpty : me.notEmpty,
    				remote: !Ext.isEmpty( remote ),
    				url: !Ext.isEmpty( remote ) ? remote.url : null,
    				fields: !Ext.isEmpty( remote ) ? remote.fields : null,
    				remoteSort: !Ext.isEmpty( remote ) ? remote.remoteSort : null,
    				pageSize: !Ext.isEmpty( remote ) ? remote.pageSize : null,
    				sort: sort,
            onAfterRender: !Ext.isEmpty( listeners ) ? listeners.afterrender : null,
    				onChange: !Ext.isEmpty( listeners ) ? listeners.change : null,
    	    	    onBlur: !Ext.isEmpty( listeners ) ? listeners.blur : null,
    	    	    onSelect: !Ext.isEmpty( listeners ) ? listeners.select : null,
    	    		onAddField: !Ext.isEmpty( listeners ) ? listeners.addfield : null
    			} );
    			var fields = this._applyArrayFields( definition, position );
    			
    			return this.getComboboxApi( fields );
    		},
    		_applyArrayFields: function( definition, position ) {
    			var owner = me.ownerCt;
    			var fields = owner.getArrayFields( [ definition ] );
    			
    			if ( !Ext.isEmpty( fields ) ) {
					Ext.each( fields, function( field, index, allFields ) {
						field = Ext.apply( field, {
							table: me
						} );
						
						me.insert( position, new Ext.Panel( {
							layout: 'form',
							frame: false,
					    	border: false,
					    	labelAlign: 'top',
					    	hidden: definition.hidden,
					    	cls: 'x-Module-customFieldPadding',
							items: [ field ]
						} ) );
						
						owner.bindPreviousNextOnInsert( field );
						
						if ( field.binded ) {
							me.blocked = true;
						}
					} );
					
					var maxLength = 0;
					var noArrayInitializer = false;
					
					me.items.each( function( item ) {
						var array = item.items.first();
						
						if ( !Ext.isEmpty( array ) ) {
							var currentLength = array.items.getCount();
							var firstField = array.items.first();
							
							if ( maxLength < currentLength) {
								maxLength = currentLength;
							}
							
							if ( !Ext.isEmpty( firstField ) && !firstField.arrayInitializer ) {
								noArrayInitializer = true;
							}
						}
					} );
					
					me.items.each( function( item ) {
						var array = item.items.first();
						
						if ( !Ext.isEmpty( array ) ) {
							var currentLength = array.items.getCount();
							
							for ( var i = currentLength; i < maxLength; i++ ) {
								array.executeAddField( i - 1 );
							}
							
							var firstItem = array.items.first();
							
							if ( !Ext.isEmpty( firstItem ) && firstItem.arrayInitializer && noArrayInitializer ) {
								array.executeAddField( array.items.getCount() - 1 );
								array.executeRemoveField( 0 );
							}
						}
					} );
					
					me.hideMenuButtons();
					
					var task = new Ext.util.DelayedTask( me.recalculateWidths, me );
        	        task.delay( 1 );
    			}
    			
    			return fields;
    		},
    		addRow: function( values, position ) {
    			var field = me.getArrayFieldAtPos( position );
    			
    			if ( !Ext.isEmpty( field ) ) {
    				field.addField( true );
        			
        			if ( Ext.isArray( values ) ) {
        				Ext.each( values, function( value, index, allValues ) {
        					var array = me.getArray( value.id );
        					
        					if ( !Ext.isEmpty( array ) ) {
        						var arrayOwner = array.ownerCt;
        						if ( arrayOwner.hidden ) {
        							arrayOwner.show();
        							arrayOwner.hide();
        							arrayOwner.doLayout();
        	    				}
        						if ( array.hidden ) {
        							array.show();
        							array.hide();
        	    				}
        						
        						position = !Ext.isEmpty( position ) ? position : array.items.getCount() - 1;
        						var field = array.items.itemAt( position );
        						field.setFieldValue( value.value );
        						field.doLayout();
        						array.doLayout();
        					}
        				} );
        			}
        			
        			me.recalculateWidths();
    			}
    		},
    		removeRow: function( position ) {
    			var field = me.getArrayFieldAtPos( position );
    			field.removeField();
    		},
    		clear: function() {
    			me.items.each( function( panel ) {
    	    		var array = panel.items.first();
    	    		array.resetFields();
    	    	}, this );
    			me.hideMenuButtons();
    		},
    		addColorPicker: function( definition, position ) {
    			definition = me.rebuildFieldDefinition( definition );
    			position = !Ext.isEmpty( position ) ? position : me.items.getCount();
    			var listeners = definition.listeners;
    			definition = Ext.apply( definition, {
    				array: true,
    				isColorPicker: true,
            onAfterRender: !Ext.isEmpty( listeners ) ? listeners.afterrender : null,
    				onChange: !Ext.isEmpty( listeners ) ? listeners.change : null,
    				onBlur: !Ext.isEmpty( listeners ) ? listeners.blur : null
    			} );
    			this._applyArrayFields( definition, position );
    		},
    		getComboboxApi: function( fields ) {
    			var me = this;
    	    	
    	    	return {
    	    		addValues: function( values ) {
    	    			if ( !Ext.isEmpty( fields ) ) {
    	    				Ext.each( fields, function( array, index, arrays ) {
        	    				var api = array.getComboboxApi();
        	    				api.addValues( values );
        	    			} );
    	    			}
    	    		},
    	    		setValues: function( values ) {
    	    			if ( !Ext.isEmpty( fields ) ) {
    	    				Ext.each( fields, function( array, index, arrays ) {
        	    				var api = array.getComboboxApi();
        	    				api.setValues( values );
        	    			} );
    	    			}
    	    		},
    	    		setUrl: function( url ) {
    	    			if ( !Ext.isEmpty( fields ) ) {
    	    				Ext.each( fields, function( array, index, arrays ) {
        	    				var api = array.getComboboxApi();
        	    				api.setUrl( url );
        	    			} );
    	    			}
    	    		},
    	    		setForceSelection: function( forceSelection ) {
    	    			if ( !Ext.isEmpty( fields ) ) {
    	    				Ext.each( fields, function( array, index, arrays ) {
        	    				var api = array.getComboboxApi();
        	    				api.setForceSelection( forceSelection );
        	    			} );
    	    			}
    	    		}
    	    	}
    	    }
    	};
    }
} );