Ext.ux.suncode.CompatibilityModeService = {
	defaultModeId: 2,
	modes: {
		mode1: {
			id: 1,
			name: '1.0',
			getId: function() {
				return this.id;
			},
			getName: function() {
				return this.name;
			},
			showActivityAdditionalsDefaultSettings: function( param ) {
				return true;
			},
			showActivityAdditionalsCheckAppendices: function( param ) {
				return true;
			},
			showActivityAdditionalsAdditionalJsChecks: function( param ) {
				return true;
			},
			showAcceptButtonJsAction: function( param ) {
				return true;
			},
			showAcceptButtonDcIncludes: function( param ) {
				return true;
			},
			showAcceptButtonDcExcludes: function( param ) {
				return true;
			},
			showAcceptButtonOldValidators: function( param ) {
				return true;
			},
			showAcceptButtonOldVariablesSetters: function( param ) {
				return true;
			},
			showVariableSetLocal: function( param ) {
				return true;
			},
			showVariableSetActions: function( param ) {
				return true;
			},
			showFormVariableActions: function( param ) {
				return true;
			},
			showGeneratePdfButton: function( param ) {
				return true;
			},
			showExportJs: function( param ) {
				return true;
			},
			showExportJavaCode: function( param ) {
				return true;
			},
			showLoadJavaCodeToSystem: function( param ) {
				return true;
			},
			showJavaCodeWindow: function( param ) {
				return true;
			},
			showDtButtonHandler: function( param ) {
			  return true;
      },
			showDeprecatedSystemFunctions: function( param ) {
				return true;
			},
			showListboxVariableInitializedOption: function( param ) {
				return true;
			},
      showWebServiceApplicationType: function( param ) {
        return true;
      }
		},
		mode2: {
			id: 2,
			name: '2.0',
			getId: function() {
				return this.id;
			},
			getName: function() {
				return this.name;
			},
			showActivityAdditionalsDefaultSettings: function( param ) {
				return !Ext.isEmpty( param );
			},
			showActivityAdditionalsCheckAppendices: function( param ) {
				return !Ext.isEmpty( param );
			},
			showActivityAdditionalsAdditionalJsChecks: function( param ) {
				return !Ext.isEmpty( param );
			},
			showAcceptButtonJsAction: function( param ) {
				return !Ext.isEmpty( param );
			},
			showAcceptButtonDcIncludes: function( param ) {
				return true;
			},
			showAcceptButtonDcExcludes: function( param ) {
				return true;
			},
			showAcceptButtonOldValidators: function( param ) {
				return !Ext.isEmpty( param );
			},
			showAcceptButtonOldVariablesSetters: function( param ) {
				return !Ext.isEmpty( param );
			},
			showVariableSetLocal: function( param ) {
				return param !== 'DEFAULT';
			},
			showVariableSetActions: function( param ) {
				return !Ext.isEmpty( param );
			},
			showFormVariableActions: function( param ) {
				return !Ext.isEmpty( param );
			},
			showGeneratePdfButton: function( param ) {
				return false;
			},
			showExportJs: function( param ) {
				return param;
			},
			showExportJavaCode: function( param ) {
				return param;
			},
			showLoadJavaCodeToSystem: function( param ) {
				return false;
			},
			showJavaCodeWindow: function( param ) {
				return param;
			},
			showDtButtonHandler: function( param ) {
        return !Ext.isEmpty(param);
      },
			showDeprecatedSystemFunctions: function( param ) {
				return false;
			},
			showListboxVariableInitializedOption: function( param ) {
				return param === 'LISTBOX_NO_LAZY' || param === 'LISTBOX_NO_FILTER_NO_LAZY';
			},
      showWebServiceApplicationType: function( param ) {
        return param === 'org.enhydra.shark.toolagent.SOAPToolAgent';
      }
		}
	},
	getModes: function() {
		return [ this.modes.mode1, this.modes.mode2 ];
	},
	getMode: function( id ) {
		return this.modes['mode' + id];
	},
	getDefaultModeId: function() {
		return this.defaultModeId;
	}
};