/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.web.support.dto.acceptvalidator.builder;

import com.plusmpm.i18n.I18NCustom;
import com.suncode.plugin.pwe.web.support.dto.acceptvalidator.AcceptValidatorParameterDefinitionDto;
import com.suncode.pwfl.form.stereotype.CustomValidator;
import com.suncode.pwfl.i18n.MessageHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Component;

@Component
public class AcceptValidatorParameterDefinitionDtoBuilder {
    public List<AcceptValidatorParameterDefinitionDto> build(CustomValidator validator) {
        ArrayList<AcceptValidatorParameterDefinitionDto> dtos = new ArrayList<AcceptValidatorParameterDefinitionDto>();
        if (ArrayUtils.isNotEmpty((Object[])validator.parameters())) {
            CustomValidator.Translator translator = validator.translator();
            Locale locale = LocaleContextHolder.getLocale();
            for (String parameter : validator.parameters()) {
                dtos.add(this.build(parameter, translator, locale));
            }
        }
        return dtos;
    }

    private AcceptValidatorParameterDefinitionDto build(String parameter, CustomValidator.Translator translator, Locale locale) {
        AcceptValidatorParameterDefinitionDto dto = new AcceptValidatorParameterDefinitionDto();
        dto.setDescription(this.translateText(parameter, translator, locale));
        return dto;
    }

    private String translateText(String text, CustomValidator.Translator translator, Locale locale) {
        switch (translator) {
            case I18N: {
                return MessageHelper.getOptionalMessage((String)text, (Locale)locale, (Object[])new Object[0]);
            }
            case I18NCUSTOM: {
                I18NCustom i18nCustom = new I18NCustom(locale);
                return i18nCustom.getString(text);
            }
        }
        return text;
    }
}

