/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public final class FormTemplateUtils {
    private static final String CHARSET_NAME = "UTF-8";
    private static final String INDENT_AMOUNT = "4";

    public static Document getAsXml(File file) throws Exception {
        try (FileInputStream inputStream = new FileInputStream(file);){
            Document document = FormTemplateUtils.getAsXml(inputStream);
            return document;
        }
    }

    private static Document getAsXml(InputStream inputStream) throws Exception {
        try (InputStreamReader inputStreamReader = new InputStreamReader(inputStream, CHARSET_NAME);){
            InputSource inputSource = new InputSource(inputStreamReader);
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(inputSource);
            document.normalize();
            Document document2 = document;
            return document2;
        }
    }

    public static void saveAsXml(File file, Document document) throws Exception {
        try (FileOutputStream outputStream = new FileOutputStream(file);){
            IOUtils.write((byte[])FormTemplateUtils.convertToBytes(document), (OutputStream)outputStream);
        }
    }

    private static byte[] convertToBytes(Document document) throws TransformerException {
        DOMSource source = new DOMSource(document);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        StreamResult result = new StreamResult(outputStream);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("standalone", "no");
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", INDENT_AMOUNT);
        transformer.transform(source, result);
        return outputStream.toByteArray();
    }

    public static List<Element> convertToElementsList(NodeList nodeList) {
        ArrayList<Element> elements = new ArrayList<Element>();
        if (FormTemplateUtils.hasElements(nodeList)) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (!FormTemplateUtils.isElement(node)) continue;
                Element element = (Element)node;
                elements.add(element);
            }
        }
        return elements;
    }

    public static boolean hasElements(NodeList nodeList) {
        return nodeList != null && nodeList.getLength() > 0;
    }

    public static boolean isElement(Node node) {
        return node != null && node instanceof Element;
    }

    public static void clearElement(Element element) {
        FormTemplateUtils.convertToNodesList(element.getChildNodes()).forEach(node -> FormTemplateUtils.clearElement(element, node));
    }

    private static List<Node> convertToNodesList(NodeList nodeList) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        if (FormTemplateUtils.hasElements(nodeList)) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                nodes.add(node);
            }
        }
        return nodes;
    }

    private static void clearElement(Element element, Node node) {
        if (node.getNodeType() == 3) {
            String nodeValue = StringUtils.replaceAll((String)node.getNodeValue(), (String)"\n", (String)"");
            nodeValue = StringUtils.replaceAll((String)nodeValue, (String)"\r", (String)"");
            if (StringUtils.isEmpty((CharSequence)(nodeValue = StringUtils.trim((String)nodeValue)))) {
                element.removeChild(node);
            }
        }
    }

    private FormTemplateUtils() {
    }
}

