/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.service.template;

import com.plusmpm.util.CoreTools;
import com.suncode.plugin.pwe.service.plugin.PluginService;
import com.suncode.plugin.pwe.util.JavaCodeType;
import com.suncode.plugin.pwe.util.PweUtils;
import com.suncode.plugin.pwe.web.support.dto.javacode.JavaCodeOptionsDto;
import com.suncode.plugin.pwe.web.support.form.JavaCodeForm;
import java.util.Date;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Service;

@Service
public class JavaCodeTemplateService {
    public static Logger log = Logger.getLogger(JavaCodeTemplateService.class);
    private static final String ENTER = System.getProperty("line.separator");
    private static final String EMPTY_LOCATION_PREFIX = "/templates/java/empty/";
    private static final String TEMPLATE_LOCATION_PREFIX = "/templates/java/";
    private static final String CLASS_NAME_TAG = "@BPMN_JAVA_CLASS_NAME_TAG@";
    private static final String AUTHOR_TAG = "@BPMN_JAVA_CLASS_AUTHOR_TAG@";
    private static final String DATE_TAG = "@BPMN_JAVA_CLASS_DATE_TAG@";
    private static final String PARAMETERS_TAG = "@BPMN_JAVA_CLASS_PARAMS_TAG@";
    private static final String DC_MAPPINGS_TAG = "@BPMN_JAVA_CLASS_DCMAPPINGS_TAG@";
    private static final String TAB = "\t";
    @Autowired
    private PluginService pluginService;

    public String generateEmptySourceCode(String userId, JavaCodeForm form) {
        JavaCodeType javaCodeType = JavaCodeType.getByName(form.getSourceCodeType());
        String location = this.buildEmptyTemplateLocation(javaCodeType);
        String sourceCode = this.getSourceCode(location);
        return this.fillSourceCode(userId, form, sourceCode);
    }

    private String getSourceCode(String location) {
        Resource resource = this.pluginService.getResource(location);
        return PweUtils.readResourceAsString(resource);
    }

    private String buildEmptyTemplateLocation(JavaCodeType javaCodeType) {
        StringBuilder location = new StringBuilder();
        location.append(EMPTY_LOCATION_PREFIX);
        location.append(PweUtils.getLanguage());
        location.append("/");
        location.append(javaCodeType.getEmptyTemplateFileName());
        return location.toString();
    }

    private String fillSourceCode(String userId, JavaCodeForm form, String sourceCode) {
        String filledSourceCode = new String(sourceCode);
        filledSourceCode = this.setPackageAndClassName(form.getQualifiedName(), filledSourceCode);
        filledSourceCode = this.setAuthor(userId, filledSourceCode);
        filledSourceCode = this.setCreationDate(filledSourceCode);
        filledSourceCode = this.setParameters(form.getOptions(), filledSourceCode);
        filledSourceCode = this.setDcMappings(form.getOptions(), filledSourceCode);
        return filledSourceCode;
    }

    private String setPackageAndClassName(String qualifiedName, String sourceCode) {
        int lastDotPos = StringUtils.lastIndexOf((CharSequence)qualifiedName, (CharSequence)".");
        if (lastDotPos != -1) {
            StringBuilder text = new StringBuilder();
            text.append("package ");
            text.append(StringUtils.substring((String)qualifiedName, (int)0, (int)lastDotPos));
            text.append(";");
            text.append(ENTER);
            text.append(ENTER);
            text.append(StringUtils.replace((String)sourceCode, (String)CLASS_NAME_TAG, (String)qualifiedName.substring(lastDotPos + 1)));
            return text.toString();
        }
        return StringUtils.replace((String)sourceCode, (String)CLASS_NAME_TAG, (String)qualifiedName);
    }

    private String setAuthor(String userId, String sourceCode) {
        return StringUtils.replace((String)sourceCode, (String)AUTHOR_TAG, (String)CoreTools.GetRealUserName((String)userId));
    }

    private String setCreationDate(String sourceCode) {
        return StringUtils.replace((String)sourceCode, (String)DATE_TAG, (String)PweUtils.buildFormattedDate(new Date(), "yyyy-MM-dd HH:mm:ss"));
    }

    private String setParameters(JavaCodeOptionsDto options, String sourceCode) {
        if (options != null && CollectionUtils.isNotEmpty(options.getParameters())) {
            return StringUtils.replace((String)sourceCode, (String)PARAMETERS_TAG, (String)StringUtils.join(options.getParameters(), (String)", "));
        }
        return StringUtils.replace((String)sourceCode, (String)PARAMETERS_TAG, (String)"");
    }

    private String setDcMappings(JavaCodeOptionsDto options, String sourceCode) {
        if (options != null && CollectionUtils.isNotEmpty(options.getDcmappings())) {
            String tab = this.getTabForDcMappings(sourceCode, DC_MAPPINGS_TAG);
            StringBuilder text = new StringBuilder();
            text.append("oneResult = new HashMap<String, String>();");
            text.append(ENTER);
            for (String dcMapping : options.getDcmappings()) {
                text.append(tab);
                text.append("oneResult.put( ");
                text.append("\"");
                text.append(dcMapping);
                text.append("\"");
                text.append(", \".....\" );");
                text.append(ENTER);
            }
            text.append(tab);
            text.append("results.add( oneResult );");
            return StringUtils.replace((String)sourceCode, (String)DC_MAPPINGS_TAG, (String)text.toString());
        }
        return StringUtils.replace((String)sourceCode, (String)DC_MAPPINGS_TAG, (String)"");
    }

    private String getTabForDcMappings(String sourceCode, String textValue) {
        int lastEnterIdx;
        int dcMappingsTagIdx = sourceCode.indexOf(textValue);
        if (dcMappingsTagIdx != -1 && (lastEnterIdx = StringUtils.lastIndexOf((CharSequence)sourceCode, (CharSequence)ENTER, (int)dcMappingsTagIdx)) != -1) {
            return StringUtils.substring((String)sourceCode, (int)(lastEnterIdx + ENTER.length()), (int)dcMappingsTagIdx);
        }
        return TAB;
    }

    public String generateSourceCode(String userId, JavaCodeForm form) {
        JavaCodeType javaCodeType = JavaCodeType.getByName(form.getSourceCodeType());
        String location = this.buildTemplateLocation(javaCodeType, form.getTemplateId());
        String sourceCode = this.getSourceCode(location);
        return this.fillSourceCode(userId, form, sourceCode);
    }

    private String buildTemplateLocation(JavaCodeType javaCodeType, String templateId) {
        StringBuilder location = new StringBuilder();
        location.append(TEMPLATE_LOCATION_PREFIX);
        location.append(javaCodeType.getSubType());
        location.append("/");
        location.append(PweUtils.getLanguage());
        location.append("/");
        location.append(templateId);
        return location.toString();
    }
}

