/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.service.processspecification;

import com.suncode.plugin.pwe.documentation.specification.ActivitiesOrderPositionSpecification;
import com.suncode.plugin.pwe.documentation.specification.ActivitiesOrderSpecification;
import com.suncode.plugin.pwe.documentation.specification.ActivitySpecification;
import com.suncode.plugin.pwe.documentation.specification.ApplicationSpecification;
import com.suncode.plugin.pwe.documentation.specification.AssumptionsAndScopeSpecification;
import com.suncode.plugin.pwe.documentation.specification.AttachmentSpecification;
import com.suncode.plugin.pwe.documentation.specification.AutoUpdateSpecification;
import com.suncode.plugin.pwe.documentation.specification.ButtonSpecification;
import com.suncode.plugin.pwe.documentation.specification.ColumnSpecification;
import com.suncode.plugin.pwe.documentation.specification.DatabaseTableSpecification;
import com.suncode.plugin.pwe.documentation.specification.DocumentClassSpecification;
import com.suncode.plugin.pwe.documentation.specification.DocumentLinkSpecification;
import com.suncode.plugin.pwe.documentation.specification.DtButtonSpecification;
import com.suncode.plugin.pwe.documentation.specification.FormVariableSpecification;
import com.suncode.plugin.pwe.documentation.specification.GeneratedDocumentSpecification;
import com.suncode.plugin.pwe.documentation.specification.IntegrationSpecification;
import com.suncode.plugin.pwe.documentation.specification.ParameterSpecification;
import com.suncode.plugin.pwe.documentation.specification.ParticipantSpecification;
import com.suncode.plugin.pwe.documentation.specification.ProcessSpecification;
import com.suncode.plugin.pwe.documentation.specification.ProgrammingTaskSpecification;
import com.suncode.plugin.pwe.documentation.specification.ProjectExclusionSpecification;
import com.suncode.plugin.pwe.documentation.specification.ScheduledTaskSpecification;
import com.suncode.plugin.pwe.documentation.specification.TableButtonSpecification;
import com.suncode.plugin.pwe.documentation.specification.TableSpecification;
import com.suncode.plugin.pwe.documentation.specification.TeamMemberSpecification;
import com.suncode.plugin.pwe.documentation.specification.TeamSpecification;
import com.suncode.plugin.pwe.documentation.specification.TransitionSpecification;
import com.suncode.plugin.pwe.documentation.specification.UtilizationSpecification;
import com.suncode.plugin.pwe.documentation.specification.VariableSpecification;
import com.suncode.plugin.pwe.documentation.specification.ViewDocumentClassSpecification;
import com.suncode.plugin.pwe.service.xml.XmlService;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.xpath.XPathExpressionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Component
public class ProcessSpecificationUnmarshaller {
    @Autowired
    private XmlService xmlService;

    public ProcessSpecification unmarshall(InputStream inputStream) throws Exception {
        Document document = this.xmlService.get(inputStream);
        Element root = document.getDocumentElement();
        ProcessSpecification processSpecification = new ProcessSpecification();
        processSpecification.setId(this.xmlService.getElementAttributeText(root, "id"));
        processSpecification.setDtButtonsSupplied(this.xmlService.getElementAttributeLogical(root, "dtButtonsSupplied"));
        processSpecification.setProcessMapImage(this.xmlService.getElementAttributeText(root, "ProcessMapImage"));
        processSpecification.setAssumptionsAndScope(this.unmarshallAssumptionsAndScope(root));
        processSpecification.setAttachmentSpecifications(this.unmarshallAttachments(root));
        processSpecification.setActivitiesOrder(this.unmarshallActivitiesOrder(root));
        processSpecification.setActivitySpecifications(this.unmarshallActivitySpecifications(root));
        processSpecification.setApplicationSpecifications(this.unmarshallApplicationSpecifications(root));
        processSpecification.setDatabaseTableSpecifications(this.unmarshallDatabaseTables(root));
        processSpecification.setDocumentClassSpecifications(this.unmarshallDocumentClasses(root));
        processSpecification.setDocumentLinkSpecifications(this.unmarshallDocumentLinks(root));
        processSpecification.setIntegrationSpecifications(this.unmarshallIntegrations(root));
        processSpecification.setParticipantSpecifications(this.unmarshallParticipantSpecifications(root));
        processSpecification.setProjectExclusionSpecifications(this.unmarshallProjectExclusions(root));
        processSpecification.setProgrammingTaskSpecifications(this.unmarshallProgrammingTasks(root));
        processSpecification.setScheduledTaskSpecifications(this.unmarshallScheduledTasks(root));
        processSpecification.setTableButtonSpecifications(this.unmarshallTableButtonSpecifications(root));
        processSpecification.setTableSpecifications(this.unmarshallTableSpecifications(root));
        processSpecification.setVariableSpecifications(this.unmarshallVariableSpecifications(root));
        return processSpecification;
    }

    private AssumptionsAndScopeSpecification unmarshallAssumptionsAndScope(Element element) throws XPathExpressionException {
        AssumptionsAndScopeSpecification assumptionsAndScope = new AssumptionsAndScopeSpecification();
        Node assumptionsAndScopeNode = this.xmlService.getNode(element, "AssumptionsAndScope");
        if (this.xmlService.isElement(assumptionsAndScopeNode)) {
            Element assumptionsAndScopeElement = (Element)assumptionsAndScopeNode;
            assumptionsAndScope.setClientName(this.xmlService.getElementText(assumptionsAndScopeElement, "ClientName"));
            assumptionsAndScope.setSystemLink(this.xmlService.getElementText(assumptionsAndScopeElement, "SystemLink"));
            assumptionsAndScope.setGeneralProcessDescription(this.xmlService.getElementText(assumptionsAndScopeElement, "GeneralProcessDescription"));
            assumptionsAndScope.setProcessInitiationMethod(this.xmlService.getElementText(assumptionsAndScopeElement, "ProcessInitiationMethod"));
            assumptionsAndScope.setEmailNotificationsDescription(this.xmlService.getElementText(assumptionsAndScopeElement, "EmailNotificationsDescription"));
            assumptionsAndScope.setUsersInProcess(this.xmlService.getElementInteger(assumptionsAndScopeElement, "UsersInProcess"));
            assumptionsAndScope.setProcessesPerMonth(this.xmlService.getElementInteger(assumptionsAndScopeElement, "ProcessesPerMonth"));
            Node analysisTeamNode = this.xmlService.getNode(element, "AnalysisTeam");
            Node projectTeamNode = this.xmlService.getNode(element, "ProjectTeam");
            if (this.xmlService.isElement(analysisTeamNode)) {
                Element analysisTeamElement = (Element)analysisTeamNode;
                assumptionsAndScope.setAnalysisTeam(this.unmarshallTeam(analysisTeamElement));
            }
            if (this.xmlService.isElement(projectTeamNode)) {
                Element projectTeamElement = (Element)projectTeamNode;
                assumptionsAndScope.setProjectTeam(this.unmarshallTeam(projectTeamElement));
            }
        }
        return assumptionsAndScope;
    }

    private TeamSpecification unmarshallTeam(Element element) throws XPathExpressionException {
        TeamSpecification team = new TeamSpecification();
        team.setClientSideMembers(this.unmarshallTeamMembers(element, "ClientSide/Member"));
        team.setCompanySideMembers(this.unmarshallTeamMembers(element, "CompanySide/Member"));
        return team;
    }

    private List<TeamMemberSpecification> unmarshallTeamMembers(Element element, String expression) throws XPathExpressionException {
        ArrayList<TeamMemberSpecification> teamMembers = new ArrayList<TeamMemberSpecification>();
        NodeList teamMembersList = this.xmlService.getNodeList(element, expression);
        for (Element teamMemberElement : this.xmlService.convertToElementsList(teamMembersList)) {
            teamMembers.add(this.unmarshallTeamMember(teamMemberElement));
        }
        return teamMembers;
    }

    private TeamMemberSpecification unmarshallTeamMember(Element element) throws XPathExpressionException {
        TeamMemberSpecification teamMember = new TeamMemberSpecification();
        teamMember.setName(this.xmlService.getElementText(element, "Name"));
        return teamMember;
    }

    private List<AttachmentSpecification> unmarshallAttachments(Element element) throws XPathExpressionException {
        ArrayList<AttachmentSpecification> attachments = new ArrayList<AttachmentSpecification>();
        NodeList attachmentsList = this.xmlService.getNodeList(element, "Attachments/Attachment");
        for (Element attachmentElement : this.xmlService.convertToElementsList(attachmentsList)) {
            attachments.add(this.unmarshallAttachment(attachmentElement));
        }
        return attachments;
    }

    private AttachmentSpecification unmarshallAttachment(Element element) throws XPathExpressionException {
        AttachmentSpecification attachment = new AttachmentSpecification();
        attachment.setId(this.xmlService.getElementText(element, "Id"));
        attachment.setName(this.xmlService.getElementText(element, "Name"));
        attachment.setFileName(this.xmlService.getElementText(element, "FileName"));
        attachment.setDescription(this.xmlService.getElementText(element, "Description"));
        return attachment;
    }

    private ActivitiesOrderSpecification unmarshallActivitiesOrder(Element element) throws XPathExpressionException {
        ActivitiesOrderSpecification activitiesOrder = new ActivitiesOrderSpecification();
        Node activitiesOrderNode = this.xmlService.getNode(element, "ActivitiesOrder");
        if (this.xmlService.isElement(activitiesOrderNode)) {
            Element activitiesOrderElement = (Element)activitiesOrderNode;
            activitiesOrder.setType(this.xmlService.getElementText(activitiesOrderElement, "Type"));
            activitiesOrder.setSequence(this.unmarshallActivitiesOrderSequence(activitiesOrderElement));
        }
        return activitiesOrder;
    }

    private List<ActivitiesOrderPositionSpecification> unmarshallActivitiesOrderSequence(Element element) throws XPathExpressionException {
        ArrayList<ActivitiesOrderPositionSpecification> sequence = new ArrayList<ActivitiesOrderPositionSpecification>();
        NodeList sequenceList = this.xmlService.getNodeList(element, "Sequence/Position");
        for (Element positionElement : this.xmlService.convertToElementsList(sequenceList)) {
            sequence.add(this.unmarshallActivitiesOrderPosition(positionElement));
        }
        return sequence;
    }

    private ActivitiesOrderPositionSpecification unmarshallActivitiesOrderPosition(Element element) throws XPathExpressionException {
        ActivitiesOrderPositionSpecification position = new ActivitiesOrderPositionSpecification();
        position.setActivityDefId(this.xmlService.getElementText(element, "ActivityDefId"));
        return position;
    }

    private Map<String, ActivitySpecification> unmarshallActivitySpecifications(Element element) throws XPathExpressionException {
        HashMap<String, ActivitySpecification> activitySpecifications = new HashMap<String, ActivitySpecification>();
        NodeList activitySpecificationsList = this.xmlService.getNodeList(element, "Activities/Activity");
        for (Element activitySpecificationElement : this.xmlService.convertToElementsList(activitySpecificationsList)) {
            String id = this.xmlService.getElementAttributeText(activitySpecificationElement, "id");
            ActivitySpecification activitySpecification = this.unmarshallActivitySpecification(activitySpecificationElement);
            activitySpecifications.put(id, activitySpecification);
        }
        return activitySpecifications;
    }

    private ActivitySpecification unmarshallActivitySpecification(Element element) throws XPathExpressionException {
        ActivitySpecification activitySpecification = new ActivitySpecification();
        Node specificationNode = this.xmlService.getNode(element, "Specification");
        if (this.xmlService.isElement(specificationNode)) {
            Element specificationElement = (Element)specificationNode;
            activitySpecification.setFormImage(this.xmlService.getElementText(specificationElement, "FormImage"));
            activitySpecification.setEmailNotificationsDescription(this.xmlService.getElementText(specificationElement, "EmailNotificationsDescription"));
            activitySpecification.setGeneralActivityDescription(this.xmlService.getElementText(specificationElement, "GeneralActivityDescription"));
            activitySpecification.setButtonSpecifications(this.unmarshallButtonSpecifications(specificationElement));
            activitySpecification.setDtButtonSpecifications(this.unmarshallDtButtonSpecifications(specificationElement));
            activitySpecification.setFormVariableSpecifications(this.unmarshallFormVariableSpecifications(specificationElement));
            activitySpecification.setGeneratedDocuments(this.unmarshallGeneratedDocuments(specificationElement));
            activitySpecification.setTransitionSpecifications(this.unmarshallTransitionSpecifications(specificationElement));
            activitySpecification.setViewDocumentClasses(this.unmarshallViewDocumentClassDocuments(specificationElement));
        }
        return activitySpecification;
    }

    private Map<String, ButtonSpecification> unmarshallButtonSpecifications(Element element) throws XPathExpressionException {
        HashMap<String, ButtonSpecification> buttonSpecifications = new HashMap<String, ButtonSpecification>();
        NodeList buttonSpecificationsList = this.xmlService.getNodeList(element, "Buttons/Button");
        for (Element buttonSpecificationElement : this.xmlService.convertToElementsList(buttonSpecificationsList)) {
            String id = this.xmlService.getElementAttributeText(buttonSpecificationElement, "id");
            ButtonSpecification buttonSpecification = this.unmarshallButtonSpecification(buttonSpecificationElement);
            buttonSpecifications.put(id, buttonSpecification);
        }
        return buttonSpecifications;
    }

    private ButtonSpecification unmarshallButtonSpecification(Element element) throws XPathExpressionException {
        ButtonSpecification buttonSpecification = new ButtonSpecification();
        Node specificationNode = this.xmlService.getNode(element, "Specification");
        if (this.xmlService.isElement(specificationNode)) {
            Element specificationElement = (Element)specificationNode;
            buttonSpecification.setDescription(this.xmlService.getElementText(specificationElement, "Description"));
        }
        return buttonSpecification;
    }

    private Map<String, DtButtonSpecification> unmarshallDtButtonSpecifications(Element element) throws XPathExpressionException {
        HashMap<String, DtButtonSpecification> dtButtonSpecifications = new HashMap<String, DtButtonSpecification>();
        NodeList dtButtonSpecificationsList = this.xmlService.getNodeList(element, "DtButtons/DtButton");
        for (Element dtButtonSpecificationElement : this.xmlService.convertToElementsList(dtButtonSpecificationsList)) {
            String id = this.xmlService.getElementAttributeText(dtButtonSpecificationElement, "id");
            DtButtonSpecification dtButtonSpecification = this.unmarshallDtButtonSpecification(dtButtonSpecificationElement);
            dtButtonSpecifications.put(id, dtButtonSpecification);
        }
        return dtButtonSpecifications;
    }

    private DtButtonSpecification unmarshallDtButtonSpecification(Element element) throws XPathExpressionException {
        DtButtonSpecification dtButtonSpecification = new DtButtonSpecification();
        Node specificationNode = this.xmlService.getNode(element, "Specification");
        if (this.xmlService.isElement(specificationNode)) {
            Element specificationElement = (Element)specificationNode;
            dtButtonSpecification.setDescription(this.xmlService.getElementText(specificationElement, "Description"));
        }
        return dtButtonSpecification;
    }

    private Map<String, FormVariableSpecification> unmarshallFormVariableSpecifications(Element element) throws XPathExpressionException {
        HashMap<String, FormVariableSpecification> formVariableSpecifications = new HashMap<String, FormVariableSpecification>();
        NodeList formVariableSpecificationsList = this.xmlService.getNodeList(element, "FormVariables/FormVariable");
        for (Element formVariableSpecificationElement : this.xmlService.convertToElementsList(formVariableSpecificationsList)) {
            String id = this.xmlService.getElementAttributeText(formVariableSpecificationElement, "id");
            FormVariableSpecification formVariableSpecification = this.unmarshallFormVariableSpecification(formVariableSpecificationElement);
            formVariableSpecifications.put(id, formVariableSpecification);
        }
        return formVariableSpecifications;
    }

    private FormVariableSpecification unmarshallFormVariableSpecification(Element element) throws XPathExpressionException {
        FormVariableSpecification formVariableSpecification = new FormVariableSpecification();
        Node specificationNode = this.xmlService.getNode(element, "Specification");
        if (this.xmlService.isElement(specificationNode)) {
            Element specificationElement = (Element)specificationNode;
            formVariableSpecification.setDescription(this.xmlService.getElementText(specificationElement, "Description"));
            formVariableSpecification.setAutoUpdateSpecifications(this.unmarshallAutoUpdateSpecifications(specificationElement));
        }
        return formVariableSpecification;
    }

    private Map<String, AutoUpdateSpecification> unmarshallAutoUpdateSpecifications(Element element) throws XPathExpressionException {
        HashMap<String, AutoUpdateSpecification> autoUpdateSpecifications = new HashMap<String, AutoUpdateSpecification>();
        NodeList autoUpdateSpecificationsList = this.xmlService.getNodeList(element, "AutoUpdates/AutoUpdate");
        for (Element autoUpdateSpecificationElement : this.xmlService.convertToElementsList(autoUpdateSpecificationsList)) {
            String id = this.xmlService.getElementAttributeText(autoUpdateSpecificationElement, "id");
            AutoUpdateSpecification autoUpdateSpecification = this.unmarshallAutoUpdateSpecification(autoUpdateSpecificationElement);
            autoUpdateSpecifications.put(id, autoUpdateSpecification);
        }
        return autoUpdateSpecifications;
    }

    private AutoUpdateSpecification unmarshallAutoUpdateSpecification(Element element) throws XPathExpressionException {
        AutoUpdateSpecification autoUpdateSpecification = new AutoUpdateSpecification();
        Node specificationNode = this.xmlService.getNode(element, "Specification");
        if (this.xmlService.isElement(specificationNode)) {
            Element specificationElement = (Element)specificationNode;
            autoUpdateSpecification.setDescription(this.xmlService.getElementText(specificationElement, "Description"));
        }
        return autoUpdateSpecification;
    }

    private List<GeneratedDocumentSpecification> unmarshallGeneratedDocuments(Element element) throws XPathExpressionException {
        ArrayList<GeneratedDocumentSpecification> generatedDocuments = new ArrayList<GeneratedDocumentSpecification>();
        NodeList generatedDocumentsList = this.xmlService.getNodeList(element, "GeneratedDocuments/GeneratedDocument");
        for (Element generatedDocumentElement : this.xmlService.convertToElementsList(generatedDocumentsList)) {
            generatedDocuments.add(this.unmarshallGeneratedDocument(generatedDocumentElement));
        }
        return generatedDocuments;
    }

    private GeneratedDocumentSpecification unmarshallGeneratedDocument(Element element) throws XPathExpressionException {
        GeneratedDocumentSpecification generatedDocument = new GeneratedDocumentSpecification();
        generatedDocument.setName(this.xmlService.getElementText(element, "Name"));
        return generatedDocument;
    }

    private Map<String, TransitionSpecification> unmarshallTransitionSpecifications(Element element) throws XPathExpressionException {
        HashMap<String, TransitionSpecification> transitionSpecifications = new HashMap<String, TransitionSpecification>();
        NodeList transitionSpecificationsList = this.xmlService.getNodeList(element, "Transitions/Transition");
        for (Element transitionSpecificationElement : this.xmlService.convertToElementsList(transitionSpecificationsList)) {
            String id = this.xmlService.getElementAttributeText(transitionSpecificationElement, "to");
            TransitionSpecification transitionSpecification = this.unmarshallTransitionSpecification(transitionSpecificationElement);
            transitionSpecifications.put(id, transitionSpecification);
        }
        return transitionSpecifications;
    }

    private TransitionSpecification unmarshallTransitionSpecification(Element element) throws XPathExpressionException {
        TransitionSpecification transitionSpecification = new TransitionSpecification();
        Node specificationNode = this.xmlService.getNode(element, "Specification");
        if (this.xmlService.isElement(specificationNode)) {
            Element specificationElement = (Element)specificationNode;
            transitionSpecification.setDescription(this.xmlService.getElementText(specificationElement, "Description"));
        }
        return transitionSpecification;
    }

    private List<ViewDocumentClassSpecification> unmarshallViewDocumentClassDocuments(Element element) throws XPathExpressionException {
        ArrayList<ViewDocumentClassSpecification> viewDocumentClassDocuments = new ArrayList<ViewDocumentClassSpecification>();
        NodeList viewDocumentClassDocumentsList = this.xmlService.getNodeList(element, "ViewDocumentClasses/ViewDocumentClass");
        for (Element viewDocumentClassDocumentElement : this.xmlService.convertToElementsList(viewDocumentClassDocumentsList)) {
            viewDocumentClassDocuments.add(this.unmarshallViewDocumentClassDocument(viewDocumentClassDocumentElement));
        }
        return viewDocumentClassDocuments;
    }

    private ViewDocumentClassSpecification unmarshallViewDocumentClassDocument(Element element) throws XPathExpressionException {
        ViewDocumentClassSpecification viewDocumentClass = new ViewDocumentClassSpecification();
        viewDocumentClass.setName(this.xmlService.getElementText(element, "Name"));
        return viewDocumentClass;
    }

    private Map<String, ApplicationSpecification> unmarshallApplicationSpecifications(Element element) throws XPathExpressionException {
        HashMap<String, ApplicationSpecification> applicationSpecifications = new HashMap<String, ApplicationSpecification>();
        NodeList applicationSpecificationsList = this.xmlService.getNodeList(element, "Applications/Application");
        for (Element applicationSpecificationElement : this.xmlService.convertToElementsList(applicationSpecificationsList)) {
            String id = this.xmlService.getElementAttributeText(applicationSpecificationElement, "id");
            ApplicationSpecification applicationSpecification = this.unmarshallApplicationSpecification(applicationSpecificationElement);
            applicationSpecifications.put(id, applicationSpecification);
        }
        return applicationSpecifications;
    }

    private ApplicationSpecification unmarshallApplicationSpecification(Element element) throws XPathExpressionException {
        ApplicationSpecification applicationSpecification = new ApplicationSpecification();
        Node specificationNode = this.xmlService.getNode(element, "Specification");
        if (this.xmlService.isElement(specificationNode)) {
            Element specificationElement = (Element)specificationNode;
            applicationSpecification.setDescription(this.xmlService.getElementText(specificationElement, "Description"));
        }
        return applicationSpecification;
    }

    private List<DatabaseTableSpecification> unmarshallDatabaseTables(Element element) throws XPathExpressionException {
        ArrayList<DatabaseTableSpecification> databaseTables = new ArrayList<DatabaseTableSpecification>();
        NodeList databaseTablesList = this.xmlService.getNodeList(element, "DatabaseTables/DatabaseTable");
        for (Element databaseTableElement : this.xmlService.convertToElementsList(databaseTablesList)) {
            databaseTables.add(this.unmarshallDatabaseTable(databaseTableElement));
        }
        return databaseTables;
    }

    private DatabaseTableSpecification unmarshallDatabaseTable(Element element) throws XPathExpressionException {
        DatabaseTableSpecification databaseTable = new DatabaseTableSpecification();
        databaseTable.setName(this.xmlService.getElementText(element, "Name"));
        databaseTable.setDatabaseType(this.xmlService.getElementText(element, "DatabaseType"));
        databaseTable.setLocation(this.xmlService.getElementText(element, "Location"));
        databaseTable.setAddedFromAdministration(this.xmlService.getElementLogical(element, "AddedFromAdministration"));
        databaseTable.setColumns(this.unmarshallColumns(element));
        databaseTable.setUtilizationInActivities(this.unmarshallUtilizations(element));
        return databaseTable;
    }

    private List<ColumnSpecification> unmarshallColumns(Element element) throws XPathExpressionException {
        ArrayList<ColumnSpecification> columns = new ArrayList<ColumnSpecification>();
        NodeList columnsList = this.xmlService.getNodeList(element, "Columns/Column");
        for (Element columnElement : this.xmlService.convertToElementsList(columnsList)) {
            columns.add(this.unmarshallColumn(columnElement));
        }
        return columns;
    }

    private ColumnSpecification unmarshallColumn(Element element) throws XPathExpressionException {
        ColumnSpecification column = new ColumnSpecification();
        column.setName(this.xmlService.getElementText(element, "Name"));
        column.setDescription(this.xmlService.getElementText(element, "Description"));
        column.setType(this.xmlService.getElementText(element, "Type"));
        return column;
    }

    private List<UtilizationSpecification> unmarshallUtilizations(Element element) throws XPathExpressionException {
        ArrayList<UtilizationSpecification> utilizations = new ArrayList<UtilizationSpecification>();
        NodeList utilizationsList = this.xmlService.getNodeList(element, "UtilizationInActivities/Utilization");
        for (Element utilizationElement : this.xmlService.convertToElementsList(utilizationsList)) {
            utilizations.add(this.unmarshallUtilization(utilizationElement));
        }
        return utilizations;
    }

    private UtilizationSpecification unmarshallUtilization(Element element) throws XPathExpressionException {
        UtilizationSpecification utilization = new UtilizationSpecification();
        utilization.setActivityDefId(this.xmlService.getElementText(element, "ActivityDefId"));
        utilization.setDescription(this.xmlService.getElementText(element, "Description"));
        return utilization;
    }

    private List<DocumentClassSpecification> unmarshallDocumentClasses(Element element) throws XPathExpressionException {
        ArrayList<DocumentClassSpecification> documentClasses = new ArrayList<DocumentClassSpecification>();
        NodeList documentClassesList = this.xmlService.getNodeList(element, "DocumentClasses/DocumentClass");
        for (Element documentClassElement : this.xmlService.convertToElementsList(documentClassesList)) {
            documentClasses.add(this.unmarshallDocumentClass(documentClassElement));
        }
        return documentClasses;
    }

    private DocumentClassSpecification unmarshallDocumentClass(Element element) throws XPathExpressionException {
        DocumentClassSpecification documentClass = new DocumentClassSpecification();
        documentClass.setName(this.xmlService.getElementText(element, "Name"));
        documentClass.setDescription(this.xmlService.getElementText(element, "Description"));
        return documentClass;
    }

    private List<DocumentLinkSpecification> unmarshallDocumentLinks(Element element) throws XPathExpressionException {
        ArrayList<DocumentLinkSpecification> documentLinks = new ArrayList<DocumentLinkSpecification>();
        NodeList documentLinksList = this.xmlService.getNodeList(element, "DocumentLinks/DocumentLink");
        for (Element documentLinkElement : this.xmlService.convertToElementsList(documentLinksList)) {
            documentLinks.add(this.unmarshallDocumentLink(documentLinkElement));
        }
        return documentLinks;
    }

    private DocumentLinkSpecification unmarshallDocumentLink(Element element) throws XPathExpressionException {
        DocumentLinkSpecification documentLink = new DocumentLinkSpecification();
        documentLink.setName(this.xmlService.getElementText(element, "Name"));
        documentLink.setDescription(this.xmlService.getElementText(element, "Description"));
        return documentLink;
    }

    private List<IntegrationSpecification> unmarshallIntegrations(Element element) throws XPathExpressionException {
        ArrayList<IntegrationSpecification> integrations = new ArrayList<IntegrationSpecification>();
        NodeList integrationsList = this.xmlService.getNodeList(element, "Integrations/Integration");
        for (Element integrationElement : this.xmlService.convertToElementsList(integrationsList)) {
            integrations.add(this.unmarshallIntegration(integrationElement));
        }
        return integrations;
    }

    private IntegrationSpecification unmarshallIntegration(Element element) throws XPathExpressionException {
        IntegrationSpecification integration = new IntegrationSpecification();
        integration.setName(this.xmlService.getElementText(element, "Name"));
        integration.setDescription(this.xmlService.getElementText(element, "Description"));
        integration.setSystemName(this.xmlService.getElementText(element, "SystemName"));
        integration.setIntegrationMethod(this.xmlService.getElementText(element, "IntegrationMethod"));
        integration.setPurpose(this.xmlService.getElementText(element, "Purpose"));
        return integration;
    }

    private Map<String, ParticipantSpecification> unmarshallParticipantSpecifications(Element element) throws XPathExpressionException {
        HashMap<String, ParticipantSpecification> participantSpecifications = new HashMap<String, ParticipantSpecification>();
        NodeList participantSpecificationsList = this.xmlService.getNodeList(element, "Participants/Participant");
        for (Element participantSpecificationElement : this.xmlService.convertToElementsList(participantSpecificationsList)) {
            String id = this.xmlService.getElementAttributeText(participantSpecificationElement, "id");
            ParticipantSpecification participantSpecification = this.unmarshallParticipantSpecification(participantSpecificationElement);
            participantSpecifications.put(id, participantSpecification);
        }
        return participantSpecifications;
    }

    private ParticipantSpecification unmarshallParticipantSpecification(Element element) throws XPathExpressionException {
        ParticipantSpecification participantSpecification = new ParticipantSpecification();
        Node specificationNode = this.xmlService.getNode(element, "Specification");
        if (this.xmlService.isElement(specificationNode)) {
            Element specificationElement = (Element)specificationNode;
            participantSpecification.setDescription(this.xmlService.getElementText(specificationElement, "Description"));
        }
        return participantSpecification;
    }

    private List<ProjectExclusionSpecification> unmarshallProjectExclusions(Element element) throws XPathExpressionException {
        ArrayList<ProjectExclusionSpecification> projectExclusions = new ArrayList<ProjectExclusionSpecification>();
        NodeList projectExclusionsList = this.xmlService.getNodeList(element, "ProjectExclusions/ProjectExclusion");
        for (Element projectExclusionElement : this.xmlService.convertToElementsList(projectExclusionsList)) {
            projectExclusions.add(this.unmarshallProjectExclusion(projectExclusionElement));
        }
        return projectExclusions;
    }

    private ProjectExclusionSpecification unmarshallProjectExclusion(Element element) throws XPathExpressionException {
        ProjectExclusionSpecification projectExclusion = new ProjectExclusionSpecification();
        projectExclusion.setName(this.xmlService.getElementText(element, "Name"));
        projectExclusion.setContents(this.xmlService.getElementText(element, "Contents"));
        return projectExclusion;
    }

    private List<ProgrammingTaskSpecification> unmarshallProgrammingTasks(Element element) throws XPathExpressionException {
        ArrayList<ProgrammingTaskSpecification> programmingTasks = new ArrayList<ProgrammingTaskSpecification>();
        NodeList programmingTasksList = this.xmlService.getNodeList(element, "ProgrammingTasks/ProgramingTask");
        for (Element programmingTaskElement : this.xmlService.convertToElementsList(programmingTasksList)) {
            programmingTasks.add(this.unmarshallProgrammingTask(programmingTaskElement));
        }
        return programmingTasks;
    }

    private ProgrammingTaskSpecification unmarshallProgrammingTask(Element element) throws XPathExpressionException {
        ProgrammingTaskSpecification programmingTask = new ProgrammingTaskSpecification();
        programmingTask.setName(this.xmlService.getElementText(element, "Name"));
        programmingTask.setDescription(this.xmlService.getElementText(element, "Description"));
        programmingTask.setType(this.xmlService.getElementText(element, "Type"));
        programmingTask.setAlgorithmDescription(this.xmlService.getElementText(element, "AlgorithmDescription"));
        programmingTask.setExecutionLocation(this.xmlService.getElementText(element, "ExecutionLocation"));
        programmingTask.setInputParameters(this.unmarshallParameters(element, "InputParameters/parameter-specification"));
        programmingTask.setOutputParameters(this.unmarshallParameters(element, "OutputParameters/parameter-specification"));
        return programmingTask;
    }

    private List<ParameterSpecification> unmarshallParameters(Element element, String expression) throws XPathExpressionException {
        ArrayList<ParameterSpecification> parameters = new ArrayList<ParameterSpecification>();
        NodeList parametersList = this.xmlService.getNodeList(element, expression);
        for (Element parameterElement : this.xmlService.convertToElementsList(parametersList)) {
            parameters.add(this.unmarshallParameter(parameterElement));
        }
        return parameters;
    }

    private ParameterSpecification unmarshallParameter(Element element) throws XPathExpressionException {
        ParameterSpecification parameter = new ParameterSpecification();
        parameter.setName(this.xmlService.getElementText(element, "Name"));
        parameter.setDescription(this.xmlService.getElementText(element, "Description"));
        return parameter;
    }

    private List<ScheduledTaskSpecification> unmarshallScheduledTasks(Element element) throws XPathExpressionException {
        ArrayList<ScheduledTaskSpecification> scheduledTasks = new ArrayList<ScheduledTaskSpecification>();
        NodeList scheduledTasksList = this.xmlService.getNodeList(element, "ScheduledTasks/ScheduledTask");
        for (Element scheduledTaskElement : this.xmlService.convertToElementsList(scheduledTasksList)) {
            scheduledTasks.add(this.unmarshallScheduledTask(scheduledTaskElement));
        }
        return scheduledTasks;
    }

    private ScheduledTaskSpecification unmarshallScheduledTask(Element element) throws XPathExpressionException {
        ScheduledTaskSpecification scheduledTask = new ScheduledTaskSpecification();
        scheduledTask.setName(this.xmlService.getElementText(element, "Name"));
        scheduledTask.setDescription(this.xmlService.getElementText(element, "Description"));
        scheduledTask.setClassName(this.xmlService.getElementText(element, "ClassName"));
        scheduledTask.setMethodName(this.xmlService.getElementText(element, "MethodName"));
        scheduledTask.setAlgorithmDescription(this.xmlService.getElementText(element, "AlgorithmDescription"));
        scheduledTask.setExecutionFrequencyValue(this.xmlService.getElementInteger(element, "ExecutionFrequencyValue"));
        scheduledTask.setExecutionFrequencyUnit(this.xmlService.getElementText(element, "ExecutionFrequencyUnit"));
        scheduledTask.setInputParameters(this.unmarshallParameters(element, "InputParameters/parameter-specification"));
        return scheduledTask;
    }

    private Map<String, TableButtonSpecification> unmarshallTableButtonSpecifications(Element element) throws XPathExpressionException {
        HashMap<String, TableButtonSpecification> tableButtonSpecifications = new HashMap<String, TableButtonSpecification>();
        NodeList tableButtonSpecificationsList = this.xmlService.getNodeList(element, "TableButtons/TableButton");
        for (Element tableButtonSpecificationElement : this.xmlService.convertToElementsList(tableButtonSpecificationsList)) {
            String id = this.xmlService.getElementAttributeText(tableButtonSpecificationElement, "id");
            TableButtonSpecification tableButtonSpecification = this.unmarshallTableButtonSpecification(tableButtonSpecificationElement);
            tableButtonSpecifications.put(id, tableButtonSpecification);
        }
        return tableButtonSpecifications;
    }

    private TableButtonSpecification unmarshallTableButtonSpecification(Element element) throws XPathExpressionException {
        TableButtonSpecification tableButtonSpecification = new TableButtonSpecification();
        Node specificationNode = this.xmlService.getNode(element, "Specification");
        if (this.xmlService.isElement(specificationNode)) {
            Element specificationElement = (Element)specificationNode;
            tableButtonSpecification.setDescription(this.xmlService.getElementText(specificationElement, "Description"));
        }
        return tableButtonSpecification;
    }

    private Map<String, TableSpecification> unmarshallTableSpecifications(Element element) throws XPathExpressionException {
        HashMap<String, TableSpecification> tableSpecifications = new HashMap<String, TableSpecification>();
        NodeList tableSpecificationsList = this.xmlService.getNodeList(element, "Tables/Table");
        for (Element tableSpecificationElement : this.xmlService.convertToElementsList(tableSpecificationsList)) {
            String id = this.xmlService.getElementAttributeText(tableSpecificationElement, "id");
            TableSpecification tableSpecification = this.unmarshallTableSpecification(tableSpecificationElement);
            tableSpecifications.put(id, tableSpecification);
        }
        return tableSpecifications;
    }

    private TableSpecification unmarshallTableSpecification(Element element) throws XPathExpressionException {
        TableSpecification tableSpecification = new TableSpecification();
        Node specificationNode = this.xmlService.getNode(element, "Specification");
        if (this.xmlService.isElement(specificationNode)) {
            Element specificationElement = (Element)specificationNode;
            tableSpecification.setDescription(this.xmlService.getElementText(specificationElement, "Description"));
        }
        return tableSpecification;
    }

    private Map<String, VariableSpecification> unmarshallVariableSpecifications(Element element) throws XPathExpressionException {
        HashMap<String, VariableSpecification> variableSpecifications = new HashMap<String, VariableSpecification>();
        NodeList variableSpecificationsList = this.xmlService.getNodeList(element, "Variables/Variable");
        for (Element variableSpecificationElement : this.xmlService.convertToElementsList(variableSpecificationsList)) {
            String id = this.xmlService.getElementAttributeText(variableSpecificationElement, "id");
            VariableSpecification variableSpecification = this.unmarshallVariableSpecification(variableSpecificationElement);
            variableSpecifications.put(id, variableSpecification);
        }
        return variableSpecifications;
    }

    private VariableSpecification unmarshallVariableSpecification(Element element) throws XPathExpressionException {
        VariableSpecification variableSpecification = new VariableSpecification();
        Node specificationNode = this.xmlService.getNode(element, "Specification");
        if (this.xmlService.isElement(specificationNode)) {
            Element specificationElement = (Element)specificationNode;
            variableSpecification.setDescription(this.xmlService.getElementText(specificationElement, "Description"));
        }
        return variableSpecification;
    }
}

