/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.service.packageinfo;

import com.suncode.plugin.pwe.dao.packageinfo.PackageInfoTemplateDao;
import com.suncode.plugin.pwe.model.packageinfo.PackageInfoTemplate;
import com.suncode.plugin.pwe.web.support.dto.packageinfo.PackageInfoTemplateDto;
import com.suncode.plugin.pwe.web.support.dto.packageinfo.builder.PackageInfoTemplateDtoBuilder;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class PackageInfoTemplateService {
    private static final String DEFAULT_CONTENT = "Osoba wprowadzaj\u0105ca: \nNumer zmiany: \nTyp: \nOpis: ";
    @Autowired
    private PackageInfoTemplateDao packageInfoTemplateDao;
    @Autowired
    private PackageInfoTemplateDtoBuilder packageInfoTemplateDtoBuilder;

    public PackageInfoTemplateDto get() {
        return this.getTemplate().map(this.packageInfoTemplateDtoBuilder::build).orElse(PackageInfoTemplateService.buildDefault());
    }

    private Optional<PackageInfoTemplate> getTemplate() {
        return this.packageInfoTemplateDao.getAll(new String[0]).stream().findFirst();
    }

    private static PackageInfoTemplateDto buildDefault() {
        PackageInfoTemplateDto dto = new PackageInfoTemplateDto();
        dto.setContent(DEFAULT_CONTENT);
        dto.setValidate(true);
        return dto;
    }

    public boolean set(PackageInfoTemplateDto dto) {
        Optional<PackageInfoTemplate> templateOpt = this.getTemplate();
        if (templateOpt.isPresent()) {
            PackageInfoTemplate packageInfoTemplate = templateOpt.get();
            packageInfoTemplate.setContent(dto.getContent());
            packageInfoTemplate.setValidate(dto.getValidate());
            this.packageInfoTemplateDao.update(packageInfoTemplate);
            return true;
        }
        PackageInfoTemplate packageInfoTemplate = this.packageInfoTemplateDtoBuilder.extract(dto);
        Long id = (Long)this.packageInfoTemplateDao.save(packageInfoTemplate);
        return id != null;
    }
}

