/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.documentation.paragraph.builder;

import com.suncode.plugin.pwe.documentation.ParagraphContent;
import com.suncode.plugin.pwe.documentation.ParagraphContents;
import com.suncode.plugin.pwe.documentation.TextValue;
import com.suncode.plugin.pwe.documentation.enumeration.DefinedVariable;
import com.suncode.plugin.pwe.documentation.object.TextPart;
import com.suncode.plugin.pwe.documentation.util.BookmarkNameUtils;
import com.suncode.plugin.pwe.documentation.util.ParagraphContentsUtils;
import com.suncode.plugin.pwe.documentation.util.TextUtils;
import com.suncode.plugin.pwe.documentation.util.TextValueUtils;
import com.suncode.plugin.pwe.documentation.util.VariableUtils;
import com.suncode.plugin.pwe.service.translator.TranslatorService;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.enhydra.shark.xpdl.elements.DataField;
import org.enhydra.shark.xpdl.elements.WorkflowProcess;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ParagraphContentsBuilder {
    @Autowired
    private TranslatorService translatorService;

    public List<ParagraphContents> build(WorkflowProcess process, List<String> values) {
        ArrayList<ParagraphContents> list = new ArrayList<ParagraphContents>();
        for (String value : values) {
            list.add(this.build(process, value));
        }
        return list;
    }

    private ParagraphContents build(WorkflowProcess process, String value) {
        if (this.isDefinedVariable(value)) {
            String text = this.buildDefinedVariableText(value);
            return this.build(text);
        }
        if (process.getDataFields().containsElement(value)) {
            DataField dataField = process.getDataField(value);
            String text = dataField.getName();
            String bookmarkName = this.buildBookmarkName(dataField);
            return this.build(text, bookmarkName);
        }
        String text = VariableUtils.getName(process, value);
        return this.build(text);
    }

    private boolean isDefinedVariable(String value) {
        switch (DefinedVariable.getByName(value)) {
            case UNKNOWN: {
                return false;
            }
        }
        return true;
    }

    private String buildDefinedVariableText(String value) {
        return this.translatorService.translateDocumentationMessageForText(TextUtils.generateTranslationText(value));
    }

    private String buildBookmarkName(DataField dataField) {
        return BookmarkNameUtils.getNameForProcessVariable(dataField.getId());
    }

    private ParagraphContents build(String text) {
        return ParagraphContentsUtils.build(text);
    }

    private ParagraphContents build(String text, String bookmarkName) {
        return ParagraphContentsUtils.build(text, bookmarkName);
    }

    public ParagraphContents build(List<TextPart> parts) {
        ParagraphContents contents = new ParagraphContents();
        if (CollectionUtils.isNotEmpty(parts)) {
            for (TextPart part : parts) {
                if (part.isBookmarked()) {
                    contents.addContent(this.buildBookmarkContent(part));
                    continue;
                }
                if (part.isImage()) {
                    contents.addContent(this.buildImageContent(part));
                    continue;
                }
                contents.addContent(this.buildBasicContent(part));
            }
        }
        return contents;
    }

    private ParagraphContent buildBasicContent(TextPart part) {
        ParagraphContent content = new ParagraphContent();
        content.setTextValue(this.buildBasicTextValue(part));
        content.setBold(part.isBold());
        return content;
    }

    private TextValue buildBasicTextValue(TextPart part) {
        return TextValueUtils.build(part.getText());
    }

    private ParagraphContent buildBookmarkContent(TextPart part) {
        ParagraphContent content = new ParagraphContent();
        content.setTextValue(this.buildBookmarkTextValue(part));
        return content;
    }

    private ParagraphContent buildImageContent(TextPart part) {
        ParagraphContent content = new ParagraphContent();
        content.setBytes(part.getBytes());
        return content;
    }

    private TextValue buildBookmarkTextValue(TextPart part) {
        String text = part.getText();
        String bookmarkName = part.getBookmarkName();
        return TextValueUtils.build(text, bookmarkName);
    }
}

