/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.documentation.object.builder;

import com.suncode.plugin.pwe.documentation.enumeration.AutoUpdateConfig;
import com.suncode.plugin.pwe.documentation.object.AutoUpdate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class AutoUpdateBuilder {
    private static final String DEFAULT_EVENT_TYPE = "blur";
    private static final String ID_SEPARATOR = ",";

    public List<AutoUpdate> build(String extAttrValue) {
        ArrayList<AutoUpdate> autoUpdates = new ArrayList<AutoUpdate>();
        List<Object> actionSources = new ArrayList();
        String eventType = new String(DEFAULT_EVENT_TYPE);
        List<String> dataSources = new ArrayList<String>();
        List<String> destinationVariables = new ArrayList<String>();
        String taskName = "";
        block7: for (String oneExtAttr : extAttrValue.split("\n")) {
            String[] oneExtAttrSplit = oneExtAttr.split("=", 2);
            String oneExtAttrName = oneExtAttrSplit[0];
            switch (AutoUpdateConfig.getByName(oneExtAttrName)) {
                case actionsource: {
                    actionSources = this.buildActionSources(oneExtAttrSplit[1]);
                    continue block7;
                }
                case datasource: {
                    dataSources = this.buildDataSources(oneExtAttrSplit[1]);
                    continue block7;
                }
                case destination: {
                    destinationVariables = this.buildDestinationVariables(oneExtAttrSplit[1]);
                    continue block7;
                }
                case eventType: {
                    eventType = new String(oneExtAttrSplit[1]);
                    continue block7;
                }
                case taskName: {
                    taskName = new String(oneExtAttrSplit[1]);
                    continue block7;
                }
            }
        }
        if (CollectionUtils.isNotEmpty(actionSources)) {
            String id = this.buildId(taskName, dataSources, destinationVariables);
            for (String actionSource : actionSources) {
                AutoUpdate autoUpdate = new AutoUpdate();
                autoUpdate.setId(id);
                autoUpdate.setActionSource(actionSource);
                autoUpdate.setEventType(eventType);
                autoUpdate.setDataSources(dataSources);
                autoUpdate.setDestinationVariables(destinationVariables);
                autoUpdate.setTaskName(taskName);
                autoUpdates.add(autoUpdate);
            }
        }
        return autoUpdates;
    }

    private List<String> buildActionSources(String oneExtAttrValue) {
        return Arrays.asList(oneExtAttrValue.split(ID_SEPARATOR));
    }

    private List<String> buildDataSources(String oneExtAttrValue) {
        return Arrays.asList(oneExtAttrValue.split(ID_SEPARATOR));
    }

    private List<String> buildDestinationVariables(String oneExtAttrValue) {
        if (StringUtils.contains((CharSequence)oneExtAttrValue, (CharSequence)ID_SEPARATOR)) {
            return Arrays.asList(oneExtAttrValue.split(ID_SEPARATOR));
        }
        return Arrays.asList(oneExtAttrValue.split(";"));
    }

    private String buildId(String taskName, List<String> dataSources, List<String> destinationVariables) {
        StringBuilder id = new StringBuilder();
        id.append(taskName);
        id.append(ID_SEPARATOR);
        if (CollectionUtils.isNotEmpty(dataSources)) {
            id.append(StringUtils.join(dataSources, (String)ID_SEPARATOR));
            id.append(ID_SEPARATOR);
        }
        if (CollectionUtils.isNotEmpty(destinationVariables)) {
            id.append(StringUtils.join(destinationVariables, (String)ID_SEPARATOR));
            id.append(ID_SEPARATOR);
        }
        return id.toString();
    }
}

