/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.documentation.chapter.point.builder;

import com.suncode.plugin.pwe.documentation.Table;
import com.suncode.plugin.pwe.documentation.TableCell;
import com.suncode.plugin.pwe.documentation.TableHeader;
import com.suncode.plugin.pwe.documentation.TableHeaders;
import com.suncode.plugin.pwe.documentation.TableRecord;
import com.suncode.plugin.pwe.documentation.TableRecords;
import com.suncode.plugin.pwe.documentation.enumeration.DefinedVariable;
import com.suncode.plugin.pwe.documentation.object.AcceptButton;
import com.suncode.plugin.pwe.documentation.object.AcceptButtonAction;
import com.suncode.plugin.pwe.documentation.object.builder.DefinedValueTranslationBuilder;
import com.suncode.plugin.pwe.documentation.util.BookmarkNameUtils;
import com.suncode.plugin.pwe.documentation.util.TableUtils;
import com.suncode.plugin.pwe.documentation.util.TextUtils;
import com.suncode.plugin.pwe.service.translator.TranslatorService;
import org.enhydra.shark.xpdl.elements.DataField;
import org.enhydra.shark.xpdl.elements.DataFields;
import org.enhydra.shark.xpdl.elements.WorkflowProcess;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AcceptButtonActionsPointBuilder {
    private static final String VARIABLE_NAME_TABLE_COLUMN_ID = "name";
    private static final String VARIABLE_NAME_TABLE_HEADER = "pwe.documentation.table.header.variablename";
    private static final String VALUE_TABLE_COLUMN_ID = "value";
    private static final String VALUE_TABLE_HEADER = "pwe.documentation.table.header.value";
    @Autowired
    private TranslatorService translatorService;
    @Autowired
    private DefinedValueTranslationBuilder definedValueTranslationBuilder;

    public Table build(WorkflowProcess process, AcceptButton acceptButton) {
        Table table = new Table();
        table.setHeaders(this.buildTableHeaders());
        table.setRecords(this.buildTableRecords(process, acceptButton));
        return table;
    }

    private TableHeaders buildTableHeaders() {
        TableHeaders headers = new TableHeaders();
        headers.add(this.buildTableVariableNameHeader());
        headers.add(this.buildTableValueHeader());
        return headers;
    }

    private TableHeader buildTableVariableNameHeader() {
        return TableUtils.buildTableHeader(VARIABLE_NAME_TABLE_COLUMN_ID, this.translatorService.translateMessage(VARIABLE_NAME_TABLE_HEADER));
    }

    private TableHeader buildTableValueHeader() {
        return TableUtils.buildTableHeader(VALUE_TABLE_COLUMN_ID, this.translatorService.translateMessage(VALUE_TABLE_HEADER));
    }

    private TableRecords buildTableRecords(WorkflowProcess process, AcceptButton acceptButton) {
        TableRecords records = new TableRecords();
        for (AcceptButtonAction acceptButtonAction : acceptButton.getActions()) {
            records.add(this.buildTableRecord(process, acceptButtonAction));
        }
        return records;
    }

    private TableRecord buildTableRecord(WorkflowProcess process, AcceptButtonAction acceptButtonAction) {
        TableRecord record = new TableRecord();
        record.addCell(VARIABLE_NAME_TABLE_COLUMN_ID, this.buildTableRecordVariableNameCell(process, acceptButtonAction));
        record.addCell(VALUE_TABLE_COLUMN_ID, this.buildTableRecordValueCell(acceptButtonAction));
        return record;
    }

    private TableCell buildTableRecordVariableNameCell(WorkflowProcess process, AcceptButtonAction acceptButtonAction) {
        String actionId = acceptButtonAction.getId();
        DataFields dataFields = process.getDataFields();
        if (this.isDefinedVariable(actionId)) {
            return TableUtils.buildTableCell(this.buildDefinedVariableText(actionId));
        }
        if (dataFields.containsElement(actionId)) {
            DataField dataField = dataFields.getDataField(actionId);
            String text = dataField.getName();
            String bookmarkName = this.buildBookmarkName(dataField);
            return TableUtils.buildTableCell(text, bookmarkName);
        }
        return TableUtils.buildTableCell(actionId);
    }

    private boolean isDefinedVariable(String value) {
        switch (DefinedVariable.getByName(value)) {
            case UNKNOWN: {
                return false;
            }
        }
        return true;
    }

    private String buildDefinedVariableText(String value) {
        return this.translatorService.translateDocumentationMessageForText(TextUtils.generateTranslationText(value));
    }

    private String buildBookmarkName(DataField dataField) {
        return BookmarkNameUtils.getNameForProcessVariable(dataField.getId());
    }

    private TableCell buildTableRecordValueCell(AcceptButtonAction acceptButtonAction) {
        return TableUtils.buildTableCell(this.buildValueText(acceptButtonAction));
    }

    private String buildValueText(AcceptButtonAction acceptButtonAction) {
        return this.definedValueTranslationBuilder.build(acceptButtonAction.getValue());
    }
}

