/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.documentation.chapter.builder;

import com.suncode.plugin.pwe.documentation.Documentation;
import com.suncode.plugin.pwe.documentation.ParagraphContents;
import com.suncode.plugin.pwe.documentation.TableCell;
import com.suncode.plugin.pwe.documentation.TableHeader;
import com.suncode.plugin.pwe.documentation.TableHeaders;
import com.suncode.plugin.pwe.documentation.TableRecord;
import com.suncode.plugin.pwe.documentation.TableRecords;
import com.suncode.plugin.pwe.documentation.chapter.builder.ChapterBuilder;
import com.suncode.plugin.pwe.documentation.object.DataChooser;
import com.suncode.plugin.pwe.documentation.object.builder.DataChooserBuilder;
import com.suncode.plugin.pwe.documentation.object.builder.DefinedValueTranslationBuilder;
import com.suncode.plugin.pwe.documentation.paragraph.builder.ParagraphContentsBuilder;
import com.suncode.plugin.pwe.documentation.paragraph.builder.SpecificationDescriptionParagraphContentsBuilder;
import com.suncode.plugin.pwe.documentation.specification.ProcessSpecification;
import com.suncode.plugin.pwe.documentation.specification.VariableSpecification;
import com.suncode.plugin.pwe.documentation.subchapter.builder.SubchapterBuilder;
import com.suncode.plugin.pwe.documentation.util.BookmarkNameUtils;
import com.suncode.plugin.pwe.documentation.util.Counter;
import com.suncode.plugin.pwe.documentation.util.ParagraphContentsUtils;
import com.suncode.plugin.pwe.documentation.util.ParagraphIndentsUtils;
import com.suncode.plugin.pwe.documentation.util.TableUtils;
import com.suncode.plugin.pwe.documentation.util.TextUtils;
import com.suncode.plugin.pwe.service.translator.TranslatorService;
import com.suncode.plugin.pwe.util.DocumentationType;
import com.suncode.plugin.pwe.util.ExtAttrUtils;
import com.suncode.plugin.pwe.util.VariableType;
import com.suncode.plugin.pwe.util.translation.TranslationInfo;
import com.suncode.plugin.pwe.web.support.dto.documentationconfig.DocumentationConfigDto;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.enhydra.shark.xpdl.elements.DataField;
import org.enhydra.shark.xpdl.elements.DataFields;
import org.enhydra.shark.xpdl.elements.ExtendedAttributes;
import org.enhydra.shark.xpdl.elements.WorkflowProcess;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="processVariablesListChapterBuilder")
public class ProcessVariablesListChapterBuilderImpl
implements ChapterBuilder {
    private static final String CHAPTER_TITLE = "pwe.documentation.chapter.title.processvariableslist";
    private static final String VARIABLES_TABLE_NAME_COLUMN_ID = "name";
    private static final String NAME_TABLE_HEADER = "pwe.documentation.table.header.variablename";
    private static final String VARIABLES_TABLE_DESCRIPTION_COLUMN_ID = "description";
    private static final String DESCRIPTION_TABLE_HEADER = "pwe.documentation.table.header.description";
    private static final String VARIABLES_TABLE_TYPE_COLUMN_ID = "type";
    private static final String TYPE_TABLE_HEADER = "pwe.documentation.table.header.variabletype";
    private static final String PROPERTY_NAME_TABLE_COLUMN_ID = "propertyName";
    private static final String PROPERTY_NAME_TABLE_HEADER = "pwe.documentation.table.header.propertyname";
    private static final String PROPERTY_VALUE_TABLE_COLUMN_ID = "propertyValue";
    private static final String PROPERTY_VALUE_TABLE_HEADER = "pwe.documentation.table.header.propertyvalue";
    private static final String VARIABLE_DESCRIPTION = "pwe.documentation.text.variabledescription";
    private static final String VARIABLE_TYPE = "pwe.documentation.text.variabletype";
    private static final String ROLEUSERS_VALUES_EXT_ATTR_VALUE = "ROLEUSERS";
    private static final String USERLIST_VALUES_EXT_ATTR_VALUE = "USERLIST";
    private static final String ARRAY = "pwe.documentation.text.array";
    private static final String ARRAY_EXT_ATTR_NAME = "ARRAY";
    private static final String ARRAY_EXT_ATTR_VALUE = "TRUE";
    private static final String REQUIREMENT = "pwe.documentation.text.requirement";
    private static final String REQUIREMENT_EXT_ATTR_NAME = "REQUIREMENT";
    private static final String REQUIREMENT_EXT_ATTR_VALUE = "YES";
    private static final String READ_ONLY = "pwe.documentation.text.readonly";
    private static final String READONLY_EXT_ATTR_NAME = "READONLY";
    private static final String READONLY_EXT_ATTR_VALUE = "TRUE";
    private static final String YES = "pwe.documentation.text.yes";
    private static final String NO = "pwe.documentation.text.no";
    private static final String INITIAL_VALUE = "pwe.documentation.text.initialvalue";
    private static final String POSSIBLE_VALUES_LIST = "pwe.documentation.text.possiblevalueslist";
    private static final String VALUES_EXT_ATTR_NAME = "VALUES";
    private static final String POSSIBLE_VALUES_VARIABLE_REGEX = "<\\w+>";
    private static final String DATA_CHOOSER_PARAMETERS = "pwe.documentation.text.datachooserparameters";
    private static final String DATA_CHOOSER_TYPE = "pwe.documentation.text.type";
    private static final String DATA_CHOOSER_FORCE_SELECTION = "pwe.documentation.text.forceselection";
    private static final String DATA_CHOOSER_MAPPINGS = "pwe.documentation.text.mappings";
    @Autowired
    private TranslatorService translatorService;
    @Autowired
    private DefinedValueTranslationBuilder definedValueTranslationBuilder;
    @Autowired
    private DataChooserBuilder dataChooserBuilder;
    @Autowired
    private ParagraphContentsBuilder paragraphContentsBuilder;
    @Autowired
    private SpecificationDescriptionParagraphContentsBuilder specificationDescriptionParagraphContentsBuilder;
    @Autowired
    private SubchapterBuilder subchapterBuilder;

    @Override
    public void build(Documentation documentation, WorkflowProcess process, ProcessSpecification processSpecification, TranslationInfo translationInfo, DocumentationConfigDto documentationConfig) {
        documentation.addChapter(this.translatorService.translateDocumentationChapterTitle(CHAPTER_TITLE));
        this.buildSubchapters(documentation, process, processSpecification, translationInfo, documentationConfig);
    }

    private void buildSubchapters(Documentation documentation, WorkflowProcess process, ProcessSpecification processSpecification, TranslationInfo translationInfo, DocumentationConfigDto documentationConfig) {
        DataFields dataFields = process.getDataFields();
        if (!dataFields.isEmpty()) {
            if (DocumentationType.getByName(documentationConfig.getDocumentationType()) == DocumentationType.BUSINESS) {
                this.buildVariablesTable(documentation, process, processSpecification, translationInfo, dataFields);
            } else {
                Counter subchapterNo = new Counter(1);
                for (int i = 0; i < dataFields.size(); ++i) {
                    DataField dataField = (DataField)dataFields.get(i);
                    this.buildSubchapter(documentation, process, processSpecification, translationInfo, dataField, subchapterNo.getCountAndIncrement());
                }
            }
        }
    }

    private void buildVariablesTable(Documentation documentation, WorkflowProcess process, ProcessSpecification processSpecification, TranslationInfo translationInfo, DataFields dataFields) {
        TableHeaders headers = this.buildVariablesTableHeaders();
        TableRecords records = this.buildVariablesTableRecords(process, processSpecification, translationInfo, dataFields);
        documentation.addTable(headers, records);
    }

    private TableHeaders buildVariablesTableHeaders() {
        TableHeaders headers = new TableHeaders();
        headers.add(this.buildVariablesTableNameHeader());
        headers.add(this.buildVariablesTableDescriptionHeader());
        headers.add(this.buildVariablesTableTypeHeader());
        return headers;
    }

    private TableHeader buildVariablesTableNameHeader() {
        return TableUtils.buildTableHeader(VARIABLES_TABLE_NAME_COLUMN_ID, this.translatorService.translateMessage(NAME_TABLE_HEADER));
    }

    private TableHeader buildVariablesTableDescriptionHeader() {
        return TableUtils.buildTableHeader(VARIABLES_TABLE_DESCRIPTION_COLUMN_ID, this.translatorService.translateMessage(DESCRIPTION_TABLE_HEADER));
    }

    private TableHeader buildVariablesTableTypeHeader() {
        return TableUtils.buildTableHeader(VARIABLES_TABLE_TYPE_COLUMN_ID, this.translatorService.translateMessage(TYPE_TABLE_HEADER));
    }

    private TableRecords buildVariablesTableRecords(WorkflowProcess process, ProcessSpecification processSpecification, TranslationInfo translationInfo, DataFields dataFields) {
        TableRecords records = new TableRecords();
        for (int i = 0; i < dataFields.size(); ++i) {
            DataField dataField = (DataField)dataFields.get(i);
            records.add(this.buildVariablesTableRecord(process, processSpecification, translationInfo, dataField));
        }
        return records;
    }

    private TableRecord buildVariablesTableRecord(WorkflowProcess process, ProcessSpecification processSpecification, TranslationInfo translationInfo, DataField dataField) {
        VariableSpecification variableSpecification = this.getVariableSpecification(processSpecification, dataField);
        ParagraphContents contents = this.buildSpecificationDescriptionParagraphContents(process, translationInfo, variableSpecification.getDescription());
        contents.setIndents(ParagraphIndentsUtils.buildLeft(0));
        String variableName = this.translatorService.translateVariableName(translationInfo, process, dataField);
        String bookmarkName = this.buildBookmarkName(dataField);
        VariableType variableType = VariableType.getType(dataField);
        String variableTypeText = this.buildVariableTypeText(variableType);
        TableRecord record = new TableRecord();
        record.addCell(VARIABLES_TABLE_NAME_COLUMN_ID, this.buildTableCell(variableName, bookmarkName));
        record.addCell(VARIABLES_TABLE_DESCRIPTION_COLUMN_ID, this.buildTableCell(contents));
        record.addCell(VARIABLES_TABLE_TYPE_COLUMN_ID, this.buildTableCell(variableTypeText));
        return record;
    }

    private void buildSubchapter(Documentation documentation, WorkflowProcess process, ProcessSpecification processSpecification, TranslationInfo translationInfo, DataField dataField, int subchapterNo) {
        String title = this.buildSubchapterTitle(process, translationInfo, dataField, subchapterNo);
        String bookmarkName = this.buildBookmarkName(dataField);
        VariableSpecification variableSpecification = this.getVariableSpecification(processSpecification, dataField);
        TableHeaders headers = this.buildTableHeaders();
        TableRecords records = this.buildTableRecords(process, translationInfo, dataField, variableSpecification);
        documentation.addBookmarkedSubchapter(title, bookmarkName);
        this.buildPoint(documentation, headers, records);
        documentation.addNewLine();
    }

    private String buildSubchapterTitle(WorkflowProcess process, TranslationInfo translationInfo, DataField dataField, int subchapterNo) {
        StringBuilder title = new StringBuilder();
        title.append(subchapterNo);
        title.append(". ");
        title.append(this.translatorService.translateVariableName(translationInfo, process, dataField));
        return title.toString();
    }

    private String buildBookmarkName(DataField dataField) {
        return BookmarkNameUtils.getNameForProcessVariable(dataField.getId());
    }

    private VariableSpecification getVariableSpecification(ProcessSpecification processSpecification, DataField dataField) {
        String id = dataField.getId();
        if (MapUtils.isNotEmpty(processSpecification.getVariableSpecifications()) && processSpecification.getVariableSpecifications().containsKey(id)) {
            return processSpecification.getVariableSpecifications().get(id);
        }
        return new VariableSpecification();
    }

    private TableHeaders buildTableHeaders() {
        TableHeaders headers = new TableHeaders();
        headers.add(this.buildTablePropertyNameHeader());
        headers.add(this.buildTablePropertyValueHeader());
        return headers;
    }

    private TableHeader buildTablePropertyNameHeader() {
        return TableUtils.buildTableHeader(PROPERTY_NAME_TABLE_COLUMN_ID, this.translatorService.translateMessage(PROPERTY_NAME_TABLE_HEADER));
    }

    private TableHeader buildTablePropertyValueHeader() {
        return TableUtils.buildTableHeader(PROPERTY_VALUE_TABLE_COLUMN_ID, this.translatorService.translateMessage(PROPERTY_VALUE_TABLE_HEADER));
    }

    private TableRecords buildTableRecords(WorkflowProcess process, TranslationInfo translationInfo, DataField dataField, VariableSpecification variableSpecification) {
        VariableType variableType = VariableType.getType(dataField);
        TableRecords records = new TableRecords();
        if (StringUtils.isNotBlank((CharSequence)variableSpecification.getDescription())) {
            records.add(this.buildVariableDescriptionTableRecord(process, translationInfo, variableSpecification));
        }
        records.add(this.buildTypeTableRecord(variableType));
        records.add(this.buildArrayTableRecord(dataField));
        records.add(this.buildRequirementTableRecord(dataField));
        records.add(this.buildReadOnlyTableRecord(dataField));
        if (StringUtils.isNotBlank((CharSequence)dataField.getInitialValue())) {
            records.add(this.buildInitialValueTableRecord(dataField));
        }
        if (this.shouldBuildPossibleValuesTableRecord(dataField)) {
            records.add(this.buildPossibleValuesTableRecord(process, dataField));
        }
        if (variableType.equals((Object)VariableType.DATA_CHOOSER)) {
            DataChooser dataChooser = this.buildDataChooser(dataField);
            records.add(this.buildDataChooserParametersTableRecord());
            records.add(this.buildDataChooserTypeTableRecord(dataChooser));
            records.add(this.buildDataChooserForceSelectionTableRecord(dataChooser));
            if (CollectionUtils.isNotEmpty(dataChooser.getMappings())) {
                records.add(this.buildDataChooserMappingsTableRecord(process, dataChooser));
            }
        }
        return records;
    }

    private TableRecord buildVariableDescriptionTableRecord(WorkflowProcess process, TranslationInfo translationInfo, VariableSpecification variableSpecification) {
        ParagraphContents contents = this.buildSpecificationDescriptionParagraphContents(process, translationInfo, variableSpecification.getDescription());
        contents.setIndents(ParagraphIndentsUtils.buildLeft(0));
        return this.buildTableRecord(VARIABLE_DESCRIPTION, contents);
    }

    private TableRecord buildTypeTableRecord(VariableType variableType) {
        String text = this.buildVariableTypeText(variableType);
        return this.buildTableRecord(VARIABLE_TYPE, text);
    }

    private String buildVariableTypeText(VariableType variableType) {
        String type = variableType.name();
        return this.translatorService.translateDocumentationMessageForText(TextUtils.generateTranslationText(type));
    }

    private TableRecord buildArrayTableRecord(DataField dataField) {
        String text = this.buildArray(dataField);
        return this.buildTableRecord(ARRAY, text);
    }

    private String buildArray(DataField dataField) {
        ExtendedAttributes extAttrs = dataField.getExtendedAttributes();
        if (ExtAttrUtils.hasExtAttr(extAttrs, ARRAY_EXT_ATTR_NAME, "TRUE")) {
            return this.translatorService.translateMessage(YES);
        }
        return this.translatorService.translateMessage(NO);
    }

    private TableRecord buildRequirementTableRecord(DataField dataField) {
        String propertyValue = this.buildRequirement(dataField);
        return this.buildTableRecord(REQUIREMENT, propertyValue);
    }

    private String buildRequirement(DataField dataField) {
        ExtendedAttributes extAttrs = dataField.getExtendedAttributes();
        if (ExtAttrUtils.hasExtAttr(extAttrs, REQUIREMENT_EXT_ATTR_NAME, REQUIREMENT_EXT_ATTR_VALUE)) {
            return this.translatorService.translateMessage(YES);
        }
        return this.translatorService.translateMessage(NO);
    }

    private TableRecord buildReadOnlyTableRecord(DataField dataField) {
        String propertyValue = this.builReadOnly(dataField);
        return this.buildTableRecord(READ_ONLY, propertyValue);
    }

    private String builReadOnly(DataField dataField) {
        ExtendedAttributes extAttrs = dataField.getExtendedAttributes();
        if (ExtAttrUtils.hasExtAttr(extAttrs, READONLY_EXT_ATTR_NAME, "TRUE")) {
            return this.translatorService.translateMessage(YES);
        }
        return this.translatorService.translateMessage(NO);
    }

    private TableRecord buildInitialValueTableRecord(DataField dataField) {
        return this.buildTableRecord(INITIAL_VALUE, this.buildInitialValueText(dataField));
    }

    private String buildInitialValueText(DataField dataField) {
        return this.definedValueTranslationBuilder.build(dataField.getInitialValue());
    }

    private boolean shouldBuildPossibleValuesTableRecord(DataField dataField) {
        if (ExtAttrUtils.hasExtAttr(dataField.getExtendedAttributes(), VALUES_EXT_ATTR_NAME)) {
            String possibleValues = ExtAttrUtils.getExtAttrValue(dataField.getExtendedAttributes(), VALUES_EXT_ATTR_NAME);
            return !StringUtils.equals((CharSequence)possibleValues, (CharSequence)ROLEUSERS_VALUES_EXT_ATTR_VALUE) && !StringUtils.equals((CharSequence)possibleValues, (CharSequence)USERLIST_VALUES_EXT_ATTR_VALUE);
        }
        return false;
    }

    private TableRecord buildPossibleValuesTableRecord(WorkflowProcess process, DataField dataField) {
        List<String> values = this.buildValuesList(dataField.getExtendedAttributes());
        List<ParagraphContents> numberedList = this.buildPossibleValuesNumberedList(process, values);
        return this.buildTableRecord(POSSIBLE_VALUES_LIST, numberedList);
    }

    private List<String> buildValuesList(ExtendedAttributes extAttrs) {
        String values = ExtAttrUtils.getExtAttrValue(extAttrs, VALUES_EXT_ATTR_NAME);
        return Arrays.asList(values.split("\n"));
    }

    private List<ParagraphContents> buildPossibleValuesNumberedList(WorkflowProcess process, List<String> list) {
        ArrayList<ParagraphContents> numberedList = new ArrayList<ParagraphContents>();
        if (CollectionUtils.isNotEmpty(list)) {
            for (String text : list) {
                if (this.isVariablePossibleValue(process, text)) {
                    String id = StringUtils.substringBetween((String)text, (String)"<", (String)">");
                    numberedList.add(this.buildVariableContents(process, id));
                    continue;
                }
                numberedList.add(this.buildContents(text));
            }
        }
        return numberedList;
    }

    private boolean isVariablePossibleValue(WorkflowProcess process, String text) {
        if (text.matches(POSSIBLE_VALUES_VARIABLE_REGEX)) {
            String id = StringUtils.substringBetween((String)text, (String)"<", (String)">");
            return process.getDataFields().containsElement(id);
        }
        return false;
    }

    private ParagraphContents buildVariableContents(WorkflowProcess process, String id) {
        DataField dataField = process.getDataField(id);
        String text = dataField.getName();
        String bookmarkName = this.buildBookmarkName(dataField);
        return ParagraphContentsUtils.build(text, bookmarkName);
    }

    private ParagraphContents buildContents(String text) {
        return ParagraphContentsUtils.build(text);
    }

    private DataChooser buildDataChooser(DataField dataField) {
        return this.dataChooserBuilder.build(dataField);
    }

    private TableRecord buildDataChooserParametersTableRecord() {
        TableRecord record = new TableRecord();
        record.setMerged(true);
        record.addCell(this.buildTableCell(this.translatorService.translateMessage(DATA_CHOOSER_PARAMETERS)));
        return record;
    }

    private TableRecord buildDataChooserTypeTableRecord(DataChooser dataChooser) {
        String propertyValue = this.buildDataChooserType(dataChooser);
        return this.buildTableRecord(DATA_CHOOSER_TYPE, propertyValue);
    }

    private String buildDataChooserType(DataChooser dataChooser) {
        return this.translatorService.translateDocumentationMessageForText(dataChooser.getType());
    }

    private TableRecord buildDataChooserForceSelectionTableRecord(DataChooser dataChooser) {
        String propertyValue = this.buildDataChooserForceSelection(dataChooser);
        return this.buildTableRecord(DATA_CHOOSER_FORCE_SELECTION, propertyValue);
    }

    private String buildDataChooserForceSelection(DataChooser dataChooser) {
        if (dataChooser.isForceSelection()) {
            return this.translatorService.translateMessage(YES);
        }
        return this.translatorService.translateMessage(NO);
    }

    private TableRecord buildDataChooserMappingsTableRecord(WorkflowProcess process, DataChooser dataChooser) {
        List<ParagraphContents> numberedList = this.buildDataChooserNumberedList(process, dataChooser.getMappings());
        return this.buildTableRecord(DATA_CHOOSER_MAPPINGS, numberedList);
    }

    private List<ParagraphContents> buildDataChooserNumberedList(WorkflowProcess process, List<String> values) {
        return this.paragraphContentsBuilder.build(process, values);
    }

    private TableRecord buildTableRecord(String propertyNameKey, ParagraphContents contents) {
        TableRecord record = new TableRecord();
        record.addCell(PROPERTY_NAME_TABLE_COLUMN_ID, this.buildTableCell(this.translatorService.translateMessage(propertyNameKey)));
        record.addCell(PROPERTY_VALUE_TABLE_COLUMN_ID, this.buildTableCell(contents));
        return record;
    }

    private TableRecord buildTableRecord(String propertyNameKey, String propertyValue) {
        TableRecord record = new TableRecord();
        record.addCell(PROPERTY_NAME_TABLE_COLUMN_ID, this.buildTableCell(this.translatorService.translateMessage(propertyNameKey)));
        record.addCell(PROPERTY_VALUE_TABLE_COLUMN_ID, this.buildTableCell(propertyValue));
        return record;
    }

    private TableRecord buildTableRecord(String propertyNameKey, List<ParagraphContents> numberedList) {
        TableRecord record = new TableRecord();
        record.addCell(PROPERTY_NAME_TABLE_COLUMN_ID, this.buildTableCell(this.translatorService.translateMessage(propertyNameKey)));
        record.addCell(PROPERTY_VALUE_TABLE_COLUMN_ID, this.buildTableCell(numberedList));
        return record;
    }

    private TableCell buildTableCell(ParagraphContents contents) {
        return TableUtils.buildTableCell(contents);
    }

    private TableCell buildTableCell(String text) {
        return TableUtils.buildTableCell(text);
    }

    private TableCell buildTableCell(String text, String bookmarkName) {
        TableCell tableCell = this.buildTableCell(text);
        tableCell.setBookmarkName(bookmarkName);
        return tableCell;
    }

    private TableCell buildTableCell(List<ParagraphContents> numberedList) {
        return TableUtils.buildTableCell(numberedList);
    }

    private ParagraphContents buildSpecificationDescriptionParagraphContents(WorkflowProcess process, TranslationInfo translationInfo, String description) {
        return this.specificationDescriptionParagraphContentsBuilder.build(process, translationInfo, description);
    }

    private void buildPoint(Documentation documentation, TableHeaders headers, TableRecords records) {
        this.subchapterBuilder.build(documentation, headers, records);
    }
}

