Ext.ux.suncode.PackagePanel = function( config ) {
    config = Ext.apply( {
        id: 'package_panel',
        title: getTranslation( 'Definicja pakietu' ),
        iconCls: 'x-Module-packagePanel',
        region: 'west',
        layout: 'fit',
        collapsible: true,
        titleCollapse: true,
        animCollapse: config.animationsOn,
        width: 200,
        useArrows: true,
        autoScroll: true,
        animate: config.animationsOn,
        containerScroll: true,
        enableDD: true,
        dropConfig: new Ext.ux.suncode.TreeNodeInternalDropConfig(),
        frame: false,
        border: false,
        style: 'border-width: 1px; border-radius: 8px;',
        hidden: !config.editionMode,
        bodyCssClass: 'x-Module-whiteBody',
        root: new Ext.ux.suncode.PackageNode( config )
    }, config );

    Ext.ux.suncode.PackagePanel.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.PackagePanel, Ext.tree.TreePanel, {
    initComponent: function() {
        Ext.ux.suncode.PackagePanel.superclass.initComponent.call( this );
    },
    findProcess: function( processDefId ) {
        return this.getRootNode().findChild( 'processDefId', processDefId );
    },
    findActivity: function( processDefId, activityDefId ) {
        return this.findProcess( processDefId ).findChild( 'activityDefId', activityDefId );
    },
    selectProcess: function( processDefId ) {
        var processNode = this.findProcess( processDefId );
        this.selectPath( processNode.getPath() );
        processNode.fireEvent( 'click', processNode );
    },
    selectActivity: function( processNode, activityDefId ) {
        var activityNode = this.findActivity( processNode.attributes.processDefId, activityDefId );
        this.selectPath( activityNode.getPath() );
        activityNode.fireEvent( 'click', activityNode );
    },
    exit: function() {
        this.getEl().slideOut( 'l', {
            easing: 'bounceOut',
            duration: 1,
            remove: true,
            useDisplay: false,
            callback: function() {
                Ext.getCmp( 'main_panel' ).exit();
            }
        } );
    }
} );

Ext.ux.suncode.PackageNode = function( config ) {
    config = Ext.apply( {
        text: getTranslation( 'Pakiet' ),
        icon: getPluginImgPath( 'package' ),
        draggable: false,
        allowDrop: false,
        currentProcessNo: 0,
        packageId: generateId( getTranslation( 'Pakiet' ), Ext.ux.suncode.Constants.PACKAGE_ID_MAX_LENGTH ),
        packageName: getTranslation( 'Pakiet' ),
        packageDescr: '',
        packageAuthor: '',
        packageCreationTime: new Date().format( 'Y-m-d H:i:s' ),
        scriptType: 'text/javascript',
        scriptVersion: '',
        scriptGrammar: '',
        idChanged: false,
        participants: new Array(),
        applications: new Array(),
        eventActionIdCounter: 1,
        sortOrder: {
          attributeName: '',
          asc: true
        },
        listeners: {
            contextmenu: function( node, e ) {
                e.stopEvent();
                this.showContextMenu( e.getXY() );
            },
            dblclick: function( node, e ) {
                showPackageProperties( node );
            }
        }
    }, config );

    Ext.ux.suncode.PackageNode.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.PackageNode, Ext.tree.TreeNode, {
    initComponent: function() {
        Ext.ux.suncode.PackageNode.superclass.initComponent.call( this );
    },
    setPackageAuthor: function( packageAuthor ) {
        this.attributes.packageAuthor = packageAuthor;
    },
    isIdUnique: function( processDefId ) {
        if ( this.findChild( 'processDefId', processDefId ) ) {
            return false;
        }
        return true;
    },
    updatePackageDef: function( def ) {
        var packageId = def.packageId;
        var packageName = def.packageName;
        var packageNameTranslation = getXpdlPackageNameTranslation( packageId, packageName );
        this.setText( packageNameTranslation );
        this.attributes.packageId = packageId;
        this.attributes.packageName = packageName;
        this.attributes.packageDescr = def.packageDescr;
        this.attributes.packageAuthor = def.packageAuthor;
        this.attributes.scriptType = def.scriptType;
        this.attributes.scriptVersion = def.scriptVersion;
        this.attributes.scriptGrammar = def.scriptGrammar;
        this.attributes.idChanged = true;
    },
    findParticipant: function( roleId ) {
        var participants = this.attributes.participants;
        for ( var i = 0; i < participants.length; i++ ) {
            if ( roleId == participants[i].roleId ) {
                return participants[i];
            }
        }
        return null;
    },
    addParticipant: function( participant ) {
        this.attributes.participants.push( participant );
        Ext.getCmp( 'main_panel' ).setSaved( false );
    },
    removeParticipant: function( roleId ) {
        var participants = this.attributes.participants;
        for ( var i = 0; i < participants.length; i++ ) {
            if ( roleId == participants[i].roleId ) {
                participants.splice( i, 1 );
                Ext.getCmp( 'main_panel' ).setSaved( false );
                break;
            }
        }
    },
    updateParticipant: function( oldRoleId, participant ) {
        var participants = this.attributes.participants;
        for ( var i = 0; i < participants.length; i++ ) {
            if ( oldRoleId == participants[i].roleId ) {
                participants[i] = participant;
                Ext.getCmp( 'main_panel' ).setSaved( false );
                break;
            }
        }
    },
    findApplication: function( appId ) {
        var applications = this.attributes.applications;
        for ( var i = 0; i < applications.length; i++ ) {
            if ( appId == applications[i].id ) {
                return applications[i];
            }
        }
        return null;
    },
    addApplication: function( appObj ) {
        this.attributes.applications.push( appObj );
        Ext.getCmp( 'main_panel' ).setSaved( false );
    },
    loadApplications: function( apps ) {
        this.attributes.applications = apps ? apps : new Array();
    },
    removeApplication: function( appId ) {
        var applications = this.attributes.applications;
        for ( var i = 0; i < applications.length; i++ ) {
            if ( appId == applications[i].id ) {
                applications.splice( i, 1 );
                Ext.getCmp( 'main_panel' ).setSaved( false );
                break;
            }
        }

        this.eachChild( function( processNode ) {
            processNode.removeApplication( appId );
        } );
    },
    updateApplication: function( oldAppId, appObj ) {
        var applications = this.attributes.applications;
        for ( var i = 0; i < applications.length; i++ ) {
            if ( oldAppId == applications[i].id ) {
                applications[i] = appObj;
                this.eachChild( function( processNode ) {
                    processNode.updateApplicationDefinitionForActivities( oldAppId, appObj );
                } );
                Ext.getCmp( 'main_panel' ).setSaved( false );
                break;
            }
        }
    },
    updateApplicationDescription: function( appId, descrption ) {
    	var applications = this.attributes.applications;
        for ( var i = 0; i < applications.length; i++ ) {
            if ( appId == applications[i].id ) {
                applications[i].descr = descrption;
                Ext.getCmp( 'main_panel' ).setSaved( false );
                break;
            }
        }
    },
    getAndIncrementEventActionIdCounter: function() {
      var counter = this.attributes.eventActionIdCounter;
      this.attributes.eventActionIdCounter++;

      return counter
    },
    loadEventActionIdCounter: function( counter ) {
      this.attributes.eventActionIdCounter = counter;
    },
    resetPackage: function() {
    	  var mainPanel = Ext.getCmp( 'main_panel' );
        this.setText( getTranslation( 'Pakiet' ) );
        this.attributes.currentProcessNo = 0;
        this.attributes.packageId = generateId( getTranslation( 'Pakiet' ), Ext.ux.suncode.Constants.PACKAGE_ID_MAX_LENGTH );
        this.attributes.packageName = getTranslation( 'Pakiet' );
        this.attributes.packageDescr = '';
        this.attributes.packageAuthor = mainPanel.getUserName();
        this.attributes.packageCreationTime = new Date().format( 'Y-m-d H:i:s' );
        this.attributes.scriptType = 'text/javascript';
        this.attributes.scriptVersion = '';
        this.attributes.scriptGrammar = '';
        this.attributes.idChanged = false;

        clearArray( this.attributes.participants );
        clearArray( this.attributes.applications );

        this.removeAll( false );
    },
    getProcessSpecifications: function( processDefId ) {
        var specifications = new Array();

        if ( this.hasChildNodes() ) {
            this.eachChild( function( processNode ) {
            	if ( Ext.isEmpty( processDefId ) || processDefId === processNode.attributes.processDefId ) {
	                var specification = processNode.attributes.specification;
	                specification = Ext.apply( specification, {
	                    id: processNode.attributes.processDefId
	                } );
	
	                specifications.push( specification );
            	}
            } );
        }

        return specifications;
    },
    getFormPreviewProcessDataSets: function( processDefId ) {
    	var processDataSets = new Array();

        if ( this.hasChildNodes() ) {
            this.eachChild( function( processNode ) {
            	if ( Ext.isEmpty( processDefId ) || processDefId === processNode.attributes.processDefId ) {
	                var dataSets = new Object();
	                dataSets = Ext.apply( dataSets, {
	                    id: processNode.attributes.processDefId,
	                    dataSets: processNode.attributes.formPreview.dataSets
	                } );
	
	                processDataSets.push( dataSets );
            	}
            } );
        }

        return processDataSets;
    },
    getProcessGlobalSettings: function( processDefId ) {
    	var processGlobalSettings = new Array();

        if ( this.hasChildNodes() ) {
            this.eachChild( function( processNode ) {
            	if ( Ext.isEmpty( processDefId ) || processDefId === processNode.attributes.processDefId ) {
	                var globalSettings = new Object();
	                globalSettings = Ext.apply( globalSettings, processNode.attributes.globalSettings );
	                globalSettings = Ext.apply( globalSettings, {
	                    id: processNode.attributes.processDefId,
	                } );
	
	                processGlobalSettings.push( globalSettings );
            	}
            } );
        }

        return processGlobalSettings;
    },
    getAttachmentDirectories: function( processDefId ) {
      var attachmentDirectories = new Array();

      if ( this.hasChildNodes() ) {
        this.eachChild( function( processNode ) {
          if ( Ext.isEmpty( processDefId ) || processDefId === processNode.attributes.processDefId ) {
            attachmentDirectories.push( processNode.attributes.attachmentDirectory );
          }
        } );
      }

      return attachmentDirectories;
    },
    setSortOrder: function( attributeName, asc ) {
      this.attributes.sortOrder = {
        attributeName: attributeName,
        asc: asc
      };
    },
    sortProcesses: function() {
        if ( !Ext.isEmpty( this.attributes.sortOrder.attributeName ) ) {
          sortNode( this, this.attributes.sortOrder.attributeName, this.attributes.sortOrder.asc );
        }
    },
    showContextMenu: function( pos ) {
      var items = new Array();
      items.push( new Ext.menu.Item( {
        cls: 'x-btn-text-icon',
        icon: getPluginImgPath( 'down' ),
        text: getTranslation( 'Rozwiń wszystkie' ),
        scope: this,
        handler: function() {
          expandAllProcessesAndActivities( this );
        }
      } ) );
      items.push( new Ext.menu.Item( {
        cls: 'x-btn-text-icon',
        icon: getPluginImgPath( 'up' ),
        text: getTranslation( 'Zwiń wszystkie' ),
        scope: this,
        handler: function() {
          collapseAllProcessesAndActivities( this );
        }
      } ) );
      items.push( new Ext.menu.Separator() );
      items.push( new Ext.menu.Item( {
        cls: 'x-btn-text-icon',
        icon: getPluginImgPath( 'package_add' ),
        text: menuTextWithHotkey( getTranslation( 'Dodaj proces' ), 'Ctrl+N' ),
        scope: this,
        handler: function() {
          createNewProcess( {
            initialProcessNameMask: 'VER'
          } );
        }
      } ) );
      items.push( new Ext.menu.Item( {
        cls: 'x-btn-text-icon',
        icon: getPluginImgPath( 'package_validate' ),
        text: menuTextWithHotkey( getTranslation( 'Waliduj' ), 'Ctrl+W' ),
        handler: validateXpdl
      } ) );
      items.push( new Ext.menu.Item( {
        cls: 'x-btn-text-icon',
        icon: getPluginImgPath( 'translations' ),
        text: getTranslation( 'Tłumaczenia' ),
        handler: showPackageTranslations
      } ) );
      items.push( new Ext.menu.Separator() );
      items.push( new Ext.menu.Item( {
        cls: 'x-btn-text-icon',
        icon: getPluginImgPath( 'sort' ),
        text: getTranslation( 'Sortuj procesy' ),
        menu: new Ext.menu.Menu( {
          items: [ {
            cls: 'x-btn-text-icon',
            icon: getPluginImgPath( 'alphabet' ),
            text: getTranslation( 'Alfabetycznie rosnąco' ),
            scope: this,
            handler: function() {
              this.setSortOrder( 'processName', true );
              this.sortProcesses();
            }
          }, {
            cls: 'x-btn-text-icon',
            icon: getPluginImgPath( 'alphabet' ),
            text: getTranslation( 'Alfabetycznie malejąco' ),
            scope: this,
            handler: function() {
              this.setSortOrder( 'processName', false );
              this.sortProcesses();
            }
          }, {
            cls: 'x-btn-text-icon',
            icon: getPluginImgPath( 'time' ),
            text: getTranslation( 'Czas utworzenia' ),
            scope: this,
            handler: function() {
              this.setSortOrder( 'processCreationTime', true );
              this.sortProcesses();
            }
          } ]
        } )
      } ) );
      items.push( new Ext.menu.Item( {
        cls: 'x-btn-text-icon',
        icon: getPluginImgPath( 'properties' ),
        text: menuTextWithHotkey( getTranslation( 'Właściwości' ), 'F2' ),
        scope: this,
        handler: function() {
          showPackageProperties( this );
        }
      } ) );

      var menu = new Ext.menu.Menu( {
        items: items
      } );
      menu.showAt( pos );
    }
} );

Ext.ux.suncode.PaperPanel = function( config ) {
    config = Ext.apply( {
        id: 'paper_panel',
        items: new Array(),
        enableTabScroll: true,
        region: 'center',
        closable: false,
        collapsible: false,
        tbar: new Ext.ux.suncode.PaperPanelTopToolbar( config ),
        bbar: new Ext.Toolbar( {
            hidden: !config.editionMode,
            items: [ {
                xtype: 'tbtext',
                id: 'paper_panel_message_field',
                text: emptyMessageToolbar()
            } ]
        } ),
        listeners: {
            beforetabchange: function( panel, newTab, currentTab ) {
                panel.getTopToolbar().deactivateUsedButton();
            },
            tabchange: function( panel, tab ) {
                if ( !Ext.isEmpty( tab ) ) {
                    var packagePanel = Ext.getCmp( 'package_panel' );
                    var processNode = packagePanel.findProcess( tab.processDefId );
                    packagePanel.selectPath( processNode.getPath() );
                }
            },
            contextmenu: function( panel, tab, e ) {
                e.stopEvent();
                panel.setActiveTab( tab );
                var processNode = Ext.getCmp( 'package_panel' ).findProcess( tab.processDefId );
                processNode.showContextMenu( e.getXY() );
            }
        }
    }, config );

    Ext.ux.suncode.PaperPanel.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.PaperPanel, Ext.TabPanel, {
    initComponent: function() {
        Ext.ux.suncode.PaperPanel.superclass.initComponent.call( this );
    },
    removeProcess: function( processDefId ) {
        var tab = this.find( 'processDefId', processDefId )[0];
        this.remove( tab );

        if ( this.items.length > 0 ) {
            this.setActiveTab( 0 );
        }
    },
    updateProcessTab: function( oldProcessDefId, newProcessDefId, processName, processColor ) {
        var tabs = this.find( 'processDefId', oldProcessDefId );

        if ( !Ext.isEmpty( tabs ) ) {
            var tab = tabs[0];
            tab.processDefId = newProcessDefId;
            var processNameTranslation = getXpdlProcessNameTranslation( newProcessDefId, processName );
            tab.setTitle( tab.getPanelText( processNameTranslation, processColor ) );
        }
    },
    findProcessTab: function( processDefId ) {
        var tabs = this.items.items;

        for ( var i = 0; i < tabs.length; i++ ) {
            if ( processDefId == tabs[i].processDefId ) {
                return tabs[i];
            }
        }

        return null;
    },
    resetPanel: function() {
        this.items.each( function( item, index, length ) {
            item.paper.clear();
        } );
        this.suspendEvents();
        this.removeAll( true );
        this.resumeEvents();
    },
    setSnapToGrid: function( snapToGrid ) {
    	this.items.each( function( item, index, length ) {
    		var paper = item.paper;
    		paper = Ext.apply( paper, {
    			snapToGrid: snapToGrid
    		} );
        } );
    },
    setShowGrid: function( showGrid ) {
    	this.items.each( function( item, index, length ) {
    		var paper = item.paper;
    		paper = Ext.apply( paper, {
    			showGrid: showGrid
    		} );
        } );
    }, 
    setGridSize: function( gridSize ) {
    	this.items.each( function( item, index, length ) {
    		var paper = item.paper;
    		paper = Ext.apply( paper, {
    			gridSize: gridSize
    		} );
        } );
    },
    showGrids: function() {
    	this.items.each( function( item, index, length ) {
    		var paper = item.paper;
    		paper.bpmn.showGrid( paper );
        } );
    },
    hideGrids: function() {
    	this.items.each( function( item, index, length ) {
    		var paper = item.paper;
    		paper.bpmn.hideGrid( paper );
        } );
    },
    redrawGrids: function() {
    	this.items.each( function( item, index, length ) {
    		var paper = item.paper;
    		paper.bpmn.redrawGrid( paper );
        } );
    },
    exit: function() {
        this.getEl().slideOut( 'r', {
            easing: 'bounceOut',
            duration: 1,
            remove: true,
            useDisplay: false,
            callback: function() {
                Ext.getCmp( 'package_panel' ).exit();
            }
        } );
    }
} );

Ext.ux.suncode.ProcessPanel = function( config ) {
    config = Ext.apply( {
        tabTip: getProcessTabTip( config.processDefId ),
        autoScroll: true,
        layout: 'fit',
        collapsible: false,
        closable: Ext.getCmp( 'main_panel' ).isEditionModeActive(),
        hideBorders: true,
        paper: null,
        objToDraw: null,
        objToDrawType: '',
        connectingStarted: false,
        xStart: 0,
        yStart: 0,
        customLineType: '',
        connectFrom: null,
        connectTo: null,
        condLineType: '',
        conditionalLineStep: 0,
        objStorage: new Object(),
        currentTaskNo: 1,
        currentRoleNo: 1,
        currentSystemNo: 1,
        currentBufferNo: 1,
        processDefId: config.processDefId,
        listeners: {
            render: function( panel ) {
                var panelBody = panel.getEl();
                panelBody.on( 'click', panel.onClick, panel );
                panelBody.on( 'contextmenu', panel.onContextMenu, panel );
            }
        }
    }, config );

    Ext.ux.suncode.ProcessPanel.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.ProcessPanel, Ext.Panel, {
    initComponent: function() {
        Ext.ux.suncode.ProcessPanel.superclass.initComponent.call( this );

        this.on( 'afterrender', this.onAfterRender, this );
        this.on( 'beforeclose', this.onBeforeClose, this );
    },
    onAfterRender: function() {
        var paperPanel = Ext.getCmp( 'paper_panel' );
        var tab = Ext.get( paperPanel.getTabEl( this ) );
        tab.on( 'dblclick', handleProcessFullScreen );
    },
    onBeforeClose: function() {
        var paperPanel = Ext.getCmp( 'paper_panel' );
        paperPanel.hideTabStripItem( this );
        this.hide();

        var items = paperPanel.items.items;
        for ( var i = 0; i < items.length; i++ ) {
            var item = items[i];
            var tab = Ext.get( paperPanel.getTabEl( item ) );

            if ( tab.isVisible() ) {
                paperPanel.setActiveTab( item );
            }
        }

        return false;
    },
    onMouseMove: function() {
        this.body.on( 'mousemove', this.executeMouseMove, this );
    },
    unMouseMove: function() {
        if ( this.objToDraw ) {
            this.objToDraw.remove();
            this.objToDraw = null;
        }

        this.resetConnecting();
        this.clearStorage();
        this.objToDrawType = '';
        this.conditionalLineStep = 0;
        this.paper.bpmn.hoverBlocked = false;
        this.body.un( 'mousemove', this.executeMouseMove, this );
    },
    executeMouseMove: function( e ) {
        var pos = this.getPaperPos( e );
        var x = pos.x;
        var y = pos.y;
        this.drawTooltip( x, y );
    },
    isLineOutOfFields: function( x, y ) {
        if ( x < this.paper.bpmn.roleWidth || y > this.paper.lastRoleYPos || x > this.paper.lastRoleXPos ) {
            this.drawTooltip( x, y );
            return true;
        }

        return false;
    },
    basicConnectionPossible: function( x, y ) {
        var el = this.paper.bpmn.getConnector( this.paper, x, y );

        if ( el ) {
            if ( !this.connectFrom ) {
                if ( !this.paper.bpmn.isConnBeginningAvailable( 'BASIC', el, this.processDefId ) ) {
                    return false;
                }

                this.connectFrom = el;
                return true;
            }

            if ( !this.paper.bpmn.isConnEndingAvailable( 'BASIC', el, this.connectFrom, this.processDefId ) ) {
                return false;
            }

            this.connectTo = el;
            return true;
        } else if ( !this.connectFrom ) {
            return false;
        }

        if ( this.isLineOutOfFields( x, y ) ) {
            return false;
        }

        var basicLineSet = this.paper.bpmn.basicLine( this.paper, this.connectFrom, this.connectTo, x, y, false, false );
        var line = basicLineSet.splice( 0, 1 )[0];
        line = line.data( 'connectFrom', this.connectFrom );
        var pathAttr = line.attr( 'path' );
        var endPointAtLength = Raphael.getPointAtLength( pathAttr, line.getTotalLength() );
        this.addToStorage( 'customLine', line );
        basicLineSet.remove();
        this.objToDrawType = 'customLine';
        this.customLineType = 'BASIC';
        this.xStart = endPointAtLength.x;
        this.yStart = endPointAtLength.y;
    },
    condConnectionPossible: function( x, y ) {
        switch ( this.conditionalLineStep ) {
            case 0:
                var el = this.paper.bpmn.getConnector( this.paper, x, y );
                if ( el ) {
                    if ( !this.paper.bpmn.isConnBeginningAvailable( this.condLineType, el, this.processDefId ) ) {
                        return false;
                    }

                    if ( el.data( 'isBox' ) ) {
                        this.paper.bpmn.conditionBox = el;
                        this.connectFrom = el.data( 'connectFrom' );
                        this.conditionalLineStep = 3;
                    } else {
                        this.connectFrom = el;
                        this.conditionalLineStep++;
                    }

                    this.connectingStarted = true;
                    return true;
                }
                return false;
                break;
            case 1:
                var el = this.paper.bpmn.getConnector( this.paper, x, y );
                if ( !el ) {
                    if ( this.isLineOutOfFields( x, y ) ) {
                        return false;
                    }

                    this.conditionalLineStep++;
                    return true;
                }
                return false;
                break;
            case 2:
                return true;
                break;
            case 3:
                var el = this.paper.bpmn.getConnector( this.paper, x, y );
                if ( el ) {
                    if ( !this.paper.bpmn.isConnEndingAvailable( this.condLineType, el, this.connectFrom, this.processDefId ) ) {
                        return false;
                    }

                    this.connectTo = el;
                    this.conditionalLineStep++;
                    return true;
                } else {
                    if ( this.isLineOutOfFields( x, y ) ) {
                        return false;
                    }

                    var condLineSet = this.paper.bpmn.conditionalLine( this.paper, this.condLineType, this.conditionalLineStep, this.connectFrom,
                                    this.connectTo, x, y, false, false );
                    var line = condLineSet.splice( 0, 1 )[0];
                    line = line.data( 'connectFrom', this.connectFrom );
                    var pathAttr = line.attr( 'path' );
                    var endPointAtLength = Raphael.getPointAtLength( pathAttr, line.getTotalLength() );
                    this.addToStorage( 'customLine', line );
                    condLineSet.remove();
                    this.objToDrawType = 'customLine';
                    this.customLineType = this.condLineType;
                    this.xStart = endPointAtLength.x;
                    this.yStart = endPointAtLength.y;
                }
                break;
            default:
                return false;
                break;
        }
    },
    otherwiseConnectionPossible: function( x, y ) {
        var el = this.paper.bpmn.getConnector( this.paper, x, y );

        if ( el ) {
            if ( !this.connectFrom ) {
                if ( !this.paper.bpmn.isConnBeginningAvailable( 'OTHERWISE', el, this.processDefId ) ) {
                    return false;
                }

                this.connectFrom = el;
                return true;
            }

            if ( !this.paper.bpmn.isConnEndingAvailable( 'OTHERWISE', el, this.connectFrom, this.processDefId ) ) {
                return false;
            }

            this.connectTo = el;
            return true;
        } else if ( !this.connectFrom ) {
            return false;
        }

        if ( this.isLineOutOfFields( x, y ) ) {
            return false;
        }

        var otherwiseLineSet = this.paper.bpmn.otherwiseLine( this.paper, this.connectFrom, this.connectTo, x, y, false, false );
        var line = otherwiseLineSet.splice( 0, 1 )[0];
        line = line.data( 'connectFrom', this.connectFrom );
        var pathAttr = line.attr( 'path' );
        var endPointAtLength = Raphael.getPointAtLength( pathAttr, line.getTotalLength() );
        this.addToStorage( 'customLine', line );
        otherwiseLineSet.remove();
        this.objToDrawType = 'customLine';
        this.customLineType = 'OTHERWISE';
        this.xStart = endPointAtLength.x;
        this.yStart = endPointAtLength.y;
    },
    deadlineConnectionPossible: function( x, y ) {
        var el = this.paper.bpmn.getConnector( this.paper, x, y );

        if ( el ) {
            if ( !this.connectFrom ) {
                if ( !this.paper.bpmn.isConnBeginningAvailable( 'EXCEPTION', el, this.processDefId ) ) {
                    return false;
                }

                this.connectFrom = el;
                return true;
            }

            if ( !this.paper.bpmn.isConnEndingAvailable( 'EXCEPTION', el, this.connectFrom, this.processDefId ) ) {
                return false;
            }

            this.connectTo = el;
            return true;
        } else if ( !this.connectFrom ) {
            return false;
        }

        if ( this.isLineOutOfFields( x, y ) ) {
            return false;
        }

        var deadlineLineSet = this.paper.bpmn.deadlineLine( this.paper, this.connectFrom, this.connectTo, x, y, false, false );
        var line = deadlineLineSet.splice( 0, 1 )[0];
        line = line.data( 'connectFrom', this.connectFrom );
        var pathAttr = line.attr( 'path' );
        var endPointAtLength = Raphael.getPointAtLength( pathAttr, line.getTotalLength() );
        this.addToStorage( 'customLine', line );
        var clockImg = deadlineLineSet.pop();
        this.addToStorage( 'deadlineClock', clockImg );
        deadlineLineSet.remove();
        this.objToDrawType = 'customLine';
        this.customLineType = 'EXCEPTION';
        this.xStart = endPointAtLength.x;
        this.yStart = endPointAtLength.y;
    },
    resetConnecting: function() {
        this.connectingStarted = false;
        this.xStart = 0;
        this.yStart = 0;
        this.customLineType = '';
        this.connectFrom = null;
        this.connectTo = null;
        this.condLineType = '';
        this.conditionalLineStep = 0;
    },
    onClick: function( e ) {
        if ( !this.objToDraw ) {
            return;
        }

        var paper = this.paper;
        paper.bpmn.eraseAllTrashes( paper );
        paper.bpmn.eraseAllTrashesWithDelay( paper, 210 );
        var pos = this.getPaperPos( e );
        var x = pos.x;
        var y = pos.y;

        var objType = this.objToDraw.setType;
        if ( !objType ) {
            objType = this.objToDraw[0].data( 'setType' );
        }
        if ( objType == 'disabled' ) {
            return;
        }

        this.objToDraw.remove();

        switch ( objType ) {
            case 'startTooltip':
                this.drawStart( x, y );
                break;
            case 'stopTooltip':
                this.drawStop( x, y );
                break;
            case 'roleTooltip':
                this.drawRole( x, y );
                break;
            case 'systemTooltip':
                this.drawSystem( x, y );
                break;
            case 'buforTooltip':
                this.drawBufor( x, y );
                break;
            case 'routeTooltip':
                this.drawRoute( x, y );
                break;
            case 'activityTooltip':
                this.drawActivity( x, y );
                break;
            case 'toolTooltip':
                var component = this.getFromStorage( 'applicationIntegrationComponent' );

                if ( !Ext.isEmpty( component ) ) {
                    this.drawApplicationIntegrationComponent( x, y );
                } else {
                    this.drawTool( x, y );
                }
                break;
            case 'subflowTooltip':
                this.drawSubflow( x, y );
                break;
            case 'basicLineTooltip':
                this.drawBasicLine( x, y );
                break;
            case 'conditionalLineTooltip':
                this.drawConditionalLine( x, y );
                break;
            case 'otherwiseLineTooltip':
                this.drawOtherwiseLine( x, y );
                break;
            case 'deadlineLineTooltip':
                this.drawDeadlineLine( x, y );
                break;
            case 'basicLineWithRouteTooltip':
                this.drawBasicLineWithRoute( x, y );
                break;
            case 'conditionalLineWithRouteTooltip':
                this.drawConditionalLineWithRoute( x, y );
                break;
            case 'basicLineWithActivityTooltip':
                this.drawBasicLineWithActivity( x, y );
                break;
            case 'conditionalLineWithActivityTooltip':
                this.drawConditionalLineWithActivity( x, y );
                break;
            case 'basicLineWithToolTooltip':
                this.drawBasicLineWithTool( x, y );
                break;
            case 'conditionalLineWithToolTooltip':
                this.drawConditionalLineWithTool( x, y );
                break;
            case 'basicLineWithSubflowTooltip':
                this.drawBasicLineWithSubflow( x, y );
                break;
            case 'conditionalLineWithSubflowTooltip':
                this.drawConditionalLineWithSubflow( x, y );
                break;
            case 'basicLineWithStartTooltip':
                this.drawBasicLineWithStart( x, y );
                break;
            case 'basicLineWithStopTooltip':
                this.drawBasicLineWithStop( x, y );
                break;
            case 'customLineTooltip':
                this.drawCustomLine( x, y );
                break;
            default:
                break;
        }
    },
    onContextMenu: function( e ) {
        e.stopEvent();
        var paperPanel = Ext.getCmp( 'paper_panel' );
        var paperToolbar = paperPanel.getTopToolbar();
        if ( paperToolbar.deactivateUsedButton() ) {
            return;
        }

        if ( !this.paper.bpmn.editionMode ) {
            return;
        }

        var set = this.getSetUnderClick( e );
        if ( set.length == 0 ) {
            return;
        }

        var setType = set[0].data( 'setType' );
        var packagePanel = Ext.getCmp( 'package_panel' );
        var processNode = packagePanel.findProcess( this.processDefId );
        if ( setType == 'roleHeader' || setType == 'systemHeader' ) {
            this.paper.bpmn.eraseAllTrashes( this.paper );
            var roleEl = set[0];
            this.showRoleMenu( e, processNode, roleEl );
            return;
        }

        var el = this.getElem( set );
        if ( !el ) {
            return;
        }
        setType = el.data( 'setType' );

        if ( setType == 'start' || setType == 'stop' ) {
            this.paper.bpmn.eraseAllTrashes( this.paper );
            this.showStartStopMenu( e, el );
        }
    },
    initAddActivity: function( activity, x, y, iconImg ) {
        if ( this.verifyDisabled( activity ) ) {
            this.drawTooltip( x, y );
            if ( this.objToDraw ) {
                this.objToDraw.toFront();
            }
            this.addActivity( activity, x, y, iconImg );
            this.currentTaskNo++;
        }
    },
    addActivity: function( activity, x, y, iconImg ) {
        var packagePanel = Ext.getCmp( 'package_panel' );
        var processNode = packagePanel.findProcess( this.processDefId );
        var actNo = processNode.attributes.currentActivityNo;
        var a = activity[0];
        var activityNode = new Ext.ux.suncode.ActivityNode( {
            iconImg: iconImg,
            currentActivityNo: actNo,
            processDefId: processNode.attributes.processDefId,
            activityDefId: a.data( 'activityDefId' ),
            activityName: a.data( 'activityName' ),
            activityType: a.data( 'activityType' ),
            roleName: a.data( 'roleName' ),
            roleId: a.data( 'roleId' ),
            xOffset: parseInt( a.data( 'xOffset' ) ),
            yOffset: parseInt( a.data( 'yOffset' ) )
        } );
        processNode.addActivity( activityNode );
        processNode.incrementActivityNo();
        Ext.ux.suncode.DocumentationService.addActivitySpecification( processNode, activityNode.attributes.activityDefId,
                        activityNode.attributes.specification );
    },
    getSetUnderClick: function( e ) {
        var pos = this.getPaperPos( e );
        return this.paper.getElementsByPoint( pos.x, pos.y );
    },
    getElem: function( set ) {
        for ( var i = 0; i < set.length; i++ ) {
            var setType = set[i].data( 'setType' );
            if ( setType == 'route' || setType == 'activity' || setType == 'tool' || setType == 'subflow' || setType == 'basicLine'
                            || setType == 'start' || setType == 'stop' || setType == 'conditionalLineBox' ) {
                return set[i];
            }
        }
        return null;
    },
    getPaperPos: function( e ) {
        var pos = new Object();
        var panelPos = this.getPosition();
        var scrollX = this.body.dom.scrollLeft;
        var scrollY = this.body.dom.scrollTop;
        var xPos = e.getPageX() - panelPos[0] + scrollX;
        var yPos = e.getPageY() - panelPos[1] + scrollY;
        xPos *= this.paper.scale;
        yPos *= this.paper.scale;

        pos = Ext.apply( {
            x: xPos,
            y: yPos
        }, pos );

        return pos;
    },
    showStartStopMenu: function( e, el ) {
        var itemsConfig = new Array();
        var itemConfig = new Object();

        itemConfig = Ext.apply( {
            id: 'delete_startstop_menu_item_' + Ext.id(),
            cls: 'x-btn-text-icon',
            icon: getPluginImgPath( 'delete' ),
            text: getTranslation( 'Usuń element' ),
            functionName: 'deleteElement',
            functionArg: el
        }, itemConfig );
        itemsConfig.push( itemConfig );

        var menu = new Ext.ux.suncode.Menu( itemsConfig );
        showMenu( menu, e );
    },
    showRoleMenu: function( e, processNode, roleEl ) {
        var roleId = roleEl.data( 'roleId' );
        var roleType = roleEl.data( 'roleType' );
        var deleteText = '';

        switch ( roleType ) {
            case 'ROLE':
                deleteText = getTranslation( 'Usuń rolę' );
                break;
            case 'SYSTEM':
                deleteText = getTranslation( 'Usuń system' );
                break;
            case 'RESOURCE':
                deleteText = getTranslation( 'Usuń bufor' );
                break;
            default:
                break;
        }

        var itemsConfig = new Array();
        var itemConfig = new Object();

        itemConfig = Ext.apply( {
            cls: 'x-btn-text-icon',
            icon: getPluginImgPath( 'delete' ),
            text: deleteText,
            functionName: 'deleteRole',
            functionArg: {
                paper: this.paper,
                processNode: processNode,
                roleId: roleId
            }
        }, itemConfig );
        itemsConfig.push( itemConfig );
        itemConfig = new Object();

        itemConfig = Ext.apply( {
            cls: 'x-btn-text-icon',
            icon: getPluginImgPath( 'properties' ),
            text: getTranslation( 'Właściwości' ),
            functionName: 'showRoleProperties',
            functionArg: {
                processNode: processNode,
                roleId: roleId
            }
        }, itemConfig );
        itemsConfig.push( itemConfig );

        var menu = new Ext.ux.suncode.Menu( itemsConfig );
        showMenu( menu, e );
    },
    showBasicLineMenu: function( e, lineEl, xOffset, yOffset ) {
        var itemsConfig = new Array();
        var itemConfig = new Object();

        itemConfig = Ext.apply( {
            cls: 'x-btn-text-icon',
            icon: getPluginImgPath( 'mark_path' ),
            text: getTranslation( 'Zaznacz ścieżkę' ),
            functionName: 'markPath',
            functionArg: lineEl
        }, itemConfig );
        itemsConfig.push( itemConfig );
        itemConfig = new Object();
        itemConfig = Ext.apply( {
            cls: 'x-btn-text-icon',
            icon: getPluginImgPath( 'shortest_path' ),
            text: getTranslation( 'Najkrótsza ścieżka' ),
            functionName: 'reduceTransitionToShortestPath',
            functionArg: lineEl
        }, itemConfig );
        itemsConfig.push( itemConfig );
        itemConfig = new Object();

        if ( !lineEl.data( 'isArrow' ) ) {
            e.getPageX = function() {
                return e.pageX + xOffset;
            };
            e.getPageY = function() {
                return e.pageY + yOffset;
            };

            itemConfig = Ext.apply( {
                cls: 'x-btn-text-icon',
                icon: getPluginImgPath( 'add' ),
                text: getTranslation( 'Dodaj punkt' ),
                functionName: 'addLinePoint',
                functionArg: {
                    line: lineEl,
                    pos: this.getPaperPos( e )
                }
            }, itemConfig );
            itemsConfig.push( itemConfig );
            itemConfig = new Object();
        }

        itemConfig = Ext.apply( {
            id: 'separator'
        }, itemConfig );
        itemsConfig.push( itemConfig );
        itemConfig = new Object();

        itemConfig = Ext.apply( {
            cls: 'x-btn-text-icon',
            icon: getPluginImgPath( 'delete' ),
            text: getTranslation( 'Usuń połączenie' ),
            functionName: 'deleteBasicLine',
            functionArg: lineEl
        }, itemConfig );
        itemsConfig.push( itemConfig );

        var menu = new Ext.ux.suncode.Menu( itemsConfig );
        menu.showAt( [ e.clientX, e.clientY + getPageYOffset() ] );
    },
    showConditionalLineMenu: function( e, lineEl, xOffset, yOffset ) {
        var connector = lineEl.data( 'connectedWith' );
        var transitionId = lineEl.data( 'transitionId' );
        var itemsConfig = new Array();
        var itemConfig = new Object();

        itemConfig = Ext.apply( {
            cls: 'x-btn-text-icon',
            icon: getPluginImgPath( 'mark_path' ),
            text: getTranslation( 'Zaznacz ścieżkę' ),
            functionName: 'markPath',
            functionArg: lineEl
        }, itemConfig );
        itemsConfig.push( itemConfig );
        itemConfig = new Object();
        itemConfig = Ext.apply( {
            cls: 'x-btn-text-icon',
            icon: getPluginImgPath( 'shortest_path' ),
            text: getTranslation( 'Najkrótsza ścieżka' ),
            functionName: 'reduceTransitionToShortestPath',
            functionArg: lineEl
        }, itemConfig );
        itemsConfig.push( itemConfig );
        itemConfig = new Object();

        if ( !lineEl.data( 'isArrow' ) ) {
            e.getPageX = function() {
                return e.pageX + xOffset;
            };
            e.getPageY = function() {
                return e.pageY + yOffset;
            };

            itemConfig = Ext.apply( {
                cls: 'x-btn-text-icon',
                icon: getPluginImgPath( 'add' ),
                text: getTranslation( 'Dodaj punkt' ),
                functionName: 'addLinePoint',
                functionArg: {
                    line: lineEl,
                    pos: this.getPaperPos( e )
                }
            }, itemConfig );
            itemsConfig.push( itemConfig );
            itemConfig = new Object();
        }

        itemConfig = Ext.apply( {
            id: 'separator'
        }, itemConfig );
        itemsConfig.push( itemConfig );
        itemConfig = new Object();

        itemConfig = Ext.apply( {
            cls: 'x-btn-text-icon',
            icon: getPluginImgPath( 'condition' ),
            text: getTranslation( 'Warunki' ),
            functionName: 'showConditionalLineCondition',
            functionArg: {
                el: lineEl,
                processDefId: this.processDefId
            }
        }, itemConfig );
        itemsConfig.push( itemConfig );
        itemConfig = new Object();

        itemConfig = Ext.apply( {
            cls: 'x-btn-text-icon',
            icon: getPluginImgPath( 'delete' ),
            text: getTranslation( 'Usuń połączenie' ),
            functionName: 'deleteConditionalLine',
            functionArg: {
                connector: connector,
                transitionId: transitionId,
                inout: 'in',
                processDefId: this.processDefId
            }
        }, itemConfig );
        itemsConfig.push( itemConfig );

        var menu = new Ext.ux.suncode.Menu( itemsConfig );
        menu.showAt( [ e.clientX, e.clientY + getPageYOffset() ] );
    },
    showConditionalLineBoxMenu: function( e, el ) {
        var connectFrom = el.data( 'connectFrom' );
        var connector = el.data( 'connectedWith' );
        var transitionId = el.data( 'transitionId' );
        var conditionType = el.data( 'conditionType' );
        var changeTypeMenuIcon = conditionType == 'XOR' ? 'cond_line_and' : 'cond_line_xor';

        var itemsConfig = new Array();
        var itemConfig = new Object();

        itemConfig = Ext.apply( {
            cls: 'x-btn-text-icon',
            icon: getPluginImgPath( 'condition' ),
            text: getTranslation( 'Warunki' ),
            functionName: 'showConditionalLineConditions',
            functionArg: {
                connectFrom: connectFrom
            }
        }, itemConfig );
        itemsConfig.push( itemConfig );
        itemConfig = new Object();

        itemConfig = Ext.apply( {
            cls: 'x-btn-text-icon',
            icon: getPluginImgPath( changeTypeMenuIcon ),
            text: getTranslation( 'Zmień typ warunku' ),
            functionName: 'changeConditionalLineType',
            functionArg: {
                conditionType: conditionType,
                el: el
            }
        }, itemConfig );
        itemsConfig.push( itemConfig );
        itemConfig = new Object();

        itemConfig = Ext.apply( {
            cls: 'x-btn-text-icon',
            icon: getPluginImgPath( 'delete' ),
            text: getTranslation( 'Usuń połączenie' ),
            functionName: 'deleteConditionalLine',
            functionArg: {
                connector: connector,
                transitionId: transitionId,
                inout: 'out',
                processDefId: this.processDefId
            }
        }, itemConfig );
        itemsConfig.push( itemConfig );

        var menu = new Ext.ux.suncode.Menu( itemsConfig );
        menu.showAt( [ e.clientX, e.clientY + getPageYOffset() ] );
    },
    showOtherwiseLineMenu: function( e, lineEl, xOffset, yOffset ) {
        var itemsConfig = new Array();
        var itemConfig = new Object();

        itemConfig = Ext.apply( {
            cls: 'x-btn-text-icon',
            icon: getPluginImgPath( 'mark_path' ),
            text: getTranslation( 'Zaznacz ścieżkę' ),
            functionName: 'markPath',
            functionArg: lineEl
        }, itemConfig );
        itemsConfig.push( itemConfig );
        itemConfig = new Object();
        itemConfig = Ext.apply( {
            cls: 'x-btn-text-icon',
            icon: getPluginImgPath( 'shortest_path' ),
            text: getTranslation( 'Najkrótsza ścieżka' ),
            functionName: 'reduceTransitionToShortestPath',
            functionArg: lineEl
        }, itemConfig );
        itemsConfig.push( itemConfig );
        itemConfig = new Object();

        if ( !lineEl.data( 'isArrow' ) ) {
            e.getPageX = function() {
                return e.pageX + xOffset;
            };
            e.getPageY = function() {
                return e.pageY + yOffset;
            };

            itemConfig = Ext.apply( {
                cls: 'x-btn-text-icon',
                icon: getPluginImgPath( 'add' ),
                text: getTranslation( 'Dodaj punkt' ),
                functionName: 'addLinePoint',
                functionArg: {
                    line: lineEl,
                    pos: this.getPaperPos( e )
                }
            }, itemConfig );
            itemsConfig.push( itemConfig );
            itemConfig = new Object();
        }

        itemConfig = Ext.apply( {
            id: 'separator'
        }, itemConfig );
        itemsConfig.push( itemConfig );
        itemConfig = new Object();

        itemConfig = Ext.apply( {
            cls: 'x-btn-text-icon',
            icon: getPluginImgPath( 'delete' ),
            text: getTranslation( 'Usuń połączenie' ),
            functionName: 'deleteOtherwiseLine',
            functionArg: lineEl
        }, itemConfig );
        itemsConfig.push( itemConfig );

        var menu = new Ext.ux.suncode.Menu( itemsConfig );
        menu.showAt( [ e.clientX, e.clientY + getPageYOffset() ] );
    },
    showDeadlineLineMenu: function( e, lineEl, xOffset, yOffset ) {
        var connector = lineEl.data( 'connectFrom' );
        var transitionId = lineEl.data( 'transitionId' );
        var itemsConfig = new Array();
        var itemConfig = new Object();

        itemConfig = Ext.apply( {
            cls: 'x-btn-text-icon',
            icon: getPluginImgPath( 'mark_path' ),
            text: getTranslation( 'Zaznacz ścieżkę' ),
            functionName: 'markPath',
            functionArg: lineEl
        }, itemConfig );
        itemsConfig.push( itemConfig );
        itemConfig = new Object();
        itemConfig = Ext.apply( {
            cls: 'x-btn-text-icon',
            icon: getPluginImgPath( 'shortest_path' ),
            text: getTranslation( 'Najkrótsza ścieżka' ),
            functionName: 'reduceTransitionToShortestPath',
            functionArg: lineEl
        }, itemConfig );
        itemsConfig.push( itemConfig );
        itemConfig = new Object();

        if ( !lineEl.data( 'isArrow' ) ) {
            e.getPageX = function() {
                return e.pageX + xOffset;
            };
            e.getPageY = function() {
                return e.pageY + yOffset;
            };

            itemConfig = Ext.apply( {
                cls: 'x-btn-text-icon',
                icon: getPluginImgPath( 'add' ),
                text: getTranslation( 'Dodaj punkt' ),
                functionName: 'addLinePoint',
                functionArg: {
                    line: lineEl,
                    pos: this.getPaperPos( e )
                }
            }, itemConfig );
            itemsConfig.push( itemConfig );
            itemConfig = new Object();
        }

        itemConfig = Ext.apply( {
            id: 'separator'
        }, itemConfig );
        itemsConfig.push( itemConfig );
        itemConfig = new Object();

        itemConfig = Ext.apply( {
            cls: 'x-btn-text-icon',
            icon: getPluginImgPath( 'calendar_edit' ),
            text: getTranslation( 'Określ nazwę terminu ostatecznego' ),
            functionName: 'typeDeadlineExceptionName',
            functionArg: {
                connector: connector,
                transitionId: transitionId
            }
        }, itemConfig );
        itemsConfig.push( itemConfig );
        itemConfig = new Object();

        itemConfig = Ext.apply( {
            cls: 'x-btn-text-icon',
            icon: getPluginImgPath( 'delete' ),
            text: getTranslation( 'Usuń wyjątek' ),
            functionName: 'deleteDeadlineLine',
            functionArg: {
                connector: connector,
                transitionId: transitionId
            }
        }, itemConfig );
        itemsConfig.push( itemConfig );

        var menu = new Ext.ux.suncode.Menu( itemsConfig );
        menu.showAt( [ e.clientX, e.clientY + getPageYOffset() ] );
    },
    drawTooltip: function( x, y ) {
        if ( this.objToDraw ) {
            this.objToDraw.remove();
        }

        switch ( this.objToDrawType ) {
            case 'start':
                this.objToDraw = this.paper.bpmn.start( this.paper, x, y, true );
                break;
            case 'stop':
                this.objToDraw = this.paper.bpmn.stop( this.paper, x, y, true );
                break;
            case 'role':
                this.objToDraw = this.paper.bpmn.role( this.paper, x, y, true );
                break;
            case 'system':
                this.objToDraw = this.paper.bpmn.system( this.paper, x, y, true );
                break;
            case 'bufor':
                this.objToDraw = this.paper.bpmn.bufor( this.paper, x, y, true );
                break;
            case 'route':
                this.objToDraw = this.paper.bpmn.route( this.paper, x, y, true, this.currentTaskNo );
                break;
            case 'activity':
                this.objToDraw = this.paper.bpmn.activity( this.paper, x, y, true, this.currentTaskNo );
                break;
            case 'tool':
                this.objToDraw = this.paper.bpmn.tool( this.paper, x, y, true, this.currentTaskNo );
                break;
            case 'applicationIntegrationComponent':
                this.objToDraw = this.paper.bpmn.applicationIntegrationComponent( this.paper, x, y, true, this.currentTaskNo );
                break;
            case 'subflow':
                this.objToDraw = this.paper.bpmn.subflow( this.paper, x, y, true, this.currentTaskNo );
                break;
            case 'basicLine':
                this.objToDraw = this.paper.bpmn.basicLine( this.paper, this.connectFrom, this.connectTo, x, y, false, false );
                break;
            case 'defaultBasicLine':
                this.objToDraw = this.paper.bpmn.defaultBasicLine( this.paper, this.connectFrom, this.connectTo, x, y, false, false );
                break;
            case 'conditionalLine':
                this.objToDraw = this.paper.bpmn.conditionalLine( this.paper, this.condLineType, this.conditionalLineStep, this.connectFrom,
                                this.connectTo, x, y, false, true );
                break;
            case 'otherwiseLine':
                this.objToDraw = this.paper.bpmn.otherwiseLine( this.paper, this.connectFrom, this.connectTo, x, y, false, false );
                break;
            case 'deadlineLine':
                this.objToDraw = this.paper.bpmn.deadlineLine( this.paper, this.connectFrom, this.connectTo, x, y, false, false );
                break;
            case 'basicLineWithRoute':
                this.objToDraw = this.paper.bpmn.basicLineWithRoute( this.paper, this.connectFrom, x, y, true, this.currentTaskNo );
                break;
            case 'conditionalLineWithRoute':
                this.objToDraw = this.paper.bpmn.conditionalLineWithRoute( this.paper, this.condLineType, this.conditionalLineStep, this.connectFrom,
                                x, y, true, this.currentTaskNo );
                break;
            case 'basicLineWithActivity':
                this.objToDraw = this.paper.bpmn.basicLineWithActivity( this.paper, this.connectFrom, x, y, true, this.currentTaskNo );
                break;
            case 'conditionalLineWithActivity':
                this.objToDraw = this.paper.bpmn.conditionalLineWithActivity( this.paper, this.condLineType, this.conditionalLineStep,
                                this.connectFrom, x, y, true, this.currentTaskNo );
                break;
            case 'basicLineWithTool':
                this.objToDraw = this.paper.bpmn.basicLineWithTool( this.paper, this.connectFrom, x, y, true, this.currentTaskNo );
                break;
            case 'conditionalLineWithTool':
                this.objToDraw = this.paper.bpmn.conditionalLineWithTool( this.paper, this.condLineType, this.conditionalLineStep, this.connectFrom,
                                x, y, true, this.currentTaskNo );
                break;
            case 'basicLineWithSubflow':
                this.objToDraw = this.paper.bpmn.basicLineWithSubflow( this.paper, this.connectFrom, x, y, true, this.currentTaskNo );
                break;
            case 'conditionalLineWithSubflow':
                this.objToDraw = this.paper.bpmn.conditionalLineWithSubflow( this.paper, this.condLineType, this.conditionalLineStep,
                                this.connectFrom, x, y, true, this.currentTaskNo );
                break;
            case 'basicLineWithStart':
                this.objToDraw = this.paper.bpmn.basicLineWithStart( this.paper, this.connectTo, x, y, true );
                break;
            case 'basicLineWithStop':
                this.objToDraw = this.paper.bpmn.basicLineWithStop( this.paper, this.connectFrom, x, y, true );
                break;
            case 'customLine':
                this.objToDraw = this.paper.bpmn.customLine( this.paper, this.customLineType, x, y, this.xStart, this.yStart, this.connectFrom,
                                this.connectTo );
                break;
            default:
                break;
        }
    },
    drawStart: function( x, y ) {
        var start = this.paper.bpmn.start( this.paper, x, y, false );
        if ( this.verifyDisabled( start ) ) {
            this.drawTooltip( x, y );
            if ( this.objToDraw ) {
                this.objToDraw.toFront();
            }
        }
        return start;
    },
    drawStop: function( x, y ) {
        var stop = this.paper.bpmn.stop( this.paper, x, y, false );
        if ( this.verifyDisabled( stop ) ) {
            this.drawTooltip( x, y );
            if ( this.objToDraw ) {
                this.objToDraw.toFront();
            }
        }
        return stop;
    },
    drawRole: function( x, y, name, id, isGlobal ) {
        var processNode = Ext.getCmp( 'package_panel' ).findProcess( this.processDefId );
        var roleId = '';

        if ( !name ) {
          var roleName = getTranslation( 'Uczestnik' ) + ' ' + this.currentRoleNo;
          roleId = generateId( roleName, Ext.ux.suncode.Constants.ROLE_ID_MAX_LENGTH );

          while ( processNode.findRole( roleId ) ) {
            this.currentRoleNo++;
            roleName = getTranslation( 'Uczestnik' ) + ' ' + this.currentRoleNo;
            roleId = generateId( roleName, Ext.ux.suncode.Constants.ROLE_ID_MAX_LENGTH );
          }
        }

        var role = this.paper.bpmn.role( this.paper, x, y, false, this.currentRoleNo, name, id, isGlobal );
        this.drawTooltip( x, y );
        if ( this.objToDraw ) {
            this.objToDraw.toFront();
        }
        processNode.addRole( role );
        this.currentRoleNo++;
        return role;
    },
    drawSystem: function( x, y, name, id, isGlobal ) {
        var packagePanel = Ext.getCmp( 'package_panel' );
        var packageNode = packagePanel.getRootNode();
        var processNode = packagePanel.findProcess( this.processDefId );
        var systemId = '';

        if ( !id ) {
          systemId = getTranslation( 'System' ) + this.currentSystemNo;

          if ( isGlobal ) {
            while ( packageNode.findParticipant( systemId ) ) {
              this.currentSystemNo++;
              systemId = getTranslation( 'System' ) + this.currentSystemNo;
            }
          } else {
            while ( processNode.findRole( systemId ) ) {
              this.currentSystemNo++;
              systemId = getTranslation( 'System' ) + this.currentSystemNo;
            }
          }
        } else {
          systemId = id;
        }

        var system = this.paper.bpmn.system( this.paper, x, y, false, name, systemId, isGlobal );
        this.drawTooltip( x, y );
        if ( this.objToDraw ) {
            this.objToDraw.toFront();
        }
        processNode.addRole( system );
        this.currentSystemNo++;
        return system;
    },
    drawBufor: function( x, y, name, id, isGlobal ) {
        var processNode = Ext.getCmp( 'package_panel' ).findProcess( this.processDefId );
        var bufferId = '';

        if ( !id ) {
          bufferId = getTranslation( 'Bufor' ) + this.currentBufferNo;

          while ( processNode.findRole( bufferId ) ) {
            this.currentBufferNo++;
            bufferId = getTranslation( 'Bufor' ) + this.currentBufferNo;
          }
        } else {
          bufferId = id;
        }

        var bufor = this.paper.bpmn.bufor( this.paper, x, y, false, name, bufferId, isGlobal );
        this.drawTooltip( x, y );
        if ( this.objToDraw ) {
            this.objToDraw.toFront();
        }
        processNode.addRole( bufor );
        this.currentBufferNo++;
        return bufor;
    },
    drawRoute: function( x, y, name, id ) {
        var route = this.paper.bpmn.route( this.paper, x, y, false, this.currentTaskNo, name, id );
        this.initAddActivity( route, x, y, getPluginImgPath( 'route_small' ) );
        return route;
    },
    drawActivity: function( x, y, name, id ) {
        var act = this.paper.bpmn.activity( this.paper, x, y, false, this.currentTaskNo, name, id );
        this.initAddActivity( act, x, y, getPluginImgPath( 'activity_small' ) );
        return act;
    },
    drawTool: function( x, y, name, id ) {
        var tool = this.paper.bpmn.tool( this.paper, x, y, false, this.currentTaskNo, name, id );
        this.initAddActivity( tool, x, y, getPluginImgPath( 'tool_small' ) );
        return tool;
    },
    drawApplicationIntegrationComponent: function( x, y, name, id ) {
        var component = this.getFromStorage( 'applicationIntegrationComponent' );
        var processDefId = this.processDefId;
        var processNode = Ext.getCmp( 'package_panel' ).findProcess( processDefId );
        
        var win = new Ext.ux.suncode.IntegrationComponentParametersWindow( {
            title: getTranslation( 'Parametry aplikacji' ) + ': ' + component.name,
            component: component,
            processNode: processNode,
            conditionalExecutionEnabled: Ext.ux.suncode.IntegrationComponentService
            .isApplicationWithConditionalExecution( component.id ),
            inactiveEnabled: true,
            errorHandlingEnabled: true,
            systemFunctionsAccessibility: Ext.ux.suncode.IntegrationComponentService.SERVER_ACCESSIBILITY,
            saveFunction: function( condition, values, extraConfig ) {
            	var tool = this.paper.bpmn.applicationIntegrationComponent( this.paper, x, y, false, this.currentTaskNo, component, name, id );
                this.initAddActivity( tool, x, y, getPluginImgPath( 'tool_small' ) );
                var packagePanel = Ext.getCmp( 'package_panel' );
                var activityDefId = tool[0].data( 'activityDefId' );
                var activityNode = packagePanel.findActivity( processDefId, activityDefId );

                if ( !Ext.isEmpty( activityNode ) ) {
                	Ext.ux.suncode.IntegrationComponentService.addApplicationFromIntegrationComponent(
                			processNode, activityNode, component, condition, values, extraConfig );
                }
                
                Ext.getCmp( 'paper_panel' ).getTopToolbar().deactivateUsedButton();
            },
            saveScope: this,
            getComponentRegistrationFunction: function( id ) {
            	return Ext.ux.suncode.IntegrationComponentService.getApplicationRegistration( id );
            },
            getComponentRegistrationScope: this
        } );
        win.show();
    },
    drawSubflow: function( x, y, name, id ) {
        var subflow = this.paper.bpmn.subflow( this.paper, x, y, false, this.currentTaskNo, name, id );
        this.initAddActivity( subflow, x, y, getPluginImgPath( 'subflow_small' ) );
        return subflow;
    },
    drawCustomLine: function( x, y ) {
        var el = this.paper.bpmn.getConnector( this.paper, x, y );

        if ( el ) {
            if ( !this.paper.bpmn.isConnEndingAvailable( this.customLineType, el, this.connectFrom, this.processDefId ) ) {
                this.drawTooltip( x, y );
                return;
            }

            this.connectTo = el;
            var lineSet = this.paper.bpmn.customLine( this.paper, this.customLineType, x, y, this.xStart, this.yStart, this.connectFrom,
                            this.connectTo );

            if ( lineSet.duplicated ) {
                this.handleDuplicatedConnection( x, y );
                return;
            }

            if ( this.objToDraw ) {
                this.objToDraw.remove();
            }

            if ( this.customLineType == 'BASIC' ) {
                this.objToDrawType = 'basicLine';
                this.resetConnecting();
            } else if ( this.customLineType == 'OTHERWISE' ) {
                this.objToDrawType = 'otherwiseLine';
                this.resetConnecting();
            } else if ( this.customLineType == 'EXCEPTION' ) {
                this.objToDrawType = 'deadlineLine';
                this.resetConnecting();
            } else {
                this.objToDrawType = 'conditionalLine';
                this.connectTo = null;
            }
        } else {
            if ( this.isLineOutOfFields( x, y ) ) {
                return false;
            }

            var lineSet = this.paper.bpmn.customLine( this.paper, this.customLineType, x, y, this.xStart, this.yStart, this.connectFrom,
                            this.connectTo );
            var line = lineSet[0];
            var pathAttr = line.attr( 'path' );
            pathAttr = handlePathAttrType( pathAttr );
            var pointAtLength = Raphael.getPointAtLength( pathAttr, line.getTotalLength() );
            var storageLine = this.getFromStorage( 'customLine' );
            var storageLinePathAttr = storageLine.attr( 'path' );
            storageLinePathAttr = handlePathAttrType( storageLinePathAttr );
            var newPath = storageLinePathAttr.concat( pathAttr.splice( 1, pathAttr.length ) );
            storageLine.attr( {
                path: clearPath( newPath, true )
            } );
            this.xStart = pointAtLength.x;
            this.yStart = pointAtLength.y;
            lineSet.remove();
        }
    },
    drawBasicLine: function( x, y, t ) {
        if ( this.basicConnectionPossible( x, y ) ) {
            if ( !this.connectingStarted ) {
                this.connectingStarted = true;
                return;
            }

            var basicLineSet = this.paper.bpmn.basicLine( this.paper, this.connectFrom, this.connectTo, x, y, true, false, true, t );

            if ( basicLineSet.duplicated ) {
                this.handleDuplicatedConnection( x, y );
                return;
            }

            if ( this.objToDraw ) {
                this.objToDraw.remove();
            }
            this.resetConnecting();
        } else {
            this.drawTooltip( x, y );
        }
    },
    drawBasicLineForTermination: function( from, to ) {
        var toBox = to.getBBox();
        this.paper.bpmn.basicLine( this.paper, from, to, toBox.x + toBox.width / 2, toBox.y + toBox.height / 2, false, false, true );
        this.resetConnecting();
    },
    directDrawBasicLine: function( t ) {
        this.paper.bpmn.basicLine( this.paper, this.connectFrom, this.connectTo, -1, -1, false, false, true, t );
        this.resetConnecting();
    },
    directDrawCondLine: function( withBox, t ) {
        if ( withBox ) {
            this.paper.bpmn.conditionalLine( this.paper, t.condType, 2, this.connectFrom, this.connectTo, -1, -1, false, true, t );
        }

        this.paper.bpmn.conditionalLine( this.paper, t.condType, 4, this.connectFrom, this.connectTo, -1, -1, false, true, t );
        this.resetConnecting();
    },
    drawConditionalLine: function( x, y, t ) {
        if ( this.condConnectionPossible( x, y ) ) {
            if ( this.conditionalLineStep < 4 ) {
                this.drawTooltip( x, y );
                return;
            }

            var condLineSet = this.paper.bpmn.conditionalLine( this.paper, this.condLineType, this.conditionalLineStep, this.connectFrom,
                            this.connectTo, x, y, true, true, t );

            if ( condLineSet.duplicated ) {
                this.conditionalLineStep--;
                this.handleDuplicatedConnection( x, y );
                return;
            }

            if ( this.objToDraw ) {
                this.objToDraw.remove();
            }

            this.connectTo = null;
            this.conditionalLineStep--;
        } else {
            this.drawTooltip( x, y );
        }
    },
    drawOtherwiseLine: function( x, y, t ) {
        if ( this.otherwiseConnectionPossible( x, y ) ) {
            if ( !this.connectingStarted ) {
                this.connectingStarted = true;
                return;
            }

            var otherwiseLineSet = this.paper.bpmn.otherwiseLine( this.paper, this.connectFrom, this.connectTo, x, y, true, false, true, t );

            if ( otherwiseLineSet.duplicated ) {
                this.handleDuplicatedConnection( x, y );
                return;
            }

            if ( this.objToDraw ) {
                this.objToDraw.remove();
            }
            this.resetConnecting();
        } else {
            this.drawTooltip( x, y );
        }
    },
    directDrawOtherwiseLine: function( t ) {
        this.paper.bpmn.otherwiseLine( this.paper, this.connectFrom, this.connectTo, -1, -1, false, false, true, t );
        this.resetConnecting();
    },
    drawDeadlineLine: function( x, y, t ) {
        if ( this.deadlineConnectionPossible( x, y ) ) {
            if ( !this.connectingStarted ) {
                this.connectingStarted = true;
                return;
            }

            var deadlineSet = this.paper.bpmn.deadlineLine( this.paper, this.connectFrom, this.connectTo, x, y, true, false, true, t );

            if ( deadlineSet.duplicated ) {
                this.handleDuplicatedConnection( x, y );
                return;
            }

            if ( this.objToDraw ) {
                this.objToDraw.remove();
            }
            this.resetConnecting();
        } else {
            this.drawTooltip( x, y );
        }
    },
    directDrawDeadlineLine: function( t ) {
        this.paper.bpmn.deadlineLine( this.paper, this.connectFrom, this.connectTo, -1, -1, false, false, true, t );
        this.resetConnecting();
    },
    handleDuplicatedConnection: function( x, y ) {
        var msg = 'Zadanie/Narzędzie nie może mieć więcej niż jedno ';
        msg += 'wchodzące/wychodzące połączenie od/do tego samego zadania/narzędzia.';
        showWarn( getTranslation( msg ) );
        this.connectTo = null;
        this.drawTooltip( x, y );
    },
    drawBasicLineWithRoute: function( x, y ) {
        this.paper.bpmn.basicLineWithRoute( this.paper, this.connectFrom, x, y, false, this.currentTaskNo );
    },
    drawConditionalLineWithRoute: function( x, y ) {
        this.conditionalLineStep++;
        this.paper.bpmn.conditionalLineWithRoute( this.paper, this.condLineType, this.conditionalLineStep, this.connectFrom, x, y, false,
                        this.currentTaskNo );
    },
    drawBasicLineWithActivity: function( x, y ) {
        this.paper.bpmn.basicLineWithActivity( this.paper, this.connectFrom, x, y, false, this.currentTaskNo );
    },
    drawConditionalLineWithActivity: function( x, y ) {
        this.conditionalLineStep++;
        this.paper.bpmn.conditionalLineWithActivity( this.paper, this.condLineType, this.conditionalLineStep, this.connectFrom, x, y, false,
                        this.currentTaskNo );
    },
    drawBasicLineWithTool: function( x, y ) {
        this.paper.bpmn.basicLineWithTool( this.paper, this.connectFrom, x, y, false, this.currentTaskNo );
    },
    drawConditionalLineWithTool: function( x, y ) {
        this.conditionalLineStep++;
        this.paper.bpmn.conditionalLineWithTool( this.paper, this.condLineType, this.conditionalLineStep, this.connectFrom, x, y, false,
                        this.currentTaskNo );
    },
    drawBasicLineWithSubflow: function( x, y ) {
        this.paper.bpmn.basicLineWithSubflow( this.paper, this.connectFrom, x, y, false, this.currentTaskNo );
    },
    drawConditionalLineWithSubflow: function( x, y ) {
        this.conditionalLineStep++;
        this.paper.bpmn.conditionalLineWithSubflow( this.paper, this.condLineType, this.conditionalLineStep, this.connectFrom, x, y, false,
                        this.currentTaskNo );
    },
    drawBasicLineWithStart: function( x, y ) {
        var start = this.paper.bpmn.basicLineWithStart( this.paper, this.connectTo, x, y, false );
        if ( this.verifyDisabled( start ) ) {
            Ext.getCmp( 'paper_panel' ).getTopToolbar().deactivateUsedButton();
        }
    },
    drawBasicLineWithStop: function( x, y ) {
        var stop = this.paper.bpmn.basicLineWithStop( this.paper, this.connectFrom, x, y, false );
        if ( this.verifyDisabled( stop ) ) {
            Ext.getCmp( 'paper_panel' ).getTopToolbar().deactivateUsedButton();
        }
    },
    drawTerminations: function() {
        this.paper.bpmn.drawTerminations( this.paper );
    },
    removeTerminations: function() {
        this.paper.bpmn.removeTerminations( this.paper );
    },
    verifyDisabled: function( set ) {
        if ( set[0].data( 'setType' ) == 'disabled' ) {
            this.objToDraw = set;
            return false;
        }
        return true;
    },
    addToStorage: function( id, obj ) {
        this.objStorage[id] = obj;
    },
    getFromStorage: function( id ) {
        return this.objStorage[id];
    },
    resetStorage: function( id ) {
        delete this.objStorage[id];
    },
    removeFromStorage: function( id ) {
        var obj = this.objStorage[id];

        if ( Ext.isFunction( obj.remove ) ) {
            obj.remove();
        }
    },
    clearStorage: function() {
        for ( var id in this.objStorage ) {
            this.removeFromStorage( id );
            this.resetStorage( id );
        }
    },
    getPanelText: function( processName, processColor ) {
        var encodedProcessName = Ext.util.Format.htmlEncode( processName );

        if ( !Ext.isEmpty( processColor ) ) {
            return setTextColor( encodedProcessName, processColor );
        } else {
            return encodedProcessName;
        }
    }
} );

Ext.ux.suncode.PaperPanelTopToolbar = function( config ) {
    var items = new Array();

    var zoomInButton = new Ext.Button( {
        id: 'zoom_in_button',
        cls: 'x-btn-icon',
        icon: getPluginImgPath( 'zoom_in' ),
        disabled: true,
        tooltip: getTranslation( 'Powiększ' ),
        handler: function() {
            var paper = this.ownerCt.ownerCt.getActiveTab().paper;
            paper.bpmn.zoomIn( paper );
        }
    } );
    items.push( zoomInButton );

    var refreshZoomButton = new Ext.Button( {
        id: 'refresh_zoom_button',
        cls: 'x-btn-icon',
        icon: getPluginImgPath( 'zoom' ),
        disabled: true,
        tooltip: getTranslation( 'Przywróć rozmiar' ),
        handler: function() {
            var paper = this.ownerCt.ownerCt.getActiveTab().paper;
            paper.bpmn.resetZoom( paper );
        }
    } );
    items.push( refreshZoomButton );

    var zoomOutButton = new Ext.Button( {
        id: 'zoom_out_button',
        cls: 'x-btn-icon',
        icon: getPluginImgPath( 'zoom_out' ),
        disabled: true,
        tooltip: getTranslation( 'Pomniejsz' ),
        handler: function() {
            var paper = this.ownerCt.ownerCt.getActiveTab().paper;
            paper.bpmn.zoomOut( paper );
        }
    } );
    items.push( zoomOutButton );

    var fitMapButton = new Ext.Button( {
        id: 'fit_map_button',
        cls: 'x-btn-icon',
        icon: getPluginImgPath( 'fit' ),
        disabled: true,
        tooltip: getTranslation( 'Dopasuj wielkość mapy procesu' ),
        menu: {
            items: [ {
                xtype: 'menuitem',
                text: getTranslation( 'W pionie' ),
                cls: 'x-btn-text-icon',
                icon: getPluginImgPath( 'fit_vertically' ),
                scope: this,
                handler: function( item, e ) {
                    var paper = this.ownerCt.getActiveTab().paper;
                    paper.bpmn.fitProcessMapSizeVertically( paper );
                }
            }, {
                xtype: 'menuitem',
                text: getTranslation( 'W poziomie' ),
                cls: 'x-btn-text-icon',
                icon: getPluginImgPath( 'fit_horizontally' ),
                scope: this,
                handler: function( item, e ) {
                    var paper = this.ownerCt.getActiveTab().paper;
                    paper.bpmn.fitProcessMapSizeHorizontally( paper );
                }
            }, {
                xtype: 'menuitem',
                text: getTranslation( 'Pokaż całą mapę procesu' ),
                cls: 'x-btn-text-icon',
                icon: getPluginImgPath( 'fit_all' ),
                scope: this,
                handler: function( item, e ) {
                    var paper = this.ownerCt.getActiveTab().paper;
                    paper.bpmn.fitProcessMapSize( paper );
                }
            } ]
        }
    } );
    items.push( fitMapButton );

    if ( config.currentActivityMapMode || config.simulationMode ) {
        if ( config.currentActivityMapMode ) {
            items.push( new Ext.Toolbar.Separator() );

            var initProcessSimulationButton = new Ext.Button( {
                id: 'mark_current_activity_button',
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'activity_small' ),
                disabled: true,
                tooltip: getTranslation( 'Zaznacz obecne zadanie' ),
                handler: function() {
                    initProcessSimulation( {
                        markCurrentActivity: true
                    } );
                }
            } );
            items.push( initProcessSimulationButton );
        }

        items.push( new Ext.Toolbar.Separator() );

        var initProcessSimulationButton = new Ext.Button( {
            id: 'init_process_simulation_button',
            cls: 'x-btn-icon',
            icon: getPluginImgPath( 'next' ),
            disabled: true,
            tooltip: getTranslation( 'Symuluj aktualny przebieg' ),
            handler: function() {
                initProcessSimulation( {
                    skipFlow: false
                } );
            }
        } );
        items.push( initProcessSimulationButton );

        var configProcessSimulationButton = new Ext.Button( {
            id: 'config_process_simulation_button',
            cls: 'x-btn-icon',
            icon: getPluginImgPath( 'package_simulation' ),
            disabled: true,
            tooltip: getTranslation( 'Konfiguracja symulacji' ),
            handler: function() {
                var simulationConfigWindow = new Ext.ux.suncode.SimulationConfigWindow();
                simulationConfigWindow.show();
            }
        } );
        items.push( configProcessSimulationButton );
        items.push( new Ext.Toolbar.Separator() );

        var showSimulationFlowButton = new Ext.Button( {
            id: 'show_simulation_flow_button',
            cls: 'x-btn-icon',
            icon: getPluginImgPath( 'simulation_flow' ),
            disabled: true,
            tooltip: getTranslation( 'Pokaż przebieg symulacji' ),
            handler: function() {
                initProcessSimulation( {
                    fastFlow: true
                } );
            }
        } );
        items.push( showSimulationFlowButton );

        var clearProcessSimulationFlowButton = new Ext.Button( {
            id: 'clear_process_simulation_button',
            cls: 'x-btn-icon',
            icon: getPluginImgPath( 'clear' ),
            disabled: true,
            tooltip: getTranslation( 'Wyczyść przebieg symulacji' ),
            handler: function() {
                var paper = this.ownerCt.ownerCt.getActiveTab().paper;
                paper.simul.clearSimulation( paper );
            }
        } );
        items.push( clearProcessSimulationFlowButton );

        var showProcessSimulationResultsButton = new Ext.Button( {
            id: 'show_process_simulation_results_button',
            cls: 'x-btn-icon',
            icon: getPluginImgPath( 'piechart' ),
            disabled: true,
            tooltip: getTranslation( 'Pokaż wyniki symulacji' ),
            handler: function() {
                initProcessSimulation( {
                    skipFlow: true
                } );
            }
        } );
        items.push( showProcessSimulationResultsButton );
    } else if ( config.editionMode ) {
        items.push( new Ext.Toolbar.Separator() );

        var drawRoleButton = new Ext.Button( {
            id: 'draw_role_button',
            cls: 'x-btn-icon',
            icon: getPluginImgPath( 'role' ),
            disabled: true,
            tooltip: getTranslation( 'Wstaw rolę' ),
            used: false,
            handler: function() {
                this.ownerCt.handleButtonPush( this );
                var panel = Ext.getCmp( 'paper_panel' ).getActiveTab();
                if ( this.used ) {
                    panel.objToDrawType = 'role';
                    panel.onMouseMove();
                } else {
                    panel.unMouseMove();
                }
            }
        } );
        items.push( drawRoleButton );

        var drawSystemButton = new Ext.Button( {
            id: 'draw_system_button',
            cls: 'x-btn-icon',
            icon: getPluginImgPath( 'system' ),
            disabled: true,
            tooltip: getTranslation( 'Wstaw system' ),
            used: false,
            handler: function() {
                this.ownerCt.handleButtonPush( this );
                var panel = Ext.getCmp( 'paper_panel' ).getActiveTab();
                if ( this.used ) {
                    panel.objToDrawType = 'system';
                    panel.onMouseMove();
                } else {
                    panel.unMouseMove();
                }
            }
        } );
        items.push( drawSystemButton );

        var drawBuforButton = new Ext.Button( {
            id: 'draw_bufor_button',
            cls: 'x-btn-icon',
            icon: getPluginImgPath( 'buffer' ),
            disabled: true,
            tooltip: getTranslation( 'Wstaw bufor' ),
            used: false,
            handler: function() {
                this.ownerCt.handleButtonPush( this );
                var panel = Ext.getCmp( 'paper_panel' ).getActiveTab();
                if ( this.used ) {
                    panel.objToDrawType = 'bufor';
                    panel.onMouseMove();
                } else {
                    panel.unMouseMove();
                }
            }
        } );
        items.push( drawBuforButton );

        var drawGlobalParticipantButton = new Ext.Button( {
            id: 'draw_global_participant_button',
            cls: 'x-btn-icon',
            icon: getPluginImgPath( 'participant' ),
            disabled: true,
            tooltip: getTranslation( 'Wstaw uczestnika' ),
            menu: new Ext.ux.suncode.Menu( [] ),
            handler: function() {
                this.ownerCt.handleButtonPush( this );
                var panel = Ext.getCmp( 'paper_panel' ).getActiveTab();
                panel.unMouseMove();
            },
            listeners: {
                beforerender: function( button ) {
                    button.menu.on( 'beforeshow', loadGlobalParticipants );
                }
            }
        } );
        items.push( drawGlobalParticipantButton );
        items.push( new Ext.Toolbar.Separator() );

        var drawStartButton = new Ext.Button( {
            id: 'draw_start_button',
            cls: 'x-btn-icon',
            icon: getPluginImgPath( 'start_small' ),
            disabled: true,
            tooltip: getTranslation( 'Wstaw rozpoczęcie procesu' ),
            used: false,
            handler: function() {
                this.ownerCt.handleButtonPush( this );
                var panel = Ext.getCmp( 'paper_panel' ).getActiveTab();
                if ( this.used ) {
                    panel.objToDrawType = 'start';
                    panel.onMouseMove();
                } else {
                    panel.unMouseMove();
                }
            }
        } );
        items.push( drawStartButton );

        var drawStopButton = new Ext.Button( {
            id: 'draw_stop_button',
            cls: 'x-btn-icon',
            icon: getPluginImgPath( 'stop_small' ),
            disabled: true,
            tooltip: getTranslation( 'Wstaw zakończenie procesu' ),
            used: false,
            handler: function() {
                this.ownerCt.handleButtonPush( this );
                var panel = Ext.getCmp( 'paper_panel' ).getActiveTab();
                if ( this.used ) {
                    panel.objToDrawType = 'stop';
                    panel.onMouseMove();
                } else {
                    panel.unMouseMove();
                }
            }
        } );
        items.push( drawStopButton );

        var drawTerminationsButton = new Ext.Button( {
            id: 'draw_terminations_button',
            cls: 'x-btn-icon',
            icon: getPluginImgPath( 'draw_terminations' ),
            disabled: true,
            tooltip: getTranslation( 'Wstaw rozpoczęcia i zakończenia procesu' ),
            handler: function() {
                var panel = Ext.getCmp( 'paper_panel' ).getActiveTab();
                panel.drawTerminations();
            }
        } );
        items.push( drawTerminationsButton );

        var removeTerminationsButton = new Ext.Button( {
            id: 'remove_terminations_button',
            cls: 'x-btn-icon',
            icon: getPluginImgPath( 'remove_terminations' ),
            disabled: true,
            tooltip: getTranslation( 'Usuń rozpoczęcia i zakończenia procesu' ),
            handler: function() {
                var panel = Ext.getCmp( 'paper_panel' ).getActiveTab();
                panel.removeTerminations();
            }
        } );
        items.push( removeTerminationsButton );
        items.push( new Ext.Toolbar.Separator() );

        var drawActivityButton = new Ext.Button( {
            id: 'draw_activity_button',
            cls: 'x-btn-icon',
            icon: getPluginImgPath( 'activity_small' ),
            disabled: true,
            tooltip: getTranslation( 'Wstaw zadanie' ),
            used: false,
            handler: function() {
                this.ownerCt.handleButtonPush( this );
                var panel = Ext.getCmp( 'paper_panel' ).getActiveTab();
                if ( this.used ) {
                    panel.objToDrawType = 'activity';
                    panel.onMouseMove();
                } else {
                    panel.unMouseMove();
                }
            }
        } );
        items.push( drawActivityButton );

        var drawRouteButton = new Ext.Button( {
            id: 'draw_route_button',
            cls: 'x-btn-icon',
            icon: getPluginImgPath( 'route_small' ),
            disabled: true,
            tooltip: getTranslation( 'Wstaw przekierowanie' ),
            used: false,
            handler: function() {
                this.ownerCt.handleButtonPush( this );
                var panel = Ext.getCmp( 'paper_panel' ).getActiveTab();
                if ( this.used ) {
                    panel.objToDrawType = 'route';
                    panel.onMouseMove();
                } else {
                    panel.unMouseMove();
                }
            }
        } );
        items.push( drawRouteButton );

        var drawToolButton = new Ext.Button( {
            id: 'draw_tool_button',
            cls: 'x-btn-icon',
            icon: getPluginImgPath( 'tool_small' ),
            disabled: true,
            tooltip: getTranslation( 'Wstaw narzędzie systemowe' ),
            used: false,
            handler: function() {
                this.ownerCt.handleButtonPush( this );
                var panel = Ext.getCmp( 'paper_panel' ).getActiveTab();
                if ( this.used ) {
                    panel.objToDrawType = 'tool';
                    panel.onMouseMove();
                } else {
                    panel.unMouseMove();
                }
            }
        } );
        items.push( drawToolButton );

        var drawIntegrationApplicationButton = new Ext.Button( {
            id: 'draw_integration_application_button',
            cls: 'x-btn-icon',
            icon: getPluginImgPath( 'config' ),
            disabled: true,
            tooltip: getTranslation( 'Wstaw zdefiniowane narzędzie systemowe' ),
            menu: new Ext.ux.suncode.IntegrationComponentMenu( {
                getCategoriesFunction: function() {
                    return Ext.getCmp( 'main_panel' ).getApplicationsIntegrationComponentCategories();
                },
                saveFunction: function( component ) {
                    Ext.ux.suncode.IntegrationComponentService.startDrawingApplication( component );
                }
            } ),
            handler: function() {
                this.ownerCt.handleButtonPush( this );
                var panel = Ext.getCmp( 'paper_panel' ).getActiveTab();
                panel.unMouseMove();
            }
        } );
        items.push( drawIntegrationApplicationButton );

        var drawSubflowButton = new Ext.Button( {
            id: 'draw_subflow_button',
            cls: 'x-btn-icon',
            icon: getPluginImgPath( 'subflow_small' ),
            hidden: !config.userConfig.advancedView,
            disabled: true,
            tooltip: getTranslation( 'Wstaw podproces' ),
            used: false,
            handler: function() {
                this.ownerCt.handleButtonPush( this );
                var panel = Ext.getCmp( 'paper_panel' ).getActiveTab();
                if ( this.used ) {
                    panel.objToDrawType = 'subflow';
                    panel.onMouseMove();
                } else {
                    panel.unMouseMove();
                }
            }
        } );
        items.push( drawSubflowButton );
        items.push( new Ext.Toolbar.Separator() );

        var drawBasicLineButton = new Ext.Button( {
            id: 'draw_basic_line_button',
            cls: 'x-btn-icon',
            icon: getPluginImgPath( 'basic_line' ),
            disabled: true,
            tooltip: getTranslation( 'Wstaw połączenie bezwarunkowe' ),
            used: false,
            handler: function() {
                this.ownerCt.handleButtonPush( this );
                var panel = Ext.getCmp( 'paper_panel' ).getActiveTab();
                if ( this.used ) {
                    panel.objToDrawType = 'basicLine';
                    panel.onMouseMove();
                } else {
                    panel.unMouseMove();
                }
            }
        } );
        items.push( drawBasicLineButton );

        var drawConditionalXorLineButton = new Ext.Button( {
            id: 'draw_conditional_xor_line_button',
            cls: 'x-btn-icon',
            icon: getPluginImgPath( 'cond_line_xor' ),
            disabled: true,
            tooltip: getTranslation( 'Wstaw połączenie warunkowe wykluczające' ),
            used: false,
            handler: function() {
                this.ownerCt.handleButtonPush( this );
                var panel = Ext.getCmp( 'paper_panel' ).getActiveTab();
                if ( this.used ) {
                    panel.objToDrawType = 'conditionalLine';
                    panel.condLineType = 'XOR';
                    panel.onMouseMove();
                } else {
                    panel.unMouseMove();
                }
            }
        } );
        items.push( drawConditionalXorLineButton );

        var drawConditionalAndLineButton = new Ext.Button( {
            id: 'draw_conditional_and_line_button',
            cls: 'x-btn-icon',
            icon: getPluginImgPath( 'cond_line_and' ),
            disabled: true,
            tooltip: getTranslation( 'Wstaw połączenie równoległe' ),
            used: false,
            handler: function() {
                this.ownerCt.handleButtonPush( this );
                var panel = Ext.getCmp( 'paper_panel' ).getActiveTab();
                if ( this.used ) {
                    panel.objToDrawType = 'conditionalLine';
                    panel.condLineType = 'AND';
                    panel.onMouseMove();
                } else {
                    panel.unMouseMove();
                }
            }
        } );
        items.push( drawConditionalAndLineButton );

        var drawOtherwiseButton = new Ext.Button( {
            id: 'draw_otherwise_line_button',
            cls: 'x-btn-icon',
            icon: getPluginImgPath( 'otherwise' ),
            disabled: true,
            tooltip: getTranslation( 'Wstaw połączenie "w przeciwnym razie"' ),
            used: false,
            handler: function() {
                this.ownerCt.handleButtonPush( this );
                var panel = Ext.getCmp( 'paper_panel' ).getActiveTab();
                if ( this.used ) {
                    panel.objToDrawType = 'otherwiseLine';
                    panel.onMouseMove();
                } else {
                    panel.unMouseMove();
                }
            }
        } );
        items.push( drawOtherwiseButton );

        var drawDeadlineLineButton = new Ext.Button( {
            id: 'draw_deadline_line_button',
            cls: 'x-btn-icon',
            icon: getPluginImgPath( 'deadline' ),
            hidden: !config.userConfig.advancedView,
            disabled: true,
            tooltip: getTranslation( 'Wstaw wyjątek' ),
            used: false,
            handler: function() {
                this.ownerCt.handleButtonPush( this );
                var panel = Ext.getCmp( 'paper_panel' ).getActiveTab();
                if ( this.used ) {
                    panel.objToDrawType = 'deadlineLine';
                    panel.onMouseMove();
                } else {
                    panel.unMouseMove();
                }
            }
        } );
        items.push( drawDeadlineLineButton );

        var drawBasicLineWithRouteButton = new Ext.Button( {
            id: 'draw_basic_line_with_route_button',
            cls: 'x-btn-text',
            text: '',
            hidden: true,
            disabled: true,
            used: false,
            handler: function() {
                this.ownerCt.handleButtonPush( this );
                var panel = Ext.getCmp( 'paper_panel' ).getActiveTab();
                if ( this.used ) {
                    panel.objToDrawType = 'basicLineWithRoute';
                    panel.onMouseMove();
                } else {
                    panel.unMouseMove();
                }
            }
        } );
        items.push( drawBasicLineWithRouteButton );

        var drawCondLineWithRouteButton = new Ext.Button( {
            id: 'draw_conditional_line_with_route_button',
            cls: 'x-btn-text',
            text: '',
            hidden: true,
            disabled: true,
            used: false,
            handler: function() {
                this.ownerCt.handleButtonPush( this );
                var panel = Ext.getCmp( 'paper_panel' ).getActiveTab();
                if ( this.used ) {
                    panel.objToDrawType = 'conditionalLineWithRoute';
                    panel.onMouseMove();
                } else {
                    panel.unMouseMove();
                }
            }
        } );
        items.push( drawCondLineWithRouteButton );

        var drawBasicLineWithActivityButton = new Ext.Button( {
            id: 'draw_basic_line_with_activity_button',
            cls: 'x-btn-text',
            text: '',
            hidden: true,
            disabled: true,
            used: false,
            handler: function() {
                this.ownerCt.handleButtonPush( this );
                var panel = Ext.getCmp( 'paper_panel' ).getActiveTab();
                if ( this.used ) {
                    panel.objToDrawType = 'basicLineWithActivity';
                    panel.onMouseMove();
                } else {
                    panel.unMouseMove();
                }
            }
        } );
        items.push( drawBasicLineWithActivityButton );

        var drawCondLineWithActivityButton = new Ext.Button( {
            id: 'draw_conditional_line_with_activity_button',
            cls: 'x-btn-text',
            text: '',
            hidden: true,
            disabled: true,
            used: false,
            handler: function() {
                this.ownerCt.handleButtonPush( this );
                var panel = Ext.getCmp( 'paper_panel' ).getActiveTab();
                if ( this.used ) {
                    panel.objToDrawType = 'conditionalLineWithActivity';
                    panel.onMouseMove();
                } else {
                    panel.unMouseMove();
                }
            }
        } );
        items.push( drawCondLineWithActivityButton );

        var drawBasicLineWithToolButton = new Ext.Button( {
            id: 'draw_basic_line_with_tool_button',
            cls: 'x-btn-text',
            text: '',
            hidden: true,
            disabled: true,
            used: false,
            handler: function() {
                this.ownerCt.handleButtonPush( this );
                var panel = Ext.getCmp( 'paper_panel' ).getActiveTab();
                if ( this.used ) {
                    panel.objToDrawType = 'basicLineWithTool';
                    panel.onMouseMove();
                } else {
                    panel.unMouseMove();
                }
            }
        } );
        items.push( drawBasicLineWithToolButton );

        var drawCondLineWithToolButton = new Ext.Button( {
            id: 'draw_conditional_line_with_tool_button',
            cls: 'x-btn-text',
            text: '',
            hidden: true,
            disabled: true,
            used: false,
            handler: function() {
                this.ownerCt.handleButtonPush( this );
                var panel = Ext.getCmp( 'paper_panel' ).getActiveTab();
                if ( this.used ) {
                    panel.objToDrawType = 'conditionalLineWithTool';
                    panel.onMouseMove();
                } else {
                    panel.unMouseMove();
                }
            }
        } );
        items.push( drawCondLineWithToolButton );

        var drawBasicLineWithSubflowButton = new Ext.Button( {
            id: 'draw_basic_line_with_subflow_button',
            cls: 'x-btn-text',
            text: '',
            hidden: true,
            disabled: true,
            used: false,
            handler: function() {
                this.ownerCt.handleButtonPush( this );
                var panel = Ext.getCmp( 'paper_panel' ).getActiveTab();
                if ( this.used ) {
                    panel.objToDrawType = 'basicLineWithSubflow';
                    panel.onMouseMove();
                } else {
                    panel.unMouseMove();
                }
            }
        } );
        items.push( drawBasicLineWithSubflowButton );

        var drawCondLineWithSubflowButton = new Ext.Button( {
            id: 'draw_conditional_line_with_subflow_button',
            cls: 'x-btn-text',
            text: '',
            hidden: true,
            disabled: true,
            used: false,
            handler: function() {
                this.ownerCt.handleButtonPush( this );
                var panel = Ext.getCmp( 'paper_panel' ).getActiveTab();
                if ( this.used ) {
                    panel.objToDrawType = 'conditionalLineWithSubflow';
                    panel.onMouseMove();
                } else {
                    panel.unMouseMove();
                }
            }
        } );
        items.push( drawCondLineWithSubflowButton );

        var drawBasicLineWithStartButton = new Ext.Button( {
            id: 'draw_basic_line_with_start_button',
            cls: 'x-btn-text',
            text: '',
            hidden: true,
            disabled: true,
            used: false,
            handler: function() {
                this.ownerCt.handleButtonPush( this );
                var panel = Ext.getCmp( 'paper_panel' ).getActiveTab();
                if ( this.used ) {
                    panel.objToDrawType = 'basicLineWithStart';
                    panel.onMouseMove();
                } else {
                    panel.unMouseMove();
                }
            }
        } );
        items.push( drawBasicLineWithStartButton );

        var drawBasicLineWithStopButton = new Ext.Button( {
            id: 'draw_basic_line_with_stop_button',
            cls: 'x-btn-text',
            text: '',
            hidden: true,
            disabled: true,
            used: false,
            handler: function() {
                this.ownerCt.handleButtonPush( this );
                var panel = Ext.getCmp( 'paper_panel' ).getActiveTab();
                if ( this.used ) {
                    panel.objToDrawType = 'basicLineWithStop';
                    panel.onMouseMove();
                } else {
                    panel.unMouseMove();
                }
            }
        } );
        items.push( drawBasicLineWithStopButton );
    }

    config = Ext.apply( {
        usedButton: null,
        items: items
    } );

    Ext.ux.suncode.PaperPanelTopToolbar.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.PaperPanelTopToolbar, Ext.Toolbar, {
    initComponent: function() {
        Ext.ux.suncode.PaperPanelTopToolbar.superclass.initComponent.call( this );
    },
    handleButtonPush: function( button ) {
        var usedButton = this.usedButton;

        if ( usedButton && usedButton.id !== button.id ) {
            this.setUsedPropertyForButton( usedButton );
        }

        var isUsed = this.setUsedPropertyForButton( button );

        if ( isUsed ) {
            this.usedButton = button;
        } else {
            this.usedButton = null;
        }
    },
    setUsedPropertyForButton: function( button ) {
        if ( button.used ) {
            button.used = false;
            button.removeClass( 'x-btn-pressed' );
            return false;
        } else {
            button.used = true;
            button.addClass( 'x-btn-pressed' );
            return true;
        }
    },
    enableAllButtons: function() {
        var buttons = this.items.items;
        Ext.each( buttons, function( button, index, buttons ) {
            if ( button.disabled ) {
                button.enable();
            }
        } );
    },
    disableAllButtons: function() {
        var buttons = this.items.items;
        Ext.each( buttons, function( button, index, buttons ) {
            if ( !button.disabled ) {
                button.disable();
            }
        } );
    },
    deactivateUsedButton: function() {
        if ( this.usedButton ) {
            this.usedButton.handler.call( this.usedButton );
            return true;
        }
        return false;
    }
} );

Ext.ux.suncode.ProcessNode = function( config ) {
    config = Ext.apply( {
        text: this.getNodeText( config.initialProcessDefId, config.initialProcessName, config.initialProcessColor ),
        icon: getPluginImgPath( 'process' ),
        draggable: false,
        currentActivityNo: 0,
        processDefId: config.initialProcessDefId,
        processName: config.initialProcessName,
        processCreationTime: config.initialProcessCreationTime,
        processColor: config.initialProcessColor,
        processNameMask: config.initialProcessNameMask,
        processDescr: config.initialProcessDescr,
        attachmentDirectory: config.initialAttachmentDirectory,
        idChanged: config.idChanged,
        participants: new Array(),
        variables: new Array(),
        tables: new Array(),
        labels: new Array(),
        formalParameters: Ext.ux.suncode.FormalParameterService.getDefaultParameters(),
        applications: new Array(),
        starts: new Array(),
        stops: new Array(),
        specification: Ext.ux.suncode.DocumentationService.initProcessSpecification(),
        templates: {
        	validators: new Array(),
        	variablesSetters: new Array()
        },
        formPreview: {
        	dataSets: new Array()
        },
        globalSettings: {
        	formVariableLabel: {
        		labelAlign: '',
        		labelWidth: null,
        		labelSeparator: '',
        		labelFontSize: null,
        		labelColor: '',
        		textDecoration: ''
        	},
          label: {
            fontSize: null,
            color: ''
          },
        	variableSetFont: {
        		headerFontSize: null,
        		cellFontSize: null
        	}
        },
        sortOrder: {
          attributeName: '',
          asc: true
        },
        listeners: {
            scope: this,
            contextmenu: function( node, e ) {
                e.stopEvent();
                node.fireEvent( 'click', node, e );
                this.showContextMenu( e.getXY() );
            },
            dblclick: function( node, e ) {
                showProcessProperties( node );
            },
            click: function( node, e ) {
                changeProcessTab( node.attributes.processDefId );
            }
        }
    } );

    Ext.ux.suncode.ProcessNode.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.ProcessNode, Ext.tree.TreeNode, {
    initComponent: function() {
        Ext.ux.suncode.ProcessNode.superclass.initComponent.call( this );
    },
    showContextMenu: function( pos ) {
        var mainPanel = Ext.getCmp( 'main_panel' );
        var items = new Array();
        items.push( new Ext.menu.Item( {
            cls: 'x-btn-text-icon',
            icon: getPluginImgPath( 'package_delete' ),
            text: getTranslation( 'Usuń proces' ),
            scope: this,
            handler: function() {
                deleteProcess( this );
            }
        } ) );
        items.push( new Ext.menu.Separator() );
        if ( mainPanel.getDocumentationView() ) {
            items.push( new Ext.menu.Item( {
                cls: 'x-btn-text-icon',
                icon: getPluginImgPath( 'specification' ),
                text: getTranslation( 'Specyfikacja' ),
                scope: this,
                handler: function() {
                    editProcessSpecification( this );
                }
            } ) );
        }
        items.push( new Ext.menu.Item( {
            cls: 'x-btn-text-icon',
            icon: getPluginImgPath( 'collation' ),
            text: getTranslation( 'Zestawienie zmiennych' ),
            scope: this,
            handler: function() {
                showVariablesCollation( this );
            }
        } ) );
        items.push( new Ext.menu.Item( {
            cls: 'x-btn-text-icon',
            icon: getPluginImgPath( 'template' ),
            text: getTranslation( 'Szablony' ),
            menu: new Ext.menu.Menu( {
                items: [ {
                	cls: 'x-btn-text-icon',
                    icon: getPluginImgPath( 'template' ),
                    text: getTranslation( 'Mechanizmy sprawdzające formularz' ),
                    scope: this,
                    handler: function() {
                    	showValidatorsTemplates( this );
                    }
                }, {
                	cls: 'x-btn-text-icon',
                    icon: getPluginImgPath( 'template' ),
                    text: getTranslation( 'Mechanizmy uruchamiane po akceptacji' ),
                    scope: this,
                    handler: function() {
                    	showVariablesSettersTemplates( this );
                    }
                } ]
            } )
        } ) );
        items.push( new Ext.menu.Item( {
            cls: 'x-btn-text-icon',
            icon: getPluginImgPath( 'config' ),
            text: getTranslation( 'Ustawienia globalne' ),
            menu: new Ext.menu.Menu( {
                items: [ {
                	  cls: 'x-btn-text-icon',
                    icon: getPluginImgPath( 'label' ),
                    text: getTranslation( 'Etykieta zmiennej formularza' ),
                    scope: this,
                    handler: function() {
                    	setFormVariableLabelGlobalSettings( this );
                    }
                }, {
                  cls: 'x-btn-text-icon',
                  icon: getPluginImgPath( 'label' ),
                  text: getTranslation( 'Etykieta' ),
                  scope: this,
                  handler: function() {
                    setLabelGlobalSettings( this );
                  }
                }, {
                	  cls: 'x-btn-text-icon',
                    icon: getPluginImgPath( 'label' ),
                    text: getTranslation( 'Czcionka w tabeli dynamicznej' ),
                    scope: this,
                    handler: function() {
                    	setVariableSetFontGlobalSettings( this );
                    }
                } ]
            } )
        } ) );
        items.push( new Ext.menu.Item( {
            cls: 'x-btn-text-icon',
            icon: getPluginImgPath( 'create_file' ),
            text: getTranslation( 'Generuj' ),
            menu: new Ext.menu.Menu( {
                items: [ {
                	cls: 'x-btn-text-icon',
                    icon: getPluginImgPath( 'xpdl' ),
                    text: getTranslation( 'Mapa procesu' ),
                    scope: this,
                    handler: function() {
                    	generateXpdl( {
                    		processDefId: this.attributes.processDefId,
                    		processName: this.attributes.processName
                    	} );
                    }
                }, {
                	cls: 'x-btn-text-icon',
                    icon: getPluginImgPath( 'zip' ),
                    text: getTranslation( 'Archiwum ZIP' ),
                    scope: this,
                    handler: function() {
                    	generateZip( {
                    		processDefId: this.attributes.processDefId,
                    		processName: this.attributes.processName
                    	} );
                    }
                } ]
            } )
        } ) );
        items.push( new Ext.menu.Separator() );
        items.push( new Ext.menu.Item( {
          cls: 'x-btn-text-icon',
          icon: getPluginImgPath( 'sort' ),
          text: getTranslation( 'Sortuj zadania' ),
          menu: new Ext.menu.Menu( {
            items: [ {
              cls: 'x-btn-text-icon',
              icon: getPluginImgPath( 'alphabet' ),
              text: getTranslation( 'Alfabetycznie rosnąco' ),
              scope: this,
              handler: function() {
                this.setSortOrder( 'activityName', true );
                this.sortActivities();
              }
            }, {
              cls: 'x-btn-text-icon',
              icon: getPluginImgPath( 'alphabet' ),
              text: getTranslation( 'Alfabetycznie malejąco' ),
              scope: this,
              handler: function() {
                this.setSortOrder( 'activityName', false );
                this.sortActivities();
              }
            } ]
          } )
        } ) );
        items.push( new Ext.menu.Item( {
            cls: 'x-btn-text-icon',
            icon: getPluginImgPath( 'properties' ),
            text: menuTextWithHotkey( getTranslation( 'Właściwości' ), 'F2' ),
            scope: this,
            handler: function() {
                showProcessProperties( this );
            }
        } ) );

        var menu = new Ext.menu.Menu( {
            items: items
        } );
        menu.showAt( pos );
    },
    setSortOrder: function( attributeName, asc ) {
      this.attributes.sortOrder = {
        attributeName: attributeName,
        asc: asc
      };
    },
    sortActivities: function() {
      if ( !Ext.isEmpty( this.attributes.sortOrder.attributeName ) ) {
        sortNode( this, this.attributes.sortOrder.attributeName, this.attributes.sortOrder.asc );
      }
    },
    updateProcessDef: function( def ) {
        this.attributes.processDefId = def.processDefId;
        this.attributes.processDescr = def.processDescr;
        this.attributes.processName = def.processName;
        this.attributes.processColor = def.processColor;
        this.attributes.processNameMask = def.processNameMask;
        this.attributes.idChanged = true;
        this.setText( this.getNodeText( def.processDefId, def.processName, def.processColor ) );
    },
    getNodeText: function( processDefId, processName, processColor ) {
        var processNameTranslation = getXpdlProcessNameTranslation( processDefId, processName );
        var encodedProcessName = Ext.util.Format.htmlEncode( processNameTranslation );

        if ( !Ext.isEmpty( processColor ) ) {
            return setTextColor( encodedProcessName, processColor );
        } else {
            return encodedProcessName;
        }
    },
    incrementActivityNo: function() {
        this.attributes.currentActivityNo++;
    },
    isIdUnique: function( activityDefId ) {
        if ( this.findChild( 'activityDefId', activityDefId ) ) {
            return false;
        }
        return true;
    },
    addActivity: function( activity ) {
        this.appendChild( activity );
        updateProcessTabTip();
        Ext.getCmp( 'main_panel' ).setSaved( false );
    },
    removeActivity: function( activity ) {
        this.removeChild( activity, true );
        this.removeAllNextActivitiesById( activity.attributes.activityDefId );
        updateProcessTabTip();
        Ext.getCmp( 'main_panel' ).setSaved( false );
    },
    removeActivityById: function( activityDefId ) {
        var activity = this.findChild( 'activityDefId', activityDefId );
        this.removeActivity( activity );
    },
    findRole: function( roleId ) {
        var roles = this.attributes.participants;
        for ( var i = 0; i < roles.length; i++ ) {
            if ( roleId == roles[i].roleId ) {
                return roles[i];
            }
        }
        return null;
    },
    addRole: function( role ) {
        var r = role[0];
        var isGlobal = r.data( 'isGlobal' );
        var roleId = r.data( 'roleId' );
        this.attributes.participants.push( {
            roleName: r.data( 'roleName' ),
            roleType: r.data( 'roleType' ),
            roleId: roleId,
            roleWidth: r.data( 'roleWidth' ),
            roleHeight: r.data( 'roleHeight' ),
            isGlobal: isGlobal !== undefined ? isGlobal : false,
            idChanged: false
        } );
        Ext.ux.suncode.DocumentationService.addParticipantSpecification( this, roleId, {
            description: ''
        } );
        updateProcessTabTip();
        Ext.getCmp( 'main_panel' ).setSaved( false );
    },
    removeRole: function( roleId ) {
        var roles = this.attributes.participants;
        for ( var i = 0; i < roles.length; i++ ) {
            if ( roleId == roles[i].roleId ) {
                this.eachChild( function( activityNode ) {
                    activityNode.resetRoleUsersFormVariable( roleId );
                } );
                roles.splice( i, 1 );
                Ext.ux.suncode.DocumentationService.deleteParticipantSpecification( this, roleId );
                updateProcessTabTip();
                Ext.getCmp( 'main_panel' ).setSaved( false );
                break;
            }
        }
    },
    updateRole: function( oldRoleId, role ) {
        var roles = this.attributes.participants;
        for ( var i = 0; i < roles.length; i++ ) {
            if ( oldRoleId == roles[i].roleId ) {
                roles[i].roleId = role.roleId;
                roles[i].roleName = role.roleName;
                roles[i].roleType = role.roleType;
                roles[i].roleDescr = role.roleDescr;
                roles[i].idChanged = true;
                this.updateStartStopRoleId( oldRoleId, role.roleId );
                Ext.ux.suncode.DocumentationService.updateSpecificationDescriptionsForRoleId( this, oldRoleId, role.roleId );
                Ext.getCmp( 'main_panel' ).setSaved( false );
                break;
            }
        }
    },
    updateRoleWidth: function( roleId, newWidth ) {
        var roles = this.attributes.participants;
        for ( var i = 0; i < roles.length; i++ ) {
            if ( roleId == roles[i].roleId ) {
                roles[i].roleWidth = newWidth;
                Ext.getCmp( 'main_panel' ).setSaved( false );
                break;
            }
        }
    },
    updateRoleHeight: function( roleId, newHeight ) {
        var roles = this.attributes.participants;
        for ( var i = 0; i < roles.length; i++ ) {
            if ( roleId == roles[i].roleId ) {
                roles[i].roleHeight = newHeight;
                Ext.getCmp( 'main_panel' ).setSaved( false );
                break;
            }
        }
    },
    switchRolesOrder: function( sRoleId, dRoleId ) {
        var sindex = 0;
        var dindex = 0;

        var roles = this.attributes.participants;
        for ( var i = 0; i < roles.length; i++ ) {
            var role = roles[i];

            if ( role.roleId == sRoleId ) {
                sindex = i;
            }

            if ( role.roleId == dRoleId ) {
                dindex = i;
            }
        }

        changePlacementInTab( this.attributes.participants, sindex, dindex );
    },
    setAllRolesIdChanged: function() {
        var roles = this.attributes.participants;
        for ( var i = 0; i < roles.length; i++ ) {
            roles[i].idChanged = true;
        }
    },
    setRoleIdChanged: function( roleId ) {
        var roles = this.attributes.participants;
        for ( var i = 0; i < roles.length; i++ ) {
            if ( roleId == roles[i].roleId ) {
                roles[i].idChanged = true;
                break;
            }
        }
    },
    setRoleDescription: function( roleId, roleDescr ) {
        var participants = this.attributes.participants;
        for ( var i = 0; i < participants.length; i++ ) {
            if ( roleId == participants[i].roleId ) {
                participants[i].roleDescr = roleDescr;
                Ext.getCmp( 'main_panel' ).setSaved( false );
                break;
            }
        }
    },
    updateSubflowsIds: function( oldSubflowId, newSubflowId ) {
        var thisProcessDefId = this.attributes.processDefId;
        this.parentNode.eachChild( function( processNode ) {
            if ( processNode.attributes.processDefId != thisProcessDefId ) {
                processNode.eachChild( function( activityNode ) {
                    activityNode.changeSubflowId( oldSubflowId, newSubflowId );
                } );
            }
        } );
    },
    findFormalParam: function( name ) {
        var fParams = this.attributes.formalParameters;
        for ( var i = 0; i < fParams.length; i++ ) {
            if ( name == fParams[i].name ) {
                return fParams[i];
            }
        }
        return null;
    },
    findFormalParamIgnoreCase: function( name ) {
        var fParams = this.attributes.formalParameters;
        for ( var i = 0; i < fParams.length; i++ ) {
            if ( name.toLowerCase() == fParams[i].name.toLowerCase() ) {
                return fParams[i];
            }
        }
        return null;
    },
    addFormalParam: function( fpObj ) {
        this.attributes.formalParameters.push( fpObj );
        updateProcessTabTip();
        Ext.getCmp( 'main_panel' ).setSaved( false );
    },
    copyFormalParam: function( name ) {
      var formalParam = this.findFormalParam( name );
      var formalParamCopy = deepObjectCopy( formalParam );
      var formalParamCopyName = this.generateFormalParamCopyName( formalParam );

      if ( Ext.isEmpty( formalParamCopyName ) ) {
        return null;
      }

      Ext.apply( formalParamCopy, {
        id: formalParamCopyName,
        name: formalParamCopyName,
        status: 'custom'
      } );

      this.addFormalParam( formalParamCopy );

      return formalParamCopy;
    },
    loadFormalParams: function( fParams ) {
        this.attributes.formalParameters = fParams ? fParams : new Array();
    },
    removeFormalParam: function( record, grid ) {
    	var name = record.get( 'name' );
    	var componentsUsingVariable = Ext.ux.suncode.IntegrationComponentService.getComponentsUsingVariable( this, name );
    	if ( !Ext.isEmpty( componentsUsingVariable ) ) {
    		var warning = getTranslation( 'Parametr formalny jest wykorzystywany w komponentach.' );
    		var title = getTranslation( 'Komponenty wykorzystujące parametr formalny' ) + ': ' + name;
    		Ext.ux.suncode.IntegrationComponentService.showComponentsUsingVariableWarning( warning, {
              windowTitle: title,
            	utilization: componentsUsingVariable,
            	showCustomDescription: true,
              showModificationDate: true,
              showVariableUtilizationActions: true,
              enableRemoveAll: true,
            	processNode: this,
            	variableId: name
            } );
    		return;
    	}
    	
        var warnMsg = getTranslation( 'Usunięcie parametru formalnego może spowodować zmiany w następujących komponentach procesu:' );
        warnMsg += '<br>' + getTranslation( '- zmienne procesu' );
        warnMsg += '<br>' + getTranslation( '- przyciski akceptacji' );
        warnMsg += '<br>' + getTranslation( '- terminy ostateczne' );
        warnMsg += '<br>' + getTranslation( '- przypisania zadań' );
        warnMsg += '<br>' + getTranslation( '- połączenia warunkowe i równoległe' );
        warnMsg += '<br>' + getTranslation( '- aplikacje' );
        warnMsg += '<br>' + getTranslation( '- podprocesy' );
        warnMsg += '<br>' + getTranslation( '- dodatki do zadań' );
        warnMsg += '<br><br>' + getTranslation( 'Czy chcesz kontynuować?' );

        Ext.Msg.show( {
            title: '<font weight="bold">' + getTranslation( 'Uwaga' ) + '</font>',
            msg: warnMsg,
            buttons: {
                yes: getTranslation( 'Tak' ),
                no: getTranslation( 'Nie' )
            },
            fn: function( buttonId ) {
                if ( buttonId == 'yes' ) {
                    removeRowAndMarkNext( grid, record );
                    grid.updateTitle();
                    this.executeRemoveFormalParam( name );
                }
            },
            icon: Ext.Msg.QUESTION,
            scope: this
        } );
    },
    executeRemoveFormalParam: function( paramName ) {
        var maskId = 'remove_formal_parameter_mask';

        try {
            showLoadingMask( maskId, getTranslation( 'Trwa usuwanie parametru formalnego...' ) );
            var fpParams = this.attributes.formalParameters;
            var formalParamIdx = -1;
            for ( var i = 0; i < fpParams.length; i++ ) {
                if ( paramName == fpParams[i].name ) {
                    fpParams.splice( i, 1 );
                    formalParamIdx = i;
                    updateProcessTabTip();
                    Ext.getCmp( 'main_panel' ).setSaved( false );
                    break;
                }
            }

            var variables = this.attributes.variables;
            for ( var i = 0; i < variables.length; i++ ) {
                var v = variables[i];

                if ( v.valuesList ) {
                    var valuesList = v.valuesList;
                    for ( var j = 0; j < valuesList.length; j++ ) {
                        if ( valuesList[j].value == '<' + paramName + '>' ) {
                            valuesList.splice( j, 1 );
                            break;
                        }
                    }
                } else if ( v.formCriteria ) {
                    var formCriteria = v.formCriteria;
                    for ( var j = 0; j < formCriteria.length; j++ ) {
                        if ( formCriteria[j].varId == paramName ) {
                            formCriteria.splice( j, 1 );
                            break;
                        }
                    }
                }
            }

            this.eachChild( function( activityNode ) {
                activityNode.clearFormButtonsByVarId( paramName );
                activityNode.clearApplicationsByVarId( paramName );
                activityNode.removeDeadlinesByVarId( paramName );
                activityNode.changeSubflowParam( paramName, '' );
                activityNode.clearAdditionalsByVarId( paramName );
                activityNode.clearAssignmentByVarId( paramName );
            } );

            var thisProcessDefId = this.attributes.processDefId;
            this.parentNode.eachChild( function( processNode ) {
                if ( processNode.attributes.processDefId != thisProcessDefId ) {
                    processNode.eachChild( function( activityNode ) {
                        if ( activityNode.attributes.subflow.id == thisProcessDefId ) {
                            activityNode.removeSubflowParamByIndex( formalParamIdx );
                        }
                    } );
                }
            } );
        }
        finally {
            removeLoadingMask( maskId );
        }
    },
    updateFormalParam: function( oldName, fpObj ) {
        var maskId = 'update_formal_parameter_mask';

        try {
            showLoadingMask( maskId, getTranslation( 'Trwa modyfikowanie parametru formalnego...' ) );
            var fpParams = this.attributes.formalParameters;
            for ( var i = 0; i < fpParams.length; i++ ) {
                if ( oldName == fpParams[i].name ) {
                    fpParams[i] = fpObj;

                    if ( oldName != fpObj.name ) {
                        var variables = this.attributes.variables;
                        for ( var j = 0; j < variables.length; j++ ) {
                            var v = variables[j];

                            if ( v.valuesList ) {
                                var valuesList = v.valuesList;
                                for ( var k = 0; k < valuesList.length; k++ ) {
                                    if ( valuesList[k].value == '<' + oldName + '>' ) {
                                        valuesList[k].value = '<' + fpObj.id + '>';
                                    }
                                }
                            } else if ( v.formCriteria ) {
                                var formCriteria = v.formCriteria;
                                for ( var k = 0; k < formCriteria.length; k++ ) {
                                    if ( formCriteria[k].varId == oldName ) {
                                        formCriteria[k].varId = fpObj.id;
                                    }
                                }
                            }
                        }
                        
                        this.changeTemplates( oldName, fpObj.id );

                        this.eachChild( function( activityNode ) {
                            activityNode.changeFormButton( oldName, fpObj.id );
                            activityNode.changeFormAction( oldName, fpObj.id );
                            activityNode.changeEventAction( oldName, fpObj.id );
                            activityNode.changeApplicationParam( oldName, fpObj.id );
                            activityNode.changeCondTransitionCondition( oldName, fpObj.id );
                            activityNode.changeDeadline( oldName, fpObj.id );
                            activityNode.changeSubflowParam( oldName, fpObj.id );
                            activityNode.changeAdditionals( oldName, fpObj.id );
                            activityNode.changeAssignment( oldName, fpObj.id );
                        } );
                    }

                    Ext.getCmp( 'main_panel' ).setSaved( false );
                    break;
                }
            }
        }
        finally {
            removeLoadingMask( maskId );
        }
    },
    findVariable: function( varId ) {
        var variables = this.attributes.variables;
        for ( var i = 0; i < variables.length; i++ ) {
            if ( varId == variables[i].id ) {
                return variables[i];
            }
        }
        return null;
    },
    addVariable: function( varObj ) {
        this.attributes.variables.push( varObj );
        updateProcessTabTip();
        Ext.getCmp( 'main_panel' ).setSaved( false );
    },
    copyVariable: function( varId ) {
    	  var variable = this.findVariable( varId );
        var varCopy = deepObjectCopy( variable );
        var varCopyName = variable.name + ' ' + getTranslation( 'Kopia' );
        var varCopyId = this.generateVariableCopyId( variable );
        var currentDate = new Date().format( 'Y-m-d H:i:s' );

        if ( Ext.isEmpty( varCopyId ) ) {
            return null;
        }

        Ext.apply( varCopy, {
        	id: varCopyId,
        	name: varCopyName,
          creationDate: currentDate,
          modificationDate: currentDate
        } );

        if ( varCopy.type == 'DATA_CHOOSER' ) {
        	if ( !Ext.isEmpty( varCopy.mappings ) ) {
        		for ( var i = 0; i < varCopy.mappings.length; i++ ) {
            		var mapping = varCopy.mappings[i];
            		
            		if ( mapping.varId == varId ) {
            			mapping.varId = varCopyId;
            		}
            	}
        	} else if ( !Ext.isEmpty( varCopy.definition.mappings ) ) {
        		Ext.iterate( varCopy.definition.mappings, function( key, mapping, allMappings ) {
        			if ( mapping.variable === varId ) {
        				mapping.variable = varCopyId;
        			}
            	} );
        	}
        }

        this.addVariable( varCopy );
        
        return varCopy;
    },
    generateVariableCopyId: function( variable ) {
      var counter = 2;
      var reverseIdGeneration = false;
      var varCopyId = this.buildVariableCopyId( variable, counter, reverseIdGeneration );

      while ( this.findVariable( varCopyId ) ) {
        counter++;
        varCopyId = this.buildVariableCopyId( variable, counter, reverseIdGeneration );

        if ( counter > 99 ) {
          if ( reverseIdGeneration ) {
            return null;
          } else {
            reverseIdGeneration = true;
            counter = 2;
            varCopyId = this.buildVariableCopyId( variable, counter, reverseIdGeneration );
          }
        }
      }

      return varCopyId;
    },
    buildVariableCopyId: function( variable, counter, reverseIdGeneration ) {
        var newId = reverseIdGeneration ? counter + '_' + variable.id : variable.id + '_' + counter;

        if ( newId.length > Ext.ux.suncode.Constants.VARIABLE_ID_MAX_LENGTH ) {
            return variable.id.substring( 0, variable.id.length - new String( counter ).length ) + counter;
        } else {
            return newId;
        }
    },
    generateFormalParamCopyName: function( formalParam ) {
      var counter = 1;
      var formalParamCopyName = this.buildFormalParamCopyName( formalParam, counter );

      while ( this.findFormalParam( formalParamCopyName ) ) {
        counter++;
        formalParamCopyName = this.buildFormalParamCopyName( formalParam, counter );

        if ( counter > 99 ) {
          return null;
        }
      }

      return formalParamCopyName;
    },
    buildFormalParamCopyName: function( formalParam, counter ) {
      var newName = counter > 1
          ? formalParam.name + '_' + getTranslation( 'Kopia' ) + '_' + counter
          : formalParam.name + '_' + getTranslation( 'Kopia' );

      if ( newName.length > Ext.ux.suncode.Constants.VARIABLE_ID_MAX_LENGTH ) {
        return formalParam.name.substring( 0, formalParam.name.length - new String( counter ).length ) + counter;
      } else {
        return newName;
      }
    },
    loadVariables: function( vars ) {
        this.attributes.variables = vars ? vars : new Array();
    },
    removeVariable: function( records, grid ) {
    	for ( var i = 0; i < records.length; i++ ) {
    		var record = records[i];
    		var varId = record.get( 'id' );
        	var componentsUsingVariable = Ext.ux.suncode.IntegrationComponentService.getComponentsUsingVariable( this, varId );
        	
        	if ( !Ext.isEmpty( componentsUsingVariable ) ) {
        		var varName = record.get( 'name' );
        		var warning = getTranslation( 'Zmienna' ) + ' <b>' + varName + '</b> '
        			+ getTranslation( 'jest wykorzystywana w komponentach' ) + '.';
        		var title = getTranslation( 'Komponenty wykorzystujące zmienną' ) + ': ' + varName;
        		Ext.ux.suncode.IntegrationComponentService.showComponentsUsingVariableWarning( warning, {
                  windowTitle: title,
                	utilization: componentsUsingVariable,
                	showCustomDescription: true,
                  showModificationDate: true,
                  showVariableUtilizationActions: true,
                  enableRemoveAll: true,
                	processNode: this,
                	variableId: varId
                } );
        		return;
        	}
    	}
    	
        var mainPanel = Ext.getCmp( 'main_panel' );
        var warnMsg = getTranslation( 'Usunięcie zmiennych procesu może spowodować zmiany w następujących komponentach procesu:' );
        if ( mainPanel.getDocumentationView() ) {
            warnMsg += '<br>' + getTranslation( '- specyfikacja procesu' );
        }
        warnMsg += '<br>' + getTranslation( '- zmienne formularza' );
        warnMsg += '<br>' + getTranslation( '- tabele dynamiczne' );
        warnMsg += '<br>' + getTranslation( '- dynamiczne listy' );
        warnMsg += '<br>' + getTranslation( '- przyciski formularza' );
        warnMsg += '<br>' + getTranslation( '- przyciski akceptacji' );
        warnMsg += '<br>' + getTranslation( '- terminy ostateczne' );
        warnMsg += '<br>' + getTranslation( '- akceptacje' );
        warnMsg += '<br>' + getTranslation( '- przypisania zadań' );
        warnMsg += '<br>' + getTranslation( '- połączenia warunkowe i równoległe' );
        warnMsg += '<br>' + getTranslation( '- aplikacje' );
        warnMsg += '<br>' + getTranslation( '- podprocesy' );
        warnMsg += '<br>' + getTranslation( '- dodatki do zadań' );
        warnMsg += '<br>' + getTranslation( '- inne zmienne procesu' );
        warnMsg += '<br><br>' + getTranslation( 'Czy chcesz kontynuować?' );

        Ext.Msg.show( {
            title: '<font weight="bold">' + getTranslation( 'Uwaga' ) + '</font>',
            msg: warnMsg,
            buttons: {
                yes: getTranslation( 'Tak' ),
                no: getTranslation( 'Nie' )
            },
            fn: function( buttonId ) {
                if ( buttonId == 'yes' ) {
                	for ( var i = 0; i < records.length; i++ ) {
                		var record = records[i];
                		var varId = record.get( 'id' );
	                    removeRowAndMarkNext( grid, record );
	                    this.executeRemoveVariable( varId );
	                    grid.updateTitle();
                	}
                }
            },
            icon: Ext.Msg.QUESTION,
            scope: this
        } );
    },
    executeRemoveVariable: function( varId ) {
        var maskId = 'update_workflow_variable_mask';

        try {
            showLoadingMask( maskId, getTranslation( 'Trwa usuwanie zmiennej procesu...' ) );
            var variables = this.attributes.variables;

            for ( var i = 0; i < variables.length; i++ ) {
                if ( varId == variables[i].id ) {
                    variables.splice( i, 1 );
                    updateProcessTabTip();
                    Ext.getCmp( 'main_panel' ).setSaved( false );
                    break;
                }
            }

            for ( var i = 0; i < variables.length; i++ ) {
                var v = variables[i];

                if ( v.valuesList ) {
                    var valuesList = v.valuesList;
                    for ( var j = 0; j < valuesList.length; j++ ) {
                        if ( valuesList[j].value == '<' + varId + '>' ) {
                            valuesList.splice( j, 1 );
                            break;
                        }
                    }
                } else if ( v.formCriteria ) {
                    var formCriteria = v.formCriteria;
                    for ( var j = 0; j < formCriteria.length; j++ ) {
                        if ( formCriteria[j].varId == varId ) {
                            formCriteria.splice( j, 1 );
                            break;
                        }
                    }

                    var mappings = v.mappings;
                    for ( var j = 0; j < mappings.length; j++ ) {
                        if ( mappings[j].varId == varId ) {
                            mappings[j].varId = '';
                            break;
                        }
                    }
                }
            }

            this.removeVariableFromTables( varId );

            this.eachChild( function( activityNode ) {
                activityNode.clearFormVariablesByVarId( varId );
                activityNode.clearFormButtonsByVarId( varId );
                activityNode.clearApplicationsByVarId( varId );
                activityNode.removeDeadlinesByVarId( varId );
                activityNode.removeAcceptancesByVarId( varId );
                activityNode.changeSubflowParam( varId, '' );
                activityNode.clearAdditionalsByVarId( varId );
                activityNode.clearAssignmentByVarId( varId );
            } );

            Ext.ux.suncode.DocumentationService.deleteVariableSpecification( this, varId );
            Ext.ux.suncode.I18NService.onVariableRemove( this.attributes.processDefId, varId );
        }
        finally {
            removeLoadingMask( maskId );
        }
    },
    updateVariable: function( oldVarObj, varObj ) {
        var maskId = 'update_workflow_variable_mask';

        try {
            showLoadingMask( maskId, getTranslation( 'Trwa modyfikowanie zmiennej procesu...' ) );
            var oldVarId = oldVarObj.id;

            if ( oldVarObj.type == 'DATA_CHOOSER' && varObj.type != 'DATA_CHOOSER' ) {
                this.eachChild( function( activityNode ) {
                    activityNode.removeFormButtonDCValidationForVarId( oldVarId );
                } );
            }

            if ( oldVarObj.readonly != varObj.readonly ) {
                this.eachChild( function( activityNode ) {
                    activityNode.changeColumnInVariableSetEditability( oldVarId, varObj.readonly );
                } );
            }

            this.updateVariableById( oldVarId, varObj );
            Ext.getCmp( 'main_panel' ).setSaved( false );
        }
        finally {
            removeLoadingMask( maskId );
        }
    },
    updateVariableById: function( oldVarId, varObj ) {
        var variables = this.attributes.variables;

        for ( var i = 0; i < variables.length; i++ ) {
            if ( oldVarId == variables[i].id ) {
                if ( oldVarId != varObj.id ) {
                  for ( var j = 0; j < variables.length; j++ ) {
                    var v = variables[j];

                    if ( v.valuesList ) {
                      var valuesList = v.valuesList;
                      for ( var k = 0; k < valuesList.length; k++ ) {
                        if ( valuesList[k].value == '<' + oldVarId + '>' ) {
                          valuesList[k].value = '<' + varObj.id + '>';
                        }
                      }
                    } else if ( v.formCriteria ) {
                      var formCriteria = v.formCriteria;
                      for ( var k = 0; k < formCriteria.length; k++ ) {
                        if ( formCriteria[k].varId == oldVarId ) {
                          formCriteria[k].varId = varObj.id;
                        }
                      }

                      var mappings = v.mappings;
                      for ( var k = 0; k < mappings.length; k++ ) {
                        if ( mappings[k].varId == oldVarId ) {
                          mappings[k].varId = varObj.id;
                        }
                      }
                    }

                    if ( v.type == 'DATA_CHOOSER' && !Ext.isEmpty( v.definition ) && !Ext.isEmpty( v.definition.id ) ) {
                      Ext.ux.suncode.IntegrationComponentService.changeComponentByVariableId( v.definition, oldVarId, varObj.id );

                      Ext.iterate( v.definition.mappings, function( id, mapping, object ) {
                        if ( mapping.variable == oldVarId ) {
                          mapping.variable = varObj.id;
                        }
                      } );
                    }
                  }

                  this.changeTables( oldVarId, varObj.id );
                  this.changeTemplates( oldVarId, varObj.id );
                }

                this.eachChild( function( activityNode ) {
                    activityNode.changeAssignment( oldVarId, varObj.id );
                    activityNode.changeFormVariable( oldVarId, varObj );
                    activityNode.changeFormButton( oldVarId, varObj.id );
                    activityNode.changeFormAction( oldVarId, varObj.id );
                    activityNode.changeEventAction( oldVarId, varObj.id );
                    activityNode.changeApplicationParam( oldVarId, varObj.id );
                    activityNode.changeCondTransitionCondition( oldVarId, varObj.id );
                    activityNode.changeDeadline( oldVarId, varObj.id );
                    activityNode.changeAcceptance( oldVarId, varObj.id );
                    activityNode.changeSubflowParam( oldVarId, varObj.id );
                    activityNode.changeFormTemplateVariable( oldVarId, varObj );
                    activityNode.changeAdditionals( oldVarId, varObj.id );
                } );

                Ext.ux.suncode.DocumentationService.updateSpecificationDescriptionsForVarId( this, oldVarId, varObj.id );
                this.changeFormPreviewDataSet( oldVarId, varObj.id );

                variables[i] = varObj;
                break;
            }
        }
    },
    getVariableUtilization: function( variableId ) {
      var utilization = new Array();
      var processDefId = this.attributes.processDefId;
      var variables = this.attributes.variables;
      var variablesMaps = new HashMap();

      for ( var i = 0; i < variables.length; i++ ) {
        var v = variables[i];
        variablesMaps.put( v.id, v.name );

        if ( v.valuesList ) {
          var valuesList = v.valuesList;
          for ( var j = 0; j < valuesList.length; j++ ) {
            if ( valuesList[j].value == '<' + variableId + '>' ) {
              utilization.push( {
                processDefId: processDefId,
                objectOwner: getTranslation( 'Zmienna procesu' ) + ' (' + v.name +')',
                objectName: getTranslation( 'Wartość na liście' ),
                component: v
              } );
            }
          }
        } else if ( v.formCriteria ) {
          var formCriteria = v.formCriteria;
          for ( var j = 0; j < formCriteria.length; j++ ) {
            if ( formCriteria[j].varId == variableId ) {
              utilization.push( {
                processDefId: processDefId,
                objectOwner: getTranslation( 'Zmienna procesu' ) + ' (' + v.name +')',
                objectName: getTranslation( 'Kryterium formalne dynamicznej listy' ),
                component: v
              } );
            }
          }

          var mappings = v.mappings;
          for ( var j = 0; j < mappings.length; j++ ) {
            var mapping = mappings[j];
            if ( mapping.varId == variableId ) {
              utilization.push( {
                processDefId: processDefId,
                objectOwner: getTranslation( 'Zmienna procesu' ) + ' (' + v.name +')',
                objectName: getTranslation( 'Mapowanie wartości' ) + ' (' + mapping.display + ')',
                component: v
              } );
            }
          }
        }

        if ( v.type == 'DATA_CHOOSER' && !Ext.isEmpty( v.definition ) && !Ext.isEmpty( v.definition.id ) ) {
          Ext.iterate( v.definition.mappings, function( id, mapping, object ) {
            if ( mapping.variable == variableId ) {
              utilization.push( {
                processDefId: processDefId,
                objectOwner: getTranslation( 'Zmienna procesu' ) + ' (' + v.name +')',
                objectName: getTranslation( 'Mapowanie wartości' ) + ' (' + mapping.display + ')',
                component: v
              } );
            }
          } );
        }
      }

      var tables = this.attributes.tables;

      for ( var i = 0; i < tables.length; i++ ) {
        var table = tables[i];
        var columns = table.columns;
        var groupers = table.groupers;
        var sorters = table.sorters;

        for ( var j = 0; j < columns.length; j++ ) {
          var column = columns[j];

          if (column.varId == variableId) {
            utilization.push( {
              processDefId: processDefId,
              objectOwner: getTranslation( 'Tabela globalna' ) + ' (' + table.name +')',
              objectName: getTranslation( 'Kolumna' ),
              component: table
            } );
          }
        }

        for ( var j = 0; j < groupers.length; j++ ) {
          var grouper = groupers[j];

          if (grouper.columnId == variableId || grouper.groupNameColumnId == variableId) {
            utilization.push( {
              processDefId: processDefId,
              objectOwner: getTranslation( 'Tabela globalna' ) + ' (' + table.name +')',
              objectName: getTranslation( 'Grupowanie' ),
              component: table
            } );
          }

          if ( !Ext.isEmpty( grouper.aggregations ) ) {
            for (var k = 0; k < grouper.aggregations.length; k++) {
              var aggregation = grouper.aggregations[k];

              if (aggregation.columnId == variableId) {
                utilization.push({
                  processDefId: processDefId,
                  objectOwner: getTranslation('Tabela globalna') + ' (' + table.name + ')',
                  objectName: getTranslation( 'Agregacja w grupowaniu po zmiennej') + ' ' + variablesMaps.get(grouper.columnId),
                  component: table
                });
              }
            }
          }
        }

        for ( var j = 0; j < sorters.length; j++ ) {
          var sorter = sorters[j];

          if (sorter.columnId == variableId) {
            utilization.push( {
              processDefId: processDefId,
              objectOwner: getTranslation( 'Tabela globalna' ) + ' (' + table.name +')',
              objectName: getTranslation( 'Sortowanie' ),
              component: table
            } );
          }
        }
      }

      this.eachChild( function( activityNode ) {
        utilization = utilization.concat( activityNode.getVariableUtilization( processDefId, variablesMaps, variableId ) );
      } );

      return utilization;
    },
    moveVariable: function( sindex, dindex ) {
        changePlacementInTab( this.attributes.variables, sindex, dindex );
        Ext.getCmp( 'main_panel' ).setSaved( false );
    },
    validateTextareasInOneLine: function( varId ) {
      var result = {
        valid: true,
        errorMessage: ''
      };
      var activityNames = new Array();

      this.eachChild( function( activityNode ) {
        var valid = activityNode.validateTextareasInOneLine( varId );

        if ( !valid ) {
          activityNames.push( activityNode.attributes.activityName );
        }
      } );

      if ( !Ext.isEmpty( activityNames ) ) {
        var errorMessage = getTranslation( 'Dwa pola tekstowe będą występować koło siebie w następujących zadaniach' );
        errorMessage += ':';

        Ext.each( activityNames, function( activityName, index, allActivityNames ) {
          errorMessage += '<br>- ';
          errorMessage += activityName;
        }, this );

        result = Ext.apply( result, {
          valid: false,
          errorMessage: errorMessage
        } );
      }

      return result;
    },
    loadTables: function( tables ) {
      this.attributes.tables = tables ? tables : new Array();
    },
    findTable: function( tableId ) {
      var tables = this.attributes.tables;
      for ( var i = 0; i < tables.length; i++ ) {
        if ( tableId == tables[i].id ) {
          return tables[i];
        }
      }
      return null;
    },
    getLocalTableIds: function() {
      var localIds = new Array();
      var globalIds = new Array();

      var tables = this.attributes.tables;
      for ( var i = 0; i < tables.length; i++ ) {
        globalIds.push( tables[i].id );
      }

      this.eachChild( function( activityNode ) {
        var ids = activityNode.getAllVariableSetIds();

        Ext.each( ids, function( id, index, allIds ) {
          if ( globalIds.indexOf( id ) == -1 && localIds.indexOf( id ) == -1 ) {
            localIds.push( id );
          }
        } );
      }, this );

      return localIds;
    },
    addTable: function( tableObj ) {
      this.attributes.tables.push( tableObj );
      updateProcessTabTip();
      Ext.getCmp( 'main_panel' ).setSaved( false );
    },
    validateUpdateDtButton: function( globalId, dtButtonId ) {
      var result = {
        valid: true,
        errorMessage: ''
      };

      this.eachChild( function( activityNode ) {
        var activityResult = activityNode.validateUpdateDtButton( globalId, dtButtonId );

        if ( !activityResult.valid ) {
          var errorMessage = '';

          if ( !Ext.isEmpty( activityResult.duplicatedDtButton ) ) {
            var duplicatedDtButton = activityResult.duplicatedDtButton;
            errorMessage = getTranslation( 'Identyfikator przycisku został już użyty w zadaniu' );
            errorMessage += ' ';
            errorMessage += '<b>';
            errorMessage += activityNode.attributes.activityName;
            errorMessage += '</b>, ';
            errorMessage += getTranslation( 'Tabela dynamiczna' ).toLowerCase();
            errorMessage += ': <b>';
            errorMessage += duplicatedDtButton.tableName;
            errorMessage += '</b>.';
          }

          result = Ext.apply( result, {
            valid: false,
            errorMessage: errorMessage
          } );

          return false;
        }
      }, this );

      return result;
    },
    validateUpdateTable: function( tableId, columns ) {
      var result = {
        valid: true,
        errorMessage: ''
      };

      this.eachChild( function( activityNode ) {
        var activityResult = activityNode.validateChangeVariableSet( tableId, columns );

        if ( !activityResult.valid ) {
          var errorMessage = '';

          if ( !Ext.isEmpty( activityResult.duplicatedVariables ) ) {
            var activityName = activityNode.attributes.activityName;
            var activityDefId = activityNode.attributes.activityDefId;
            var processNode = activityNode.parentNode;
            var processDefId = processNode.attributes.processDefId
            var packageNode = processNode.parentNode;
            var packageId = packageNode.attributes.packageId
            var activityNameTranslation = getXpdlActivityNameTranslation( packageId, processDefId, activityDefId, activityName );
            errorMessage = getTranslation( 'Następujące zmienne zostały już użyte w zadaniu' );
            errorMessage += ' <b>';
            errorMessage += activityNameTranslation;
            errorMessage += '</b>:';

            Ext.each( activityResult.duplicatedVariables, function( duplicateVariable, index, duplicatedVariables ) {
              var variable = this.findVariable( duplicateVariable );

              errorMessage += '<br>- ';
              errorMessage += variable ? variable.name : duplicateVariable;
            }, this );
          }

          if ( !Ext.isEmpty( errorMessage ) ) {
            errorMessage += '<br><br>';
          }

          result = Ext.apply( result, {
            valid: false,
            errorMessage: errorMessage
          } );

          return false;
        }
      }, this );

      return result;
    },
    validateTableColumnsDuplication: function( columns ) {
      var result = {
        valid: true,
        errorMessage: ''
      };
      var duplicatedColumns = new Array();

      Ext.each( this.attributes.tables, function( table, tablesIndex, tables ) {
        Ext.each( table.columns, function( globalTableColumn, globalTableColumnsIndex, globalTableColumns ) {
          Ext.each( columns, function( column, columnsIndex, allColumns ) {
            if ( globalTableColumn.varId == column.varId ) {
              duplicatedColumns.push( {
                tableId: table.id,
                columnId: globalTableColumn.varId
              } );
            }
          } );
        } );
      } );

      if ( !Ext.isEmpty( duplicatedColumns ) ) {
        var errorMessage = getTranslation( 'Następujące kolumny zostały już wykorzystane w tabelach globalnych' );
        errorMessage += ':';

        Ext.each( duplicatedColumns, function( duplicatedColumn, index, allDuplicatedColumns ) {
          var columnId = duplicatedColumn.columnId;
          var variable = this.findVariable( columnId );

          errorMessage += '<br>- ';
          errorMessage += getTranslation( 'Tabela' ).toLowerCase();
          errorMessage += ' <b>';
          errorMessage += duplicatedColumn.tableId;
          errorMessage += '</b>, ';
          errorMessage += getTranslation( 'Kolumna' ).toLowerCase();
          errorMessage += ' <b>';
          errorMessage += variable ? variable.name : columnId;
          errorMessage += '</b>';
        }, this );

        result = Ext.apply( result, {
          valid: false,
          errorMessage: errorMessage
        } );
      }

      return result;
    },
    validateTableDtButtonsDuplication: function( excludedActivityDefId, dtButtons ) {
      var result = {
        valid: true,
        errorMessage: ''
      };
      var duplicatedDtButtons = new Array();

      Ext.each( this.attributes.tables, function( table, tablesIndex, tables ) {
        Ext.each( table.DTButtons, function( globalTableDtButton, globalTableDtButtonsIndex, globalTableDtButtons ) {
          Ext.each( dtButtons, function( dtButton, dtButtonsIndex, allDtButtons ) {
            if ( globalTableDtButton.buttonId == dtButton.buttonId ) {
              duplicatedDtButtons.push( {
                global: true,
                tableId: table.id,
                dtButtonId: globalTableDtButton.buttonId
              } );
            }
          } );
        } );
      } );

      this.eachChild( function( activityNode ) {
        if ( activityNode.attributes.activityDefId != excludedActivityDefId ) {
          duplicatedDtButtons = duplicatedDtButtons.concat( activityNode.validateTableDtButtonsDuplication( dtButtons ) );
        }
      } );

      if ( !Ext.isEmpty( duplicatedDtButtons ) ) {
        var errorMessage = getTranslation( 'Następujące przyciski zostały już wykorzystane' );
        errorMessage += ':';

        Ext.each( duplicatedDtButtons, function( duplicatedDtButton, index, allDuplicatedDtButtons ) {
          errorMessage += '<br>- ';
          errorMessage += duplicatedDtButton.global ? getTranslation( 'Tabela globalna' ) : getTranslation( 'Tabela lokalna' );
          errorMessage += ': <b>';
          errorMessage += duplicatedDtButton.tableId;
          errorMessage += '</b>, ';
          errorMessage += getTranslation( 'Przycisk' ).toLowerCase();
          errorMessage += ': <b>';
          errorMessage += duplicatedDtButton.dtButtonId;
          errorMessage += '</b>';
        }, this );

        result = Ext.apply( result, {
          valid: false,
          errorMessage: errorMessage
        } );
      }

      return result;
    },
    validateTableUniqueness: function( currentActivityId, tableId ) {
      var result = {
        valid: true,
        errorMessage: ''
      };

      this.eachChild( function( activityNode ) {
        if ( activityNode.attributes.activityDefId != currentActivityId ) {
          var activityResult = activityNode.validateTableUniqueness( tableId );

          if ( !activityResult.valid ) {
            var errorMessage = getTranslation( 'W zadaniu' );
            errorMessage += ' <b>';
            errorMessage += activityNode.attributes.activityName;
            errorMessage += '</b> ';
            errorMessage += getTranslation( 'występuje tabela o takim samym identyfikatorze.' );
            errorMessage += ' ';
            errorMessage += getTranslation( 'Jeśli chcesz przetransformować tą tabelę w tabelę globalną, zmień jej identyfikator.' );

            result = Ext.apply( result, {
              valid: false,
              errorMessage: errorMessage
            } );

            return false;
          }
        }
      }, this );

      return result;
    },
    updateTable: function( oldTableId, tableObj ) {
      var tables = this.attributes.tables;
      for ( var i = 0; i < tables.length; i++ ) {
        if ( oldTableId == tables[i].id ) {
          tables[i] = tableObj;
          Ext.getCmp( 'main_panel' ).setSaved( false );
          break;
        }
      }

      this.eachChild( function( activityNode ) {
        activityNode.changeVariableSet( oldTableId, tableObj );
        activityNode.changeFormTemplateVariableSet( oldTableId, tableObj.id );
      } );
    },
    removeTable: function( record, grid ) {
      Ext.Msg.show( {
        title: '<font weight="bold">' + getTranslation( 'Uwaga' ) + '</font>',
        msg: getTranslation( 'Usunąć tabelę?' ),
        buttons: {
          yes: getTranslation( 'Tak' ),
          no: getTranslation( 'Nie' )
        },
        fn: function( buttonId ) {
          if ( buttonId == 'yes' ) {
            var tableId = record.get( 'id' );
            removeRowAndMarkNext( grid, record );
            this.executeRemoveTable( tableId );
            grid.updateTitle();
          }
        },
        icon: Ext.Msg.QUESTION,
        scope: this
      } );
    },
    executeRemoveTable: function( tableId ) {
      var table = this.findTable( tableId );
      var tables = this.attributes.tables;

      for ( var i = 0; i < tables.length; i++ ) {
        if ( tableId == tables[i].id ) {
          tables.splice( i, 1 );
          updateProcessTabTip();
          Ext.getCmp( 'main_panel' ).setSaved( false );
          break;
        }
      }

      var processDefId = this.attributes.processDefId;

      this.eachChild( function( activityNode ) {
        var activityDefId = activityNode.attributes.activityDefId;
        activityNode.clearFormVariableSetsByTableId( tableId );
        Ext.ux.suncode.I18NService.onVariableSetRemove( processDefId, activityDefId, tableId );
        Ext.ux.suncode.DocumentationService.deleteFormVariableSpecification( activityNode, tableId );
      } );

      if ( !Ext.isEmpty( table ) && !Ext.isEmpty( table.DTButtons )  ) {
        Ext.each( table.DTButtons, function( dtButton, index, dtButtons ) {
          Ext.ux.suncode.DocumentationService.deleteTableButtonSpecification( this, dtButton.buttonId );
        }, this );
      }

      Ext.ux.suncode.DocumentationService.deleteTableSpecification( this, tableId );
    },
    moveTable: function( sindex, dindex ) {
      changePlacementInTab( this.attributes.tables, sindex, dindex );
      Ext.getCmp( 'main_panel' ).setSaved( false );
    },
    changeTables: function( oldVarId, newVarId ) {
      var tables = this.attributes.tables;
      for ( var i = 0; i < tables.length; i++ ) {
        var table = tables[i];
        var columns = table.columns;
        var dtButtons = table.DTButtons;
        var groupers = table.groupers;
        var sorters = table.sorters;

        for ( var j = 0; j < columns.length; j++ ) {
          var column = columns[j];

          if ( column.varId == oldVarId ) {
            column.varId = newVarId;
            break;
          }
        }

        var tableFormActions = table.formActions;
        var tableEventActions = table.eventActions;

        if ( !Ext.isEmpty( tableFormActions ) ) {
          Ext.ux.suncode.IntegrationComponentService.changeByVariableId( tableFormActions, oldVarId, newVarId );
        }
        if ( !Ext.isEmpty( tableEventActions ) ) {
          Ext.ux.suncode.IntegrationComponentService.changeByVariableId( tableEventActions, oldVarId, newVarId );
        }

        for ( var j = 0; j < dtButtons.length; j++ ) {
          var dtButton = dtButtons[j];
          var dtButtonFormActions = dtButton.formActions;
          var dtButtonEventActions = dtButton.eventActions;

          if ( !Ext.isEmpty( dtButtonFormActions ) ) {
            Ext.ux.suncode.IntegrationComponentService.changeByVariableId( dtButtonFormActions, oldVarId, newVarId );
          }
          if ( !Ext.isEmpty( dtButtonEventActions ) ) {
            Ext.ux.suncode.IntegrationComponentService.changeByVariableId( dtButtonEventActions, oldVarId, newVarId );
          }
        }

        for ( var j = 0; j < groupers.length; j++ ) {
          var grouper = groupers[j];

          if ( grouper.columnId == oldVarId ) {
            grouper.columnId = newVarId;
          }

          if ( grouper.groupNameColumnId == oldVarId ) {
            grouper.groupNameColumnId = newVarId;
          }

          if ( !Ext.isEmpty( grouper.aggregations ) ) {
            var aggregations = grouper.aggregations;
            for ( var k = 0; k < aggregations.length; k++ ) {
              var aggregation = aggregations[k];
              if ( aggregation.columnId == oldVarId ) {
                aggregation.columnId = newVarId;
                break;
              }
            }
          }
        }

        for ( var j = 0; j < sorters.length; j++ ) {
          var sorter = sorters[j];

          if ( sorter.columnId == oldVarId ) {
            sorter.columnId = newVarId;
            break;
          }
        }
      }
    },
    removeVariableFromTables: function( variableId ) {
      var tables = this.attributes.tables;
      for ( var i = 0; i < tables.length; i++ ) {
        var table = tables[i];
        var columns = table.columns;

        for ( var j = 0; j < columns.length; j++ ) {
          var column = columns[j];

          if ( column.varId == variableId ) {
            columns.splice( j, 1 );
            break;
          }
        }
      }
    },
    validateTableButtonIdDuplication: function( buttonId, globalId ) {
      var tables = this.attributes.tables;
      for ( var i = 0; i < tables.length; i++ ) {
        var table = tables[i];
        var dtButtons = table.DTButtons;

        for ( var j = 0; j < dtButtons.length; j++ ) {
          var dtButton = dtButtons[j];

          if ( dtButton.buttonId == buttonId && ( Ext.isEmpty( globalId ) || dtButton.globalId !== globalId ) ) {
            return false;
          }
        }
      }

      return true;
    },
    updateVariableFormAction: function( variableId, formActionGlobalId, formActionUpdate ) {
      var variables = this.attributes.variables;
      for ( var i = 0; i < variables.length; i++ ) {
        var variable = variables[i];

        if ( variable.id == variableId ) {
          Ext.each( variable.formActions, function( formAction, index, formActions ) {
            if ( formAction.globalId == formActionGlobalId ) {
              Ext.apply( formAction, deepObjectCopy( formActionUpdate ) );

              this.eachChild( function( activityNode ) {
                activityNode.changeFormObjectFormAction( variableId, formActionGlobalId, formActionUpdate );
              } );
            }
          }, this );
        }
      }
    },
    updateVariableEventAction: function( variableId, eventActionGlobalId, eventActionUpdate ) {
      var variables = this.attributes.variables;
      for ( var i = 0; i < variables.length; i++ ) {
        var variable = variables[i];

        if ( variable.id == variableId ) {
          Ext.each( variable.eventActions, function( eventAction, index, eventActions ) {
            if ( eventAction.globalId == eventActionGlobalId ) {
              Ext.apply( eventAction, deepObjectCopy( eventActionUpdate ) );

              this.eachChild( function( activityNode ) {
                activityNode.changeFormObjectEventAction( variableId, eventActionGlobalId, eventActionUpdate );
              } );
            }
          }, this );
        }
      }
    },
    updateTableFormAction: function( tableId, formActionGlobalId, formActionUpdate ) {
      var tables = this.attributes.tables;
      for ( var i = 0; i < tables.length; i++ ) {
        var table = tables[i];

        if ( table.id == tableId ) {
          Ext.each( table.formActions, function( formAction, index, formActions ) {
            if ( formAction.globalId == formActionGlobalId ) {
              Ext.apply( formAction, deepObjectCopy( formActionUpdate ) );

              this.eachChild( function( activityNode ) {
                activityNode.changeFormObjectFormAction( tableId, formActionGlobalId, formActionUpdate );
              } );
            }
          }, this );
        }
      }
    },
    updateTableEventAction: function( tableId, eventActionGlobalId, eventActionUpdate ) {
      var tables = this.attributes.tables;
      for ( var i = 0; i < tables.length; i++ ) {
        var table = tables[i];

        if ( table.id == tableId ) {
          Ext.each( table.eventActions, function( eventAction, index, eventActions ) {
            if ( eventAction.globalId == eventActionGlobalId ) {
              Ext.apply( eventAction, deepObjectCopy( eventActionUpdate ) );

              this.eachChild( function( activityNode ) {
                activityNode.changeFormObjectEventAction( tableId, eventActionGlobalId, eventActionUpdate );
              } );
            }
          }, this );
        }
      }
    },
    loadLabels: function( labels ) {
        this.attributes.labels = labels ? labels : new Array();
    },
    findLabel: function( labelId ) {
        var labels = this.attributes.labels;
        for ( var i = 0; i < labels.length; i++ ) {
            if ( labelId == labels[i].id ) {
                return labels[i];
            }
        }
        return null;
    },
    addLabel: function( labelObj ) {
        this.attributes.labels.push( labelObj );
        updateProcessTabTip();
        Ext.getCmp( 'main_panel' ).setSaved( false );
    },
    copyLabel: function( labelId ) {
    	var label = this.findLabel( labelId );
        var labelCopy = deepObjectCopy( label );
        var counter = 2;
        var labelCopyId = label.id + '_' + counter;
        var labelCopyName = label.name + ' ' + getTranslation( 'Kopia' );

        while ( this.findLabel( labelCopyId ) ) {
            counter++;
            labelCopyId = label.id + '_' + counter;
        }

        Ext.apply( labelCopy, {
        	id: labelCopyId,
        	name: labelCopyName
        } );

        this.addLabel( labelCopy );
        
        return labelCopy;
    },
    updateLabel: function( oldLabelId, labelObj ) {
        var labels = this.attributes.labels;
        for ( var i = 0; i < labels.length; i++ ) {
            if ( oldLabelId == labels[i].id ) {
            	labels[i] = labelObj;
                Ext.getCmp( 'main_panel' ).setSaved( false );
                break;
            }
        }
        
        this.eachChild( function( activityNode ) {
            activityNode.updateFormLabelsByLabelId( oldLabelId, labelObj );
        } );
    },
    removeLabel: function( record, grid ) {
    	removeRowAndMarkNext( grid, record );
        grid.updateTitle();
    	var labelId = record.get( 'id' );
    	var labels = this.attributes.labels;

        for ( var i = 0; i < labels.length; i++ ) {
            if ( labelId == labels[i].id ) {
            	labels.splice( i, 1 );
                updateProcessTabTip();
                Ext.getCmp( 'main_panel' ).setSaved( false );
                break;
            }
        }

        this.eachChild( function( activityNode ) {
            activityNode.clearFormLabelsByLabelId( labelId );
        } );

        Ext.ux.suncode.I18NService.onLabelRemove( this.attributes.processDefId, labelId );
    },
    moveLabel: function( sindex, dindex ) {
        changePlacementInTab( this.attributes.labels, sindex, dindex );
        Ext.getCmp( 'main_panel' ).setSaved( false );
    },
    updateLabelFormAction: function( labelId, formActionGlobalId, formActionUpdate ) {
      var labels = this.attributes.labels;
      for ( var i = 0; i < labels.length; i++ ) {
        var label = labels[i];

        if ( label.id == labelId ) {
          Ext.each( label.formActions, function( formAction, index, formActions ) {
            if ( formAction.globalId == formActionGlobalId ) {
              Ext.apply( formAction, deepObjectCopy( formActionUpdate ) );

              this.eachChild( function( activityNode ) {
                activityNode.changeLabelFormAction( labelId, formActionGlobalId, formActionUpdate );
              } );
            }
          }, this );
        }
      }
    },
    findApplication: function( appId ) {
        var applications = this.attributes.applications;
        for ( var i = 0; i < applications.length; i++ ) {
            if ( appId == applications[i].id ) {
                return applications[i];
            }
        }
        return null;
    },
    addApplication: function( appObj ) {
        this.attributes.applications.push( appObj );
        updateProcessTabTip();
        Ext.getCmp( 'main_panel' ).setSaved( false );
    },
    loadApplications: function( apps ) {
        this.attributes.applications = apps ? apps : new Array();
    },
    removeApplication: function( appId ) {
        var applications = this.attributes.applications;
        for ( var i = 0; i < applications.length; i++ ) {
            if ( appId == applications[i].id ) {
                applications.splice( i, 1 );
                updateProcessTabTip();
                Ext.getCmp( 'main_panel' ).setSaved( false );
                break;
            }
        }

        this.eachChild( function( activityNode ) {
            activityNode.removeApplication( appId );
        } );

        Ext.ux.suncode.DocumentationService.deleteApplicationSpecification( this, appId );
    },
    updateApplication: function( oldAppId, appObj ) {
        var applications = this.attributes.applications;
        for ( var i = 0; i < applications.length; i++ ) {
            if ( oldAppId == applications[i].id ) {
                applications[i] = appObj;
                this.updateApplicationDefinitionForActivities( oldAppId, appObj );
                Ext.getCmp( 'main_panel' ).setSaved( false );
                break;
            }
        }
    },
    updateApplicationDescription: function( appId, descrption ) {
    	var applications = this.attributes.applications;
        for ( var i = 0; i < applications.length; i++ ) {
            if ( appId == applications[i].id ) {
                applications[i].descr = descrption;
                Ext.getCmp( 'main_panel' ).setSaved( false );
                break;
            }
        }
    },
    updateApplicationDefinitionForActivities: function( oldAppId, appObj ) {
        this.eachChild( function( activityNode ) {
            activityNode.updateApplicationDefinition( oldAppId, appObj );
        } );
    },
    updateActivitiesPerformer: function( oldRoleId, newRoleId, newRoleName ) {
        this.eachChild( function( activityNode ) {
            if ( activityNode.attributes.roleId == oldRoleId ) {
                activityNode.updateActivityPerformer( newRoleId, newRoleName );
            }
        } );
    },
    addOrUpdateVariableInAllActivities: function( varDef, itemDef, location, specification, currentActivityDefId ) {
    	var packageId = this.parentNode.attributes.packageId;
    	var processDefId = this.attributes.processDefId;
    	var varId = varDef.varId;
    	var isVariableSet = varDef.genre == 'VARIABLE_SET';
    	var translations = null;
    	
    	if ( isVariableSet ) {
    		var translationKey = 'PACK(' + packageId + ')_PROC(' + processDefId + ')_ACTIVITY(' + currentActivityDefId
    			+ ')_VARIABLESET(' + varId + ')';
    		translations = Ext.ux.suncode.I18NService.getPackageTranslations( translationKey );
    	}
    	
        this.eachChild( function( activityNode ) {
          if ( activityNode.attributes.activityType != Ext.ux.suncode.Constants.ROUTE ) {
            var varDefCopy = Ext.apply( new Object(), varDef );
            var itemDefCopy = Ext.apply( new Object(), itemDef );

            if ( activityNode.getFormVariable( varId ) ) {
              activityNode.updateVariable( varId, varDefCopy, itemDefCopy );
              Ext.ux.suncode.DocumentationService.editFormVariableSpecification( activityNode, varId, varId, specification );
            } else {
              activityNode.addVariable( varDefCopy, itemDefCopy, location );
              Ext.ux.suncode.DocumentationService.addFormVariableSpecification( activityNode, varId, specification );
            }

            if ( isVariableSet && !Ext.isEmpty( translations ) ) {
              var activityDefId = activityNode.attributes.activityDefId;
              var translationKey = 'PACK(' + packageId + ')_PROC(' + processDefId + ')_ACTIVITY(' + activityDefId
                  + ')_VARIABLESET(' + varId + ')';
              Ext.ux.suncode.I18NService.savePackageTranslations( translationKey, translations );
            }
          }
        } );
    },
    addStart: function( start ) {
        this.attributes.starts.push( start );
        Ext.getCmp( 'main_panel' ).setSaved( false );
    },
    setStartLocation: function( terminationId, roleId, x, y ) {
        var starts = this.attributes.starts;
        for ( var i = 0; i < starts.length; i++ ) {
            var start = starts[i];
            if ( terminationId == start.terminationId ) {
                start.roleId = roleId;
                start.xOffset = x;
                start.yOffset = y;
                break;
            }
        }
    },
    setStartConnectingActivity: function( terminationId, activityDefId ) {
        var starts = this.attributes.starts;
        for ( var i = 0; i < starts.length; i++ ) {
            if ( terminationId == starts[i].terminationId ) {
                starts[i].connectingActivity = activityDefId;
                Ext.getCmp( 'main_panel' ).setSaved( false );
                break;
            }
        }
    },
    isStartConnected: function( terminationId ) {
        var starts = this.attributes.starts;
        for ( var i = 0; i < starts.length; i++ ) {
            if ( terminationId == starts[i].terminationId ) {
                if ( !Ext.isEmpty( starts[i].connectingActivity ) ) {
                    return true;
                }
                break;
            }
        }
        return false;
    },
    removeStart: function( terminationId ) {
        var starts = this.attributes.starts;
        for ( var i = 0; i < starts.length; i++ ) {
            if ( terminationId == starts[i].terminationId ) {
                starts.splice( i, 1 );
                Ext.getCmp( 'main_panel' ).setSaved( false );
                break;
            }
        }
    },
    addStop: function( stop ) {
        this.attributes.stops.push( stop );
        Ext.getCmp( 'main_panel' ).setSaved( false );
    },
    setStopLocation: function( terminationId, roleId, x, y ) {
        var stops = this.attributes.stops;
        for ( var i = 0; i < stops.length; i++ ) {
            var stop = stops[i];
            if ( terminationId == stop.terminationId ) {
                stop.roleId = roleId;
                stop.xOffset = x;
                stop.yOffset = y;
                break;
            }
        }
    },
    setStopConnectingActivity: function( terminationId, activityDefId ) {
        var stops = this.attributes.stops;
        for ( var i = 0; i < stops.length; i++ ) {
            if ( terminationId == stops[i].terminationId ) {
                stops[i].connectingActivity = activityDefId;
                Ext.getCmp( 'main_panel' ).setSaved( false );
                break;
            }
        }
    },
    isStopConnected: function( terminationId ) {
        var stops = this.attributes.stops;
        for ( var i = 0; i < stops.length; i++ ) {
            if ( terminationId == stops[i].terminationId ) {
                if ( !Ext.isEmpty( stops[i].connectingActivity ) ) {
                    return true;
                }
                break;
            }
        }
        return false;
    },
    removeStop: function( terminationId ) {
        var stops = this.attributes.stops;
        for ( var i = 0; i < stops.length; i++ ) {
            if ( terminationId == stops[i].terminationId ) {
                stops.splice( i, 1 );
                Ext.getCmp( 'main_panel' ).setSaved( false );
                break;
            }
        }
    },
    updateStartStopRoleId: function( oldRoleId, newRoleId ) {
        var starts = this.attributes.starts;
        for ( var i = 0; i < starts.length; i++ ) {
            var start = starts[i];
            if ( oldRoleId == start.roleId ) {
                start.roleId = newRoleId;
            }
        }

        var stops = this.attributes.stops;
        for ( var i = 0; i < stops.length; i++ ) {
            var stop = stops[i];
            if ( oldRoleId == stop.roleId ) {
                stop.roleId = newRoleId;
            }
        }
    },
    anyStartConnectedToActivity: function( activityDefId ) {
        var starts = this.attributes.starts;
        for ( var i = 0; i < starts.length; i++ ) {
            var start = starts[i];
            if ( activityDefId == start.connectingActivity ) {
                return true;
            }
        }

        return false;
    },
    updateAllNextActivities: function( oldActivityDefId, newActivityDefId ) {
        this.eachChild( function( activityNode ) {
            activityNode.updateNextActivity( oldActivityDefId, newActivityDefId );
        } );
    },
    removeAllNextActivitiesById: function( activityDefId ) {
        this.eachChild( function( activityNode ) {
            activityNode.removeNextActivityById( activityDefId );
        } );
    },
    changeTemplates: function( oldVarId, newVarId ) {
    	this.changeValidatorsTemplates( oldVarId, newVarId );
    	this.changeVariablesSettersTemplates( oldVarId, newVarId );
    },
    findTemplate: function( templates, templateId ) {
        for ( var i = 0; i < templates.length; i++ ) {
            if ( templateId == templates[i].id ) {
                return templates[i];
            }
        }
        return null;
    },
    findTemplateComponent: function( templates, templateId, templateComponentId ) {
    	var template = this.findTemplate( templates, templateId );
    	if ( !Ext.isEmpty( template ) ) {
    		var components = template.components;
    		for ( var i = 0; i < components.length; i++ ) {
                if ( templateComponentId == components[i].templateComponentId ) {
                    return components[i];
                }
            }
    	}
    	return null;
    },
    updateTemplate: function( templates, templateId, template ) {
        for ( var i = 0; i < templates.length; i++ ) {
            if ( templateId == templates[i].id ) {
                templates[i] = template;
                Ext.getCmp( 'main_panel' ).setSaved( false );
                break;
            }
        }
    },
    removeTemplate: function( templates, templateId ) {
        for ( var i = 0; i < templates.length; i++ ) {
            if ( templateId == templates[i].id ) {
            	templates.splice( i, 1 );
                Ext.getCmp( 'main_panel' ).setSaved( false );
                break;
            }
        }
    },
    changeTemplatesComponents: function( templates, oldVarId, newVarId ) {
        for ( var i = 0; i < templates.length; i++ ) {
            var template = templates[i];
            var components = template.components;
            Ext.ux.suncode.IntegrationComponentService.changeByVariableId( components, oldVarId, newVarId );
        }
    },
    loadValidatorsTemplates: function( templates ) {
    	this.attributes.templates.validators = templates ? templates : new Array();
    },
    getValidatorsTemplates: function() {
    	return this.attributes.templates.validators;
    },
    findValidatorsTemplate: function( templateId ) {
        return this.findTemplate( this.attributes.templates.validators, templateId );
    },
    findValidatorsTemplateComponent: function( templateId, templateComponentId ) {
    	return this.findTemplateComponent( this.attributes.templates.validators, templateId, templateComponentId );
    },
    addValidatorsTemplate: function( template ) {
    	this.attributes.templates.validators.push( template );
        Ext.getCmp( 'main_panel' ).setSaved( false );
    },
    updateValidatorsTemplate: function( templateId, template ) {
    	this.updateTemplate( this.attributes.templates.validators, templateId, template );
    },
    removeValidatorsTemplate: function( templateId ) {
    	this.removeTemplate( this.attributes.templates.validators, templateId );
    	this.eachChild( function( activityNode ) {
            activityNode.removeValidatorsTemplate( templateId );
        } );
    },
    changeValidatorsTemplates: function( oldVarId, newVarId ) {
    	this.changeTemplatesComponents( this.attributes.templates.validators, oldVarId, newVarId );
    },
    findValidatorsTemplateUtilization: function( templateId ) {
    	var utilization = new Array();
    	
    	this.eachChild( function( activityNode ) {
    		var activityUtilization = activityNode.findValidatorsTemplateUtilization( templateId );
    		utilization = utilization.concat( activityUtilization );
        } );
    	
    	return utilization;
    },
    loadVariablesSettersTemplates: function( templates ) {
    	this.attributes.templates.variablesSetters = templates ? templates : new Array();
    },
    getVariablesSettersTemplates: function() {
    	return this.attributes.templates.variablesSetters;
    },
    findVariablesSettersTemplate: function( templateId ) {
        return this.findTemplate( this.attributes.templates.variablesSetters, templateId );
    },
    findVariablesSettersTemplateComponent: function( templateId, templateComponentId ) {
    	return this.findTemplateComponent( this.attributes.templates.variablesSetters, templateId, templateComponentId );
    },
    addVariablesSettersTemplate: function( template ) {
    	this.attributes.templates.variablesSetters.push( template );
        Ext.getCmp( 'main_panel' ).setSaved( false );
    },
    updateVariablesSettersTemplate: function( templateId, template ) {
    	this.updateTemplate( this.attributes.templates.variablesSetters, templateId, template );
    },
    removeVariablesSettersTemplate: function( templateId ) {
    	this.removeTemplate( this.attributes.templates.variablesSetters, templateId );
    	this.eachChild( function( activityNode ) {
            activityNode.removeVariablesSettersTemplate( templateId );
        } );
    },
    changeVariablesSettersTemplates: function( oldVarId, newVarId ) {
    	this.changeTemplatesComponents( this.attributes.templates.variablesSetters, oldVarId, newVarId );
    },
    findVariablesSettersTemplateUtilization: function( templateId ) {
    	var utilization = new Array();
    	
    	this.eachChild( function( activityNode ) {
    		var activityUtilization = activityNode.findVariablesSettersTemplateUtilization( templateId );
    		utilization = utilization.concat( activityUtilization );
        } );
    	
    	return utilization;
    },
    loadFormPreviewDataSets: function( dataSets ) {
    	this.attributes.formPreview.dataSets = dataSets ? dataSets : new Array();
    },
    findFormPreviewDataSet: function( name ) {
    	var dataSets = this.attributes.formPreview.dataSets;
        for ( var i = 0; i < dataSets.length; i++ ) {
            if ( name == dataSets[i].name ) {
                return dataSets[i];
            }
        }
        return null;
    },
    addFormPreviewDataSet: function( dataSet ) {
    	this.attributes.formPreview.dataSets.push( dataSet );
        Ext.getCmp( 'main_panel' ).setSaved( false );
    },
    removeFormPreviewDataSet: function( name ) {
    	var dataSets = this.attributes.formPreview.dataSets;
    	for ( var i = 0; i < dataSets.length; i++ ) {
            if ( name == dataSets[i].name ) {
            	dataSets.splice( i, 1 );
                Ext.getCmp( 'main_panel' ).setSaved( false );
                break;
            }
        }
    },
    updateFormPreviewDataSet: function( oldName, dataSet ) {
    	var dataSets = this.attributes.formPreview.dataSets;
    	for ( var i = 0; i < dataSets.length; i++ ) {
            if ( oldName == dataSets[i].name ) {
            	dataSets[i] = dataSet;
                Ext.getCmp( 'main_panel' ).setSaved( false );
            }
        }
    },
    setAsDefaultFormPreviewDataSet: function( name ) {
    	var dataSets = this.attributes.formPreview.dataSets;
    	for ( var i = 0; i < dataSets.length; i++ ) {
    		var dataSet = dataSets[i];
            if ( name == dataSet.name ) {
            	dataSet.isDefault = !dataSet.isDefault;
            	Ext.getCmp( 'main_panel' ).setSaved( false );
            } else if ( dataSet.isDefault ) {
            	dataSet.isDefault = false;
            }
        }
    },
    resetDefaultFormPreviewDataSet: function() {
    	var dataSets = this.attributes.formPreview.dataSets;
    	for ( var i = 0; i < dataSets.length; i++ ) {
    		var dataSet = dataSets[i];
    		if ( dataSet.isDefault ) {
            	dataSet.isDefault = false;
            }
        }
    },
    getDefaultFormPreviewDataSet: function() {
    	var dataSets = this.attributes.formPreview.dataSets;
        for ( var i = 0; i < dataSets.length; i++ ) {
            if ( dataSets[i].isDefault ) {
                return dataSets[i];
            }
        }
        return null;
    },
    changeFormPreviewDataSet: function( oldVarId, newVarId ) {
    	var dataSets = this.attributes.formPreview.dataSets;
        for ( var i = 0; i < dataSets.length; i++ ) {
        	var dataSet = dataSets[i];
            if ( !Ext.isEmpty( dataSet.variablesValues ) ) {
            	Ext.iterate( dataSet.variablesValues, function( id, value, object ) {
                    if ( id == oldVarId ) {
                        delete object[id];
                        object[newVarId] = value;
                        return false;
                    }
                } );
            }
        }
    },
    loadGlobalSettings: function( globalSettings ) {
    	this.attributes.globalSettings = Ext.apply( this.attributes.globalSettings, globalSettings );
    },
    restoreFormsDefaultLook: function() {
      if ( this.hasChildNodes() ) {
        this.eachChild( function( activityNode ) {
          activityNode.restoreFormDefaultLook();
        } );
      }
    },
    validateVariableAgainstButtons: function( previousVariableId, newVariableId ) {
      var result = {
        valid: true
      };

      this.eachChild( function( activityNode ) {
        result = activityNode.validateVariableAgainstButtons( previousVariableId, newVariableId );

        if ( !result.valid ) {
          result = Ext.apply( result, {
            activityName: activityNode.attributes.activityName
          } );
          return false;
        }
      } );

      return result;
    }
} );

Ext.ux.suncode.ActivityNode = function( config ) {
    var activityDefId = config.activityDefId;

    config = Ext.apply( {
        text: this.getNodeText( config.processDefId, activityDefId, config.activityName ),
        icon: config.iconImg,
        leaf: true,
        activityDefId: activityDefId,
        activityName: config.activityName,
        activityDescr: '',
        idChanged: false,
        xOffset: config.xOffset,
        yOffset: config.yOffset,
        assignment: new Object( {
            type: 'role',
            value: '',
            filters: new Array(),
            exception: ''
        } ),
        nextActivity: false,
        acceptedNextActivities: new Array(),
        acceptConcurrently: true,
        acceptSequentially: false,
        newDocumentAccept: false,
        allowMultipleActiveActivities: false,
        deadlines: new Array(),
        acceptances: new Array(),
        activityType: config.activityType,
        activityPerformer: config.roleName,
        roleId: config.roleId,
        form: {
            template: {
                rows: new Array()
            },
            variables: new Array(),
            httpLinks: new Array(),
            buttons: new Array(),
            labelActions: new Array(),
            actions: new Array(),
            events: new Array()
        },
        formStyles: {
            showLines: null
        },
        formSettings: {
            showProcessAndActivityNames: true,
            showComments: true,
            documentsViewLocation: 'right',
            hideSaveButton: false
        },
        applications: new Array(),
        transitions: {
            basic: new Array(),
            cond: new Array(),
            otherwise: new Array(),
            exception: new Array(),
            incoming: 0
        },
        additionals: {
            defaults: new Array(),
            checkAppendices: new Array(),
            additionalJsChecks: new Array(),
            extraDataChooserConfigs: new Array()
        },
        transitionRestriction: {
            join: 'XOR',
            split: 'XOR'
        },
        subflow: {
            id: '',
            params: new Array()
        },
        specification: Ext.ux.suncode.DocumentationService.initActivitySpecification(),
        templates: {
        	validators: new Array(),
        	variablesSetters: new Array()
        },
        xpdlSubstitution: null,
        listeners: {
            scope: this,
            contextmenu: function( node, e ) {
                e.stopEvent();
                node.fireEvent( 'click', node, e );
                this.showContextMenu( e.getXY() );
            },
            dblclick: function( node, e ) {
                showActivityProperties( {
                  activityNode: node
                } );
            },
            click: function( node, e ) {
                var processNode = node.parentNode;
                processNode.fireEvent( 'click', processNode, e );

                var actDefId = node.attributes.activityDefId;
                var processPanel = Ext.getCmp( 'paper_panel' ).getActiveTab();
                var paper = processPanel.paper;
                paper.bpmn.eraseTrash( paper.hoverTrash );

                var set = paper.bpmn.findMapObjectElements( paper, 'activityDefId', actDefId );
                set.toFront();

                var connector = paper.bpmn.getConnectorFromSet( set );
                var color = Ext.getCmp( 'main_panel' ).getHoverColor();
                var frame = paper.bpmn.highlightTask( paper, connector, color );
                paper.hoverTrash.push( frame );

                var box = connector.getBBox();
                scrollToProcessObject( processPanel, box );
            }
        }
    } );

    Ext.ux.suncode.ActivityNode.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.ActivityNode, Ext.tree.TreeNode, {
    initComponent: function() {
        Ext.ux.suncode.ActivityNode.superclass.initComponent.call( this );
    },
    getNodeText: function( processDefId, activityDefId, activityName ) {
      var packageNode = Ext.getCmp( 'package_panel' ).getRootNode();
      var packageId = packageNode.attributes.packageId;
      var activityNameTranslation = getXpdlActivityNameTranslation( packageId, processDefId, activityDefId, activityName );

      return Ext.util.Format.htmlEncode( activityNameTranslation );
    },
    showContextMenu: function( pos ) {
        var mainPanel = Ext.getCmp( 'main_panel' );
        var activityType = this.attributes.activityType;
        var items = new Array();
        var copyMenuText = '';
        var deleteMenuText = '';

        switch ( activityType ) {
            case Ext.ux.suncode.Constants.ROUTE:
                copyMenuText = getTranslation( 'Kopiuj przekierowanie' );
                deleteMenuText = getTranslation( 'Usuń przekierowanie' );
                break;
            case Ext.ux.suncode.Constants.ACTIVITY:
                copyMenuText = getTranslation( 'Kopiuj zadanie' );
                deleteMenuText = getTranslation( 'Usuń zadanie' );
                break;
            case Ext.ux.suncode.Constants.TOOL:
                copyMenuText = getTranslation( 'Kopiuj narzędzie' );
                deleteMenuText = getTranslation( 'Usuń narzędzie' );
                break;
            case Ext.ux.suncode.Constants.SUBFLOW:
                copyMenuText = getTranslation( 'Kopiuj podproces' );
                deleteMenuText = getTranslation( 'Usuń podproces' );
                break;
            default:
                break;
        }

        if ( activityType == Ext.ux.suncode.Constants.ROUTE
            || activityType == Ext.ux.suncode.Constants.ACTIVITY
            || activityType == Ext.ux.suncode.Constants.TOOL ) {
          items.push( new Ext.menu.Item( {
            cls: 'x-btn-text-icon',
            icon: getPluginImgPath( 'copy' ),
            text: copyMenuText,
            scope: this,
            handler: function() {
              copyActivity( this );
            }
          } ) );
        }

        items.push( new Ext.menu.Item( {
            cls: 'x-btn-text-icon',
            icon: getPluginImgPath( 'delete' ),
            text: deleteMenuText,
            scope: this,
            handler: function() {
                deleteActivity( this );
            }
        } ) );
        items.push( new Ext.menu.Item( {
          cls: 'x-btn-text-icon',
          icon: getPluginImgPath( 'mark_path' ),
          text: getTranslation( 'Zaznacz połączenia' ),
          menu: new Ext.menu.Menu( {
            items: [ new Ext.menu.Item( {
              cls: 'x-btn-text-icon',
              icon: getPluginImgPath( 'incoming' ),
              text: getTranslation( 'Wchodzące' ),
              scope: this,
              handler: function() {
                markActivityIncomingTransitions( this );
              }
            } ), new Ext.menu.Item( {
              cls: 'x-btn-text-icon',
              icon: getPluginImgPath( 'outgoing' ),
              text: getTranslation( 'Wychodzące' ),
              scope: this,
              handler: function() {
                markActivityOutgoingTransitions( this );
              }
            } ), new Ext.menu.Item( {
              cls: 'x-btn-text-icon',
              icon: getPluginImgPath( 'inout' ),
              text: getTranslation( 'Wszystkie' ),
              scope: this,
              handler: function() {
                markAllActivityTransitions( this );
              }
            } ) ]
          } )
        } ) );
        if ( mainPanel.getDocumentationView() ) {
            items.push( new Ext.menu.Item( {
                cls: 'x-btn-text-icon',
                icon: getPluginImgPath( 'specification' ),
                text: getTranslation( 'Specyfikacja' ),
                scope: this,
                handler: function() {
                    editActivitySpecification( this );
                }
            } ) );
        }
        items.push( new Ext.menu.Item( {
            cls: 'x-btn-text-icon',
            icon: getPluginImgPath( 'properties' ),
            text: menuTextWithHotkey( getTranslation( 'Właściwości' ), 'F2' ),
            scope: this,
            handler: function() {
                showActivityProperties( {
                  activityNode: this
                } );
            }
        } ) );

        if ( activityType != Ext.ux.suncode.Constants.ROUTE ) {
          items.push( new Ext.menu.Separator() );
          items.push( new Ext.menu.Item( {
            cls: 'x-btn-text-icon',
            icon: getPluginImgPath( 'form' ),
            text: getTranslation( 'Formularz' ),
            scope: this,
            handler: function() {
              designActivityForm( this );
            }
          } ) );
        }

        var menu = new Ext.menu.Menu( {
            items: items
        } );
        menu.showAt( pos );
    },
    updateActivityDef: function( def ) {
        var processNode = this.parentNode;
        var processDefId = processNode.attributes.processDefId;
        var activityDefId = def.activityDefId;
        var activityName = def.activityName;

        this.attributes.activityDefId = activityDefId;
        this.attributes.activityName = activityName;
        this.attributes.activityDescr = def.activityDescr;
        this.attributes.assignment = def.assignment;
        this.attributes.nextActivity = def.nextActivity;
        this.attributes.acceptedNextActivities = def.acceptedNextActivities;
        this.attributes.acceptConcurrently = def.acceptConcurrently;
        this.attributes.acceptSequentially = def.acceptSequentially;
        this.attributes.newDocumentAccept = def.newDocumentAccept;
        this.attributes.allowMultipleActiveActivities = def.allowMultipleActiveActivities;
        this.attributes.idChanged = true;
        this.setText( this.getNodeText( processDefId, activityDefId, activityName ) );
    },
    updateActivityPerformer: function( newRoleId, newRoleName ) {
        this.attributes.roleId = newRoleId;
        this.attributes.activityPerformer = newRoleName;
    },
    getVariableUtilization: function( processDefId, variablesMaps, variableId ) {
      var utilization = new Array();
      var activityDefId = this.attributes.activityDefId;
      var activityName = this.attributes.activityName;
      var assignment = this.attributes.assignment;

      if ( ( assignment.type == 'newAssignment' || assignment.type == 'superior' || assignment.type == 'superior_role' )
          && assignment.value == variableId ) {
        utilization.push( {
          processDefId: processDefId,
          activityDefId: activityDefId,
          activityName: activityName,
          objectName: getTranslation( 'Przypisanie zadania' ),
          component: assignment
        } );
      }
      if ( assignment.exception == variableId ) {
        utilization.push( {
          processDefId: processDefId,
          activityDefId: activityDefId,
          activityName: activityName,
          objectName: getTranslation( 'Wyjątek w zadaniu' ),
          component: assignment
        } );
      }

      var variables = this.attributes.form.variables;
      for ( var i = 0; i < variables.length; i++ ) {
        var variable = variables[i];

        if ( variable.genre == 'VARIABLE' ) {
          if ( !Ext.isEmpty( variable.autoUpdates ) ) {
            for ( var j = 0; j < variable.autoUpdates.length; j++ ) {
              var autoUpdate = variable.autoUpdates[j];
              var autoUpdateDataSources = autoUpdate.dataSources;
              for ( var k = 0; k < autoUpdateDataSources.length; k++ ) {
                if ( autoUpdateDataSources[k].varId == variableId ) {
                  utilization.push( {
                    processDefId: processDefId,
                    activityDefId: activityDefId,
                    activityName: activityName,
                    objectOwner: getTranslation( 'Zmienna formularza' ) + ' (' + variablesMaps.get( variable.varId ) + ')',
                    objectName: getTranslation( 'Źródło danych akcji' ),
                    component: autoUpdate
                  } );
                }
              }

              var autoUpdateDestinations = autoUpdate.destinations;
              for ( var k = 0; k < autoUpdateDestinations.length; k++ ) {
                if ( autoUpdateDestinations[k].varId == variableId ) {
                  utilization.push( {
                    processDefId: processDefId,
                    activityDefId: activityDefId,
                    activityName: activityName,
                    objectOwner: getTranslation( 'Zmienna formularza' ) + ' (' + variablesMaps.get( variable.varId ) + ')',
                    objectName: getTranslation( 'Zmienna wynikowa akcji' ),
                    component: autoUpdate
                  } );
                }
              }
            }
          }
        } else if ( variable.genre == 'VARIABLE_SET' ) {
          var columns = variable.columns;
          var groupers = variable.groupers;
          var sorters = variable.sorters;

          for ( var j = 0; j < columns.length; j++ ) {
            var column = columns[j];
            if ( column.varId == variableId ) {
              utilization.push( {
                processDefId: processDefId,
                activityDefId: activityDefId,
                activityName: activityName,
                objectOwner: getTranslation( 'Tabela dynamiczna' ) + ' (' + variable.name + ')',
                objectName: getTranslation( 'Kolumna' ),
                component: variable
              } );
            }
          }

          for ( var j = 0; j < groupers.length; j++ ) {
            var grouper = groupers[j];

            if (grouper.columnId == variableId || grouper.groupNameColumnId == variableId) {
              utilization.push( {
                processDefId: processDefId,
                activityDefId: activityDefId,
                activityName: activityName,
                objectOwner: getTranslation( 'Tabela dynamiczna' ) + ' (' + variable.name + ')',
                objectName: getTranslation( 'Grupowanie' ),
                component: variable
              } );
            }

            if ( !Ext.isEmpty( grouper.aggregations ) ) {
              for (var k = 0; k < grouper.aggregations.length; k++) {
                var aggregation = grouper.aggregations[k];

                if (aggregation.columnId == variableId) {
                  utilization.push({
                    processDefId: processDefId,
                    activityDefId: activityDefId,
                    activityName: activityName,
                    objectOwner: getTranslation('Tabela dynamiczna') + ' (' + variable.name + ')',
                    objectName: getTranslation('Agregacja w grupowaniu po zmiennej') + ' ' + variablesMaps.get(grouper.columnId),
                    component: variable
                  });
                }
              }
            }
          }

          for ( var j = 0; j < sorters.length; j++ ) {
            var sorter = sorters[j];

            if (sorter.columnId == variableId) {
              utilization.push( {
                processDefId: processDefId,
                activityDefId: activityDefId,
                activityName: activityName,
                objectOwner: getTranslation( 'Tabela dynamiczna' ) + ' (' + variable.name + ')',
                objectName: getTranslation( 'Sortowanie' ),
                component: variable
              } );
            }
          }
        }
      }

      var buttons = this.attributes.form.buttons;
      for ( var i = 0; i < buttons.length; i++ ) {
        var button = buttons[i];
        if ( button.genre == 'ACTION_ACCEPT_BUTTON' ) {
          var actions = button.actions;
          for ( var j = 0; j < actions.length; j++ ) {
            var attributions = actions[j].attributions;
            for ( var k = 0; k < attributions.length; k++ ) {
              if ( attributions[k].varId == variableId ) {
                utilization.push( {
                  processDefId: processDefId,
                  activityDefId: activityDefId,
                  activityName: activityName,
                  objectOwner: getTranslation( 'Przycisk akceptacji' ) + ' (' + button.buttonName + ')',
                  objectName: getTranslation( 'Przypisanie akcji' ),
                  component: button
                } );
              }
            }
            var conditions = actions[j].conditions;
            for ( var k = 0; k < conditions.length; k++ ) {
              if ( conditions[k].varId == variableId ) {
                utilization.push( {
                  processDefId: processDefId,
                  activityDefId: activityDefId,
                  activityName: activityName,
                  objectOwner: getTranslation( 'Przycisk akceptacji' ) + ' (' + button.buttonName + ')',
                  objectName: getTranslation( 'Warunek przypisania akcji' ),
                  component: button
                } );
              }
            }
          }
          var dcIncludes = button.dcIncludes;
          for ( var j = 0; j < dcIncludes.length; j++ ) {
            if ( dcIncludes[j].dataChooserId == variableId ) {
              utilization.push( {
                processDefId: processDefId,
                activityDefId: activityDefId,
                activityName: activityName,
                objectOwner: getTranslation( 'Przycisk akceptacji' ) + ' (' + button.buttonName + ')',
                objectName: getTranslation( 'Walidowana dynamiczna lista' ),
                component: button
              } );
            }
          }
          var dcExcludes = button.dcExcludes;
          for ( var j = 0; j < dcExcludes.length; j++ ) {
            if ( dcExcludes[j].dataChooserId == variableId ) {
              utilization.push( {
                processDefId: processDefId,
                activityDefId: activityDefId,
                activityName: activityName,
                objectOwner: getTranslation( 'Przycisk akceptacji' ) + ' (' + button.buttonName + ')',
                objectName: getTranslation( 'Niewalidowana dynamiczna lista' ),
                component: button
              } );
            }
          }
          var oldValidators = button.oldValidators;
          for ( var j = 0; j < oldValidators.length; j++ ) {
            var parameters = oldValidators[j].parameters;
            for ( var k = 0; k < parameters.length; k++ ) {
              if ( parameters[k].id == variableId ) {
                utilization.push( {
                  processDefId: processDefId,
                  activityDefId: activityDefId,
                  activityName: activityName,
                  objectOwner: getTranslation( 'Przycisk akceptacji' ) + ' (' + button.buttonName + ')',
                  objectName: getTranslation( 'Walidator' ) + ' (' + oldValidators[j].classpath + ')',
                  component: button
                } );
              }
            }
          }
          var oldVariablesSetters = button.oldVariablesSetters;
          for ( var j = 0; j < oldVariablesSetters.length; j++ ) {
            var parameters = oldVariablesSetters[j].parameters;
            for ( var k = 0; k < parameters.length; k++ ) {
              if ( parameters[k].id == variableId ) {
                utilization.push( {
                  processDefId: processDefId,
                  activityDefId: activityDefId,
                  activityName: activityName,
                  objectOwner: getTranslation( 'Przycisk akceptacji' ) + ' (' + button.buttonName + ')',
                  objectName: getTranslation( 'Mechanizm sprawdzający formularz' ) + ' (' + oldVariablesSetters[j].classpath + ')',
                  component: button
                } );
              }
            }
          }
        } else if ( button.genre == 'BARCODE_PRINT' ) {
          if ( button.labelTextVar == variableId ) {
            utilization.push( {
              processDefId: processDefId,
              activityDefId: activityDefId,
              activityName: activityName,
              objectOwner: getTranslation( 'Przycisk drukowania kodu kreskowego' ) + ' (' + button.buttonName + ')',
              objectName: getTranslation( 'Zmienna' ),
              component: button
            } );
          }
        }
      }

      var applications = this.attributes.applications;
      for ( var i = 0; i < applications.length; i++ ) {
        var application = applications[i];

        if ( !Ext.isEmpty( application.parameters ) ) {
          var parameters = application.parameters;
          for ( var j = 0; j < parameters.length; j++ ) {
            var parameter = parameters[j];
            if ( parameter.varId == variableId ) {
              utilization.push( {
                processDefId: processDefId,
                activityDefId: activityDefId,
                activityName: activityName,
                objectOwner: getTranslation( 'Aplikacja' ) + ' (' + application.name + ')',
                objectName: getTranslation( 'Parametr' ),
                component: application
              } );
            }
          }
        }
      }

      var condTrs = this.attributes.transitions.cond;
      for ( var i = 0; i < condTrs.length; i++ ) {
        var condition = condTrs[i].condition;

        if ( !isCustomTransitionCondition( condition ) ) {
          var conditionsTable = createTransitionConditionsTable( condition );

          for ( var j = 0; j < conditionsTable.length; j++ ) {
            if ( conditionsTable[j].varId == variableId ) {
              utilization.push( {
                processDefId: processDefId,
                activityDefId: activityDefId,
                activityName: activityName,
                objectOwner: getTranslation( 'Połączenie' ),
                objectName: getTranslation( 'Warunek' ),
                component: conditionsTable[j]
              } );
            }
          }
        }
      }

      var deadlines = this.attributes.deadlines;
      for ( var i = 0; i < deadlines.length; i++ ) {
        var deadline = deadlines[i];
        if ( deadlines[i].varId == variableId ) {
          utilization.push( {
            processDefId: processDefId,
            activityDefId: activityDefId,
            activityName: activityName,
            objectOwner: getTranslation( 'Termin ostateczny' ) + ' (' + deadline.exceptionName + ')',
            objectName: getTranslation( 'Czas rozpoczęcia odliczania' ),
            component: deadline
          } );
        }
      }

      var acceptances = this.attributes.acceptances;
      for ( var i = 0; i < acceptances.length; i++ ) {
        var acceptance = acceptances[i];

        if ( variableId == acceptance.acceptVar ) {
          utilization.push( {
            processDefId: processDefId,
            activityDefId: activityDefId,
            activityName: activityName,
            objectOwner: getTranslation( 'Akceptacja' ),
            objectName: getTranslation( 'Lista akceptujących' ),
            objectId: acceptance.id,
            component: acceptance
          } );
        }
        if ( variableId == acceptance.checkVar ) {
          utilization.push( {
            processDefId: processDefId,
            activityDefId: activityDefId,
            activityName: activityName,
            objectOwner: getTranslation( 'Akceptacja' ),
            objectName: getTranslation( 'Pełna lista akceptujących' ),
            component: acceptance
          } );
        }
        if ( variableId == acceptance.resultVar ) {
          utilization.push( {
            processDefId: processDefId,
            activityDefId: activityDefId,
            activityName: activityName,
            objectOwner: getTranslation( 'Akceptacja' ),
            objectName: getTranslation( 'Zmienna wynikowa' ),
            component: acceptance
          } );
        }
      }

      if ( this.attributes.activityType == Ext.ux.suncode.Constants.SUBFLOW ) {
        var subflow = this.attributes.subflow;
        var actualParameters = subflow.params;
        for ( var i = 0; i < actualParameters.length; i++ ) {
          var p = actualParameters[i];
          if ( p.actualParam == variableId ) {
            utilization.push( {
              processDefId: processDefId,
              activityDefId: activityDefId,
              activityName: activityName,
              objectOwner: getTranslation( 'Podproces' ) + ' (' + subflow.id + ')',
              objectName: getTranslation( 'Zmienna' ),
              component: p
            } );
          }
        }
      }

      var defaults = this.attributes.additionals.defaults;
      for ( var i = 0; i < defaults.length; i++ ) {
        if ( defaults[i].varId == variableId ) {
          utilization.push( {
            processDefId: processDefId,
            activityDefId: activityDefId,
            activityName: activityName,
            objectName: getTranslation( 'Ustawienie domyślne' ),
            component: defaults[i]
          } );
        }
      }

      var extraDataChooserConfigs = this.attributes.additionals.extraDataChooserConfigs;
      for ( var i = 0; i < extraDataChooserConfigs.length; i++ ) {
        var extraDataChooserConfigs = extraDataChooserConfigs[i];
        if ( extraDataChooserConfigs.dataChooserId == variableId ) {
          utilization.push( {
            processDefId: processDefId,
            activityDefId: activityDefId,
            activityName: activityName,
            objectName: getTranslation( 'Definicja atrybutów dynamicznej listy' ),
            component: extraDataChooserConfigs
          } );
        }
      }

      return utilization;
    },
    changeAssignment: function( oldVarId, newVarId ) {
        var assignment = this.attributes.assignment;

        if ( ( assignment.type == 'newAssignment' || assignment.type == 'superior' || assignment.type == 'superior_role' )
                        && assignment.value == oldVarId ) {
            assignment.value = newVarId;
        }
        if ( assignment.exception == oldVarId ) {
            assignment.exception = newVarId;
        }
    },
    clearAssignmentByVarId: function( varId ) {
        var assignment = this.attributes.assignment;

        if ( ( assignment.type == 'newAssignment' || assignment.type == 'superior' || assignment.type == 'superior_role' )
                        && assignment.value == varId ) {
            assignment.type = 'role';
            assignment.value = this.attributes.roleId;
            assignment.exception = '';
        }
        if ( assignment.exception == varId ) {
            assignment.exception = '';
        }
    },
    setTransitionRestriction: function( transitionRestriction ) {
        this.attributes.transitionRestriction = transitionRestriction;
        Ext.getCmp( 'main_panel' ).setSaved( false );
    },
    setJoinTransitionRestriction: function( conditionType ) {
        this.attributes.transitionRestriction.join = conditionType;
        Ext.getCmp( 'main_panel' ).setSaved( false );
    },
    setSplitTransitionRestriction: function( conditionType ) {
        this.attributes.transitionRestriction.split = conditionType;
        Ext.getCmp( 'main_panel' ).setSaved( false );
    },
    loadFormTemplate: function( formTemplate ) {
        this.attributes.form.template = formTemplate ? this.resetDefaultFieldWidth(formTemplate) : {
            rows: new Array()
        };
    },
    resetDefaultFieldWidth: function (formTemplate) {
        for (var i = 0; i < formTemplate.rows.length; i++) {
            var row = formTemplate.rows[i];

            for ( var j = 0; j < row.items.length; j++ ) {
                var item = row.items[j];

                item.labelWidth = Ext.ux.suncode.Constants.FIELD_DEFAULT_LABEL_WIDTH === item.labelWidth
                    ? null : item.labelWidth;
                item.width = Ext.ux.suncode.Constants.FIELD_DEFAULT_WIDTH === item.width
                    ? null : item.width;
            }
        }
        return formTemplate;
    },
    updateFormTemplateVariable: function( type, varId, def ) {
        var formTemplate = this.attributes.form.template;

        mainLoop: for ( var i = 0; i < formTemplate.rows.length; i++ ) {
            var row = formTemplate.rows[i];

            for ( var j = 0; j < row.items.length; j++ ) {
                var item = row.items[j];

                if ( type == item.type && item.id == varId ) {
                    row.items[j] = def;
                    break mainLoop;
                }
            }
        }
    },
    changeFormTemplateVariable: function( oldVarId, varObj ) {
        var formTemplate = this.attributes.form.template;

        mainLoop: for ( var i = 0; i < formTemplate.rows.length; i++ ) {
            var row = formTemplate.rows[i];

            for ( var j = 0; j < row.items.length; j++ ) {
                var item = row.items[j];

                if ( item.id == oldVarId ) {
                    item.id = varObj.id;
                    item.type = varObj.type;
                    break mainLoop;
                }
            }
        }
    },
    restoreFormDefaultLook: function() {
      var formTemplate = this.attributes.form.template;

      for ( var i = 0; i < formTemplate.rows.length; i++ ) {
        var row = formTemplate.rows[i];

        for ( var j = 0; j < row.items.length; j++ ) {
          var item = row.items[j];

          if ( item.type == 'VARIABLE_SET' ) {
            item = Ext.apply( item, {
              headerFontSize: null,
              cellFontSize: null
            } );
          } else if ( item.type == 'LABEL' ) {
            item = Ext.apply( item, {
              marginTop: null,
              marginRight: null,
              marginBottom: null,
              marginLeft: null
            } );
          } else if ( !( item.type == 'LABEL' || item.type == 'GENERATE_PDF_BUTTON'
              || item.type == 'ACTION_ACCEPT_BUTTON' || item.type == 'ADD_FILE_BUTTON'
              || item.type == 'BARCODE_PRINT' || item.type == 'HTTP_LINK' ) ) {
            item = Ext.apply( item, {
              labelAlign: '',
              labelWidth: null,
              labelSeparator: '',
              labelFontSize: null,
              labelColor: '',
              textDecoration: '',
              hideLabel: false,
              marginTop: null,
              marginRight: null,
              marginBottom: null,
              marginLeft: null,
              width: null
            } );

            if ( item.type == 'TEXTAREA' ) {
              item = Ext.apply( item, {
                height: 100
              } );
            }
          }
        }
      }
    },
    setFormStyle: function( styleId, value ) {
        this.attributes.formStyles[styleId] = value;
    },
    setFormStyles: function( formStyles ) {
        this.attributes.formStyles = formStyles;
    },
    setFormSetting: function( settingId, value ) {
        this.attributes.formSettings[settingId] = value;
    },
    setFormSettings: function( formSettings ) {
        this.attributes.formSettings = formSettings;
    },
    getFormVariable: function( varId ) {
        var variables = this.attributes.form.variables;
        for ( var i = 0; i < variables.length; i++ ) {
            if ( varId == variables[i].varId ) {
                return variables[i];
            }
        }
        return null;
    },
    getColumnInVariableSet: function( varId ) {
        var variables = this.attributes.form.variables;
        for ( var i = 0; i < variables.length; i++ ) {
            var variable = variables[i];
            if ( variable.genre == 'VARIABLE_SET' ) {
                var columns = variable.columns;
                for ( var j = 0; j < columns.length; j++ ) {
                    var column = columns[j];
                    if ( column.varId == varId ) {
                        return column;
                    }
                }
            }
        }
        return null;
    },
    getVariableSetByColumn: function( varId ) {
        var variables = this.attributes.form.variables;
        for ( var i = 0; i < variables.length; i++ ) {
            var variable = variables[i];
            if ( variable.genre == 'VARIABLE_SET' ) {
                var columns = variable.columns;
                for ( var j = 0; j < columns.length; j++ ) {
                    var column = columns[j];
                    if ( column.varId == varId ) {
                        return variable;
                    }
                }
            }
        }
        return null;
    },
    loadFormVariables: function( formVars ) {
        this.attributes.form.variables = formVars ? formVars : new Array();
    },
    clearFormVariablesByVarId: function( varId ) {
        var variables = this.attributes.form.variables;
        var newVariables = new Array();

        for ( var i = 0; i < variables.length; i++ ) {
            var variable = variables[i];

            if ( variable.genre == 'VARIABLE' ) {
                if ( varId != variable.varId ) {
                    newVariables.push( variable );
                } else {
                    if ( !Ext.isEmpty( variable.autoUpdates ) ) {
                        for ( var j = 0; j < variable.autoUpdates.length; j++ ) {
                            var autoUpdate = variable.autoUpdates[j];
                            var autoUpdateDataSources = autoUpdate.dataSources;
                            for ( var k = 0; k < autoUpdateDataSources.length; k++ ) {
                                if ( autoUpdateDataSources[k].varId == varId ) {
                                    autoUpdateDataSources.splice( k, 1 );
                                    break;
                                }
                            }

                            var autoUpdateDestinations = autoUpdate.destinations;
                            for ( var k = 0; k < autoUpdateDestinations.length; k++ ) {
                                if ( autoUpdateDestinations[k].varId == varId ) {
                                    autoUpdateDestinations.splice( k, 1 );
                                    break;
                                }
                            }
                        }
                    }

                    var formTemplate = this.attributes.form.template;
                    var rows = formTemplate.rows;

                    mainLoop: for ( var j = 0; j < rows.length; j++ ) {
                        var row = rows[j];
                        var items = row.items;

                        for ( var k = 0; k < items.length; k++ ) {
                            var item = items[k];

                            if ( item.id == varId ) {
                                items.splice( k, 1 );

                                if ( Ext.isEmpty( items ) ) {
                                    rows.splice( j, 1 );
                                }
                                break mainLoop;
                            }
                        }
                    }
                }
            } else if ( variable.genre == 'VARIABLE_SET' ) {
                var columns = variable.columns;
                var groupers = variable.groupers;
                var sorters = variable.sorters;

                for ( var j = 0; j < columns.length; j++ ) {
                    var column = columns[j];
                    if ( column.varId == varId ) {
                        columns.splice( j, 1 );
                        break;
                    }
                }

                for ( var j = 0; j < groupers.length; j++ ) {
                    var grouper = groupers[j];
                    if ( grouper.groupNameColumnId == varId ) {
                      groupers.groupNameColumnId = '';
                    }

                    if ( grouper.columnId == varId ) {
                        groupers.splice( j, 1 );
                    }
                }

                for ( var j = 0; j < sorters.length; j++ ) {
                  var sorter = sorters[j];
                  if ( sorter.columnId == varId ) {
                    sorters.splice( j, 1 );
                  }
                }

                if ( !Ext.isEmpty( columns ) ) {
                  newVariables.push( variable );
                }
            }
        }

        variables.splice( 0, variables.length );
        this.attributes.form.variables = newVariables;
    },
    addVariable: function( varDef, itemDef, location ) {
        var addToTemplate = Ext.isEmpty( this.attributes.form.variables ) || !Ext.isEmpty( this.attributes.form.template.rows );

        if ( !Ext.isEmpty( location ) ) {
          var variables = this.attributes.form.variables;
          var added = false;

          for ( var i = 0; i < variables.length; i++ ) {
            if ( variables.varId === location.previousElementId ) {
              variables.splice( i + 1, 0, varDef );
              added = true;
              break;
            }
          }

          if ( !added ) {
            variables.push( varDef );
          }

          added = false;

          if ( addToTemplate ) {
            var formTemplate = this.attributes.form.template;
            var rows = formTemplate.rows;
            mainLoop: for ( var i = 0; i < rows.length; i++ ) {
              var row = rows[i];
              var items = row.items;

              for ( var j = 0; j < items.length; j++ ) {
                var item = items[j];

                if ( item.id === location.previousElementId ) {
                  rows.splice( i + 1, 0, {
                    layoutPack: 'start',
                    items: [ itemDef ]
                  } );
                  added = true;
                  break mainLoop;
                }

                if ( item.id === location.nextElementId ) {
                  rows.splice( i, 0, {
                    layoutPack: 'start',
                    items: [ itemDef ]
                  } );
                  added = true;
                  break mainLoop;
                }
              }
            }

            if ( !added ) {
              rows.push( {
                layoutPack: 'start',
                items: [ itemDef ]
              } );
            }
          }
        } else {
          this.attributes.form.variables.push( varDef );

          if ( addToTemplate ) {
            this.attributes.form.template.rows.push( {
              layoutPack: 'start',
              items: [ itemDef ]
            } );
          }
        }

        Ext.getCmp( 'main_panel' ).setSaved( false );
    },
    updateVariable: function( varId, varDef, itemDef ) {
        this.updateFormVariable( varId, varDef );
        this.updateFormTemplateVariable( varDef.type, varId, itemDef );
    },
    updateFormVariable: function( varId, def ) {
        var variables = this.attributes.form.variables;

        for ( var i = 0; i < variables.length; i++ ) {
            var variable = variables[i];

            if ( variable.genre == def.genre && varId == variable.varId ) {
                variables[i] = def;
                Ext.getCmp( 'main_panel' ).setSaved( false );
                break;
            }
        }
    },
    changeFormVariable: function( oldVarId, varDef ) {
        var variables = this.attributes.form.variables;
        var newVarId = varDef.id;

        for ( var i = 0; i < variables.length; i++ ) {
            var variable = variables[i];

            if ( variable.genre == 'VARIABLE' ) {
                if ( oldVarId == variable.varId ) {
                    this.changeFormVariableAutoUpdate( variable, oldVarId, newVarId );
                    this.changeFormObjectIntegrationComponents( variable, varDef );

                    variable.varId = newVarId;
                    variable.name = varDef.name;
                    variable.type = varDef.type;

                    Ext.ux.suncode.DocumentationService.renameFormVariableSpecification( this, oldVarId, newVarId );
                }
            } else if ( variable.genre == 'VARIABLE_SET' && oldVarId != newVarId ) {
                var columns = variable.columns;
                var groupers = variable.groupers;
                var sorters = variable.sorters;

                for ( var j = 0; j < columns.length; j++ ) {
                    var column = columns[j];
                    if ( column.varId == oldVarId ) {
                        column.varId = newVarId;
                        break;
                    }
                }

                for ( var j = 0; j < groupers.length; j++ ) {
                  var grouper = groupers[j];
                  if ( grouper.columnId == oldVarId ) {
                    grouper.columnId = newVarId;
                  }

                  if ( grouper.groupNameColumnId == oldVarId ) {
                    grouper.groupNameColumnId = newVarId;
                  }

                  if ( !Ext.isEmpty( grouper.aggregations ) ) {
                    var aggregations = grouper.aggregations;
                    for ( var k = 0; k < aggregations.length; k++ ) {
                      var aggregation = aggregations[k];
                      if ( aggregation.columnId == oldVarId ) {
                        aggregation.columnId = newVarId;
                        break;
                      }
                    }
                  }
                }

                for ( var j = 0; j < sorters.length; j++ ) {
                  var sorter = sorters[j];
                  if ( sorter.columnId == oldVarId ) {
                    sorter.columnId = newVarId;
                    break;
                  }
                }
            }
        }
    },
    changeFormVariableAutoUpdate: function( variable, oldVarId, newVarId ) {
        if ( !Ext.isEmpty( variable.autoUpdates ) ) {
            for ( var j = 0; j < variable.autoUpdates.length; j++ ) {
                var autoUpdate = variable.autoUpdates[j];
                var previousId = autoUpdate.id;
                var autoUpdateDataSources = autoUpdate.dataSources;
                for ( var k = 0; k < autoUpdateDataSources.length; k++ ) {
                    if ( autoUpdateDataSources[k].varId == oldVarId ) {
                        autoUpdateDataSources[k].varId = newVarId;
                        break;
                    }
                }

                var autoUpdateDestinations = autoUpdate.destinations;
                for ( var k = 0; k < autoUpdateDestinations.length; k++ ) {
                    if ( autoUpdateDestinations[k].varId == oldVarId ) {
                        autoUpdateDestinations[k].varId = newVarId;
                        break;
                    }
                }

                autoUpdate.id = generateAutoUpdateId( autoUpdate );
                Ext.ux.suncode.DocumentationService.renameAutoUpdateSpecification( this, variable.id, previousId, autoUpdate.id );
            }
        }
    },
    changeFormObjectIntegrationComponents: function( formObject, formObjectDef ) {
      if ( Ext.isDefined( formObjectDef.formActions ) ) {
        var newFormActions = deepObjectCopy( formObjectDef.formActions );

        Ext.each( formObject.formActions, function( formAction, index, formActions ) {
          if ( Ext.isEmpty( formAction.globalId ) ) {
            newFormActions.push( formAction );
          }
        } );

        Ext.apply( formObject, {
          formActions: newFormActions
        } );
      }

      if ( Ext.isDefined( formObjectDef.eventActions ) ) {
        var newEventActions = deepObjectCopy( formObjectDef.eventActions );

        Ext.each( formObject.eventActions, function( eventAction, index, eventActions ) {
          if ( Ext.isEmpty( eventAction.globalId ) ) {
            newEventActions.push( eventAction );
          }
        } );

        Ext.apply( formObject, {
          eventActions: newEventActions
        } );
      }
    },
    setFormVariablesEditability: function( editable ) {
        var variables = this.attributes.form.variables;
        for ( var i = 0; i < variables.length; i++ ) {
            variables[i].editable = editable;
        }
        Ext.getCmp( 'main_panel' ).setSaved( false );
    },
    setFormVariableEditability: function( varId, editable ) {
    	var variables = this.attributes.form.variables;
        for ( var i = 0; i < variables.length; i++ ) {
            if ( varId == variables[i].varId ) {
                variables[i].editable = editable;
                Ext.getCmp( 'main_panel' ).setSaved( false );
                break;
            }
        }
    },
    setFormVariableVisibility: function( varId, hidden ) {
        var variables = this.attributes.form.variables;
        for ( var i = 0; i < variables.length; i++ ) {
            if ( varId == variables[i].varId ) {
                variables[i].hidden = hidden;
                if ( hidden ) {
                	variables[i].editable = true;
                }
                Ext.getCmp( 'main_panel' ).setSaved( false );
                break;
            }
        }
    },
    setVariableSetColumnVisibility: function( varId, hidden ) {
        var column = this.getColumnInVariableSet( varId );
        if ( !Ext.isEmpty( column ) ) {
            column.hidden = hidden;
            column.differentHidden = hidden;
            Ext.getCmp( 'main_panel' ).setSaved( false );
        }
    },
    setVariableSetColumnReadOnly: function( varId, readonly ) {
        var column = this.getColumnInVariableSet( varId );
        if ( !Ext.isEmpty( column ) ) {
            column.readonly = readonly;
            column.differentReadonly = readonly;
            Ext.getCmp( 'main_panel' ).setSaved( false );
        }
    },
    changeColumnInVariableSetEditability: function( varId, readonly ) {
        var variables = this.attributes.form.variables;
        for ( var i = 0; i < variables.length; i++ ) {
            var variable = variables[i];
            if ( variable.genre == 'VARIABLE_SET' ) {
                var columns = variable.columns;
                for ( var j = 0; j < columns.length; j++ ) {
                    var column = columns[j];
                    if ( column.varId == varId ) {
                        if ( column.differentReadonly ) {
                            column.differentReadonly = ( column.readonly != readonly );
                        }
                        column.readonly = readonly;
                    }
                }
            }
        }
    },
    getVariableIdsOnForm: function() {
      var ids = new Array();
      var processNode = this.parentNode;
      var variables = this.attributes.form.variables;
      var formalParameters = processNode.attributes.formalParameters;

      for ( var i = 0; i < variables.length; i++ ) {
        var variable = variables[i];

        if ( variable.genre == 'VARIABLE' ) {
          ids.push( variable.varId );
        } else if ( variable.genre == 'VARIABLE_SET' ) {
          var columns = variable.columns;

          for ( var j = 0; j < columns.length; j++ ) {
            var column = columns[j];

            ids.push( column.varId );
          }
        }
      }

      for ( var i = 0; i < formalParameters.length; i++ ) {
        var formalParameter = formalParameters[i];

        ids.push(formalParameter.id);
      }

      return ids;
    },
    getAllVariableSetIds: function() {
      var ids = new Array();
      var variables = this.attributes.form.variables;

      for ( var i = 0; i < variables.length; i++ ) {
        var variable = variables[i];

        if ( variable.genre == 'VARIABLE_SET' ) {
          ids.push( variable.varId );
        }
      }

      return ids;
    },
    validateUpdateDtButton: function( globalId, dtButtonId ) {
      var result = {
        valid: true,
        duplicatedDtButton: null
      };

      var duplicatedDtButton = null;
      var variables = this.attributes.form.variables;

      for ( var i = 0; i < variables.length; i++ ) {
        var variable = variables[i];

        if ( variable.genre == 'VARIABLE_SET' ) {
          var variableSetDtButtons = variable.DTButtons;

          for ( var j = 0; j < variableSetDtButtons.length; j++ ) {
            var variableSetDtButton = variableSetDtButtons[j];

            if ( globalId !== variableSetDtButton.globalId && dtButtonId == variableSetDtButton.buttonId ) {
              duplicatedDtButton = {
                buttonId: variableSetDtButton.buttonId,
                tableName: !Ext.isEmpty( variable.name ) ? variable.name : variable.varId
              };
            }
          }
        }
      }

      if ( !Ext.isEmpty( duplicatedDtButton ) ) {
        result = Ext.apply( result, {
          valid: false,
          duplicatedDtButton: duplicatedDtButton
        } );
      }

      return result;
    },
    validateChangeVariableSet: function( tableId, columns ) {
      var result = {
        valid: true,
        duplicatedVariables: new Array()
      };

      var columnIds = new Array();
      Ext.each( columns, function( column, index, allColumns ) {
        columnIds.push( column.varId );
      } );

      var duplicatedVariables = new Array();
      var tablePresent = false;
      var variables = this.attributes.form.variables;

      for ( var i = 0; i < variables.length; i++ ) {
        var variable = variables[i];

        if ( variable.genre == 'VARIABLE' && columnIds.indexOf( variable.varId ) != -1 ) {
          duplicatedVariables.push( variable.varId );
        } else if ( variable.genre == 'VARIABLE_SET' ) {
          if ( variable.varId == tableId ) {
            tablePresent = true;
          } else {
            var variableSetColumns = variable.columns;

            for ( var j = 0; j < variableSetColumns.length; j++ ) {
              var variableSetColumn = variableSetColumns[j];

              if ( columnIds.indexOf( variableSetColumn.varId ) != -1 ) {
                duplicatedVariables.push( variableSetColumn.varId );
              }
            }
          }
        }
      }

      if ( tablePresent && !Ext.isEmpty( duplicatedVariables ) ) {
        result = Ext.apply( result, {
          valid: false,
          duplicatedVariables: duplicatedVariables
        } );
      }

      return result;
    },
    validateTableUniqueness: function( tableId ) {
      var result = {
        valid: true
      };
      var variables = this.attributes.form.variables;

      for ( var i = 0; i < variables.length; i++ ) {
        var variable = variables[i];

        if ( variable.genre == 'VARIABLE_SET' && variable.varId == tableId ) {
          result = Ext.apply( result, {
            valid: false
          } );
        }
      }

      return result;
    },
    validateTableDtButtonsDuplication: function( dtButtons ) {
      var duplicatedDtButtons = new Array();
      var variables = this.attributes.form.variables;

      for ( var i = 0; i < variables.length; i++ ) {
        var variable = variables[i];

        if ( variable.genre == 'VARIABLE_SET' ) {
          Ext.each( variable.DTButtons, function( localTableDtButton, localTableDtButtonsIndex, localTableDtButtons ) {
            Ext.each( dtButtons, function( dtButton, dtButtonsIndex, allDtButtons ) {
              if ( localTableDtButton.buttonId == dtButton.buttonId ) {
                duplicatedDtButtons.push( {
                  global: false,
                  tableId: variable.varId,
                  dtButtonId: localTableDtButton.buttonId
                } );
              }
            } );
          } );
        }
      }

      return duplicatedDtButtons;
    },
    changeVariableSet: function( oldTableId, tableObj ) {
      var variables = this.attributes.form.variables;

      for ( var i = 0; i < variables.length; i++ ) {
        var variable = variables[i];

        if ( variable.genre == 'VARIABLE_SET' && variable.varId == oldTableId ) {
          var processNode = this.parentNode;
          var newColumns = deepObjectCopy( tableObj.columns );
          var newDtButtons = deepObjectCopy( tableObj.DTButtons );
          var newFormActions = deepObjectCopy( tableObj.formActions );
          var newEventActions = deepObjectCopy( tableObj.eventActions );
          var currentColumnsReadonly = new HashMap();
          var currentColumnsHidden = new HashMap();

          Ext.each( variable.columns, function( column, index, columns ) {
            currentColumnsReadonly.put( column.varId, {
              readonly: column.readonly,
              differentReadonly: column.differentReadonly
            } );
            currentColumnsHidden.put( column.varId, {
              hidden: column.hidden,
              differentHidden: column.differentHidden
            } );
          } );

          Ext.each( newColumns, function( column, index, columns ) {
            if ( currentColumnsReadonly.contains( column.varId ) && currentColumnsHidden.contains( column.varId ) ) {
              var currentDifferentReadonly = currentColumnsReadonly.get( column.varId );
              var currentDifferentHidden = currentColumnsHidden.get( column.varId );

              if ( currentDifferentReadonly.differentReadonly ) {
                Ext.apply( column, {
                  readonly: currentDifferentReadonly.readonly
                } );
              }

              if ( currentDifferentHidden.differentHidden ) {
                Ext.apply( column, {
                  hidden: currentDifferentHidden.hidden
                } );
              }

              Ext.apply( column, {
                differentReadonly: currentDifferentReadonly.differentReadonly,
                differentHidden: currentDifferentHidden.differentHidden
              } );
            }
          } );

          Ext.each( variable.DTButtons, function( dtButton, index, dtButtons ) {
            if ( Ext.isEmpty( dtButton.globalId ) ) {
              newDtButtons.push( dtButton );
            } else {
              Ext.each( newDtButtons, function( newDtButton, newDtButtonIndex, allNewDtButtons ) {
                if ( newDtButton.globalId === dtButton.globalId ) {
                  Ext.each( dtButton.formActions, function( formAction, formActionIndex, formActions ) {
                    if ( Ext.isEmpty( formAction.globalId ) ) {
                      newDtButton.formActions.push( deepObjectCopy( formAction ) );
                    }
                  } );

                  Ext.each( dtButton.eventActions, function( eventAction, eventActionIndex, eventActions ) {
                    if ( Ext.isEmpty( eventAction.globalId ) ) {
                      newDtButton.eventActions.push( deepObjectCopy( eventAction ) );
                    }
                  } );
                  return false;
                }
              } );

              Ext.ux.suncode.DocumentationService.deleteDtButtonSpecification( this, dtButton.buttonId );
            }
          }, this );

          if ( !Ext.isEmpty( tableObj.dtButtonsFillPosition ) ) {
            Ext.apply( variable, {
              dtButtonsFillPosition: tableObj.dtButtonsFillPosition
            } );
          }

          Ext.each( variable.formActions, function( formAction, index, formActions ) {
            if ( Ext.isEmpty( formAction.globalId ) ) {
              newFormActions.push( formAction );
            }
          } );

          Ext.each( variable.eventActions, function( eventAction, index, eventActions ) {
            if ( Ext.isEmpty( eventAction.globalId ) ) {
              newEventActions.push( eventAction );
            }
          } );

          Ext.apply( variable, {
            varId: tableObj.id,
            name: tableObj.name,
            clicksToEdit: tableObj.clicksToEdit,
            showDeleteConfirmation: tableObj.showDeleteConfirmation,
            hideRowNumber: tableObj.hideRowNumber,
            columns: newColumns,
            actions: deepObjectCopy( tableObj.actions ),
            groupers: deepObjectCopy( tableObj.groupers ),
            sorters: deepObjectCopy( tableObj.sorters ),
            DTButtons: newDtButtons,
            formActions: newFormActions,
            eventActions: newEventActions
          } );

          var tableSpecification = Ext.ux.suncode.DocumentationService.getTableSpecification( processNode, tableObj.id );
          Ext.ux.suncode.DocumentationService.editFormVariableSpecification( this, oldTableId, tableObj.id, tableSpecification );

          Ext.each( variable.DTButtons, function( dtButton, index, dtButtons ) {
            if ( !Ext.isEmpty( dtButton.globalId ) ) {
              var tableButtonSpecification = Ext.ux.suncode.DocumentationService.getTableButtonSpecification( processNode, dtButton.buttonId );
              Ext.ux.suncode.DocumentationService.addDtButtonSpecification( this, dtButton.buttonId, tableButtonSpecification );
            }
          }, this );
        }
      }
    },
    changeFormTemplateVariableSet: function( oldTableId, newTableId ) {
      var formTemplate = this.attributes.form.template;

      mainLoop: for ( var i = 0; i < formTemplate.rows.length; i++ ) {
        var row = formTemplate.rows[i];

        for ( var j = 0; j < row.items.length; j++ ) {
          var item = row.items[j];

          if ( item.id == oldTableId ) {
            item.id = newTableId;
            break mainLoop;
          }
        }
      }
    },
    clearFormVariableSetsByTableId: function( tableId ) {
      var variables = this.attributes.form.variables;

      for ( var i = 0; i < variables.length; i++ ) {
        var variable = variables[i];

        if ( variable.genre == 'VARIABLE_SET' && variable.varId == tableId ) {
          variables.splice( i, 1 );

          var formTemplate = this.attributes.form.template;
          var rows = formTemplate.rows;

          mainLoop: for ( var j = 0; j < rows.length; j++ ) {
            var row = rows[j];
            var items = row.items;

            for ( var k = 0; k < items.length; k++ ) {
              var item = items[k];

              if ( item.id == tableId ) {
                items.splice( k, 1 );

                if ( Ext.isEmpty( items ) ) {
                  rows.splice( j, 1 );
                }
                break mainLoop;
              }
            }
          }
        }
      }
    },
    validateTextareasInOneLine: function( varId ) {
      var valid = true;
      var formTemplate = this.attributes.form.template;

      mainLoop: for ( var i = 0; i < formTemplate.rows.length; i++ ) {
        var row = formTemplate.rows[i];
        var isVariableInRow = false;
        var isOtherTextareaInRow = false;

        for ( var j = 0; j < row.items.length; j++ ) {
          var item = row.items[j];

          if ( item.id == varId ) {
            isVariableInRow = true;
          } else if ( item.type == 'TEXTAREA' ) {
            isOtherTextareaInRow = true;
          }

          if ( isVariableInRow && isOtherTextareaInRow ) {
            valid = false;
            break mainLoop;
          }
        }
      }

      return valid;
    },
    changeFormObjectFormAction: function( id, formActionGlobalId, formActionUpdate ) {
      var variables = this.attributes.form.variables;

      for ( var i = 0; i < variables.length; i++ ) {
        var variable = variables[i];

        if (variable.varId == id) {
          Ext.each( variable.formActions, function( formAction, index, formActions ) {
            if (formAction.globalId == formActionGlobalId) {
              Ext.apply( formAction, deepObjectCopy( formActionUpdate ) );
            }
          } );
          break;
        }
      }
    },
    changeFormObjectEventAction: function( varId, eventActionGlobalId, eventActionUpdate ) {
      var variables = this.attributes.form.variables;

      for ( var i = 0; i < variables.length; i++ ) {
        var variable = variables[i];

        if (variable.genre == 'VARIABLE_SET' && variable.varId == varId) {
          Ext.each( variable.eventActions, function( eventAction, index, eventActions ) {
            if (eventAction.globalId == eventActionGlobalId) {
              Ext.apply( eventAction, deepObjectCopy( eventActionUpdate ) );
            }
          } );
        }
      }
    },
    changeLabelFormAction: function( labelId, formActionGlobalId, formActionUpdate ) {
      var labelActions = this.attributes.form.labelActions;

      for ( var i = 0; i < labelActions.length; i++ ) {
        var labelAction = labelActions[i];

        if (labelAction.labelId == labelId) {
          Ext.each( labelAction.formActions, function( formAction, index, formActions ) {
            if (formAction.globalId == formActionGlobalId) {
              Ext.apply( formAction, deepObjectCopy( formActionUpdate ) );
            }
          } );
          break;
        }
      }
    },
    hasFormElement: function( id ) {
    	var formTemplate = this.attributes.form.template;
        var rows = formTemplate.rows;
        for ( var i = 0; i < rows.length; i++ ) {
            var row = rows[i];
            var items = row.items;

            for ( var j = 0; j < items.length; j++ ) {
                var item = items[j];

                if ( item.id == id ) {
                    return true;
                }
            }
        }
        return false;
    },
    updateFormLabelsByLabelId: function( oldLabelId, labelDef ) {
    	  var formTemplate = this.attributes.form.template;
        var rows = formTemplate.rows;

        mainLoop: for ( var i = 0; i < rows.length; i++ ) {
            var row = rows[i];
            var items = row.items;

            for ( var j = 0; j < items.length; j++ ) {
                var item = items[j];

                if ( item.id == oldLabelId ) {
                	Ext.apply( item, {
                		id: labelDef.id,
                		text: labelDef.name
                	} );
                    break mainLoop;
                }
            }
        }

        var labelActions = this.attributes.form.labelActions;
        
        for ( var i = 0; i < labelActions.length; i++ ) {
            var labelAction = labelActions[i];
            
            if ( labelAction.labelId == oldLabelId ) {
            	labelAction.labelId = labelDef.id;
              this.changeFormObjectIntegrationComponents( labelAction, labelDef );
            	break;
            }
        }
    },
    clearFormLabelsByLabelId: function( labelId ) {
    	var formTemplate = this.attributes.form.template;
        var rows = formTemplate.rows;

        mainLoop: for ( var i = 0; i < rows.length; i++ ) {
            var row = rows[i];
            var items = row.items;

            for ( var j = 0; j < items.length; j++ ) {
                var item = items[j];

                if ( item.id == labelId ) {
                    items.splice( j, 1 );

                    if ( Ext.isEmpty( items ) ) {
                        rows.splice( i, 1 );
                    }
                    break mainLoop;
                }
            }
        }
        
        var labelActions = this.attributes.form.labelActions;
        
        for ( var i = 0; i < labelActions.length; i++ ) {
            var labelAction = labelActions[i];
            
            if ( labelAction.labelId == labelId ) {
            	labelActions.splice( i, 1 );
            	break;
            }
        }
    },
    getHttpLinks: function( location ) {
        var result = new Array();
        var httpLinks = this.attributes.form.httpLinks;
        for ( var i = 0; i < httpLinks.length; i++ ) {
            if ( location == httpLinks[i].location ) {
                result.push( httpLinks[i] );
            }
        }
        return result;
    },
    addHttpLink: function( hlDef ) {
        this.attributes.form.httpLinks.push( hlDef );
        Ext.getCmp( 'main_panel' ).setSaved( false );
    },
    loadHttpLinks: function( hlLinks ) {
        this.attributes.form.httpLinks = hlLinks ? hlLinks : new Array();
    },
    getFormButton: function( actionName ) {
        var buttons = this.attributes.form.buttons;
        for ( var i = 0; i < buttons.length; i++ ) {
            if ( actionName == buttons[i].actionName ) {
                return buttons[i];
            }
        }
        return null;
    },
    addFormButton: function( buttonDef ) {
        this.attributes.form.buttons.push( buttonDef );
        Ext.getCmp( 'main_panel' ).setSaved( false );
    },
    loadFormButtons: function( formBtns ) {
        this.attributes.form.buttons = formBtns ? formBtns : new Array();
    },
    removeFormButton: function( actionName ) {
        var buttons = this.attributes.form.buttons;
        for ( var i = 0; i < buttons.length; i++ ) {
            if ( actionName == buttons[i].actionName ) {
                buttons.splice( i, 1 );
                this.updateAcceptanceByButtonName( actionName, '' );
                Ext.getCmp( 'main_panel' ).setSaved( false );
                break;
            }
        }
    },
    clearFormButtonsByVarId: function( varId ) {
        var buttons = this.attributes.form.buttons;
        var newButtons = new Array();
        for ( var i = 0; i < buttons.length; i++ ) {
            var button = buttons[i];
            if ( button.genre == 'ACTION_ACCEPT_BUTTON' ) {
                var actions = button.actions;
                for ( var j = 0; j < actions.length; j++ ) {
                    var attributions = actions[j].attributions;
                    for ( var k = 0; k < attributions.length; k++ ) {
                        if ( attributions[k].varId == varId ) {
                            attributions.splice( k, 1 );
                            break;
                        }
                    }
                    if ( Ext.isEmpty( attributions ) ) {
                        actions.splice( j, 1 );
                        j--;
                    } else {
                        var conditions = actions[j].conditions;
                        for ( var k = 0; k < conditions.length; k++ ) {
                            if ( conditions[k].varId == varId ) {
                                conditions.splice( k, 1 );
                                break;
                            }
                        }
                    }
                }
                var dcIncludes = button.dcIncludes;
                for ( var j = 0; j < dcIncludes.length; j++ ) {
                    if ( dcIncludes[j].dataChooserId == varId ) {
                        dcIncludes.splice( j, 1 );
                        break;
                    }
                }
                var dcExcludes = button.dcExcludes;
                for ( var j = 0; j < dcExcludes.length; j++ ) {
                    if ( dcExcludes[j].dataChooserId == varId ) {
                        dcExcludes.splice( j, 1 );
                        break;
                    }
                }
                newButtons.push( button );
            } else if ( button.genre == 'BARCODE_PRINT' ) {
                if ( button.labelTextVar != varId ) {
                    newButtons.push( button );
                }
            } else {
                newButtons.push( button );
            }
        }

        buttons.splice( 0, buttons.length );
        this.attributes.form.buttons = newButtons;
    },
    moveFormButton: function( sindex, dindex ) {
        changePlacementInTab( this.attributes.form.buttons, sindex, dindex );
        Ext.getCmp( 'main_panel' ).setSaved( false );
    },
    changeFormButton: function( oldVarId, newVarId ) {
        if ( oldVarId == newVarId ) {
            return;
        }

        var buttons = this.attributes.form.buttons;
        for ( var i = 0; i < buttons.length; i++ ) {
            var button = buttons[i];
            if ( button.genre == 'ACTION_ACCEPT_BUTTON' ) {
                var actions = button.actions;
                for ( var j = 0; j < actions.length; j++ ) {
                    var attributions = actions[j].attributions;
                    for ( var k = 0; k < attributions.length; k++ ) {
                        if ( attributions[k].varId == oldVarId ) {
                            attributions[k].varId = newVarId;
                        }
                    }
                    var conditions = actions[j].conditions;
                    for ( var k = 0; k < conditions.length; k++ ) {
                        if ( conditions[k].varId == oldVarId ) {
                            conditions[k].varId = newVarId;
                        }
                    }
                }
                var dcIncludes = button.dcIncludes;
                for ( var j = 0; j < dcIncludes.length; j++ ) {
                    if ( dcIncludes[j].dataChooserId == oldVarId ) {
                        dcIncludes[j].dataChooserId = newVarId;
                    }
                }
                var dcExcludes = button.dcExcludes;
                for ( var j = 0; j < dcExcludes.length; j++ ) {
                    if ( dcExcludes[j].dataChooserId == oldVarId ) {
                        dcExcludes[j].dataChooserId = newVarId;
                    }
                }
                Ext.ux.suncode.IntegrationComponentService.changeByVariableId( button.validators, oldVarId, newVarId );
                var oldValidators = button.oldValidators;
                for ( var j = 0; j < oldValidators.length; j++ ) {
                    var parameters = oldValidators[j].parameters;
                    for ( var k = 0; k < parameters.length; k++ ) {
                        if ( parameters[k].id == oldVarId ) {
                            parameters[k].id = newVarId;
                        }
                    }
                }
                Ext.ux.suncode.IntegrationComponentService.changeByVariableId( button.variablesSetters, oldVarId, newVarId );
                var oldVariablesSetters = button.oldVariablesSetters;
                for ( var j = 0; j < oldVariablesSetters.length; j++ ) {
                    var parameters = oldVariablesSetters[j].parameters;
                    for ( var k = 0; k < parameters.length; k++ ) {
                        if ( parameters[k].id == oldVarId ) {
                            parameters[k].id = newVarId;
                        }
                    }
                }
            } else if ( button.genre == 'BARCODE_PRINT' ) {
                if ( button.labelTextVar == oldVarId ) {
                    button.labelTextVar = newVarId;
                }
            }
        }
    },
    loadLabelActions: function( labelActions ) {
        this.attributes.form.labelActions = labelActions ? labelActions : new Array();
    },
    getFormFormActions: function() {
    	return this.attributes.form.actions;
    },
    loadFormFormActions: function( formFormActions ) {
        this.attributes.form.actions = formFormActions ? formFormActions : new Array();
    },
    changeFormAction: function( oldVarId, newVarId ) {
      Ext.ux.suncode.IntegrationComponentService.changeByVariableId( this.attributes.form.actions, oldVarId, newVarId );
      var variables = this.attributes.form.variables;
      this.changeElementsComponentsById( variables, 'formActions', oldVarId, newVarId );
      this.changeElementsComponentsById( this.attributes.form.httpLinks, 'formActions', oldVarId, newVarId );
      this.changeElementsComponentsById( this.attributes.form.buttons, 'formActions', oldVarId, newVarId );
      this.changeElementsComponentsById( this.attributes.form.labelActions, 'formActions', oldVarId, newVarId );

      for ( var i = 0; i < variables.length; i++ ) {
        var variable = variables[i];

        if ( variable.genre == 'VARIABLE_SET') {
          this.changeElementsComponentsById( variable.DTButtons, 'formActions', oldVarId, newVarId );
        }
      }
    },
    changeEventAction: function( oldVarId, newVarId ) {
      Ext.ux.suncode.IntegrationComponentService.changeByVariableId( this.attributes.form.events, oldVarId, newVarId );
      var variables = this.attributes.form.variables;
      this.changeElementsComponentsById( variables, 'eventActions', oldVarId, newVarId );
      this.changeElementsComponentsById( this.attributes.form.httpLinks, 'eventActions', oldVarId, newVarId );
      this.changeElementsComponentsById( this.attributes.form.buttons, 'eventActions', oldVarId, newVarId );

      for ( var i = 0; i < variables.length; i++ ) {
        var variable = variables[i];

        if ( variable.genre == 'VARIABLE_SET') {
          this.changeElementsComponentsById( variable.DTButtons, 'eventActions', oldVarId, newVarId );
        }
      }
    },
    changeElementsComponentsById: function( elements, componentName, oldVarId, newVarId ) {
      for ( var i = 0; i < elements.length; i++ ) {
        var element = elements[i];
        var components = element[componentName];

        if ( !Ext.isEmpty( components ) ) {
          Ext.ux.suncode.IntegrationComponentService.changeByVariableId( components, oldVarId, newVarId );
        }
      }
    },
    getFormEventActions: function() {
      return this.attributes.form.events;
    },
    loadFormEventActions: function( formEventActions ) {
      this.attributes.form.events = formEventActions ? formEventActions : new Array();
    },
    clearActionAcceptButtonForwardTo: function( forwardTo ) {
        var buttons = this.attributes.form.buttons;
        for ( var i = 0; i < buttons.length; i++ ) {
            if ( forwardTo == buttons[i].forwardTo ) {
                buttons[i].forwardTo = '';
                break;
            }
        }
    },
    removeFormButtonDCValidationForVarId: function( varId ) {
        var buttons = this.attributes.form.buttons;
        for ( var i = 0; i < buttons.length; i++ ) {
            var button = buttons[i];
            if ( button.genre == 'ACTION_ACCEPT_BUTTON' ) {
                var dcIncludes = button.dcIncludes;
                for ( var j = 0; j < dcIncludes.length; j++ ) {
                    if ( dcIncludes[j].dataChooserId == varId ) {
                        dcIncludes.splice( j, 1 );
                        break;
                    }
                }
                var dcExcludes = button.dcExcludes;
                for ( var j = 0; j < dcExcludes.length; j++ ) {
                    if ( dcExcludes[j].dataChooserId == varId ) {
                        dcExcludes.splice( j, 1 );
                        break;
                    }
                }
            }
        }
    },
    getApplicationByIndex: function( index ) {
        return this.attributes.applications[index];
    },
    addApplication: function( appObj ) {
        this.attributes.applications.push( appObj );
        Ext.getCmp( 'main_panel' ).setSaved( false );
    },
    loadApplications: function( apps ) {
        this.attributes.applications = apps ? apps : new Array();
    },
    removeApplication: function( appId ) {
        var newApplications = new Array();
        var applications = this.attributes.applications;
        for ( var i = 0; i < applications.length; i++ ) {
            var application = applications[i];
            if ( appId != application.id ) {
                newApplications.push( application );
            }
        }

        applications.splice( 0, applications.length );
        this.attributes.applications = newApplications;
    },
    removeApplicationByIndex: function( index ) {
        this.attributes.applications.splice( index, 1 );
        Ext.getCmp( 'main_panel' ).setSaved( false );
    },
    clearApplicationsByVarId: function( varId ) {
        var applications = this.attributes.applications;
        for ( var i = 0; i < applications.length; i++ ) {
        	var application = applications[i];
        	
        	if ( !application.integrationComponent ) {
        		var parameters = application.parameters;
                for ( var j = 0; j < parameters.length; j++ ) {
                    var parameter = parameters[j];
                    if ( varId == parameter.varId ) {
                        parameter.varId = '';
                        break;
                    }
                }
        	}
        }
    },
    updateApplicationByIndex: function( index, appObj ) {
        this.attributes.applications[index] = appObj;
        Ext.getCmp( 'main_panel' ).setSaved( false );
    },
    updateApplicationDefinition: function( oldAppId, appObj ) {
        var applications = this.attributes.applications;
        for ( var i = 0; i < applications.length; i++ ) {
            if ( oldAppId == applications[i].id ) {
                applications[i].id = appObj.id;
                applications[i].name = appObj.name;
                applications[i].appType = appObj.appType;
                Ext.getCmp( 'main_panel' ).setSaved( false );
            }
        }
    },
    updateApplicationInactiveByIndex: function( index, inactive ) {
    	this.attributes.applications[index].inactive = inactive;
        Ext.getCmp( 'main_panel' ).setSaved( false );
    },
    moveApplication: function( sindex, dindex ) {
    	changePlacementInTab( this.attributes.applications, sindex, dindex );
        Ext.getCmp( 'main_panel' ).setSaved( false );
    },
    changeApplicationParam: function( oldVarId, newVarId ) {
        if ( oldVarId == newVarId ) {
            return;
        }

        var applications = this.attributes.applications;
        for ( var i = 0; i < applications.length; i++ ) {
        	var application = applications[i];
        	
        	if ( application.integrationComponent ) {
        		Ext.ux.suncode.IntegrationComponentService.changeComponentByVariableId( application, oldVarId, newVarId );
        	} else if ( !Ext.isEmpty( application.parameters ) ) {
        		var parameters = application.parameters;
                for ( var j = 0; j < parameters.length; j++ ) {
                    var parameter = parameters[j];
                    if ( oldVarId == parameter.varId ) {
                        parameter.varId = newVarId;
                        break;
                    }
                }
        	}
        }
    },
    findDeadline: function( exceptionName ) {
        var deadlines = this.attributes.deadlines;
        for ( var i = 0; i < deadlines.length; i++ ) {
            if ( exceptionName == deadlines[i].exceptionName ) {
                return deadlines[i];
            }
        }
        return null;
    },
    addDeadline: function( deadlineObj ) {
        this.attributes.deadlines.push( deadlineObj );
        Ext.getCmp( 'main_panel' ).setSaved( false );
    },
    loadDeadlines: function( deadlines ) {
        this.attributes.deadlines = deadlines ? deadlines : new Array();
    },
    removeDeadline: function( exceptionName ) {
        var deadlines = this.attributes.deadlines;
        for ( var i = 0; i < deadlines.length; i++ ) {
            if ( exceptionName == deadlines[i].exceptionName ) {
                this.removeDeadlineTransitionByExceptionName( exceptionName );
                deadlines.splice( i, 1 );
                Ext.getCmp( 'main_panel' ).setSaved( false );
                break;
            }
        }
    },
    removeDeadlinesByVarId: function( varId ) {
        var newDeadlines = new Array();
        var removedDeadlines = new Array();
        var deadlines = this.attributes.deadlines;
        for ( var i = 0; i < deadlines.length; i++ ) {
            if ( varId != deadlines[i].varId ) {
                newDeadlines.push( deadlines[i] );
            } else {
                removedDeadlines.push( deadlines[i] );
            }
        }
        deadlines.splice( 0, deadlines.length );
        this.attributes.deadlines = newDeadlines;

        for ( var i = 0; i < removedDeadlines.length; i++ ) {
            this.removeDeadlineTransitionByExceptionName( removedDeadlines[i].exceptionName );
        }
    },
    updateDeadline: function( oldExceptionName, deadlineObj ) {
        var deadlines = this.attributes.deadlines;
        for ( var i = 0; i < deadlines.length; i++ ) {
            if ( oldExceptionName == deadlines[i].exceptionName ) {
                deadlines[i] = deadlineObj;
                this.updateDeadlineTransitionExceptionName( oldExceptionName, deadlineObj.exceptionName );
                Ext.getCmp( 'main_panel' ).setSaved( false );
                break;
            }
        }
    },
    changeDeadline: function( oldVarId, newVarId ) {
        var deadlines = this.attributes.deadlines;
        for ( var i = 0; i < deadlines.length; i++ ) {
            if ( oldVarId == deadlines[i].varId ) {
                deadlines[i].varId = newVarId;
            }
        }
    },
    validateSynchronousDeadlines: function( update, exceptionName ) {
        var deadlines = this.attributes.deadlines;
        for ( var i = 0; i < deadlines.length; i++ ) {
            var deadline = deadlines[i];
            if ( ( !update && deadline.execution == 'SYNCHR' )
                            || ( update && deadline.execution == 'SYNCHR' && deadline.exceptionName != exceptionName ) ) {
                return false;
            }
        }
        return true;
    },
    findAcceptance: function( id ) {
        var acceptances = this.attributes.acceptances;
        for ( var i = 0; i < acceptances.length; i++ ) {
            if ( id == acceptances[i].id ) {
                return acceptances[i];
            }
        }
        return null;
    },
    addAcceptance: function( acceptanceObj ) {
        this.attributes.acceptances.push( acceptanceObj );
        Ext.getCmp( 'main_panel' ).setSaved( false );
    },
    loadAcceptances: function( acceptances ) {
        this.attributes.acceptances = acceptances ? acceptances : new Array();
    },
    removeAcceptance: function( id ) {
        var acceptances = this.attributes.acceptances;
        for ( var i = 0; i < acceptances.length; i++ ) {
            if ( id == acceptances[i].id ) {
                acceptances.splice( i, 1 );
                Ext.getCmp( 'main_panel' ).setSaved( false );
                break;
            }
        }
    },
    removeAcceptancesByVarId: function( varId ) {
        var newAcceptances = new Array();
        var acceptances = this.attributes.acceptances;
        for ( var i = 0; i < acceptances.length; i++ ) {
            var acceptance = acceptances[i];

            if ( varId != acceptance.acceptVar && varId != acceptance.checkVar && varId != acceptance.resultVar ) {
                newAcceptances.push( acceptance );
            }
        }
        acceptances.splice( 0, acceptances.length );
        this.attributes.acceptances = newAcceptances;
    },
    updateAcceptance: function( oldId, acceptanceObj ) {
        var acceptances = this.attributes.acceptances;
        for ( var i = 0; i < acceptances.length; i++ ) {
            if ( oldId == acceptances[i].id ) {
                acceptances[i] = acceptanceObj;
                Ext.getCmp( 'main_panel' ).setSaved( false );
                break;
            }
        }
    },
    updateAcceptanceByButtonName: function( oldButtonName, newButtonName ) {
        var acceptances = this.attributes.acceptances;
        for ( var i = 0; i < acceptances.length; i++ ) {
            if ( oldButtonName == acceptances[i].buttonName ) {
                acceptances[i].buttonName = newButtonName;
                break;
            }
        }
    },
    changeAcceptance: function( oldVarId, newVarId ) {
        var acceptances = this.attributes.acceptances;
        for ( var i = 0; i < acceptances.length; i++ ) {
            var acceptance = acceptances[i];

            if ( oldVarId == acceptance.acceptVar ) {
                acceptance.acceptVar = newVarId;
            }
            if ( oldVarId == acceptance.checkVar ) {
                acceptance.checkVar = newVarId;
            }
            if ( oldVarId == acceptance.resultVar ) {
                acceptance.resultVar = newVarId;
            }
        }
    },
    validateGlobalAcceptance: function( update, id ) {
    	var acceptances = this.attributes.acceptances;
        for ( var i = 0; i < acceptances.length; i++ ) {
            var acceptance = acceptances[i];
            if ( ( !update && Ext.isEmpty( acceptance.buttonName ) )
                            || ( update && Ext.isEmpty( acceptance.buttonName ) && acceptance.id != id ) ) {
                return false;
            }
        }
        return true;
    },
    validateButtonAcceptance: function( update, id, buttonName ) {
    	var acceptances = this.attributes.acceptances;
        for ( var i = 0; i < acceptances.length; i++ ) {
            var acceptance = acceptances[i];
            if ( ( !update && acceptance.buttonName === buttonName )
                            || ( update && acceptance.buttonName === buttonName && acceptance.id != id ) ) {
                return false;
            }
        }
        return true;
    },
    addBasicTransition: function( transition ) {
        this.attributes.transitions.basic.push( transition );
        Ext.getCmp( 'main_panel' ).setSaved( false );
    },
    updateBasicTransition: function( transition ) {
        var basicTrs = this.attributes.transitions.basic;
        var transitionId = transition.id;
        for ( var i = 0; i < basicTrs.length; i++ ) {
            if ( transitionId == basicTrs[i].id ) {
                basicTrs[i] = transition;
                Ext.getCmp( 'main_panel' ).setSaved( false );
                break;
            }
        }
    },
    updateBasicTransitionPaths: function( transition ) {
        var basicTrs = this.attributes.transitions.basic;
        var transitionId = transition.id;
        for ( var i = 0; i < basicTrs.length; i++ ) {
            var basicTr = basicTrs[i];
            if ( transitionId == basicTr.id ) {
                basicTr.linePaths = transition.linePaths;
                break;
            }
        }
    },
    updateBasicTransitionTo: function( transition ) {
        var basicTrs = this.attributes.transitions.basic;
        var transitionId = transition.id;
        for ( var i = 0; i < basicTrs.length; i++ ) {
            var basicTr = basicTrs[i];
            if ( transitionId == basicTr.id ) {
                basicTr.to = transition.to;
                break;
            }
        }
    },
    removeBasicTransition: function( transitionId ) {
        var basicTrs = this.attributes.transitions.basic;
        for ( var i = 0; i < basicTrs.length; i++ ) {
            if ( transitionId == basicTrs[i].id ) {
                this.removeNextActivityById( basicTrs[i].to );
                basicTrs.splice( i, 1 );
                Ext.getCmp( 'main_panel' ).setSaved( false );
                break;
            }
        }
    },
    addCondTransition: function( transition ) {
        this.attributes.transitions.cond.push( transition );
        this.attributes.transitionRestriction.split = transition.condType;
        Ext.getCmp( 'main_panel' ).setSaved( false );
    },
    updateCondTransitionLinePathsWithDir: function( transition ) {
        var condTrs = this.attributes.transitions.cond;
        var transitionId = transition.id;
        for ( var i = 0; i < condTrs.length; i++ ) {
            var conn = condTrs[i];
            if ( transitionId == conn.id ) {
                conn.linePaths = transition.linePaths;
                conn.secondLineDirection = transition.secondLineDirection;
                break;
            }
        }
    },
    updateCondTransitionLinePaths: function( transition ) {
        var condTrs = this.attributes.transitions.cond;
        var transitionId = transition.id;
        for ( var i = 0; i < condTrs.length; i++ ) {
            var conn = condTrs[i];
            if ( transitionId == conn.id ) {
                conn.linePaths = transition.linePaths;
                break;
            }
        }
    },
    updateCondTransitionBoxPaths: function( transition ) {
        var condTrs = this.attributes.transitions.cond;
        var transitionId = transition.id;
        for ( var i = 0; i < condTrs.length; i++ ) {
            var conn = condTrs[i];
            if ( transitionId == conn.id ) {
                conn.boxPaths = transition.boxPaths;
                break;
            }
        }
    },
    updateCondTransitionBoxInfo: function( transition ) {
        var condTrs = this.attributes.transitions.cond;
        var transitionId = transition.id;
        for ( var i = 0; i < condTrs.length; i++ ) {
            var conn = condTrs[i];
            if ( transitionId == conn.id ) {
                conn.x = transition.x;
                conn.y = transition.y;
                conn.firstLineDirection = transition.firstLineDirection;
                conn.boxDirection = transition.boxDirection;
                conn.boxPaths = transition.boxPaths;
                break;
            }
        }
    },
    updateCondTransitionTo: function( transition ) {
        var condTrs = this.attributes.transitions.cond;
        var transitionId = transition.id;
        for ( var i = 0; i < condTrs.length; i++ ) {
            var conn = condTrs[i];
            if ( transitionId == conn.id ) {
                conn.to = transition.to;
                break;
            }
        }
    },
    updateCondTransitionCondition: function( transition ) {
        var condTrs = this.attributes.transitions.cond;
        var transitionId = transition.id;
        for ( var i = 0; i < condTrs.length; i++ ) {
            var conn = condTrs[i];
            if ( transitionId == conn.id ) {
                conn.condition = transition.condition;
                Ext.getCmp( 'main_panel' ).setSaved( false );
                break;
            }
        }
    },
    resetForwardToCondTransitionConditions: function( actionName, transitionId ) {
        var condTrs = this.attributes.transitions.cond;
        var anyChange = false;
        for ( var i = 0; i < condTrs.length; i++ ) {
            var conn = condTrs[i];

            if ( transitionId == conn.id ) {
                if ( conn.condition == 'Action==\'' + actionName + '\'' ) {
                    conn.condition = '';
                    anyChange = true;
                } else if( conn.condition.includes( ' || Action==\'' + actionName + '\'' ) ) {
                    conn.condition = conn.condition.replaceAll( ' || Action==\'' + actionName + '\'', '' );
                    anyChange = true;
                }
            }
        }
        
        if ( anyChange ) {
        	Ext.getCmp( 'main_panel' ).setSaved( false );
        }
    },
    changeCondTransitionCondition: function( oldVarId, newVarId ) {
        if ( oldVarId == newVarId ) {
            return;
        }

        var condTrs = this.attributes.transitions.cond;
        for ( var i = 0; i < condTrs.length; i++ ) {
            var condition = condTrs[i].condition;

            if ( !isCustomTransitionCondition( condition ) ) {
                var conditionsTable = createTransitionConditionsTable( condition );

                for ( var j = 0; j < conditionsTable.length; j++ ) {
                    if ( conditionsTable[j].varId == oldVarId ) {
                        conditionsTable[j].varId = newVarId;
                    }
                }

                condTrs[i].condition = createTransitionConditionsText( conditionsTable );
            }
        }
    },
    updateCondTransitionType: function( transition ) {
        var condTrs = this.attributes.transitions.cond;
        var transitionId = transition.id;
        for ( var i = 0; i < condTrs.length; i++ ) {
            var conn = condTrs[i];
            if ( transitionId == conn.id ) {
                conn.condType = transition.condType;
                Ext.getCmp( 'main_panel' ).setSaved( false );
                break;
            }
        }
    },
    changeCondTransitionsOrder: function( sindex, dindex ) {
        changePlacementInTab( this.attributes.transitions.cond, sindex, dindex );
        Ext.getCmp( 'main_panel' ).setSaved( false );
    },
    getCondTransitionCondition: function( transitionId ) {
        var condTrs = this.attributes.transitions.cond;
        for ( var i = 0; i < condTrs.length; i++ ) {
            var conn = condTrs[i];
            if ( transitionId == conn.id ) {
                return conn.condition;
            }
        }
        return '';
    },
    removeCondTransition: function( transitionId ) {
        var condTrs = this.attributes.transitions.cond;
        for ( var i = 0; i < condTrs.length; i++ ) {
            if ( transitionId == condTrs[i].id ) {
                this.removeNextActivityById( condTrs[i].to );
                condTrs.splice( i, 1 );
                Ext.getCmp( 'main_panel' ).setSaved( false );
                break;
            }
        }
    },
    addOtherwiseTransition: function( transition ) {
        this.attributes.transitions.otherwise.push( transition );
        Ext.getCmp( 'main_panel' ).setSaved( false );
    },
    updateOtherwiseTransition: function( transition ) {
        var otherwiseTrs = this.attributes.transitions.otherwise;
        var transitionId = transition.id;
        for ( var i = 0; i < otherwiseTrs.length; i++ ) {
            if ( transitionId == otherwiseTrs[i].id ) {
                otherwiseTrs[i] = transition;
                Ext.getCmp( 'main_panel' ).setSaved( false );
                break;
            }
        }
    },
    updateOtherwiseTransitionPaths: function( transition ) {
        var otherwiseTrs = this.attributes.transitions.otherwise;
        var transitionId = transition.id;
        for ( var i = 0; i < otherwiseTrs.length; i++ ) {
            var otherwiseTr = otherwiseTrs[i];
            if ( transitionId == otherwiseTr.id ) {
                otherwiseTr.linePaths = transition.linePaths;
                break;
            }
        }
    },
    updateOtherwiseTransitionTo: function( transition ) {
        var otherwiseTrs = this.attributes.transitions.otherwise;
        var transitionId = transition.id;
        for ( var i = 0; i < otherwiseTrs.length; i++ ) {
            var otherwiseTr = otherwiseTrs[i];
            if ( transitionId == otherwiseTr.id ) {
                otherwiseTr.to = transition.to;
                break;
            }
        }
    },
    removeOtherwiseTransition: function( transitionId ) {
        var otherwiseTrs = this.attributes.transitions.otherwise;
        for ( var i = 0; i < otherwiseTrs.length; i++ ) {
            if ( transitionId == otherwiseTrs[i].id ) {
                otherwiseTrs.splice( i, 1 );
                Ext.getCmp( 'main_panel' ).setSaved( false );
                break;
            }
        }
    },
    findDeadlineTransition: function( transitionId ) {
        var exceptionTrs = this.attributes.transitions.exception;
        for ( var i = 0; i < exceptionTrs.length; i++ ) {
            if ( transitionId == exceptionTrs[i].id ) {
                return exceptionTrs[i];
            }
        }
        return null;
    },
    addDeadlineTransition: function( transition ) {
        this.attributes.transitions.exception.push( transition );
        Ext.getCmp( 'main_panel' ).setSaved( false );
    },
    updateDeadlineTransition: function( transition ) {
        var exceptionTrs = this.attributes.transitions.exception;
        var transitionId = transition.id;
        for ( var i = 0; i < exceptionTrs.length; i++ ) {
            if ( transitionId == exceptionTrs[i].id ) {
                transition = Ext.apply( {
                    exceptionName: exceptionTrs[i].exceptionName
                }, transition );
                exceptionTrs[i] = transition;
                Ext.getCmp( 'main_panel' ).setSaved( false );
                break;
            }
        }
    },
    updateDeadlineTransitionPaths: function( transition ) {
        var exceptionTrs = this.attributes.transitions.exception;
        var transitionId = transition.id;
        for ( var i = 0; i < exceptionTrs.length; i++ ) {
            var exceptionTr = exceptionTrs[i];
            if ( transitionId == exceptionTr.id ) {
                exceptionTr.linePaths = transition.linePaths;
                break;
            }
        }
    },
    updateDeadlineTransitionTo: function( transition ) {
        var exceptionTrs = this.attributes.transitions.exception;
        var transitionId = transition.id;
        for ( var i = 0; i < exceptionTrs.length; i++ ) {
            var exceptionTr = exceptionTrs[i];
            if ( transitionId == exceptionTr.id ) {
                exceptionTr.to = transition.to;
                break;
            }
        }
    },
    updateDeadlineTransitionExceptionName: function( oldExceptionName, newExceptionName ) {
        var exceptionTrs = this.attributes.transitions.exception;
        for ( var i = 0; i < exceptionTrs.length; i++ ) {
            if ( oldExceptionName == exceptionTrs[i].exceptionName ) {
                exceptionTrs[i].exceptionName = newExceptionName;
            }
        }
    },
    removeDeadlineTransition: function( transitionId ) {
        var exceptionTrs = this.attributes.transitions.exception;
        for ( var i = 0; i < exceptionTrs.length; i++ ) {
            if ( transitionId == exceptionTrs[i].id ) {
                exceptionTrs.splice( i, 1 );
                Ext.getCmp( 'main_panel' ).setSaved( false );
                break;
            }
        }
    },
    removeDeadlineTransitionByExceptionName: function( exceptionName ) {
        var exceptionTrs = this.attributes.transitions.exception;
        var deadlines = this.attributes.deadlines;

        var paper = Ext.getCmp( 'paper_panel' ).getActiveTab().paper;
        var set = paper.bpmn.findMapObjectElements( paper, 'activityDefId', this.attributes.activityDefId );
        var connector = paper.bpmn.getConnectorFromSet( set );
        var exceptionToDelete = null;
        var foundByExceptionName = false;

        for ( var i = 0; i < exceptionTrs.length; i++ ) {
            var exceptionTr = exceptionTrs[i];
            if ( exceptionName == exceptionTr.exceptionName ) {
                exceptionToDelete = exceptionTr;
                foundByExceptionName = true;
                break;
            } else {
                exceptionToDelete = exceptionTr;
            }
        }

        if ( exceptionToDelete && ( foundByExceptionName || ( !foundByExceptionName && exceptionTrs.length >= deadlines.length ) ) ) {
            deleteDeadlineLine( {
                connector: connector,
                transitionId: exceptionToDelete.id
            } );
        }
    },
    setDeadlineTransitionExceptionName: function( transitionId, exceptionName ) {
        var exceptionTrs = this.attributes.transitions.exception;
        for ( var i = 0; i < exceptionTrs.length; i++ ) {
            var exceptionTr = exceptionTrs[i];
            if ( transitionId == exceptionTr.id ) {
                exceptionTr.exceptionName = exceptionName;
                Ext.getCmp( 'main_panel' ).setSaved( false );
                break;
            }
        }
    },
    validateDeadlineTransitionsExceptionName: function( transitionId, exceptionName ) {
        var exceptionTrs = this.attributes.transitions.exception;
        for ( var i = 0; i < exceptionTrs.length; i++ ) {
            var exceptionTr = exceptionTrs[i];
            if ( exceptionName == exceptionTr.exceptionName && transitionId != exceptionTr.id ) {
                return false;
            }
        }
        return true;
    },
    incrementIncomingTransitions: function() {
        this.attributes.transitions.incoming++;
    },
    decrementIncomingTransitions: function() {
        this.attributes.transitions.incoming--;
    },
    updateActivityLocation: function( x, y ) {
        this.attributes.xOffset = x;
        this.attributes.yOffset = y;
    },
    updateSubflowInfo: function( subflow ) {
        this.attributes.subflow = subflow;
    },
    changeSubflowId: function( oldSubflowId, newSubflowId ) {
        if ( this.attributes.activityType == Ext.ux.suncode.Constants.SUBFLOW ) {
            if ( this.attributes.subflow.id == oldSubflowId ) {
                this.attributes.subflow.id = newSubflowId;
            }
        }
    },
    changeSubflowParam: function( oldActualParamId, newActualParamId ) {
        if ( this.attributes.activityType == Ext.ux.suncode.Constants.SUBFLOW ) {
            var actualParameters = this.attributes.subflow.params;
            for ( var i = 0; i < actualParameters.length; i++ ) {
                var p = actualParameters[i];
                if ( p.actualParam == oldActualParamId ) {
                    p.actualParam = newActualParamId;
                    break;
                }
            }
        }
    },
    removeSubflowParamByIndex: function( index ) {
        this.attributes.subflow.params.splice( index, 1 );
    },
    updateNextActivity: function( oldActivityDefId, newActivityDefId ) {
        var acceptedNextActivities = this.attributes.acceptedNextActivities;
        for ( var i = 0; i < acceptedNextActivities.length; i++ ) {
            if ( acceptedNextActivities[i].activityDefId == oldActivityDefId ) {
                acceptedNextActivities[i].activityDefId = newActivityDefId;
                break;
            }
        }
    },
    removeNextActivityById: function( activityDefId ) {
        var acceptedNextActivities = this.attributes.acceptedNextActivities;
        for ( var i = 0; i < acceptedNextActivities.length; i++ ) {
            if ( acceptedNextActivities[i].activityDefId == activityDefId ) {
                acceptedNextActivities.splice( i, 1 );
                break;
            }
        }
    },
    resetRoleUsersFormVariable: function( roleId ) {
        var variables = this.attributes.form.variables;
        for ( var i = 0; i < variables.length; i++ ) {
            var variable = variables[i];
            if ( !Ext.isEmpty( variable.role ) && variable.role == roleId ) {
                variable.role = '';
            }
        }
    },
    loadAdditionals: function( additionals ) {
        this.attributes.additionals = additionals;
    },
    setAdditional: function( name, value ) {
        this.attributes.additionals[name] = value;
    },
    clearAdditionalsByVarId: function( varId ) {
        var defaults = this.attributes.additionals.defaults;
        for ( var i = 0; i < defaults.length; i++ ) {
            if ( defaults[i].varId == varId ) {
                defaults.splice( i, 1 );
                break;
            }
        }

        var extraDataChooserConfigs = this.attributes.additionals.extraDataChooserConfigs;
        for ( var i = 0; i < extraDataChooserConfigs.length; i++ ) {
            if ( extraDataChooserConfigs[i].dataChooserId == varId ) {
                extraDataChooserConfigs.splice( i, 1 );
                break;
            }
        }
    },
    changeAdditionals: function( oldVarId, newVarId ) {
        var defaults = this.attributes.additionals.defaults;
        for ( var i = 0; i < defaults.length; i++ ) {
            if ( defaults[i].varId == oldVarId ) {
                defaults[i].varId = newVarId;
            }
        }

        var extraDataChooserConfigs = this.attributes.additionals.extraDataChooserConfigs;
        for ( var i = 0; i < extraDataChooserConfigs.length; i++ ) {
            if ( extraDataChooserConfigs[i].dataChooserId == oldVarId ) {
                extraDataChooserConfigs[i].dataChooserId = newVarId;
            }
        }
    },
    setAssignmentByAcceptance: function( acceptance ) {
        this.attributes.assignment = Ext.apply( this.attributes.assignment, {
            type: 'newAssignment',
            value: acceptance.checkVar,
            exception: acceptance.acceptVar
        } );
    },
    removeTemplate: function( templates, templateId ) {
        for ( var i = 0; i < templates.length; i++ ) {
            if ( templateId == templates[i].id ) {
            	templates.splice( i, 1 );
                Ext.getCmp( 'main_panel' ).setSaved( false );
                break;
            }
        }
    },
    loadValidatorsTemplates: function( templates ) {
    	this.attributes.templates.validators = templates ? templates : new Array();
    },
    findMergedValidatorsTemplates: function( templates ) {
    	var validatorsTemplates = new Array();
        var processNode = this.parentNode;
        for ( var i = 0; i < templates.length; i++ ) {
        	var template = templates[i];
        	var processTemplate = processNode.findValidatorsTemplate( template.id );
        	if ( !Ext.isEmpty( processTemplate ) ) {
        		var mergedTemplate = Ext.ux.suncode.IntegrationComponentService.mergeTemplates(
        				processTemplate, template );
        		validatorsTemplates.push( mergedTemplate );
        	}
        }
        return validatorsTemplates;
    },
    addValidatorsTemplate: function( template ) {
    	this.attributes.templates.validators.push( template );
        Ext.getCmp( 'main_panel' ).setSaved( false );
    },
    removeValidatorsTemplate: function( templateId ) {
    	this.removeTemplate( this.attributes.templates.validators, templateId );
    },
    findValidatorsTemplateUtilization: function( templateId ) {
    	var utilization = new Array();
    	
    	Ext.each( this.attributes.templates.validators, function( validator, index, validators ) {
    		if ( validator.id == templateId ) {
    			var button = this.getFormButton( validator.action );
    			
    			if ( !Ext.isEmpty( button ) ) {
	    			utilization.push( {
	    				activityName: this.attributes.activityName,
	    				buttonName: button.buttonName
	    			} );
    			}
    		}
    	}, this );
    	
    	return utilization;
    },
    loadVariablesSettersTemplates: function( templates ) {
    	this.attributes.templates.variablesSetters = templates ? templates : new Array();
    },
    findMergedVariablesSettersTemplates: function( templates ) {
    	var variablesSettersTemplates = new Array();
        var processNode = this.parentNode;
        for ( var i = 0; i < templates.length; i++ ) {
        	var template = templates[i];
        	var processTemplate = processNode.findVariablesSettersTemplate( template.id );
        	if ( !Ext.isEmpty( processTemplate ) ) {
        		var mergedTemplate = Ext.ux.suncode.IntegrationComponentService.mergeTemplates(
        				processTemplate, template );
        		variablesSettersTemplates.push( mergedTemplate );
        	}
        }
        return variablesSettersTemplates;
    },
    addVariablesSettersTemplate: function( template ) {
    	this.attributes.templates.variablesSetters.push( template );
        Ext.getCmp( 'main_panel' ).setSaved( false );
    },
    removeVariablesSettersTemplate: function( templateId ) {
    	this.removeTemplate( this.attributes.templates.variablesSetters, templateId );
    },
    findVariablesSettersTemplateUtilization: function( templateId ) {
    	var utilization = new Array();
    	
    	Ext.each( this.attributes.templates.variablesSetters, function( variablesSetter, index, variablesSetters ) {
    		if ( variablesSetter.id == templateId ) {
    			var button = this.getFormButton( variablesSetter.action );
    			
    			if ( !Ext.isEmpty( button ) ) {
	    			utilization.push( {
	    				activityName: this.attributes.activityName,
	    				buttonName: button.buttonName
	    			} );
    			}
    		}
    	}, this );
    	
    	return utilization;
    },
    setXpdlSubstitution: function( xpdlSubstitution ) {
    	this.attributes.xpdlSubstitution = xpdlSubstitution;
    },
    getXpdlSubstitution: function() {
    	return this.attributes.xpdlSubstitution;
    },
    hasXpdlSubstitution: function() {
    	return !Ext.isEmpty( this.attributes.xpdlSubstitution );
    },
    resetXpdlSubstitution: function() {
    	delete this.attributes.xpdlSubstitution;
    	this.attributes.xpdlSubstitution = null;
    },
    validateVariablesUsage: function() {
      var presentVariableIds = this.getVariableIdsOnForm();
      var variables = this.attributes.form.variables;
      var httpLinks = this.attributes.form.httpLinks;
      var buttons = this.attributes.form.buttons;
      var labelActions = this.attributes.form.labelActions;

      if ( Ext.ux.suncode.IntegrationComponentService.hasVariablesMissingInComponents(
          this.attributes.form.actions, presentVariableIds ) ) {
        return false;
      }

      if ( Ext.ux.suncode.IntegrationComponentService.hasVariablesMissingInComponents(
          this.attributes.form.events, presentVariableIds ) ) {
        return false;
      }

      for ( var i = 0; i < variables.length; i++ ) {
        var variable = variables[i];

        if ( variable.genre == 'VARIABLE'
            && ( Ext.ux.suncode.IntegrationComponentService.hasVariablesMissingInComponents(
                variable.formActions, presentVariableIds )
            || Ext.ux.suncode.IntegrationComponentService.hasVariablesMissingInComponents(
                variable.eventActions, presentVariableIds ) ) ) {
          return false;
        } else if ( variable.genre == 'VARIABLE_SET') {
          if ( Ext.ux.suncode.IntegrationComponentService.hasVariablesMissingInComponents(
              variable.formActions, presentVariableIds )
              || Ext.ux.suncode.IntegrationComponentService.hasVariablesMissingInComponents(
                  variable.eventActions, presentVariableIds )) {
            return false;
          }

          var dtButtons = variable.DTButtons;

          for ( var j = 0; j < dtButtons.length; j++ ) {
            var dtButton = dtButtons[j];

            if ( Ext.ux.suncode.IntegrationComponentService.hasVariablesMissingInComponents(
                dtButton.formActions, presentVariableIds )
              || Ext.ux.suncode.IntegrationComponentService.hasVariablesMissingInComponents(
                    dtButton.eventActions, presentVariableIds )) {
              return false;
            }
          }
        }
      }

      for ( var i = 0; i < httpLinks.length; i++ ) {
        var httpLink = httpLinks[i];

        if ( Ext.ux.suncode.IntegrationComponentService.hasVariablesMissingInComponents(
            httpLink.formActions, presentVariableIds )
          || Ext.ux.suncode.IntegrationComponentService.hasVariablesMissingInComponents(
                httpLink.eventActions, presentVariableIds ) ) {
          return false;
        }
      }

      for ( var i = 0; i < buttons.length; i++ ) {
        var button = buttons[i];

        if ( ( !Ext.isEmpty( button.formActions )
            && Ext.ux.suncode.IntegrationComponentService.hasVariablesMissingInComponents(
                button.formActions, presentVariableIds ) )
          || ( !Ext.isEmpty( button.eventActions )
                && Ext.ux.suncode.IntegrationComponentService.hasVariablesMissingInComponents(
                    button.eventActions, presentVariableIds ) ) ) {
          return false;
        }
      }

      for ( var i = 0; i < labelActions.length; i++ ) {
        var labelAction = labelActions[i];

        if ( Ext.ux.suncode.IntegrationComponentService.hasVariablesMissingInComponents(
            labelAction.formActions, presentVariableIds ) ) {
          return false;
        }
      }

      return true;
    },
    validateVariablesUsageInParameterValue: function( value ) {
      var missingVariables = Ext.ux.suncode.IntegrationComponentService.getVariablesMissingInValue(
          '', value, this.getVariableIdsOnForm() );

      if ( !Ext.isEmpty( missingVariables ) ) {
        showWarn( this.buildVariablesMissingInIntegrationComponentParameterMessage( missingVariables ) );

        return false;
      } else {
        return true;
      }
    },
    buildVariablesMissingInIntegrationComponentParameterMessage: function( missingVariables ) {
      var msg = getTranslation( 'Wartość zawiera zmienne nieistniejące na formularzu' );
      msg += ': ';

      Ext.each( missingVariables, function( variable, index, variables ) {
        msg += '<br>- ';
        msg += variable.variableId;
      } );

      return msg;
    },
    getFormActionsUsingVariable: function( varId ) {
      var components = new Array();
      components = components.concat( this.getObjectIntegrationComponentsUsingVariable(
          this.attributes.form.actions, varId, getTranslation( 'Globalna akcja formularza' ),
          Ext.ux.suncode.IntegrationComponentService.COMPONENT_TYPES.FORM_ACTION ) );
      var processNode = this.parentNode;

      Ext.each( this.attributes.form.variables, function( variable, index, variables ) {
        if ( variable.genre == 'VARIABLE' ) {
          if ( variable.varId !== varId ) {
            var processVariable = processNode.findVariable( variable.varId );
            components = components.concat( this.getObjectIntegrationComponentsUsingVariable(
                variable.formActions, varId,
                getTranslation( 'Akcja formularza na zmiennej formularza' ) + ': ' + processVariable.name,
                Ext.ux.suncode.IntegrationComponentService.COMPONENT_TYPES.FORM_ACTION ) );
          }
        } else if ( variable.genre == 'VARIABLE_SET' ) {
          if ( variable.varId !== varId ) {
            components = components.concat( this.getObjectIntegrationComponentsUsingVariable(
                variable.formActions, varId,
                getTranslation( 'Akcja formularza na tabeli dynamicznej' ) + ': ' + variable.name,
                Ext.ux.suncode.IntegrationComponentService.COMPONENT_TYPES.FORM_ACTION ) );

            if ( !Ext.isEmpty( variable.DTButtons ) ) {
              Ext.each( variable.DTButtons, function( dtButton, dtButtonIndex, dtButtons ) {
                components = components.concat( this.getObjectIntegrationComponentsUsingVariable(
                    dtButton.formActions, varId,
                    getTranslation( 'Akcja formularza na przycisku tabeli dynamicznej' )
                    + ': ' + dtButton.name,
                    Ext.ux.suncode.IntegrationComponentService.COMPONENT_TYPES.FORM_ACTION ) );
              }, this );
            }
          }
        }
      }, this );

      Ext.each( this.attributes.form.httpLinks, function( httpLink, index, httpLinks ) {
        components = components.concat( this.getObjectIntegrationComponentsUsingVariable(
            httpLink.formActions, varId,
            getTranslation( 'Akcja formularza na przycisku' ) + ': ' + httpLink.buttonName,
            Ext.ux.suncode.IntegrationComponentService.COMPONENT_TYPES.FORM_ACTION ) );
      }, this );

      Ext.each( this.attributes.form.buttons, function( button, index, buttons ) {
        if ( button.genre == 'ACTION_ACCEPT_BUTTON' ) {
          components = components.concat( this.getObjectIntegrationComponentsUsingVariable(
              button.formActions, varId,
              getTranslation( 'Akcja formularza na przycisku' ) + ': ' + button.buttonName,
              Ext.ux.suncode.IntegrationComponentService.COMPONENT_TYPES.FORM_ACTION ) );
        }
      }, this );

      Ext.each( this.attributes.form.labelActions, function( labelAction, index, labelActions ) {
        var label = processNode.findLabel( labelAction.labelId );
        components = components.concat( this.getObjectIntegrationComponentsUsingVariable(
            labelAction.formActions, varId,
            getTranslation( 'Akcja formularza na etykiecie' ) + ': ' + label.name,
            Ext.ux.suncode.IntegrationComponentService.COMPONENT_TYPES.FORM_ACTION ) );
      }, this );

      return components;
    },
    getEventActionsUsingVariable: function( varId ) {
      var components = new Array();
      components = components.concat( this.getObjectIntegrationComponentsUsingVariable(
          this.attributes.form.events, varId, getTranslation( 'Globalne zdarzenie formularza' ),
          Ext.ux.suncode.IntegrationComponentService.COMPONENT_TYPES.EVENT_ACTION ) );
      var processNode = this.parentNode;

      Ext.each( this.attributes.form.variables, function( variable, index, variables ) {
        if ( variable.genre == 'VARIABLE' ) {
          if ( variable.varId !== varId ) {
            var processVariable = processNode.findVariable( variable.varId );
            components = components.concat( this.getObjectIntegrationComponentsUsingVariable(
                variable.eventActions, varId,
                getTranslation( 'Zdarzenie na zmiennej formularza' ) + ': ' + processVariable.name,
                Ext.ux.suncode.IntegrationComponentService.COMPONENT_TYPES.EVENT_ACTION ) );
          }
        } else if ( variable.genre == 'VARIABLE_SET' ) {
          if ( variable.varId !== varId ) {
            components = components.concat( this.getObjectIntegrationComponentsUsingVariable(
                variable.eventActions, varId,
                getTranslation( 'Zdarzenie na tabeli dynamicznej' ) + ': ' + variable.name,
                Ext.ux.suncode.IntegrationComponentService.COMPONENT_TYPES.EVENT_ACTION ) );

            if ( !Ext.isEmpty( variable.DTButtons ) ) {
              Ext.each( variable.DTButtons, function( dtButton, dtButtonIndex, dtButtons ) {
                components = components.concat( this.getObjectIntegrationComponentsUsingVariable(
                    dtButton.eventActions, varId,
                    getTranslation( 'Zdarzenie na przycisku tabeli dynamicznej' )
                    + ': ' + dtButton.name,
                    Ext.ux.suncode.IntegrationComponentService.COMPONENT_TYPES.EVENT_ACTION ) );
              }, this );
            }
          }
        }
      }, this );

      Ext.each( this.attributes.form.httpLinks, function( httpLink, index, httpLinks ) {
        components = components.concat( this.getObjectIntegrationComponentsUsingVariable(
            httpLink.eventActions, varId,
            getTranslation( 'Zdarzenie na przycisku' ) + ': ' + httpLink.buttonName,
            Ext.ux.suncode.IntegrationComponentService.COMPONENT_TYPES.EVENT_ACTION ) );
      }, this );

      Ext.each( this.attributes.form.buttons, function( button, index, buttons ) {
        if ( button.genre == 'ACTION_ACCEPT_BUTTON' ) {
          components = components.concat( this.getObjectIntegrationComponentsUsingVariable(
              button.eventActions, varId,
              getTranslation( 'Zdarzenie na przycisku' ) + ': ' + button.buttonName,
              Ext.ux.suncode.IntegrationComponentService.COMPONENT_TYPES.EVENT_ACTION ) );
        }
      }, this );

      return components;
    },
    getObjectIntegrationComponentsUsingVariable: function( integrationComponents, varId, objectType, componentType ) {
      var components = new Array();

      if ( !Ext.isEmpty( integrationComponents ) ) {
        Ext.each( integrationComponents, function( integrationComponent, index, allIntegrationComponent ) {
          if ( Ext.ux.suncode.IntegrationComponentService.doesComponentUseVariable( integrationComponent, varId ) ) {
            components.push( {
              object: objectType,
              component: integrationComponents,
              objectId: integrationComponents.id,
              customDescription: integrationComponents.customDescription,
              modificationDate: integrationComponents.modificationDate,
              objectType: componentType,
              objectContainer: integrationComponents
            } );
          }
        }, this );
      }

      return components;
    },
    validateVariableAgainstButtons: function( previousVariableId, newVariableId ) {
      var isVariablePresent = false;
      var variables = this.attributes.form.variables;

      for ( var i = 0; i < variables.length; i++ ) {
        var variable = variables[i];

        if ( variable.genre == 'VARIABLE' && variable.varId == previousVariableId ) {
          isVariablePresent = true;
          break;
        } else if ( variable.genre == 'VARIABLE_SET' ) {
          var columns = variable.columns;

          for ( var j = 0; j < columns.length; j++ ) {
            var column = columns[j];
            if ( column.varId == previousVariableId ) {
              isVariablePresent = true;
              break;
            }
          }
        }
      }

      if ( isVariablePresent ) {
        var httpLinks = this.attributes.form.httpLinks;

        for ( var i = 0; i < httpLinks.length; i++ ) {
          var httpLink = httpLinks[i];

          if ( httpLink.actionName == newVariableId ) {
            return {
              valid: false,
              buttonName: httpLink.buttonName
            };
          }
        }

        var buttons = this.attributes.form.buttons;

        for ( var i = 0; i < buttons.length; i++ ) {
          var button = buttons[i];

          if ( button.actionName == newVariableId ) {
            return {
              valid: false,
              buttonName: button.buttonName
            };
          }
        }
      }

      return {
        valid: true
      };
    }
} );