Ext.ux.suncode.VariableUtilizationWindow = function( config ) {
  var windowWidth = Ext.getBody().getViewSize().width * 0.95;
  var buttons = new Array();
  if ( config.enableRemoveAll ) {
    buttons.push( {
      cls: 'x-btn-icon',
      icon: getPluginImgPath( 'clear' ),
      tooltip: getTranslation( 'Usuń wszystkie' ),
      handler: this.removeAllComponents,
      scope: this
    } );
  }
  buttons.push( {
    cls: 'x-btn-icon',
    icon: getPluginImgPath( 'close' ),
    tooltip: getTranslation( 'Zamknij' ),
    handler: this.closeWindow,
    scope: this
  } );

  config = Ext.apply( {
    title: config.windowTitle,
    modal: true,
    width: windowWidth,
    autoHeight: true,
    tbar: new Ext.Toolbar( {
      buttons: buttons
    } ),
    items: [ new Ext.ux.suncode.VariableUtilizationPanel( config ) ]
  }, config );

  Ext.ux.suncode.VariableUtilizationWindow.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.VariableUtilizationWindow, Ext.Window, {
  initComponent: function() {
    Ext.ux.suncode.VariableUtilizationWindow.superclass.initComponent.call( this );
  },
  removeAllComponents: function() {
    this.utilizationPanel.removeAllComponents();
  },
  closeWindow: function() {
    this.close();
  }
} );

Ext.ux.suncode.VariableUtilizationPanel = function( config ) {
  var gridHeight = Ext.getBody().getViewSize().height * 0.8;
  var utilization = new Array();

  if ( Ext.isDefined( config.utilization ) ) {
    utilization = config.utilization;
  } else {
    var processNode = config.processNode;
    var variableId = config.variableId;
    utilization = utilization.concat( Ext.ux.suncode.IntegrationComponentService.getComponentsUsingVariable( processNode, variableId ) );
    utilization = utilization.concat( processNode.getVariableUtilization( variableId ) );
    utilization = utilization.concat( Ext.ux.suncode.DocumentationService.getVariableUtilization( processNode, variableId ) );
  }

  var fields = new Array();
  var columns = new Array();
  columns.push( {
    header: getTranslation( 'Lokalizacja' ),
    dataIndex: 'location',
    align: 'left',
    renderer: {
      fn: function( value, metaData, record, rowIndex, colIndex, store ) {
        var parts = new Array();
        var processName = record.get( 'processName' );
        var activityName = record.get( 'activityName' );
        var objectOwner = record.get( 'objectOwner' );
        var objectName = record.get( 'objectName' );

        if ( config.showProcessName && !Ext.isEmpty( processName ) ) {
          parts.push( getTranslation( 'Proces' ) + ' (' + processName + ')' );
        }

        if ( !Ext.isEmpty( activityName ) ) {
          parts.push( getTranslation( 'Zadanie' ) + ' (' + activityName + ')' );
        }

        if ( !Ext.isEmpty( objectOwner ) ) {
          parts.push( objectOwner );
        }

        if ( !config.showObjectNameAsColumn && !Ext.isEmpty( objectName ) ) {
          parts.push( objectName );
        }

        return parts.join( ' -> ' );
      },
      scope: this
    }
  } );

  if ( config.showProcessName ) {
    fields.push( {
      name: 'processName',
      type: 'string'
    } );
  }

  fields.push( {
    name: 'activityName',
    type: 'string'
  } );
  fields.push( {
    name: 'objectOwner',
    type: 'string'
  } );
  fields.push( {
    name: 'objectName',
    type: 'string'
  } );

  if ( config.showObjectNameAsColumn ) {
    columns.push( {
      header: getTranslation( 'Nazwa' ),
      dataIndex: 'objectName',
      align: 'left'
    } );
  }

  if ( config.showCustomDescription ) {
    fields.push( {
      name: 'customDescription',
      type: 'string'
    } );

    columns.push( {
      header: getTranslation( 'Opis własny' ),
      dataIndex: 'customDescription',
      align: 'left'
    } );
  }

  if ( config.showModificationDate ) {
    fields.push( {
      name: 'modificationDate',
      type: 'string'
    } );

    columns.push( {
      header: getTranslation( 'Data modyfikacji' ),
      dataIndex: 'modificationDate',
      align: 'center'
    } );
  }

  fields.push( {
    name: 'inactive',
    type: 'boolean'
  } );

  columns.push( {
    header: getTranslation( 'Aktywny' ),
    dataIndex: 'inactive',
    align: 'center',
    width: 60,
    renderer: {
      fn: function (value, metaData, record, rowIndex, colIndex, store) {
        if ( Ext.isDefined( value ) ) {
          return tickCrossValue(!value, metaData, record, rowIndex, colIndex, store);
        } else {
          return '';
        }
      }
    }
  } );

  if ( config.showVariableUtilizationActions ) {
    fields.push( {
      name: 'processDefId',
      type: 'string'
    } );
    fields.push( {
      name: 'activityDefId',
      type: 'string'
    } );
    fields.push( {
      name: 'component'
    } );
    fields.push( {
      name: 'objectType',
      type: 'string'
    } );
    fields.push( {
      name: 'objectContainer'
    } );

    columns.push( {
      id: 'actions',
      header: getTranslation( 'Akcje' ),
      align: 'center',
      width: 60,
      renderer: {
        fn: function( value, metaData, record, rowIndex, colIndex, store ) {
          var objectType = record.get( 'objectType' );

          if ( !Ext.isEmpty( objectType ) ) {
            var id = this.getId();

            return '<img onclick="callGridFunctionForRow(\'' + id + '\', \'onEditComponentClick\', \'' + rowIndex + '\')" '
                + 'src=\"' + getPluginImgPath( 'edit' ) + '\" style="margin-right: 10px;">'
                + '<img onclick="callGridFunctionForRow(\'' + id + '\', \'onRemoveComponentClick\', \'' + rowIndex + '\')" '
                + 'src=\"' + getPluginImgPath( 'delete' ) + '\">';
          } else {
            return '';
          }
        },
        scope: this
      }
    } );
  }

  var toolbar = new Ext.Toolbar( {
    hidden: !( config.showLocationFilter || config.showObjectNameFilter
        || config.showCustomDescriptionFilter )
  } );
  var toolbarPanel = new Ext.Panel( {
    layout: 'form',
    border: false,
    width: 350,
    labelWidth: 150,
    cls: 'x-Module-filtersPanel'
  } );
  toolbar.add( toolbarPanel );

  if ( config.showLocationFilter ) {
    toolbarPanel.add( {
      xtype: 'compositefield',
      fieldLabel: getTranslation( 'Lokalizacja' ),
      ref: 'locationFilter',
      getFilterValue: function() {
        return this.items.first().getValue();
      },
      setFilterValue: function( value ) {
        var filter = this.items.first();
        filter.setValue( value );
      },
      items: [ {
        xtype: 'textfield',
        emptyText: getTranslation( 'Szukaj' ) + '...',
        flex: 1,
        cls: 'x-Module-field-leftAlign',
        listeners: {
          scope: this,
          afterrender: this.onLocationFilterAfterRender
        }
      }, {
        xtype: 'button',
        cls: 'x-btn-icon',
        icon: getPluginImgPath( 'clear' ),
        tooltip: getTranslation( 'Wyczyść filtr' ),
        flex: 0,
        handler: this.clearLocationFilter,
        scope: this
      } ]
    } );
  }

  if ( config.showObjectNameFilter ) {
    toolbarPanel.add( {
      xtype: 'compositefield',
      fieldLabel: getTranslation( 'Nazwa' ),
      ref: 'objectNameFilter',
      getFilterValue: function() {
        return this.items.first().getValue();
      },
      setFilterValue: function( value ) {
        var filter = this.items.first();
        filter.setValue( value );
      },
      items: [ {
        xtype: 'textfield',
        emptyText: getTranslation( 'Szukaj' ) + '...',
        flex: 1,
        cls: 'x-Module-field-leftAlign',
        listeners: {
          scope: this,
          afterrender: this.onObjectNameFilterAfterRender
        }
      }, {
        xtype: 'button',
        cls: 'x-btn-icon',
        icon: getPluginImgPath( 'clear' ),
        tooltip: getTranslation( 'Wyczyść filtr' ),
        flex: 0,
        handler: this.clearObjectNameFilter,
        scope: this
      } ]
    } );
  }

  if ( config.showCustomDescriptionFilter ) {
    toolbarPanel.add( {
      xtype: 'compositefield',
      fieldLabel: getTranslation( 'Opis własny' ),
      ref: 'customDescriptionFilter',
      getFilterValue: function() {
        return this.items.first().getValue();
      },
      setFilterValue: function( value ) {
        var filter = this.items.first();
        filter.setValue( value );
      },
      items: [ {
        xtype: 'textfield',
        emptyText: getTranslation( 'Szukaj' ) + '...',
        flex: 1,
        cls: 'x-Module-field-leftAlign',
        listeners: {
          scope: this,
          afterrender: this.onCustomDescriptionFilterAfterRender
        }
      }, {
        xtype: 'button',
        cls: 'x-btn-icon',
        icon: getPluginImgPath( 'clear' ),
        tooltip: getTranslation( 'Wyczyść filtr' ),
        flex: 0,
        handler: this.clearCustomDescriptionFilter,
        scope: this
      } ]
    } );
  }

  config = Ext.apply( {
    height: gridHeight,
    enableColumnResize: true,
    columnLines: true,
    autoScroll: true,
    border: false,
    ref: 'utilizationPanel',
    store: new Ext.data.Store( {
      data: !Ext.isEmpty( utilization ) ? utilization : new Array(),
      reader: new Ext.data.JsonReader( {
        fields: Ext.data.Record.create( fields )
      } )
    } ),
    colModel: new Ext.grid.ColumnModel( {
      defaults: {
        sortable: true,
        menuDisabled: false
      },
      columns: columns
    } ),
    viewConfig: new Ext.ux.suncode.StandardGridView( {
      emptyText: getTranslation( 'Brak wykorzystania komponentu integracyjnego' )
    } ),
    sm: new Ext.grid.RowSelectionModel( {
      singleSelect: true
    } ),
    tbar: toolbar
  }, config );

  Ext.ux.suncode.VariableUtilizationPanel.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.VariableUtilizationPanel, Ext.grid.GridPanel, {
  initComponent: function() {
    Ext.ux.suncode.VariableUtilizationPanel.superclass.initComponent.call( this );
  },
  onLocationFilterAfterRender: function( filter ) {
    filter.getEl().on( 'keyup', function() {
      this.applyLocationFilter( filter.getValue() );
    }, this, {
      buffer: 500
    } );
  },
  onObjectNameFilterAfterRender: function( filter ) {
    filter.getEl().on( 'keyup', function() {
      this.applyObjectNameFilter( filter.getValue() );
    }, this, {
      buffer: 500
    } );
  },
  onCustomDescriptionFilterAfterRender: function( filter ) {
    filter.getEl().on( 'keyup', function() {
      this.applyCustomDescriptionFilter( filter.getValue() );
    }, this, {
      buffer: 500
    } );
  },
  applyLocationFilter: function( value ) {
    var filtersPanel = this.getFiltersPanel();
    var objectNameFilter = filtersPanel.objectNameFilter;
    var customDescriptionFilter = filtersPanel.customDescriptionFilter;
    this.doFilterComponents( value, objectNameFilter.getFilterValue(), customDescriptionFilter.getFilterValue() );
  },
  applyObjectNameFilter: function( value ) {
    var filtersPanel = this.getFiltersPanel();
    var locationFilter = filtersPanel.locationFilter;
    var customDescriptionFilter = filtersPanel.customDescriptionFilter;
    this.doFilterComponents( locationFilter.getFilterValue(), value, customDescriptionFilter.getFilterValue() );
  },
  applyCustomDescriptionFilter: function( value ) {
    var filtersPanel = this.getFiltersPanel();
    var locationFilter = filtersPanel.locationFilter;
    var objectNameFilter = filtersPanel.objectNameFilter;
    this.doFilterComponents( locationFilter.getFilterValue(), objectNameFilter.getFilterValue(), value );
  },
  doFilterComponents: function( location, objectName, customDescription ) {
    var locationRegex = new RegExp( Ext.escapeRe( location ), 'i' );
    var objectNameRegex = new RegExp( Ext.escapeRe( objectName ), 'i' );
    var customDescriptionRegex = new RegExp( Ext.escapeRe( customDescription ), 'i' );
    var store = this.getStore();

    store.filterBy( function( record, id ) {
      var componentLocation  = record.get( 'objectOwner' );
      var componentObjectName  = record.get( 'objectName' );
      var componentCustomDescription  = record.get( 'customDescription' );

      return locationRegex.test( componentLocation )
          && objectNameRegex.test( componentObjectName )
          && customDescriptionRegex.test( componentCustomDescription );
    } );
  },
  clearLocationFilter: function() {
    var filtersPanel = this.getFiltersPanel();
    var locationFilter = filtersPanel.locationFilter;
    var objectNameFilter = filtersPanel.objectNameFilter;
    var customDescriptionFilter = filtersPanel.customDescriptionFilter;
    locationFilter.setFilterValue( '' );
    this.doFilterComponents( '', objectNameFilter.getFilterValue(), customDescriptionFilter.getFilterValue() );
  },
  clearObjectNameFilter: function() {
    var filtersPanel = this.getFiltersPanel();
    var locationFilter = filtersPanel.locationFilter;
    var objectNameFilter = filtersPanel.objectNameFilter;
    var customDescriptionFilter = filtersPanel.customDescriptionFilter;
    objectNameFilter.setFilterValue( '' );
    this.doFilterComponents( locationFilter.getFilterValue(), '', customDescriptionFilter.getFilterValue() );
  },
  clearCustomDescriptionFilter: function() {
    var filtersPanel = this.getFiltersPanel();
    var locationFilter = filtersPanel.locationFilter;
    var objectNameFilter = filtersPanel.objectNameFilter;
    var customDescriptionFilter = filtersPanel.customDescriptionFilter;
    customDescriptionFilter.setFilterValue( '' );
    this.doFilterComponents( locationFilter.getFilterValue(), objectNameFilter.getFilterValue(), '' );
  },
  getFiltersPanel: function() {
    var tbar = this.getTopToolbar();

    return tbar.items.first();
  },
  onEditComponentClick: function( rowIndex ) {
    var record = this.getRecord( rowIndex );
    var component = record.get( 'component' );
    var objectType = record.get( 'objectType' );

    switch ( objectType ) {
      case Ext.ux.suncode.IntegrationComponentService.COMPONENT_TYPES.DATA_CHOOSER:
        this.editDataChooser( record, component );
        break;
      case Ext.ux.suncode.IntegrationComponentService.COMPONENT_TYPES.FORM_ACTION:
        this.editFormAction( record, component );
        break;
      case Ext.ux.suncode.IntegrationComponentService.COMPONENT_TYPES.VALIDATOR:
        this.editValidator( record, component );
        break;
      case Ext.ux.suncode.IntegrationComponentService.COMPONENT_TYPES.VARIABLES_SETTER:
        this.editVariablesSetter( record, component );
        break;
      case Ext.ux.suncode.IntegrationComponentService.COMPONENT_TYPES.APPLICATION:
        this.editApplication( record, component );
        break;
      case Ext.ux.suncode.IntegrationComponentService.COMPONENT_TYPES.EVENT_ACTION:
        this.editEventAction( record, component );
        break;
      default:
        break;
    }
  },
  editDataChooser: function( record, component ) {
    this.editComponent( {
      record: record,
      component: component,
      categories: Ext.getCmp( 'main_panel' ).getDataChoosersIntegrationComponentCategories(),
      parametersWindowTitlePrefix: getTranslation( 'Parametry dynamicznej listy' ),
      systemFunctionsAccessibility: Ext.ux.suncode.IntegrationComponentService.SERVER_ACCESSIBILITY,
      saveFunction: function( condition, values, extraConfig ) {
        Ext.apply( component, {
          customDescription: extraConfig.customDescription,
          modificationDate: extraConfig.modificationDate,
          condition: condition,
          parameters: values
        } );
      },
      getComponentRegistrationFunction: function( id ) {
        return Ext.ux.suncode.IntegrationComponentService.getDataChooserRegistration( id );
      }
    } );
  },
  editFormAction: function( record, component ) {
    var packagePanel = Ext.getCmp( 'package_panel' );
    var processDefId = record.get( 'processDefId' );
    var activityDefId = record.get( 'activityDefId' );
    var activityNode = packagePanel.findActivity( processDefId, activityDefId );

    this.editComponent( {
      record: record,
      component: component,
      categories: Ext.getCmp( 'main_panel' ).getFormActionsIntegrationComponentCategories(),
      parametersWindowTitlePrefix: getTranslation( 'Parametry akcji formularza' ),
      conditionalExecutionEnabled: true,
      inactiveEnabled: true,
      checkDestination: true,
      availableVariables: activityNode.getVariableIdsOnForm(),
      missingVariablesValidatorFunction: activityNode.validateVariablesUsageInParameterValue,
      missingVariablesValidatorScope: activityNode,
      systemFunctionsAccessibility: Ext.ux.suncode.IntegrationComponentService.BROWSER_ACCESSIBILITY,
      saveFunction: function( condition, values, extraConfig ) {
        Ext.apply( component, {
          customDescription: extraConfig.customDescription,
          modificationDate: extraConfig.modificationDate,
          condition: condition,
          inactive: extraConfig.inactive,
          parameters: values
        } );
      },
      getComponentRegistrationFunction: function( id ) {
        return Ext.ux.suncode.IntegrationComponentService.getFormActionRegistration( id );
      }
    } );
  },
  editValidator: function( record, component ) {
    this.editComponent( {
      record: record,
      component: component,
      categories: Ext.getCmp( 'main_panel' ).getValidatorsIntegrationComponentCategories(),
      parametersWindowTitlePrefix: getTranslation( 'Parametry mechanizmu sprawdzającego formularz' ),
      conditionalExecutionEnabled: true,
      inactiveEnabled: true,
      systemFunctionsAccessibility: Ext.ux.suncode.IntegrationComponentService.SERVER_ACCESSIBILITY,
      saveFunction: function( condition, values, extraConfig ) {
        Ext.apply( component, {
          customDescription: extraConfig.customDescription,
          modificationDate: extraConfig.modificationDate,
          condition: condition,
          inactive: extraConfig.inactive,
          parameters: values
        } );
      },
      getComponentRegistrationFunction: function( id ) {
        return Ext.ux.suncode.IntegrationComponentService.getValidatorRegistration( id );
      }
    } );
  },
  editVariablesSetter: function( record, component ) {
    this.editComponent( {
      record: record,
      component: component,
      categories: Ext.getCmp( 'main_panel' ).getVariablesSettersIntegrationComponentCategories(),
      parametersWindowTitlePrefix: getTranslation( 'Parametry mechanizmu uruchamianego po akceptacji' ),
      conditionalExecutionEnabled: true,
      inactiveEnabled: true,
      systemFunctionsAccessibility: Ext.ux.suncode.IntegrationComponentService.SERVER_ACCESSIBILITY,
      saveFunction: function( condition, values, extraConfig ) {
        Ext.apply( component, {
          customDescription: extraConfig.customDescription,
          modificationDate: extraConfig.modificationDate,
          condition: condition,
          inactive: extraConfig.inactive,
          parameters: values
        } );
      },
      getComponentRegistrationFunction: function( id ) {
        return Ext.ux.suncode.IntegrationComponentService.getVariablesSetterRegistration( id );
      }
    } );
  },
  editApplication: function( record, component ) {
    this.editComponent( {
      record: record,
      component: component,
      categories: Ext.getCmp( 'main_panel' ).getApplicationsIntegrationComponentCategories(),
      parametersWindowTitlePrefix: getTranslation( 'Parametry aplikacji' ),
      conditionalExecutionEnabled: Ext.ux.suncode.IntegrationComponentService
      .isApplicationWithConditionalExecution( component.id ),
      errorHandlingEnabled: true,
      inactiveEnabled: true,
      systemFunctionsAccessibility: Ext.ux.suncode.IntegrationComponentService.SERVER_ACCESSIBILITY,
      saveFunction: function( condition, values, extraConfig ) {
        Ext.apply( component, {
          customDescription: extraConfig.customDescription,
          modificationDate: extraConfig.modificationDate,
          condition: condition,
          errorHandling: extraConfig.errorHandling,
          inactive: extraConfig.inactive,
          parameters: values
        } );
      },
      getComponentRegistrationFunction: function( id ) {
        return Ext.ux.suncode.IntegrationComponentService.getApplicationRegistration( id );
      }
    } );
  },
  editEventAction: function( record, component ) {
    var packagePanel = Ext.getCmp( 'package_panel' );
    var processDefId = record.get( 'processDefId' );
    var activityDefId = record.get( 'activityDefId' );
    var activityNode = packagePanel.findActivity( processDefId, activityDefId );

    this.editComponent( {
      record: record,
      component: component,
      categories: Ext.getCmp( 'main_panel' ).getEventActionsCategories(),
      parametersWindowTitlePrefix: getTranslation( 'Parametry zdarzenia' ),
      enableCopyPasteMenu: true,
      conditionalExecutionEnabled: true,
      inactiveEnabled: true,
      availableVariables: activityNode.getVariableIdsOnForm(),
      missingVariablesValidatorFunction: activityNode.validateVariablesUsageInParameterValue,
      missingVariablesValidatorScope: activityNode,
      systemFunctionsAccessibility: Ext.ux.suncode.IntegrationComponentService.BROWSER_ACCESSIBILITY,
      saveFunction: function( condition, values, extraConfig ) {
        Ext.apply( component, {
          customDescription: extraConfig.customDescription,
          modificationDate: extraConfig.modificationDate,
          condition: condition,
          inactive: extraConfig.inactive,
          parameters: values
        } );
      },
      getComponentRegistrationFunction: function( id ) {
        return Ext.ux.suncode.IntegrationComponentService.getEventActionRegistration( id );
      }
    } );
  },
  editComponent: function( config ) {
    var component = config.component;
    var componentDef = Ext.ux.suncode.IntegrationComponentService.getIntegrationComponent( config.categories, component.id );

    if ( !Ext.isEmpty( componentDef ) ) {
      var destination = config.checkDestination ? Ext.ux.suncode.IntegrationComponentService.getDestination( componentDef,
          [ Ext.ux.suncode.IntegrationComponentService.FORM_DESTINATION,
            Ext.ux.suncode.IntegrationComponentService.VARIABLE_DESTINATION ,
            Ext.ux.suncode.IntegrationComponentService.VARIABLE_SET_DESTINATION] ) : null;

      var win = new Ext.ux.suncode.IntegrationComponentParametersWindow( {
        title: config.parametersWindowTitlePrefix + ': ' + componentDef.name,
        component: componentDef,
        customDescription: component.customDescription,
        creationDate: component.creationDate,
        modificationDate: component.modificationDate,
        condition: component.condition,
        errorHandling: component.errorHandling,
        inactive: component.inactive,
        parameters: component.parameters,
        processNode: this.initialConfig.processNode,
        conditionalExecutionEnabled: config.conditionalExecutionEnabled,
        errorHandlingEnabled: config.errorHandlingEnabled,
        inactiveEnabled: config.inactiveEnabled,
        destinationType: !Ext.isEmpty( destination ) ? destination.type : null,
        acceptButton: false,
        availableVariables: config.availableVariables,
        missingVariablesValidatorFunction: config.missingVariablesValidatorFunction,
        missingVariablesValidatorScope: config.missingVariablesValidatorScope,
        systemFunctionsAccessibility: config.systemFunctionsAccessibility,
        saveFunction: function( condition, values, extraConfig ) {
          var saveFunction = config.saveFunction;

          if ( Ext.isFunction( saveFunction ) ) {
            saveFunction.apply( this, [ condition, values, extraConfig ] );
            this.afterEditComponent( config.record, component );
          }
        },
        saveScope: this,
        getComponentRegistrationFunction: config.getComponentRegistrationFunction,
        getComponentRegistrationScope: this
      } );
      win.show();
    } else {
      showWarn( getTranslation( 'Komponent nie istnieje.' ) );
    }
  },
  afterEditComponent: function( record, component ) {
    if ( !this.initialConfig.preventSave ) {
      Ext.getCmp( 'main_panel' ).setSaved( false );
    }

    if ( !Ext.isEmpty( this.initialConfig.variableId )
        && !Ext.ux.suncode.IntegrationComponentService.doesComponentUseVariable( component, this.initialConfig.variableId ) ) {
      this.removeRecord( record );
    } else if ( this.initialConfig.showCustomDescription ) {
      record.set( 'customDescription', component.customDescription );
      record.set( 'modificationDate', component.modificationDate );
      record.set( 'inactive', component.inactive );
      record.commit();
    }
  },
  removeAllComponents: function() {
    Ext.Msg.show( {
      title: '<font color="#E16E6E" weight="bold">' + getTranslation( 'Uwaga' ) + '</font>',
      msg: getTranslation( 'Usunąć wszystkie komponenty wraz z możliwymi zależnościami' ) + "?",
      buttons: {
        yes: getTranslation( 'Tak' ),
        no: getTranslation( 'Nie' )
      },
      fn: function( buttonId ) {
        if ( buttonId == 'yes' ) {
          this.executeRemoveAllComponents();
        }
      },
      icon: Ext.Msg.QUESTION,
      scope: this
    } );
  },
  executeRemoveAllComponents: function() {
    var store = this.getStore();
    store.each( function( record ) {
      this.removeComponent( record, false );
    }, this );

    this.ownerCt.closeWindow();
  },
  onRemoveComponentClick: function( rowIndex ) {
    Ext.Msg.show( {
      title: '<font color="#E16E6E" weight="bold">' + getTranslation( 'Uwaga' ) + '</font>',
      msg: getTranslation( 'Usunąć komponent?' ),
      buttons: {
        yes: getTranslation( 'Tak' ),
        no: getTranslation( 'Nie' )
      },
      fn: function( buttonId ) {
        if ( buttonId == 'yes' ) {
          var record = this.getRecord( rowIndex );
          this.removeComponent( record, true );
        }
      },
      icon: Ext.Msg.QUESTION,
      scope: this
    } );
  },
  removeComponent: function( record, askForDependenciesRemoval ) {
    var objectType = record.get( 'objectType' );

    switch ( objectType ) {
      case Ext.ux.suncode.IntegrationComponentService.COMPONENT_TYPES.DATA_CHOOSER:
        this.removeDataChooser( record );
        break;
      case Ext.ux.suncode.IntegrationComponentService.COMPONENT_TYPES.FORM_ACTION:
      case Ext.ux.suncode.IntegrationComponentService.COMPONENT_TYPES.VALIDATOR:
      case Ext.ux.suncode.IntegrationComponentService.COMPONENT_TYPES.VARIABLES_SETTER:
      case Ext.ux.suncode.IntegrationComponentService.COMPONENT_TYPES.APPLICATION:
        this.removeComponentFromContainer( record );
        break;
      case Ext.ux.suncode.IntegrationComponentService.COMPONENT_TYPES.EVENT_ACTION:
        this.removeEventAction( record, askForDependenciesRemoval );
        break;
      default:
        break;
    }
  },
  removeDataChooser: function( record ) {
    var processNode = this.initialConfig.processNode;
    var objectContainer = record.get( 'objectContainer' );
    var variableId = objectContainer.id;
    var variable = processNode.findVariable( variableId );

    if ( !Ext.isEmpty( variable ) ) {
      var vObj = deepObjectCopy( variable );
      vObj = Ext.apply( vObj, {
        mappings: [ {
          varId: variableId
        } ]
      } );
      vObj.classpath = '';
      delete vObj.definition.id;
      delete vObj.definition.customDescription;
      delete vObj.definition.inactive;
      delete vObj.definition.parameters;
      delete vObj.definition.mappings;

      processNode.updateVariable( variable, vObj );
      this.afterRemoveComponent( record );
    }
  },
  removeEventAction: function( record, askForDependenciesRemoval ) {
    var component = record.get( 'component' );
    var eventOwnerId = component.eventOwnerId;
    var objectContainer = record.get( 'objectContainer' );
    var hasDependentEvents = false;

    if ( Ext.isArray( objectContainer ) ) {
      Ext.each( objectContainer, function ( cmp, index, allCmp ) {
        if ( cmp.eventParentId === eventOwnerId ) {
          hasDependentEvents = true;
          return false;
        }
      } );
    }

    if ( hasDependentEvents ) {
      if ( askForDependenciesRemoval ) {
        Ext.ux.suncode.IntegrationComponentService.showDependentEventsRemovalWarning(
            this.removeEventActionWithDependencies, this, [ record ] );
      } else {
        this.removeEventActionWithDependencies( record );
      }
    } else {
      this.removeComponentFromContainer( record );
    }
  },
  removeEventActionWithDependencies: function( record ) {
    var component = record.get( 'component' );
    var objectContainer = record.get( 'objectContainer' );

    if ( Ext.isArray( objectContainer ) ) {
      var eventOwnerId = component.eventOwnerId;
      var convertedEvents = new Array();

      Ext.each( objectContainer, function( event, index, allEvents ) {
        convertedEvents.push( {
          index: index,
          event: event
        } );
      } );

      var depententEvents = this.findDependentEvents( convertedEvents, eventOwnerId );

      if ( !Ext.isEmpty( depententEvents ) ) {
        var store = this.getStore();
        depententEvents.sort( function( a, b ) {
          return b.index - a.index;
        } );

        Ext.each( depententEvents, function( depententEvent, index, allDepententEvents ) {
          objectContainer.splice( depententEvent.index, 1) ;

          var recordIndex = store.findBy( function ( record, id ) {
            var recordComponent = record.get( 'component' );

            return recordComponent.eventParentId === depententEvent.event.eventParentId;
          } );

          if ( recordIndex != -1 ) {
            var recordToDelete = this.getRecord( recordIndex );
            this.afterRemoveComponent( recordToDelete );
          }
        }, this );
      }
    }

    this.removeComponentFromContainer( record );
  },
  findDependentEvents: function( events, eventOwnerId ) {
    var depententEvents = new Array();
    Ext.each( events, function( event, index, allEvents ) {
      if ( event.event.eventParentId === eventOwnerId ) {
        depententEvents.push( event );
      }
    } );

    if ( !Ext.isEmpty( depententEvents ) ) {
      Ext.each( depententEvents, function( event, index, allEvents ) {
        depententEvents = depententEvents.concat( this.findDependentEvents( events, event.event.eventOwnerId ) );
      }, this );
    }

    return depententEvents;
  },
  removeComponentFromContainer: function( record ) {
    var objectContainer = record.get( 'objectContainer' );

    if ( Ext.isArray( objectContainer ) ) {
      var component = record.get( 'component' );
      Ext.apply( component, {
        markAsDeleted: true
      } );

      for ( var i = 0; i < objectContainer.length; i++ ) {
        if ( objectContainer[i].markAsDeleted ) {
          objectContainer.splice( i, 1 );
          break;
        }
      }

      this.afterRemoveComponent( record );
    }
  },
  afterRemoveComponent: function( record ) {
    if ( !this.initialConfig.preventSave ) {
      Ext.getCmp( 'main_panel' ).setSaved( false );
    }

    this.removeRecord( record );

    var afterRemoveComponentFunction = this.initialConfig.afterRemoveComponentFunction;

    if ( Ext.isFunction( afterRemoveComponentFunction ) ) {
      var afterRemoveComponentScope = !Ext.isEmpty( this.initialConfig.afterRemoveComponentScope ) ?
          this.initialConfig.afterRemoveComponentScope : window;
      afterRemoveComponentFunction.apply( afterRemoveComponentScope, [] );
    }
  },
  getRecord: function( rowIndex ) {
    var store = this.getStore();

    return store.getAt( rowIndex );
  },
  removeRecord: function( record ) {
    var store = this.getStore();
    store.remove( record );
    store.commitChanges();
    this.getView().refresh();
  }
} );