Ext.ux.suncode.ReplaceVariablesWindow = function( config ) {
  var windowWidth = Ext.getBody().getViewSize().width * 0.95;

  config = Ext.apply( {
    modal: true,
    width: windowWidth,
    autoHeight: true,
    title: getTranslation( 'Zmienne do zastąpienia' ),
    tbar: new Ext.Toolbar( {
      buttons: [ {
        cls: 'x-btn-icon',
        ref: 'saveBtn',
        icon: getPluginImgPath( 'save' ),
        tooltip: getTranslation( 'Zapisz' ),
        scope: this,
        handler: this.saveReplacements
      }, {
        cls: 'x-btn-icon',
        icon: getPluginImgPath( 'close' ),
        tooltip: getTranslation( 'Zamknij' ),
        handler: this.closeWindow,
        scope: this
      } ]
    } ),
    items: [ new Ext.ux.suncode.ReplaceVariablesPanel( config ) ]
  }, config );

  Ext.ux.suncode.ReplaceVariablesWindow.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.ReplaceVariablesWindow, Ext.Window, {
  initComponent: function() {
    Ext.ux.suncode.ReplaceVariablesWindow.superclass.initComponent.call( this );
  },
  saveReplacements: function() {
    this.replacementsGrid.saveReplacements();
  },
  closeWindow: function() {
    this.close();
  }
} );

Ext.ux.suncode.ReplaceVariablesPanel = function( config ) {
  var processNode = config.processNode;
  var variables = processNode.attributes.variables;
  var formalParameters = processNode.attributes.formalParameters;

  var allVariablesChooser = new Ext.ux.suncode.AllVariablesChooser( {
    variables: variables,
    formalParameters: formalParameters
  } );

  config = Ext.apply( {
    height: 400,
    ref: 'replacementsGrid',
    enableColumnResize: true,
    columnLines: true,
    autoScroll: true,
    border: false,
    store: new Ext.data.Store( {
      data: config.toReplace,
      reader: new Ext.data.JsonReader( {
        fields: Ext.data.Record.create( [ {
          name: 'placement',
          type: 'string'
        }, {
          name: 'description',
          type: 'string'
        }, {
          name: 'replacedVariable',
          type: 'string'
        }, {
          name: 'variableReplacement',
          type: 'string'
        }, {
          name: 'expectedType',
          type: 'string'
        }, {
          name: 'acceptedPlacement',
          type: 'string'
        }, {
          name: 'expectedInArray',
          type: 'boolean'
        }, {
          name: 'translateType',
          type: 'boolean'
        }, {
          name: 'excludeFormalParameters',
          type: 'boolean'
        }, {
          name: 'modificationContext'
        } ] )
      } )
    } ),
    colModel: new Ext.grid.ColumnModel( {
      defaults: {
        sortable: true,
        menuDisabled: false
      },
      columns: [ {
        id: 'placement',
        header: getTranslation( 'Miejsce występowania' ),
        dataIndex: 'placement',
        align: 'left'
      }, {
        id: 'description',
        header: getTranslation( 'Opis własny' ),
        dataIndex: 'description',
        align: 'left'
      }, {
        id: 'replacedVariable',
        header: getTranslation( 'Zastępowana zmienna' ),
        dataIndex: 'replacedVariable',
        align: 'left'
      }, {
        id: 'variableReplacement',
        header: getTranslation( 'Zastąpienie' ),
        dataIndex: 'variableReplacement',
        align: 'left',
        editor: allVariablesChooser,
        renderer: function( value, metaData, record, rowIndex, colIndex, store ) {
          if ( Ext.isEmpty( value ) ) {
            metaData.css = 'x-Module-editableCell';
            return '';
          } else {
            var func = Ext.util.Format.ComboBoxRenderer( allVariablesChooser );

            return func.apply( this, [ value ] );
          }
        }
      } ]
    } ),
    viewConfig: new Ext.ux.suncode.StandardGridView( {
      emptyText: getTranslation( 'Brak zmiennych' )
    } ),
    sm: new Ext.grid.RowSelectionModel( {
      singleSelect: true
    } ),
    listeners: {
      scope: this,
      beforeedit: this.onBeforeEdit,
      afteredit: this.onAfterEdit
    }
  }, config );

  Ext.ux.suncode.ReplaceVariablesPanel.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.ReplaceVariablesPanel, Ext.grid.EditorGridPanel, {
  initComponent: function() {
    Ext.ux.suncode.ReplaceVariablesPanel.superclass.initComponent.call( this );
  },
  onBeforeEdit: function( e ) {
    var grid = e.grid;
    var columnModel = grid.getColumnModel();
    var columnIndex = e.column;
    var columnId = columnModel.getColumnId( columnIndex );

    if ( columnId == 'variableReplacement' ) {
      var processNode = grid.processNode;
      var variables = processNode.attributes.variables;
      var acceptedTypes = new Array();
      var record = e.record;
      var expectedType = record.get( 'expectedType' );
      var translateType = record.get( 'translateType' );
      var acceptedPlacement = record.get( 'acceptedPlacement' );
      var excludeFormalParameters = record.get( 'excludeFormalParameters' );

      if ( translateType ) {
        var typesMatrix = Ext.ux.suncode.IntegrationComponentService.VARIABLE_TYPES_MATRIX;

        Ext.iterate( typesMatrix, function( variableType, paramType, object ) {
          if ( Ext.isEmpty( expectedType ) || expectedType == paramType ) {
            acceptedTypes.push( variableType );
          }
        } );
      } else {
        acceptedTypes.push( expectedType );
      }

      var variablesChooser = new Ext.ux.suncode.AllVariablesChooser( {
        variables: variables,
        formalParameters: excludeFormalParameters ? null : processNode.attributes.formalParameters,
        acceptedTypes: acceptedTypes,
        acceptedPlacement: acceptedPlacement,
        acceptedVariables: grid.availableVariables
      } );

      columnModel.setEditor( e.column, variablesChooser );
      columnModel.setRenderer( e.column, function( value, metaData, record, rowIndex, colIndex, store ) {
        if ( Ext.isEmpty( value ) ) {
          metaData.css = 'x-Module-editableCell';
          return '';
        } else {
          var func = Ext.util.Format.ComboBoxRenderer( variablesChooser );

          return func.apply( this, [ value ] );
        }
      } );
    }

    return true;
  },
  onAfterEdit: function ( e ) {
    var store = e.grid.getStore();
    store.commitChanges();
  },
  saveReplacements: function() {
    if ( !this.isValid() ) {
      return;
    }

    var store = this.getStore();

    store.each( function( rec ) {
      var modificationContext = rec.get( 'modificationContext' );
      var variableReplacement = rec.get( 'variableReplacement' );

      if ( Ext.isArray( modificationContext ) ) {
        Ext.each( modificationContext, function( one, index, all ) {
          one.object[one.property] = variableReplacement;
        } );
      }
    } );

    this.ownerCt.closeWindow();
    var saveFunction = this.initialConfig.saveFunction;

    if ( Ext.isFunction( saveFunction ) ) {
      var saveScope = !Ext.isEmpty( this.initialConfig.saveScope ) ? this.initialConfig.saveScope : window;
      saveFunction.apply( saveScope, [] );
    }
  },
  isValid: function() {
    var valid = true;
    var store = this.getStore();

    store.each( function( rec ) {
      var variableReplacement = rec.get( 'variableReplacement' );

      if ( Ext.isEmpty( variableReplacement ) ) {
        showWarn( getTranslation( 'Uzupełnij wszystkie zmienne.' ) );
        valid = false;
        return false;
      }
    } );

    return valid;
  }
} );