Ext.ux.suncode.JsCodingWindow = function( config ) {
    var windowWidth = Ext.getBody().getViewSize().width * 0.8;

    config = Ext.apply( {
        modal: true,
        width: windowWidth,
        title: config.winTitle,
        items: [ new Ext.ux.suncode.JsCodingPanel( config ) ],
        closable: true,
        tbar: new Ext.Toolbar( {
            buttons: [ {
                cls: 'x-btn-icon',
                ref: 'saveBtn',
                icon: getPluginImgPath( 'save' ),
                tooltip: getTranslation( 'Zapisz' ),
                handler: this.saveForm,
                scope: this
            }, {
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'close' ),
                tooltip: getTranslation( 'Zamknij' ),
                cancel: false,
                handler: this.closeWindow,
                scope: this
            } ]
        } )
    }, config );

    Ext.ux.suncode.JsCodingWindow.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.JsCodingWindow, Ext.Window, {
    initComponent: function() {
        Ext.ux.suncode.JsCodingWindow.superclass.initComponent.call( this );
    },
    saveForm: function() {
        this.jsCodingPanel.saveForm();
    },
    closeWindow: function() {
        this.close();
    }
} );

Ext.ux.suncode.JsCodingPanel = function( config ) {
    var instruction = getTranslation( 'Korzystaj z szablonów lub przygotuj własną definicję funkcji.' ) + ' ';
    instruction += getTranslation( 'Rozpocznij od słowa "function".' ) + ' ';
    instruction += getTranslation( 'Zaznacz tekst, kliknij prawym przyciskiem myszy w obszar kodu źródłowego i wybieraj z menu wartości z mapy.' );

    config = Ext.apply( {
        labelWidth: 200,
        autoHeight: true,
        frame: false,
        border: false,
        bodyCssClass: 'x-Module-container-padding',
        ref: 'jsCodingPanel',
        items: [ {
            xtype: 'textfield',
            inputType: 'text',
            fieldLabel: getTranslation( 'Nazwa funkcji' ),
            name: 'functionName',
            anchor: '100%',
            readOnly: true,
            allowBlank: false,
            blankText: getTranslation( 'Pole jest wymagane' )
        }, {
        	xtype: 'compositefield',
        	fieldLabel: getTranslation( 'Dostępna w systemie' ),
        	ref: 'availableInSystemItemWrapper',
        	items: [ {
                xtype: 'checkbox',
                name: 'availableInSystem',
                inputValue: 'true',
                disabled: true
            }, {
                xtype: 'button',
                id: 'delete_function_definition_button',
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'delete' ),
                tooltip: getTranslation( 'Usuń' ),
                disabled: true,
                handler: this.deleteFunctionDefinition,
                scope: this
            } ]
        }, {
            xtype: 'textfield',
            inputType: 'text',
            fieldLabel: getTranslation( 'Autor' ),
            name: 'codeAuthor',
            anchor: '100%',
            readOnly: true
        }, new Ext.ux.suncode.TemplatesContainer( {
            templateType: config.sourceCodeType,
            templateLoadScope: this
        } ), {
            xtype: 'label',
            fieldLabel: getTranslation( 'Instrukcja' ),
            text: instruction
        }, {
            xtype: 'fieldset',
            autoHeight: true,
            anchor: '100%',
            title: getTranslation( 'Definicja funkcji' ),
            layout: 'fit',
            items: [ new Ext.ux.suncode.CodeEditor( {
                ref: '../codeEditor',
                codeMode: 'javascript'
            } ), {
                xtype: 'textarea',
                name: 'sourceCode',
                hidden: true
            } ]
        } ]
    }, config );

    Ext.ux.suncode.JsCodingPanel.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.JsCodingPanel, Ext.FormPanel, {
    initComponent: function() {
        Ext.ux.suncode.JsCodingPanel.superclass.initComponent.call( this );

        this.on( 'afterrender', this.loadSourceCode, this );
    },
    loadSourceCode: function() {
        this.getForm().load( {
            url: 'api/jscode/get',
            params: {
                sourceCodeType: this.initialConfig.sourceCodeType,
                functionName: this.initialConfig.functionName,
                sourceCodeOptions: Ext.util.JSON.encode( this.initialConfig.options )
            },
            method: 'POST',
            scope: this,
            success: function( form, action ) {
            	var data = action.result.data;
                this.codeEditor.setCode( data.sourceCode );
                
                if ( data.availableInSystem ) {
                	this.getDeleteFunctionDefinitionButton().enable();
                } else {
                	this.getDeleteFunctionDefinitionButton().disable();
                }
            },
            failure: function( form, action ) {
            	showServerFailure( action.response );
            }
        } );
    },
    getDeleteFunctionDefinitionButton: function() {
    	return Ext.getCmp( 'delete_function_definition_button' );
    },
    deleteFunctionDefinition: function() {
    	Ext.Msg.show( {
            title: '<font weight="bold">' + getTranslation( 'Uwaga' ) + '</font>',
            msg: getTranslation( 'Usunąć definicję funkcji?' ),
            buttons: {
                yes: getTranslation( 'Tak' ),
                no: getTranslation( 'Nie' )
            },
            fn: function( buttonId ) {
                if ( buttonId == 'yes' ) {
                    this.executeDeleteFunctionDefinition();
                }
            },
            icon: Ext.Msg.QUESTION,
            scope: this
        } );
    },
    executeDeleteFunctionDefinition: function() {
    	Ext.Ajax.request( {
            url: 'api/jscode/delete',
            method: 'GET',
            params: {
            	functionName: this.initialConfig.functionName
            },
            scope: this,
            success: function( response, opts ) {
            	if ( parseBoolean( response.responseText ) ) {
            		this.loadSourceCode();
                } else {
                    showWarn( getTranslation( 'Wystąpił błąd.' ) );
                }
            },
            failure: function( response, opts ) {
            	showWarn( getTranslation( 'Wystąpił błąd.' ) );
            }
        } );
    },
    saveForm: function() {
        var form = this.getForm();

        if ( form.isValid() ) {
            var code = this.codeEditor.getCode();

            if ( !Ext.isEmpty( code ) ) {
                form.findField( 'sourceCode' ).setValue( code );
                form.submit( {
                    url: 'api/jscode/set',
                    method: 'POST',
                    scope: this,
                    success: function( form, action ) {
                        if ( parseBoolean( action.response.responseText ) ) {
                            this.ownerCt.closeWindow();
                        } else {
                            showWarn( getTranslation( 'Wystąpił błąd.' ) );
                        }
                    },
                    failure: function( form, action ) {
                    	showServerFailure( action.response );
                    }
                } );
            } else {
                showWarn( getTranslation( 'Podaj definicję funkcji.' ) );
            }
        }
    },
    onLoadTemplate: function( templateId ) {
        Ext.Ajax.request( {
            url: 'api/jscode/getFromTemplate',
            method: 'POST',
            params: {
                sourceCodeType: this.initialConfig.sourceCodeType,
                functionName: this.initialConfig.functionName,
                sourceCodeOptions: Ext.util.JSON.encode( this.initialConfig.options ),
                templateId: templateId
            },
            scope: this,
            success: function( response, opts ) {
                this.codeEditor.setCode( response.responseText );
            },
            failure: function( response, opts ) {
            	showWarn( getTranslation( 'Wystąpił błąd.' ) );
            }
        } );
    }
} );