Ext.ux.suncode.IntegrationComponentViewer = function( config ) {
	var components = config.components;
    
    config = Ext.apply( {
        border: false,
        store: new Ext.ux.suncode.IntegrationComponentsStore( {
        	data: components
        } ),
        singleSelect: true,
        overClass: 'x-Module-integrationComponentThumbWrapOver',
        itemSelector: 'div.x-Module-integrationComponentThumbWrap',
        emptyText: '<div style="padding:10px;">' + getTranslation( 'Brak komponentów' ) + '</div>',
        prepareData: this.formatData
    }, config );

    Ext.ux.suncode.IntegrationComponentViewer.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.IntegrationComponentViewer, Ext.DataView, {
    initComponent: function() {
        Ext.ux.suncode.IntegrationComponentViewer.superclass.initComponent.call( this );

        this.on( 'selectionchange', this.showComponentDetails, this );
    },
    formatData: function( data ) {
        var noOfParameters = 0;
        var parametersDescription = '';
        var sourceDescription = '';
        var replacementText = '';
        var showDestinations = false;
        var destinationsDescription = '';

        if ( !Ext.isEmpty( data.parameters ) ) {
            noOfParameters = data.parameters.length;

            Ext.each( data.parameters, function( param, index, params ) {
                parametersDescription += '<span>';
                parametersDescription += param.name;
                parametersDescription += '</span>';
            } );
        } else {
            parametersDescription += '<span>';
            parametersDescription += getTranslation( 'Brak parametrów' );
            parametersDescription += '</span>';
        }
        
        if ( !Ext.isEmpty( data.source ) ) {
          sourceDescription += '<span>';
          sourceDescription += getTranslation( 'Identyfikator' );
          sourceDescription += ': ';
          sourceDescription += data.source.id;
          sourceDescription += '</span>';

          sourceDescription += '<span>';
          sourceDescription += getTranslation( 'Nazwa' );
          sourceDescription += ': ';
          sourceDescription += data.source.name;
          sourceDescription += '</span>';
        }
        
        if ( data.deprecated ) {
        	if ( !Ext.isEmpty( data.replacement ) ) {
        		replacementText += getTranslation( 'Zastąpiony nowym komponentem' );
        		replacementText += ': ';
        		replacementText += data.replacement;
        	} else {
        		replacementText += getTranslation( 'Komponent jest przestarzały' );
        	}

        	if ( !Ext.isEmpty( data.deprecationDescription ) ) {
            replacementText += '<br><br>';
            replacementText += data.deprecationDescription;
          }
        }

        if ( !Ext.isEmpty( data.destinations ) ) {
          var destinationTypes = new Array();
          showDestinations = true;

          Ext.each( data.destinations, function( destination, index, destinations ) {
            destinationTypes.push(
                Ext.ux.suncode.IntegrationComponentService.translateDestinationType( destination.type ) );
          } );

          destinationsDescription = destinationTypes.join( ', ' );
        }

        data = Ext.apply( data, {
            noOfParameters: noOfParameters,
            parametersDescription: parametersDescription,
            image: Ext.ux.suncode.IntegrationComponentService.buildImage( data ),
            sourceDescription: sourceDescription,
            replacementText: replacementText,
            showDestinations: showDestinations,
            destinationsDescription: destinationsDescription
        } );

        return data;
    },
    showComponentDetails: function( view, selections ) {
        var detailsPanel = this.initialConfig.detailsPanel;

        if ( !Ext.isEmpty( detailsPanel ) ) {
        	var detailsPanelBody = detailsPanel.body;
        	
        	if ( !Ext.isEmpty( selections ) ) {
                var component = this.getRecord( selections[0] ).data;
                var animationsOn = Ext.getCmp( 'main_panel' ).getAnimationsOn();
                detailsPanelBody.hide();
                detailsPanel.detailsTemplate.overwrite( detailsPanelBody, component );

                if ( animationsOn ) {
                    detailsPanelBody.slideIn( 'l', {
                        stopFx: true,
                        duration: 0.2
                    } );
                } else {
                    detailsPanelBody.show();
                }
            } else {
                detailsPanelBody.update( '' );
            }
        }
    }
} );