Ext.ux.suncode.IntegrationComponentParametersWindow = function( config ) {
	  var viewSize = Ext.getBody().getViewSize();
    var component = config.component;
    var contextVariables = new Array();
    if ( !Ext.isEmpty( component.contextVariables ) ) {
      contextVariables = contextVariables.concat( component.contextVariables );
    }
    if ( !Ext.isEmpty( config.additionalContextVariables ) ) {
      contextVariables = contextVariables.concat( config.additionalContextVariables );
    }
    var processNode = config.processNode;
    var componentReg = this.getComponentRegistration( config, component.id );
    var eventTypes = this.getEventTypes( component.events, config.eventTypesTag,
        config.eventTypeAddedFunction, config.eventTypeAddedScope );
    var customForm = new Object();
    customForm = Ext.apply( {
        fields: deepObjectCopy( component.parameters ),
        values: config.parameters,
        buildForm: !Ext.isEmpty( componentReg ) ? componentReg.buildForm : null,
        validateForm: !Ext.isEmpty( componentReg ) ? componentReg.validateForm : null,
        apiVersion: !Ext.isEmpty( componentReg ) ? componentReg.apiVersion : null
    }, customForm );
    var mainPanel = Ext.getCmp( 'main_panel' );
    var customFormConfig = mainPanel.getCustomFormConfig();
    var buttons = new Array();
    buttons.push( {
        cls: 'x-btn-icon',
        ref: 'saveBtn',
        icon: getPluginImgPath( 'save' ),
        tooltip: getTranslation( 'Zapisz' ),
        handler: this.saveForm,
        scope: this
    } );
    buttons.push( {
    	  ref: 'toggleTypeVisibilityButton',
        cls: 'x-btn-icon',
        icon: customFormConfig.typesVisible ? getPluginImgPath( 'type_visibility_off' ) :
        	getPluginImgPath( 'type_visibility_on' ),
        tooltip: customFormConfig.typesVisible ? getTranslation( 'Ukryj typy' ) :
        	getTranslation( 'Pokaż typy' ),
        enableToggle: true,
        handler: this.toggleTypeVisibility,
        scope: this
    } );
    buttons.push( {
      ref: 'toggleFunctionPrettyFormatButton',
      cls: 'x-btn-icon',
      icon: customFormConfig.functionPrettyFormat ? getPluginImgPath( 'function_pretty_format_off' ) :
          getPluginImgPath( 'function_pretty_format_on' ),
      tooltip: customFormConfig.functionPrettyFormat ? getTranslation( 'Wyłącz formatowanie funkcji' ) :
          getTranslation( 'Włącz formatowanie funkcji' ),
      enableToggle: true,
      handler: this.toggleFunctionPrettyFormat,
      scope: this
    } );
    if ( !Ext.isEmpty( component.documentationLink ) ) {
    	buttons.push( {
            cls: 'x-btn-icon',
            icon: getPluginImgPath( 'help' ),
            tooltip: getTranslation( 'Pomoc' ),
            handler: this.showHelp,
            scope: this
        } );
    }
    buttons.push( {
        cls: 'x-btn-icon',
        icon: getPluginImgPath( 'close' ),
        tooltip: getTranslation( 'Zamknij' ),
        handler: this.closeWindow,
        scope: this
    } );

    config = Ext.apply( {
        width: viewSize.width * 0.8,
        bodyStyle: {
        	maxHeight: viewSize.height * 0.8 + 'px'
        },
        autoScroll: true,
        modal: true,
        frame: false,
        onEsc: Ext.emptyFn,
        shadow: false,
        tbar: new Ext.Toolbar( {
            buttons: buttons
        } ),
        items: [ new Ext.ux.suncode.CustomForm( {
            ref: 'parametersPanel',
            customDescriptionEnabled: true,
            inactiveEnabled: config.inactiveEnabled,
            conditionalExecutionEnabled: config.conditionalExecutionEnabled,
            confirmationConfigurationEnabled: component.confirmationConfiguration,
            errorConfigurationEnabled: component.errorConfiguration,
            errorHandlingEnabled: config.errorHandlingEnabled,
            customDescription: config.customDescription,
            condition: config.condition,
            confirmation: config.confirmation,
            error: config.error,
            errorHandling: config.errorHandling,
            inactive: config.inactive,
            customForm: customForm,
            focusFirstParameter: true,
            processNode: processNode,
            information: {
            	deprecated: component.deprecated,
            	deprecatedMessage: getTranslation( 'Komponent jest przestarzały' ),
              deprecationDescription: component.deprecationDescription,
            	replacement: component.replacement,
            	replacementMessage: getTranslation( 'Zastąpiony nowym komponentem' ),
              nameValue: component.name,
              descriptionValue: component.description,
              documentationLink: component.documentationLink,
              creationDate: config.creationDate,
              modificationDate: config.modificationDate
            },
            onFieldEnterTask: new Ext.ux.suncode.RunnableTask( {
                handler: this.saveForm,
                scope: this
            } ),
            bindTo: config.bindTo,
            destinationType: config.destinationType,
            acceptButton: config.acceptButton,
            contextVariables: contextVariables,
            availableVariables: config.availableVariables,
            eventTypesEnabled: config.eventTypesEnabled,
            eventTypes: eventTypes,
            eventTypesTag: config.eventTypesTag,
            addEventTypeFunction: this.onAddEventType,
            addEventTypeScope: this,
            missingVariablesValidatorFunction: config.missingVariablesValidatorFunction,
            missingVariablesValidatorScope: config.missingVariablesValidatorScope,
            systemFunctionsAccessibility: config.systemFunctionsAccessibility,
            tableId: config.tableId,
            dtButtons: config.dtButtons,
            buttonId: config.buttonId,
            validateFieldFunction: config.validateFieldFunction,
            validateFieldScope: config.validateFieldScope,
            customFormConfig: customFormConfig
        } ) ]
    }, config );

    Ext.ux.suncode.IntegrationComponentParametersWindow.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.IntegrationComponentParametersWindow, Ext.Window, {
    initComponent: function() {
        Ext.ux.suncode.IntegrationComponentParametersWindow.superclass.initComponent.call( this );

        this.on( 'resize', this.onWindowResize ,this );
    },
    onWindowResize: function( win, width, height  ) {
      var parametersPanel = this.parametersPanel;
      parametersPanel.recalculateTableWidths();
    },
    getComponentRegistration: function( config, id ) {
    	var getComponentRegistrationFunction = config.getComponentRegistrationFunction;

        if ( Ext.isFunction( getComponentRegistrationFunction ) ) {
            var getComponentRegistrationScope = !Ext.isEmpty( config.getComponentRegistrationScope ) ?
            		config.getComponentRegistrationScope : window;
            return getComponentRegistrationFunction.apply( getComponentRegistrationScope, [ id ] );
        } else {
        	return null;
        }
    },
    getEventTypes: function( events, eventTypesTag, eventTypeAddedFunction, eventTypeAddedScope ) {
      var eventTypes = new Array();

      if ( !Ext.isEmpty( events ) && Ext.isArray( events ) && !Ext.isEmpty( eventTypesTag ) && Ext.isFunction( eventTypeAddedFunction ) ) {
        var scope = !Ext.isEmpty( eventTypeAddedScope ) ? eventTypeAddedScope : window;

        Ext.each( events, function( event, index, allEvents ) {
          var eventType = deepObjectCopy( event );
          eventType = Ext.apply( eventType, {
            added: eventTypeAddedFunction.apply( scope, [ event, eventTypesTag ] )
          } );

          eventTypes.push( eventType );
        } );
      }

      return eventTypes;
    },
    saveForm: function() {
        var values = this.parametersPanel.getParametersValues( {
          callbackFunction: this.doSaveForm,
          callbackScope: this
        } );

        if ( values ) {
          this.doSaveForm( values );
        }
    },
    doSaveForm: function( values ) {
      if ( this.doSaveWithResult( values ) ) {
        this.closeWindow();
      }
    },
    doSaveWithResult: function( values ) {
      var condition = this.parametersPanel.getCondition();
      var extraConfig = this.parametersPanel.getExtraConfig();
      var saveFunction = this.initialConfig.saveFunction;
      var validateFunction = this.initialConfig.validateFunction;
      var valid = true;

      if ( Ext.isFunction( validateFunction ) ) {
        var validateScope = !Ext.isEmpty( this.initialConfig.validateScope ) ? this.initialConfig.validateScope : window;
        valid = validateFunction.apply( validateScope, [ condition, values, extraConfig ] );
      }

      if ( valid && Ext.isFunction( saveFunction ) ) {
        var saveScope = !Ext.isEmpty( this.initialConfig.saveScope ) ? this.initialConfig.saveScope : window;
        saveFunction.apply( saveScope, [ condition, values, extraConfig ] );
        return true;
      }

      return false;
    },
    toggleTypeVisibility: function() {
    	var parametersPanel = this.parametersPanel;
    	var areVisible = parametersPanel.areTypesVisible();
    	this.changeTypeVisibility( areVisible );
    	parametersPanel.updateCustomFormConfig();
    },
    changeTypeVisibility: function( areVisible ) {
    	var parametersPanel = this.parametersPanel;
    	var button = this.getTopToolbar().toggleTypeVisibilityButton;
    	
    	if ( areVisible ) {
        	parametersPanel.hideTypes();
            button.setTooltip( getTranslation( 'Pokaż typy' ) );
            button.setIcon( getPluginImgPath( 'type_visibility_on' ) );
        } else {
        	parametersPanel.showTypes();
            button.setTooltip( getTranslation( 'Ukryj typy' ) );
            button.setIcon( getPluginImgPath( 'type_visibility_off' ) );
        }
    },
    toggleFunctionPrettyFormat: function() {
      var parametersPanel = this.parametersPanel;
      var prettyFormat = parametersPanel.areFunctionsPrettyFormatted();
      this.changeFunctionPrettyFormat( prettyFormat );
      parametersPanel.updateCustomFormConfig();
    },
    changeFunctionPrettyFormat: function( prettyFormat ) {
      var parametersPanel = this.parametersPanel;
      var button = this.getTopToolbar().toggleFunctionPrettyFormatButton;

      if ( prettyFormat ) {
        parametersPanel.switchOffFunctionPrettyFormat();
        button.setTooltip( getTranslation( 'Włącz formatowanie funkcji' ) );
        button.setIcon( getPluginImgPath( 'function_pretty_format_on' ) );
      } else {
        parametersPanel.switchOnFunctionPrettyFormat();
        button.setTooltip( getTranslation( 'Wyłącz formatowanie funkcji' ) );
        button.setIcon( getPluginImgPath( 'function_pretty_format_off' ) );
      }
    },
    showHelp: function() {
      var url = this.initialConfig.component.documentationLink;

    	window.open( url );
    },
    onAddEventType: function( eventType, eventTypesTag ) {
      var valid = false;
      var eventTypeAddedFunction = this.initialConfig.eventTypeAddedFunction;

      if ( Ext.isFunction( eventTypeAddedFunction ) ) {
        var eventTypeAddedScope = !Ext.isEmpty( this.initialConfig.eventTypeAddedScope ) ? this.initialConfig.eventTypeAddedScope : window;
        added = eventTypeAddedFunction.apply( eventTypeAddedScope, [ eventType, eventTypesTag ] );
      }

      if ( !added ) {
        var values = this.parametersPanel.getParametersValues( {
          callbackFunction: this.executeAddEventType,
          callbackScope: this,
          callbackParameters: [ eventType, eventTypesTag ]
        } );

        if ( values ) {
          this.executeAddEventType( eventType, eventTypesTag, values );
        }
      }
    },
    executeAddEventType: function ( eventType, eventTypesTag, values ) {
      if ( this.doSaveWithResult( values ) ) {
        var addEventTypeFunction = this.initialConfig.addEventTypeFunction;

        if ( Ext.isFunction( addEventTypeFunction ) ) {
          var addEventTypeScope = !Ext.isEmpty( this.initialConfig.addEventTypeScope ) ? this.initialConfig.addEventTypeScope : window;
          addEventTypeFunction.apply( addEventTypeScope, [ eventType, eventTypesTag ] );
          this.closeWindow();
        }
      }
    },
    closeWindow: function() {
        this.close();
    }
} );