Ext.ux.suncode.ParameterSpecificationsPanel = function( config ) {
    var store = new Ext.data.Store( {
        data: config.parameters,
        reader: new Ext.data.JsonReader( {
            fields: Ext.data.Record.create( [ {
                name: 'name',
                type: 'string'
            }, {
                name: 'description',
                type: 'string'
            } ] )
        } )
    } );

    config = Ext.apply( {
        height: 200,
        store: store,
        columnLines: true,
        autoScroll: true,
        frame: false,
        enableColumnMove: true,
        collapsed: true,
        colModel: new Ext.grid.ColumnModel( {
            defaults: {
                sortable: true,
                menuDisabled: false
            },
            columns: [ {
                id: 'name',
                header: getTranslation( 'Nazwa' ),
                dataIndex: 'name',
                align: 'left',
                editor: {
                    xtype: 'textfield'
                }
            }, {
                id: 'description',
                header: getTranslation( 'Opis' ),
                dataIndex: 'description',
                align: 'left',
                editor: {
                    xtype: 'textarea'
                }
            } ]
        } ),
        viewConfig: new Ext.ux.suncode.StandardGridView( {
            emptyText: getTranslation( 'Brak parametrów' )
        } ),
        sm: new Ext.grid.RowSelectionModel( {
            singleSelect: true
        } ),
        tbar: new Ext.Toolbar( {
            items: [ '->', {
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'add' ),
                tooltip: getTranslation( 'Dodaj parametr' ),
                handler: function() {
                    var grid = this.ownerCt.ownerCt;
                    var store = grid.getStore();
                    var v = store.recordType;
                    var rec = new v( {
                        name: '',
                        description: ''
                    } );
                    grid.stopEditing();
                    store.add( rec );
                    store.commitChanges();
                }
            }, {
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'delete' ),
                tooltip: getTranslation( 'Usuń parametr' ),
                handler: function() {
                    var grid = this.ownerCt.ownerCt;
                    var selModel = grid.getSelectionModel();
                    var rows = selModel.getSelections();
                    if ( rows.length == 0 ) {
                        showWarn( getTranslation( 'Wybierz parametr do usunięcia.' ) );
                        return;
                    }
                    removeRowAndMarkNext( grid, rows[0] );
                    grid.getView().refresh();
                }
            } ]
        } ),
        listeners: {
            validateedit: function( e ) {
                var grid = e.grid;
                var store = grid.getStore();
                var cm = grid.getColumnModel();
                var colIndex = e.column;
                var value = e.value;

                if ( cm.getColumnId( colIndex ) == 'name' && !Ext.isEmpty( value ) && store.findExact( 'name', value ) != -1 ) {
                    showWarn( getTranslation( 'Parametr został już dodany.' ) );
                    return false;
                }
            },
            afteredit: function( e ) {
                e.record.commit();
            }
        }
    }, config );

    Ext.ux.suncode.ParameterSpecificationsPanel.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.ParameterSpecificationsPanel, Ext.grid.EditorGridPanel, {
    initComponent: function() {
        Ext.ux.suncode.ParameterSpecificationsPanel.superclass.initComponent.call( this );
    },
    isValid: function() {
        var valid = true;
        var store = this.getStore();

        store.each( function( rec ) {
            var name = rec.get( 'name' );

            if ( Ext.isEmpty( name ) ) {
                showWarn( getTranslation( 'Podaj nazwę wszystkich parametrów.' ) );
                valid = false;
                return false;
            }
        } );

        return valid;
    },
    readParameters: function() {
        var parameters = new Array();
        var store = this.getStore();

        store.each( function( rec ) {
            parameters.push( {
                name: rec.get( 'name' ),
                description: rec.get( 'description' )
            } );
        } );

        return parameters;
    }
} );