Ext.ux.suncode.PermissionScopesChooser = function( config ) {
    config = config ? config : new Object();

    config = Ext.apply( {
        anchor: '100%',
        fieldLabel: getTranslation( 'Zakres uprawnienia' ),
        triggerAction: 'all',
        mode: 'local',
        store: new Ext.data.JsonStore( {
            fields: [ 'scope', 'scopeName' ],
            data: [ {
                scope: 'USER',
                scopeName: getTranslation( 'Użytkownik' )
            }, {
                scope: 'GROUP',
                scopeName: getTranslation( 'Grupa' )
            } ]
        } ),
        forceSelection: true,
        valueField: 'scope',
        displayField: 'scopeName',
        resizable: true,
        editable: false
    }, config );

    Ext.ux.suncode.PermissionScopesChooser.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.PermissionScopesChooser, Ext.form.ComboBox, {
    initComponent: function() {
        Ext.ux.suncode.PermissionScopesChooser.superclass.initComponent.call( this );
    }
} );