/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.service.xml;

import com.suncode.plugin.pwe.util.PweContentHandler;
import com.suncode.plugin.pwe.util.XmlAttribute;
import com.suncode.plugin.pwe.util.XmlUtils;
import com.suncode.plugin.pwe.util.exception.XmlAsStringGenerationException;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.stereotype.Service;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

@Service
public class XmlService {
    public static Logger log = Logger.getLogger(XmlService.class);
    private static final String XML_VERSION = "1.0";
    private static final String NODE_VALUE_TAG = "XPDLNODEVALUE";
    private static final XPath XPATH = XPathFactory.newInstance().newXPath();

    public Document write(String xml, String namespace) throws ParserConfigurationException, JSONException {
        JSONObject json = new JSONObject(xml);
        return this.write(json, namespace);
    }

    public Document write(JSONObject json, String namespace) throws ParserConfigurationException, JSONException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = factory.newDocumentBuilder();
        Document document = documentBuilder.newDocument();
        document.setXmlVersion(XML_VERSION);
        document.setXmlStandalone(false);
        return this.write(namespace, document, null, json);
    }

    private Document write(String namespace, Document document, Element element, JSONObject json) throws JSONException {
        Object[] attributeNames;
        if (json != null && ArrayUtils.isNotEmpty((Object[])(attributeNames = JSONObject.getNames((JSONObject)json)))) {
            for (Object attributeName : attributeNames) {
                Object attributeValue = json.get((String)attributeName);
                if (attributeValue instanceof JSONObject) {
                    this.addNode(namespace, document, element, (String)attributeName, (JSONObject)attributeValue);
                    continue;
                }
                if (attributeValue instanceof JSONArray) {
                    Element arrayElement = this.addNode(namespace, document, element, (String)attributeName, null);
                    JSONArray jsonArray = (JSONArray)attributeValue;
                    for (int i = 0; i < jsonArray.length(); ++i) {
                        JSONObject jsonRow = (JSONObject)jsonArray.get(i);
                        this.write(namespace, document, arrayElement, jsonRow);
                    }
                    continue;
                }
                this.setString(document, element, (String)attributeName, attributeValue);
            }
        }
        return document;
    }

    private void setString(Document document, Element element, String attributeName, Object attributeValue) {
        if (attributeName.equalsIgnoreCase(NODE_VALUE_TAG)) {
            element.appendChild(document.createTextNode(attributeValue.toString()));
        } else {
            element.setAttribute(attributeName, attributeValue.toString());
        }
    }

    private Element addNode(String namespace, Document document, Element element, String nodeName, JSONObject json) throws JSONException {
        Element newElement = document.createElement(this.buildNodeName(namespace, nodeName));
        if (element != null) {
            element.appendChild(newElement);
        } else {
            document.appendChild(newElement);
        }
        this.write(namespace, document, newElement, json);
        return newElement;
    }

    private String buildNodeName(String namespace, String nodeName) {
        StringBuilder name = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)namespace)) {
            name.append(namespace);
            name.append(":");
        }
        name.append(nodeName);
        return name.toString();
    }

    public String getAsString(String xml, String namespace, boolean prettyPrint) {
        try {
            Document document = this.write(xml, namespace);
            return XmlUtils.convertToString(document, prettyPrint);
        }
        catch (Exception exception) {
            log.error((Object)exception.getMessage(), (Throwable)exception);
            throw new XmlAsStringGenerationException(exception);
        }
    }

    public String getAsString(JSONObject json, String namespace, boolean prettyPrint) {
        try {
            Document document = this.write(json, namespace);
            return XmlUtils.convertToString(document, prettyPrint);
        }
        catch (Exception exception) {
            log.error((Object)exception.getMessage(), (Throwable)exception);
            throw new XmlAsStringGenerationException(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject read(String path) throws SAXException, IOException {
        FileInputStream inputStream = new FileInputStream(path);
        try {
            JSONObject jSONObject = this.read(inputStream);
            return jSONObject;
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject read(byte[] bytes) throws SAXException, IOException {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
        try {
            JSONObject jSONObject = this.read(inputStream);
            return jSONObject;
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }

    public JSONObject read(InputStream inputStream) throws SAXException, IOException {
        InputSource inputSource = new InputSource(inputStream);
        PweContentHandler contentHandler = new PweContentHandler();
        XMLReader parser = XMLReaderFactory.createXMLReader();
        parser.setContentHandler(contentHandler);
        parser.parse(inputSource);
        return contentHandler.getResult();
    }

    public Document create() throws ParserConfigurationException {
        DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder domBuilder = domFactory.newDocumentBuilder();
        return domBuilder.newDocument();
    }

    public void setElementAttribute(Element element, XmlAttribute attribute) {
        this.setElementAttributes(element, Arrays.asList(attribute));
    }

    private void setElementAttributes(Element element, List<XmlAttribute> attributes) {
        attributes.forEach(a -> element.setAttribute(a.getName(), this.defaultString(a.getValue())));
    }

    private String defaultString(Object value) {
        return value != null ? StringUtils.defaultString((String)value.toString()) : "";
    }

    public void appendTextElement(Document document, Element parent, String elementName, Object text) {
        Element element = document.createElement(elementName);
        element.appendChild(document.createTextNode(this.defaultString(text)));
        parent.appendChild(element);
    }

    public void writeToOutputStream(OutputStream outputStream, Document document) throws TransformerException {
        DOMSource source = new DOMSource(document);
        StreamResult result = new StreamResult(outputStream);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("standalone", "no");
        transformer.transform(source, result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document get(InputStream inputStream) throws Exception {
        Document document;
        InputStreamReader inputStreamReader = null;
        InputSource inputSource = null;
        try {
            inputStreamReader = new InputStreamReader(inputStream, "UTF-8");
            inputSource = new InputSource(inputStreamReader);
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document2 = documentBuilder.parse(inputSource);
            document2.normalize();
            document = document2;
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(inputStreamReader);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)inputStreamReader);
        return document;
    }

    public Node getNode(Element element, String nodeName) throws XPathExpressionException {
        return (Node)XPATH.evaluate(nodeName, element, XPathConstants.NODE);
    }

    public NodeList getNodeList(Element element, String expression) throws XPathExpressionException {
        return (NodeList)XPATH.evaluate(expression, element, XPathConstants.NODESET);
    }

    public boolean isElement(Node node) {
        return node != null && node instanceof Element;
    }

    public String getElementText(Element element, String nodeName) throws XPathExpressionException {
        return (String)XPATH.evaluate(nodeName, element, XPathConstants.STRING);
    }

    public Integer getElementInteger(Element element, String nodeName) throws XPathExpressionException {
        Double value = (Double)XPATH.evaluate(nodeName, element, XPathConstants.NUMBER);
        if (value != null && !value.isNaN()) {
            return value.intValue();
        }
        return null;
    }

    public Boolean getElementLogical(Element element, String nodeName) throws XPathExpressionException {
        String text = this.getElementText(element, nodeName);
        return Boolean.parseBoolean(text);
    }

    public String getElementAttributeText(Element element, String attributeName) {
        return element.getAttribute(attributeName);
    }

    public Boolean getElementAttributeLogical(Element element, String attributeName) {
        String text = this.getElementAttributeText(element, attributeName);
        return Boolean.parseBoolean(text);
    }

    public List<Element> convertToElementsList(NodeList nodeList) {
        ArrayList<Element> elements = new ArrayList<Element>();
        if (this.hasElements(nodeList)) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (!this.isElement(node)) continue;
                Element element = (Element)node;
                elements.add(element);
            }
        }
        return elements;
    }

    private boolean hasElements(NodeList nodeList) {
        return nodeList != null && nodeList.getLength() > 0;
    }
}

