/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.service.template;

import com.suncode.plugin.pwe.service.plugin.PluginService;
import com.suncode.plugin.pwe.util.PageResult;
import com.suncode.plugin.pwe.util.PweUtils;
import com.suncode.plugin.pwe.util.TemplateType;
import com.suncode.plugin.pwe.util.comparator.ResourceComparator;
import com.suncode.plugin.pwe.web.support.dto.template.TemplateDto;
import com.suncode.plugin.pwe.web.support.dto.template.builder.TemplateDtoBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Service;

@Service
public class TemplateService {
    public static Logger log = Logger.getLogger(TemplateService.class);
    private static final String RESOURCES_LOCATION_PATTERN_PREFIX = "/templates/";
    private static final String TRANSLATION_PROPERTIES_FILE_NAME = "translation.properties";
    private static final String RESOURCES_LOCATION_PATTERN_POSTFIX = "*.txt";
    private static final long NO_TEMPLATES = 0L;
    @Autowired
    private PluginService pluginService;
    @Autowired
    private TemplateDtoBuilder templateDtoBuilder;

    public PageResult<TemplateDto> get(String type, String query, int offset, int limit) {
        TemplateType templateType = TemplateType.getByName(type);
        String locationPattern = this.buildResourcesLocationPattern(templateType);
        Object[] array = this.pluginService.getResources(locationPattern);
        if (ArrayUtils.isNotEmpty((Object[])array)) {
            List<Resource> resources = this.filterAndConvertToSortedList((Resource[])array, query);
            List<Resource> resourcesOnPage = resources.subList(offset, Math.min(resources.size(), offset + limit));
            Properties translationProperties = this.buildTranslationProperties(templateType);
            long total = resources.size();
            return new PageResult<TemplateDto>(this.templateDtoBuilder.build(resourcesOnPage, translationProperties), total);
        }
        return new PageResult<TemplateDto>(new ArrayList(), NO_TEMPLATES);
    }

    private String buildResourcesLocationPattern(TemplateType templateType) {
        StringBuilder pattern = new StringBuilder();
        pattern.append(this.buildBaseResourcesLocation(templateType));
        pattern.append(RESOURCES_LOCATION_PATTERN_POSTFIX);
        return pattern.toString();
    }

    private String buildBaseResourcesLocation(TemplateType templateType) {
        StringBuilder pattern = new StringBuilder();
        pattern.append(RESOURCES_LOCATION_PATTERN_PREFIX);
        pattern.append(templateType.getBasicType());
        pattern.append("/");
        pattern.append(templateType.getSubType());
        pattern.append("/");
        pattern.append(PweUtils.getLanguage());
        pattern.append("/");
        return pattern.toString();
    }

    private List<Resource> filterAndConvertToSortedList(Resource[] array, String query) {
        List<Resource> list = new ArrayList<Resource>();
        for (Resource resource : array) {
            if (!resource.exists()) continue;
            list.add(resource);
        }
        if (CollectionUtils.isNotEmpty(list)) {
            if (StringUtils.isNotBlank((CharSequence)query)) {
                list = this.filterTemplates(list, query);
            }
            Collections.sort(list, new ResourceComparator());
        }
        return list;
    }

    private List<Resource> filterTemplates(List<Resource> list, String query) {
        ArrayList<Resource> filteredList = new ArrayList<Resource>();
        for (Resource resource : list) {
            if (!this.shouldAcceptFilter(resource, query)) continue;
            filteredList.add(resource);
        }
        return filteredList;
    }

    private boolean shouldAcceptFilter(Resource resource, String query) {
        String fileName = resource.getFilename();
        String replacedQuery = StringUtils.replace((String)query, (String)" ", (String)"_");
        return StringUtils.contains((CharSequence)fileName, (CharSequence)replacedQuery);
    }

    private Properties buildTranslationProperties(TemplateType templateType) {
        String location = this.buildTranslationPropertiesLocation(templateType);
        Resource resource = this.pluginService.getResource(location);
        if (resource.exists()) {
            Properties properties = new Properties();
            try {
                properties.load(resource.getInputStream());
            }
            catch (IOException exception) {
                log.error((Object)exception.getMessage(), (Throwable)exception);
            }
            return properties;
        }
        return new Properties();
    }

    private String buildTranslationPropertiesLocation(TemplateType templateType) {
        StringBuilder location = new StringBuilder();
        location.append(this.buildBaseResourcesLocation(templateType));
        location.append(TRANSLATION_PROPERTIES_FILE_NAME);
        return location.toString();
    }
}

