/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.service.simulationconfig;

import com.suncode.plugin.framework.service.Provides;
import com.suncode.plugin.pwe.dao.simulationconfig.SimulationConfigDao;
import com.suncode.plugin.pwe.model.simulationconfig.SimulationConfig;
import com.suncode.plugin.pwe.service.simulationconfig.SimulationConfigService;
import com.suncode.plugin.pwe.web.support.dto.simulationconfig.SimulationConfigDto;
import com.suncode.plugin.pwe.web.support.dto.simulationconfig.builder.SimulationConfigDtoBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
@Provides(value={SimulationConfigService.class})
public class SimulationConfigServiceImpl
implements SimulationConfigService {
    @Autowired
    private SimulationConfigDao simulationConfigDao;
    @Autowired
    private SimulationConfigDtoBuilder simulationConfigDtoBuilder;

    @Override
    public SimulationConfigDto getForUser(String userId) {
        SimulationConfig config = this.simulationConfigDao.getForUser(userId);
        if (config != null) {
            return this.simulationConfigDtoBuilder.build(config);
        }
        return this.simulationConfigDtoBuilder.build();
    }

    @Override
    public boolean setForUser(String userId, SimulationConfigDto dto) {
        SimulationConfig config = this.simulationConfigDao.getForUser(userId);
        if (config != null) {
            config.setAnimationsOn(dto.getAnimationsOn());
            config.setDistinctionColor(dto.getDistinctionColor());
            config.setFitMap(dto.getFitMap());
            config.setFormDisplayTime(dto.getFormDisplayTimeValue());
            config.setShowForms(dto.getShowForms());
            config.setShowSummary(dto.getShowSummary());
            config.setSpeed(dto.getSpeedValue());
            this.simulationConfigDao.update(config);
            return true;
        }
        config = this.simulationConfigDtoBuilder.extract(userId, dto);
        Long id = (Long)this.simulationConfigDao.save(config);
        return id != null;
    }
}

