/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.service.formpreview;

import com.suncode.plugin.pwe.service.xml.XmlService;
import com.suncode.plugin.pwe.util.FormVariableLabel;
import com.suncode.plugin.pwe.util.Label;
import com.suncode.plugin.pwe.util.ProcessGlobalSettings;
import com.suncode.plugin.pwe.util.VariableSetFont;
import java.io.InputStream;
import javax.xml.xpath.XPathExpressionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Component
public class ProcessGlobalSettingsUnmarshaller {
    @Autowired
    private XmlService xmlService;

    public ProcessGlobalSettings unmarshall(InputStream inputStream) throws Exception {
        Document document = this.xmlService.get(inputStream);
        Element root = document.getDocumentElement();
        ProcessGlobalSettings processGlobalSettings = new ProcessGlobalSettings();
        processGlobalSettings.setId(this.xmlService.getElementAttributeText(root, "id"));
        processGlobalSettings.setFormVariableLabel(this.unmarshallFormVariableLabel(root));
        processGlobalSettings.setLabel(this.unmarshallLabel(root));
        processGlobalSettings.setVariableSetFont(this.unmarshallVariableSetFont(root));
        return processGlobalSettings;
    }

    private FormVariableLabel unmarshallFormVariableLabel(Element element) throws XPathExpressionException {
        FormVariableLabel formVariableLabel = new FormVariableLabel();
        Node formVariableLabelNode = this.xmlService.getNode(element, "FormVariableLabel");
        if (this.xmlService.isElement(formVariableLabelNode)) {
            Element formVariableLabelElement = (Element)formVariableLabelNode;
            formVariableLabel.setLabelAlign(this.xmlService.getElementText(formVariableLabelElement, "LabelAlign"));
            formVariableLabel.setLabelColor(this.xmlService.getElementText(formVariableLabelElement, "LabelColor"));
            formVariableLabel.setLabelSeparator(this.xmlService.getElementText(formVariableLabelElement, "LabelSeparator"));
            formVariableLabel.setLabelWidth(this.xmlService.getElementInteger(formVariableLabelElement, "LabelWidth"));
            formVariableLabel.setLabelFontSize(this.xmlService.getElementInteger(formVariableLabelElement, "LabelFontSize"));
            formVariableLabel.setTextDecoration(this.xmlService.getElementText(formVariableLabelElement, "TextDecoration"));
        }
        return formVariableLabel;
    }

    private Label unmarshallLabel(Element element) throws XPathExpressionException {
        Label label = new Label();
        Node labelNode = this.xmlService.getNode(element, "Label");
        if (this.xmlService.isElement(labelNode)) {
            Element labelElement = (Element)labelNode;
            label.setFontSize(this.xmlService.getElementInteger(labelElement, "FontSize"));
            label.setColor(this.xmlService.getElementText(labelElement, "Color"));
        }
        return label;
    }

    private VariableSetFont unmarshallVariableSetFont(Element element) throws XPathExpressionException {
        VariableSetFont variableSetFont = new VariableSetFont();
        Node variableSetFontNode = this.xmlService.getNode(element, "VariableSetFont");
        if (this.xmlService.isElement(variableSetFontNode)) {
            Element variableSetFontElement = (Element)variableSetFontNode;
            variableSetFont.setCellFontSize(this.xmlService.getElementInteger(variableSetFontElement, "CellFontSize"));
            variableSetFont.setHeaderFontSize(this.xmlService.getElementInteger(variableSetFontElement, "HeaderFontSize"));
        }
        return variableSetFont;
    }
}

