/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.documentation.comparator.subcomparator;

import com.suncode.plugin.pwe.documentation.comparator.subcomparator.ProcessSpecificationSubcomparator;
import com.suncode.plugin.pwe.documentation.object.Difference;
import com.suncode.plugin.pwe.documentation.object.builder.DifferenceBuilder;
import com.suncode.plugin.pwe.documentation.specification.IntegrationSpecification;
import com.suncode.plugin.pwe.util.translation.TranslationInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.enhydra.shark.xpdl.elements.WorkflowProcess;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="integrationSpecificationsSubcomparator")
public class IntegrationSpecificationsSubcomparatorImpl
implements ProcessSpecificationSubcomparator<List<IntegrationSpecification>> {
    private static final String SYSTEM_NAME_MODIFIED = "pwe.documentation.changecard.modified.integrationsystemname";
    private static final String PURPOSE_MODIFIED = "pwe.documentation.changecard.modified.integrationdataexchangepurpose";
    private static final String INTEGRATION_METHOD_MODIFIED = "pwe.documentation.changecard.modified.integrationintegrationmethod";
    private static final String DESCRIPTION_MODIFIED = "pwe.documentation.changecard.modified.integrationdescription";
    private static final String INTEGRATION_ADDED = "pwe.documentation.changecard.added.integration";
    private static final String INTEGRATION_DELETED = "pwe.documentation.changecard.deleted.integration";
    @Autowired
    private DifferenceBuilder differenceBuilder;

    @Override
    public List<Difference> compare(WorkflowProcess baseProcess, List<IntegrationSpecification> base, WorkflowProcess comparedProcess, List<IntegrationSpecification> compared, TranslationInfo translationInfo) {
        ArrayList<Difference> differences = new ArrayList<Difference>();
        Map<String, IntegrationSpecification> baseMap = this.convertToMap(base);
        if (CollectionUtils.isNotEmpty(compared)) {
            for (IntegrationSpecification comparedSpecification : compared) {
                if (baseMap.containsKey(comparedSpecification.getName())) {
                    IntegrationSpecification baseSpecification = baseMap.remove(comparedSpecification.getName());
                    differences.addAll(this.compare(comparedSpecification.getName(), baseSpecification, comparedSpecification));
                    continue;
                }
                differences.add(this.differenceBuilder.build(INTEGRATION_ADDED, comparedSpecification.getName()));
            }
        }
        if (MapUtils.isNotEmpty(baseMap)) {
            for (IntegrationSpecification baseSpecification : baseMap.values()) {
                differences.add(this.differenceBuilder.build(INTEGRATION_DELETED, baseSpecification.getName()));
            }
        }
        return differences;
    }

    private Map<String, IntegrationSpecification> convertToMap(List<IntegrationSpecification> list) {
        HashMap<String, IntegrationSpecification> map = new HashMap<String, IntegrationSpecification>();
        if (CollectionUtils.isNotEmpty(list)) {
            for (IntegrationSpecification element : list) {
                map.put(element.getName(), element);
            }
        }
        return map;
    }

    private List<Difference> compare(String name, IntegrationSpecification base, IntegrationSpecification compared) {
        ArrayList<Difference> differences = new ArrayList<Difference>();
        if (!StringUtils.equalsIgnoreCase((CharSequence)base.getSystemName(), (CharSequence)compared.getSystemName())) {
            differences.add(this.differenceBuilder.build(SYSTEM_NAME_MODIFIED, name, base.getSystemName(), compared.getSystemName()));
        }
        if (!StringUtils.equalsIgnoreCase((CharSequence)base.getPurpose(), (CharSequence)compared.getPurpose())) {
            differences.add(this.differenceBuilder.build(PURPOSE_MODIFIED, name, base.getPurpose(), compared.getPurpose()));
        }
        if (!StringUtils.equalsIgnoreCase((CharSequence)base.getIntegrationMethod(), (CharSequence)compared.getIntegrationMethod())) {
            differences.add(this.differenceBuilder.build(INTEGRATION_METHOD_MODIFIED, name, base.getIntegrationMethod(), compared.getIntegrationMethod()));
        }
        if (!StringUtils.equalsIgnoreCase((CharSequence)base.getDescription(), (CharSequence)compared.getDescription())) {
            differences.add(this.differenceBuilder.build(DESCRIPTION_MODIFIED, name, base.getDescription(), compared.getDescription()));
        }
        return differences;
    }
}

