/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.documentation.comparator.subcomparator;

import com.suncode.plugin.pwe.documentation.comparator.subcomparator.ProcessSpecificationSubcomparator;
import com.suncode.plugin.pwe.documentation.object.Difference;
import com.suncode.plugin.pwe.documentation.object.builder.DifferenceBuilder;
import com.suncode.plugin.pwe.documentation.object.builder.SpecificationDescriptionPartBuilder;
import com.suncode.plugin.pwe.documentation.specification.AssumptionsAndScopeSpecification;
import com.suncode.plugin.pwe.documentation.specification.TeamMemberSpecification;
import com.suncode.plugin.pwe.documentation.util.ComparatorUtils;
import com.suncode.plugin.pwe.util.translation.TranslationInfo;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.enhydra.shark.xpdl.elements.WorkflowProcess;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="assumptionsAndScopeSubcomparator")
public class AssumptionsAndScopeSubcomparatorImpl
implements ProcessSpecificationSubcomparator<AssumptionsAndScopeSpecification> {
    private static final String CLIENT_NAME_MODIFIED = "pwe.documentation.changecard.modified.clientname";
    private static final String SYSTEM_LINK_MODIFIED = "pwe.documentation.changecard.modified.systemlink";
    private static final String GENERAL_PROCESS_DESCRIPTION_MODIFIED = "pwe.documentation.changecard.modified.generalprocessdescription";
    private static final String PROCESS_INITIATION_METHOD_MODIFIED = "pwe.documentation.changecard.modified.processinitiationmethod";
    private static final String EMAIL_NOTIFICATIONS_DESCRIPTION_MODIFIED = "pwe.documentation.changecard.modified.emailnotificationsdescription";
    private static final String PROCESSES_PER_MONTH_MODIFIED = "pwe.documentation.changecard.modified.processespermonth";
    private static final String USERS_IN_PROCESS_MODIFIED = "pwe.documentation.changecard.modified.usersinprocess";
    private static final String ANALYSIS_TEAM_COMPANY_SIDE_MEMBER_ADDED = "pwe.documentation.changecard.added.analysisteamcompanysidemember";
    private static final String ANALYSIS_TEAM_COMPANY_SIDE_MEMBER_DELETED = "pwe.documentation.changecard.deleted.analysisteamcompanysidemember";
    private static final String ANALYSIS_TEAM_CLIENT_SIDE_MEMBER_ADDED = "pwe.documentation.changecard.added.analysisteamclientsidemember";
    private static final String ANALYSIS_TEAM_CLIENT_SIDE_MEMBER_DELETED = "pwe.documentation.changecard.deleted.analysisteamclientsidemember";
    private static final String PROJECT_TEAM_COMPANY_SIDE_MEMBER_ADDED = "pwe.documentation.changecard.added.projectteamcompanysidemember";
    private static final String PROJECT_TEAM_COMPANY_SIDE_MEMBER_DELETED = "pwe.documentation.changecard.deleted.projectteamcompanysidemember";
    private static final String PROJECT_TEAM_CLIENT_SIDE_MEMBER_ADDED = "pwe.documentation.changecard.added.projectteamclientsidemember";
    private static final String PROJECT_TEAM_CLIENT_SIDE_MEMBER_DELETED = "pwe.documentation.changecard.deleted.projectteamclientsidemember";
    @Autowired
    private SpecificationDescriptionPartBuilder specificationDescriptionPartBuilder;
    @Autowired
    private DifferenceBuilder differenceBuilder;

    @Override
    public List<Difference> compare(WorkflowProcess baseProcess, AssumptionsAndScopeSpecification base, WorkflowProcess comparedProcess, AssumptionsAndScopeSpecification compared, TranslationInfo translationInfo) {
        ArrayList<Difference> differences = new ArrayList<Difference>();
        if (!StringUtils.equalsIgnoreCase((CharSequence)base.getClientName(), (CharSequence)compared.getClientName())) {
            differences.add(this.differenceBuilder.build(CLIENT_NAME_MODIFIED, base.getClientName(), compared.getClientName()));
        }
        if (!StringUtils.equalsIgnoreCase((CharSequence)base.getSystemLink(), (CharSequence)compared.getSystemLink())) {
            differences.add(this.differenceBuilder.build(SYSTEM_LINK_MODIFIED, base.getSystemLink(), compared.getSystemLink()));
        }
        if (!StringUtils.equalsIgnoreCase((CharSequence)base.getGeneralProcessDescription(), (CharSequence)compared.getGeneralProcessDescription())) {
            String baseGeneralProcessDescription = this.buildGeneralProcessDescription(baseProcess, translationInfo, base);
            String comparedGeneralProcessDescription = this.buildGeneralProcessDescription(comparedProcess, translationInfo, compared);
            differences.add(this.differenceBuilder.build(GENERAL_PROCESS_DESCRIPTION_MODIFIED, baseGeneralProcessDescription, comparedGeneralProcessDescription));
        }
        if (!StringUtils.equalsIgnoreCase((CharSequence)base.getProcessInitiationMethod(), (CharSequence)compared.getProcessInitiationMethod())) {
            differences.add(this.differenceBuilder.build(PROCESS_INITIATION_METHOD_MODIFIED, base.getProcessInitiationMethod(), compared.getProcessInitiationMethod()));
        }
        if (!StringUtils.equalsIgnoreCase((CharSequence)base.getEmailNotificationsDescription(), (CharSequence)compared.getEmailNotificationsDescription())) {
            String baseEmailNotificationsDescription = this.buildEmailNotificationsDescription(baseProcess, translationInfo, base);
            String comparedEmailNotificationsDescription = this.buildEmailNotificationsDescription(comparedProcess, translationInfo, compared);
            differences.add(this.differenceBuilder.build(EMAIL_NOTIFICATIONS_DESCRIPTION_MODIFIED, baseEmailNotificationsDescription, comparedEmailNotificationsDescription));
        }
        if (base.getProcessesPerMonth().intValue() != compared.getProcessesPerMonth().intValue()) {
            differences.add(this.differenceBuilder.build(PROCESSES_PER_MONTH_MODIFIED, (int)base.getProcessesPerMonth(), compared.getProcessesPerMonth()));
        }
        if (base.getUsersInProcess().intValue() != compared.getUsersInProcess().intValue()) {
            differences.add(this.differenceBuilder.build(USERS_IN_PROCESS_MODIFIED, (int)base.getUsersInProcess(), compared.getUsersInProcess()));
        }
        differences.addAll(this.compareTeamMembers(base.getAnalysisTeam().getCompanySideMembers(), compared.getAnalysisTeam().getCompanySideMembers(), ANALYSIS_TEAM_COMPANY_SIDE_MEMBER_ADDED, ANALYSIS_TEAM_COMPANY_SIDE_MEMBER_DELETED));
        differences.addAll(this.compareTeamMembers(base.getAnalysisTeam().getClientSideMembers(), compared.getAnalysisTeam().getClientSideMembers(), ANALYSIS_TEAM_CLIENT_SIDE_MEMBER_ADDED, ANALYSIS_TEAM_CLIENT_SIDE_MEMBER_DELETED));
        differences.addAll(this.compareTeamMembers(base.getProjectTeam().getCompanySideMembers(), compared.getProjectTeam().getCompanySideMembers(), PROJECT_TEAM_COMPANY_SIDE_MEMBER_ADDED, PROJECT_TEAM_COMPANY_SIDE_MEMBER_DELETED));
        differences.addAll(this.compareTeamMembers(base.getProjectTeam().getClientSideMembers(), compared.getProjectTeam().getClientSideMembers(), PROJECT_TEAM_CLIENT_SIDE_MEMBER_ADDED, PROJECT_TEAM_CLIENT_SIDE_MEMBER_DELETED));
        return differences;
    }

    private String buildGeneralProcessDescription(WorkflowProcess process, TranslationInfo translationInfo, AssumptionsAndScopeSpecification assumptionsAndScopeSpecification) {
        return this.specificationDescriptionPartBuilder.buildAsString(process, translationInfo, assumptionsAndScopeSpecification.getGeneralProcessDescription());
    }

    private String buildEmailNotificationsDescription(WorkflowProcess process, TranslationInfo translationInfo, AssumptionsAndScopeSpecification assumptionsAndScopeSpecification) {
        return this.specificationDescriptionPartBuilder.buildAsString(process, translationInfo, assumptionsAndScopeSpecification.getEmailNotificationsDescription());
    }

    private List<Difference> compareTeamMembers(List<TeamMemberSpecification> base, List<TeamMemberSpecification> compared, String addedKey, String deletedKey) {
        ArrayList<Difference> differences = new ArrayList<Difference>();
        List<TeamMemberSpecification> added = ComparatorUtils.getAdded(base, compared);
        List<TeamMemberSpecification> deleted = ComparatorUtils.getDeleted(base, compared);
        if (CollectionUtils.isNotEmpty(added)) {
            for (TeamMemberSpecification member : added) {
                differences.add(this.differenceBuilder.build(addedKey, member.getName()));
            }
        }
        if (CollectionUtils.isNotEmpty(deleted)) {
            for (TeamMemberSpecification member : deleted) {
                differences.add(this.differenceBuilder.build(deletedKey, member.getName()));
            }
        }
        return differences;
    }
}

