/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.documentation.chapter.point.builder;

import com.suncode.plugin.pwe.documentation.Documentation;
import com.suncode.plugin.pwe.documentation.ParagraphContents;
import com.suncode.plugin.pwe.documentation.chapter.point.builder.ActivityPointBuilder;
import com.suncode.plugin.pwe.documentation.chapter.point.builder.IntegrationComponentsPointBuilder;
import com.suncode.plugin.pwe.documentation.object.ActivityForm;
import com.suncode.plugin.pwe.documentation.object.BarcodePrintButton;
import com.suncode.plugin.pwe.documentation.object.FormAction;
import com.suncode.plugin.pwe.documentation.specification.ActivitySpecification;
import com.suncode.plugin.pwe.documentation.subchapter.builder.SubchapterBuilder;
import com.suncode.plugin.pwe.documentation.util.BookmarkNameUtils;
import com.suncode.plugin.pwe.documentation.util.ParagraphContentsUtils;
import com.suncode.plugin.pwe.documentation.util.ParagraphIndentsUtils;
import com.suncode.plugin.pwe.documentation.util.VariableUtils;
import com.suncode.plugin.pwe.service.translator.TranslatorService;
import com.suncode.plugin.pwe.util.translation.TranslationInfo;
import org.apache.commons.collections.CollectionUtils;
import org.enhydra.shark.xpdl.elements.Activity;
import org.enhydra.shark.xpdl.elements.WorkflowProcess;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="activityBarcodePrintButtonsPointBuilder")
public class ActivityBarcodePrintButtonsPointBuilderImpl
implements ActivityPointBuilder {
    private static final String PRINT_BARCODE = "pwe.documentation.point.title.printbarcode";
    private static final String DATA_SOURCE_FOR_LABEL = "pwe.documentation.point.title.datasourceforlabel";
    private static final String FORM_ACTIONS_POINT_TITLE = "pwe.documentation.point.title.formactions";
    @Autowired
    private TranslatorService translatorService;
    @Autowired
    private IntegrationComponentsPointBuilder<FormAction> formActionsIntegrationComponentsPointBuilder;
    @Autowired
    private SubchapterBuilder subchapterBuilder;

    @Override
    public void build(Documentation documentation, WorkflowProcess process, TranslationInfo translationInfo, Activity activity, ActivitySpecification activitySpecification, ActivityForm activityForm) {
        for (BarcodePrintButton barcodePrintButton : activityForm.getBarcodePrintButtons()) {
            this.buildPoints(documentation, process, barcodePrintButton);
        }
    }

    private void buildPoints(Documentation documentation, WorkflowProcess process, BarcodePrintButton barcodePrintButton) {
        this.buildTitlePoint(documentation);
        this.buildDataSourceForLabelPoint(documentation, process, barcodePrintButton);
        if (CollectionUtils.isNotEmpty(barcodePrintButton.getFormActions())) {
            this.buildFormActionsPoint(documentation, process, barcodePrintButton);
        }
        documentation.addNewLine();
    }

    private void buildTitlePoint(Documentation documentation) {
        String text = this.buildTitlePointText();
        this.buildPoint(documentation, text);
    }

    private String buildTitlePointText() {
        return this.translatorService.translateMessage(PRINT_BARCODE);
    }

    private void buildDataSourceForLabelPoint(Documentation documentation, WorkflowProcess process, BarcodePrintButton barcodePrintButton) {
        ParagraphContents contents = this.buildDataSourceForLabelPointContents(process, barcodePrintButton);
        contents.setIndents(ParagraphIndentsUtils.buildLeft(3));
        this.buildPoint(documentation, DATA_SOURCE_FOR_LABEL, contents);
    }

    private ParagraphContents buildDataSourceForLabelPointContents(WorkflowProcess process, BarcodePrintButton barcodePrintButton) {
        String labelVariable = barcodePrintButton.getLabelVariable();
        String text = VariableUtils.getName(process, labelVariable);
        String bookmarkName = BookmarkNameUtils.getNameForProcessVariable(labelVariable);
        return this.buildParagraphContents(text, bookmarkName);
    }

    private ParagraphContents buildParagraphContents(String text, String bookmarkName) {
        return ParagraphContentsUtils.build(text, bookmarkName);
    }

    private void buildFormActionsPoint(Documentation documentation, WorkflowProcess process, BarcodePrintButton barcodePrintButton) {
        this.formActionsIntegrationComponentsPointBuilder.build(documentation, process, barcodePrintButton.getFormActions(), FORM_ACTIONS_POINT_TITLE, 3);
    }

    private void buildPoint(Documentation documentation, String title) {
        this.buildPoint(documentation, title, 2);
    }

    private void buildPoint(Documentation documentation, String title, int leftIndents) {
        this.subchapterBuilder.build(documentation, title, leftIndents);
    }

    private void buildPoint(Documentation documentation, String titleKey, ParagraphContents contents) {
        this.subchapterBuilder.build(documentation, titleKey, 3, contents);
    }
}

