/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.documentation.chapter.builder;

import com.suncode.plugin.pwe.documentation.Documentation;
import com.suncode.plugin.pwe.documentation.ParagraphContents;
import com.suncode.plugin.pwe.documentation.TableCell;
import com.suncode.plugin.pwe.documentation.TableHeader;
import com.suncode.plugin.pwe.documentation.TableHeaders;
import com.suncode.plugin.pwe.documentation.TableRecord;
import com.suncode.plugin.pwe.documentation.TableRecords;
import com.suncode.plugin.pwe.documentation.chapter.builder.ChapterBuilder;
import com.suncode.plugin.pwe.documentation.specification.ParameterSpecification;
import com.suncode.plugin.pwe.documentation.specification.ProcessSpecification;
import com.suncode.plugin.pwe.documentation.specification.ProgrammingTaskSpecification;
import com.suncode.plugin.pwe.documentation.subchapter.builder.SubchapterBuilder;
import com.suncode.plugin.pwe.documentation.util.BookmarkNameUtils;
import com.suncode.plugin.pwe.documentation.util.Counter;
import com.suncode.plugin.pwe.documentation.util.ParagraphContentsUtils;
import com.suncode.plugin.pwe.documentation.util.ParagraphIndentsUtils;
import com.suncode.plugin.pwe.documentation.util.TableUtils;
import com.suncode.plugin.pwe.service.translator.TranslatorService;
import com.suncode.plugin.pwe.util.translation.TranslationInfo;
import com.suncode.plugin.pwe.web.support.dto.documentationconfig.DocumentationConfigDto;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.enhydra.shark.xpdl.elements.Activities;
import org.enhydra.shark.xpdl.elements.Activity;
import org.enhydra.shark.xpdl.elements.WorkflowProcess;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="programmingTasksChapterBuilder")
public class ProgrammingTasksChapterBuilderImpl
implements ChapterBuilder {
    private static final String CHAPTER_TITLE = "pwe.documentation.chapter.title.programmingtasks";
    private static final String TASK_DESCRIPTION_POINT_TITLE = "pwe.documentation.point.title.taskdescription";
    private static final String TASK_TYPE_POINT_TITLE = "pwe.documentation.point.title.tasktype";
    private static final String EXECUTION_LOCATION_POINT_TITLE = "pwe.documentation.point.title.executionlocation";
    private static final String INPUT_PARAMETERS_POINT_TITLE = "pwe.documentation.point.title.inputparameters";
    private static final String PARAMETER_NAME_TABLE_COLUMN_ID = "name";
    private static final String PARAMETER_NAME_TABLE_HEADER = "pwe.documentation.table.header.name";
    private static final String PARAMETER_DESCRIPTION_TABLE_COLUMN_ID = "description";
    private static final String PARAMETER_DESCRIPTION_TABLE_HEADER = "pwe.documentation.table.header.description";
    private static final String NO_INPUT_PARAMETERS = "pwe.documentation.text.noinputparameters";
    private static final String OUTPUT_PARAMETERS_POINT_TITLE = "pwe.documentation.point.title.outputparameters";
    private static final String NO_OUTPUT_PARAMETERS = "pwe.documentation.text.nooutputparameters";
    private static final String ALGORITHM_DESCRIPTION_POINT_TITLE = "pwe.documentation.point.title.algorithmdescription";
    @Autowired
    private TranslatorService translatorService;
    @Autowired
    private SubchapterBuilder subchapterBuilder;

    @Override
    public void build(Documentation documentation, WorkflowProcess process, ProcessSpecification processSpecification, TranslationInfo translationInfo, DocumentationConfigDto documentationConfig) {
        documentation.addChapter(this.translatorService.translateDocumentationChapterTitle(CHAPTER_TITLE));
        this.buildSubchapters(documentation, process, processSpecification);
    }

    private void buildSubchapters(Documentation documentation, WorkflowProcess process, ProcessSpecification processSpecification) {
        List<ProgrammingTaskSpecification> programmingTaskSpecifications = processSpecification.getProgrammingTaskSpecifications();
        if (CollectionUtils.isNotEmpty(programmingTaskSpecifications)) {
            Counter subchapterNo = new Counter(1);
            for (ProgrammingTaskSpecification programmingTaskSpecification : programmingTaskSpecifications) {
                this.buildSubchapter(documentation, process, programmingTaskSpecification, subchapterNo.getCountAndIncrement());
            }
        }
    }

    private void buildSubchapter(Documentation documentation, WorkflowProcess process, ProgrammingTaskSpecification programmingTaskSpecification, int subchapterNo) {
        String title = this.buildSubchapterTitle(programmingTaskSpecification, subchapterNo);
        documentation.addSubchapter(title);
        this.buildTaskDescriptionPoint(documentation, programmingTaskSpecification);
        this.buildTaskTypePoint(documentation, programmingTaskSpecification);
        this.buildExecutionLocationPoint(documentation, process, programmingTaskSpecification);
        this.buildInputParametersPoint(documentation, programmingTaskSpecification);
        this.buildOutputParametersPoint(documentation, programmingTaskSpecification);
        this.buildAlgorithmDescriptionPoint(documentation, programmingTaskSpecification);
        documentation.addNewLine();
    }

    private String buildSubchapterTitle(ProgrammingTaskSpecification programmingTaskSpecification, int subchapterNo) {
        StringBuilder title = new StringBuilder();
        title.append(subchapterNo);
        title.append(". ");
        title.append(programmingTaskSpecification.getName());
        return title.toString();
    }

    private void buildTaskDescriptionPoint(Documentation documentation, ProgrammingTaskSpecification programmingTaskSpecification) {
        this.buildPoint(documentation, TASK_DESCRIPTION_POINT_TITLE, programmingTaskSpecification.getDescription());
    }

    private void buildTaskTypePoint(Documentation documentation, ProgrammingTaskSpecification programmingTaskSpecification) {
        this.buildPoint(documentation, TASK_TYPE_POINT_TITLE, this.buildTaskType(programmingTaskSpecification));
    }

    private String buildTaskType(ProgrammingTaskSpecification programmingTaskSpecification) {
        return this.translatorService.translateDocumentationMessageForText(programmingTaskSpecification.getType());
    }

    private void buildExecutionLocationPoint(Documentation documentation, WorkflowProcess process, ProgrammingTaskSpecification programmingTaskSpecification) {
        Activities activities = process.getActivities();
        if (this.doesExecutionLocationActivityExist(programmingTaskSpecification, activities)) {
            Activity activity = activities.getActivity(programmingTaskSpecification.getExecutionLocation());
            ParagraphContents contents = this.buildParagraphContents(activity);
            contents.setIndents(ParagraphIndentsUtils.buildLeft(1));
            this.buildPoint(documentation, EXECUTION_LOCATION_POINT_TITLE, contents);
        } else {
            this.buildPoint(documentation, EXECUTION_LOCATION_POINT_TITLE, programmingTaskSpecification.getExecutionLocation());
        }
    }

    private boolean doesExecutionLocationActivityExist(ProgrammingTaskSpecification programmingTaskSpecification, Activities activities) {
        return !activities.isEmpty() && activities.containsElement(programmingTaskSpecification.getExecutionLocation());
    }

    private ParagraphContents buildParagraphContents(Activity activity) {
        String bookmarkName = this.buildBookmarkName(activity);
        return ParagraphContentsUtils.build(activity.getName(), bookmarkName);
    }

    private String buildBookmarkName(Activity activity) {
        return BookmarkNameUtils.getNameForActivity(activity.getId());
    }

    private void buildInputParametersPoint(Documentation documentation, ProgrammingTaskSpecification programmingTaskSpecification) {
        this.buildParametersPoint(documentation, programmingTaskSpecification.getInputParameters(), INPUT_PARAMETERS_POINT_TITLE, NO_INPUT_PARAMETERS);
    }

    private void buildParametersPoint(Documentation documentation, List<ParameterSpecification> parameters, String titleKey, String noParametersKey) {
        if (CollectionUtils.isNotEmpty(parameters)) {
            TableHeaders headers = this.buildParametersTableHeaders();
            TableRecords records = new TableRecords();
            for (ParameterSpecification parameterSpecification : parameters) {
                records.add(this.buildParametersTableRecord(parameterSpecification));
            }
            this.buildPoint(documentation, titleKey, headers, records);
        } else {
            this.buildPoint(documentation, titleKey, this.translatorService.translateMessage(noParametersKey));
        }
    }

    private TableHeaders buildParametersTableHeaders() {
        TableHeaders headers = new TableHeaders();
        headers.add(this.buildParametersTableNameHeader());
        headers.add(this.buildParametersTableDescriptionHeader());
        return headers;
    }

    private TableHeader buildParametersTableNameHeader() {
        return TableUtils.buildTableHeader(PARAMETER_NAME_TABLE_COLUMN_ID, this.translatorService.translateMessage(PARAMETER_NAME_TABLE_HEADER));
    }

    private TableHeader buildParametersTableDescriptionHeader() {
        return TableUtils.buildTableHeader(PARAMETER_DESCRIPTION_TABLE_COLUMN_ID, this.translatorService.translateMessage(PARAMETER_DESCRIPTION_TABLE_HEADER));
    }

    private TableRecord buildParametersTableRecord(ParameterSpecification parameterSpecification) {
        TableRecord record = new TableRecord();
        record.addCell(PARAMETER_NAME_TABLE_COLUMN_ID, this.buildParametersTableNameCell(parameterSpecification));
        record.addCell(PARAMETER_DESCRIPTION_TABLE_COLUMN_ID, this.buildParametersTableDescriptionCell(parameterSpecification));
        return record;
    }

    private TableCell buildParametersTableNameCell(ParameterSpecification parameterSpecification) {
        return TableUtils.buildTableCell(parameterSpecification.getName());
    }

    private TableCell buildParametersTableDescriptionCell(ParameterSpecification parameterSpecification) {
        return TableUtils.buildTableCell(parameterSpecification.getDescription());
    }

    private void buildOutputParametersPoint(Documentation documentation, ProgrammingTaskSpecification programmingTaskSpecification) {
        this.buildParametersPoint(documentation, programmingTaskSpecification.getOutputParameters(), OUTPUT_PARAMETERS_POINT_TITLE, NO_OUTPUT_PARAMETERS);
    }

    private void buildAlgorithmDescriptionPoint(Documentation documentation, ProgrammingTaskSpecification programmingTaskSpecification) {
        this.buildPoint(documentation, ALGORITHM_DESCRIPTION_POINT_TITLE, programmingTaskSpecification.getAlgorithmDescription());
    }

    private void buildPoint(Documentation documentation, String titleKey, String text) {
        this.subchapterBuilder.build(documentation, titleKey, text);
    }

    private void buildPoint(Documentation documentation, String titleKey, ParagraphContents contents) {
        this.subchapterBuilder.build(documentation, titleKey, contents);
    }

    private void buildPoint(Documentation documentation, String titleKey, TableHeaders headers, TableRecords records) {
        this.subchapterBuilder.build(documentation, titleKey, headers, records);
    }
}

