function expandAllProcessesAndActivities( rootNode ) {
    rootNode.expand( true );
}

function collapseAllProcessesAndActivities( rootNode ) {
    rootNode.collapse( true );
}

function createNewProcess( config ) {
    var packagePanel = Ext.getCmp( 'package_panel' );
    var rootNode = packagePanel.getRootNode();
    var currentProcessNo = rootNode.attributes.currentProcessNo;
    var paperPanel = Ext.getCmp( 'paper_panel' );
    var mainPanel = Ext.getCmp( 'main_panel' );

    if ( !rootNode.hasChildNodes() ) {
        var paperToolbar = paperPanel.getTopToolbar();
        paperToolbar.enableAllButtons();
    }

    var pN = getTranslation( 'Proces' ) + ' ' + ( currentProcessNo + 1 );
    if ( !config.initialProcessDefId ) {
        while ( packagePanel.findProcess( generateId( pN, Ext.ux.suncode.Constants.PROCESS_DEF_ID_MAX_LENGTH ) ) ) {
            rootNode.attributes.currentProcessNo = ++currentProcessNo;
            pN = getTranslation( 'Proces' ) + ' ' + ( currentProcessNo + 1 );
        }
    }

    var newProcessConfig = new Object();
    newProcessConfig = Ext.apply( {
        currentProcessNo: currentProcessNo,
        initialProcessName: config.initialProcessName ? config.initialProcessName : pN,
        initialProcessDefId: config.initialProcessDefId ? config.initialProcessDefId : generateId( pN,
                        Ext.ux.suncode.Constants.PROCESS_DEF_ID_MAX_LENGTH ),
        initialProcessCreationTime: config.initialProcessCreationTime ? config.initialProcessCreationTime : new Date().format( 'Y-m-d H:i:s' ),
        initialProcessColor: config.initialProcessColor ? config.initialProcessColor : '',
        initialProcessNameMask: config.initialProcessNameMask ? config.initialProcessNameMask : '',
        initialProcessDescr: config.initialProcessDescr ? config.initialProcessDescr : '',
        initialAttachmentDirectory: config.initialAttachmentDirectory ? config.initialAttachmentDirectory : generateUUID(),
        idChanged: config.initialProcessDefId ? true : false
    }, newProcessConfig );

    var newProcess = new Ext.ux.suncode.ProcessNode( newProcessConfig );
    rootNode.appendChild( newProcess );

    var processPanel = new Ext.ux.suncode.ProcessPanel( {
        title: newProcess.text,
        processDefId: newProcess.attributes.processDefId
    } );
    paperPanel.add( processPanel );
    paperPanel.activate( processPanel );
    packagePanel.selectPath( newProcess.getPath() );
    processPanel.paper = Raphael( processPanel.body.id, processPanel.getWidth() - 25, processPanel.getHeight() - 25 );
    processPanel.paper = Ext.apply( {
        lastRoleXPos: processPanel.getWidth() - 30 - processPanel.paper.bpmn.roleWidth,
        lastRoleYPos: 1,
        scale: 1,
        hoverTrash: new Array(),
        resizerTrash: new Array(),
        helperTrash: new Array(),
        dragTrash: new Array(),
        validationTrash: new Array(),
        clickedLineSetTrash: new Array(),
        clickedTaskTrash: new Array(),
        fadedTrash: new Array(),
        markedElIdsTrash: new Array(),
        gridSet: processPanel.paper.set(),
        snapToGrid: mainPanel.getSnapToGrid(),
        showGrid: mainPanel.getShowGrid(),
        gridSize: mainPanel.getGridSize()
    }, processPanel.paper );
    processPanel.paper.canvas.removeAttribute( 'xmlns' );
    processPanel.paper.canvas.setAttribute( 'xmlns:xlink', 'http://www.w3.org/1999/xlink' );
    
    if ( !mainPanel.isEditionModeActive() ) {
        Raphael.fn.touchpad.activateTouchpad( processPanel.paper );
    }

    rootNode.attributes.currentProcessNo = ++currentProcessNo;
    mainPanel.setSaved( false );

    return newProcess;
}

function showPackageProperties( packageNode ) {
    var packagePropertiesWindow = new Ext.ux.suncode.PackagePropertiesWindow( {
        packageNode: packageNode,
        AV: Ext.getCmp( 'main_panel' ).getAdvancedView()
    } );
    packagePropertiesWindow.show();
}

Ext.ux.suncode.PackagePropertiesWindow = function( config ) {
    var windowWidth = Ext.getBody().getViewSize().width * 0.5;
    var packageNode = config.packageNode;
    var packageId = packageNode.attributes.packageId;
    var packageName = packageNode.attributes.packageName;
    var packageNameTranslation = getXpdlPackageNameTranslation( packageId, packageName );

    config = Ext.apply( {
        windowWidth: windowWidth
    }, config );

    config = Ext.apply( {
        modal: true,
        width: windowWidth,
        autoHeight: true,
        title: getTranslation( 'Właściwości pakietu' ) + ' ' + packageNameTranslation,
        items: new Ext.ux.suncode.PackagePropertiesTabPanel( config ),
        closable: true,
        tbar: new Ext.ux.suncode.PackagePropertiesTopToolbar( config )
    }, config );

    Ext.ux.suncode.PackagePropertiesWindow.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.PackagePropertiesWindow, Ext.Window, {
    initComponent: function() {
        Ext.ux.suncode.PackagePropertiesWindow.superclass.initComponent.call( this );

        this.on( 'afterrender', this.onAfterRender, this );
    },
    onAfterRender: function() {
        if ( this.initialConfig.activateTab ) {
            this.PackagePropertiesTabPanel.activate( this.initialConfig.activateTab );
        }
    }
} );

Ext.ux.suncode.PackagePropertiesTabPanel = function( config ) {
    var panelHeight = Ext.getBody().getViewSize().height * 0.8;

    config = Ext.apply( {
        panelHeight: panelHeight
    }, config );

    var items = new Array();
    items.push( new Ext.ux.suncode.PackageDefinitionPanel( config ) );
    items.push( new Ext.ux.suncode.PackageProcessesPanel( config ) );
    items.push( new Ext.ux.suncode.PackageParticipantsPanel( config ) );
    config = Ext.apply( {
        nodeName: 'package',
        node: config.packageNode
    }, config );
    items.push( new Ext.ux.suncode.ApplicationsPanel( config ) );

    config = Ext.apply( {
        items: items,
        activeTab: 0,
        autoHeight: true,
        enableTabScroll: true,
        border: false,
        ref: 'PackagePropertiesTabPanel'
    }, config );

    Ext.ux.suncode.PackagePropertiesTabPanel.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.PackagePropertiesTabPanel, Ext.TabPanel, {
    initComponent: function() {
        Ext.ux.suncode.PackagePropertiesTabPanel.superclass.initComponent.call( this );
    }
} );

Ext.ux.suncode.PackageDefinitionPanel = function( config ) {
    var packageNode = config.packageNode;
    var items = new Array();

    var packageIdItem = new Ext.ux.suncode.IdField( {
        anchor: '100%',
        fieldLabel: getTranslation( 'Identyfikator pakietu' ),
        value: packageNode.attributes.packageId,
        ref: '../../packageIdItem',
        hidden: !config.AV,
        idMaxLength: Ext.ux.suncode.Constants.PACKAGE_ID_MAX_LENGTH,
        idChanged: packageNode.attributes.idChanged
    } );
    items.push( packageIdItem );

    var packageNameItem = new Ext.ux.suncode.I18NTranslatedField( {
    	fieldLabel: getTranslation( 'Nazwa pakietu' ),
    	ref: '../../packageNameItem',
    	field: {
            xtype: 'textfield',
            maxLength: 32,
            maxLengthText: getTranslation( 'Nazwa pakietu nie może przekroczyć 32 znaki.' ),
            value: packageNode.attributes.packageName,
            blankText: getTranslation( 'Pole jest wymagane' ),
            stripCharsRe: /\.|\\|\/|\?|:|\*|"|\||<|>/g,
            listeners: {
                blur: function( field ) {
                    if ( !packageNode.attributes.idChanged ) {
                        var packageId = generateId( field.getValue(), Ext.ux.suncode.Constants.PACKAGE_ID_MAX_LENGTH );
                        packageIdItem.setValue( packageId );
                    }
                }
            }
        },
        getIdFieldFunction: function() {
        	return this.ownerCt.ownerCt.packageIdItem;
        },
        getIdFieldScope: this,
        emptyIdMessage: getTranslation( 'Podaj identyfikator pakietu.' ),
        windowTitle: getTranslation( 'Tłumaczenia nazwy pakietu' ),
        keyPrefix: 'PACK(',
        keyPostfix: ')',
        saveToCache: false,
        initialId: packageNode.attributes.packageId
    } );
    items.push( packageNameItem );

    var packageAuthorItem = new Ext.form.TextField( {
        inputType: 'text',
        fieldLabel: getTranslation( 'Autor' ),
        anchor: '100%',
        ref: '../../packageAuthorItem',
        value: packageNode.attributes.packageAuthor
    } );
    items.push( packageAuthorItem );

    var packageCreationTimeItem = new Ext.form.TextField( {
        inputType: 'text',
        fieldLabel: getTranslation( 'Czas utworzenia' ),
        anchor: '100%',
        value: packageNode.attributes.packageCreationTime,
        readOnly: true
    } );
    items.push( packageCreationTimeItem );

    var scriptItem = new Ext.form.FieldSet( {
        title: getTranslation( 'Skrypt' ),
        labelWidth: config.windowWidth * 0.4,
        autoWidth: true,
        anchor: '100%',
        defaults: {
            anchor: '98%'
        },
        hidden: !config.AV
    } );
    var scriptTypeItem = new Ext.form.ComboBox( {
        inputType: 'text',
        fieldLabel: getTranslation( 'Typ' ),
        ref: '../../../scriptTypeItem',
        triggerAction: 'all',
        mode: 'local',
        store: new Ext.data.ArrayStore( {
            fields: [ 'scriptType' ],
            data: [ [ 'text/javascript' ] ]
        } ),
        valueField: 'scriptType',
        displayField: 'scriptType',
        forceSelection: true,
        editable: false,
        value: packageNode.attributes.scriptType,
        listeners: {
            blur: function( combo ) {
                if ( combo.getValue() == '' ) {
                    combo.setValue( packageNode.attributes.scriptType );
                }
            }
        }
    } );
    scriptItem.add( scriptTypeItem );
    var scriptVersionItem = new Ext.form.TextField( {
        inputType: 'text',
        fieldLabel: getTranslation( 'Wersja' ),
        value: packageNode.attributes.scriptVersion,
        ref: '../../../scriptVersionItem'
    } );
    scriptItem.add( scriptVersionItem );
    var scriptGrammarItem = new Ext.form.TextField( {
        inputType: 'text',
        fieldLabel: getTranslation( 'Gramatyka' ),
        value: packageNode.attributes.scriptGrammar,
        ref: '../../../scriptGrammarItem'
    } );
    scriptItem.add( scriptGrammarItem );
    items.push( scriptItem );

    var packageDescrItem = new Ext.form.FieldSet( {
        title: getTranslation( 'Opis' ),
        layout: 'fit',
        anchor: '100%'
    } );
    var packageDescrArea = new Ext.ux.suncode.I18NTranslatedField( {
    	ref: '../../../packageDescrItem',
    	field: {
            xtype: 'textarea',
            height: 150,
            value: packageNode.attributes.packageDescr
        },
        getIdFieldFunction: function() {
        	return this.ownerCt.ownerCt.packageIdItem;
        },
        getIdFieldScope: this,
        emptyIdMessage: getTranslation( 'Podaj identyfikator pakietu.' ),
        windowTitle: getTranslation( 'Tłumaczenia opisu pakietu' ),
        keyPrefix: 'PACK(',
        keyPostfix: ')_DESC',
        saveToCache: false,
        initialId: packageNode.attributes.packageId,
        multilineTranslationFields: true
    } );
    packageDescrItem.add( packageDescrArea );
    items.push( packageDescrItem );

    config = Ext.apply( {
        layoutConfig: {
            trackLabels: true
        },
        items: items,
        title: getTranslation( 'Definicja' ),
        frame: false,
        bodyCssClass: 'x-Module-container-padding',
        labelWidth: config.windowWidth * 0.4,
        boxMinHeight: config.panelHeight,
        boxMaxHeight: config.panelHeight,
        autoScroll: true,
        border: false
    }, config );

    Ext.ux.suncode.PackageDefinitionPanel.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.PackageDefinitionPanel, Ext.FormPanel, {
    initComponent: function() {
        Ext.ux.suncode.PackageDefinitionPanel.superclass.initComponent.call( this );
    }
} );

Ext.ux.suncode.PackageProcessesPanel = function( config ) {
    var record = Ext.data.Record.create( [ {
        name: 'processName',
        type: 'string'
    }, {
        name: 'workflowVariables',
        type: 'int'
    }, {
        name: 'processDefId',
        type: 'string'
    } ] );

    var processesStoreReader = new Ext.data.JsonReader( {
        fields: record
    } );

    var processesStore = new Ext.data.Store( {
        reader: processesStoreReader,
        fields: record
    } );

    var processNodes = Ext.getCmp( 'package_panel' ).getRootNode().childNodes;
    if ( processNodes.length > 0 ) {
        Ext.each( processNodes, function( process, index, processNodes ) {
            var processDefId = process.attributes.processDefId;
            var processName = process.attributes.processName;
            var processNameTranslation = getXpdlProcessNameTranslation( processDefId, processName );

            processesStore.add( new record( {
                processName: processNameTranslation,
                workflowVariables: process.attributes.variables.length,
                processDefId: processDefId
            } ) );
        } );
        processesStore.commitChanges();
    }

    config = Ext.apply( {
        id: 'package_processes_panel',
        title: getTranslation( 'Procesy' ),
        store: processesStore,
        height: config.panelHeight,
        enableColumnResize: true,
        columnLines: true,
        autoScroll: true,
        border: false,
        colModel: new Ext.grid.ColumnModel( {
            defaults: {
                sortable: true,
                menuDisabled: false
            },
            columns: [ {
                id: 'processName',
                header: getTranslation( 'Nazwa procesu' ),
                dataIndex: 'processName',
                align: 'left'
            }, {
                id: 'workflowVariables',
                header: getTranslation( 'Zmienne procesu' ),
                dataIndex: 'workflowVariables',
                align: 'left'
            }, {
                id: 'processDefId',
                header: 'processDefId',
                dataIndex: 'processDefId',
                align: 'left',
                hidden: true,
                hideable: false
            } ]
        } ),
        viewConfig: new Ext.ux.suncode.StandardGridView( {
            emptyText: getTranslation( 'Brak procesów' )
        } ),
        sm: new Ext.grid.RowSelectionModel( {
            singleSelect: true
        } ),
        tbar: new Ext.Toolbar( {
            items: [ {
                xtype: 'tbtext',
                text: '<font ' + getTotalStyle() + '><b>' + getTranslation( 'Ilość procesów' ) + ': ' + processesStore.getCount() + '</b></font>'
            }, '->', {
                xtype: 'button',
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'add' ),
                tooltip: getTranslation( 'Dodaj proces' ),
                scope: this,
                handler: this.addProcess
            }, {
                xtype: 'button',
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'edit' ),
                tooltip: getTranslation( 'Edytuj proces' ),
                scope: this,
                handler: this.editProcess
            }, {
                xtype: 'button',
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'delete' ),
                tooltip: getTranslation( 'Usuń proces' ),
                scope: this,
                handler: this.removeProcess
            } ]
        } ),
        listeners: {
            rowclick: function( grid, rowIndex, e ) {
                var row = grid.getStore().getAt( rowIndex );
                var procDefId = row.get( 'processDefId' );
                var packagePanel = Ext.getCmp( 'package_panel' );
                packagePanel.selectProcess( procDefId );
            },
            rowdblclick: function( grid, rowIndex, e ) {
                var row = grid.getStore().getAt( rowIndex );
                var procDefId = row.get( 'processDefId' );
                var processNode = Ext.getCmp( 'package_panel' ).findProcess( procDefId );
                var window = grid.ownerCt.ownerCt;
                window.close();
                showProcessProperties( processNode );
            },
            afterrender: function( grid ) {
                grid.on( 'sortchange', grid.sortProcessesInTree, grid );
            }
        }
    }, config );

    Ext.ux.suncode.PackageProcessesPanel.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.PackageProcessesPanel, Ext.grid.GridPanel, {
    initComponent: function() {
        Ext.ux.suncode.PackageProcessesPanel.superclass.initComponent.call( this );
    },
    updateTitle: function() {
        var tbar = this.getTopToolbar();
        var txtInfo = tbar.items.first();
        var amount = this.getStore().getCount();
        txtInfo.setText( '<font ' + getTotalStyle() + '><b>' + getTranslation( 'Ilość procesów' ) + ': ' + amount + '</b></font>' );
    },
    addProcess: function() {
        var newProcess = createNewProcess( {
            initialProcessNameMask: 'VAR'
        } );
        var store = this.getStore();
        var p = store.recordType;
        var rec = new p( {
            processName: newProcess.attributes.processName,
            workflowVariables: 0,
            processDefId: newProcess.attributes.processDefId
        } );
        store.add( rec );
        store.commitChanges();
        this.updateTitle();
    },
    editProcess: function() {
        var process = this.getSelectedProcess();
        if ( !process ) {
            return;
        }

        var rowIndex = this.getStore().indexOf( process );
        this.fireEvent( 'rowdblclick', this, rowIndex );
    },
    removeProcess: function() {
        var process = this.getSelectedProcess();
        if ( !process ) {
            return;
        }

        Ext.Msg.show( {
            title: '<font weight="bold">' + getTranslation( 'Uwaga' ) + '</font>',
            msg: getTranslation( 'Usunąć proces z pakietu?' ),
            buttons: {
                yes: getTranslation( 'Tak' ),
                no: getTranslation( 'Nie' )
            },
            fn: function( buttonId ) {
                if ( buttonId == 'yes' ) {
                    var processNode = Ext.getCmp( 'package_panel' ).findProcess( process.get( 'processDefId' ) );
                    executeDeleteProcess( processNode );
                    removeRowAndMarkNext( this, process );
                    this.getView().refresh();
                    this.updateTitle();
                }
            },
            scope: this,
            icon: Ext.Msg.QUESTION
        } );
    },
    getSelectedProcess: function() {
        var process = this.getSelectionModel().getSelected();
        if ( !process ) {
            showWarn( getTranslation( 'Wybierz proces.' ) );
            return null;
        }

        return process;
    },
    sortProcessesInTree: function( grid, sortInfo ) {
        var packageNode = this.initialConfig.packageNode;
        var sortFactor = sortInfo.direction == 'ASC' ? 1 : -1;

        switch ( sortInfo.field ) {
            case 'processName':
                packageNode.sort( function( a, b ) {
                    if ( a.attributes.processName > b.attributes.processName ) {
                        return 1 * sortFactor;
                    }
                    return -1 * sortFactor;
                } );
                break;
            case 'workflowVariables':
                packageNode.sort( function( a, b ) {
                    if ( a.attributes.variables.length > b.attributes.variables.length ) {
                        return 1 * sortFactor;
                    }
                    return -1 * sortFactor;
                } );
                break;
            default:
                break;
        }
    }
} );

Ext.ux.suncode.PackageParticipantsPanel = function( config ) {
    var packageNode = config.packageNode;

    var record = Ext.data.Record.create( [ {
      name: 'roleName',
      type: 'string'
    }, {
      name: 'roleType',
      type: 'string'
    }, {
      name: 'roleId',
      type: 'string'
    } ] );

    var store = new Ext.data.Store( {
        reader: new Ext.data.JsonReader( {
            fields: record
        } )
    } );

    if ( !Ext.isEmpty( packageNode.attributes.participants ) ) {
        var packageId = packageNode.attributes.packageId;

        Ext.each( packageNode.attributes.participants, function( participant, index, participants) {
          var participantId = participant.roleId;
          var participantName = participant.roleName;
          var participantNameTranslation = getXpdlPackageParticipantNameTranslation( packageId, participantId, participantName );

          store.add( new record( {
            roleName: participantNameTranslation,
            roleType: participant.roleType,
            roleId: participantId
          } ) );
        } );
        store.commitChanges();
    }

    var roleTypesChooser = new Ext.ux.suncode.RoleTypesChooser( {} );

    config = Ext.apply( {
        title: getTranslation( 'Uczestnicy' ),
        store: store,
        height: config.panelHeight,
        enableColumnResize: true,
        columnLines: true,
        autoScroll: true,
        border: false,
        colModel: new Ext.grid.ColumnModel( {
            defaults: {
                sortable: true,
                menuDisabled: false
            },
            columns: [ {
                id: 'roleName',
                header: getTranslation( 'Nazwa' ),
                dataIndex: 'roleName',
                align: 'left'
            }, {
                id: 'roleType',
                header: getTranslation( 'Typ' ),
                dataIndex: 'roleType',
                align: 'left',
                editor: roleTypesChooser,
                renderer: Ext.util.Format.ComboBoxRenderer( roleTypesChooser )
            }, {
                id: 'roleId',
                header: 'roleId',
                dataIndex: 'roleId',
                align: 'left',
                hidden: true,
                hideable: false
            } ]
        } ),
        viewConfig: new Ext.ux.suncode.StandardGridView( {
            emptyText: getTranslation( 'Brak uczestników' )
        } ),
        sm: new Ext.grid.RowSelectionModel( {
            singleSelect: true
        } ),
        tbar: new Ext.Toolbar( {
            items: [ {
                xtype: 'tbtext',
                text: '<font ' + getTotalStyle() + '><b>' + getTranslation( 'Ilość uczestników' ) + ': ' + store.getCount() + '</b></font>'
            }, '->', {
                xtype: 'button',
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'add' ),
                tooltip: getTranslation( 'Dodaj uczestnika' ),
                scope: this,
                handler: this.addParticipant
            }, {
                xtype: 'button',
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'edit' ),
                tooltip: getTranslation( 'Edytuj uczestnika' ),
                scope: this,
                handler: this.editParticipant
            }, {
                xtype: 'button',
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'delete' ),
                tooltip: getTranslation( 'Usuń uczestnika' ),
                scope: this,
                handler: this.removeParticipant
            } ]
        } ),
        listeners: {
            scope: this,
            rowdblclick: function( grid, rowIndex, e ) {
                var record = this.getStore().getAt( rowIndex );
                var roleId = record.get( 'roleId' );
                var participant = packageNode.findParticipant( roleId );

                var globalParticipantWin = new Ext.ux.suncode.GlobalParticipantWindow( {
                    packageNode: this.initialConfig.packageNode,
                    saveTo: this,
                    varRecord: record,
                    participant: participant
                } );
                globalParticipantWin.show();
            }
        }
    }, config );

    Ext.ux.suncode.PackageParticipantsPanel.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.PackageParticipantsPanel, Ext.grid.GridPanel, {
    initComponent: function() {
        Ext.ux.suncode.PackageParticipantsPanel.superclass.initComponent.call( this );
    },
    updateTitle: function() {
        var tbar = this.getTopToolbar();
        var txtInfo = tbar.items.first();
        var amount = this.getStore().getCount();
        txtInfo.setText( '<font ' + getTotalStyle() + '><b>' + getTranslation( 'Ilość uczestników' ) + ': ' + amount + '</b></font>' );
    },
    addParticipant: function() {
        var record = this.getStore().recordType;

        var globalParticipantWin = new Ext.ux.suncode.GlobalParticipantWindow( {
            packageNode: this.initialConfig.packageNode,
            saveTo: this,
            varRecord: record
        } );
        globalParticipantWin.show();
    },
    editParticipant: function() {
        var participant = this.getSelectedParticipant();
        if ( !participant ) {
            return;
        }

        var rowIndex = this.getStore().indexOf( participant );
        this.fireEvent( 'rowdblclick', this, rowIndex );
    },
    removeParticipant: function() {
        var participant = this.getSelectedParticipant();
        if ( !participant ) {
            return;
        }

        var warnMsg = getTranslation( 'Usunięcie uczestnika pakietowego spowoduje usunięcie go ze wszystkich procesów.' );
        warnMsg += '<br><br>' + getTranslation( 'Czy chcesz kontynuować?' );

        Ext.Msg.show( {
            title: '<font weight="bold">' + getTranslation( 'Uwaga' ) + '</font>',
            msg: warnMsg,
            buttons: {
                yes: getTranslation( 'Tak' ),
                no: getTranslation( 'Nie' )
            },
            fn: function( buttonId ) {
                if ( buttonId == 'yes' ) {
                    this.executeRemoveParticipant( participant );
                }
            },
            icon: Ext.Msg.QUESTION,
            scope: this
        } );
    },
    executeRemoveParticipant: function( participant ) {
        var roleId = participant.get( 'roleId' );
        var packageNode = this.initialConfig.packageNode;
        packageNode.removeParticipant( roleId );
        removeRowAndMarkNext( this, participant );
        this.getView().refresh();
        this.updateTitle();

        var packagePanel = Ext.getCmp( 'package_panel' );
        var paperPanel = Ext.getCmp( 'paper_panel' );
        var currentProcessDefId = paperPanel.getActiveTab().processDefId;

        Ext.each( paperPanel.items.items, function( tab, index, tabs ) {
            var paper = tab.paper;
            paper.bpmn.eraseTrash( paper.resizerTrash );
            var processDefId = tab.processDefId;
            var processNode = packagePanel.findProcess( processDefId );

            if ( processNode.findRole( roleId ) ) {
                changeProcessTab( processDefId );

                deleteRole( {
                    paper: paper,
                    processNode: processNode,
                    roleId: roleId
                } );
            }
        } );

        changeProcessTab( currentProcessDefId );
    },
    getSelectedParticipant: function() {
        var participant = this.getSelectionModel().getSelected();
        if ( !participant ) {
            showWarn( getTranslation( 'Wybierz uczestnika.' ) );
            return null;
        }

        return participant;
    }
} );

Ext.ux.suncode.PackagePropertiesTopToolbar = function( config ) {
    var items = new Array();

    var savePropertiesButton = new Ext.Button( {
        cls: 'x-btn-icon',
        ref: 'saveBtn',
        icon: getPluginImgPath( 'save' ),
        handler: this.saveForm,
        tooltip: getTranslation( 'Zapisz' ),
        scope: this
    } );
    items.push( savePropertiesButton );

    var closeWindowButton = new Ext.Button( {
        cls: 'x-btn-icon',
        icon: getPluginImgPath( 'close' ),
        tooltip: getTranslation( 'Zamknij' ),
        scope: this,
        handler: function() {
            this.ownerCt.close();
        }
    } );
    items.push( closeWindowButton );

    config = Ext.apply( {
        items: items
    }, config );

    Ext.ux.suncode.PackagePropertiesTopToolbar.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.PackagePropertiesTopToolbar, Ext.Toolbar, {
    initComponent: function() {
        Ext.ux.suncode.PackagePropertiesTopToolbar.superclass.initComponent.call( this );
    },
    saveForm: function() {
        var win = this.ownerCt;
        var oldPackageId = win.packageIdItem.startValue;
        var newPackageId = win.packageIdItem.getValue();
        var newPackageName = win.packageNameItem.getValue();
        
        if ( Ext.isEmpty( newPackageId ) || Ext.isEmpty( newPackageName ) ) {
            showWarn( getTranslation( 'Podaj nazwę pakietu.' ) );
            return;
        } else if ( newPackageName.length > 32 ) {
            showWarn( getTranslation( 'Nazwa pakietu nie może przekroczyć 32 znaki.' ) );
            return;
        }

        if ( oldPackageId != newPackageId ) {
          Ext.ux.suncode.I18NService.onPackageIdChange( oldPackageId, newPackageId );
        }

        var packageNode = this.initialConfig.packageNode;
        packageNode.updatePackageDef( {
            packageId: newPackageId,
            packageName: newPackageName,
            packageDescr: win.packageDescrItem.getValue(),
            packageAuthor: win.packageAuthorItem.getValue(),
            scriptType: win.scriptTypeItem.getValue(),
            scriptVersion: win.scriptVersionItem.getValue(),
            scriptGrammar: win.scriptGrammarItem.getValue()
        } );

        Ext.getCmp( 'main_panel' ).setSaved( false );
        win.close();
    }
} );