Ext.ux.suncode.AcceptanceDefWindow = function( config ) {
    var windowWidth = Ext.getBody().getViewSize().width * 0.5;
    var acceptance = config.acceptance;

    var winTitle = acceptance ? getTranslation( 'Definicja akceptacji' ) : getTranslation( 'Kreator akceptacji' );

    config = Ext.apply( {
        modal: true,
        width: windowWidth,
        autoScroll: true,
        title: winTitle,
        items: new Ext.ux.suncode.AcceptanceDefPanel( config ),
        closable: true,
        tbar: new Ext.Toolbar( {
            buttons: [ {
                cls: 'x-btn-icon',
                ref: 'saveBtn',
                icon: getPluginImgPath( 'save' ),
                tooltip: getTranslation( 'Zapisz' ),
                handler: this.saveForm,
                scope: this
            }, {
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'close' ),
                tooltip: getTranslation( 'Zamknij' ),
                handler: this.closeWindow,
                scope: this
            } ]
        } )
    }, config );

    Ext.ux.suncode.AcceptanceDefWindow.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.AcceptanceDefWindow, Ext.Window, {
    initComponent: function() {
        Ext.ux.suncode.AcceptanceDefWindow.superclass.initComponent.call( this );
    },
    saveForm: function() {
        this.AcceptanceDefPanel.saveForm();
    },
    closeWindow: function() {
        this.close();
    }
} );

Ext.ux.suncode.AcceptanceDefPanel = function( config ) {
    var activityNode = config.activityNode;
    var acceptVarItemValue = '';
    var checkVarItemValue = '';
    var resultVarItemValue = '';
    var acceptVarValueItemValue = '';
    var checkVarValueItemValue = '';
    var buttonNameItemValue = '';

    var acceptance = config.acceptance;
    if ( acceptance ) {
        acceptVarItemValue = acceptance.acceptVar;
        checkVarItemValue = acceptance.checkVar;
        resultVarItemValue = acceptance.resultVar;
        acceptVarValueItemValue = acceptance.acceptVarValue;
        checkVarValueItemValue = acceptance.checkVarValue;
        buttonNameItemValue = acceptance.buttonName;
    }

    config = Ext.apply( {
        labelWidth: 220,
        autoHeight: true,
        frame: false,
        border: false,
        bodyCssClass: 'x-Module-container-padding',
        ref: 'AcceptanceDefPanel',
        items: [ {
            xtype: 'compositefield',
            fieldLabel: getTranslation( 'Lista akceptujących' ),
            ref: 'acceptVarItem',
            items: [ new Ext.ux.suncode.AllVariablesChooser( {
                variables: activityNode.parentNode.attributes.variables,
                formalParameters: activityNode.parentNode.attributes.formalParameters,
                startWith: acceptVarItemValue
            } ) ]
        }, {
            xtype: 'compositefield',
            fieldLabel: getTranslation( 'Pełna lista akceptujących' ),
            ref: 'checkVarItem',
            items: [ new Ext.ux.suncode.AllVariablesChooser( {
                variables: activityNode.parentNode.attributes.variables,
                formalParameters: activityNode.parentNode.attributes.formalParameters,
                startWith: checkVarItemValue
            } ) ]
        }, {
            xtype: 'compositefield',
            fieldLabel: getTranslation( 'Zmienna wynikowa' ),
            ref: 'resultVarItem',
            items: [ new Ext.ux.suncode.AllVariablesChooser( {
                variables: activityNode.parentNode.attributes.variables,
                formalParameters: activityNode.parentNode.attributes.formalParameters,
                startWith: resultVarItemValue
            } ) ]
        }, {
            xtype: 'textfield',
            inputType: 'text',
            fieldLabel: getTranslation( 'Wartość spełnionego warunku' ),
            anchor: '100%',
            stripCharsRe: /\?|:/g,
            ref: 'acceptVarValueItem',
            value: acceptVarValueItemValue
        }, {
            xtype: 'textfield',
            inputType: 'text',
            fieldLabel: getTranslation( 'Wartość niespełnionego warunku' ),
            anchor: '100%',
            stripCharsRe: /\?|:/g,
            ref: 'checkVarValueItem',
            value: checkVarValueItemValue
        }, new Ext.ux.suncode.ActivityAcceptButtonsChooser( {
            activityNode: activityNode,
            fieldLabel: getTranslation( 'Nazwa przycisku' ),
            anchor: '100%',
            ref: 'buttonNameItem',
            value: buttonNameItemValue
        } ) ]
    }, config );

    Ext.ux.suncode.AcceptanceDefPanel.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.AcceptanceDefPanel, Ext.FormPanel, {
    initComponent: function() {
        Ext.ux.suncode.AcceptanceDefPanel.superclass.initComponent.call( this );
    },
    saveForm: function() {
        var activityNode = this.initialConfig.activityNode;
        var acceptance = this.initialConfig.acceptance;
        var saveToObj = this.initialConfig.saveTo;
        var varRecord = this.initialConfig.varRecord;
        var assignmentTypeItem = this.initialConfig.assignmentTypeItem;
        var id = acceptance ? acceptance.id : Ext.id();
        var acceptVar = this.acceptVarItem.items.first().getValue();
        var checkVar = this.checkVarItem.items.first().getValue();
        var resultVar = this.resultVarItem.items.first().getValue();
        var acceptVarValue = this.acceptVarValueItem.getValue();
        var checkVarValue = this.checkVarValueItem.getValue();
        var buttonName = this.buttonNameItem.getValue();

        if ( Ext.isEmpty( acceptVar ) || Ext.isEmpty( acceptVarValue ) || Ext.isEmpty( checkVar ) || Ext.isEmpty( checkVarValue )
                        || Ext.isEmpty( resultVar ) ) {
            showWarn( getTranslation( 'Uzupełnij poprawnie definicję akceptacji.' ) );
            return;
        }
        
        var acceptanceUpdate = acceptance ? true : false;
        if ( Ext.isEmpty( buttonName ) && !activityNode.validateGlobalAcceptance( acceptanceUpdate, id ) ) {
        	showWarn( getTranslation( 'Występuje już akceptacja bez zdefiniowanego przycisku.' ) );
        	return;
        } else if ( !Ext.isEmpty( buttonName ) && !activityNode.validateButtonAcceptance( acceptanceUpdate, id, buttonName ) ) {
        	showWarn( getTranslation( 'Występuje już akceptacja dla przycisku o nazwie' ) + ' ' + this.buttonNameItem.getRawValue()
        			+ '.');
        	return;
        }

        if ( saveToObj && varRecord ) {
            if ( acceptance ) {
                varRecord.set( 'acceptVar', acceptVar );
                varRecord.set( 'checkVar', checkVar );
                varRecord.set( 'resultVar', resultVar );
                varRecord.set( 'buttonName', buttonName );
                varRecord.commit();
            } else {
                var store = saveToObj.getStore();
                store.add( new varRecord( {
                    id: id,
                    acceptVar: acceptVar,
                    checkVar: checkVar,
                    resultVar: resultVar,
                    buttonName: buttonName
                } ) );
                store.commitChanges();
                saveToObj.updateTitle();
            }
        }

        var acceptanceObj = new Object();
        acceptanceObj = Ext.apply( {
            id: id,
            acceptVar: acceptVar,
            acceptVarValue: acceptVarValue,
            checkVar: checkVar,
            checkVarValue: checkVarValue,
            resultVar: resultVar,
            buttonName: buttonName
        }, acceptanceObj );

        if ( acceptance ) {
            activityNode.updateAcceptance( acceptance.id, acceptanceObj );
        } else {
            activityNode.addAcceptance( acceptanceObj );
        }

        activityNode.setAssignmentByAcceptance( acceptanceObj );
        var tabPanel = assignmentTypeItem.ownerCt.ownerCt;
        var propertiesPanel = assignmentTypeItem.ownerCt;
        tabPanel.activate( propertiesPanel );
        assignmentTypeItem.setValue( 'newAssignment' );
        assignmentTypeItem.fireEvent( 'afterrender', assignmentTypeItem );

        if ( saveToObj ) {
            tabPanel.activate( saveToObj );
        }

        this.ownerCt.closeWindow();
    }
} );