function IEWorkarounds() {
    if ( !Ext.isFunction( document.createElementNS ) ) {
        document.createElementNS = function( uri, name ) {
            return document.createElement( name );
        };
    }

    if ( typeof Range !== 'undefined' && !Range.prototype.createContextualFragment ) {
        Range.prototype.createContextualFragment = function( html ) {
            var frag = document.createDocumentFragment(), div = document.createElement( 'div' );
            frag.appendChild( div );
            div.outerHTML = html;
            return frag;
        };
    }

    if ( !Array.prototype.includes ) {
        Array.prototype.includes = function( obj ) {
            return this.indexOf( obj ) != -1;
        };
    }
}

function initQuickTips() {
    Ext.QuickTips.init();
}

function initPrototypeFunctions() {
    String.prototype.replaceAll = function( str1, str2, ignore ) {
        return this.replace( new RegExp( str1.replace( /([\/\,\!\\\^\$\{\}\[\]\(\)\.\*\+\?\|\<\>\-\&])/g, '\\$&' ), ( ignore ? 'gi' : 'g' ) ),
                        ( typeof ( str2 ) == 'string' ) ? str2.replace( /\$/g, '$$$$' ) : str2 );
    };

    String.prototype.removePolishLetters = function() {
        return this.replaceAll( 'ą', 'a' ).replaceAll( 'ć', 'c' ).replaceAll( 'ę', 'e' ).replaceAll( 'ł', 'l' ).replaceAll( 'ń', 'n' ).replaceAll(
                        'ó', 'o' ).replaceAll( 'ś', 's' ).replaceAll( 'ż', 'z' ).replaceAll( 'ź', 'z' );
    };

    String.prototype.removeSpecialChars = function() {
        return this.replace( /[^\w\s]/gi, '' );
    };

    String.prototype.isDCMapping = function() {
        return this.match( '^mapping[0-9]+$' );
    };

    String.prototype.isAcceptBtnAction = function() {
        return this.match( '^action[0-9]+$' );
    };

    String.prototype.isBtnParam = function() {
        return this.match( '^param[0-9]+$' );
    };

    String.prototype.startsWith = function( prefix ) {
        return ( this.match( '^' + prefix ) == prefix );
    };

    String.prototype.endsWith = function( suffix ) {
        return this.indexOf( suffix, this.length - suffix.length ) !== -1;
    };

    String.prototype.ellipse = function( maxLength ) {
        if ( this.length > maxLength ) {
            return this.substr( 0, maxLength - 3 ) + '...';
        }

        return this;
    };

    if ( !String.prototype.trim ) {
        String.prototype.trim = function() {
            return this.replace( /^\s+|\s+$/g, '' );
        };
    }

    if ( !Array.prototype.forEach ) {
        Array.prototype.forEach = function( func ) {
            this.each( func );
        };
    }
}

function ExtOverrides() {
    Ext.grid.GridView.prototype.templates = undefined;

    Ext.apply( Ext, {
        isEmpty: function( v, allowBlank ) {
            return v === null || v === undefined || ( ( Ext.isArray( v ) && !v.length ) )
                            || ( !allowBlank ? ( Ext.isString( v ) && v.trim() === '' ) : false );
        }
    } );

    Ext.override( Ext.form.Field, {
    	msgTarget: 'under',
        setFieldLabel: function( text ) {
            if ( this.rendered ) {
                var labelSeparator = Ext.isDefined( this.initialConfig.labelSeparator ) ? this.initialConfig.labelSeparator : ':';
                this.getEl().up( '.x-form-item', 10, true ).child( '.x-form-item-label' ).update( text + labelSeparator );
            }

            this.fieldLabel = text;
        },
        setValue: function( v ){
            this.value = v;
            if ( this.rendered ) {
                this.el.dom.value = ( Ext.isEmpty( v, true ) ? '' : v );
                if ( !this.preventSetValueValidation ) {
                	this.validate();
                }
            }
            return this;
        },
        initComponent: function() {
            Ext.form.Field.superclass.initComponent.call( this );
            this.addEvents(
                'focus',
                'blur',
                'specialkey',
                'change',
                'invalid',
                'valid'
            );
            this.on( 'change', this.storeParentWindowAsUnsaved, this );
        }
    } );
    
    Ext.override( Ext.form.Checkbox, {
        initComponent: function() {
        	Ext.form.Checkbox.superclass.initComponent.call(this);
            this.addEvents(
                'check'
            );
            this.on( 'check', this.storeParentWindowAsUnsaved, this );
        }
    } );
    
    Ext.override( Ext.Panel, {
        setFieldLabel: function( text ) {
            if ( this.rendered ) {
                var labelSeparator = Ext.isDefined( this.initialConfig.labelSeparator ) ? this.initialConfig.labelSeparator : ':';
                this.getEl().up( '.x-form-item', 10, true ).child( '.x-form-item-label' ).update( text + labelSeparator );
            }

            this.fieldLabel = text;
        }
    } );

    Ext.override( Ext.layout.ContainerLayout, {
        fieldTpl: new Ext.Template( '<div class="x-form-item {itemCls}" tabIndex="-1">', '<label '
                        + 'style="{labelStyle}" class="x-form-item-label">{label}{labelSeparator}</label>',
                        '<div class="x-form-element" id="x-form-el-{id}" style="{elementStyle}">', '</div><div class="{clearCls}"></div>', '</div>',
                        {
                            disableFormats: true,
                            compiled: true
                        } )
    } );

    Ext.override( Ext.form.TextField, {
        replaceSelectedText: function( replacement ) {
            var dom = this.getEl().dom;
            var beforeText = '';
            var afterText = '';
            var selectionStart = 0;

            if ( Ext.isIE ) {
                var sel = document.selection;
                var range = sel.createRange();
                var bookmark = range.getBookmark();
                var selection = dom.createTextRange();
                selection.moveToBookmark( bookmark );
                var before = dom.createTextRange();
                before.collapse( true );
                before.setEndPoint( 'EndToStart', selection );
                var after = dom.createTextRange();
                after.setEndPoint( 'StartToEnd', selection );
                beforeText = before.text;
                afterText = after.text;
                selectionStart = beforeText.length;
            } else {
                if ( dom.selectionEnd < 0 || dom.selectionStart < 0 || dom.selectionEnd < dom.selectionStart ) {
                    return;
                }

                beforeText = dom.value.substr( 0, dom.selectionStart );
                afterText = dom.value.substr( dom.selectionEnd );
                selectionStart = dom.selectionStart;
            }

            this.setValue( beforeText + replacement + afterText );
            this.selectText( selectionStart, selectionStart + replacement.length );
        },
        getCursorPosition: function() {
        	var dom = this.getEl().dom;
        	
        	if ( Ext.isIE ) {
                var sel = document.selection;
                var range = sel.createRange();
                var bookmark = range.getBookmark();
                var selection = dom.createTextRange();
                selection.moveToBookmark( bookmark );
                var before = dom.createTextRange();
                before.collapse( true );
                before.setEndPoint( 'EndToStart', selection );
                var after = dom.createTextRange();
                after.setEndPoint( 'StartToEnd', selection );
                
                return after.text.length;
            } else if ( dom.selectionEnd ) {
                return dom.selectionEnd;
            }
        },
        insertAtCursor: function( text, replaced ) {
            text = !Ext.isEmpty( text ) ? text : '';
            var cursorPosition = this.getCursorPosition();
            var dom = this.getEl().dom;
            var beforeTextIndex = !Ext.isEmpty( replaced, true ) ? cursorPosition - replaced.length : cursorPosition;
            var beforeText = dom.value.substr( 0, beforeTextIndex );
            var afterText = dom.value.substr( cursorPosition );
            this.setValue( beforeText + text + afterText );

            var selectTextTask = new Ext.util.DelayedTask( function() {
                this.selectText( beforeTextIndex + text.length, beforeTextIndex + text.length );
            }, this );
            selectTextTask.delay( 20 );
        },
        getPreviousText: function( marker ) {
        	var cursorPosition = this.getCursorPosition();
        	var dom = this.getEl().dom;
            var beforeText = dom.value.substr( 0, cursorPosition );
            
            if ( !Ext.isEmpty( marker, true ) && !Ext.isEmpty( beforeText ) ) {
            	var markerIndex = beforeText.lastIndexOf( marker, cursorPosition );
            	
            	if ( markerIndex != -1 ) {
            		beforeText = beforeText.substr( markerIndex + 1, beforeText.length -1 );
            	}
            }
            
            return beforeText;
        },
        getErrors: function( value ) {
            var errors = Ext.form.TextField.superclass.getErrors.apply( this, arguments );
            value = Ext.isDefined( value ) ? value : this.processValue( this.getRawValue() );

            if ( Ext.isFunction( this.validator ) ) {
                var msg = this.validator( value );
                if ( msg !== true ) {
                    errors.push( msg );
                }
            }

            if ( ( ( Ext.isString( value ) && value.trim().length < 1 ) || value.length < 1 ) || value === this.emptyText ) {
                if ( this.allowBlank ) {
                    return errors;
                } else {
                    errors.push( this.blankText );
                }
            }

            if ( !this.allowBlank && ( ( ( Ext.isString( value ) && value.trim().length < 1 ) || value.length < 1 ) || value === this.emptyText ) ) {
                errors.push( this.blankText );
            }

            if ( value.length < this.minLength ) {
                errors.push( String.format( this.minLengthText, this.minLength ) );
            }

            if ( value.length > this.maxLength ) {
                errors.push( String.format( this.maxLengthText, this.maxLength ) );
            }

            if ( this.vtype ) {
                var vt = Ext.form.VTypes;
                if ( !vt[this.vtype]( value, this ) ) {
                    errors.push( this.vtypeText || vt[this.vtype + 'Text'] );
                }
            }

            if ( this.regex && !this.regex.test( value ) ) {
                errors.push( this.regexText );
            }

            return errors;
        },
        selectText: function( start, end ) {
          var v = this.getRawValue();
          var doFocus = false;
          if ( v.length > 0 ) {
            start = start === undefined ? 0 : start;
            end = end === undefined ? v.length : end;
            var d = this.el.dom;
            if ( d.setSelectionRange ) {
              if ( Ext.isChrome ) {
                this.focus();
              }

              d.setSelectionRange( start, end );
            } else if ( d.createTextRange ) {
              var range = d.createTextRange();
              range.moveStart( 'character', start );
              range.moveEnd( 'character', end - v.length );
              range.select();
            }
            doFocus = Ext.isGecko || Ext.isOpera;
          } else {
            doFocus = true;
          }
          if ( doFocus ) {
            this.focus();
          }
        }
    } );

    Ext.override( Ext.form.ComboBox, {
        beforeBlur: function() {
            var val = this.getRawValue(), rec;
            if ( this.valueField && Ext.isDefined( this.value ) ) {
                rec = this.findRecord( this.valueField, this.value );
                if ( rec && rec.get( this.displayField ) == val ) {
                    return;
                }
            }
            rec = this.findRecord( this.displayField, val );
            if ( !rec && this.forceSelection ) {
                if ( val.length > 0 && val != this.emptyText ) {
                    this.el.dom.value = Ext.isDefined( this.lastSelectionText ) ? this.lastSelectionText : '';
                    this.applyEmptyText();
                    if ( !this.blockInvalidValueWarn ) {
                        showWarn( getTranslation( 'Wprowadzona wartość nie istnieje na liście.' ) );
                    }
                } else {
                    this.clearValue();
                }
            } else {
                if ( rec ) {
                    val = rec.get( this.valueField || this.displayField );
                }
                this.setValue( val );
            }
        },
        assertValue: function() {
          var val = this.getRawValue();
          var recs = [];

          if ( this.store.getCount() > 0 ) {
            this.store.each( function( r ) {
              if ( r.data[this.displayField] == val ) {
                recs.push( r );
              }
            }, this );
          }

          if ( Ext.isEmpty( recs ) && this.forceSelection ) {
            if ( val.length > 0 && val != this.emptyText ) {
              this.el.dom.value = Ext.value( this.lastSelectionText, '' );
              this.applyEmptyText();
            } else {
              this.clearValue();
            }
          } else {
            if ( !Ext.isEmpty( recs ) ) {
              for ( var i = 0; i < recs.length; i++ ) {
                var rec = recs[i];
                if ( val == rec.get( this.displayField ) && this.value == rec.get( this.valueField ) ) {
                  return;
                }
              }
              val = recs[0].get( this.valueField || this.displayField );
            }
            this.setValue( val );
          }
        }
    } );
    
    Ext.override( Ext.Component, {
    	onShow: function() {
            this.getVisibilityEl().removeClass( 'x-hide-' + this.hideMode );
            
    		if ( Ext.isWebKit ) {
    			this.getVisibilityEl().show();
    		}
        },
    	onHide: function() {
    		this.getVisibilityEl().addClass( 'x-hide-' + this.hideMode );
            
    		if ( Ext.isWebKit ) {
    			this.getVisibilityEl().hide();
    		}
        },
        storeParentWindowAsUnsaved: function() {
        	var win = this.getParentWindow();
        	
        	if ( !Ext.isEmpty( win ) ) {
        		var mainPanel = Ext.getCmp( 'main_panel' );
        		
        		if ( !Ext.isEmpty( mainPanel ) ) {
        			mainPanel.storeUnsavedWindow( win.getId() );
        		}
        	}
        },
        getParentWindow: function() {
        	var parent = this.ownerCt;
        	
        	 while ( parent != null ) {
        		 if ( Ext.isFunction( parent.toFront ) ) {
        			 return parent;
        		 }
        		 
        		 parent = parent.ownerCt;
        	 }
        	 
        	 return null;
        }
    } );
    
    Ext.override( Ext.Window, {
    	disableCloseValidation: false,
    	shouldValidateClose: false,
    	initTools: function() {
            if ( this.minimizable ) {
                this.addTool( {
                    id: 'minimize',
                    handler: this.minimize.createDelegate( this, [] )
                } );
            }
            if ( this.maximizable ) {
                this.addTool( {
                    id: 'maximize',
                    handler: this.maximize.createDelegate( this, [] )
                } );
                this.addTool( {
                    id: 'restore',
                    handler: this.restore.createDelegate( this, [] ),
                    hidden: true
                } );
            }
            if ( this.closable ) {
                this.addTool({
                    id: 'close',
                    handler: function() {
                    	this.shouldValidateClose = true;
                    	this[this.closeAction]();
                    },
                    scope: this
                } );
            }
        },
    	  onEsc: function( k, e ){
            if ( this.activeGhost ) {
                return;
            }
            e.stopEvent();
            this.shouldValidateClose = true;
            this[this.closeAction]();
        },
        onShow: function() {
        	this.on( 'beforeclose', this.validateClose, this );

          if ( this.shouldManageOpenedWindow() ) {
            var mainPanel = Ext.getCmp( 'main_panel' );
            mainPanel.addOpenedWindow( this );
          }
        },
        validateClose: function() {
        	var mainPanel = Ext.getCmp( 'main_panel' );
        	if ( Ext.isEmpty( mainPanel ) ) {
        		return;
        	}
        	var id = this.getId();
        	
        	if ( !this.disableCloseValidation && this.shouldValidateClose && mainPanel.isWindowUnsaved( id ) ) {
        		Ext.Msg.show( {
                    title: '<font weight="bold">' + getTranslation( 'Uwaga' ) + '</font>',
                    msg: getTranslation( 'Zmiany są niezapisane. Czy chcesz zamknąć okno?' ),
                    buttons: {
                        yes: getTranslation( 'Tak' ),
                        no: getTranslation( 'Nie' )
                    },
                    fn: function( buttonId ) {
                        if ( buttonId == 'yes' ) {
                        	mainPanel.removeUnsavedWindow( id );
                          mainPanel.removeLastOpenedWindow();
                          this.doClose();
                        } else {
                        	this.shouldValidateClose = false;
                        	this.focus();
                        }
                    },
                    icon: Ext.Msg.QUESTION,
                    scope: this
                } );
        		
        		return false;
        	} else {
        		mainPanel.removeUnsavedWindow( id );

            if ( this.shouldManageOpenedWindow() ) {
              mainPanel.removeLastOpenedWindow();
            }

        		return true;
        	}
        },
        shouldManageOpenedWindow: function() {
          var tbar = this.getTopToolbar();

          return ( !Ext.isEmpty( tbar ) && !Ext.isEmpty( tbar.saveBtn ) );
        }
    } );
    
    Ext.override( Ext.tree.TreeNodeUI, {
    	getChildIndent: function() {
    		if ( !this.childIndent ) {
                var buf = [],
                    p = this.node;
                while ( p ) {
                    if ( ( !p.isRoot || ( p.isRoot && p.ownerTree.rootVisible ) ) && !p.attributes.noIndent ) {
                        if ( !p.isLast() ) {
                            buf.unshift( '<img alt="" src="' + this.emptyIcon + '" class="x-tree-elbow-line" />' );
                        } else {
                            buf.unshift( '<img alt="" src="' + this.emptyIcon + '" class="x-tree-icon" />' );
                        }
                    }
                    p = p.parentNode;
                }
                this.childIndent = buf.join( '' );
            }
            return this.childIndent;
    	}
    } );
}

function logError( e ) {
    if ( typeof console !== 'undefined' && e && e.message && Ext.isFunction( e.message.indexOf ) && e.message.indexOf( 'readXpdl' ) == -1 ) {
        console.log( e );
    }
}

function logFormTemplateReaderError( processDefId, activityDefId ) {
    if ( typeof console !== 'undefined' ) {
        console.log( 'Zadanie o id ' + activityDefId + ' w procesie o id ' + processDefId + ' nie istnieje.' );
    }
}

function generateId( name, limit ) {
    var id = name.trim().toLowerCase().removePolishLetters().removeSpecialChars().replace( /\s+/g, ' ' ).replaceAll( ' ', '_' )
    	.replace( /^\d+/, '' ).replace( /_{2,}/, '_' );

    if ( Ext.isNumber( limit ) && id.length > limit ) {
        id = id.substring( 0, limit );
    }

    if ( id.endsWith( '_' ) ) {
        id = id.substring( 0, id.length - 1 );
    }

    return id;
}

function generateAutoUpdateId( autoUpdate ) {
    var id = '';

    if ( autoUpdate.taskNameType == 'RESTful' ) {
        id += 'api/';
    }

    id += autoUpdate.taskName;

    if ( autoUpdate.taskNameType == 'Struts' ) {
        id += '.do';
    } else if ( autoUpdate.taskNameType == 'Servlet' ) {
        id += '.customServlet';
    }

    id += ',';

    if ( !Ext.isEmpty( autoUpdate.dataSources ) ) {
        Ext.each( autoUpdate.dataSources, function( dataSource, index, dataSources ) {
            id += dataSource.varId + ',';
        } );
    }

    if ( !Ext.isEmpty( autoUpdate.destinations ) ) {
        Ext.each( autoUpdate.destinations, function( destination, index, destinations ) {
            id += destination.varId + ',';
        } );
    }

    return id;
}

function generateTransitionId() {
    var mainPanel = Ext.getCmp( 'main_panel' );
    var id = 'transition_' + Ext.id();

    while ( !mainPanel.isTransitionIdUnique( id ) ) {
        id = 'transition_' + Ext.id();
    }

    return id;
}

function generateGlobalId() {
  var mainPanel = Ext.getCmp( 'main_panel' );
  var id = 'global_id_' + Ext.id();

  while ( !mainPanel.isGlobalIdUnique( id ) ) {
    id = 'global_id_' + Ext.id();
  }

  return id;
}

function areIdsTheSame( oldId, newId ) {
    return ( !Ext.isEmpty( oldId ) && !Ext.isEmpty( newId ) && oldId.toLowerCase() === newId.toLowerCase() );
}

function isInteger( value ) {
    try {
        var int = parseInt( value );

        return Ext.isNumber( int );
    }
    catch ( e ) {
        return false;
    }
}

function showMenu( menu, e ) {
    menu.showAt( [ e.getPageX(), e.getPageY() ] );
}

function showWarn( msg ) {
    var warnDialog = Ext.Msg.show( {
        title: '<font weight="bold">' + getTranslation( 'Uwaga' ) + '</font>',
        msg: msg,
        buttons: Ext.Msg.OK,
        icon: Ext.Msg.WARNING,
        minWidth: 250,
    } ).getDialog();
    warnDialog.toFront();
    closeDialogOnMaskClick( warnDialog );
}

function closeDialogOnMaskClick( dialog ) {
    var mask = Ext.get( dialog.mask.id );
    mask.on( 'click', function( e ) {
        var button = dialog.buttons[0];

        if ( button ) {
            button.handler.call( button );
        }
    } );
}

function showPackageExportException( packageLoad ) {
    Ext.Msg.show( {
        title: '<font weight="bold">' + getTranslation( 'Uwaga' ) + '</font>',
        msg: getTranslation( packageLoad.loadError ),
        buttons: !Ext.isEmpty( packageLoad.detailedError ) ? {
            yes: getTranslation( 'Zamknij' ),
            no: getTranslation( 'Szczegoly >>' )
        } : {
            yes: getTranslation( 'Zamknij' )
        },
        fn: function( buttonId ) {
            if ( buttonId == 'no' ) {
                showWarn( packageLoad.detailedError );
            }
        },
        icon: Ext.Msg.QUESTION,
        scope: this
    } );
}

function getInsertPos( p, obj ) {
    var insertPos = 0;
    var objId = obj.getId();
    var items = p.items.items;

    Ext.each( items, function( item, index, items ) {
        if ( item.getId() == objId ) {
            insertPos = index + 1;
            return;
        }
    }, p );

    return insertPos;
}

function windowUp() {
    var y = getPageYOffset() + calculateVersionBarHeight();

    this.setPosition( this.getPosition()[0], y );
}

function getPageYOffset() {
    if ( Ext.isIE && Ext.isStrict ) {
        return document.documentElement.scrollTop;
    } else {
        return window.pageYOffset;
    }
}

function calculateVersionBarHeight() {
  return !Ext.isEmpty( document.getElementsByClassName( 'version-bar' ) ) ? 32 : 0;
}

function updateActivityLocation( activityDefId, x, y ) {
    var packagePanel = Ext.getCmp( 'package_panel' );
    var processDefId = Ext.getCmp( 'paper_panel' ).getActiveTab().processDefId;
    var activityNode = packagePanel.findActivity( processDefId, activityDefId );
    activityNode.updateActivityLocation( x, y );
}

function addProcessStart( terminationId, roleId, x, y, activityDefId ) {
    var procDefId = Ext.getCmp( 'paper_panel' ).getActiveTab().processDefId;
    var processNode = Ext.getCmp( 'package_panel' ).findProcess( procDefId );
    if ( activityDefId == undefined ) {
        activityDefId = '';
    }
    processNode.addStart( {
        terminationId: terminationId,
        roleId: roleId,
        connectingActivity: activityDefId,
        xOffset: x,
        yOffset: y
    } );
}

function setProcessStartLocation( terminationId, roleId, x, y, activityDefId ) {
    var procDefId = Ext.getCmp( 'paper_panel' ).getActiveTab().processDefId;
    var processNode = Ext.getCmp( 'package_panel' ).findProcess( procDefId );
    processNode.setStartLocation( terminationId, roleId, x, y );

    if ( activityDefId != undefined ) {
        processNode.setStartConnectingActivity( activityDefId );
    }
}

function setStartConnectingActivity( terminationId, activityDefId ) {
    var procDefId = Ext.getCmp( 'paper_panel' ).getActiveTab().processDefId;
    var processNode = Ext.getCmp( 'package_panel' ).findProcess( procDefId );
    processNode.setStartConnectingActivity( terminationId, activityDefId );
}

function resetStartConnectingActivity( terminationId ) {
    var procDefId = Ext.getCmp( 'paper_panel' ).getActiveTab().processDefId;
    var processNode = Ext.getCmp( 'package_panel' ).findProcess( procDefId );
    processNode.setStartConnectingActivity( terminationId, '' );
}

function removeProcessStart( terminationId ) {
    var procDefId = Ext.getCmp( 'paper_panel' ).getActiveTab().processDefId;
    var processNode = Ext.getCmp( 'package_panel' ).findProcess( procDefId );
    processNode.removeStart( terminationId );
}

function addProcessStop( terminationId, roleId, x, y, activityDefId ) {
    var procDefId = Ext.getCmp( 'paper_panel' ).getActiveTab().processDefId;
    var processNode = Ext.getCmp( 'package_panel' ).findProcess( procDefId );
    if ( activityDefId == undefined ) {
        activityDefId = '';
    }
    processNode.addStop( {
        terminationId: terminationId,
        roleId: roleId,
        connectingActivity: activityDefId,
        xOffset: x,
        yOffset: y
    } );
}

function setProcessStopLocation( terminationId, roleId, x, y, activityDefId ) {
    var procDefId = Ext.getCmp( 'paper_panel' ).getActiveTab().processDefId;
    var processNode = Ext.getCmp( 'package_panel' ).findProcess( procDefId );
    processNode.setStopLocation( terminationId, roleId, x, y );

    if ( activityDefId != undefined ) {
        processNode.setStopConnectingActivity( activityDefId );
    }
}

function setStopConnectingActivity( terminationId, activityDefId ) {
    var procDefId = Ext.getCmp( 'paper_panel' ).getActiveTab().processDefId;
    var processNode = Ext.getCmp( 'package_panel' ).findProcess( procDefId );
    processNode.setStopConnectingActivity( terminationId, activityDefId );
}

function resetStopConnectingActivity( terminationId ) {
    var procDefId = Ext.getCmp( 'paper_panel' ).getActiveTab().processDefId;
    var processNode = Ext.getCmp( 'package_panel' ).findProcess( procDefId );
    processNode.setStopConnectingActivity( terminationId, '' );
}

function removeProcessStop( terminationId ) {
    var procDefId = Ext.getCmp( 'paper_panel' ).getActiveTab().processDefId;
    var processNode = Ext.getCmp( 'package_panel' ).findProcess( procDefId );
    processNode.removeStop( terminationId );
}

function initAddActivity( task, x, y, iconImg, condConn ) {
    var processPanel = Ext.getCmp( 'paper_panel' ).getActiveTab();
    if ( condConn ) {
        processPanel.conditionalLineStep = 3;
    }

    processPanel.initAddActivity( task, x, y, iconImg );
}

function addBasicTransition( from, t ) {
    var packagePanel = Ext.getCmp( 'package_panel' );
    var processDefId = Ext.getCmp( 'paper_panel' ).getActiveTab().processDefId;
    var fromActivityNode = packagePanel.findActivity( processDefId, from );
    fromActivityNode.addBasicTransition( t );
    var toActivityNode = packagePanel.findActivity( processDefId, t.to );
    toActivityNode.incrementIncomingTransitions();
}

function updateBasicTransition( from, t ) {
    var packagePanel = Ext.getCmp( 'package_panel' );
    var processDefId = Ext.getCmp( 'paper_panel' ).getActiveTab().processDefId;
    var activityNode = packagePanel.findActivity( processDefId, from );
    activityNode.updateBasicTransition( t );
}

function addCondTransition( from, t ) {
    var packagePanel = Ext.getCmp( 'package_panel' );
    var processDefId = Ext.getCmp( 'paper_panel' ).getActiveTab().processDefId;
    var fromActivityNode = packagePanel.findActivity( processDefId, from );
    fromActivityNode.addCondTransition( t );
    var toActivityNode = packagePanel.findActivity( processDefId, t.to );
    toActivityNode.incrementIncomingTransitions();
}

function updateCondTransitionLinePathsWithDir( from, t ) {
    var packagePanel = Ext.getCmp( 'package_panel' );
    var processDefId = Ext.getCmp( 'paper_panel' ).getActiveTab().processDefId;
    var activityNode = packagePanel.findActivity( processDefId, from );
    activityNode.updateCondTransitionLinePathsWithDir( t );
}

function updateCondTransitionBoxInfo( from, t ) {
    var packagePanel = Ext.getCmp( 'package_panel' );
    var processDefId = Ext.getCmp( 'paper_panel' ).getActiveTab().processDefId;
    var activityNode = packagePanel.findActivity( processDefId, from );
    activityNode.updateCondTransitionBoxInfo( t );
}

function addOtherwiseTransition( from, t ) {
    var packagePanel = Ext.getCmp( 'package_panel' );
    var processDefId = Ext.getCmp( 'paper_panel' ).getActiveTab().processDefId;
    var fromActivityNode = packagePanel.findActivity( processDefId, from );
    fromActivityNode.addOtherwiseTransition( t );
    var toActivityNode = packagePanel.findActivity( processDefId, t.to );
    toActivityNode.incrementIncomingTransitions();
}

function updateOtherwiseTransition( from, t ) {
    var packagePanel = Ext.getCmp( 'package_panel' );
    var processDefId = Ext.getCmp( 'paper_panel' ).getActiveTab().processDefId;
    var activityNode = packagePanel.findActivity( processDefId, from );
    activityNode.updateOtherwiseTransition( t );
}

function addDeadlineTransition( from, t ) {
    var packagePanel = Ext.getCmp( 'package_panel' );
    var processDefId = Ext.getCmp( 'paper_panel' ).getActiveTab().processDefId;
    var fromActivityNode = packagePanel.findActivity( processDefId, from );
    fromActivityNode.addDeadlineTransition( t );
    var toActivityNode = packagePanel.findActivity( processDefId, t.to );
    toActivityNode.incrementIncomingTransitions();
}

function updateDeadlineTransition( from, t ) {
    var packagePanel = Ext.getCmp( 'package_panel' );
    var processDefId = Ext.getCmp( 'paper_panel' ).getActiveTab().processDefId;
    var activityNode = packagePanel.findActivity( processDefId, from );
    activityNode.updateDeadlineTransition( t );
}

function decomposePathAttrFromLineSet( lineSet ) {
    var paths = new Array();

    for ( var i = 0; i < lineSet.length; i++ ) {
        paths.push( decomposePathAttr( lineSet[i].attr( 'path' ) ) );
    }

    return paths;
}

function decomposePathAttr( path ) {
    var pathDef = '';

    for ( var i = 0; i < path.length; i++ ) {
        var seg = path[i];

        for ( var j = 0; j < seg.length; j++ ) {
            if ( j > 1 ) {
                pathDef += ' ';
            }

            pathDef += seg[j];
        }
    }

    return pathDef;
}

function decomposeBasicPathToBreakPoints( path ) {
    return decomposePathToBreakPoints( path, 1, 1 );
}

function decomposeCondPathToBreakPoints( boxPath, linePath ) {
    return decomposePathToBreakPoints( boxPath, 1, 0 ) + '-' + decomposePathToBreakPoints( linePath, 0, 1 );
}

function decomposePathToBreakPoints( path, from, to ) {
    if ( path.startsWith( 'M' ) ) {
        path = path.substring( 1, path.length );
    }

    var pathSplit = path.split( 'L' );
    var pathDef = '';

    for ( var i = 0 + from; i < pathSplit.length - to; i++ ) {
        var seg = pathSplit[i];
        var segSplit = seg.split( ' ' );

        if ( !Ext.isEmpty( pathDef ) ) {
            pathDef += '-';
        }

        pathDef += segSplit[0] + ',' + segSplit[1];
    }

    return pathDef;
}

function clearPath( path, control ) {
    var clearedPath = new Array();
    var mPath = path[0];
    var xStart = parseInt( mPath[1] );
    var yStart = parseInt( mPath[2] );
    var section = {
        x1: 0,
        y1: 0,
        x2: xStart,
        y2: yStart
    };

    clearedPath.push( [ 'M', xStart, yStart ] );

    for ( var i = 1; i < path.length; i++ ) {
        var seg = path[i];

        var letter = '';
        var x = 0;
        var y = 0;

        if ( seg[0] == 'C' ) {
            letter = 'L';
            x = parseInt( seg[3] );
            y = parseInt( seg[4] );
        } else {
            letter = seg[0];
            x = parseInt( seg[1] );
            y = parseInt( seg[2] );
        }

        if ( control && isPointInsidePath( x, y, section ) ) {
            clearedPath[clearedPath.length - 1] = [ 'L', x, y ];
            continue;
        }

        clearedPath.push( [ letter, x, y ] );
        section = {
            x1: section.x2,
            y1: section.y2,
            x2: x,
            y2: y
        };
    }

    return clearedPath;
}

function isPointInsidePath( x, y, section ) {
    return ( y - section.y1 ) * ( section.x2 - section.x1 ) == ( section.y2 - section.y1 ) * ( x - section.x1 );
}

function isPointXBetweenLineEnds( x, x1, x2 ) {
    if ( x1 < x2 ) {
        if ( x > x1 && x < x2 ) {
            return true;
        } else {
            return false;
        }
    } else {
        if ( x < x1 && x > x2 ) {
            return true;
        } else {
            return false;
        }
    }
}

function isPointYBetweenLineEnds( y, y1, y2 ) {
    if ( y1 < y2 ) {
        if ( y > y1 && y < y2 ) {
            return true;
        } else {
            return false;
        }
    } else {
        if ( y < y1 && y > y2 ) {
            return true;
        } else {
            return false;
        }
    }
}

function randomInsidePoint( dimension, start ) {
    var k = 5;
    return parseInt( Math.random() * ( dimension - 2 * k ) + start + k );
}

function removeTransition( type, transitionId, from, to ) {
    var packagePanel = Ext.getCmp( 'package_panel' );
    var processDefId = Ext.getCmp( 'paper_panel' ).getActiveTab().processDefId;
    var fromActivityNode = packagePanel.findActivity( processDefId, from );

    switch ( type ) {
        case 'basic':
            fromActivityNode.removeBasicTransition( transitionId );
            break;
        case 'cond':
            fromActivityNode.removeCondTransition( transitionId );
            break;
        case 'otherwise':
            fromActivityNode.removeOtherwiseTransition( transitionId );
            break;
        case 'exception':
            fromActivityNode.removeDeadlineTransition( transitionId );
            break;
        default:
            break;
    }

    var toActivityNode = packagePanel.findActivity( processDefId, to );
    if ( toActivityNode ) {
        toActivityNode.decrementIncomingTransitions();
    }
}

function changeProcessTab( processDefId ) {
    var paperPanel = Ext.getCmp( 'paper_panel' );
    var processPanel = paperPanel.find( 'processDefId', processDefId )[0];
    
    if ( !Ext.isEmpty( processPanel ) ) {
    	paperPanel.unhideTabStripItem( processPanel );
        processPanel.show();
        
        return processPanel;
    } else {
    	return null;
    }
}

function getActivityTransitionsStore( activityNode ) {
    var packagePanel = Ext.getCmp( 'package_panel' );
    var processNode = activityNode.parentNode;
    var processDefId = processNode.attributes.processDefId
    var packageNode = processNode.parentNode;
    var packageId = packageNode.attributes.packageId

    var store = new Ext.data.Store( {
        reader: new Ext.data.JsonReader( {
            fields: Ext.data.Record.create( [ {
                name: 'activityDefId',
                type: 'string'
            }, {
                name: 'activityName',
                type: 'string'
            }, {
                name: 'condition',
                type: 'string'
            }, {
                name: 'transitionId',
                type: 'string'
            } ] )
        } )
    } );

    var c = store.recordType;

    Ext.each( activityNode.attributes.transitions.cond, function( t, idx, ts ) {
        var toActivityDefId = t.to;
        var toActivityNode = packagePanel.findActivity( processDefId, toActivityDefId );
        var toActivityName = toActivityNode.attributes.activityName;
        var toActivityNameTranslation = getXpdlActivityNameTranslation( packageId, processDefId, toActivityDefId, toActivityName );

        var rec = new c( {
            activityDefId: toActivityDefId,
            activityName: toActivityNameTranslation,
            condition: t.condition,
            transitionId: t.id
        } );

        store.add( rec );
    } );

    store.commitChanges();

    return store;
}

function getNextActivities( activityNode, visitedActivityDefIds ) {
    var nextActivities = new Array();
    var packagePanel = Ext.getCmp( 'package_panel' );
    var processDefId = Ext.getCmp( 'paper_panel' ).getActiveTab().processDefId;
    nextActivities = nextActivities.concat( getNextActivitiesForTransitions( packagePanel, processDefId, activityNode.attributes.transitions.cond,
                    visitedActivityDefIds ) );
    nextActivities = nextActivities.concat( getNextActivitiesForTransitions( packagePanel, processDefId, activityNode.attributes.transitions.basic,
                    visitedActivityDefIds ) );

    return nextActivities;
}

function getNextActivitiesForTransitions( packagePanel, processDefId, transitions, visitedActivityDefIds ) {
    var nextActivities = new Array();

    Ext.each( transitions, function( t, idx, ts ) {
        var to = t.to;
        var toActivityNode = packagePanel.findActivity( processDefId, to );
        var activityType = toActivityNode.attributes.activityType;

        if ( visitedActivityDefIds.indexOf( to ) == -1 ) {
          visitedActivityDefIds.push( to );

          if ( activityType == Ext.ux.suncode.Constants.ACTIVITY || activityType == Ext.ux.suncode.Constants.SUBFLOW ) {
            var nextActivity = new Object();
            nextActivity = Ext.apply( {
              activityDefId: to,
              activityName: toActivityNode.attributes.activityName
            }, nextActivity );

            nextActivities.push( nextActivity );
          } else {
            nextActivities = nextActivities.concat( getNextActivities( toActivityNode, visitedActivityDefIds ) );
          }
        }
    } );

    return nextActivities;
}

function wheel( event ) {
    if ( !event ) {
        event = parent.window.event;
    }

    if ( !event.ctrlKey ) {
        return;
    }

    if ( event.preventDefault ) {
        event.preventDefault();
    }

    event.returnValue = false;

    var delta = 0;
    var processPanel = Ext.getCmp( 'paper_panel' ).getActiveTab();

    if ( !processPanel || processPanel.paper.bpmn.elDragged ) {
        return;
    }

    if ( event.wheelDelta ) {
        delta = event.wheelDelta / 120;
    } else if ( event.detail ) {
        delta = -event.detail / 3;
    }

    if ( delta ) {
        handleWheel( delta, processPanel, event );
    }
}

function handleWheel( delta, processPanel, event ) {
    if ( delta < 0 ) {
        var zoomOutButton = Ext.getCmp( 'zoom_out_button' );
        if ( zoomOutButton.disabled ) {
            return;
        }

        zoomOutButton.handler.call( zoomOutButton );
    } else {
        var zoomInButton = Ext.getCmp( 'zoom_in_button' );
        if ( zoomInButton.disabled ) {
            return;
        }

        zoomInButton.handler.call( zoomInButton );
    }

    processPanel.executeMouseMove( {
        getPageX: function() {
            return event.pageX;
        },
        getPageY: function() {
            return event.pageY;
        }
    } );
}

function decodeTextFromXpdl( text ) {
    return unescapeHTML(text.replaceAll( '@PWE_QOUTE@', '"' ).replaceAll( '@PWE_AMP@', '&' ));
}

function unescapeHTML(htmlString) {
    const doc = new DOMParser().parseFromString(htmlString, 'text/html');
    return doc.documentElement.textContent;
}

function decodeXpdlTranslations( text ) {
    return text.replaceAll( '@PWE_LT@', '<' ).replaceAll( '@PWE_GT@', '>' );
}

function parseBoolean( txt ) {
    return txt.toUpperCase() === 'TRUE';
}

function analyzeParticipantType( type ) {
    if ( type == 'ROLE' || type == 'SYSTEM' || type == 'RESOURCE' ) {
        return type;
    }

    return 'ROLE';
}

function addHotkeys() {
    Ext.EventManager.removeListener( document, 'keyup', executeHotkey );
    Ext.EventManager.addListener( document, 'keyup', executeHotkey );
}

function executeHotkey( e ) {
    var key = e.getKey();
    var mainPanel = Ext.getCmp( 'main_panel' );

    if ( mainPanel.areHotkeysLocked() && key != e.F1 && key != e.F5 ) {
        return;
    }

    switch ( key ) {
        case e.ESC:
            Ext.getCmp( 'paper_panel' ).getTopToolbar().deactivateUsedButton();
            break;
        case e.F1:
            help();
            break;
        case e.F2:
            var packagePanel = Ext.getCmp( 'package_panel' );
            var node = packagePanel.getSelectionModel().getSelectedNode();

            if ( node ) {
                if ( node.attributes.packageId ) {
                    showPackageProperties( node );
                } else if ( node.attributes.processDefId ) {
                    showProcessProperties( node );
                } else if ( node.attributes.activityDefId ) {
                    showActivityProperties( {
                      activityNode: node
                    } );
                }
            } else {
                showPackageProperties( packagePanel.getRootNode() );
            }
            break;
        case e.F5:
            if ( !( e.ctrlKey || e.altKey ) ) {
                refresh();
            }
            break;
        case e.N:
            if ( e.ctrlKey && !e.altKey ) {
                createNewProcess( {
                    initialProcessNameMask: 'VER'
                } );
            }
            break;
        case e.S:
            if ( e.ctrlKey && !e.altKey ) {
              var openedWindow = mainPanel.getLastOpenedWindow();

              if ( !Ext.isEmpty( openedWindow ) ) {
                var tbar = openedWindow.getTopToolbar();

                if ( !Ext.isEmpty( tbar ) && !Ext.isEmpty( tbar.saveBtn ) ) {
                  var saveButton = tbar.saveBtn
                  saveButton.handler.call( saveButton.scope, e );
                }
              } else {
                saveXpdl();
              }
            }
            break;
        case e.P:
            if ( e.ctrlKey && !e.altKey ) {
                showXpdlPreview();
            }
            break;
        case e.G:
            if ( e.ctrlKey && !e.altKey ) {
                generateZip(new Object() );
            }
            break;
        case e.E:
            if ( e.ctrlKey && !e.altKey ) {
                executeValidateXpdl( {
                    doExportXpdl: true,
                    doExportPackageTranslations: false
                } );
            }
            break;
        case e.W:
            if ( e.ctrlKey && !e.altKey ) {
                validateXpdl();
            }
            break;
        case e.B:
            if ( e.ctrlKey && !e.altKey ) {
                changeAdvancedView();
            }
            break;
        case e.T:
            if ( e.ctrlKey && !e.altKey ) {
                changeTooltipVisibility();
            }
            break;
        case e.O:
            if ( e.ctrlKey && !e.altKey ) {
                openXpdl();
            }
            break;
        default:
            break;
    }
}

function getProcessTabTip( processDefId ) {
    var mainPanel = Ext.getCmp( 'main_panel' );
    if ( !mainPanel.getShowTooltips() ) {
        return;
    }

    var AV = mainPanel.getAdvancedView();
    var packagePanel = Ext.getCmp( 'package_panel' );
    var processNode = packagePanel.findProcess( processDefId );
    var processName = processNode.attributes.processName;
    var processNameTranslation = getXpdlProcessNameTranslation( processDefId, processName );

    var tooltipText = '<table border="0"><tr><td width="25"><img src="' + getPluginImgPath( 'process' ) + '"></td>';
    tooltipText += '<td><b>' + getTranslation( 'Nazwa procesu' ) + ':</b> ' + processNameTranslation + '<br>';
    tooltipText += '<b>' + getTranslation( 'Opis procesu' ) + ':</b> ' + processNode.attributes.processDescr + '<br>';
    tooltipText += '<b>' + getTranslation( 'Ilość uczestników' ) + ':</b> ' + processNode.attributes.participants.length + '<br>';
    tooltipText += '<b>' + getTranslation( 'Ilość zadań' ) + ':</b> ' + processNode.childNodes.length + '<br>';
    if ( AV ) {
        tooltipText += '<b>' + getTranslation( 'Ilość parametrów formalnych' ) + ':</b> ' + processNode.childNodes.length + '<br>';
    }
    tooltipText += '<b>' + getTranslation( 'Ilość zmiennych procesu' ) + ':</b> ' + processNode.attributes.variables.length + '<br>';
    tooltipText += '<b>' + getTranslation( 'Ilość tabel' ) + ':</b> ' + processNode.attributes.tables.length + '<br>';
    tooltipText += '<b>' + getTranslation( 'Ilość etykiet' ) + ':</b> ' + processNode.attributes.labels.length + '<br>';
    if ( AV ) {
        tooltipText += '<b>' + getTranslation( 'Ilość aplikacji' ) + ':</b> ' + processNode.attributes.applications.length + '</td></tr></table>';
    }
    tooltipText += '</td></tr></table>';

    return tooltipText;
}

function updateProcessTabTip() {
    var paperPanel = Ext.getCmp( 'paper_panel' );
    var processPanel = paperPanel.getActiveTab();
    var tabEl = Ext.get( paperPanel.getTabEl( processPanel ) );
    tabEl.child( 'span.x-tab-strip-text', true ).qtip = getProcessTabTip( processPanel.processDefId );
}

function updateAllProcessTabTips( showTooltips ) {
    var paperPanel = Ext.getCmp( 'paper_panel' );

    Ext.each( paperPanel.items.items, function( processPanel, index, processPanels ) {
        var tabEl = Ext.get( paperPanel.getTabEl( processPanel ) );
        var child = tabEl.child( 'span.x-tab-strip-text', true );

        if ( showTooltips ) {
            child.qtip = getProcessTabTip( processPanel.processDefId );
        } else {
            child.qtip = undefined;
        }
    } );
}

function handleProcessFullScreen() {
    var packagePanel = Ext.getCmp( 'package_panel' );

    if ( packagePanel.collapsed ) {
        packagePanel.expand();
    } else {
        packagePanel.collapse();
    }
}

function changePlacementInTab( tab, sindex, dindex ) {
    var obj = tab.splice( sindex, 1 )[0];
    tab.splice( dindex, 0, obj );
}

function removeRowAndMarkNext( grid, row ) {
    var store = grid.getStore();
    var idx = store.indexOf( row );
    store.remove( row );
    store.commitChanges();
    var storeCount = store.getCount();

    if ( storeCount > 0 ) {
        if ( storeCount <= idx ) {
            idx--;
        }

        grid.getSelectionModel().selectRow( idx );
    }
}

function exitProgram() {
    if ( Ext.getCmp( 'main_panel' ).getAnimationsOn() ) {
        Ext.getCmp( 'paper_panel' ).exit();
    } else {
        onExitProgram();
    }
}

function onExitProgram() {
	var mainPanel = Ext.getCmp( 'main_panel' );
	mainPanel.setCheckSavedOnUnload( false );
	
    if ( history.length < 2 ) {
        document.location.href = '/ShowWorkListAction.do';
    } else {
        history.back();
    }
}

function logPluginCloseAudit() {
  Ext.Ajax.request( {
    url: 'close',
    method: 'GET'
  } );
}

function refresh() {
    if ( Ext.getCmp( 'main_panel' ).isSaved() ) {
        onRefresh();
        return;
    }

    Ext.Msg.show( {
        title: getTranslation( 'Uwaga' ),
        msg: getTranslation( 'Plik jest niezapisany. Zapisać przed wykonaniem operacji?' ),
        buttons: {
            yes: getTranslation( 'Tak' ),
            no: getTranslation( 'Nie' ),
            cancel: getTranslation( 'Anuluj' )
        },
        fn: function( buttonId ) {
            switch ( buttonId ) {
                case 'yes':
                    saveXpdl( onRefresh );
                    break;
                case 'no':
                	resetAutoSaved();
                    onRefresh();
                    break;
                default:
                    break;
            }
        },
        icon: Ext.Msg.QUESTION
    } );
}

function onRefresh() {
    document.location.reload();
}

function isCustomTransitionCondition( condition ) {
    if ( condition.indexOf( '(' ) != -1 || condition.indexOf( '[' ) != -1 || condition.indexOf( ')' ) != -1 || condition.indexOf( ']' ) != -1 ) {
        return true;
    }

    if ( condition.indexOf( '&&' ) != -1 && condition.indexOf( '||' ) != -1 ) {
        return true;
    }
    
    var isCustom = false;
    var mark = '&&';

    if ( !Ext.isEmpty( condition ) ) {
        var split = condition.split( mark );

        if ( split.length == 1 ) {
            mark = '||';
            split = condition.split( mark );
        }

        Ext.each( split, function( el, idx, els ) {
        	var oneCondition = el.trim();
        	
        	if ( !/\w+(==|<=|>=|!=|<|>)'(\w+|\s+)'/.test( oneCondition ) ) {
        		isCustom = true;
        		return false;
        	}
        } );
    }

    return isCustom;
}

function createTransitionConditionsTable( condition ) {
    var tab = new Array();

    var mark = '&&';
    var conjunction = true;

    if ( !Ext.isEmpty( condition ) ) {
        var split = condition.split( mark );

        if ( split.length == 1 ) {
            mark = '||';
            conjunction = false;
            split = condition.split( mark );
        }

        Ext.each( split, function( el, idx, els ) {
            var operatorsStart = [ '==', '<=', '>=', '!=', '<', '>' ];
            var indexOfOperatorStart = -1;
            var operator = '';
            var condValue = '';

            for ( var i = 0; i < operatorsStart.length; i++ ) {
                indexOfOperatorStart = el.indexOf( operatorsStart[i] );

                if ( indexOfOperatorStart != -1 ) {
                    operator = operatorsStart[i];
                    break;
                }
            }

            condValue = el.substring( indexOfOperatorStart + operator.length, el.length );

            tab.push( {
                varId: el.substring( 0, indexOfOperatorStart ).trim(),
                operator: operator.trim(),
                value: condValue.trim(),
                conjunction: conjunction
            } );
        } );
    }

    return tab;
}

function createTransitionConditionsText( tab ) {
    var txt = '';
    var tabSize = tab.length;

    for ( var i = 0; i < tabSize; i++ ) {
        var c = tab[i];
        var mark = c.conjunction ? '&&' : '||';

        txt += c.varId + c.operator + c.value;

        if ( i != tabSize - 1 ) {
            txt += ' ' + mark + ' ';
        }
    }

    return txt;
}

function lockHotkeys() {
    Ext.getCmp( 'main_panel' ).lockHotkeys();
}

function unlockHotkeys() {
    Ext.getCmp( 'main_panel' ).unlockHotkeys();
}

function getEventXY( e, offset ) {
    var x = e.pageX ? e.pageX + offset : e.clientX + window.screenLeft + offset;
    var y = e.pageY ? e.pageY + offset : e.clientY + window.screenTop + offset;

    return [ x, y ];
}

function handlePathAttrType( pathAttr ) {
    if ( Raphael.is( pathAttr, 'string' ) ) {
        pathAttr = Raphael.parsePathString( pathAttr );
    }

    return pathAttr;
}

function closeColorChooser() {
    var colorChooser = Ext.getCmp( 'color_chooser' );

    if ( colorChooser ) {
        colorChooser.close();
    }
}

function loadRecentFiles() {
    var recentFilesItem = Ext.getCmp( 'recent_files_main_menu_item' );
    var store = recentFilesItem.store;

    store.load( {
        scope: store,
        callback: function( r, options, success ) {
            var menu = recentFilesItem.menu;
            menu.removeAll();
            var noOfRecentFiles = this.getCount();
            var counter = 1;

            if ( noOfRecentFiles > 0 ) {
                this.each( function( recentFile ) {
                    menu.addItem( new Ext.ux.suncode.MenuItem( {
                        cls: 'x-btn-text',
                        text: createMenuRecentFileBox( recentFile ),
                        recentFilePath: recentFile.get( 'location' ),
                        listeners: {
                            click: openRecentFile
                        }
                    } ) );

                    if ( counter < noOfRecentFiles ) {
                        menu.addItem( new Ext.menu.Separator() );
                    }

                    counter++;
                } );
            } else {
                menu.addItem( new Ext.ux.suncode.MenuItem( {
                    cls: 'x-btn-text',
                    text: getTranslation( 'Pusta lista' ),
                    disabled: true
                } ) );
            }
        }
    } );
}

function loadGlobalParticipants( menu ) {
    menu.removeAll();

    var packagePanel = Ext.getCmp( 'package_panel' );
    var processDefId = Ext.getCmp( 'paper_panel' ).getActiveTab().processDefId;
    var processNode = packagePanel.findProcess( processDefId );

    var packageNode = packagePanel.getRootNode();
    var participants = packageNode.attributes.participants;

    if ( Ext.isEmpty( participants ) ) {
        menu.addItem( {
            xtype: 'menuitem',
            cls: 'x-btn-text',
            text: getTranslation( 'Pusta lista' ),
            disabled: true
        } );
    } else {
        for ( var i = 0; i < participants.length; i++ ) {
            var participant = participants[i];

            if ( !processNode.findRole( participant.roleId ) ) {
                var icon = '';

                switch ( participant.roleType ) {
                    case 'ROLE':
                        icon = getPluginImgPath( 'role' );
                        break;
                    case 'SYSTEM':
                        icon = getPluginImgPath( 'system' );
                        break;
                    case 'RESOURCE':
                        icon = getPluginImgPath( 'buffer' );
                        break;
                    default:
                        break;
                }

                menu.addItem( {
                    xtype: 'menuitem',
                    cls: 'x-btn-text-icon',
                    icon: icon,
                    text: participant.roleName,
                    roleType: participant.roleType,
                    roleId: participant.roleId,
                    roleName: participant.roleName,
                    roleDescr: participant.roleDescr,
                    listeners: {
                        click: drawGlobalParticipant
                    }
                } );
            }
        }

        if ( Ext.isEmpty( menu.items.items ) ) {
            menu.addItem( {
                xtype: 'menuitem',
                cls: 'x-btn-text',
                text: getTranslation( 'Pusta lista' ),
                disabled: true
            } );
        }
    }
}

function scrollToProcessObject( processPanel, box ) {
    var scale = processPanel.paper.scale;

    var scrollTopPos = parseInt( processPanel.body.dom.scrollTop / scale );
    if ( !( scrollTopPos < ( box.y - 20 ) / scale && scrollTopPos + processPanel.getHeight() > ( box.y2 + 40 ) / scale ) ) {
        processPanel.body.dom.scrollTop = parseInt( ( box.y - 20 ) / scale );
    }

    var scrollLeftPos = parseInt( processPanel.body.dom.scrollLeft / scale );
    if ( !( scrollLeftPos < ( box.x - 20 ) / scale && scrollLeftPos + processPanel.getWidth() > ( box.x2 + 40 ) / scale ) ) {
        processPanel.body.dom.scrollLeft = parseInt( ( box.x - 20 ) / scale );
    }
}

function loadExamples() {
    var examplesItem = Ext.getCmp( 'examples_main_menu_item' );
    var store = examplesItem.store;

    store.load( {
        scope: store,
        callback: function( r, options, success ) {
            var menu = examplesItem.menu;

            if ( this.getCount() > 0 ) {
                this.each( function( example ) {
                    menu.addItem( new Ext.ux.suncode.MenuItem( {
                        cls: 'x-btn-text',
                        text: createMenuExampleBox( example ),
                        examplePath: example.get( 'path' ),
                        listeners: {
                            click: openExample
                        }
                    } ) );
                } );
            } else {
                menu.addItem( new Ext.ux.suncode.MenuItem( {
                    cls: 'x-btn-text',
                    text: getTranslation( 'Pusta lista' ),
                    disabled: true
                } ) );
            }
        }
    } );
}

function clearArray( array ) {
    while ( !Ext.isEmpty( array ) ) {
        array.pop();
    }
}

function countAsPercent( all, part, precision ) {
    if ( part == 0 ) {
        var val = 0;

        return val.toFixed( precision );
    }

    return ( ( part / all ) * 100 ).toFixed( precision );
}

function formatPercentAsText( percent, presicion ) {
    var zeroPercent = '0.';

    for ( var i = 0; i < presicion; i++ ) {
        zeroPercent += '0';
    }

    if ( percent.toString() == zeroPercent ) {
        percent = '< 0.';

        for ( var i = 0; i < presicion - 1; i++ ) {
            percent += '0';
        }

        percent += '1';
    }

    return percent + ' %';
}

function millisToText( millis ) {
    var d = new Date( millis );

    if ( millis < 1000 ) {
        return d.getMilliseconds() + ' ' + getTranslation( 'milisekund' );
    } else if ( millis < 1000 * 60 ) {
        return d.getSeconds() + ' ' + getTranslation( 'sekund' ) + ', ' + d.getMilliseconds() + ' ' + getTranslation( 'milisekund' );
    } else if ( millis < 1000 * 60 * 60 ) {
        return d.getMinutes() + ' ' + getTranslation( 'minut' ) + ', ' + d.getSeconds() + ' ' + getTranslation( 'sekund' ) + ', '
                        + d.getMilliseconds() + ' ' + getTranslation( 'milisekund' );
    } else if ( millis < 1000 * 60 * 60 * 24 ) {
        return d.getHours() + ' ' + getTranslation( 'godzin' ) + ', ' + d.getMinutes() + ' ' + getTranslation( 'minut' ) + ', ' + d.getSeconds()
                        + ' ' + getTranslation( 'sekund' ) + ', ' + d.getMilliseconds() + ' ' + getTranslation( 'milisekund' );
    } else {
        var days = Math.floor( millis / ( 1000 * 60 * 60 * 24 ) );

        return days + ' ' + getTranslation( 'dni' ) + ', ' + d.getHours() + ' ' + getTranslation( 'godzin' ) + ', ' + d.getMinutes() + ' '
                        + getTranslation( 'minut' ) + ', ' + d.getSeconds() + ' ' + getTranslation( 'sekund' ) + ', ' + d.getMilliseconds() + ' '
                        + getTranslation( 'milisekund' );
    }
}

function getActionAcceptButtonActionNodeText( attributions, conditions ) {
    var text = getTranslation( 'Przypisania' );
    text += ': ';
    text += attributions.length;
    text += ', ';
    text += getTranslation( 'Warunki przypisania' );
    text += ': ';
    text += conditions.length;

    return text;
}

function getExtraDataChooserConfigNodeText( dataChooserName, attributes ) {
    var text = getTranslation( 'Dynamiczna lista' );
    text += ': ';
    text += dataChooserName;
    text += ', ';
    text += getTranslation( 'Atrybuty' );
    text += ': ';
    text += attributes.length;

    return text;
}

function showActivityDetails( processId, activityId ) {
    window.open( Suncode.context( 'pwe' ).contextPath + '/ShowDetailHistory.do?histActivityId=' + activityId + '&ProcessId=' + processId );
}

function fullScreen() {
    var mainPanel = Ext.getCmp( 'main_panel' );

    if ( mainPanel.modes.currentActivityMapMode ) {
        window.open( Suncode.context( 'pwe' ).pluginContextPath + '/?currentActivityMapMode=true&processDefId='
                        + Ext.getCmp( 'paper_panel' ).getActiveTab().processDefId + '&processId=' + mainPanel.getSimulationInfo().processId
                        + '&activityDefId=' + mainPanel.getSimulationInfo().activityDefId );
    } else if ( mainPanel.modes.simulationMode ) {
        window.open( Suncode.context( 'pwe' ).pluginContextPath + '/?simulationMode=true&processDefId='
                        + Ext.getCmp( 'paper_panel' ).getActiveTab().processDefId + '&processId=' + mainPanel.getSimulationInfo().processId );
    } else if ( mainPanel.modes.processPreviewMode ) {
        window.open( Suncode.context( 'pwe' ).pluginContextPath + '/?processPreviewMode=true&processDefId='
                        + Ext.getCmp( 'paper_panel' ).getActiveTab().processDefId );
    }
}

Ext.ux.suncode.Utils = {
    Application: {
        get: function( processNode, appId ) {
            var app = processNode.findApplication( appId );

            if ( !app ) {
                var packageNode = processNode.parentNode;

                return packageNode.findApplication( appId );
            } else {
                return app;
            }
        },
        getLabelForType: function( appType ) {
            switch ( appType ) {
                case 'org.enhydra.shark.toolagent.JavaScriptToolAgent':
                    return getTranslation( 'Skrypt' );
                case 'org.enhydra.shark.toolagent.JavaClassToolAgent':
                case 'org.enhydra.shark.toolagent.JavaClassTransToolAgent':
                    return getTranslation( 'Ścieżka do klasy' );
                case 'org.enhydra.shark.toolagent.RuntimeApplicationToolAgent':
                    return getTranslation( 'Ścieżka do aplikacji' );
                case 'org.enhydra.shark.toolagent.SOAPToolAgent':
                    return getTranslation( 'Lokalizacja usługi sieciowej' );
                default:
                    return getTranslation( 'Wykonanie' );
            }
        },
        translateType: function( appType ) {
            switch ( appType ) {
                case 'org.enhydra.shark.toolagent.JavaScriptToolAgent':
                    return getTranslation( 'Aplikacja JavaScript' );
                case 'org.enhydra.shark.toolagent.JavaClassToolAgent':
                    return getTranslation( 'Aplikacja Java' );
                case 'org.enhydra.shark.toolagent.JavaClassTransToolAgent':
                    return getTranslation( 'Aplikacja Java z transakcją' );
                case 'org.enhydra.shark.toolagent.RuntimeApplicationToolAgent':
                    return getTranslation( 'Aplikacja systemowa' );
                case 'org.enhydra.shark.toolagent.SOAPToolAgent':
                    return getTranslation( 'Aplikacja WebService' );
                default:
                    return appType;
            }
        }
    }
};

function deepObjectCopy( object ) {
    if ( Ext.isArray( object ) ) {
        var group = new Array();
        Ext.each( object, function( el, index, els ) {
            group.push( deepObjectCopy( el ) );
        } );
        return group;
    } else if ( Ext.isObject( object ) ) {
        var group = new Object();
        Ext.iterate( object, function( key, value, myself ) {
            group[key] = deepObjectCopy( value );
        } );
        return group;
    } else {
        return object;
    }
}

function hasAnyProperty( object ) {
	if ( Ext.isObject( object ) ) {
		var has = false;
		
		Ext.iterate( object, function( key, value, myself ) {
			has = true;
			return false;
        } );
		
		return has;
	} else {
		return false;
	}
}

function initMissingFormTemplates() {
	var packageNode = Ext.getCmp( 'package_panel' ).getRootNode();
	
	if ( packageNode.hasChildNodes() ) {
		packageNode.eachChild( function( processNode ) {
			if ( processNode.hasChildNodes() ) {
	            processNode.eachChild( function( activityNode ) {
	            	if ( Ext.isEmpty( activityNode.attributes.form.template.rows ) ) {
		            	var template = new Object();
		            	var rows = new Array();
		            	var formVariables = activityNode.attributes.form.variables;
		            	var buttons = activityNode.attributes.form.buttons;
		            	
		            	if ( !Ext.isEmpty( formVariables ) ) {
		            		Ext.each( formVariables, function( formVariable, index, allFormVariables ) {
		            			var items = new Array();
		            			items.push( getDefaultTemplateItemConfig( processNode, formVariable.type, formVariable ) );
		            			
		            			var httpLinks = activityNode.getHttpLinks( formVariable.varId );
		                        if ( !Ext.isEmpty( httpLinks ) ) {
		                        	Ext.each( httpLinks, function( httpLink, index, allHttpLinks ) {
		                        		items.push( getDefaultTemplateItemConfig( processNode, httpLink.genre, httpLink ) );
		                        	} );
		                        }
		            			
		            			var row = new Object();
		            			row = Ext.apply( {
		            				layoutPack: 'start',
		            		        items: items
		            		    }, row );
		            			
		            			rows.push( row );
		            		} );
		                }
		            	
		            	if ( !Ext.isEmpty( buttons ) ) {
		            		Ext.each( buttons, function( button, index, allButtons ) {
		            			var items = new Array();
		            			items.push( getDefaultTemplateItemConfig( processNode, button.genre, button ) );
		            			
		            			var row = new Object();
		            			row = Ext.apply( {
		            				layoutPack: 'start',
		            		        items: items
		            		    }, row );
		            			
		            			rows.push( row );
		            		} );
		                }
		            	
		            	template = Ext.apply( {
		                    rows: rows
		                }, template );
		            	
		            	activityNode.loadFormTemplate( template );
	            	}
	            } );
	        }
		} );
	}
}

function getDefaultTemplateItemConfig( processNode, type, objectDef ) {
    var item = new Object();
    item = Ext.apply( {
        type: type
    }, item );
    var globalSettings = processNode.attributes.globalSettings;

    switch ( objectDef.genre ) {
        case 'VARIABLE':
        	item = Ext.apply( {
                id: objectDef.varId,
                width: null,
                labelAlign: globalSettings.formVariableLabel.labelAlign,
                labelWidth: globalSettings.formVariableLabel.labelWidth,
                labelSeparator: globalSettings.formVariableLabel.labelSeparator,
                labelFontSize: globalSettings.formVariableLabel.labelFontSize,
                labelColor: globalSettings.formVariableLabel.labelColor,
                textDecoration: globalSettings.formVariableLabel.textDecoration,
                hideLabel: false,
                marginTop: null,
                marginRight: null,
                marginBottom: null,
                marginLeft: null
            }, item );

            if ( type == 'TEXTAREA' ) {
            	item = Ext.apply( {
                    height: 100
                }, item );
            }
            break;
        case 'VARIABLE_SET':
        	item = Ext.apply( {
                id: objectDef.varId,
                headerFontSize: globalSettings.variableSetFont.headerFontSize,
            	cellFontSize: globalSettings.variableSetFont.cellFontSize
            }, item );
            break;
        case 'HTTP_LINK':
        case 'ACTION_ACCEPT_BUTTON':
        case 'ADD_FILE_BUTTON':
        	item = Ext.apply( {
                id: objectDef.actionName,
                icon: objectDef.icon
            }, item );
            break;
        case 'GENERATE_PDF_BUTTON':
        case 'BARCODE_PRINT':
        	item = Ext.apply( {
                id: objectDef.actionName
            }, item );
            break;
        case 'LABEL':
        	item = Ext.apply( {
                id: objectDef.id,
                text: getTranslation( 'Etykieta' ),
                fontSize: 1,
                color: '#333333',
                marginTop: null,
                marginRight: null,
                marginBottom: null,
                marginLeft: null
            }, item );
            break;
        default:
            break;
    }

    return item;
}

function fitWindowToView( win, calculateXPosFunc, calculateYPosFunc, getWidthFunc, getHeightFunc ) {
	var position = win.getPosition();
	var x = position[0];
	var y = position[1];
	var changePosition = false;
  var width = null;
  var height = null;

  if ( Ext.isFunction( getWidthFunc ) ) {
    width = getWidthFunc.apply( win, [] );
  } else {
    width = win.getWidth();
  }

  if ( Ext.isFunction( getHeightFunc ) ) {
    height = getHeightFunc.apply( win, [] );
  } else {
    height = win.getHeight();
  }
	
	if ( x + width > Ext.getBody().getWidth() + jQuery( document ).scrollLeft() && Ext.isFunction( calculateXPosFunc ) ) {
		x = calculateXPosFunc.apply( win, [ x ] );
		changePosition = true;
	}
	
	if ( x < jQuery( document ).scrollLeft() ) {
		x = jQuery( document ).scrollLeft();
		changePosition = true;
	}

	if ( y + height > Ext.getBody().getHeight() + jQuery( document ).scrollTop() && Ext.isFunction( calculateYPosFunc ) ) {
		y = calculateYPosFunc.apply( win, [ y ] );
		changePosition = true;
	}
	
	if ( y < jQuery( document ).scrollTop() ) {
		y = jQuery( document ).scrollTop();
		changePosition = true;
	}
	
	if ( changePosition ) {
		win.setPosition( x, y );
	}
}

function showServerFailure( response ) {
	if ( !Ext.isEmpty( response.responseText ) ) {
		var exception = Ext.util.JSON.decode( response.responseText );
		
		if ( !Ext.isEmpty( exception.stackTrace ) ) {
			var win = new Ext.ux.suncode.ServerErrorWindow( {
				message: exception.message,
				stackTrace: exception.stackTrace
			} );
			win.show();
		} else {
			showWarn( getTranslation( 'Wystąpił błąd.' ) );
		}
	} else {
		showWarn( getTranslation( 'Wystąpił błąd.' ) );
	}
}

function getElementsFromPoint( x, y ) {
	if ( Ext.isFunction( document.elementsFromPoint ) ) {
		return document.elementsFromPoint( x, y );
	} else if ( Ext.isFunction( document.msElementsFromPoint ) ) {
		return document.msElementsFromPoint( x, y );
	} else {
		return new Array();
	}
}

function compareStringsWithNumbers( a, b ) {
	var reParts = /\d+|\D+/g;
	var reDigit = /\d/;
	
    a = a.toUpperCase();
    b = b.toUpperCase();
 
    var aParts = a.match( reParts );
    var bParts = b.match( reParts );
 
    var isDigitPart;
 
    if ( aParts && bParts && ( isDigitPart = reDigit.test( aParts[0] ) ) == reDigit.test( bParts[0] ) ) {
      var len = Math.min( aParts.length, bParts.length );
      for ( var i = 0; i < len; i++ ) {
        var aPart = aParts[i];
        var bPart = bParts[i];
 
        if ( isDigitPart ) {
          aPart = parseInt( aPart, 10 );
          bPart = parseInt( bPart, 10 );
        }
 
        if ( aPart != bPart ) {
          return aPart < bPart ? -1 : 1;
        }
 
        isDigitPart = !isDigitPart;
      }
    }
 
    return ( a >= b ) - ( a <= b );
}

function callGridFunctionForRow( id, functionName, rowIndex, colIndex ) {
	var grid = Ext.getCmp( id );
	
	if ( !Ext.isEmpty( grid ) && Ext.isFunction( grid[functionName] ) ) {
		grid[functionName]( rowIndex, colIndex );
	}
}

function sortNode( node, attributeName, asc ) {
  node.sort(function (a, b) {
    var attributeNameA = a.attributes[attributeName].toLowerCase();
    var attributeNameB = b.attributes[attributeName].toLowerCase();

    if (asc) {
      return attributeNameA > attributeNameB ? 1 : -1;
    } else {
      return attributeNameB > attributeNameA ? 1 : -1;
    }
  });
}

function notifyOverGrid( dd, e, data ) {
  var rowEl = e.getTarget( 'div[class*=x-grid3-row]', null, true );

  if ( !Ext.isEmpty( rowEl ) ) {
    var gridDropTopProxyClass = 'x-Module-gridDropTopProxy';
    var gridDropBottomProxyClass = 'x-Module-gridDropBottomProxy';

    if ( dd.markedRow && dd.markedRow.id != rowEl.id ) {
      dd.markedRow.removeClass( gridDropTopProxyClass );
      dd.markedRow.removeClass( gridDropBottomProxyClass );
    }

    var grid = dd.grid;
    var index = grid.getView().findRowIndex( rowEl.dom );

    if ( index < dd.dragData.rowIndex ) {
      rowEl.addClass( gridDropTopProxyClass );
    } else {
      rowEl.addClass( gridDropBottomProxyClass );
    }

    dd.markedRow = rowEl;
  }

  return this.dropAllowed;
}

function notifyDropGrid( dd, e, data, callback ) {
  var store = dd.grid.store;
  var sm = dd.grid.getSelectionModel();
  var dragData = dd.getDragData( e );

  if ( dragData ) {
    var sindex = dd.dragData.rowIndex;
    var dindex = dragData.rowIndex;

    if ( typeof ( dindex ) != 'undefined' ) {
      var row = store.getAt( sindex );
      store.remove( store.getAt( sindex ) );
      store.insert( dindex, row );
      sm.clearSelections();

      if ( Ext.isFunction( callback ) ) {
        callback.apply( this, [ sindex, dindex ]);
      }
    }
  }

  if ( dd.markedRow ) {
    dd.markedRow.removeClass( 'x-Module-gridDropTopProxy' );
    dd.markedRow.removeClass( 'x-Module-gridDropBottomProxy' );
  }
}

function buildEventActionsGroupTemplate( values ) {
  var tpl = getTranslation( 'Zdarzenie' );
  tpl += ': ';

  var eventParentId = values.rs[0].data["eventParentId"];

  if ( !Ext.isEmpty( eventParentId ) ) {
    var store = values.rs[0].store;
    var index = store.find( 'eventOwnerId', eventParentId );
    var parentEventName = store.getAt( index ).get( 'eventName' );

    tpl += parentEventName;
    tpl += ' -> ';
    tpl += values.rs[0].data["eventName"];
    tpl += ' [';
    tpl += getTranslation( 'Tag' );
    tpl += ': ';
    tpl += eventParentId;
    tpl += ']';
  } else {
    tpl += values.rs[0].data["eventName"];
  }

  tpl += ' (';
  tpl += values.rs.length - 1;
  tpl += ' ';

  if ( values.rs.length == 2 ) {
    tpl += getTranslation( 'element' );
  } else {
    tpl += getTranslation( 'elementów' );
  }

  tpl += ')';

  return tpl;
}

function lowerFirstLetter( string ) {
  if ( !Ext.isEmpty( string ) ) {
    return string.charAt(0).toLowerCase() + string.slice(1);
  } else {
    return string;
  }
}

function generateUUID() {
  var d = new Date().getTime();
  var d2 = ((typeof performance !== 'undefined') && performance.now
      && (performance.now() * 1000)) || 0;
  return 'xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx'.replace(/[xy]/g, function (c) {
    var r = Math.random() * 16;
    if (d > 0) {
      r = (d + r) % 16 | 0;
      d = Math.floor(d / 16);
    } else {
      r = (d2 + r) % 16 | 0;
      d2 = Math.floor(d2 / 16);
    }
    return (c === 'x' ? r : (r & 0x3 | 0x8)).toString(16);
  });
}

function setCookie( name, value, expirationDays ) {
  var expirationDate = new Date();
  expirationDate.setDate( expirationDate.getDate() + expirationDays );
  var cookieValue = encodeURIComponent( value ) + ( ( expirationDate == null ) ? '' : '; expires=' + expirationDate.toUTCString() );
  document.cookie = name + '=' + cookieValue;
}

function getCookie( name ) {
  var cookies = document.cookie.split( ';' );

  for ( var i = 0; i < cookies.length; i++) {
    var cookie = cookies[i];
    var indexOfEquals = cookie.indexOf( '=' );

    if ( indexOfEquals != -1 ) {
      var cookieName = cookie.substring( 0, indexOfEquals );
      cookieName = cookieName.replace(/^\s+|\s+$/g, '' );

      if ( cookieName == name ) {
        var cookieValue = cookie.substring( indexOfEquals + 1 );

        return decodeURIComponent( cookieValue );
      }
    }
  }

  return null;
}

function copyTextToClipboard( text ) {
  if ( navigator.clipboard && navigator.clipboard.writeText ) {
    navigator.clipboard.writeText( text );
  } else {
    var textArea = document.createElement( 'textarea' );
    textArea.value = text;

    textArea.style.top = '0';
    textArea.style.left = '0';
    textArea.style.position = 'fixed';

    document.body.appendChild( textArea );
    textArea.focus();
    textArea.select();

    try {
      document.execCommand( 'copy' );
    } catch ( e ) {

    }

    document.body.removeChild( textArea );
  }
}

function readTextFromClipboard( successFunc, successScope, errorFunc, errorScope ) {
  if ( Ext.isFunction( successFunc ) && Ext.isFunction( errorFunc ) ) {
    successScope = !Ext.isEmpty( successScope ) ? successScope : window;
    errorScope = !Ext.isEmpty( errorScope ) ? errorScope : window;

    if ( navigator.clipboard && navigator.clipboard.readText ) {
      navigator.clipboard.readText()
      .then( text => {
        successFunc.apply( successScope, [ text ] );
      } )
      .catch( error => {
        logError( error );
        errorFunc.apply( errorScope, [] );
      } );
    } else if ( window.clipboardData && window.clipboardData.getData ) {
      var text = window.clipboardData.getData( 'Text' );

      successFunc.apply( successScope, [ text ] );
    } else {
      errorFunc.apply( errorScope, [] );
    }
  }
}

function sleep( millis ) {
  var e = new Date().getTime() + millis;
  while (new Date().getTime() <= e) {}
}

function lowerFirstLetter( str ) {
  return str[0].toLowerCase() + str.slice( 1 );
}