function showLoadingMask( id, msg ) {
    var maskDiv = Ext.DomHelper.append( Ext.getCmp( 'main_panel' ).getEl(), {
        tag: 'div',
        id: id
    }, true );
    maskDiv.setStyle( {
        'position': 'fixed',
        'left': 0,
        'top': 0,
        'width': '100%',
        'height': '100%',
        'z-index': 20000
    } );

    var mask = new Ext.LoadMask( maskDiv, {
        msg: msg
    } );

    mask.show();
}

function removeLoadingMask( id ) {
    Ext.get( id ).remove();
}

function tickCrossValue( value, metaData, record, rowIndex, colIndex, store ) {
    if ( value ) {
        return '<img src=\"' + getPluginImgPath( 'tick' ) + '\" width="12" height="12">';
    } else {
        return '<img src=\"' + getPluginImgPath( 'close' ) + '\" width="12" height="12">';
    }
}

function conditionRenderer( value, metaData, record, rowIndex, colIndex, store ) {
    return value.replaceAll( '&&', getTranslation( 'i' ) ).replaceAll( '||', getTranslation( 'lub' ) );
}

function conditionValueRenderer( value, metaData, record, rowIndex, colIndex, store ) {
    return value.replaceAll( '\'', '' );
}

function wrapColumnValue( value, metaData, record, rowIndex, colIndex, store ) {
    return '<div style="white-space:normal !important;">' + value + '</div>';
}

function imageCell( value, metaData, record, rowIndex, colIndex, store ) {
    return '<img src=\"' + getPluginImgPath( value ) + '\">';
}

function getPluginImgPath( img ) {
    return Suncode.context( 'pwe' ).pluginResourcesPath + '/style/img/' + img + '.png';
}

function addTooltipToField( label, txt, pdf, isDeprecated ) {
    if ( txt ) {
        label += ' <img onmouseover=\"new Function(showFieldTooltip(this, \'' + txt.replaceAll( '\'', '\\\'' )
                        + '\', \'tip_on\'))\" onmouseout=\"new Function(hideFieldTooltip(this, \'tip_off\'))\" src="'
                        + getPluginImgPath( 'tip_off' ) + '" height="12" width="12">';
    }

    if ( pdf ) {
        label += ' <img onclick=\"new Function(showHelp(\'' + pdf + '\'))\" src="' + getPluginImgPath( 'pdf' ) + '" height="12" width="12">';
    }
    
    if ( isDeprecated ) {
        label += ' <img onmouseover=\"new Function(showFieldTooltip(this, \'' + getTranslation( 'Opcja jest przestarzała' )
                        + '\', \'warning\'))\" onmouseout=\"new Function(hideFieldTooltip(this, \'warning\'))\" src="'
                        + getPluginImgPath( 'warning' ) + '" height="12" width="12">';
    }

    return label;
}

function showFieldTooltip( img, txt, imgSrc ) {
    showImageTooltip( img, txt );
    img.src = getPluginImgPath( imgSrc );
}

function showImageTooltip( img, txt ) {
    new Ext.ux.suncode.DescriptionToolTip( {
        html: txt,
        target: img
    } );
}

function hideFieldTooltip( img, imgSrc ) {
    img.src = getPluginImgPath( imgSrc );
}

function showHelp( pdf ) {
    var win = new Ext.ux.suncode.HelpWindow( {
        pdf: pdf
    } );
    win.show();
}

function setTextColor( txt, color ) {
    return '<font color="' + color + '">' + txt + '</font>';
}

function createMenuColorBox( text, color ) {
    return '<table border="0"><tr><td><div style="background: ' + color + '; width: 20px; margin-right: 8px;">&nbsp;</div></td><td class="x-menu-item-text">&nbsp;'
                    + text + '</td></tr></table>';
}

function createMenuRecentFileBox( recentFile ) {
    var tableText = '<table border="0"><tr><td>';
    tableText += '<b>' + getTranslation( 'Nazwa pliku' ) + ':</b> ' + recentFile.get( 'fileName' ) + '<br>';
    tableText += '<b>' + getTranslation( 'Lokalizacja' ) + ':</b> ' + getTranslation( recentFile.get( 'locationName' ) ) + '<br>';
    tableText += '<b>' + getTranslation( 'Rozmiar pliku' ) + ':</b> ' + recentFile.get( 'size' ).replaceAll( 'bytes', getTranslation( 'bajtów' ) ) + '<br>';
    tableText += '<b>' + getTranslation( 'Czas otwarcia' ) + ':</b> ' + recentFile.get( 'openTime' );
    tableText += '</td></tr></table>';

    return tableText;
}

function createMenuExampleBox( example ) {
    if ( example.get( 'isEmpty' ) ) {
        return getTranslation( example.get( 'emptyListText' ) );
    }

    return example.get( 'name' );
}

function getTemplateColor() {
    return '#7F9DB9';
}

function getTemplateStyle() {
    return 'color="' + getTemplateColor() + '"';
}

function getTotalStyle() {
    return 'color="#000000"';
}

function getHRLineStyle() {
    return 'size="1" width="100%" color="#7F9DB9"';
}

function emptyMessageToolbar() {
    var icon = getPluginImgPath( 'new' );
    var txt = getTranslation( 'Plik jest zapisany' );

    var mainPanel = Ext.getCmp( 'main_panel' );
    if ( mainPanel && !mainPanel.isSaved() ) {
        icon = getPluginImgPath( 'page_edit' );
        txt = getTranslation( 'Plik jest niezapisany' );
    }

    return '<img onmouseover=\"new Function(showImageTooltip(this, \'' + txt + '\'))\" src="' + icon + '" width="12" height="12">';
}

function notifyMessageToolbar( text, success ) {
    var fontColor = success ? '#308E11' : '#E16E6E';
    var icon = success ? getPluginImgPath( 'tick' ) : getPluginImgPath( 'close' );
    var msg = '<img src="' + icon + '" width="12" height="12">' + ' <b><font color="' + fontColor + '">' + text + '</font></b>';
    Ext.getCmp( 'paper_panel_message_field' ).setText( msg );
}

function clearMessageToolbarWithDelay( seconds ) {
    window.setTimeout( function() {
        Ext.getCmp( 'paper_panel_message_field' ).setText( emptyMessageToolbar() );
    }, 1000 * seconds );
}

function setDistinctionColorCssRules( color ) {
    var rules = [ '.x-combo-list .x-combo-selected', '.x-tree-node .x-tree-selected', '.x-grid3-row-selected .x-grid3-cell',
        '.x-grid3-body .x-grid3-row-selected .x-grid3-cell.x-grid3-td-checker.x-grid3-cell-first',
        '.x-grid3-body .x-grid3-row-selected .x-grid3-cell.x-grid3-td-numberer.x-grid3-cell-first' ];

    for ( var i = 0; i < rules.length; i++ ) {
        var rule = Ext.util.CSS.getRule( rules[i] );

        if(rule) {
            if ( Ext.isIE ) {
                rule.style.setAttribute( 'background-color', color, 'important' );
            } else {
                rule.style.setProperty( 'background-color', color, 'important' );
            }
        }
        else {
            Ext.util.CSS.createStyleSheet(rules[i] + ' {background-color: ' + color + '}');
        }
    }
}

function menuTextWithHotkey( text, hotkey ) {
    return '<table border="0" cellpadding="0" cellspacing="0" width="100%"><tr><td>' + text +
    	'</td><td align="right">&nbsp;&nbsp;&nbsp;&nbsp;' + hotkey + '</td></tr></table>';
}

function escapeHtmlRenderer( value, metaData, record, rowIndex, colIndex, store ) {
    return Ext.util.Format.htmlEncode( value );
}

function activityTypeRenderer( value, metaData, record, rowIndex, colIndex, store ) {
    switch ( value ) {
        case Ext.ux.suncode.Constants.ROUTE:
            return getTranslation( 'Przekierowanie' );
        case Ext.ux.suncode.Constants.ACTIVITY:
            return getTranslation( 'Zadanie' );
        case Ext.ux.suncode.Constants.TOOL:
            return getTranslation( 'Narzędzie' );
        case Ext.ux.suncode.Constants.SUBFLOW:
            return getTranslation( 'Podproces' );
        default:
            return value;
    }
}