Ext.ux.suncode.MissingIntegrationComponentsWindow = function( config ) {
    var windowWidth = Ext.getBody().getViewSize().width * 0.95;

    config = Ext.apply( {
        modal: true,
        width: windowWidth,
        autoHeight: true,
        title: getTranslation( 'Brakujące komponenty integracyjne' ),
        tbar: new Ext.Toolbar( {
            buttons: [ {
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'close' ),
                tooltip: getTranslation( 'Zamknij' ),
                handler: this.closeWindow,
                scope: this
            } ]
        } ),
        items: [ new Ext.ux.suncode.MissingIntegrationComponentsPanel( config ) ]
    }, config );

    Ext.ux.suncode.MissingIntegrationComponentsWindow.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.MissingIntegrationComponentsWindow, Ext.Window, {
    initComponent: function() {
        Ext.ux.suncode.MissingIntegrationComponentsWindow.superclass.initComponent.call( this );
    },
    closeWindow: function() {
        this.close();
    }
} );

Ext.ux.suncode.MissingIntegrationComponentsPanel = function( config ) {
    config = Ext.apply( {
        height: 400,
        enableColumnResize: true,
        columnLines: true,
        autoScroll: true,
        border: false,
        store: new Ext.data.Store( {
            data: config.missingComponents,
            reader: new Ext.data.JsonReader( {
                fields: Ext.data.Record.create( [ {
                    name: 'object',
                    type: 'string'
                }, {
                    name: 'processName',
                    type: 'string'
                }, {
                    name: 'activityName',
                    type: 'string'
                }, {
                    name: 'componentId',
                    type: 'string'
                } ] )
            } )
        } ),
        colModel: new Ext.grid.ColumnModel( {
            defaults: {
                sortable: true,
                menuDisabled: false
            },
            columns: [ {
                header: getTranslation( 'Obiekt' ),
                dataIndex: 'object',
                align: 'left'
            }, {
                header: getTranslation( 'Nazwa procesu' ),
                dataIndex: 'processName',
                align: 'left'
            }, {
                header: getTranslation( 'Nazwa zadania' ),
                dataIndex: 'activityName',
                align: 'left'
            }, {
                header: getTranslation( 'Identyfikator komponentu' ),
                dataIndex: 'componentId',
                align: 'left'
            } ]
        } ),
        viewConfig: new Ext.ux.suncode.StandardGridView( {
            emptyText: getTranslation( 'Brak brakujących komponentów integracyjnych' )
        } ),
        sm: new Ext.grid.RowSelectionModel( {
            singleSelect: true
        } )
    }, config );

    Ext.ux.suncode.MissingIntegrationComponentsPanel.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.MissingIntegrationComponentsPanel, Ext.grid.GridPanel, {
    initComponent: function() {
        Ext.ux.suncode.MissingIntegrationComponentsPanel.superclass.initComponent.call( this );
    }
} );