Ext.ux.suncode.I18NService = {
  NO_XPDL_TRANSLATION_LANGUAGE: 'none',
	PACKAGE_ID_PLACEHOLDER_PREFIX: 'PACK',
	PARTICIPANT_ID_PLACEHOLDER_PREFIX: 'PARTICIPANT',
	PROCESS_DEF_ID_PLACEHOLDER_PREFIX: 'PROC',
	VARIABLE_ID_PLACEHOLDER_PREFIX: 'DATAFIELD',
  TABLE_ID_PLACEHOLDER_PREFIX: 'TABLE',
	LABEL_ID_PLACEHOLDER_PREFIX: 'LABEL',
	DATA_CHOOSER_ID_PLACEHOLDER_PREFIX: 'DATACHOOSER',
	MAPPING_ID_PLACEHOLDER_PREFIX: 'MAPPING',
	ACTIVITY_DEF_ID_PLACEHOLDER_PREFIX: 'ACTIVITY',
	VARIABLE_SET_ID_PLACEHOLDER_PREFIX: 'VARIABLESET',
	DT_BUTTON_ID_PLACEHOLDER_PREFIX: 'DTBUTTON',
	HTTP_LINK_ID_PLACEHOLDER_PREFIX: 'HTTPLINK',
	ACTION_ACCEPT_BUTTON_ID_PLACEHOLDER_PREFIX: 'ACTIONBUTTON',
	ADD_FILE_BUTTON_ID_PLACEHOLDER_PREFIX: 'ADDFILEBUTTON',
	GENERATE_PDF_BUTTON_ID_PLACEHOLDER_PREFIX: 'PDFBUTTON',
	initI18N: function( language, supportedLanguages, currentActivityMapMode ) {
		Ext.ux.suncode.I18N.init( language, supportedLanguages, currentActivityMapMode );
    Ext.ux.suncode.IntegrationComponentService.initTranslations();
	},
	getDefaultLanguage: function() {
		return Ext.ux.suncode.I18N.getLanguage();
	},
  getXpdlTranslationLanguage: function () {
    return Ext.ux.suncode.I18N.getXpdlTranslationLanguage();
  },
  setXpdlTranslationLanguage: function ( language ) {
    Ext.ux.suncode.I18N.setXpdlTranslationLanguage( language );
  },
	getSupportedLanguages: function() {
		return Ext.ux.suncode.I18N.getSupportedLanguages();
	},
	getMessage: function( key ) {
		return Ext.ux.suncode.I18N.getMessage( key );
	},
	getAllPackageTranslations: function( processDefId ) {
		var processDefIdPlaceholder = !Ext.isEmpty( processDefId ) ? this.buildProcessDefIdPlaceholder( processDefId ) : null;
		
		return Ext.ux.suncode.I18N.getAllPackageTranslations( processDefIdPlaceholder );
	},
	loadAllPackageTranslations: function( translations ) {
		return Ext.ux.suncode.I18N.loadPackageTranslations( translations );
	},
	resetAllPackageTranslations: function() {
		return Ext.ux.suncode.I18N.resetPackageTranslations();
	},
	getPackageTranslationsFromCaches: function( fields ) {
		var translations = new Object();
		
    	if ( !Ext.isEmpty( fields ) ) {
    		Ext.each( fields, function( field, index, allFields ) {
    			var fromCache = this.getPackageTranslationsFromCache( field );
    			
    			if ( !Ext.isEmpty( fromCache ) ) {
    				translations[fromCache.key] = fromCache.translations;
    			}
    		}, this );
    	}
    	
    	return translations;
    },
    getPackageTranslationsFromCache: function( field ) {
    	var cache = field.getCache();
    	
    	if ( !Ext.isEmpty( cache.key ) ) {
    		return deepObjectCopy( cache );
    	} else {
    		return null;
    	}
    },
	  addPackageTranslationsFromCaches: function( fields ) {
    	if ( !Ext.isEmpty( fields ) ) {
    		Ext.each( fields, function( field, index, allFields ) {
    			this.addPackageTranslationsFromCache( field );
    		}, this );
    	}
    },
    addPackageTranslationsFromCache: function( field ) {
    	var cache = field.getCache();
    	
    	if ( !Ext.isEmpty( cache.key ) ) {
    		this.savePackageTranslations( cache.key, cache.translations );
    	}
    },
    updatePackageTranslationsFromCaches: function( fields ) {
    	if ( !Ext.isEmpty( fields ) ) {
    		Ext.each( fields, function( field, index, allFields ) {
    			this.updatePackageTranslationsFromCache( field );
    		}, this );
    	}
    },
    updatePackageTranslationsFromCache: function( field ) {
    	var cache = field.getCache();
    	
    	if ( !Ext.isEmpty( cache.key ) ) {
    		this.savePackageTranslations( cache.key, cache.translations );
    	}
    },
    savePackageTranslations: function( key, translations ) {
    	Ext.ux.suncode.I18N.savePackageTranslations( key, translations );
    },
    savePackageTranslation: function( key, language, translation ) {
    	Ext.ux.suncode.I18N.savePackageTranslation( key, language, translation );
    },
    getPackageTranslations: function( key ) {
    	return Ext.ux.suncode.I18N.getPackageTranslations( key );
    },
    getPackageTranslation: function( key, language ) {
    	return Ext.ux.suncode.I18N.getPackageTranslation( key, language );
    },
    getXpdlPackageTranslation: function( key ) {
      return Ext.ux.suncode.I18N.getPackageTranslation( key, this.getXpdlTranslationLanguage() );
    },
    getXpdlPackageNamePackageTranslation: function( packageId ) {
      var key = this.buildPackageIdPlaceholder( packageId );

      return this.getXpdlPackageTranslation( key );
    },
    getXpdlPackageParticipantNamePackageTranslation: function( packageId, participantId ) {
      var key = this.buildPackageIdPlaceholder( packageId );
      key += '_';
      key += this.buildParticipantIdPlaceholder( participantId );

      return this.getXpdlPackageTranslation( key );
    },
    getXpdlProcessParticipantNamePackageTranslation: function( packageId, processDefId, participantId ) {
      var key = this.buildPackageIdPlaceholder( packageId );
      key += '_';
      key += this.buildProcessDefIdPlaceholder( processDefId );
      key += '_';
      key += this.buildParticipantIdPlaceholder( participantId );

      return this.getXpdlPackageTranslation( key );
    },
    getXpdlProcessNamePackageTranslation: function( packageId, processDefId ) {
      var key = this.buildPackageIdPlaceholder( packageId );
      key += '_';
      key += this.buildProcessDefIdPlaceholder( processDefId );

      return this.getXpdlPackageTranslation( key );
    },
    getXpdlActivityNamePackageTranslation: function( packageId, processDefId, activityDefId ) {
      var key = this.buildPackageIdPlaceholder( packageId );
      key += '_';
      key += this.buildProcessDefIdPlaceholder( processDefId );
      key += '_';
      key += this.buildActivityDefIdPlaceholder( activityDefId );

      return this.getXpdlPackageTranslation( key );
    },
    getXpdlVariableNamePackageTranslation: function( packageId, processDefId, variableId ) {
      var key = this.buildPackageIdPlaceholder( packageId );
      key += '_';
      key += this.buildProcessDefIdPlaceholder( processDefId );
      key += '_';
      key += this.buildVariableIdPlaceholder( variableId );

      return this.getXpdlPackageTranslation( key );
    },
    getXpdlLabelNamePackageTranslation: function( packageId, processDefId, labelId ) {
      var key = this.buildPackageIdPlaceholder( packageId );
      key += '_';
      key += this.buildProcessDefIdPlaceholder( processDefId );
      key += '_';
      key += this.buildLabelIdPlaceholder( labelId );

      return this.getXpdlPackageTranslation( key );
    },
    getXpdlVariableSetTitlePackageTranslation: function( packageId, processDefId, activityDefId, variableSetId ) {
      var key = this.buildPackageIdPlaceholder( packageId );
      key += '_';
      key += this.buildProcessDefIdPlaceholder( processDefId );
      key += '_';
      key += this.buildActivityDefIdPlaceholder( activityDefId );
      key += '_';
      key += this.buildVariableSetIdPlaceholder( variableSetId );

      return this.getXpdlPackageTranslation( key );
    },
    getXpdlVariableSetDtButtonNameTranslationKey: function( packageId, processDefId, activityDefId, variableSetId, dtButtonId ) {
      var key = this.buildPackageIdPlaceholder( packageId );
      key += '_';
      key += this.buildProcessDefIdPlaceholder( processDefId );
      key += '_';
      key += this.buildActivityDefIdPlaceholder( activityDefId );
      key += '_';
      key += this.buildVariableSetIdPlaceholder( variableSetId );
      key += '_';
      key += this.buildDtButtonIdPlaceholder( dtButtonId );

      return key;
    },
    getXpdlVariableSetDtButtonNamePackageTranslation: function( packageId, processDefId, activityDefId, variableSetId, dtButtonId ) {
      var key = this.getXpdlVariableSetDtButtonNameTranslationKey( packageId, processDefId, activityDefId, variableSetId, dtButtonId );

      return this.getXpdlPackageTranslation( key );
    },
    getXpdlHttpLinkNamePackageTranslation: function( packageId, processDefId, activityDefId, buttonName ) {
      var key = this.buildPackageIdPlaceholder( packageId );
      key += '_';
      key += this.buildProcessDefIdPlaceholder( processDefId );
      key += '_';
      key += this.buildActivityDefIdPlaceholder( activityDefId );
      key += '_';
      key += this.buildHttpLinkIdPlaceholder( this.replaceHttpLinkId( buttonName ) );

      return this.getXpdlPackageTranslation( key );
    },
    getXpdlActionAcceptButtonNamePackageTranslation: function( packageId, processDefId, activityDefId, actionName ) {
      var key = this.buildPackageIdPlaceholder( packageId );
      key += '_';
      key += this.buildProcessDefIdPlaceholder( processDefId );
      key += '_';
      key += this.buildActivityDefIdPlaceholder( activityDefId );
      key += '_';
      key += this.buildActionAcceptButtonIdPlaceholder( actionName )

      return this.getXpdlPackageTranslation( key );
    },
    getXpdlAddFileButtonNamePackageTranslation: function( packageId, processDefId, activityDefId, docClassName ) {
      var key = this.buildPackageIdPlaceholder( packageId );
      key += '_';
      key += this.buildProcessDefIdPlaceholder( processDefId );
      key += '_';
      key += this.buildActivityDefIdPlaceholder( activityDefId );
      key += '_';
      key += this.buildAddFileButtonIdPlaceholder( this.replaceAddFileButtonId( docClassName ) )

      return this.getXpdlPackageTranslation( key );
    },
    getXpdlGeneratePdfButtonNamePackageTranslation: function( packageId, processDefId, activityDefId, actionName ) {
      var key = this.buildPackageIdPlaceholder( packageId );
      key += '_';
      key += this.buildProcessDefIdPlaceholder( processDefId );
      key += '_';
      key += this.buildActivityDefIdPlaceholder( activityDefId );
      key += '_';
      key += this.buildGeneratePdfButtonIdPlaceholder( actionName )

      return this.getXpdlPackageTranslation( key );
    },
    onPackageIdChange: function( previousId, currentId ) {
    	this.replaceInPackageTranslationsKeys(
    			this.buildPackageIdPlaceholder( previousId ), this.buildPackageIdPlaceholder( currentId ) );
    },
    onGlobalParticipantIdChange: function( previousId, currentId ) {
    	this.replaceInPackageTranslationsKeys(
    			this.buildParticipantIdPlaceholder( previousId ), this.buildParticipantIdPlaceholder( currentId ) );
    },
    onProcessDefIdChange: function( previousId, currentId ) {
    	this.replaceInPackageTranslationsKeys(
    			this.buildProcessDefIdPlaceholder( previousId ), this.buildProcessDefIdPlaceholder( currentId ) );
    },
    onProcessParticipantIdChange: function( processDefId, previousId, currentId ) {
      var processDefIdPlaceholder = this.buildProcessDefIdPlaceholder( processDefId );

      this.replaceInPackageTranslationsKeys(
          processDefIdPlaceholder + '_' + this.buildParticipantIdPlaceholder( previousId ),
          processDefIdPlaceholder + '_' + this.buildParticipantIdPlaceholder( currentId ) );
    },
    onVariableIdChange: function( processDefId, previousId, currentId ) {
    	var processDefIdPlaceholder = this.buildProcessDefIdPlaceholder( processDefId );
    	
    	this.replaceInPackageTranslationsKeys(
    			processDefIdPlaceholder + '_' + this.buildVariableIdPlaceholder( previousId ),
    			processDefIdPlaceholder + '_' + this.buildVariableIdPlaceholder( currentId ) );
    	this.replaceInPackageTranslationsKeys(
    			processDefIdPlaceholder + '_' + this.buildDataChooserIdPlaceholder( previousId ),
    			processDefIdPlaceholder + '_' + this.buildDataChooserIdPlaceholder( currentId ) );
    },
    onLabelIdChange: function( processDefId, previousId, currentId ) {
    	var processDefIdPlaceholder = this.buildProcessDefIdPlaceholder( processDefId );
    	
    	this.replaceInPackageTranslationsKeys(
    			processDefIdPlaceholder + '_' + this.buildLabelIdPlaceholder( previousId ),
    			processDefIdPlaceholder + '_' + this.buildLabelIdPlaceholder( currentId ) );
    },
    onActivityDefIdChange: function( processDefId, previousId, currentId ) {
    	var processDefIdPlaceholder = this.buildProcessDefIdPlaceholder( processDefId );
    	
    	this.replaceInPackageTranslationsKeys(
    			processDefIdPlaceholder + '_' + this.buildActivityDefIdPlaceholder( previousId ),
    			processDefIdPlaceholder + '_' + this.buildActivityDefIdPlaceholder( currentId ) );
    },
    onProcessRemove: function( id ) {
    	this.removeByPackageTranslationsKeyContains( this.buildProcessDefIdPlaceholder( id ) );
    },
    onVariableRemove: function( processDefId, id ) {
    	var processDefIdPlaceholder = this.buildProcessDefIdPlaceholder( processDefId );
    	
    	this.removeByPackageTranslationsKeyContains( processDefIdPlaceholder + '_' + this.buildVariableIdPlaceholder( id ) );
    	this.removeByPackageTranslationsKeyContains( processDefIdPlaceholder + '_' + this.buildDataChooserIdPlaceholder( id ) );
    },
    onLabelRemove: function( processDefId, id ) {
    	var processDefIdPlaceholder = this.buildProcessDefIdPlaceholder( processDefId );
    	
    	this.removeByPackageTranslationsKeyContains( processDefIdPlaceholder + '_' + this.buildLabelIdPlaceholder( id ) );
    },
    onActivityRemove: function( processDefId, id ) {
    	var processDefIdPlaceholder = this.buildProcessDefIdPlaceholder( processDefId );
    	
    	this.removeByPackageTranslationsKeyContains( processDefIdPlaceholder + '_' + this.buildActivityDefIdPlaceholder( id ) );
    },
    onVariableSetRemove: function( processDefId, activityDefId, id ) {
      var basicPlaceholder = this.buildProcessDefIdPlaceholder( processDefId );
      basicPlaceholder += '_';
      basicPlaceholder += this.buildActivityDefIdPlaceholder( activityDefId );

      this.removeByPackageTranslationsKeyContains( basicPlaceholder + '_' + this.buildVariableSetIdPlaceholder( id ) );
    },
    onActivityFormClear: function( processDefId, activityDefId ) {
    	var basicPlaceholder = this.buildProcessDefIdPlaceholder( processDefId );
    	basicPlaceholder += '_';
    	basicPlaceholder += this.buildActivityDefIdPlaceholder( activityDefId );
    	basicPlaceholder += '_';
    	var placeholders = [
    	                     basicPlaceholder + this.HTTP_LINK_ID_PLACEHOLDER_PREFIX,
    	                     basicPlaceholder + this.ACTION_ACCEPT_BUTTON_ID_PLACEHOLDER_PREFIX,
    	                     basicPlaceholder + this.ADD_FILE_BUTTON_ID_PLACEHOLDER_PREFIX,
    	                     basicPlaceholder + this.GENERATE_PDF_BUTTON_ID_PLACEHOLDER_PREFIX ];
    	
    	Ext.each( placeholders, function( placeholder, index, allPlaceholders ) {
    		this.removeByPackageTranslationsKeyContains( placeholder );
    	}, this );
    },
    buildPackageIdPlaceholder: function( id ) {
    	return this.buildIdPlaceholder( this.PACKAGE_ID_PLACEHOLDER_PREFIX, id );
    },
    buildParticipantIdPlaceholder: function( id ) {
    	return this.buildIdPlaceholder( this.PARTICIPANT_ID_PLACEHOLDER_PREFIX, id );
    },
    buildProcessDefIdPlaceholder: function( id ) {
    	return this.buildIdPlaceholder( this.PROCESS_DEF_ID_PLACEHOLDER_PREFIX, id );
    },
    buildVariableIdPlaceholder: function( id ) {
    	return this.buildIdPlaceholder( this.VARIABLE_ID_PLACEHOLDER_PREFIX, id );
    },
    buildTableIdPlaceholder: function( id ) {
      return this.buildIdPlaceholder( this.TABLE_ID_PLACEHOLDER_PREFIX, id );
    },
    buildLabelIdPlaceholder: function( id ) {
    	return this.buildIdPlaceholder( this.LABEL_ID_PLACEHOLDER_PREFIX, id );
    },
    buildDataChooserIdPlaceholder: function( id ) {
    	return this.buildIdPlaceholder( this.DATA_CHOOSER_ID_PLACEHOLDER_PREFIX, id );
    },
    buildMappingIdPlaceholder: function( id ) {
    	return this.buildIdPlaceholder( this.MAPPING_ID_PLACEHOLDER_PREFIX, id );
    },
    buildActivityDefIdPlaceholder: function( id ) {
    	return this.buildIdPlaceholder( this.ACTIVITY_DEF_ID_PLACEHOLDER_PREFIX, id );
    },
    buildVariableSetIdPlaceholder: function( id ) {
    	return this.buildIdPlaceholder( this.VARIABLE_SET_ID_PLACEHOLDER_PREFIX, id );
    },
    buildDtButtonIdPlaceholder: function( id ) {
    	return this.buildIdPlaceholder( this.DT_BUTTON_ID_PLACEHOLDER_PREFIX, id );
    },
    buildHttpLinkIdPlaceholder: function( id ) {
    	return this.buildIdPlaceholder( this.HTTP_LINK_ID_PLACEHOLDER_PREFIX, id );
    },
    buildAddFileButtonIdPlaceholder: function( id ) {
    	return this.buildIdPlaceholder( this.ADD_FILE_BUTTON_ID_PLACEHOLDER_PREFIX, id );
    },
    buildActionAcceptButtonIdPlaceholder: function( id ) {
    	return this.buildIdPlaceholder( this.ACTION_ACCEPT_BUTTON_ID_PLACEHOLDER_PREFIX, id );
    },
    buildGeneratePdfButtonIdPlaceholder: function( id ) {
    	return this.buildIdPlaceholder( this.GENERATE_PDF_BUTTON_ID_PLACEHOLDER_PREFIX, id );
    },
    buildAddFileButtonIdPlaceholder: function( id ) {
    	return this.buildIdPlaceholder( this.ADD_FILE_BUTTON_ID_PLACEHOLDER_PREFIX, id );
    },
    buildIdPlaceholder: function( prefix, id ) {
    	return prefix + '(' + id + ')'; 
    },
    replaceInPackageTranslationsKeys: function( regex, replacement ) {
    	Ext.ux.suncode.I18N.replaceInPackageTranslationsKeys( regex, replacement );
    },
    removeByPackageTranslationsKeyContains: function( regex ) {
    	Ext.ux.suncode.I18N.removeByPackageTranslationsKeysContains( regex );
    },
    copyTranslationsWithPackageIdChange: function( translations, previousId, currentId ) {
      var copy = deepObjectCopy( translations );
      var regex = this.buildPackageIdPlaceholder( previousId );
      var replacement = this.buildPackageIdPlaceholder( currentId );

      Ext.iterate( copy, function( key, packageTranslation, object ) {
        var newKey = key.replaceAll( regex, replacement );

        if ( newKey !== key ) {
          object[newKey] = packageTranslation;
          delete object[key];
        }
      } );

      return copy;
    },
    copyActivityTranslationsBetweenProcesses: function( previousProcessDefId, previousActivityDefId,
        currentProcessDefId, currentActivityDefId,  ) {
      var packageNode = Ext.getCmp( 'package_panel' ).getRootNode();
      var packageId = packageNode.attributes.packageId;
      var packageIdPlaceholder = this.buildPackageIdPlaceholder( packageId );
      var previousProcessDefIdPlaceholder = this.buildProcessDefIdPlaceholder( previousProcessDefId );
      var previousActivityDefIdPlaceholder = this.buildActivityDefIdPlaceholder( previousActivityDefId );
      var previousTranslationsRegex = packageIdPlaceholder + '_' + previousProcessDefIdPlaceholder + '_' + previousActivityDefIdPlaceholder;
      var previousTranslations = Ext.ux.suncode.I18N.getAllPackageTranslations( previousTranslationsRegex );
      var currentProcessDefIdPlaceholder = this.buildProcessDefIdPlaceholder( currentProcessDefId );
      var currentActivityDefIdPlaceholder = this.buildActivityDefIdPlaceholder( currentActivityDefId );
      var currentTranslationsRegex = packageIdPlaceholder + '_' + currentProcessDefIdPlaceholder + '_' + currentActivityDefIdPlaceholder;

      Ext.iterate( previousTranslations, function( key, packageTranslation, object ) {
        var currentKey = key.replace( previousTranslationsRegex, currentTranslationsRegex );

        Ext.ux.suncode.I18N.savePackageTranslations( currentKey, packageTranslation );
      } );
    },
    replaceAddFileButtonId: function( id ) {
      return id.replaceAll( ' ', '_' );
    },
    replaceHttpLinkId: function( id ) {
      return id.removePolishLetters().replaceAll( ' ', '_' );
    },
    fixTranslations: function() {
      var supportedLanguages = this.getSupportedLanguages();
    	var packageNode = Ext.getCmp( 'package_panel' ).getRootNode();
    	var packageId = packageNode.attributes.packageId;
    	var packageIdPlaceholder = this.buildPackageIdPlaceholder( packageId );
    	
    	Ext.ux.suncode.I18N.fillPackageTranslations( packageIdPlaceholder, packageNode.attributes.packageName );
    	Ext.ux.suncode.I18N.fillPackageTranslations( packageIdPlaceholder + '_DESC', packageNode.attributes.packageDescr );
    	
    	Ext.each( packageNode.attributes.participants, function( role, index, roles ) {
    		var participantIdPlaceholder = this.buildParticipantIdPlaceholder( role.roleId );
    		
    		Ext.ux.suncode.I18N.fillPackageTranslations( packageIdPlaceholder + '_' + participantIdPlaceholder, role.roleName );
    	}, this );
    	
    	packageNode.eachChild( function( processNode ) {
    		var processDefId = processNode.attributes.processDefId;
    		var processName = processNode.attributes.processName;
    		var processDefIdPlaceholder = this.buildProcessDefIdPlaceholder( processDefId );
    		
    		Ext.ux.suncode.I18N.fillPackageTranslations( packageIdPlaceholder + '_' + processDefIdPlaceholder, processName );
    		
    		var processNameMaskTranslationsKey = packageIdPlaceholder + '_' + processDefIdPlaceholder + '_PROCESS_NAME_MASK';
    		Ext.ux.suncode.I18N.fillPackageTranslations( processNameMaskTranslationsKey, processName );
    		var processNameMaskTranslations = this.getPackageTranslations( processNameMaskTranslationsKey );
    		
    		if ( !Ext.isEmpty( processNameMaskTranslations ) ) {
    			Ext.iterate( processNameMaskTranslations, function( language, translation, object ) {
    				object[language] = translation.replaceAll( ' #####', '' );
    			} );
    			
    			this.savePackageTranslations( processNameMaskTranslationsKey, processNameMaskTranslations );
    		}
    		
    		Ext.ux.suncode.I18N.fillPackageTranslations(
    				packageIdPlaceholder + '_' + processDefIdPlaceholder + '_DESC', processNode.attributes.processDescr );
    		
    		Ext.each( processNode.attributes.participants, function( role, index, roles ) {
    			var participantIdPlaceholder = this.buildParticipantIdPlaceholder( role.roleId );
    			
    			Ext.ux.suncode.I18N.fillPackageTranslations(
    					packageIdPlaceholder + '_' + processDefIdPlaceholder + '_' + participantIdPlaceholder, role.roleName );
        	}, this );

        Ext.each( processNode.attributes.tables, function( table, index, tables ) {
          var tableIdPlaceholder = this.buildTableIdPlaceholder( table.id );
          var tableTitleKey = packageIdPlaceholder
              + '_'
              + processDefIdPlaceholder
              + '_'
              + tableIdPlaceholder;
          var tableTitleTranslations = table.translations[tableTitleKey];

          if ( Ext.isEmpty( tableTitleTranslations ) ) {
            tableTitleTranslations = new Object();

            Ext.each( supportedLanguages, function( language, index, languages ) {
              tableTitleTranslations[language] = table.name;
            } );

            table.translations[tableTitleKey] = tableTitleTranslations;
          }

          Ext.each( table.DTButtons, function( dtButton, idx, dtButtons ) {
            var dtButtonIdPlaceholder = this.buildDtButtonIdPlaceholder( dtButton.buttonId );
            var dtButtonNameKey = packageIdPlaceholder
                + '_'
                + processDefIdPlaceholder
                + '_'
                + tableIdPlaceholder
                + '_'
                + dtButtonIdPlaceholder;
            var dtButtonTooltipKey = dtButtonNameKey + '_DESC';

            var dtButtonNameTranslations = dtButton.translations[dtButtonNameKey];
            var dtButtonTooltipTranslations = dtButton.translations[dtButtonTooltipKey];

            if ( Ext.isEmpty( dtButtonNameTranslations ) ) {
              dtButtonNameTranslations = new Object();

              Ext.each( supportedLanguages, function( language, index, languages ) {
                dtButtonNameTranslations[language] = dtButton.name;
              } );

              dtButton.translations[dtButtonNameKey] = dtButtonNameTranslations;
            }

            if ( Ext.isEmpty( dtButtonTooltipTranslations ) ) {
              dtButtonTooltipTranslations = new Object();

              Ext.each( supportedLanguages, function( language, index, languages ) {
                dtButtonTooltipTranslations[language] = dtButton.tooltip;
              } );

              dtButton.translations[dtButtonTooltipKey] = dtButtonTooltipTranslations;
            }
          }, this );
        }, this );
    		
    		Ext.each( processNode.attributes.variables, function( processVariable, index, processVariables ) {
    			var variableIdPlaceholder = this.buildVariableIdPlaceholder( processVariable.id );
    			
    			Ext.ux.suncode.I18N.fillPackageTranslations(
    					packageIdPlaceholder + '_' + processDefIdPlaceholder + '_' + variableIdPlaceholder, processVariable.name );
    			Ext.ux.suncode.I18N.fillPackageTranslations(
    					packageIdPlaceholder + '_' + processDefIdPlaceholder + '_' + variableIdPlaceholder + '_DESC',
    					processVariable.descr );
    			
            	if ( processVariable.type == 'DATA_CHOOSER' ) {
            		var dataChooserPlaceholder = this.buildDataChooserIdPlaceholder( processVariable.id );
            		
            		if ( Ext.isEmpty( processVariable.definition.id ) ) {
            			Ext.each( processVariable.mappings, function( dcMapping, dcMappingIndex, dcMappings ) {
            				var mappingIdPlaceholder = this.buildMappingIdPlaceholder( dcMapping.id );
            				
            				Ext.ux.suncode.I18N.fillPackageTranslations(
                					packageIdPlaceholder
	                					+ '_'
	                					+ processDefIdPlaceholder
	                					+ '_'
	                					+ dataChooserPlaceholder
	                					+ '_'
	                					+ mappingIdPlaceholder,
                					dcMapping.display );
                		}, this );
            		} else {
            			Ext.iterate( processVariable.definition.mappings, function( id, dcMapping, dcMappings ) {
            				var mappingIdPlaceholder = this.buildMappingIdPlaceholder( id );
            				
            				Ext.ux.suncode.I18N.fillPackageTranslations(
                					packageIdPlaceholder
	                					+ '_'
	                					+ processDefIdPlaceholder
	                					+ '_'
	                					+ dataChooserPlaceholder
	                					+ '_'
	                					+ mappingIdPlaceholder,
                					dcMapping.name );
            	    	}, this );
            		}
        		}
        	}, this );
    		
        	processNode.eachChild( function( activityNode ) {
        		var activityDefId = activityNode.attributes.activityDefId;
        		var activityDefIdPlaceholder = this.buildActivityDefIdPlaceholder( activityDefId );
        		
        		Ext.ux.suncode.I18N.fillPackageTranslations(
        				packageIdPlaceholder + '_' + processDefIdPlaceholder + '_' + activityDefIdPlaceholder,
        				activityNode.attributes.activityName );
        		Ext.ux.suncode.I18N.fillPackageTranslations(
        				packageIdPlaceholder + '_' + processDefIdPlaceholder + '_' + activityDefIdPlaceholder + '_DESC',
        				activityNode.attributes.activityDescr );
        		
        		Ext.each( activityNode.attributes.form.variables, function( formVariable, index, formVariables ) {
            		if ( formVariable.genre == 'VARIABLE_SET' ) {
            			var variableSetIdPlaceholder = this.buildVariableSetIdPlaceholder( formVariable.varId );
            			
            			Ext.ux.suncode.I18N.fillPackageTranslations(
            					packageIdPlaceholder
            						+ '_'
            						+ processDefIdPlaceholder
            						+ '_'
            						+ activityDefIdPlaceholder
            						+ '_'
            						+ variableSetIdPlaceholder,
            					formVariable.name );
            			
            			Ext.each( formVariable.DTButtons, function( dtButton, dtButtonIndex, dtButtons ) {
            				var dtButtonIdPlaceholder = this.buildDtButtonIdPlaceholder( dtButton.buttonId );
                			
                			Ext.ux.suncode.I18N.fillPackageTranslations(
                					packageIdPlaceholder
                						+ '_'
                						+ processDefIdPlaceholder
                						+ '_'
                						+ activityDefIdPlaceholder
                						+ '_'
                						+ variableSetIdPlaceholder
                						+ '_'
                						+ dtButtonIdPlaceholder,
                						dtButton.name );
                			
                			Ext.ux.suncode.I18N.fillPackageTranslations(
                					packageIdPlaceholder
                						+ '_'
                						+ processDefIdPlaceholder
                						+ '_'
                						+ activityDefIdPlaceholder
                						+ '_'
                						+ variableSetIdPlaceholder
                						+ '_'
                						+ dtButtonIdPlaceholder
                						+ '_DESC',
                						dtButton.tooltip );
            			}, this );
            		}
            	}, this );
        		
        		Ext.each( activityNode.attributes.form.httpLinks, function( httpLink, index, httpLinks ) {
					var basicPlaceholder = processDefIdPlaceholder + '_' + activityDefIdPlaceholder;
					var replacedButtonName = this.replaceHttpLinkId( httpLink.buttonName );
        			var httpLinkIdPlaceholder = this.buildHttpLinkIdPlaceholder( replacedButtonName );
        			var previousTranslations = this.getPackageTranslations( packageIdPlaceholder
                  + '_'
                  + processDefIdPlaceholder
                  + '_'
                  + activityDefIdPlaceholder
                  + '_'
                  + httpLinkIdPlaceholder );

        			if ( Ext.isEmpty( previousTranslations ) ) {
                this.replaceInPackageTranslationsKeys(
                    basicPlaceholder + '_' + this.buildHttpLinkIdPlaceholder( httpLink.buttonName ),
                    basicPlaceholder + '_' + httpLinkIdPlaceholder );
                this.replaceInPackageTranslationsKeys(
                    basicPlaceholder + '_' + this.buildHttpLinkIdPlaceholder( httpLink.buttonName.replaceAll( ' ', '_' ) ),
                    basicPlaceholder + '_' + httpLinkIdPlaceholder );
              }
        			
        			Ext.ux.suncode.I18N.fillPackageTranslations(
        					packageIdPlaceholder
        						+ '_'
        						+ processDefIdPlaceholder
        						+ '_'
        						+ activityDefIdPlaceholder
        						+ '_'
        						+ httpLinkIdPlaceholder,
        					httpLink.buttonName );
            	}, this );
        		
            	Ext.each( activityNode.attributes.form.buttons, function( formButton, index, formButtons ) {
            		if ( formButton.genre == 'ADD_FILE_BUTTON' ) {
						var basicPlaceholder = processDefIdPlaceholder + '_' + activityDefIdPlaceholder;
						var replacedDocClassName = this.replaceAddFileButtonId( formButton.docClassName );
						var addFileButtonIdPlaceholder = this.buildAddFileButtonIdPlaceholder( replacedDocClassName );
            	    	
            	    	this.replaceInPackageTranslationsKeys(
            	    			basicPlaceholder + '_' + this.buildAddFileButtonIdPlaceholder( formButton.docClassName ),
            	    			basicPlaceholder + '_' + addFileButtonIdPlaceholder );
            	    	this.replaceInPackageTranslationsKeys(
            	    			basicPlaceholder + '_' + this.buildAddFileButtonIdPlaceholder( formButton.actionName ),
            	    			basicPlaceholder + '_' + addFileButtonIdPlaceholder );
            		}
            		
            		switch ( formButton.genre ) {
	            		case 'ACTION_ACCEPT_BUTTON':
	            			var actionAcceptButtonNamePlaceholder = this.buildActionAcceptButtonIdPlaceholder( formButton.actionName );
	            			
	            			Ext.ux.suncode.I18N.fillPackageTranslations(
	            					packageIdPlaceholder
	            						+ '_'
	            						+ processDefIdPlaceholder
	            						+ '_'
	            						+ activityDefIdPlaceholder
	            						+ '_'
	            						+ actionAcceptButtonNamePlaceholder,
	            					formButton.buttonName );
	            			break;
	            		case 'GENERATE_PDF_BUTTON':
	            			var generatePdfButtonNamePlaceholder = this.buildGeneratePdfButtonIdPlaceholder( formButton.actionName );
	            			
	            			Ext.ux.suncode.I18N.fillPackageTranslations(
	            					packageIdPlaceholder
	            						+ '_'
	            						+ processDefIdPlaceholder
	            						+ '_'
	            						+ activityDefIdPlaceholder
	            						+ '_'
	            						+ generatePdfButtonNamePlaceholder,
	            					formButton.buttonName );
	            			break;
	            		case 'ADD_FILE_BUTTON':
							var replacedDocClassName = this.replaceAddFileButtonId( formButton.docClassName );
	            			var addFileButtonNamePlaceholder = this.buildAddFileButtonIdPlaceholder( replacedDocClassName );
	            			
	            			Ext.ux.suncode.I18N.fillPackageTranslations(
	            					packageIdPlaceholder
	            						+ '_'
	            						+ processDefIdPlaceholder
	            						+ '_'
	            						+ activityDefIdPlaceholder
	            						+ '_'
	            						+ addFileButtonNamePlaceholder,
	            					formButton.buttonName );
	            			break;
	            		default:
	            			break;
            		}
            	}, this );
            }, this );
        }, this );
    },
    updateLocalVariableSetTranslations: function( processNode, variableSetId, titleTranslations, dtButtonsTranslations ) {
      var packageNode = Ext.getCmp( 'package_panel' ).getRootNode();
      var packageId = packageNode.attributes.packageId;
      var processDefId = processNode.attributes.processDefId;

      processNode.eachChild(function (activityNode) {
        var activityDefId = activityNode.attributes.activityDefId;
        var titleKey = 'PACK(' + packageId + ')_PROC(' + processDefId
            + ')_ACTIVITY(' + activityDefId + ')_VARIABLESET('
            + variableSetId + ')';

        this.savePackageTranslations( titleKey, titleTranslations );

        Ext.each( dtButtonsTranslations, function ( dtButtonsTranslation, index, all ) {
          var buttonId = dtButtonsTranslation.buttonId;
          var dtButtonNameKey = 'PACK(' + packageId + ')_PROC(' + processDefId
              + ')_ACTIVITY(' + activityDefId + ')_VARIABLESET('
              + variableSetId + ')_DTBUTTON(' + buttonId + ')';
          var dtButtonTooltipKey = 'PACK(' + packageId + ')_PROC(' + processDefId
              + ')_ACTIVITY(' + activityDefId + ')_VARIABLESET('
              + variableSetId + ')_DTBUTTON(' + buttonId + ')_DESC';

          this.savePackageTranslations( dtButtonNameKey, dtButtonsTranslation.nameTranslations );
          this.savePackageTranslations( dtButtonTooltipKey, dtButtonsTranslation.tooltipTranslations );
        }, this );
      }, this);
    }
};