Ext.ux.suncode.I18N = {
	language: 'pl',
  xpdlTranslationLanguage: '',
	bundle: new Array(),
	supportedLanguages: new Array(),
  currentActivityMapMode: false,
	packageTranslations: {},
	init: function( language, supportedLanguages, currentActivityMapMode ) {
		this.language = language;
		this.supportedLanguages = supportedLanguages;
    this.currentActivityMapMode = currentActivityMapMode;

		this.populateBundle();
	},
	populateBundle: function() {
		var language = this.language;

		switch ( language ) {
      case 'pl':
        this.bundle = Ext.ux.suncode.I18NPL.populateBundle();
        break;
      case 'de':
        this.bundle = Ext.ux.suncode.I18NDE.populateBundle();
        break;
      default:
        this.bundle = Ext.ux.suncode.I18NEN.populateBundle();
        break;
		}
	},
	getLanguage: function() {
		return this.language;
	},
  getXpdlTranslationLanguage: function() {
    if ( this.currentActivityMapMode ) {
      return this.language;
    } else {
      return this.xpdlTranslationLanguage;
    }
  },
  setXpdlTranslationLanguage: function( language ) {
    this.xpdlTranslationLanguage = language;
  },
	getSupportedLanguages: function() {
		return this.supportedLanguages;
	},
	getMessage: function( key ) {
		var message = this.bundle[key];

		return !Ext.isEmpty( message ) ? message : key;
	},
	getAllPackageTranslations: function( regex ) {
		if ( !Ext.isEmpty( regex ) ) {
			var processTranslations = new Object();

			Ext.iterate( this.packageTranslations, function( key, packageTranslation, object ) {
				if ( key.indexOf( regex ) > -1) {
					processTranslations[key] = Ext.apply( {}, object[key] );
				}
			} );

			return processTranslations;
		} else {
			return Ext.apply( {}, this.packageTranslations );
		}
	},
	loadPackageTranslations: function( translations ) {
		return this.packageTranslations = translations;
	},
	resetPackageTranslations: function() {
		this.packageTranslations = new Object();
	},
	savePackageTranslations: function( key, translations ) {
		this.packageTranslations[key] = translations;
	},
	savePackageTranslation: function( key, language, translation ) {
		var translations = this.getPackageTranslations( key );

		if ( Ext.isEmpty( translations )) {
			translations = new Object();

			Ext.each( this.supportedLanguages, function( supportedLanguage, index, supportedLanguages ) {
				translations[supportedLanguage] = '';
			} );
		}

		translations[language] = translation;
		this.savePackageTranslations( key, translations );
	},
	getPackageTranslations: function( key ) {
		return this.packageTranslations[key];
	},
	getPackageTranslation: function( key, language ) {
		var translations = this.getPackageTranslations( key );

		if ( !Ext.isEmpty( translations ) ) {
			return translations[language];
		} else {
			return '';
		}
	},
	replaceInPackageTranslationsKeys: function( regex, replacement ) {
		Ext.iterate( this.packageTranslations, function( key, packageTranslation, object ) {
			var newKey = key.replaceAll( regex, replacement );

			if ( newKey !== key ) {
				object[newKey] = packageTranslation;
				delete object[key];
			}
		} );
	},
	removeByPackageTranslationsKeysContains: function( regex ) {
		Ext.iterate( this.packageTranslations, function( key, packageTranslation, object ) {
			if ( key.indexOf( regex ) > -1 ) {
				delete object[key];
			}
		});
	},
	fillPackageTranslations: function( key, value ) {
		var packageTranslations = this.getPackageTranslations( key );
		
		if ( Ext.isEmpty( packageTranslations ) ) {
			packageTranslations = new Object();
			this.packageTranslations[key] = packageTranslations;
		}
		
		Ext.each( this.getSupportedLanguages(), function( language, index, languages ) {
			if ( Ext.isEmpty(packageTranslations[language] ) ) {
				packageTranslations[language] = value;
			}
		} );
	}
};

function getTranslation( key ) {
	return Ext.ux.suncode.I18NService.getMessage( key );
}

function getXpdlPackageNameTranslation( packageId, defaultTranslation ) {
  var translation = Ext.ux.suncode.I18NService.getXpdlPackageNamePackageTranslation( packageId );

  return evaluateXpdlTranslation( translation, defaultTranslation );
}

function getXpdlPackageParticipantNameTranslation( packageId, participantId, defaultTranslation ) {
  var translation = Ext.ux.suncode.I18NService.getXpdlPackageParticipantNamePackageTranslation( packageId, participantId );

  return evaluateXpdlTranslation( translation, defaultTranslation );
}

function getXpdlProcessParticipantNameTranslation( packageId, processDefId, participantId, defaultTranslation ) {
  var translation = Ext.ux.suncode.I18NService.getXpdlProcessParticipantNamePackageTranslation( packageId, processDefId, participantId );

  return evaluateXpdlTranslation( translation, defaultTranslation );
}

function getXpdlProcessNameTranslation( processDefId, defaultTranslation ) {
  var packageNode = Ext.getCmp( 'package_panel' ).getRootNode();
  var packageId = packageNode.attributes.packageId;
  var translation = Ext.ux.suncode.I18NService.getXpdlProcessNamePackageTranslation( packageId, processDefId );

  return evaluateXpdlTranslation( translation, defaultTranslation );
}

function getXpdlActivityNameTranslation( packageId, processDefId, activityDefId, defaultTranslation ) {
  var translation = Ext.ux.suncode.I18NService.getXpdlActivityNamePackageTranslation( packageId, processDefId, activityDefId );

  return evaluateXpdlTranslation( translation, defaultTranslation );
}

function getXpdlVariableNameTranslation( packageId, processDefId, variableId, defaultTranslation ) {
  var translation = Ext.ux.suncode.I18NService.getXpdlVariableNamePackageTranslation( packageId, processDefId, variableId );

  return evaluateXpdlTranslation( translation, defaultTranslation );
}

function getXpdlLabelNameTranslation( packageId, processDefId, labelId, defaultTranslation ) {
  var translation = Ext.ux.suncode.I18NService.getXpdlLabelNamePackageTranslation( packageId, processDefId, labelId );

  return evaluateXpdlTranslation( translation, defaultTranslation );
}

function getXpdlVariableSetTitleTranslation( packageId, processDefId, activityDefId, variableSetId, defaultTranslation ) {
  var translation = Ext.ux.suncode.I18NService.getXpdlVariableSetTitlePackageTranslation( packageId, processDefId, activityDefId, variableSetId );

  return evaluateXpdlTranslation( translation, defaultTranslation );
}

function getXpdlVariableSetDtButtonNameTranslation( packageId, processDefId, activityDefId, variableSetId, dtButtonId, defaultTranslation ) {
  var translation = Ext.ux.suncode.I18NService.getXpdlVariableSetDtButtonNamePackageTranslation( packageId, processDefId, activityDefId, variableSetId, dtButtonId );

  return evaluateXpdlTranslation( translation, defaultTranslation );
}

function getXpdlHttpLinkNameTranslation( packageId, processDefId, activityDefId, buttonName, defaultTranslation ) {
  var translation = Ext.ux.suncode.I18NService.getXpdlHttpLinkNamePackageTranslation( packageId, processDefId, activityDefId, buttonName );

  return evaluateXpdlTranslation( translation, defaultTranslation );
}

function getXpdlActionAcceptButtonNameTranslation( packageId, processDefId, activityDefId, actionName, defaultTranslation ) {
  var translation = Ext.ux.suncode.I18NService.getXpdlActionAcceptButtonNamePackageTranslation( packageId, processDefId, activityDefId, actionName );

  return evaluateXpdlTranslation( translation, defaultTranslation );
}

function getXpdlAddFileButtonNameTranslation( packageId, processDefId, activityDefId, docClassName, defaultTranslation ) {
  var translation = Ext.ux.suncode.I18NService.getXpdlAddFileButtonNamePackageTranslation( packageId, processDefId, activityDefId, docClassName );

  return evaluateXpdlTranslation( translation, defaultTranslation );
}

function getXpdlGeneratePdfButtonNameTranslation( packageId, processDefId, activityDefId, actionName, defaultTranslation ) {
  var translation = Ext.ux.suncode.I18NService.getXpdlGeneratePdfButtonNamePackageTranslation( packageId, processDefId, activityDefId, actionName );

  return evaluateXpdlTranslation( translation, defaultTranslation );
}

function evaluateXpdlTranslation( translation, defaultTranslation ) {
  if ( !Ext.isEmpty( translation ) ) {
    return translation;
  } else {
    return defaultTranslation;
  }
}