Ext.ux.suncode.ProgrammingTaskSpecificationWindow = function( config ) {
    var windowWidth = Ext.getBody().getViewSize().width * 0.5;
    var programmingTask = config.programmingTask;
    var winTitle = programmingTask ? getTranslation( 'Definicja zadania programistycznego' ) + ' ' + programmingTask.name
                    : getTranslation( 'Kreator zadania programistycznego' );

    config = Ext.apply( {
        modal: true,
        width: windowWidth,
        title: winTitle,
        items: [ new Ext.ux.suncode.ProgrammingTaskSpecificationPanel( config ) ],
        closable: true,
        tbar: new Ext.Toolbar( {
            buttons: [ {
                cls: 'x-btn-icon',
                ref: 'saveBtn',
                icon: getPluginImgPath( 'save' ),
                tooltip: getTranslation( 'Zapisz' ),
                handler: this.saveForm,
                scope: this
            }, new Ext.ux.suncode.CloseWindowButton( {
            	win: this
            } ) ]
        } )
    }, config );

    Ext.ux.suncode.ProgrammingTaskSpecificationWindow.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.ProgrammingTaskSpecificationWindow, Ext.Window, {
    initComponent: function() {
        Ext.ux.suncode.ProgrammingTaskSpecificationWindow.superclass.initComponent.call( this );
    },
    saveForm: function() {
        this.programmingTaskSpecificationPanel.saveForm();
    },
    closeWindow: function() {
        this.close();
    }
} );

Ext.ux.suncode.ProgrammingTaskSpecificationPanel = function( config ) {
    var programmingTask = config.programmingTask;
    var mainPanel = Ext.getCmp( 'main_panel' );
    var animationsOn = mainPanel.getAnimationsOn();

    config = Ext.apply( {
        labelWidth: 200,
        autoHeight: true,
        frame: false,
        border: false,
        bodyCssClass: 'x-Module-container-padding',
        ref: 'programmingTaskSpecificationPanel',
        items: [ {
            xtype: 'textfield',
            name: 'name',
            anchor: '100%',
            fieldLabel: getTranslation( 'Nazwa' ),
            allowBlank: false,
            blankText: getTranslation( 'Pole jest wymagane' ),
            validator: this.validateName
        }, new Ext.ux.suncode.ProgrammingTaskTypesChooser( {
            listeners: {
                scope: this,
                select: this.onTypeSelect
            }
        } ), {
            xtype: 'combo',
            anchor: '100%',
            fieldLabel: getTranslation( 'Miejsce wykonania' ),
            triggerAction: 'all',
            mode: 'local',
            forceSelection: true,
            store: new Ext.data.Store( {
                reader: new Ext.data.JsonReader( {
                    fields: Ext.data.Record.create( [ {
                        name: 'executionLocation',
                        type: 'string'
                    }, {
                        name: 'executionLocationName',
                        type: 'string'
                    } ] )
                } )
            } ),
            valueField: 'executionLocation',
            displayField: 'executionLocationName',
            hiddenName: 'executionLocation',
            resizable: true,
            allowBlank: false,
            blankText: getTranslation( 'Pole jest wymagane' )
        }, {
            xtype: 'panel',
            layout: 'accordion',
            layoutConfig: {
                animate: animationsOn,
                fill: false
            },
            style: {
                marginBottom: '5px'
            },
            bodyStyle: {
                border: 0
            },

            items: [ new Ext.ux.suncode.ParameterSpecificationsPanel( {
                title: getTranslation( 'Parametry wejściowe' ),
                ref: '../inputParametersPanel',
                parameters: programmingTask ? programmingTask.inputParameters : []
            } ), new Ext.ux.suncode.ParameterSpecificationsPanel( {
                title: getTranslation( 'Parametry wyjściowe' ),
                ref: '../outputParametersPanel',
                parameters: programmingTask ? programmingTask.outputParameters : []
            } ) ]
        }, {
            xtype: 'fieldset',
            title: getTranslation( 'Opis' ),
            layout: 'fit',
            items: [ {
                xtype: 'textarea',
                name: 'description',
                anchor: '100%',
                height: 100
            } ]
        }, {
            xtype: 'fieldset',
            title: getTranslation( 'Opis algorytmu' ),
            layout: 'fit',
            items: [ {
                xtype: 'textarea',
                name: 'algorithmDescription',
                anchor: '100%',
                height: 100
            } ]
        } ]
    }, config );

    Ext.ux.suncode.ProgrammingTaskSpecificationPanel.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.ProgrammingTaskSpecificationPanel, Ext.FormPanel, {
    initComponent: function() {
        Ext.ux.suncode.ProgrammingTaskSpecificationPanel.superclass.initComponent.call( this );

        this.on( 'afterrender', this.onAfterRender, this );
    },
    onAfterRender: function() {
        var programmingTask = this.initialConfig.programmingTask;

        if ( !Ext.isEmpty( programmingTask ) ) {
            this.getForm().setValues( programmingTask );
            this.loadExecutionLocationStore( programmingTask.type );
        }
    },
    validateName: function( value ) {
        var panel = this.ownerCt;
        var processNode = panel.processNode;
        var programmingTask = panel.programmingTask;

        if ( !Ext.isEmpty( programmingTask ) && programmingTask.name === value ) {
            return true;
        } else {
            var object = Ext.ux.suncode.DocumentationService.getProgrammingTask( processNode, value );

            if ( !Ext.isEmpty( object ) ) {
                return getTranslation( 'Zadanie programistyczne już istnieje.' );
            } else {
                return true;
            }
        }
    },
    onTypeSelect: function( combo, record, index ) {
        var type = combo.getValue();

        if ( !Ext.isEmpty( type ) && combo.isValid() ) {
            this.loadExecutionLocationStore( type );
            this.getForm().findField( 'executionLocation' ).setValue( '' );
        }
    },
    loadExecutionLocationStore: function( type ) {
        var addActivities = false;
        var addTools = false;
        var processNode = this.initialConfig.processNode;
        var records = new Array();

        switch ( type ) {
            case 'servlet':
                addActivities = true;
                break;
            case 'javaclass':
                addActivities = true;
                addTools = true;
                break;
            case 'javascript':
                addActivities = true;
                addTools = true;
                break;
            case 'applet':
                addActivities = true;
                break;
            case 'automatictask':
                addTools = true;
                break;
            default:
                break;
        }

        processNode.eachChild( function( activityNode ) {
            if ( addActivities && activityNode.attributes.activityType == Ext.ux.suncode.Constants.ACTIVITY ) {
                records.push( {
                    executionLocation: activityNode.attributes.activityDefId,
                    executionLocationName: activityNode.attributes.activityName
                } );
            } else if ( addTools && activityNode.attributes.activityType == Ext.ux.suncode.Constants.TOOL ) {
                records.push( {
                    executionLocation: activityNode.attributes.activityDefId,
                    executionLocationName: activityNode.attributes.activityName
                } );
            }
        } );

        var executionLocationChooser = this.getForm().findField( 'executionLocation' );
        var store = executionLocationChooser.getStore();
        store.loadData( records );
    },
    saveForm: function() {
        var form = this.getForm();

        if ( form.isValid() && this.inputParametersPanel.isValid() && this.outputParametersPanel.isValid() ) {
            var processNode = this.initialConfig.processNode;
            var saveToObj = this.initialConfig.saveTo;
            var varRecord = this.initialConfig.varRecord;
            var programmingTask = this.initialConfig.programmingTask;
            var def = form.getValues();
            def = Ext.apply( {
                inputParameters: this.inputParametersPanel.readParameters(),
                outputParameters: this.outputParametersPanel.readParameters()
            }, def );

            if ( saveToObj && varRecord ) {
                if ( programmingTask ) {
                    varRecord.set( 'name', def.name );
                    varRecord.set( 'type', def.type );
                    varRecord.set( 'executionLocation', def.executionLocation );
                    varRecord.commit();
                } else {
                    var store = saveToObj.getStore();
                    store.add( new varRecord( {
                        name: def.name,
                        type: def.type,
                        executionLocation: def.executionLocation
                    } ) );
                    store.commitChanges();
                }
            }

            if ( programmingTask ) {
                Ext.ux.suncode.DocumentationService.editProgrammingTask( processNode, programmingTask.name, def );
            } else {
                Ext.ux.suncode.DocumentationService.addProgrammingTask( processNode, def );
            }

            this.ownerCt.closeWindow();
        }
    }
} );

Ext.ux.suncode.ProgrammingTaskTypesChooser = function( config ) {
    var types = [ [ 'servlet', getTranslation( 'Servlet' ) ], [ 'javaclass', getTranslation( 'Klasa Java' ) ],
                    [ 'javascript', getTranslation( 'JavaScript' ) ], [ 'applet', getTranslation( 'Applet' ) ],
                    [ 'automatictask', getTranslation( 'Zadanie automatyczne' ) ] ];

    config = Ext.apply( {
        name: 'type',
        anchor: '100%',
        fieldLabel: getTranslation( 'Typ zadania' ),
        triggerAction: 'all',
        mode: 'local',
        forceSelection: true,
        store: new Ext.data.ArrayStore( {
            fields: [ 'type', 'typeName' ],
            data: types
        } ),
        valueField: 'type',
        displayField: 'typeName',
        hiddenName: 'type',
        resizable: true,
        allowBlank: false,
        blankText: getTranslation( 'Pole jest wymagane' ),
        editable: false
    }, config );

    Ext.ux.suncode.ProgrammingTaskTypesChooser.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.ProgrammingTaskTypesChooser, Ext.form.ComboBox, {
    initComponent: function() {
        Ext.ux.suncode.ProgrammingTaskTypesChooser.superclass.initComponent.call( this );
    }
} );