Ext.ux.suncode.DocumentationConfigurationWindow = function( config ) {
  var windowWidth = Ext.getBody().getViewSize().width * 0.25;

  config = Ext.apply( {
    modal: true,
    width: windowWidth,
    title: getTranslation( 'Konfiguracja dokumentacji' ),
    items: [ new Ext.ux.suncode.DocumentationConfigurationPanel( config ) ],
    closable: true,
    disableCloseValidation: true,
    tbar: new Ext.Toolbar( {
      buttons: [ {
        cls: 'x-btn-icon',
        icon: getPluginImgPath( 'close' ),
        tooltip: getTranslation( 'Zamknij' ),
        handler: this.closeWindow,
        scope: this
      } ]
    } )
  }, config );

  Ext.ux.suncode.DocumentationConfigurationWindow.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.DocumentationConfigurationWindow, Ext.Window, {
  initComponent: function() {
    Ext.ux.suncode.DocumentationConfigurationWindow.superclass.initComponent.call( this );
  },
  closeWindow: function() {
    this.close();
  }
} );

Ext.ux.suncode.DocumentationConfigurationPanel = function( config ) {
  config = Ext.apply( {
    labelWidth: 200,
    autoHeight: true,
    frame: false,
    border: false,
    bodyCssClass: 'x-Module-container-padding',
    ref: 'documentationConfigurationPanel',
    buttonAlign: 'center',
    items: [ {
      xtype: 'combo',
      anchor: '100%',
      fieldLabel: getTranslation( 'Typ dokumentacji' ),
      triggerAction: 'all',
      mode: 'local',
      forceSelection: true,
      store: new Ext.data.Store( {
        data: [ {
          documentationType: 'BUSINESS',
          documentationTypeName: getTranslation( 'Biznesowa' )
        }, {
          documentationType: 'TECHNICAL',
          documentationTypeName: getTranslation( 'Techniczna' )
        } ],
        reader: new Ext.data.JsonReader( {
          fields: Ext.data.Record.create( [ {
            name: 'documentationType',
            type: 'string'
          }, {
            name: 'documentationTypeName',
            type: 'string'
          } ] )
        } )
      } ),
      valueField: 'documentationType',
      displayField: 'documentationTypeName',
      hiddenName: 'documentationType',
      resizable: true,
      allowBlank: false,
      blankText: getTranslation( 'Pole jest wymagane' ),
      listeners: {
        scope: this,
        select: this.onDocumentationTypeSelect
      }
    }, {
      xtype: 'checkbox',
      name: 'systemLink',
      inputValue: 'true',
      fieldLabel: getTranslation( 'Link do systemu' )
    }, {
      xtype: 'checkbox',
      name: 'rolesList',
      inputValue: 'true',
      fieldLabel: getTranslation( 'Wykaz ról w procesie' )
    }, {
      xtype: 'checkbox',
      name: 'showManualTasks',
      inputValue: 'true',
      fieldLabel: getTranslation( 'Zadania manualne' )
    }, {
      xtype: 'checkbox',
      name: 'showSystemTasks',
      inputValue: 'true',
      fieldLabel: getTranslation( 'Zadania systemowe' )
    }, {
      xtype: 'checkbox',
      name: 'showRoutes',
      inputValue: 'true',
      fieldLabel: getTranslation( 'Przekierowania' )
    }, {
      xtype: 'checkbox',
      name: 'scheduledTasks',
      inputValue: 'true',
      fieldLabel: getTranslation( 'Zadania zaplanowane' )
    }, {
      xtype: 'checkbox',
      name: 'databaseTables',
      inputValue: 'true',
      fieldLabel: getTranslation( 'Tabele baz danych' )
    }, {
      xtype: 'checkbox',
      name: 'integrations',
      inputValue: 'true',
      fieldLabel: getTranslation( 'Integracje' )
    }, {
      xtype: 'checkbox',
      name: 'projectExclusions',
      inputValue: 'true',
      fieldLabel: getTranslation( 'Wyłączenia z projektu' )
    }, {
      xtype: 'checkbox',
      name: 'attachments',
      inputValue: 'true',
      fieldLabel: getTranslation( 'Załączniki' )
    } ],
    buttons: [ {
      cls: 'x-btn-text',
      text: getTranslation( 'Generuj' ),
      tooltip: getTranslation( 'Generuj dokumentację procesu' ),
      handler: this.generateDocumentation,
      scope: this
    } ]
  }, config );

  Ext.ux.suncode.DocumentationConfigurationPanel.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.DocumentationConfigurationPanel, Ext.FormPanel, {
  initComponent: function() {
    Ext.ux.suncode.DocumentationConfigurationPanel.superclass.initComponent.call( this );

    this.on( 'afterrender', this.onAfterRender, this );
  },
  onAfterRender: function() {
    this.getForm().load( {
      url: 'api/documentationconfig/default',
      method: 'GET',
      scope: this,
      failure: function( form, action ) {
        showServerFailure( action.response );
      }
    } );
  },
  onDocumentationTypeSelect: function( combo, record, index ) {
    if ( !combo.isValid() ) {
      return;
    }

    var documentationType = combo.getValue();

    this.getForm().load( {
      url: 'api/documentationconfig/get',
      method: 'GET',
      params: {
        type: documentationType
      },
      scope: this,
      failure: function( form, action ) {
        showServerFailure( action.response );
      }
    } );
  },
  generateDocumentation: function() {
    var form = this.getForm();

    if ( form.isValid() ) {
      form.submit({
        url: 'api/documentationconfig/set',
        waitMsg: getTranslation('Trwa zapisywanie konfiguracji...'),
        waitTitle: getTranslation('Proszę czekać'),
        method: 'POST',
        timeout: 600,
        scope: this,
        success: function (form, action) {
          if (action.result.success) {
            this.ownerCt.close();
            this.executeGenerateDocumentation();
          } else {
            showWarn(getTranslation('Wystąpił błąd.'));
          }
        },
        failure: function (form, action) {
          showServerFailure(action.response);
        }
      });
    }
  },
  executeGenerateDocumentation: function() {
    var processDefId = this.initialConfig.processDefId;

    Ext.ux.suncode.DocumentationService.generateDocumentation( processDefId );
  }
} );