Ext.ux.suncode.ActivitySpecificationWindow = function( config ) {
    var windowWidth = Ext.getBody().getViewSize().width * 0.5;
    var activityNode = config.activityNode;
    var activityName = activityNode.attributes.activityName;
    var activityDefId = activityNode.attributes.activityDefId;
    var processNode = activityNode.parentNode;
    var processDefId = processNode.attributes.processDefId
    var packageNode = processNode.parentNode;
    var packageId = packageNode.attributes.packageId
    var activityNameTranslation = getXpdlActivityNameTranslation( packageId, processDefId, activityDefId, activityName );
    var activityType = activityNode.attributes.activityType;
    var winTitle = '';

    switch ( activityType ) {
        case Ext.ux.suncode.Constants.ROUTE:
            winTitle = getTranslation( 'Specyfikacja przekierowania' ) + ' ' + activityNameTranslation;
            break;
        case Ext.ux.suncode.Constants.ACTIVITY:
            winTitle = getTranslation( 'Specyfikacja zadania' ) + ' ' + activityNameTranslation;
            break;
        case Ext.ux.suncode.Constants.TOOL:
            winTitle = getTranslation( 'Specyfikacja narzędzia' ) + ' ' + activityNameTranslation;
            break;
        case Ext.ux.suncode.Constants.SUBFLOW:
            winTitle = getTranslation( 'Specyfikacja podprocesu' ) + ' ' + activityNameTranslation;
            break;
        default:
            break;
    }

    config = Ext.apply( {
        modal: true,
        width: windowWidth,
        title: winTitle,
        items: [ new Ext.ux.suncode.ActivitySpecificationPanel( config ) ],
        closable: true,
        tbar: new Ext.Toolbar( {
            buttons: [ {
                cls: 'x-btn-icon',
                ref: 'saveBtn',
                icon: getPluginImgPath( 'save' ),
                tooltip: getTranslation( 'Zapisz' ),
                handler: this.saveForm,
                scope: this
            }, new Ext.ux.suncode.CloseWindowButton( {
            	win: this
            } ) ]
        } )
    }, config );

    Ext.ux.suncode.ActivitySpecificationWindow.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.ActivitySpecificationWindow, Ext.Window, {
    initComponent: function() {
        Ext.ux.suncode.ActivitySpecificationWindow.superclass.initComponent.call( this );
    },
    saveForm: function() {
        this.activitySpecificationPanel.saveForm();
    },
    closeWindow: function() {
        this.close();
    }
} );

Ext.ux.suncode.ActivitySpecificationPanel = function( config ) {
    var activityNode = config.activityNode;
    var processNode = activityNode.parentNode;
    var specification = activityNode.attributes.specification;
    var mainPanel = Ext.getCmp( 'main_panel' );
    var animationsOn = mainPanel.getAnimationsOn();

    config = Ext.apply( {
        labelWidth: 200,
        autoHeight: true,
        frame: false,
        border: false,
        bodyCssClass: 'x-Module-container-padding',
        ref: 'activitySpecificationPanel',
        items: [ {
            xtype: 'panel',
            layout: 'accordion',
            layoutConfig: {
                animate: animationsOn,
                fill: false
            },
            bodyStyle: {
              border: 0
            },
            style: {
                marginBottom: '5px'
            },
            items: [ new Ext.ux.suncode.GeneratedDocumentSpecificationsPanel( {
                height: 200,
                collapsed: true,
                ref: '../generatedDocumentsPanel',
                generatedDocuments: specification.generatedDocuments
            } ), new Ext.ux.suncode.ViewDocumentClassSpecificationsPanel( {
                ref: '../viewDocumentClassesPanel',
                viewDocumentClasses: specification.viewDocumentClasses
            } ) ]
        }, new Ext.ux.suncode.SpecificationDescriptionArea( {
            processNode: processNode,
            title: getTranslation( 'Ogólny opis' ),
            fieldName: 'generalActivityDescription',
            description: specification.generalActivityDescription
        } ), new Ext.ux.suncode.SpecificationDescriptionArea( {
            processNode: processNode,
            title: getTranslation( 'Opis powiadomień mailowych' ),
            fieldName: 'emailNotificationsDescription',
            description: specification.emailNotificationsDescription
        } ) ]
    }, config );

    Ext.ux.suncode.ActivitySpecificationPanel.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.ActivitySpecificationPanel, Ext.FormPanel, {
    initComponent: function() {
        Ext.ux.suncode.ActivitySpecificationPanel.superclass.initComponent.call( this );

        this.on( 'afterrender', this.onAfterRender, this );
    },
    onAfterRender: function() {
        var activityNode = this.initialConfig.activityNode;
        var specification = activityNode.attributes.specification;
        this.getForm().setValues( specification );
    },
    saveForm: function() {
        var form = this.getForm();

        if ( form.isValid() && this.viewDocumentClassesPanel.isValid() && this.generatedDocumentsPanel.isValid() ) {
            var activityNode = this.initialConfig.activityNode;
            var values = form.getValues();
            values = Ext.apply( {
                viewDocumentClasses: this.viewDocumentClassesPanel.readViewDocumentClasses(),
                generatedDocuments: this.generatedDocumentsPanel.readGeneratedDocuments()
            }, values );
            Ext.ux.suncode.DocumentationService.setActivitySpecification( activityNode, values );

            Ext.getCmp( 'main_panel' ).setSaved( false );
            this.ownerCt.closeWindow();
        }
    }
} );

Ext.ux.suncode.ViewDocumentClassSpecificationsPanel = function( config ) {
    var store = new Ext.data.Store( {
        data: config.viewDocumentClasses,
        reader: new Ext.data.JsonReader( {
            fields: Ext.data.Record.create( [ {
                name: 'name',
                type: 'string'
            } ] )
        } )
    } );

    var docClassesChooser = new Ext.ux.suncode.SystemDocumentClassesChooser( {} );

    config = Ext.apply( {
        title: getTranslation( 'Klasy dokumentów w podglądzie' ),
        height: 200,
        store: store,
        columnLines: true,
        autoScroll: true,
        frame: false,
        enableColumnMove: true,
        collapsed: true,
        colModel: new Ext.grid.ColumnModel( {
            defaults: {
                sortable: true,
                menuDisabled: false
            },
            columns: [ {
                id: 'name',
                header: getTranslation( 'Nazwa' ),
                dataIndex: 'name',
                align: 'left',
                editor: docClassesChooser,
                renderer: Ext.util.Format.ComboBoxRenderer( docClassesChooser )
            } ]
        } ),
        viewConfig: new Ext.ux.suncode.StandardGridView( {
            emptyText: getTranslation( 'Brak klas dokumentów w podglądzie' )
        } ),
        sm: new Ext.grid.RowSelectionModel( {
            singleSelect: true
        } ),
        tbar: new Ext.Toolbar( {
            items: [ '->', {
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'add' ),
                tooltip: getTranslation( 'Dodaj klasę dokumentów' ),
                handler: function() {
                    var grid = this.ownerCt.ownerCt;
                    var store = grid.getStore();
                    var v = store.recordType;
                    var rec = new v( {
                        name: ''
                    } );
                    grid.stopEditing();
                    store.add( rec );
                    store.commitChanges();
                }
            }, {
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'delete' ),
                tooltip: getTranslation( 'Usuń klasę dokumentów' ),
                handler: function() {
                    var grid = this.ownerCt.ownerCt;
                    var selModel = grid.getSelectionModel();
                    var rows = selModel.getSelections();
                    if ( rows.length == 0 ) {
                        showWarn( getTranslation( 'Wybierz klasę dokumentów do usunięcia.' ) );
                        return;
                    }
                    removeRowAndMarkNext( grid, rows[0] );
                    grid.getView().refresh();
                }
            } ]
        } ),
        listeners: {
            validateedit: function( e ) {
                var grid = e.grid;
                var store = grid.getStore();
                var cm = grid.getColumnModel();
                var colIndex = e.column;
                var value = e.value;

                if ( cm.getColumnId( colIndex ) == 'name' && !Ext.isEmpty( value ) && store.findExact( 'name', value ) != -1 ) {
                    showWarn( getTranslation( 'Klasa dokumentów została już dodana.' ) );
                    return false;
                }
            },
            afteredit: function( e ) {
                e.record.commit();
            }
        }
    }, config );

    Ext.ux.suncode.ViewDocumentClassSpecificationsPanel.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.ViewDocumentClassSpecificationsPanel, Ext.grid.EditorGridPanel, {
    initComponent: function() {
        Ext.ux.suncode.ViewDocumentClassSpecificationsPanel.superclass.initComponent.call( this );
    },
    isValid: function() {
        var valid = true;
        var store = this.getStore();

        store.each( function( rec ) {
            var name = rec.get( 'name' );

            if ( Ext.isEmpty( name ) ) {
                showWarn( getTranslation( 'Uzupełnij poprawnie tabelę klasy dokumentów w podglądzie.' ) );
                valid = false;
                return false;
            }
        } );

        return valid;
    },
    readViewDocumentClasses: function() {
        var viewDocumentClasses = new Array();
        var store = this.getStore();

        store.each( function( rec ) {
            viewDocumentClasses.push( {
                name: rec.get( 'name' )
            } );
        } );

        return viewDocumentClasses;
    }
} );