Ext.ux.suncode.VariablesMenuWindow = function( config ) {
    config = Ext.apply( {
        height: 300,
        layout: 'fit',
        header: false,
        cls: 'x-Module-window-header-hidden',
        frame: false,
        shadow: false,
        closable: false,
        draggable: false,
        resizable: false,
        toFront: Ext.emptyFn,
        items: [ new Ext.ux.suncode.VariablesMenuGrid( {
        	processNode: config.processNode,
        	contextVariables: config.contextVariables,
        	variableId: config.variableId,
          variableType: config.variableType,
          acceptTable: config.acceptTable,
          inArray: config.inArray,
          customField: config.customField,
          disableVariableDuplication: config.disableVariableDuplication,
          availableVariables: config.availableVariables
        } ) ]
    }, config );

    Ext.ux.suncode.VariablesMenuWindow.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.VariablesMenuWindow, Ext.Window, {
    initComponent: function() {
        Ext.ux.suncode.VariablesMenuWindow.superclass.initComponent.call( this );
    },
    getMenuPanel: function() {
        return this.menuPanel;
    },
    handleMenuText: function( menuText ) {
      var sortFunctions = [ function( record, id ) {
        var regex = new RegExp( Ext.escapeRe( menuText ), 'i' );
        var name = record.get( 'name' );

        return regex.test( name );
      }, function( record, id ) {
        var regex = new RegExp( Ext.escapeRe( menuText ), 'i' );
        var name = record.get( 'name' );
        var description  = record.get( 'description' );

        return regex.test( name ) || regex.test( description );
      } ];
      var menuPanel = this.getMenuPanel();
      var store = menuPanel.getStore();

      Ext.each( sortFunctions, function( sortFunction, index, allSortFunctions ) {
        store.filterBy( sortFunction );

        if ( store.getCount() > 0 ) {
          return false;
        }
      } );

      if ( store.getCount() > 0 ) {
        var selModel = menuPanel.getSelectionModel();
        selModel.selectFirstRow();
      }
    },
    onDown: function() {
        var menuPanel = this.getMenuPanel();
        var store = menuPanel.getStore();

        if ( store.getCount() > 0 ) {
            var selModel = menuPanel.getSelectionModel();

            if ( selModel.hasNext() ) {
                selModel.selectRow( selModel.last + 1 );
                this.syncScroll( selModel.last + 1 );
            } else {
                selModel.selectFirstRow();
                this.syncScroll( 0 );
            }
        }
    },
    onUp: function() {
        var menuPanel = this.getMenuPanel();
        var store = menuPanel.getStore();

        if ( store.getCount() > 0 ) {
            var selModel = menuPanel.getSelectionModel();

            if ( selModel.hasPrevious() ) {
                selModel.selectRow( selModel.last - 1 );
                this.syncScroll( selModel.last - 1 );
            } else {
                selModel.selectLastRow();
                this.syncScroll( store.getCount() - 1 );
            }
        }
    },
    syncScroll: function( rowIndex ) {
    	var menuPanel = this.getMenuPanel();
    	var view = menuPanel.getView();
        view.syncFocusEl( view.ensureVisible( rowIndex, 0, false ) );
    },
    chooseMenuOption: function() {
        var menuPanel = this.getMenuPanel();
        var selModel = menuPanel.getSelectionModel();
        var record = selModel.getSelected();

        if ( !Ext.isEmpty( record ) ) {
            var id = record.get( 'id' );
            var customField = this.initialConfig.customField;
            var setVariableFunc = customField.setVariable;

            if ( Ext.isFunction( setVariableFunc ) ) {
            	setVariableFunc.apply( customField, [ id ] );
            }
        }
    }
} );

Ext.ux.suncode.VariablesMenuGrid = function( config ) {
	var processNode = config.processNode;
	var variableId = config.variableId;
	var variableType = config.variableType;
	var usedVariableIds = this.evaluateUsedVariableIds( config.disableVariableDuplication, config.inArray, config.customField );
	var availableVariables = config.availableVariables;
  var data = new Array();
	data = data.concat( this.buildContextVariablesData( config.contextVariables, variableType, usedVariableIds ) );
	data = data.concat( this.buildProcessData(
			processNode.attributes.variables, variableType, config.acceptTable, usedVariableIds, availableVariables ) );
	data = data.concat( this.buildProcessData(
			processNode.attributes.formalParameters, variableType, config.acceptTable, usedVariableIds ) );

	var store = new Ext.data.Store( {
		data: this.sortData( data ),
		reader : new Ext.data.JsonReader( {
			fields : Ext.data.Record.create( [ {
				name : 'id',
				type : 'string'
			}, {
				name : 'name',
				type : 'string'
			}, {
				name : 'description',
				type : 'string'
			}, {
				name : 'context',
				type : 'boolean'
			} ] )
		} )
	} );
	
	if ( !Ext.isEmpty( variableId ) ) {
		store.filter( 'id', variableId );
	}

    config = Ext.apply( {
        ref: 'menuPanel',
        store: store,
        columnLines: true,
        autoScroll: true,
        border: false,
        colModel: new Ext.grid.ColumnModel( {
            defaults: {
                sortable: false,
                menuDisabled: true
            },
            columns: [ {
                id: 'name',
                header: getTranslation( 'Nazwa zmiennej' ),
                dataIndex: 'name',
                align: 'left',
                width: 300,
                fixed: true,
                renderer: function( value, metaData, record, rowIndex, colIndex, store ) {
                    if ( !value.includes( ' ' ) && value.includes( '.' ) && value.length > 25 ) {
                      var splitted = value.match(/.{1,25}/g);

                      return splitted.join( '<br>' );
                    } else {
                      return wrapColumnValue( value );
                    }
                }
            }, {
                id: 'description',
                header: getTranslation( 'Opis' ),
                dataIndex: 'description',
                align: 'left',
                renderer: function( value, metaData, record, rowIndex, colIndex, store ) {
                  if ( !Ext.isEmpty( value ) ) {
                    metaData.attr = 'ext:qtip="' + value + '"';
                    return wrapColumnValue( value.ellipse( 150 ) );
                  } else {
                    return '';
                  }
                }
            }, {
                id: 'context',
                header: getTranslation( 'Zmienna kontekstowa' ),
                dataIndex: 'context',
                align: 'center',
                width: 160,
                fixed: true,
                renderer: tickCrossValue
            }, ]
        } ),
        viewConfig: new Ext.ux.suncode.StandardGridView( {
            emptyText: getTranslation( 'Brak zmiennych procesu' )
        } ),
        sm: new Ext.grid.RowSelectionModel( {
            singleSelect: true
        } ),
        listeners: {
            scope: this,
            viewready: this.onViewReady,
            cellmousedown: this.onCellMouseDown
        }
    }, config );

    Ext.ux.suncode.VariablesMenuGrid.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.VariablesMenuGrid, Ext.grid.GridPanel, {
    initComponent: function() {
        Ext.ux.suncode.VariablesMenuGrid.superclass.initComponent.call( this );
    },
    DEFAULT_TYPE: 'string',
    VARIABLE_TYPE: 'variable',
    evaluateUsedVariableIds: function( disableVariableDuplication, inArray, customField ) {
    	var usedVariableIds = new Object();

    	if ( disableVariableDuplication && inArray && !Ext.isEmpty( customField.array ) ) {
    		var array = customField.array;
    		var values = array.getFieldValue();
    		
    		if ( Ext.isArray( values ) ) {
    			Ext.each( values, function( value, index, allValues ) {
    				if ( Ext.isDefined( value ) && value.type === this.VARIABLE_TYPE ) {
    					usedVariableIds[value.value] = true;
    				}
    			}, this );
    		}
    	}
    	
    	return usedVariableIds;
    },
    buildContextVariablesData: function( elements, variableType, usedVariableIds ) {
		var data = new Array();
		
		if ( !Ext.isEmpty( elements ) ) {
			Ext.each( elements, function( element, index, allElements ) {
				var hidden = element.hidden;
				var elementType = !Ext.isEmpty( element.type ) ? element.type : this.DEFAULT_TYPE;
				
				if ( !hidden &&
						( variableType === Ext.ux.suncode.IntegrationComponentService.VARIABLE_TYPE ||
								variableType === elementType ) && !usedVariableIds[element.id] ) {
					data.push( {
						id: element.id,
						name: element.name,
						description: element.description,
						context: true
					} );
				}
			}, this );
		}
		
		return data;
	},
	buildProcessData: function( elements, variableType, acceptTable, usedVariableIds, availableVariables ) {
		var data = new Array();
		
		if ( !Ext.isEmpty( elements ) ) {
			Ext.each( elements, function( element, index, allElements ) {
				if ( this.shouldAcceptProcessDatum( variableType, acceptTable, element, usedVariableIds, availableVariables ) ) {
					data.push( {
						id: element.id,
						name: element.name,
						description: element.descr,
						context: false
					} );
				}
			}, this );
		}
		
		return data;
	},
	shouldAcceptProcessDatum: function( variableType, acceptTable, element, usedVariableIds, availableVariables ) {
		if ( usedVariableIds[element.id] || !( Ext.isEmpty( availableVariables ) || availableVariables.indexOf( element.id ) != -1 ) ) {
			return false;
		}
		
		var typesMatrix = Ext.ux.suncode.IntegrationComponentService.VARIABLE_TYPES_MATRIX;
		var type = element.type;
		
		if ( variableType === Ext.ux.suncode.IntegrationComponentService.VARIABLE_TYPE ) {
			return true;
		} else if ( variableType === typesMatrix[type] ) {
			return ( acceptTable || Ext.isEmpty( element.placement ) || element.placement === 'form' );
		} else {
			return false;
		}
	},
	sortData: function( data ) {
		data.sort( function( a, b ) {
			if ( a.context === b.context ) {
				return ( a.name.toLowerCase() > b.name.toLowerCase() ) ? 1 : -1;
			} else {
				return a.context ? -1 : 1;
			}
		} );
		
		return data;
	},
    onViewReady: function( grid ) {
        var store = grid.getStore();

        if ( store.getCount() > 0 ) {
            var selModel = grid.getSelectionModel();
            selModel.selectFirstRow();
        }
    },
    onCellMouseDown: function( grid, rowIndex, columnIndex, e ) {
        this.ownerCt.chooseMenuOption();
    }
} );