var HashMap = function() {
    this._dict = [];
};

HashMap.prototype._get = function( key ) {
    for ( var i = 0, couplet; couplet = this._dict[i]; i++ ) {
        if ( couplet[0] === key ) {
            return couplet;
        }
    }

    return null;
};

HashMap.prototype.put = function( key, value ) {
    var couplet = this._get( key );

    if ( couplet ) {
        couplet[1] = value;
    } else {
        this._dict.push( [ key, value ] );
    }

    return this;
};

HashMap.prototype.get = function( key ) {
    var couplet = this._get( key );

    if ( couplet ) {
        return couplet[1];
    } else {
        return null;
    }
};

HashMap.prototype.remove = function( key ) {
	for ( var i = 0, couplet; couplet = this._dict[i]; i++ ) {
        if ( couplet[0] === key ) {
        	this._dict.splice( i, 1 );
        	break;
        }
    }
	
	return this;
};

HashMap.prototype.contains = function( key ) {
	for ( var i = 0, couplet; couplet = this._dict[i]; i++ ) {
        if ( couplet[0] === key ) {
        	return true;
        }
    }
	
	return false;
};

HashMap.prototype.clear = function() {
    clearArray( this._dict );
};

HashMap.prototype.isEmpty = function() {
    return Ext.isEmpty( this._dict );
};

HashMap.prototype.each = function( func, scope ) {
	if ( Object.prototype.toString.apply( func ) === '[object Function]' ) {
		scope = scope ? scope : window;

		for( var i = 0; i < this._dict.length; i++ ) {
	    	var couplet = this._dict[i];
	    	func.apply( scope, [ couplet[0], couplet[1] ] );
	    }
	}
};