/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.web.support.dto.configuration.builder;

import com.plusmpm.util.HistoryVariable;
import com.suncode.plugin.pwe.service.language.LanguageService;
import com.suncode.plugin.pwe.service.plugin.PluginService;
import com.suncode.plugin.pwe.util.PweUtils;
import com.suncode.plugin.pwe.web.support.dto.configuration.ProcessPreviewConfigurationDto;
import com.suncode.plugin.pwe.web.support.dto.configuration.PweConfigurationDto;
import com.suncode.plugin.pwe.web.support.dto.configuration.SimulationConfigurationDto;
import com.suncode.plugin.pwe.web.support.dto.configuration.builder.ProcessPreviewConfigurationDtoBuilder;
import com.suncode.plugin.pwe.web.support.dto.configuration.builder.SimulationConfigurationDtoBuilder;
import com.suncode.pwfl.administration.configuration.SystemProperties;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PweConfigurationDtoBuilder {
    @Autowired
    private SimulationConfigurationDtoBuilder simulationConfigurationDtoBuilder;
    @Autowired
    private ProcessPreviewConfigurationDtoBuilder processPreviewConfigurationDtoBuilder;
    @Autowired
    private PluginService pluginService;
    @Autowired
    private LanguageService languageService;

    public PweConfigurationDto buildForCurrentActivityMapMode(String processDefId, String processId, String activityDefId, HistoryVariable[] historyVariables) {
        PweConfigurationDto dto = this.initialize();
        dto.setCurrentActivityMapMode(true);
        dto.setSimulationMode(false);
        dto.setProcessPreviewMode(false);
        dto.setEditionMode(false);
        dto.setCanUseDefaultUserConfig(true);
        dto.setSimulation(this.buildSimulationForCurrentActivityMapMode(processDefId, processId, activityDefId, historyVariables));
        return dto;
    }

    private SimulationConfigurationDto buildSimulationForCurrentActivityMapMode(String processDefId, String processId, String activityDefId, HistoryVariable[] historyVariables) {
        return this.simulationConfigurationDtoBuilder.buildForCurrentActivityMapMode(processDefId, processId, activityDefId, historyVariables);
    }

    public PweConfigurationDto buildForSimulationMode(String processDefId, String processId, HistoryVariable[] historyVariables) {
        PweConfigurationDto dto = this.initialize();
        dto.setCurrentActivityMapMode(false);
        dto.setSimulationMode(true);
        dto.setProcessPreviewMode(false);
        dto.setEditionMode(false);
        dto.setCanUseDefaultUserConfig(true);
        dto.setSimulation(this.buildSimulationForSimulationMode(processDefId, processId, historyVariables));
        return dto;
    }

    private SimulationConfigurationDto buildSimulationForSimulationMode(String processDefId, String processId, HistoryVariable[] historyVariables) {
        return this.simulationConfigurationDtoBuilder.buildForSimulationMode(processDefId, processId, historyVariables);
    }

    public PweConfigurationDto buildForProcessPreviewMode(String processDefId) {
        PweConfigurationDto dto = this.initialize();
        dto.setCurrentActivityMapMode(false);
        dto.setSimulationMode(false);
        dto.setProcessPreviewMode(true);
        dto.setEditionMode(false);
        dto.setCanUseDefaultUserConfig(true);
        dto.setProcessPreview(this.buildProcessPreview(processDefId));
        return dto;
    }

    private ProcessPreviewConfigurationDto buildProcessPreview(String processDefId) {
        return this.processPreviewConfigurationDtoBuilder.build(processDefId);
    }

    public PweConfigurationDto buildForEditionMode() {
        PweConfigurationDto dto = this.initialize();
        dto.setCurrentActivityMapMode(false);
        dto.setSimulationMode(false);
        dto.setProcessPreviewMode(false);
        dto.setEditionMode(true);
        dto.setCanUseDefaultUserConfig(false);
        return dto;
    }

    private PweConfigurationDto initialize() {
        PweConfigurationDto dto = new PweConfigurationDto();
        dto.setLanguage(PweUtils.getLanguage());
        dto.setSupportedLanguages(this.getSupportedLanguages());
        dto.setSystemType(this.getSystemType());
        dto.setVersion(this.getVersion());
        return dto;
    }

    private List<String> getSupportedLanguages() {
        return this.languageService.getSupportedLanguages();
    }

    private String getSystemType() {
        return SystemProperties.getString((String)"SystemType");
    }

    private String getVersion() {
        return this.pluginService.getPluginVersion().getVersion();
    }
}

