/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.web.rest;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.suncode.plugin.pwe.service.xpdl.InternalXpdlService;
import com.suncode.plugin.pwe.util.PageResult;
import com.suncode.plugin.pwe.util.PweUtils;
import com.suncode.plugin.pwe.web.support.dto.xpdl.ExportZipDto;
import com.suncode.plugin.pwe.web.support.dto.xpdl.PackageLoadDto;
import com.suncode.plugin.pwe.web.support.dto.xpdl.PackageNodeDto;
import com.suncode.plugin.pwe.web.support.dto.xpdl.PackageTranslationImportDto;
import com.suncode.plugin.pwe.web.support.dto.xpdl.PackageVersionInfoDto;
import com.suncode.plugin.pwe.web.support.dto.xpdl.PackageVersionNodeDto;
import com.suncode.plugin.pwe.web.support.dto.xpdl.ProcessDto;
import com.suncode.plugin.pwe.web.support.dto.xpdl.ProcessVersionDto;
import com.suncode.plugin.pwe.web.support.dto.xpdl.ServerXpdlDto;
import com.suncode.plugin.pwe.web.support.dto.xpdl.VariableIdValidationDto;
import com.suncode.plugin.pwe.web.support.dto.xpdl.VariableTypeValidationDto;
import com.suncode.plugin.pwe.web.support.dto.xpdl.XpdlHistoryDto;
import com.suncode.plugin.pwe.web.support.dto.xpdl.XpdlOpenDto;
import com.suncode.plugin.pwe.web.support.dto.xpdl.XpdlValidationDto;
import com.suncode.plugin.pwe.web.support.form.ExportTranslationsForm;
import com.suncode.plugin.pwe.web.support.form.ExportZipForm;
import com.suncode.plugin.pwe.web.support.form.ImportTranslationsForm;
import com.suncode.plugin.pwe.web.support.form.OpenForm;
import com.suncode.plugin.pwe.web.support.form.PackageLoadForm;
import com.suncode.plugin.pwe.web.support.form.SaveForm;
import com.suncode.plugin.pwe.web.support.form.SaveXpdlErrorsForm;
import com.suncode.plugin.pwe.web.support.form.ValidateVariableTypeForm;
import com.suncode.plugin.pwe.web.support.form.ZipForm;
import com.suncode.plugin.pwe.web.support.result.CountedResult;
import com.suncode.plugin.pwe.web.support.result.DataResult;
import com.suncode.plugin.pwe.web.support.util.PagingInfo;
import com.suncode.plugin.pwe.web.support.util.RestUtils;
import com.suncode.plugin.pwe.web.support.util.SortInfo;
import com.suncode.pwfl.administration.configuration.SystemProperties;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/xpdl"})
public class XpdlController {
    private static final String XPDL_CONTENT_TYPE = "application/xpdl";
    private static final String ZIP_CONTENT_TYPE = "application/zip";
    private static final String HTML_CONTENT_TYPE = "text/html";
    private static final String XPDL_ERRORS_CONTENT_TYPE = "text/plain";
    private static final String XLSX_CONTENT_TYPE = "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet";
    private static final Cache<UUID, XpdlOpenDto> OPENED_XPDL_CACHE_CACHE = CacheBuilder.newBuilder().expireAfterWrite(60L, TimeUnit.SECONDS).build();
    @Autowired
    private InternalXpdlService internalXpdlService;

    @RequestMapping(value={"getPreview"}, method={RequestMethod.POST}, produces={"text/plain; charset=utf-8"})
    @ResponseBody
    public String getPreview(@RequestParam String xpdl) {
        return this.internalXpdlService.getPreview(xpdl);
    }

    @RequestMapping(value={"getPreview"}, method={RequestMethod.GET}, produces={"text/plain; charset=utf-8"})
    @ResponseBody
    public String getPreview(@RequestParam String packageId, @RequestParam String packageVersion) {
        return this.internalXpdlService.getPreview(packageId, packageVersion);
    }

    @RequestMapping(value={"validate"}, method={RequestMethod.POST})
    @ResponseBody
    public XpdlValidationDto validate(@RequestParam String xpdl) {
        return this.internalXpdlService.validate(xpdl);
    }

    @RequestMapping(value={"getPackageNodes"}, method={RequestMethod.GET})
    @ResponseBody
    public List<PackageNodeDto> getPackageNodes() {
        return this.internalXpdlService.getPackageNodes();
    }

    @RequestMapping(value={"getPackageVersionNodes"}, method={RequestMethod.GET})
    @ResponseBody
    public List<PackageVersionNodeDto> getPackageVersionNodes(@RequestParam String packageId) {
        return this.internalXpdlService.getPackageVersionNodes(packageId);
    }

    @RequestMapping(value={"getPackageVersionInfo"}, method={RequestMethod.GET})
    @ResponseBody
    public DataResult<PackageVersionInfoDto> getPackageVersionInfo(@RequestParam String packageId, @RequestParam String packageVersion) {
        PackageVersionInfoDto dto = this.internalXpdlService.getPackageVersionInfo(packageId, packageVersion);
        return new DataResult<PackageVersionInfoDto>(true, dto);
    }

    @RequestMapping(value={"getHistory"}, method={RequestMethod.GET})
    @ResponseBody
    public CountedResult<XpdlHistoryDto> getHistory(PagingInfo pagingInfo, SortInfo sortInfo) {
        PageResult<XpdlHistoryDto> pageResult = this.internalXpdlService.getHistory(pagingInfo.getStart(), pagingInfo.getLimit(), sortInfo.getSort(), sortInfo.getDir());
        return new CountedResult<XpdlHistoryDto>(pageResult.getPage(), pageResult.getTotal());
    }

    @RequestMapping(value={"getProcesses"}, method={RequestMethod.GET})
    @ResponseBody
    public CountedResult<ProcessDto> getProcesses(@RequestParam String packageId, @RequestParam String packageVersion) {
        List<ProcessDto> dtos = this.internalXpdlService.getProcesses(packageId, packageVersion);
        long total = dtos.size();
        return new CountedResult<ProcessDto>(dtos, total);
    }

    @RequestMapping(value={"getProcessVersions"}, method={RequestMethod.GET})
    @ResponseBody
    public CountedResult<ProcessVersionDto> getProcessVersions(@RequestParam String packageId, @RequestParam String processDefId) {
        List<ProcessVersionDto> dtos = this.internalXpdlService.getProcessVersions(packageId, processDefId);
        long total = dtos.size();
        return new CountedResult<ProcessVersionDto>(dtos, total);
    }

    @RequestMapping(value={"getFromServer"}, method={RequestMethod.GET})
    @ResponseBody
    public CountedResult<ServerXpdlDto> getFromServer(HttpServletRequest request, @RequestParam String source, @RequestParam(required=false) String query) {
        String userId = RestUtils.getUserIdFromSession(request);
        List<ServerXpdlDto> dtos = this.internalXpdlService.getFromServer(userId, source, query);
        long total = dtos.size();
        return new CountedResult<ServerXpdlDto>(dtos, total);
    }

    @RequestMapping(value={"save"}, method={RequestMethod.POST})
    @ResponseBody
    public Boolean save(HttpServletRequest request, SaveForm form) {
        String userId = RestUtils.getUserIdFromSession(request);
        return this.internalXpdlService.save(userId, form);
    }

    @RequestMapping(value={"autoSave"}, method={RequestMethod.POST})
    @ResponseBody
    public Boolean autoSave(HttpServletRequest request, SaveForm form) {
        String userId = RestUtils.getUserIdFromSession(request);
        return this.internalXpdlService.autoSave(userId, form);
    }

    @RequestMapping(value={"generate"}, method={RequestMethod.POST})
    public ResponseEntity<byte[]> generate(HttpServletRequest request, @RequestParam String xpdl, @RequestParam String fileName) throws UnsupportedEncodingException {
        String userId = RestUtils.getUserIdFromSession(request);
        String filename = this.buildXpdlFilename(fileName);
        byte[] bytes = this.internalXpdlService.generate(userId, filename, xpdl);
        HttpHeaders responseHeaders = this.buildHeaders(bytes, XPDL_CONTENT_TYPE, filename);
        return new ResponseEntity((Object)bytes, (MultiValueMap)responseHeaders, (HttpStatusCode)HttpStatus.OK);
    }

    @RequestMapping(value={"generateFromHistory"}, method={RequestMethod.POST})
    public ResponseEntity<byte[]> generateFromHistory(@RequestParam String packageId, @RequestParam String packageVersion, @RequestParam String fileName) throws UnsupportedEncodingException {
        String filename = this.buildZipFilename(fileName);
        byte[] bytes = this.internalXpdlService.generateFromHistory(fileName, packageId, packageVersion);
        HttpHeaders responseHeaders = this.buildHeaders(bytes, ZIP_CONTENT_TYPE, filename);
        return new ResponseEntity((Object)bytes, (MultiValueMap)responseHeaders, (HttpStatusCode)HttpStatus.OK);
    }

    @RequestMapping(value={"generateZip"}, method={RequestMethod.POST})
    public ResponseEntity<byte[]> generateZip(HttpServletRequest request, ZipForm form) throws UnsupportedEncodingException {
        String userId = RestUtils.getUserIdFromSession(request);
        String filename = this.buildZipFilename(form.getFileName());
        byte[] bytes = this.internalXpdlService.generateZip(userId, form, filename);
        HttpHeaders responseHeaders = this.buildHeaders(bytes, ZIP_CONTENT_TYPE, filename);
        return new ResponseEntity((Object)bytes, (MultiValueMap)responseHeaders, (HttpStatusCode)HttpStatus.OK);
    }

    @RequestMapping(value={"export"}, method={RequestMethod.POST})
    @ResponseBody
    public PackageLoadDto export(HttpServletRequest request, PackageLoadForm form) {
        String userId = RestUtils.getUserIdFromSession(request);
        return this.internalXpdlService.export(userId, form);
    }

    @RequestMapping(value={"exportZip"}, method={RequestMethod.POST})
    public ResponseEntity<ExportZipDto> exportZip(ExportZipForm form) throws IOException {
        return this.buildHtmlResponse(this.internalXpdlService.exportZip(form.getFile().getInputStream(), form.getPackageInfo()));
    }

    @RequestMapping(value={"refresh"}, method={RequestMethod.POST})
    @ResponseBody
    public PackageLoadDto refresh(HttpServletRequest request, PackageLoadForm form) {
        String userId = RestUtils.getUserIdFromSession(request);
        return this.internalXpdlService.refresh(userId, form);
    }

    @RequestMapping(value={"openFromDisc"}, method={RequestMethod.POST})
    public ResponseEntity<XpdlOpenDto.Key> openFromDisc(HttpServletRequest request, OpenForm form) {
        String userId = RestUtils.getUserIdFromSession(request);
        XpdlOpenDto dto = this.internalXpdlService.openFromDisc(userId, form);
        UUID uuid = UUID.randomUUID();
        OPENED_XPDL_CACHE_CACHE.put((Object)uuid, (Object)dto);
        return this.buildHtmlResponse(new XpdlOpenDto.Key(uuid, true));
    }

    @RequestMapping(value={"openFromDisc"}, method={RequestMethod.GET})
    @ResponseBody
    public XpdlOpenDto openFromDisc(@RequestParam UUID id) {
        XpdlOpenDto xpdlOpenDto = Optional.ofNullable((XpdlOpenDto)OPENED_XPDL_CACHE_CACHE.getIfPresent((Object)id)).orElseThrow(() -> new IllegalStateException("There is no opened xpdl with id " + String.valueOf(id)));
        OPENED_XPDL_CACHE_CACHE.invalidate((Object)id);
        return xpdlOpenDto;
    }

    @RequestMapping(value={"openFromSystem"}, method={RequestMethod.POST})
    public ResponseEntity<XpdlOpenDto.Key> openFromSystem(HttpServletRequest request, OpenForm form) {
        String userId = RestUtils.getUserIdFromSession(request);
        XpdlOpenDto dto = this.internalXpdlService.openFromSystem(userId, form);
        UUID uuid = UUID.randomUUID();
        OPENED_XPDL_CACHE_CACHE.put((Object)uuid, (Object)dto);
        return this.buildHtmlResponse(new XpdlOpenDto.Key(uuid, true));
    }

    @RequestMapping(value={"openFromSystem"}, method={RequestMethod.GET})
    @ResponseBody
    public XpdlOpenDto openFromSystem(@RequestParam UUID id) {
        XpdlOpenDto xpdlOpenDto = Optional.ofNullable((XpdlOpenDto)OPENED_XPDL_CACHE_CACHE.getIfPresent((Object)id)).orElseThrow(() -> new IllegalStateException("There is no opened xpdl with id " + String.valueOf(id)));
        OPENED_XPDL_CACHE_CACHE.invalidate((Object)id);
        return xpdlOpenDto;
    }

    @RequestMapping(value={"openFromSaved"}, method={RequestMethod.POST})
    public ResponseEntity<XpdlOpenDto.Key> openFromSaved(HttpServletRequest request, OpenForm form) {
        String userId = RestUtils.getUserIdFromSession(request);
        XpdlOpenDto dto = this.internalXpdlService.openFromSaved(userId, form);
        UUID uuid = UUID.randomUUID();
        OPENED_XPDL_CACHE_CACHE.put((Object)uuid, (Object)dto);
        return this.buildHtmlResponse(new XpdlOpenDto.Key(uuid, true));
    }

    @RequestMapping(value={"openFromSaved"}, method={RequestMethod.GET})
    @ResponseBody
    public XpdlOpenDto openFromSaved(@RequestParam UUID id) {
        XpdlOpenDto xpdlOpenDto = Optional.ofNullable((XpdlOpenDto)OPENED_XPDL_CACHE_CACHE.getIfPresent((Object)id)).orElseThrow(() -> new IllegalStateException("There is no opened xpdl with id " + String.valueOf(id)));
        OPENED_XPDL_CACHE_CACHE.invalidate((Object)id);
        return xpdlOpenDto;
    }

    @RequestMapping(value={"openFromAutoSaved"}, method={RequestMethod.POST})
    public ResponseEntity<XpdlOpenDto> openFromAutoSaved(HttpServletRequest request, OpenForm form) {
        String userId = RestUtils.getUserIdFromSession(request);
        XpdlOpenDto dto = this.internalXpdlService.openFromAutoSaved(userId, form);
        return this.buildHtmlResponse(dto);
    }

    @RequestMapping(value={"openRecentFile"}, method={RequestMethod.POST})
    public ResponseEntity<XpdlOpenDto> openRecentFile(HttpServletRequest request, OpenForm form) {
        String userId = RestUtils.getUserIdFromSession(request);
        XpdlOpenDto dto = this.internalXpdlService.openRecentFile(userId, form);
        return this.buildHtmlResponse(dto);
    }

    @RequestMapping(value={"openExample"}, method={RequestMethod.POST})
    public ResponseEntity<XpdlOpenDto> openExample(HttpServletRequest request, OpenForm form) {
        String userId = RestUtils.getUserIdFromSession(request);
        XpdlOpenDto dto = this.internalXpdlService.openExample(userId, form);
        return this.buildHtmlResponse(dto);
    }

    @RequestMapping(value={"openPackageVersion"}, method={RequestMethod.POST})
    public ResponseEntity<XpdlOpenDto> openPackageVersion(HttpServletRequest request, OpenForm form) {
        String userId = RestUtils.getUserIdFromSession(request);
        XpdlOpenDto dto = this.internalXpdlService.openPackageVersion(userId, form);
        return this.buildHtmlResponse(dto);
    }

    @RequestMapping(value={"openProcess"}, method={RequestMethod.POST})
    public ResponseEntity<XpdlOpenDto> openProcess(OpenForm form) {
        XpdlOpenDto dto = this.internalXpdlService.openProcess(form);
        return this.buildHtmlResponse(dto);
    }

    @RequestMapping(value={"saveErrors"}, method={RequestMethod.POST})
    public ResponseEntity<byte[]> saveErrors(SaveXpdlErrorsForm form) throws UnsupportedEncodingException {
        byte[] bytes = this.internalXpdlService.generateErrorsTextFileContent(form);
        String filename = this.buildTextFilename(form);
        HttpHeaders responseHeaders = this.buildHeaders(bytes, XPDL_ERRORS_CONTENT_TYPE, filename);
        return new ResponseEntity((Object)bytes, (MultiValueMap)responseHeaders, (HttpStatusCode)HttpStatus.OK);
    }

    @RequestMapping(value={"validateVariableType"}, method={RequestMethod.GET})
    @ResponseBody
    public VariableTypeValidationDto validateVariableType(ValidateVariableTypeForm form) {
        return this.internalXpdlService.validateVariableType(form);
    }

    @RequestMapping(value={"validateVariableId"}, method={RequestMethod.GET})
    @ResponseBody
    public VariableIdValidationDto validateVariableId(@RequestParam String variableId, @RequestParam String previousVariableId) {
        return this.internalXpdlService.validateVariableId(variableId, previousVariableId);
    }

    @RequestMapping(value={"resetAutoSaved"}, method={RequestMethod.GET})
    @ResponseBody
    public Boolean resetAutoSaved(HttpServletRequest request, @RequestParam String moduleStartTime) {
        String userId = RestUtils.getUserIdFromSession(request);
        return this.internalXpdlService.resetAutoSaved(userId, moduleStartTime);
    }

    @RequestMapping(value={"deleteAutoSaved"}, method={RequestMethod.GET})
    @ResponseBody
    public Boolean deleteAutoSaved(@RequestParam String path) {
        return this.internalXpdlService.deleteAutoSaved(path);
    }

    @RequestMapping(value={"deleteAllAutoSaved"}, method={RequestMethod.GET})
    @ResponseBody
    public Boolean deleteAllAutoSaved(HttpServletRequest request) {
        String userId = RestUtils.getUserIdFromSession(request);
        return this.internalXpdlService.deleteAllAutoSaved(userId);
    }

    @RequestMapping(value={"exportTranslations"}, method={RequestMethod.POST})
    public ResponseEntity<byte[]> exportTranslations(HttpServletRequest request, ExportTranslationsForm form) throws UnsupportedEncodingException {
        String userId = RestUtils.getUserIdFromSession(request);
        byte[] bytes = this.internalXpdlService.exportTranslationsToExcel(userId, form);
        String filename = this.buildTranslationsFilename(form.getFileName());
        HttpHeaders responseHeaders = this.buildHeaders(bytes, XLSX_CONTENT_TYPE, filename);
        return new ResponseEntity((Object)bytes, (MultiValueMap)responseHeaders, (HttpStatusCode)HttpStatus.OK);
    }

    @RequestMapping(value={"importTranslations"}, method={RequestMethod.POST})
    public ResponseEntity<PackageTranslationImportDto> importTranslations(HttpServletRequest request, ImportTranslationsForm form) {
        String userId = RestUtils.getUserIdFromSession(request);
        PackageTranslationImportDto dto = this.internalXpdlService.importTranslationsFromExcel(userId, form);
        return this.buildHtmlResponse(dto);
    }

    @RequestMapping(value={"loadTranslationsToSystem"}, method={RequestMethod.POST})
    public ResponseEntity<Void> loadToSystem(HttpServletRequest request, @RequestParam String xpdlTranslations) {
        String userId = RestUtils.getUserIdFromSession(request);
        this.internalXpdlService.loadTranslationsToSystem(userId, xpdlTranslations);
        return new ResponseEntity((HttpStatusCode)HttpStatus.OK);
    }

    private String buildXpdlFilename(String fileName) {
        StringBuilder filename = new StringBuilder();
        filename.append(fileName);
        filename.append(".xpdl");
        return filename.toString();
    }

    private String buildZipFilename(String fileName) {
        Optional<String> systemTypeOpt = this.getSystemType();
        StringBuilder filename = new StringBuilder();
        filename.append(fileName);
        filename.append(" ");
        filename.append(PweUtils.buildFormattedDate(System.currentTimeMillis(), "yyyy-MM-dd HH:mm:ss"));
        systemTypeOpt.ifPresent(systemType -> {
            filename.append(" ");
            filename.append((String)systemType);
        });
        filename.append(".zip");
        return filename.toString();
    }

    private String buildTextFilename(SaveXpdlErrorsForm form) {
        StringBuilder filename = new StringBuilder();
        filename.append(form.getPackageId());
        filename.append(".txt");
        return filename.toString();
    }

    private String buildTranslationsFilename(String fileName) {
        Optional<String> systemTypeOpt = this.getSystemType();
        StringBuilder filename = new StringBuilder();
        filename.append("[i18n] ");
        filename.append(fileName);
        filename.append(" ");
        filename.append(PweUtils.buildFormattedDate(System.currentTimeMillis(), "yyyy-MM-dd HH:mm:ss"));
        systemTypeOpt.ifPresent(systemType -> {
            filename.append(" ");
            filename.append((String)systemType);
        });
        filename.append(".xlsx");
        return filename.toString();
    }

    private Optional<String> getSystemType() {
        return Optional.ofNullable(SystemProperties.getString((String)"SystemType"));
    }

    private HttpHeaders buildHeaders(String contentType) {
        HttpHeaders responseHeaders = new HttpHeaders();
        responseHeaders.setContentType(MediaType.parseMediaType((String)contentType));
        return responseHeaders;
    }

    private HttpHeaders buildHeaders(byte[] bytes, String contentType, String filename) throws UnsupportedEncodingException {
        HttpHeaders responseHeaders = new HttpHeaders();
        responseHeaders.setContentType(MediaType.parseMediaType((String)contentType));
        responseHeaders.setContentLength((long)ArrayUtils.getLength((Object)bytes));
        responseHeaders.setContentDispositionFormData("attachment", XpdlController.encodeFileName(filename));
        return responseHeaders;
    }

    private static String encodeFileName(String filename) throws UnsupportedEncodingException {
        return URLEncoder.encode(filename, "UTF-8").replace("+", "%20");
    }

    private <T> ResponseEntity<T> buildHtmlResponse(T dto) {
        HttpHeaders responseHeaders = this.buildHeaders(HTML_CONTENT_TYPE);
        return new ResponseEntity(dto, (MultiValueMap)responseHeaders, (HttpStatusCode)HttpStatus.OK);
    }
}

