/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.service.processmapimage;

import com.suncode.plugin.pwe.documentation.util.ImageUtils;
import com.suncode.plugin.pwe.util.AuditType;
import com.suncode.pwfl.audit.builder.ManualAuditBuilder;
import java.util.Date;
import java.util.LinkedHashMap;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class ProcessMapImageService {
    public static Logger log = Logger.getLogger(ProcessMapImageService.class);

    public byte[] generate(String userId, String fileName, String processMapImage) {
        Date started = new Date();
        try {
            byte[] bytes = ImageUtils.getBase64EncodedBytes(processMapImage);
            this.logGenerateProcessMapImageAudit(userId, started, true, fileName);
            return bytes;
        }
        catch (Exception exception) {
            log.error((Object)exception.getMessage(), (Throwable)exception);
            this.logGenerateProcessMapImageAudit(userId, started, false, fileName);
            return new byte[0];
        }
    }

    private void logGenerateProcessMapImageAudit(String userId, Date started, boolean success, String fileName) {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("pwe.audit.generate.processmapimage.param.filename", fileName);
        ManualAuditBuilder.getInstance().type(AuditType.AUDIT_GENERATE_PROCESS_MAP_IMAGE.getValue()).username(userId).success(success).params(params).started(started).stopped(new Date()).build().log();
    }
}

