/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.documentation.specification.supplier;

import com.suncode.plugin.pwe.documentation.enumeration.ActivityExtendedAttributeName;
import com.suncode.plugin.pwe.documentation.object.AcceptButton;
import com.suncode.plugin.pwe.documentation.object.AddFileButton;
import com.suncode.plugin.pwe.documentation.object.BarcodePrintButton;
import com.suncode.plugin.pwe.documentation.object.DtButton;
import com.suncode.plugin.pwe.documentation.object.FormButton;
import com.suncode.plugin.pwe.documentation.object.GeneratePdfButton;
import com.suncode.plugin.pwe.documentation.object.builder.AcceptButtonBuilder;
import com.suncode.plugin.pwe.documentation.object.builder.AddFileButtonBuilder;
import com.suncode.plugin.pwe.documentation.object.builder.BarcodePrintButtonBuilder;
import com.suncode.plugin.pwe.documentation.object.builder.DtButtonBuilder;
import com.suncode.plugin.pwe.documentation.object.builder.FormButtonBuilder;
import com.suncode.plugin.pwe.documentation.object.builder.GeneratePdfButtonBuilder;
import com.suncode.plugin.pwe.documentation.specification.ActivitySpecification;
import com.suncode.plugin.pwe.documentation.specification.ButtonSpecification;
import com.suncode.plugin.pwe.documentation.specification.DtButtonSpecification;
import com.suncode.plugin.pwe.documentation.specification.ProcessSpecification;
import com.suncode.plugin.pwe.documentation.specification.supplier.SpecificationSupplier;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.commons.lang3.BooleanUtils;
import org.enhydra.shark.xpdl.elements.Activities;
import org.enhydra.shark.xpdl.elements.Activity;
import org.enhydra.shark.xpdl.elements.ExtendedAttribute;
import org.enhydra.shark.xpdl.elements.ExtendedAttributes;
import org.enhydra.shark.xpdl.elements.Package;
import org.enhydra.shark.xpdl.elements.WorkflowProcess;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="dtButtonSpecificationSupplier")
public class DtButtonSpecificationSupplierImpl
implements SpecificationSupplier {
    @Autowired
    private DtButtonBuilder dtButtonBuilder;
    @Autowired
    private FormButtonBuilder formButtonBuilder;
    @Autowired
    private AcceptButtonBuilder acceptButtonBuilder;
    @Autowired
    private GeneratePdfButtonBuilder generatePdfButtonBuilder;
    @Autowired
    private AddFileButtonBuilder addFileButtonBuilder;
    @Autowired
    private BarcodePrintButtonBuilder barcodePrintButtonBuilder;

    @Override
    public boolean shouldSupply(List<ProcessSpecification> processSpecifications) {
        return processSpecifications.stream().anyMatch(processSpecification -> BooleanUtils.isNotTrue((Boolean)processSpecification.getDtButtonsSupplied()));
    }

    @Override
    public void supply(Package pack, List<ProcessSpecification> processSpecifications) {
        processSpecifications.stream().forEach(this.supply(pack));
    }

    private Consumer<ProcessSpecification> supply(Package pack) {
        return processSpecification -> this.supply(pack, (ProcessSpecification)processSpecification);
    }

    private void supply(Package pack, ProcessSpecification processSpecification) {
        if (BooleanUtils.isNotTrue((Boolean)processSpecification.getDtButtonsSupplied())) {
            WorkflowProcess process = pack.getWorkflowProcess(processSpecification.getId());
            Optional<WorkflowProcess> optional = Optional.ofNullable(process);
            optional.ifPresent(this.supply(processSpecification));
            processSpecification.setDtButtonsSupplied(true);
        }
    }

    private Consumer<WorkflowProcess> supply(ProcessSpecification processSpecification) {
        return process -> this.supply((WorkflowProcess)process, processSpecification);
    }

    private void supply(WorkflowProcess process, ProcessSpecification processSpecification) {
        Activities activities = process.getActivities();
        if (!activities.isEmpty()) {
            for (int i = 0; i < activities.size(); ++i) {
                Activity activity = (Activity)activities.get(i);
                this.supply(activity, processSpecification);
            }
        }
    }

    private void supply(Activity activity, ProcessSpecification processSpecification) {
        String activityDefId = activity.getId();
        if (processSpecification.getActivitySpecifications().containsKey(activityDefId)) {
            ActivitySpecification activitySpecification = processSpecification.getActivitySpecifications().get(activityDefId);
            ArrayList<DtButton> dtButtons = new ArrayList<DtButton>();
            HashSet<String> buttonIds = new HashSet<String>();
            ExtendedAttributes extAttrs = activity.getExtendedAttributes();
            if (!extAttrs.isEmpty()) {
                block8: for (int i = 0; i < extAttrs.size(); ++i) {
                    ExtendedAttribute extAttr = (ExtendedAttribute)extAttrs.get(i);
                    String extAttrName = extAttr.getName();
                    String extAttrValue = extAttr.getVValue();
                    switch (ActivityExtendedAttributeName.getByName(extAttrName)) {
                        case DT_BUTTON: {
                            dtButtons.add(this.buildDtButton(extAttrValue));
                            continue block8;
                        }
                        case HTTP_LINK: 
                        case ACTIONBUTTON: {
                            FormButton formButton = this.buildFormButton(extAttrValue);
                            buttonIds.add(formButton.getActionName());
                            continue block8;
                        }
                        case ACTION_ACCEPT_BUTTON: {
                            AcceptButton acceptButton = this.buildAcceptButton(extAttrValue);
                            buttonIds.add(acceptButton.getActionName());
                            continue block8;
                        }
                        case GENERATE_PDF_BUTTON: {
                            GeneratePdfButton generatePdfButton = this.buildGeneratePdfButton(extAttrValue);
                            buttonIds.add(generatePdfButton.getActionName());
                            continue block8;
                        }
                        case ADD_FILE_BUTTON: {
                            AddFileButton addFileButton = this.buildAddFileButton(extAttrValue);
                            buttonIds.add(addFileButton.getActionName());
                            continue block8;
                        }
                        case BARCODE_PRINT: {
                            BarcodePrintButton barcodePrintButton = this.buildBarcodePrintButton(extAttrValue);
                            buttonIds.add(barcodePrintButton.getActionName());
                            continue block8;
                        }
                    }
                }
                dtButtons.stream().forEach(dtButton -> this.supply((DtButton)dtButton, (Set<String>)buttonIds, activitySpecification));
            }
        }
    }

    private void supply(DtButton button, Set<String> buttonIds, ActivitySpecification activitySpecification) {
        String dtButtonId = button.getId();
        if (activitySpecification.getButtonSpecifications().containsKey(dtButtonId)) {
            ButtonSpecification buttonSpecification = this.getButtonSpecification(dtButtonId, buttonIds, activitySpecification);
            DtButtonSpecification dtButtonSpecification = new DtButtonSpecification();
            dtButtonSpecification.setDescription(buttonSpecification.getDescription());
            activitySpecification.getDtButtonSpecifications().put(dtButtonId, dtButtonSpecification);
        }
    }

    private ButtonSpecification getButtonSpecification(String dtButtonId, Set<String> buttonIds, ActivitySpecification activitySpecification) {
        if (buttonIds.contains(dtButtonId)) {
            return activitySpecification.getButtonSpecifications().get(dtButtonId);
        }
        return activitySpecification.getButtonSpecifications().remove(dtButtonId);
    }

    private DtButton buildDtButton(String extAttrValue) {
        return this.dtButtonBuilder.build(extAttrValue);
    }

    private FormButton buildFormButton(String extAttrValue) {
        return this.formButtonBuilder.build(extAttrValue);
    }

    private AcceptButton buildAcceptButton(String extAttrValue) {
        return this.acceptButtonBuilder.build(extAttrValue);
    }

    private GeneratePdfButton buildGeneratePdfButton(String extAttrValue) {
        return this.generatePdfButtonBuilder.build(extAttrValue);
    }

    private AddFileButton buildAddFileButton(String extAttrValue) {
        return this.addFileButtonBuilder.build(extAttrValue);
    }

    private BarcodePrintButton buildBarcodePrintButton(String extAttrValue) {
        return this.barcodePrintButtonBuilder.build(extAttrValue);
    }
}

