/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.documentation.comparator.subcomparator;

import com.suncode.plugin.pwe.documentation.comparator.subcomparator.ParameterSpecificationsSubcomparator;
import com.suncode.plugin.pwe.documentation.comparator.subcomparator.ProcessSpecificationSubcomparator;
import com.suncode.plugin.pwe.documentation.object.Difference;
import com.suncode.plugin.pwe.documentation.object.builder.DifferenceBuilder;
import com.suncode.plugin.pwe.documentation.specification.ParameterSpecification;
import com.suncode.plugin.pwe.documentation.specification.ProgrammingTaskSpecification;
import com.suncode.plugin.pwe.service.translator.TranslatorService;
import com.suncode.plugin.pwe.util.translation.TranslationInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.enhydra.shark.xpdl.elements.WorkflowProcess;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="programmingTaskSpecificationsSubcomparator")
public class ProgrammingTaskSpecificationsSubcomparatorImpl
implements ProcessSpecificationSubcomparator<List<ProgrammingTaskSpecification>> {
    private static final String TYPE_MODIFIED = "pwe.documentation.changecard.modified.programmingtasktype";
    private static final String EXECUTION_LOCATION_MODIFIED = "pwe.documentation.changecard.modified.programmingtaskexecutionlocation";
    private static final String DESCRIPTION_MODIFIED = "pwe.documentation.changecard.modified.programmingtaskdescription";
    private static final String ALGORITHM_DESCRIPTION_MODIFIED = "pwe.documentation.changecard.modified.programmingtaskalgorithmdescription";
    private static final String INPUT_PARAMETER_DESCRIPTION_MODIFIED = "pwe.documentation.changecard.modified.programmingtaskinputparameterdescription";
    private static final String INPUT_PARAMETER_ADDED = "pwe.documentation.changecard.added.programmingtaskinputparameter";
    private static final String INPUT_PARAMETER_DELETED = "pwe.documentation.changecard.deleted.programmingtaskinputparameter";
    private static final String OUTPUT_PARAMETER_DESCRIPTION_MODIFIED = "pwe.documentation.changecard.modified.programmingtaskoutputparameterdescription";
    private static final String OUTPUT_PARAMETER_ADDED = "pwe.documentation.changecard.added.programmingtaskoutputparameter";
    private static final String OUTPUT_PARAMETER_DELETED = "pwe.documentation.changecard.deleted.programmingtaskoutputparameter";
    private static final String PROGRAMMING_TASK_ADDED = "pwe.documentation.changecard.added.programmingtask";
    private static final String PROGRAMMING_TASK_DELETED = "pwe.documentation.changecard.deleted.programmingtask";
    @Autowired
    private DifferenceBuilder differenceBuilder;
    @Autowired
    private TranslatorService translatorService;
    @Autowired
    private ParameterSpecificationsSubcomparator parameterSpecificationsSubcomparator;

    @Override
    public List<Difference> compare(WorkflowProcess baseProcess, List<ProgrammingTaskSpecification> base, WorkflowProcess comparedProcess, List<ProgrammingTaskSpecification> compared, TranslationInfo translationInfo) {
        ArrayList<Difference> differences = new ArrayList<Difference>();
        Map<String, ProgrammingTaskSpecification> baseMap = this.convertToMap(base);
        if (CollectionUtils.isNotEmpty(compared)) {
            for (ProgrammingTaskSpecification comparedSpecification : compared) {
                if (baseMap.containsKey(comparedSpecification.getName())) {
                    ProgrammingTaskSpecification baseSpecification = baseMap.remove(comparedSpecification.getName());
                    differences.addAll(this.compare(comparedSpecification.getName(), baseSpecification, comparedSpecification));
                    continue;
                }
                differences.add(this.differenceBuilder.build(PROGRAMMING_TASK_ADDED, comparedSpecification.getName()));
            }
        }
        if (MapUtils.isNotEmpty(baseMap)) {
            for (ProgrammingTaskSpecification baseSpecification : baseMap.values()) {
                differences.add(this.differenceBuilder.build(PROGRAMMING_TASK_DELETED, baseSpecification.getName()));
            }
        }
        return differences;
    }

    private Map<String, ProgrammingTaskSpecification> convertToMap(List<ProgrammingTaskSpecification> list) {
        HashMap<String, ProgrammingTaskSpecification> map = new HashMap<String, ProgrammingTaskSpecification>();
        if (CollectionUtils.isNotEmpty(list)) {
            for (ProgrammingTaskSpecification element : list) {
                map.put(element.getName(), element);
            }
        }
        return map;
    }

    private List<Difference> compare(String name, ProgrammingTaskSpecification base, ProgrammingTaskSpecification compared) {
        ArrayList<Difference> differences = new ArrayList<Difference>();
        if (!StringUtils.equalsIgnoreCase((CharSequence)base.getType(), (CharSequence)compared.getType())) {
            String translatedBaseType = this.buildTranstaledType(base);
            String translatedComparedType = this.buildTranstaledType(compared);
            differences.add(this.differenceBuilder.build(TYPE_MODIFIED, name, translatedBaseType, translatedComparedType));
        }
        if (!StringUtils.equalsIgnoreCase((CharSequence)base.getExecutionLocation(), (CharSequence)compared.getExecutionLocation())) {
            differences.add(this.differenceBuilder.build(EXECUTION_LOCATION_MODIFIED, name, base.getExecutionLocation(), compared.getExecutionLocation()));
        }
        if (!StringUtils.equalsIgnoreCase((CharSequence)base.getDescription(), (CharSequence)compared.getDescription())) {
            differences.add(this.differenceBuilder.build(DESCRIPTION_MODIFIED, name, base.getDescription(), compared.getDescription()));
        }
        if (!StringUtils.equalsIgnoreCase((CharSequence)base.getAlgorithmDescription(), (CharSequence)compared.getAlgorithmDescription())) {
            differences.add(this.differenceBuilder.build(ALGORITHM_DESCRIPTION_MODIFIED, name, base.getAlgorithmDescription(), compared.getAlgorithmDescription()));
        }
        differences.addAll(this.compareParameters(name, INPUT_PARAMETER_DESCRIPTION_MODIFIED, INPUT_PARAMETER_ADDED, INPUT_PARAMETER_DELETED, base.getInputParameters(), compared.getInputParameters()));
        differences.addAll(this.compareParameters(name, OUTPUT_PARAMETER_DESCRIPTION_MODIFIED, OUTPUT_PARAMETER_ADDED, OUTPUT_PARAMETER_DELETED, base.getOutputParameters(), compared.getOutputParameters()));
        return differences;
    }

    private String buildTranstaledType(ProgrammingTaskSpecification specification) {
        return this.translatorService.translateDocumentationMessageForText(specification.getType());
    }

    private List<Difference> compareParameters(String containerName, String descriptionModifiedKey, String addedKey, String deletedKey, List<ParameterSpecification> base, List<ParameterSpecification> compared) {
        return this.parameterSpecificationsSubcomparator.compare(containerName, descriptionModifiedKey, addedKey, deletedKey, base, compared);
    }
}

