/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.documentation.comparator.subcomparator;

import com.suncode.plugin.pwe.documentation.comparator.subcomparator.FormVariableSpecificationSubcomparator;
import com.suncode.plugin.pwe.documentation.object.Difference;
import com.suncode.plugin.pwe.documentation.object.builder.DifferenceBuilder;
import com.suncode.plugin.pwe.documentation.object.builder.SpecificationDescriptionPartBuilder;
import com.suncode.plugin.pwe.documentation.specification.AutoUpdateSpecification;
import com.suncode.plugin.pwe.documentation.specification.DescriptionSpecification;
import com.suncode.plugin.pwe.util.translation.TranslationInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.enhydra.shark.xpdl.elements.WorkflowProcess;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="autoUpdateSpecificationsSubcomparator")
public class AutoUpdateSpecificationsSubcomparatorImpl
implements FormVariableSpecificationSubcomparator<Map<String, AutoUpdateSpecification>> {
    private static final String DESCRIPTION_MODIFIED = "pwe.documentation.changecard.modified.autoupdatespecificationdescription";
    @Autowired
    private SpecificationDescriptionPartBuilder specificationDescriptionPartBuilder;
    @Autowired
    private DifferenceBuilder differenceBuilder;

    @Override
    public List<Difference> compare(String activityDefId, String formVariableId, WorkflowProcess baseProcess, Map<String, AutoUpdateSpecification> base, WorkflowProcess comparedProcess, Map<String, AutoUpdateSpecification> compared, TranslationInfo translationInfo) {
        ArrayList<Difference> differences = new ArrayList<Difference>();
        if (MapUtils.isNotEmpty(compared)) {
            for (String id : compared.keySet()) {
                if (!base.containsKey(id)) continue;
                AutoUpdateSpecification baseSpecification = base.get(id);
                AutoUpdateSpecification comparedSpecification = compared.get(id);
                if (StringUtils.equalsIgnoreCase((CharSequence)baseSpecification.getDescription(), (CharSequence)comparedSpecification.getDescription())) continue;
                String baseDescription = this.buildDescription(baseProcess, translationInfo, baseSpecification);
                String comparedDescription = this.buildDescription(comparedProcess, translationInfo, comparedSpecification);
                differences.add(this.differenceBuilder.build(DESCRIPTION_MODIFIED, formVariableId, activityDefId, baseDescription, comparedDescription));
            }
        }
        return differences;
    }

    private String buildDescription(WorkflowProcess process, TranslationInfo translationInfo, DescriptionSpecification descriptionSpecification) {
        return this.specificationDescriptionPartBuilder.buildAsString(process, translationInfo, descriptionSpecification.getDescription());
    }
}

