/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.documentation.chapter.point.builder;

import com.suncode.plugin.pwe.documentation.Documentation;
import com.suncode.plugin.pwe.documentation.NumberedPoint;
import com.suncode.plugin.pwe.documentation.NumberedPoints;
import com.suncode.plugin.pwe.documentation.ParagraphContents;
import com.suncode.plugin.pwe.documentation.chapter.point.builder.ActivityPointBuilder;
import com.suncode.plugin.pwe.documentation.object.ActivityForm;
import com.suncode.plugin.pwe.documentation.specification.ActivitySpecification;
import com.suncode.plugin.pwe.documentation.specification.GeneratedDocumentSpecification;
import com.suncode.plugin.pwe.documentation.subchapter.builder.SubchapterBuilder;
import com.suncode.plugin.pwe.documentation.util.ParagraphContentsUtils;
import com.suncode.plugin.pwe.service.translator.TranslatorService;
import com.suncode.plugin.pwe.util.translation.TranslationInfo;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.enhydra.shark.xpdl.elements.Activity;
import org.enhydra.shark.xpdl.elements.WorkflowProcess;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="activityGeneratedDocumentsPointBuilder")
public class ActivityGeneratedDocumentsPointBuilderImpl
implements ActivityPointBuilder {
    private static final String POINT_TITLE = "pwe.documentation.point.title.generateddocuments";
    @Autowired
    private TranslatorService translatorService;
    @Autowired
    private SubchapterBuilder subchapterBuilder;

    @Override
    public void build(Documentation documentation, WorkflowProcess process, TranslationInfo translationInfo, Activity activity, ActivitySpecification activitySpecification, ActivityForm activityForm) {
        NumberedPoints points = this.buildNumberedPoints(activitySpecification);
        this.buildPoint(documentation, points);
    }

    private NumberedPoints buildNumberedPoints(ActivitySpecification activitySpecification) {
        NumberedPoints points = new NumberedPoints();
        points.addPoint(this.buildNumberedPoint(this.buildGeneratedDocuments(activitySpecification.getGeneratedDocuments())));
        return points;
    }

    private List<String> buildGeneratedDocuments(List<GeneratedDocumentSpecification> generatedDocumentSpecifications) {
        ArrayList<String> generatedDocuments = new ArrayList<String>();
        if (CollectionUtils.isNotEmpty(generatedDocumentSpecifications)) {
            for (GeneratedDocumentSpecification generatedDocumentSpecification : generatedDocumentSpecifications) {
                generatedDocuments.add(generatedDocumentSpecification.getName());
            }
        }
        return generatedDocuments;
    }

    private NumberedPoint buildNumberedPoint(List<String> list) {
        NumberedPoint point = new NumberedPoint();
        point.setTitle(this.translatorService.translateMessage(POINT_TITLE));
        point.setSubPoints(this.buildSubPoints(list));
        return point;
    }

    private List<ParagraphContents> buildSubPoints(List<String> list) {
        return ParagraphContentsUtils.build(list);
    }

    private void buildPoint(Documentation documentation, NumberedPoints points) {
        this.subchapterBuilder.build(documentation, points);
    }
}

