var processDataFields = null;
var processTablesColumns = null;
var processApplications = null;
var conditionTypes = null;
var deadlineInfos = null;
var transitionsOrder = null;
var participantsTypes = null;
var packageParticipants = null;
var packageApplications = null;

function readXpdl( xpdl, acceptedProcessDefId ) {
  processDataFields = new HashMap();
  processTablesColumns = new HashMap();
  processApplications = new HashMap();
  conditionTypes = new HashMap();
  deadlineInfos = new HashMap();
  transitionsOrder = new HashMap();
  participantsTypes = new HashMap();
  mainPanel = Ext.getCmp( 'main_panel' );
  mainPanel.resetTransitionIds();
  mainPanel.resetGlobalIds();
  Ext.ux.suncode.XpdlErrors.reset();
  readXpdlPackage( xpdl.Package, acceptedProcessDefId );
}

function readXpdlPackage( Package, acceptedProcessDefId ) {
    var packageNode = Ext.getCmp( 'package_panel' ).getRootNode();
    participantsTypes.clear();
    packageParticipants = new Array();

    for ( var i = 0; i < Package.length; i++ ) {
        var prop = Package[i];

        for ( var o in prop ) {
            try {
                window['readXpdlPackage' + o]( packageNode, prop[o], acceptedProcessDefId );
            }
            catch ( e ) {
                logError( e );
            }
        }
    }

    processDataFields.clear();
    processTablesColumns.clear();
    processApplications.clear();
    conditionTypes.clear();
    deadlineInfos.clear();
    transitionsOrder.clear();
    participantsTypes.clear();
    clearArray( packageParticipants );
    clearArray( packageApplications );
}

function readXpdlPackageId( packageNode, packageId ) {
    packageNode.attributes.packageId = packageId;
    packageNode.attributes.idChanged = true;

    if ( packageId.length > Ext.ux.suncode.Constants.PACKAGE_ID_MAX_LENGTH ) {
        var errorDescr = getTranslation( 'Zbyt długi identyfikator pakietu' );
        errorDescr += ', ';
        errorDescr += getTranslation( 'maksymalna długość' );
        errorDescr += ': ';
        errorDescr += Ext.ux.suncode.Constants.PACKAGE_ID_MAX_LENGTH;
        errorDescr += ' ';
        errorDescr += getTranslation( 'znaków' );

        Ext.ux.suncode.XpdlErrors.addError( {
            object: getTranslation( 'Pakiet' ),
            processDefId: 'n/a',
            activityDefId: 'n/a',
            descr: errorDescr,
            correction: 'n/a'
        } );
    }
}

function readXpdlPackageName( packageNode, packageName ) {
    var packageId = packageNode.attributes.packageId;
    packageName = decodeTextFromXpdl( packageName );
    var packageNameTranslation = getXpdlPackageNameTranslation( packageId, packageName );
    packageNode.setText( packageNameTranslation );
    packageNode.attributes.packageName = packageName;
}

function readXpdlPackagePackageHeader( packageNode, packageHeader ) {
    for ( var i = 0; i < packageHeader.length; i++ ) {
        var info = packageHeader[i];

        if ( info.Created ) {
            packageNode.attributes.packageCreationTime = info.Created[0].XPDLNODEVALUE;
        } else if ( info.Description ) {
            packageNode.attributes.packageDescr = decodeTextFromXpdl( info.Description[0].XPDLNODEVALUE );
        }
    }
}

function readXpdlPackageRedefinableHeader( packageNode, redefinableHeader ) {
    for ( var i = 0; i < redefinableHeader.length; i++ ) {
        var info = redefinableHeader[i];

        if ( info.Author ) {
            packageNode.attributes.packageAuthor = decodeTextFromXpdl( info.Author[0].XPDLNODEVALUE );
        }
    }
}

function readXpdlPackageScript( packageNode, scrpt ) {
    for ( var i = 0; i < scrpt.length; i++ ) {
        var info = scrpt[i];

        if ( info.Grammar ) {
            packageNode.attributes.scriptGrammar = info.Grammar;
        } else if ( info.Type ) {
            packageNode.attributes.scriptType = info.Type;
        } else if ( info.Version ) {
            packageNode.attributes.scriptVersion = info.Version;
        }
    }
}

function readXpdlPackageParticipants( packageNode, participants ) {
    var config = readXpdlProcessParticipants( {}, participants, true );
    packageParticipants = config.participants.splice( 0, config.participants.length );

    for ( var i = 0; i < packageParticipants.length; i++ ) {
        var roleDef = new Object();
        roleDef = Ext.apply( packageParticipants[i], roleDef );
        participantsTypes.put( roleDef.roleId, roleDef.roleType );
        packageNode.addParticipant( roleDef );
    }
}

function readXpdlPackageApplications( packageNode, applications ) {
    var config = readXpdlProcessApplications( {}, applications );
    packageApplications = config.applications.splice( 0, config.applications.length );

    packageNode.loadApplications( [].concat( packageApplications ) );
}

function readXpdlPackageWorkflowProcesses( packageNode, wps, acceptedProcessDefId ) {
    for ( var i = 0; i < wps.length; i++ ) {
        var wp = wps[i];
        var config = new Object();
        var workflowProcess = wp.WorkflowProcess;
        var breakAdding = false;

        if ( acceptedProcessDefId ) {
            breakAdding = true;

            for ( var j = 0; j < workflowProcess.length; j++ ) {
                var el = workflowProcess[j];

                if ( el.Id && el.Id == acceptedProcessDefId ) {
                    breakAdding = false;
                    break;
                }
            }
        }

        if ( breakAdding ) {
            continue;
        }

        var activitiesEl = null;
        var transitionsEl = null;

        for ( var j = 0; j < workflowProcess.length; j++ ) {
            var el = workflowProcess[j];

            for ( var o in el ) {
                if ( o == 'Activities' ) {
                    activitiesEl = el[o];
                } else if ( o == 'Transitions' ) {
                    transitionsEl = el[o];
                } else {
                    try {
                        config = window['readXpdlProcess' + o](config, el[o]);
                    } catch (e) {
                        logError(e);
                    }
              }
            }
        }

        if ( !Ext.isEmpty( activitiesEl ) ) {
            config = readXpdlProcessActivities( config, activitiesEl );
        }

        if ( !Ext.isEmpty( transitionsEl ) ) {
            config = readXpdlProcessTransitions( config, transitionsEl );
        }

        var newProcess = createNewProcess( config );
        newProcess.loadFormalParams( config.formalParameters );
        newProcess.loadVariables( assignVariablePlacementIfNecessary( config.dataFields, config.activities ) );
        newProcess.loadLabels( config.labels );
        newProcess.loadApplications( config.applications );
        newProcess.loadValidatorsTemplates( config.validatorsTemplates );
        newProcess.loadVariablesSettersTemplates( config.variablesSettersTemplates );
        newProcess.loadTables( config.tables );
        var processPanel = Ext.getCmp( 'paper_panel' ).getActiveTab();
        var paper = processPanel.paper;
        var snapToGrid = paper.snapToGrid;
        paper = Ext.apply( paper, {
        	snapToGrid: false
		    } );
        var taskWidth = paper.bpmn.activityWidth;
        var taskHeight = paper.bpmn.activityHeight;
        var rolesXLocationRelations = config.rolesXLocationRelations ? config.rolesXLocationRelations : new Array();
        var rolesYLocationRelations = config.rolesYLocationRelations ? config.rolesYLocationRelations : new Array();
        var roleYOffsets = new Array();

        var ps = handleParticipants( config );
        for ( var j = 0; j < ps.length; j++ ) {
            var p = ps[j];
            var fields = null;
            var fieldName = '';
            var roleId = p.roleId;

            if ( p.roleType == 'SYSTEM' ) {
                fieldName = 'systemField';
                fields = processPanel.drawSystem( 1, 1, p.roleName, roleId, p.isGlobal );
            } else if ( p.roleType == 'RESOURCE' ) {
                fieldName = 'roleField';
                fields = processPanel.drawBufor( 1, 1, p.roleName, roleId, p.isGlobal );
            } else {
                fieldName = 'roleField';
                fields = processPanel.drawRole( 1, 1, p.roleName, roleId, p.isGlobal );
            }

            var rolebox = Raphael.pathBBox( fields[0].attr( 'path' ) );
            roleYOffsets[roleId] = rolebox.y;

            var cbox = {
                width: paper.bpmn.minRoleWidth,
                height: paper.bpmn.roleHeight
            };

            fields.forEach( function( roleEl ) {
                var roleElSetType = roleEl.data( 'setType' );

                if ( roleElSetType == 'roleField' || roleElSetType == 'systemField' ) {
                    cbox = Raphael.pathBBox( roleEl.attr( 'path' ) );
                    return false;
                }
            } );

            var newWidth = 0;
            var newHeight = 0;

            if ( p.roleWidth && p.roleHeight ) {
                if ( rolesXLocationRelations[roleId] && rolesXLocationRelations[roleId] + taskWidth + 10 <= p.roleWidth ) {
                    newWidth = p.roleWidth;
                } else {
                    newWidth = rolesXLocationRelations[roleId] ? rolesXLocationRelations[roleId] + taskWidth + 10 : p.roleWidth;
                }

                if ( rolesYLocationRelations[roleId] && rolesYLocationRelations[roleId] + taskHeight + 10 <= p.roleHeight ) {
                    newHeight = p.roleHeight;
                } else {
                    newHeight = rolesYLocationRelations[roleId] ? rolesYLocationRelations[roleId] + taskHeight + 10 : p.roleHeight;
                }
            } else {
                newWidth = rolesXLocationRelations[roleId] ? rolesXLocationRelations[roleId] + taskWidth + 10 : cbox.width;
                newHeight = rolesYLocationRelations[roleId] ? rolesYLocationRelations[roleId] + taskHeight + 10 : cbox.height;
            }

            if ( newHeight < paper.bpmn.roleHeight ) {
                newHeight = paper.bpmn.roleHeight;
            }

            paper.bpmn.setRoleSize( paper, fieldName, roleId, newWidth, newHeight );

            if ( !Ext.isEmpty( p.roleDescr ) ) {
                newProcess.setRoleDescription( roleId, p.roleDescr );
            }
        }

        newProcess.setAllRolesIdChanged();

        var packagePanel = Ext.getCmp( 'package_panel' );
        var processDefId = newProcess.attributes.processDefId;
        var activitiesSet = new Array();

        var as = config.activities ? config.activities : new Array();
        for ( var j = 0; j < as.length; j++ ) {
            var a = as[j];
            var activitySet = null;
            var activityDefId = a.activityDefId;

            if ( a.participantId == 'FreeTextExpressionParticipant' ) {
                if ( Ext.isEmpty( roleYOffsets[a.participantId] ) ) {
                    var roleFields = processPanel.drawBufor( 1, 1 );
                    var rolebox = Raphael.pathBBox( roleFields[0].attr( 'path' ) );
                    roleYOffsets[a.participantId] = rolebox.y;
                }

                Ext.ux.suncode.XpdlErrors.addError( {
                    object: getTranslation( 'Zadanie' ),
                    processDefId: config.initialProcessDefId,
                    activityDefId: activityDefId,
                    descr: getTranslation( 'Zadanie wykonywane przez uczestnika, który został usunięty' ),
                    correction: getTranslation( 'Przekazanie zadania do użytkownika "Bufor"' )
                } );
            }

            var x = a.x;
            var y = roleYOffsets[a.participantId] + a.y;
            var activityName = a.activityName ? a.activityName : activityDefId;

            if ( a.isRoute ) {
                activitySet = processPanel.drawRoute( x, y, activityName, activityDefId );
            } else if ( a.isTool ) {
                activitySet = processPanel.drawTool( x, y, activityName, activityDefId );
            } else if ( a.isSubflow ) {
                activitySet = processPanel.drawSubflow( x, y, activityName, activityDefId );
            } else {
                activitySet = processPanel.drawActivity( x, y, activityName, activityDefId );
            }

            activitiesSet[activityDefId] = activitySet;

            Ext.each( a.formVariables, function( formVariable, formVariableIndex, allFormVariables ) {
              if ( formVariable.genre == 'VARIABLE_SET' ) {
                for ( var k = 0; k < formVariable.columns.length; k++ ) {
                  var column = formVariable.columns[k];
                  var tableColumns = processTablesColumns.get( formVariable.varId );
                  var tableColumn = !Ext.isEmpty( tableColumns ) ? tableColumns.get( column.varId ) : null;

                  if ( !Ext.isEmpty( tableColumn ) ) {
                    if ( column.hidden != tableColumn.hidden ) {
                      Ext.apply( column, {
                        differentHidden: true
                      } );
                    }
                    if ( column.readonly != tableColumn.readonly ) {
                      Ext.apply( column, {
                        differentReadonly: true
                      } );
                    }
                  }
                }
              }
            } );

            var activityNode = packagePanel.findActivity( processDefId, activityDefId );
            activityNode.updateActivityDef( {
                activityDefId: activityDefId,
                activityName: activityName,
                activityDescr: a.descr,
                assignment: a.assignment,
                nextActivity: a.nextActivity,
                acceptedNextActivities: a.acceptedNextActivities,
                acceptConcurrently: a.acceptConcurrently,
                acceptSequentially: a.acceptSequentially,
                newDocumentAccept: a.newDocumentAccept,
                allowMultipleActiveActivities: a.allowMultipleActiveActivities
            } );
            activityNode.setTransitionRestriction( a.transitionRestriction );
            activityNode.loadFormVariables( a.formVariables );
            activityNode.loadFormButtons( a.formButtons );
            activityNode.loadHttpLinks( a.httpLinks );
            activityNode.loadApplications( a.applications );
            activityNode.loadDeadlines( a.deadlines );
            activityNode.loadAcceptances( a.acceptances );
            activityNode.updateSubflowInfo( a.subflow );
            activityNode.loadAdditionals( a.additionals );
            activityNode.loadLabelActions( a.labelActions );
            activityNode.loadFormFormActions( a.formFormActions );
            activityNode.loadFormEventActions( a.formEventActions );
            activityNode.loadValidatorsTemplates(
            		assignTemplateComponentIdIfNecessary( config.validatorsTemplates, a.validatorsTemplates ) );
            activityNode.loadVariablesSettersTemplates(
            		assignTemplateComponentIdIfNecessary( config.variablesSettersTemplates, a.variablesSettersTemplates ) );
        }

        var eas = config.extendedAttributes ? config.extendedAttributes : new Array();
        for ( var j = 0; j < eas.length; j++ ) {
            var ea = eas[j];

            if ( ea.NAME == 'JaWE_GRAPH_START_OF_WORKFLOW' || ea.NAME == 'JaWE_GRAPH_END_OF_WORKFLOW' ) {
                var terminationDefSplit = ea.VALUE.split( ',' );
                var participantId = '';
                var x = -1;
                var yPos = -1;
                var connectingActivity = '';

                for ( var k = 0; k < terminationDefSplit.length; k++ ) {
                    var sd = terminationDefSplit[k];
                    var equalSplit = sd.split( '=', -1 );
                    var confName = equalSplit[0];

                    switch ( confName ) {
                        case 'JaWE_GRAPH_PARTICIPANT_ID':
                            participantId = equalSplit[1];
                            break;
                        case 'X_OFFSET':
                            x = parseInt( equalSplit[1] );
                            break;
                        case 'Y_OFFSET':
                            yPos = parseInt( equalSplit[1] );
                            break;
                        case 'CONNECTING_ACTIVITY_ID':
                            connectingActivity = equalSplit[1];
                            break;
                        default:
                            break;
                    }
                }

                if ( x <= paper.bpmn.roleWidth ) {
                    x = paper.bpmn.roleWidth + 5;
                }
                var y = roleYOffsets[participantId] + yPos;
                var connectedWith = activitiesSet[connectingActivity];

                if ( ea.NAME == 'JaWE_GRAPH_START_OF_WORKFLOW' ) {
                    var start = processPanel.drawStart( x, y );

                    if ( connectedWith ) {
                        processPanel.drawBasicLineForTermination( start[0], connectedWith[0] );
                    }
                } else if ( ea.NAME == 'JaWE_GRAPH_END_OF_WORKFLOW' ) {
                    var stop = processPanel.drawStop( x, y );

                    if ( connectedWith ) {
                        processPanel.drawBasicLineForTermination( connectedWith[0], stop[0] );
                    }
                }
            }
        }

        var tOffset = 8;
        var hasOutCondConnection = new Array();
        var ts = config.transitions ? config.transitions : new Array();

        ts.sort( function( a, b ) {
            if ( a.from == b.from ) {
                var order = transitionsOrder.get( a.from );

                if ( !Ext.isEmpty( order ) ) {
                    return order.indexOf( a.tId ) - order.indexOf( b.tId );
                } else {
                    return -1;
                }
            } else if ( a.from > b.from ) {
                return 1;
            }
            return -1;
        } );

        for ( var j = 0; j < ts.length; j++ ) {
            var t = ts[j];
            var connectFrom = activitiesSet[t.from][0];
            processPanel.connectFrom = connectFrom;
            var connectTo = activitiesSet[t.to][0];

            if ( t.isBasic ) {
                if ( t.linePaths && t.linePaths.length > 0 ) {
                    processPanel.connectTo = connectTo;
                    processPanel.directDrawBasicLine( t );
                } else {
                    processPanel.connectingStarted = true;
                    var toBox = connectTo.getBBox();
                    processPanel.drawBasicLine( toBox.x + toBox.width / 2 + tOffset, toBox.y + toBox.height / 2 + tOffset, {
                        tId: t.tId
                    } );
                }
            } else if ( t.isOtherwise ) {
                if ( t.linePaths && t.linePaths.length > 0 ) {
                    processPanel.connectTo = connectTo;
                    processPanel.directDrawOtherwiseLine( t );
                } else {
                    processPanel.connectingStarted = true;
                    var toBox = connectTo.getBBox();
                    processPanel.drawOtherwiseLine( toBox.x + toBox.width / 2 + tOffset, toBox.y + toBox.height / 2 + tOffset, {
                        tId: t.tId
                    } );
                }
            } else if ( t.isDeadline ) {
                if ( t.linePaths && t.linePaths.length > 0 ) {
                    processPanel.connectTo = connectTo;
                    processPanel.directDrawDeadlineLine( t );
                } else {
                    processPanel.connectingStarted = true;
                    var toBox = connectTo.getBBox();
                    processPanel.drawDeadlineLine( toBox.x + toBox.width / 2 + tOffset, toBox.y + toBox.height / 2 + tOffset, {
                        tId: t.tId
                    } );
                }
            } else {
                var condType = conditionTypes.get( t.tId ) ? conditionTypes.get( t.tId ) : 'XOR';
                processPanel.condLineType = condType;

                if ( t.boxPaths && t.boxPaths.length > 0 ) {
                    var withBox = true;
                    if ( hasOutCondConnection[t.from] ) {
                        withBox = false;
                    }

                    t = Ext.apply( {
                        condType: condType
                    }, t );

                    processPanel.connectTo = connectTo;
                    processPanel.directDrawCondLine( withBox, t );
                } else {
                    processPanel.objToDrawType = 'conditionalLine';

                    if ( !hasOutCondConnection[t.from] ) {
                        var fromBox = connectFrom.getBBox();
                        processPanel.conditionalLineStep = 2;
                        processPanel.drawConditionalLine( fromBox.x2 + 10, fromBox.y + fromBox.height / 2 );
                    }

                    processPanel.conditionalLineStep = 3;
                    var toBox = connectTo.getBBox();
                    processPanel.drawConditionalLine( toBox.x + toBox.width / 2 + tOffset, toBox.y + toBox.height / 2 + tOffset, {
                        tId: t.tId,
                        condition: t.condition
                    } );
                }

                hasOutCondConnection[t.from] = true;
            }
        }
        
        if ( snapToGrid ) {
        	paper = Ext.apply( paper, {
        		snapToGrid: true
    		} );

        	if ( paper.showGrid ) {
        		paper.bpmn.showGrid( paper );
        	}
        }
    }
}

function readXpdlPackageExtendedAttributes( packageNode, extendedAttributes ) {
  var mainPanel = Ext.getCmp( 'main_panel' );
  var eas = decomposeExtendedAttributes( extendedAttributes );

  for ( var i = 0; i < eas.length; i++ ) {
    var ea = eas[i];
    var eaName = ea.NAME;
    var eaValue = ea.VALUE;

    switch ( eaName ) {
      case 'EVENT_ACTION_ID_COUNTER':
        packageNode.loadEventActionIdCounter( eaValue );
        break;
      case 'PWE_VERSION':
        mainPanel.setCurrentXpdlVersion( eaValue );
        break;
      default:
        break;
    }
  }
}

function readXpdlProcessId( config, processDefId ) {
    config = Ext.apply( {
        initialProcessDefId: processDefId
    }, config );

    if ( processDefId.length > Ext.ux.suncode.Constants.PROCESS_DEF_ID_MAX_LENGTH ) {
        var errorDescr = getTranslation( 'Zbyt długi identyfikator definicji procesu' );
        errorDescr += ', ';
        errorDescr += getTranslation( 'maksymalna długość' );
        errorDescr += ': ';
        errorDescr += Ext.ux.suncode.Constants.PROCESS_DEF_ID_MAX_LENGTH;
        errorDescr += ' ';
        errorDescr += getTranslation( 'znaków' );

        Ext.ux.suncode.XpdlErrors.addError( {
            object: getTranslation( 'Proces' ),
            processDefId: processDefId,
            activityDefId: 'n/a',
            descr: errorDescr,
            correction: 'n/a'
        } );
    }

    return config;
}

function readXpdlProcessName( config, processName ) {
    processName = decodeTextFromXpdl( processName );

    config = Ext.apply( {
        initialProcessName: processName
    }, config );

    return config;
}

function readXpdlProcessProcessHeader( config, processHeader ) {
    for ( var i = 0; i < processHeader.length; i++ ) {
        var info = processHeader[i];

        if ( info.Created ) {
            config = Ext.apply( {
                initialProcessCreationTime: info.Created[0].XPDLNODEVALUE
            }, config );
        } else if ( info.Description ) {
            var processDescription = decodeTextFromXpdl( info.Description[0].XPDLNODEVALUE );

            if ( processDescription.length > Ext.ux.suncode.Constants.PROCESS_DEF_DESCRIPTION_MAX_LENGTH ) {
              processDescription = processDescription.substring( 0, Ext.ux.suncode.Constants.PROCESS_DEF_DESCRIPTION_MAX_LENGTH );

              var errorDescr = getTranslation( 'Zbyt długi opis procesu' );
              errorDescr += ', ';
              errorDescr += getTranslation( 'maksymalna długość' );
              errorDescr += ': ';
              errorDescr += Ext.ux.suncode.Constants.PROCESS_DEF_DESCRIPTION_MAX_LENGTH;
              errorDescr += ' ';
              errorDescr += getTranslation( 'znaków' );

              var correction = getTranslation( 'Skrócenie długości do' );
              correction += ' ';
              correction += Ext.ux.suncode.Constants.PROCESS_DEF_DESCRIPTION_MAX_LENGTH;
              correction += ' ';
              correction += getTranslation( 'znaków' );

              Ext.ux.suncode.XpdlErrors.addError( {
                object: getTranslation( 'Proces' ),
                processDefId: config.initialProcessDefId,
                activityDefId: 'n/a',
                descr: errorDescr,
                correction: correction
              } );
            }

            config = Ext.apply( {
              initialProcessDescr: processDescription
            }, config );
        }
    }

    return config;
}

function readXpdlProcessFormalParameters( config, formalParameters ) {
    var fParams = new Array();
    var storageDataPresent = false;

    for ( var i = 0; i < formalParameters.length; i++ ) {
        var fp = formalParameters[i];
        var fpDef = new Object();

        var els = fp.FormalParameter;
        for ( var j = 0; j < els.length; j++ ) {
            var el = els[j];

            if ( el.Id ) {
                fpDef = Ext.apply( {
                    id: el.Id,
                    name: el.Id
                }, fpDef );

                if ( el.Id.length > Ext.ux.suncode.Constants.VARIABLE_ID_MAX_LENGTH ) {
                    var errorDescr = getTranslation( 'Zbyt długi identyfikator parametru formalnego' );
                    errorDescr += ', ';
                    errorDescr += getTranslation( 'maksymalna długość' );
                    errorDescr += ': ';
                    errorDescr += Ext.ux.suncode.Constants.VARIABLE_ID_MAX_LENGTH;
                    errorDescr += ' ';
                    errorDescr += getTranslation( 'znaków' );

                    Ext.ux.suncode.XpdlErrors.addError( {
                        object: getTranslation( 'Parametr formalny' ) + ': ' + el.Id,
                        processDefId: config.initialProcessDefId,
                        activityDefId: 'n/a',
                        descr: errorDescr,
                        correction: 'n/a'
                    } );
                }
            } else if ( el.Mode ) {
                fpDef = Ext.apply( {
                    mode: el.Mode
                }, fpDef );
            } else if ( el.Description ) {
                fpDef = Ext.apply( {
                    descr: decodeTextFromXpdl( el.Description[0].XPDLNODEVALUE )
                }, fpDef );
            } else if ( el.DataType ) {
                fpDef = Ext.apply( {
                    type: el.DataType[0].BasicType[0].Type
                }, fpDef );
            }
        }

        if ( Ext.ux.suncode.FormalParameterService.isDefaultParameter( fpDef.name ) ) {
            fpDef = Ext.apply( {
                status: 'static'
            }, fpDef );
        } else {
            fpDef = Ext.apply( {
                status: 'custom'
            }, fpDef );
        }

        if ( Ext.ux.suncode.FormalParameterService.isStorageDataParameter( fpDef.name ) ) {
          storageDataPresent = true;

          if ( !Ext.ux.suncode.FormalParameterService.isCorrectStorageDataParameter( fpDef ) ) {
            fpDef = Ext.apply( fpDef, Ext.ux.suncode.FormalParameterService.buildStorageDataParameter() );

            var errorDescr = getTranslation( 'Parametr formalny StorageData posiada inną definicję, niż założona' );

            Ext.ux.suncode.XpdlErrors.addError( {
              object: getTranslation( 'Parametr formalny' ) + ': ' + fpDef.id,
              processDefId: config.initialProcessDefId,
              activityDefId: 'n/a',
              descr: getTranslation( 'Parametr formalny StorageData posiada inny tryb lub typ, niż oczekiwane' ),
              correction: getTranslation( 'Zmiana trybu i typu na oczekiwane' )
            } );
          }
        }

      fParams.push( fpDef );
    }

    if ( !storageDataPresent ) {
      fParams.push( Ext.ux.suncode.FormalParameterService.buildStorageDataParameter() );
    }

    config = Ext.apply( {
        formalParameters: fParams
    }, config );

    return config;
}

function readXpdlProcessParticipants( config, participants, fromPackage ) {
    var roles = new Array();

    for ( var i = 0; i < participants.length; i++ ) {
        var p = participants[i];
        var roleDef = new Object();

        var els = p.Participant;
        for ( var j = 0; j < els.length; j++ ) {
            var el = els[j];

            if ( el.Id ) {
                roleDef = Ext.apply( {
                    roleId: el.Id
                }, roleDef );

                if ( el.Id.length > Ext.ux.suncode.Constants.ROLE_ID_MAX_LENGTH ) {
                    var errorDescr = fromPackage ? getTranslation( 'Zbyt długi identyfikator uczestnika pakietowego' )
                                    : getTranslation( 'Zbyt długi identyfikator uczestnika' );
                    errorDescr += ', ';
                    errorDescr += getTranslation( 'maksymalna długość' );
                    errorDescr += ': ';
                    errorDescr += Ext.ux.suncode.Constants.ROLE_ID_MAX_LENGTH;
                    errorDescr += ' ';
                    errorDescr += getTranslation( 'znaków' );

                    Ext.ux.suncode.XpdlErrors.addError( {
                        object: getTranslation( 'Uczestnik' ) + ': ' + el.Id,
                        processDefId: fromPackage ? 'n/a' : config.initialProcessDefId,
                        activityDefId: 'n/a',
                        descr: errorDescr,
                        correction: 'n/a'
                    } );
                }
            } else if ( el.Name ) {
                roleDef = Ext.apply( {
                    roleName: decodeTextFromXpdl( el.Name )
                }, roleDef );
            } else if ( el.ParticipantType ) {
                roleDef = Ext.apply( {
                    roleType: analyzeParticipantType( el.ParticipantType[0].Type )
                }, roleDef );
            } else if ( el.Description ) {
                roleDef = Ext.apply( {
                    roleDescr: decodeTextFromXpdl( el.Description[0].XPDLNODEVALUE )
                }, roleDef );
            } else if ( el.ExtendedAttributes ) {
                extAttrs = decomposeExtendedAttributes( el.ExtendedAttributes );

                for ( var k = 0; k < extAttrs.length; k++ ) {
                    var ea = extAttrs[k];
                    var eaName = ea.NAME;
                    var eaValue = ea.VALUE;

                    switch ( eaName ) {
                        case 'WIDTH':
                            roleDef = Ext.apply( {
                                roleWidth: eaValue
                            }, roleDef );
                            break;
                        case 'HEIGHT':
                            roleDef = Ext.apply( {
                                roleHeight: eaValue
                            }, roleDef );
                            break;
                        default:
                            break;
                    }
                }
            }
        }

        if ( Ext.isEmpty( roleDef.roleName ) ) {
            roleDef = Ext.apply( {
                roleName: roleDef.roleId
            }, roleDef );
        }

        roles.push( roleDef );

        participantsTypes.put( roleDef.roleId, roleDef.roleType );
    }

    config = Ext.apply( {
        participants: roles
    }, config );

    return config;
}

function readXpdlProcessApplications( config, applications ) {
    var apps = new Array();
    processApplications.clear();

    if ( !Ext.isEmpty( packageApplications ) ) {
        for ( var i = 0; i < packageApplications.length; i++ ) {
            var appDef = packageApplications[i];

            processApplications.put( appDef.id, {
                name: appDef.name,
                appType: appDef.appType,
                parameters: appDef.parameters
            } );
        }
    }

    for ( var i = 0; i < applications.length; i++ ) {
        var a = applications[i];
        var appDef = new Object();
        var appParams = new Array();
        var extAttrs = new Array();
        var realization = new Object( {
            agent: '',
            mode: ''
        } );
        var appType = '';
        var appDescr = '';
        var integrationComponent = true;

        var els = a.Application;
        for ( var j = 0; j < els.length; j++ ) {
            var el = els[j];

            if ( el.Id ) {
                appDef = Ext.apply( {
                    id: el.Id
                }, appDef );
            } else if ( el.Name ) {
                appDef = Ext.apply( {
                    name: decodeTextFromXpdl( el.Name )
                }, appDef );
            } else if ( el.Description ) {
                appDescr = decodeTextFromXpdl( el.Description[0].XPDLNODEVALUE );
            } else if ( el.FormalParameters ) {
            	integrationComponent = false;
                var fps = el.FormalParameters;
                for ( var k = 0; k < fps.length; k++ ) {
                    var fp = fps[k];
                    var fpDef = new Object();

                    var fpels = fp.FormalParameter;
                    for ( var l = 0; l < fpels.length; l++ ) {
                        var fpel = fpels[l];

                        if ( fpel.Id ) {
                            fpDef = Ext.apply( {
                                id: fpel.Id
                            }, fpDef );
                        } else if ( fpel.Mode ) {
                            fpDef = Ext.apply( {
                                mode: fpel.Mode
                            }, fpDef );
                        } else if ( fpel.DataType ) {
                            fpDef = Ext.apply( {
                                type: fpel.DataType[0].BasicType[0].Type
                            }, fpDef );
                        } else if ( fpel.Description ) {
                            fpDef = Ext.apply( {
                                descr: decodeTextFromXpdl( fpel.Description[0].XPDLNODEVALUE )
                            }, fpDef );
                        }
                    }

                    appParams.push( fpDef );
                }
            } else if ( el.ExtendedAttributes ) {
                extAttrs = decomposeExtendedAttributes( el.ExtendedAttributes );

                for ( var k = 0; k < extAttrs.length; k++ ) {
                    var ea = extAttrs[k];
                    var eaName = ea.NAME;
                    var eaValue = ea.VALUE;

                    switch ( eaName ) {
                        case 'ToolAgentClass':
                            appType = eaValue;
                            break;
                        case 'Script':
                            realization.agent = decodeTextFromXpdl( eaValue );
                            break;
                        case 'AppName':
                            realization.agent = eaValue;
                            break;
                        case 'AppMode':
                            realization.mode = eaValue;
                            break;
                        default:
                            break;
                    }
                }
            }
        }

        appDef = Ext.apply( {
            appType: appType,
            realization: realization,
            parameters: appParams,
            descr: appDescr,
            integrationComponent: integrationComponent
        }, appDef );

        if ( Ext.isEmpty( appDef.name ) ) {
            appDef = Ext.apply( {
                name: appDef.id
            }, appDef );
        }

        apps.push( appDef );

        processApplications.put( appDef.id, {
            name: appDef.name,
            appType: appDef.appType,
            parameters: appDef.parameters
        } );
    }

    config = Ext.apply( {
        applications: apps
    }, config );

    return config;
}

function readXpdlProcessDataFields( config, dataFields ) {
    var vars = new Array();
    processDataFields.clear();

    for ( var i = 0; i < dataFields.length; i++ ) {
        var df = dataFields[i];
        var varDef = new Object();
        var requirement = false;
        var readonly = false;
        var dtHidden = false;
        var dtSize = 0;
        var dtMinSize = 0;
        var dtMenuDisabled = true;
        var dtAlign = '';
        var dtDecimalSeparator = '';
        var dtAllowDecimals = true;
        var dtSortable = false;
        var dtGroupable = true;
        var extAttrs = new Array();
        var roleusersTxt = 'ROLEUSERS';
        var isRoleusers = false;
        var userlistTxt = 'USERLIST';
        var isUserlist = false;
        var regex = '';
        var subtype = '';

        var els = df.DataField;
        for ( var j = 0; j < els.length; j++ ) {
            var el = els[j];

            if ( el.Id ) {
                varDef = Ext.apply( {
                    id: el.Id
                }, varDef );

                if ( el.Id.length > Ext.ux.suncode.Constants.VARIABLE_ID_MAX_LENGTH ) {
                    var errorDescr = getTranslation( 'Zbyt długi identyfikator zmiennej procesu' );
                    errorDescr += ', ';
                    errorDescr += getTranslation( 'maksymalna długość' );
                    errorDescr += ': ';
                    errorDescr += Ext.ux.suncode.Constants.VARIABLE_ID_MAX_LENGTH;
                    errorDescr += ' ';
                    errorDescr += getTranslation( 'znaków' );

                    Ext.ux.suncode.XpdlErrors.addError( {
                        object: getTranslation( 'Zmienna procesu' ) + ': ' + el.Id,
                        processDefId: config.initialProcessDefId,
                        activityDefId: 'n/a',
                        descr: errorDescr,
                        correction: 'n/a'
                    } );
                } else {
                	var correctId = generateId( el.Id, Ext.ux.suncode.Constants.VARIABLE_ID_MAX_LENGTH );

                    if ( !areIdsTheSame( el.Id, correctId ) ) {
                    	Ext.ux.suncode.XpdlErrors.addError( {
                            object: getTranslation( 'Zmienna procesu' ) + ': ' + el.Id,
                            processDefId: config.initialProcessDefId,
                            activityDefId: 'n/a',
                            descr: getTranslation( 'Niepoprawny identyfikator zmiennej procesu' ),
                            correction: 'n/a'
                        } );
                    }
                }
            } else if ( el.Name ) {
                varDef = Ext.apply( {
                    name: decodeTextFromXpdl( el.Name )
                }, varDef );
            } else if ( el.Description ) {
                varDef = Ext.apply( {
                    descr: decodeTextFromXpdl( el.Description[0].XPDLNODEVALUE )
                }, varDef );
            } else if ( el.InitialValue ) {
                varDef = Ext.apply( {
                    initialValue: decodeTextFromXpdl( el.InitialValue[0].XPDLNODEVALUE )
                }, varDef );
            } else if ( el.DataType ) {
                varDef = Ext.apply( {
                    type: el.DataType[0].BasicType[0].Type
                }, varDef );

                if ( varDef.type == 'INTEGER' || varDef.type == 'FLOAT' ) {
                	varDef = Ext.apply( {
                        placement: 'form'
                    }, varDef );
                }
            } else if ( el.ExtendedAttributes ) {
                extAttrs = decomposeExtendedAttributes( el.ExtendedAttributes );
            }
        }

        for ( var j = 0; j < extAttrs.length; j++ ) {
            var ea = extAttrs[j];
            var eaName = ea.NAME;
            var eaValue = ea.VALUE;

            switch ( eaName ) {
                case 'REQUIREMENT':
                    if ( eaValue.toLowerCase() == 'yes' ) {
                        requirement = true;
                    }
                    break;
                case 'READONLY':
                    if ( eaValue.toLowerCase() == 'true' ) {
                        readonly = true;
                    }
                    break;
                case 'SUBTYPE':
                	subtype = eaValue;
                    varDef.type = analyzeDataFieldType( config.initialProcessDefId, varDef.id, varDef.type, eaValue );

                    if ( Ext.isEmpty( varDef.placement ) &&
                    		( varDef.type == 'INTEGER' || varDef.type == 'FLOAT' || varDef.type == 'AMOUNT' ) ) {
                    	varDef = Ext.apply( {
                            placement: 'table'
                        }, varDef );
                    }
                    break;
                case 'VALUES':
                    if ( eaValue == roleusersTxt ) {
                        isRoleusers = true;
                    } else if ( eaValue == userlistTxt ) {
                        isUserlist = true;
                    } else {
                        var values = eaValue.split( '\n' );
                        var valuesList = new Array();

                        for ( var k = 0; k < values.length; k++ ) {
                            if ( !Ext.isEmpty( values[k] ) ) {
                                valuesList.push( {
                                    value: decodeTextFromXpdl( values[k] )
                                } );
                            }
                        }

                        varDef = Ext.apply( {
                            valuesList: valuesList
                        }, varDef );
                    }
                    break;
                case 'DATA_CHOOSER':
                    varDef.type = 'DATA_CHOOSER';

                    varDef = Ext.apply( {
                        classpath: '',
                        sort: 'combobox',
                        fieldType: 'string',
                        comboForceSelection: false,
                        comboFilteringDisabled: false,
                        comboNoLazyInit: false,
                        comboQueryDelay: '',
                        formCriteria: new Array(),
                        mappings: new Array(),
                        customKeys: new Array(),
                        definition: {
                        	autoMapping: {
                                active: true,
                                clearMapped: false,
                                onlyUnique: true,
                                filterValue: true,
                                suspendChildrenPropagation: false
                            }
                        }
                    }, varDef );

                    var dcConfLines = eaValue.split( '\n' );

                    for ( var k = 0; k < dcConfLines.length; k++ ) {
                        varDef = handleDCConfLine( varDef, dcConfLines[k] );
                    }
                    break;
                case 'DATA_CHOOSER_DEFINITION':
                    varDef = Ext.apply( varDef, {
                    	definition: Ext.util.JSON.decode( decodeTextFromXpdl( eaValue ) )
                    } );
                case 'DT_HIDDEN':
                    dtHidden = parseBoolean( eaValue );
                    break;
                case 'SIZE':
                    try {
                        dtSize = parseInt( eaValue );

                        if ( dtSize < 0 ) {
                            dtSize = 0;
                        }
                    }
                    catch ( e ) {
                        dtSize = 0;
                    }
                    break;
                case 'MIN_SIZE':
                    try {
                        dtMinSize = parseInt( eaValue );

                        if ( dtMinSize < 0 ) {
                            dtMinSize = 0;
                        }
                    }
                    catch ( e ) {
                        dtMinSize = 0;
                    }
                    break;
                case 'DT_MENU_DISABLED':
                    dtMenuDisabled = parseBoolean( eaValue );
                    break;
                case 'DT_ALIGN':
                    dtAlign = eaValue;
                    break;
                case 'DT_DECIMAL_PRECISION':
                case 'DECIMAL_PRECISION':
                	var decimalPrecision = 2;

                    try {
                        decimalPrecision = parseInt( eaValue );

                        if ( decimalPrecision < 0 ) {
                        	decimalPrecision = 2;
                        }
                    }
                    catch ( e ) {
                        decimalPrecision = 2;
                    }

                    varDef = Ext.apply( {
                    	decimalPrecision: decimalPrecision
                    }, varDef );
                    break;
                case 'DT_DECIMAL_SEPARATOR':
                    dtDecimalSeparator = eaValue;
                    break;
                case 'DT_ALLOW_DECIMALS':
                    dtAllowDecimals = parseBoolean( eaValue );
                    break;
                case 'DT_SORTABLE':
                    dtSortable = parseBoolean( eaValue );
                    break;
                case 'DT_GROUPABLE':
                    dtGroupable = parseBoolean( eaValue );
                    break;
                case 'DT_LOCKED':
                    break;
                case 'DT_LOCKABLE':
                    break;
                case 'DT_FORMAT':
                    varDef = Ext.apply( {
                        dtFormat: eaValue
                    }, varDef );
                    break;
                case 'DC_ALIGN':
                    varDef = Ext.apply( {
                        dcAlign: eaValue
                    }, varDef );
                    break;
                case 'THOUSAND_SEPARATOR':
                	varDef = Ext.apply( {
                        thousandSeparator: Ext.isEmpty( eaValue, true ) ? '<NONE>' : decodeTextFromXpdl( eaValue )
                    }, varDef );
                    break;
                case 'REG_EXPRESSION':
                    regex = decodeTextFromXpdl( eaValue );
                    break;
                case 'EXTYPE':
                    varDef = Ext.apply( {
                        exType: eaValue
                    }, varDef );
                    break;
                case 'FORMAT':
                    varDef = Ext.apply( {
                    	format: eaValue
                    }, varDef );
                    break;
                case 'ARRAY':
                    varDef = Ext.apply( {
                        placement: parseBoolean( eaValue ) ? 'table' : 'form'
                    }, varDef );
                    break;
                case 'FORM_ACTIONS':
                    varDef = Ext.apply( {
                      formActions: Ext.util.JSON.decode( decodeTextFromXpdl( eaValue ) )
                    }, varDef );
                    break;
                case 'EVENT_ACTIONS':
                  varDef = Ext.apply( {
                    eventActions: Ext.util.JSON.decode( decodeTextFromXpdl( eaValue ) )
                  }, varDef );
                  break;
                case 'CREATION_DATE':
                    varDef = Ext.apply( {
                      creationDate: eaValue
                    }, varDef );
                    break;
                case 'MODIFICATION_DATE':
                    varDef = Ext.apply( {
                      modificationDate: eaValue
                    }, varDef );
                    break;
                case 'NOT_REMEMBER_SIZE':
                  varDef = Ext.apply( varDef, {
                    rememberSize: !parseBoolean( eaValue )
                  } );
                  break;
                default:
                    Ext.ux.suncode.XpdlErrors.addError( {
                        object: getTranslation( 'Zmienna procesu' ) + ': ' + varDef.id,
                        processDefId: config.initialProcessDefId,
                        activityDefId: 'n/a',
                        descr: getTranslation( 'Nieznany atrybut rozszerzony' ) + ': ' + eaName,
                        correction: getTranslation( 'Pominięcie atrybutu' )
                    } );
                    break;
            }
        }

        if ( ( isRoleusers || isUserlist || !Ext.isEmpty( varDef.valuesList ) ) && Ext.isEmpty( subtype ) ) {
            Ext.ux.suncode.XpdlErrors.addError( {
                object: getTranslation( 'Zmienna procesu' ) + ': ' + varDef.id,
                processDefId: config.initialProcessDefId,
                activityDefId: 'n/a',
                descr: getTranslation( 'Definicja określa artybut VALUES bez podania podtypu' ),
                correction: getTranslation( 'Zmiana typu zmiennej na' ) + ' ' + getTranslation( 'Tekstowy' ).toLowerCase()
            } );
        }

        if ( isRoleusers ) {
            varDef.type = varDef.type.replace( 'LISTBOX', roleusersTxt );
        }
        if ( isUserlist ) {
            varDef.type = userlistTxt + 'LISTBOX';
        }

        if ( Ext.isEmpty( varDef.name ) ) {
            varDef = Ext.apply( {
                name: varDef.id
            }, varDef );
        }

        if ( varDef.type == 'FLOAT' && !Ext.isEmpty( varDef.format ) && varDef.format.endsWith( '.00' ) ) {
        	varDef.type = 'AMOUNT';
        }

        if ( varDef.type == 'DATE' ) {
          if ( !Ext.isEmpty( varDef.format ) ) {
            switch ( varDef.format ) {
              case 'Y-m-d g:i:s A':
                varDef.format = 'Y-m-d';
                break;
              case 'Y-m-dTH:i:s':
                varDef.format = 'Y-m-d';
                break;
              default:
                break;
            }
          } else if ( !Ext.isEmpty( varDef.dtFormat ) ) {
            varDef = Ext.apply( varDef, {
              format: varDef.dtFormat
            } );

            delete varDef.dtFormat;
          }
        }

        if ( Ext.isEmpty( varDef.format ) ) {
        	switch ( varDef.type ) {
	        	case 'INTEGER':
              varDef = Ext.apply( {
                format: '0,000'
              }, varDef );
	        		break;
	        	case 'FLOAT':
              if ( !Ext.isEmpty( varDef.dtFormat ) ) {
                varDef = Ext.apply( varDef, {
                  format: varDef.dtFormat
                } );

                delete varDef.dtFormat;
              } else {
                varDef = Ext.apply( {
                  format: '0,000.00'
                }, varDef );
              }
	        		break;
	        	case 'AMOUNT':
              varDef = Ext.apply( {
                format: '0,000.00'
              }, varDef );
	        		break;
	        	default:
	        		break;
        	}
        }

        if ( Ext.isEmpty( varDef.decimalPrecision ) ) {
        	switch ( varDef.type ) {
	        	case 'FLOAT':
	        		varDef = Ext.apply( {
                    	decimalPrecision: 2
                    }, varDef );
	        		break;
	        	case 'AMOUNT':
	        		varDef = Ext.apply( {
                    	decimalPrecision: 2
                    }, varDef );
	        		break;
	        	default:
	        		break;
        	}
        }

        if ( Ext.isEmpty( varDef.thousandSeparator ) ) {
        	switch ( varDef.type ) {
        		case 'INTEGER':
	        	case 'FLOAT':
	        	case 'AMOUNT':
              varDef = Ext.apply( varDef, {
                thousandSeparator: ' '
              } );
	        		break;
	        	default:
	        		break;
        	}
        }

        if ( ( !Ext.isEmpty( varDef.thousandSeparator ) || varDef.thousandSeparator === ' ' ) && varDef.format === '0.00' ) {
            varDef = Ext.apply( varDef, {
                format: '0,000.00'
            } );
        }

        switch ( varDef.type ) {
        	case 'CHECKBOX':
        	case 'RADIOBUTTON':
	        case 'LISTBOX':
	        case 'LISTBOX_EDIT':
	        case 'LISTBOX_NO_FILTER':
	        case 'LISTBOX_EDIT_NO_FILTER':
	        case 'LISTBOX_NO_LAZY':
	        case 'LISTBOX_NO_FILTER_NO_LAZY':
	        	if ( Ext.isEmpty( varDef.valuesList ) ) {
	        		var valuesList = new Array();
	        		valuesList.push( {
                        value: varDef.name
                    } );

                    varDef = Ext.apply( varDef, {
                        valuesList: valuesList
                    } );

                    Ext.ux.suncode.XpdlErrors.addError( {
                        object: getTranslation( 'Zmienna procesu' ) + ': ' + varDef.id,
                        processDefId: config.initialProcessDefId,
                        activityDefId: 'n/a',
                        descr: getTranslation( 'Brak określonych wartości' ),
                        correction: getTranslation( 'Dodanie nazwy zmiennej jako wartość domyślna' )
                    } );
	        	}
        		break;
          case 'TEXTAREA':
            if ( !Ext.isDefined( varDef.rememberSize ) ) {
              varDef = Ext.apply( varDef, {
                rememberSize: true
              } );
            }
            break;
	        case 'DATA_CHOOSER':
	        	if ( subtype == 'TEXTAREA' ) {
	        		varDef = Ext.apply( varDef, {
	        			fieldType: 'textarea'
	        		} );
	        	}
	        	break;
        	default:
        		break;
        }

        varDef = Ext.apply( {
            regex: regex,
            requirement: requirement,
            readonly: readonly,
            dtHidden: dtHidden,
            dtSize: dtSize,
            dtMinSize: dtMinSize,
            dtMenuDisabled: dtMenuDisabled,
            dtAlign: dtAlign,
            dtDecimalSeparator: dtDecimalSeparator,
            dtAllowDecimals: dtAllowDecimals,
            dtSortable: dtSortable,
            dtGroupable: dtGroupable
        }, varDef );

        vars.push( varDef );

        processDataFields.put( varDef.id, {
            name: varDef.name,
            type: varDef.type,
            readonly: readonly,
            dtHidden: dtHidden
        } );
    }

    config = Ext.apply( {
        dataFields: vars
    }, config );

    return config;
}

function analyzeDataFieldType( processDefId, varId, type, subtype ) {
    subtype = Ext.isEmpty( subtype ) ? 'UNKNOWN' : subtype.toUpperCase();

    switch ( subtype ) {
        case 'LISTBOX_NO_EDIT':
            return 'LISTBOX';
        case 'LISTBOX_NO_FILTER_EDIT':
            return 'LISTBOX_EDIT_NO_FILTER';
        case 'LISTBOX_NO_LAZY_NO_FILTER':
            return 'LISTBOX_NO_FILTER_NO_LAZY';
        case 'ADVANCELISTBOX':
            addAdvanceListboxXpdlError( processDefId, varId );
            return 'LISTBOX';
        case 'ADVANCELISTBOX_EDIT':
            addAdvanceListboxXpdlError( processDefId, varId );
            return 'LISTBOX_EDIT';
        case 'ADVANCELISTBOX_NO_FILTER':
            addAdvanceListboxXpdlError( processDefId, varId );
            return 'LISTBOX_NO_FILTER';
        case 'ADVANCELISTBOX_EDIT_NO_FILTER':
        case 'ADVANCELISTBOX_NO_FILTER_EDIT':
            addAdvanceListboxXpdlError( processDefId, varId );
            return 'LISTBOX_EDIT_NO_FILTER';
        case 'ADVANCELISTBOX_NO_LAZY':
            addAdvanceListboxXpdlError( processDefId, varId );
            return 'LISTBOX_NO_LAZY';
        case 'ADVANCELISTBOX_NO_FILTER_NO_LAZY':
        case 'ADVANCELISTBOX_NO_LAZY_NO_FILTER':
            addAdvanceListboxXpdlError( processDefId, varId );
            return 'LISTBOX_NO_FILTER_NO_LAZY';
        case 'STRING':
        case 'TEXTAREA':
        case 'DATETIME':
        case 'DATE':
        case 'INTEGER':
        case 'FLOAT':
        case 'AMOUNT':
        case 'BOOLEAN':
        case 'RADIOBUTTON':
        case 'CHECKBOX':
        case 'LISTBOX':
        case 'LISTBOX_EDIT':
        case 'LISTBOX_NO_FILTER':
        case 'LISTBOX_EDIT_NO_FILTER':
        case 'LISTBOX_NO_LAZY':
        case 'LISTBOX_NO_FILTER_NO_LAZY':
        case 'USERLIST':
        case 'DATA_CHOOSER':
            return subtype;
        default:
            var usedType = '';

            if ( Ext.isEmpty( type ) ) {
                usedType = 'STRING';
            } else {
                usedType = type;
            }

            Ext.ux.suncode.XpdlErrors.addError( {
                object: getTranslation( 'Zmienna procesu' ) + ': ' + varId,
                processDefId: processDefId,
                activityDefId: 'n/a',
                descr: getTranslation( 'Użycie nieznanego typu zmiennej' ) + ': ' + subtype,
                correction: getTranslation( 'Zmiana typu zmiennej na' ) + ' ' + usedType
            } );

            return usedType;
    }
}

function addAdvanceListboxXpdlError( processDefId, varId ) {
    Ext.ux.suncode.XpdlErrors.addError( {
        object: getTranslation( 'Zmienna procesu' ) + ': ' + varId,
        processDefId: processDefId,
        activityDefId: 'n/a',
        descr: getTranslation( 'Użycie przestarzałego typu zmiennej ADVANCELISTBOX' ),
        correction: getTranslation( 'Zmiana typu zmiennej na' ) + ' LISTBOX'
    } );
}

function handleDCConfLine( varDef, line ) {
    var lineSplit = line.split( '=', -1 );
    var confName = decodeTextFromXpdl( lineSplit[0] );

    if ( confName.isDCMapping() ) {
        var semicolonSplit = connectEqualSplit( lineSplit ).split( ';', -1 );

        varDef.mappings.push( {
            id: semicolonSplit[0],
            descr: '',
            varId: semicolonSplit[1],
            display: semicolonSplit[2],
            verify: semicolonSplit[3] == 'check' ? true : false
        } );

        return varDef;
    }

    switch ( confName ) {
        case 'class':
            varDef.classpath = lineSplit[1];
            break;
        case 'type':
            varDef.sort = lineSplit[1];
            break;
        case 'comboForceSelection':
            varDef.comboForceSelection = parseBoolean( lineSplit[1] );
            break;
        case 'comboFilteringDisabled':
            varDef.comboFilteringDisabled = parseBoolean( lineSplit[1] );
            break;
        case 'comboLazyInit':
            varDef.comboNoLazyInit = !parseBoolean( lineSplit[1] );
            break;
        case 'comboQueryDelay':
            varDef.comboQueryDelay = lineSplit[1];
            break;
        case 'formCriteria':
            var semicolonSplit = connectEqualSplit( lineSplit ).replaceAll( ',', ';' ).replaceAll( '.', ';' ).replaceAll( ':', ';' ).split( ';' );

            for ( var i = 0; i < semicolonSplit.length; i++ ) {
                var fc = semicolonSplit[i];

                if ( !Ext.isEmpty( fc ) ) {
                    varDef.formCriteria.push( {
                        descr: '',
                        varId: fc
                    } );
                }
            }

            break;
        default:
            varDef.customKeys.push( {
                id: confName,
                descr: '',
                value: connectEqualSplit( lineSplit )
            } );
            break;
    }

    return varDef;
}

function connectEqualSplit( lineSplit ) {
    var str = '';

    for ( var i = 1; i < lineSplit.length; i++ ) {
        var substr = decodeTextFromXpdl( lineSplit[i] );

        if ( i < lineSplit.length - 1 ) {
            str += substr + '=';
        } else {
            str += substr;
        }
    }

    return str;
}

function readXpdlProcessExtendedAttributes( config, extendedAttributes ) {
    var mainPanel = Ext.getCmp( 'main_panel' );
    var eas = decomposeExtendedAttributes( extendedAttributes );
    var labels = new Array();
    processTablesColumns.clear();

    config = Ext.apply( {
        extendedAttributes: eas
    }, config );

    for ( var j = 0; j < eas.length; j++ ) {
        var ea = eas[j];
        var eaName = ea.NAME;
        var eaValue = ea.VALUE;

        switch ( eaName ) {
            case 'PROCESS_COLOR':
                config = Ext.apply( {
                    initialProcessColor: eaValue
                }, config );
                break;
            case 'PROCESS_NAME_MASK':
                var processNameMask = '';

                if ( eaValue == config.initialProcessName ) {
                    processNameMask = 'NAME';
                } else if ( eaValue == config.initialProcessName + '_ VER/#####' || ea.VALUE == config.initialProcessName + ' _VER/#####' ) {
                    processNameMask = 'VER';
                } else {
                    processNameMask = decodeTextFromXpdl( eaValue );
                }

                config = Ext.apply( {
                    initialProcessNameMask: processNameMask
                }, config );
                break;
            case 'JaWE_GRAPH_WORKFLOW_PARTICIPANT_ORDER':
                config = Ext.apply( {
                    participantsOrder: eaValue
                }, config );
                break;
            case 'GLOBAL_PARTICIPANT':
            case 'JaWE_GRAPH_START_OF_WORKFLOW':
            case 'JaWE_GRAPH_END_OF_WORKFLOW':
            case 'JaWE_GRAPH_WORKFLOW_PARTICIPANT_ORIENTATION':
                break;
            case 'VALIDATOR_TEMPLATES':
            	var templates = Ext.util.JSON.decode( decodeTextFromXpdl( eaValue ) );

            	config = Ext.apply( {
                    validatorsTemplates: generateTemplateComponentIdsIfNecessary( templates )
                }, config );
            	break;
            case 'VARIABLES_SETTER_TEMPLATES':
            	var templates = Ext.util.JSON.decode( decodeTextFromXpdl( eaValue ) );

            	config = Ext.apply( {
                    variablesSettersTemplates: generateTemplateComponentIdsIfNecessary( templates )
                }, config );
            	break;
            case 'LABEL':
            	var labelDef = new Object();
            	var labelConfLines = eaValue.split( '\n' );

                for ( var k = 0; k < labelConfLines.length; k++ ) {
                	labelDef = handleLabel( labelDef, labelConfLines[k] );
                }

            	labels.push( labelDef );
            	break;
          case 'TABLES':
              var tables = Ext.util.JSON.decode( decodeTextFromXpdl( eaValue ) );

              config = Ext.apply( {
                tables: tables
              }, config );

              if ( !Ext.isEmpty( tables ) ) {
                Ext.each( tables, function( table, tableIndex, allTables ) {
                  var tableColumnsMap = new HashMap();
                  var tableColumns = table.columns;

                  for (var k = 0; k < tableColumns.length; k++ ) {
                    var tableColumn = tableColumns[k];
                    tableColumnsMap.put( tableColumn.varId, tableColumn );

                    if ( !processDataFields.contains( tableColumn.varId ) ) {
                      tableColumns.splice( k, 1 );

                      Ext.ux.suncode.XpdlErrors.addError( {
                        object: getTranslation( 'Tabela globalna' ),
                        processDefId: config.initialProcessDefId,
                        activityDefId: 'n/a',
                        descr: getTranslation( 'Użycie nieistniejącej zmiennej procesu jako kolumny w tabeli globalnej' )
                            + ': ' + tableColumn.varId,
                        correction: getTranslation( 'Usunięcie kolumny' )
                      } );
                      break;
                    }
                  }

                  processTablesColumns.put( table.id, tableColumnsMap );

                  Ext.each( table.formActions, function( formAction, formActionIndex, formActions ) {
                    if ( !Ext.isEmpty( formAction.globalId ) ) {
                      mainPanel.storeGlobalId( formAction.globalId );
                    }
                  } );

                  if ( Ext.isDefined( table.eventActions ) ) {
                    Ext.each( table.eventActions, function( eventAction, eventActionIndex, eventActions ) {
                      if ( !Ext.isEmpty( eventAction.globalId ) ) {
                        mainPanel.storeGlobalId( eventAction.globalId );
                      }
                    } );
                  } else {
                    Ext.apply( table, {
                      eventActions: new Array()
                    } );
                  }

                  Ext.each( table.DTButtons, function( dtButton, dtButtonIndex, dtButtons ) {
                    Ext.each( dtButton.formActions, function( formAction, formActionIndex, formActions ) {
                      if ( !Ext.isEmpty( formAction.globalId ) ) {
                        mainPanel.storeGlobalId( formAction.globalId );
                      }
                    } );

                    if ( Ext.isDefined( dtButton.eventActions ) ) {
                      Ext.each(dtButton.eventActions, function (eventAction, eventActionIndex, eventActions) {
                        if (!Ext.isEmpty(eventAction.globalId)) {
                          mainPanel.storeGlobalId(eventAction.globalId);
                        }
                      });
                    } else {
                      Ext.apply( dtButton, {
                        eventActions: new Array()
                      } );
                    }

                    if ( Ext.isEmpty( dtButton.destination ) ) {
                      Ext.apply( dtButton, {
                        destination: 'TASKFORM'
                      } );
                    }
                  } );

                  if ( Ext.isEmpty( table.clicksToEdit ) ) {
                    Ext.apply( table, {
                      clicksToEdit: 2
                    } );
                  }

                  if ( Ext.isEmpty( table.showDeleteConfirmation ) ) {
                    Ext.apply( table, {
                      showDeleteConfirmation: false
                    } );
                  }

                  if ( Ext.isEmpty( table.hideRowNumber ) ) {
                    Ext.apply( table, {
                      hideRowNumber: false
                    } );
                  }
                } );
              }
              break;
          case 'ATTACHMENT_DIRECTORY':
            config = Ext.apply( {
              initialAttachmentDirectory: eaValue
            }, config );
            break;
            default:
                Ext.ux.suncode.XpdlErrors.addError( {
                    object: getTranslation( 'Proces' ),
                    processDefId: config.initialProcessDefId,
                    activityDefId: 'n/a',
                    descr: getTranslation( 'Nieznany atrybut rozszerzony' ) + ': ' + eaName,
                    correction: getTranslation( 'Pominięcie atrybutu' )
                } );
                break;
        }
    }

    config = Ext.apply( {
        labels: labels
    }, config );

    return config;
}

function handleLabel( labelDef, line ) {
    var lineSplit = line.split( '=', -1 );
    var confName = decodeTextFromXpdl( lineSplit[0] );

    switch ( confName ) {
        case 'id':
        	labelDef.id = lineSplit[1];
            break;
        case 'name':
        	labelDef.name = decodeTextFromXpdl( lineSplit[1] );
            break;
        case 'formActions':
          labelDef.formActions = Ext.util.JSON.decode( decodeTextFromXpdl( connectEqualSplit( lineSplit ) ) );
          break;
        default:
            break;
    }

    return labelDef;
}

function assignVariablePlacementIfNecessary( dataFields, activities ) {
	if ( !Ext.isEmpty( dataFields ) ) {
		for ( var i = 0; i < dataFields.length; i++ ) {
			var dataField = dataFields[i];

			if ( Ext.isEmpty( dataField.placement ) ) {
				dataField = Ext.apply( dataField, {
					placement: isVariableInAnyVariableSet( dataField, activities ) ? 'table' : 'form'
				} );
			}
		}
	}

	return dataFields;
}

function isVariableInAnyVariableSet( dataField, activities ) {
	if ( !Ext.isEmpty( activities ) ) {
		for ( var i = 0; i < activities.length; i++ ) {
			var activity = activities[i];
			var formVariables = activity.formVariables;

			if ( !Ext.isEmpty( formVariables ) ) {
				for ( var j = 0; j < formVariables.length; j++ ) {
					var formVariable = formVariables[j];

					if ( formVariable.genre == 'VARIABLE_SET' ) {
						var columns = formVariable.columns;

		                for ( var k = 0; k < columns.length; k++ ) {
		                    var column = columns[k];

		                    if ( column.varId == dataField.id ) {
		                        return true;
		                    }
		                }
					}
				}
			}
		}
	}

	return false;
}

function generateTemplateComponentIdsIfNecessary( templates ) {
	if ( !Ext.isEmpty( templates ) ) {
		for ( var i = 0; i < templates.length; i++ ) {
			var components = templates[i].components;

			if ( !Ext.isEmpty( components ) ) {
				for ( var j = 0; j < components.length; j++ ) {
					var component = components[j];

					if ( Ext.isEmpty( component.templateComponentId ) ) {
						component = Ext.apply( component, {
							templateComponentId: 'templateComponent' + ( j + 1 )
						} );
						components[j] = component;
					}
				}
			}
		}
	}

	return templates;
}

function assignTemplateComponentIdIfNecessary( processTemplates, activityTemplates ) {
	if ( !Ext.isEmpty( activityTemplates ) ) {
		for ( var i = 0; i < activityTemplates.length; i++ ) {
			var activityTemplate = activityTemplates[i];
			var activityTemplateComponents = activityTemplates[i].components;

			if ( !Ext.isEmpty( activityTemplateComponents ) ) {
				for ( var j = 0; j < activityTemplateComponents.length; j++ ) {
					var activityTemplateComponent = activityTemplateComponents[j];

					if ( Ext.isEmpty( activityTemplateComponent.templateComponentId ) ) {
						var processTemplateComponent = null;

						if ( !Ext.isEmpty( processTemplates ) ) {
							for ( var k = 0; k < processTemplates.length; k++ ) {
								var processTemplate = processTemplates[k];

								if ( processTemplate.id == activityTemplate.id ) {
									var processTemplateComponents = processTemplate.components;

									for ( var l = 0; l < processTemplateComponents.length; l++ ) {
										if ( processTemplateComponents[l].id == activityTemplateComponent.id ) {
											processTemplateComponent = processTemplateComponents[l];
											break;
										}
									}

									if ( !Ext.isEmpty( processTemplateComponent ) ) {
										break;
									}
								}
							}
						}

						if ( !Ext.isEmpty( processTemplateComponent ) ) {
							activityTemplateComponent = Ext.apply( activityTemplateComponent, {
								templateComponentId: processTemplateComponent.templateComponentId
							} );
							activityTemplateComponents[j] = activityTemplateComponent;
						}
					}
				}
			}
		}
	}

	return activityTemplates;
}

function handleParticipants( config ) {
    var ps = new Array();
    var eas = config.extendedAttributes ? config.extendedAttributes : new Array();
    var participantsOrder = config.participantsOrder.split( ';' );
    var localParticipantsTable = config.participants ? config.participants : [];
    var globalParticipantsTable = [].concat( packageParticipants );

    for ( var i = 0; i < participantsOrder.length; i++ ) {
        var participantId = participantsOrder[i];
        var missed = true;

        for ( var j = 0; j < localParticipantsTable.length; j++ ) {
            var p = localParticipantsTable[j];

            if ( participantId == p.roleId ) {
                ps.push( localParticipantsTable.splice( j, 1 )[0] );
                missed = false;
                break;
            }
        }

        if ( missed ) {
            for ( var j = 0; j < globalParticipantsTable.length; j++ ) {
                var p = globalParticipantsTable[j];

                if ( participantId == p.roleId ) {
                    var globalParticipant = globalParticipantsTable.splice( j, 1 )[0];
                    globalParticipant = Ext.apply( {
                        isGlobal: true
                    }, globalParticipant );

                    for ( var k = 0; k < eas.length; k++ ) {
                        var ea = eas[k];

                        if ( ea.NAME == 'GLOBAL_PARTICIPANT' ) {
                            var pDefSplit = ea.VALUE.split( ',' );
                            var pId = '';
                            var pWidth = -1;
                            var pHeight = -1;

                            for ( var l = 0; l < pDefSplit.length; l++ ) {
                                var pDef = pDefSplit[l];
                                var equalSplit = pDef.split( '=', -1 );
                                var confName = equalSplit[0];

                                switch ( confName ) {
                                    case 'GLOBAL_PARTICIPANT_ID':
                                        pId = equalSplit[1];
                                        break;
                                    case 'WIDTH':
                                        pWidth = parseInt( equalSplit[1] );
                                        break;
                                    case 'HEIGHT':
                                        pHeight = parseInt( equalSplit[1] );
                                        break;
                                    default:
                                        break;
                                }
                            }

                            if ( participantId == pId ) {
                                globalParticipant = Ext.apply( {
                                    roleWidth: pWidth,
                                    roleHeight: pHeight
                                }, globalParticipant );
                            }
                        }
                    }

                    ps.push( globalParticipant );
                    break;
                }
            }
        }
    }

    if ( !Ext.isEmpty( localParticipantsTable ) ) {
        ps = ps.concat( localParticipantsTable );
    }

    return ps;
}

function readXpdlProcessActivities( config, tasks ) {
    var activities = new Array();
    var rolesXLocationRelations = new Array();
    var rolesYLocationRelations = new Array();
    var mainPanel = Ext.getCmp( 'main_panel' );
    conditionTypes.clear();
    deadlineInfos.clear();
    transitionsOrder.clear();

    for ( var i = 0; i < tasks.length; i++ ) {
        var t = tasks[i];
        var actDef = new Object();
        var participantId = '';
        var isRoute = false;
        var isTool = false;
        var isSubflow = false;
        var descr = '';
        var nextActivity = false;
        var acceptedNextActivities = new Array();
        var acceptConcurrently = true;
        var acceptSequentially = false;
        var newDocumentAccept = false;
        var allowMultipleActiveActivities = false;
        var assignment = {
            type: 'role',
            value: '',
            filters: new Array(),
            exception: ''
        };
        var formVariables = new Array();
        var formButtons = new Array();
        var httpLinks = new Array();
        var applications = new Array();
        var dtButtons = new Array();
        var transitionRestriction = {
            join: 'XOR',
            split: 'XOR'
        };
        var autoUpdates = new Array();
        var deadlines = new Array();
        var acceptances = new Array();
        var subflow = {
            id: '',
            params: new Array()
        };
        var additionals = {
            defaults: new Array(),
            checkAppendices: new Array(),
            additionalJsChecks: new Array(),
            extraDataChooserConfigs: new Array()
        };
        var hasImplementationTool = false;
        var formActions = new Array();
        var eventActions = new Array();
        var formFormActions = new Array();
        var formEventActions = new Array();
        var labelActions = new Array();
        var validators = new Array();
        var validatorsTemplates = new Array();
        var variablesSetters = new Array();
        var variablesSettersTemplates = new Array();

        var els = t.Activity;
        for ( var j = 0; j < els.length; j++ ) {
            var el = els[j];

            if ( el.Id ) {
                actDef = Ext.apply( {
                    activityDefId: el.Id
                }, actDef );

                if ( el.Id.length > Ext.ux.suncode.Constants.ACTIVITY_DEF_ID_MAX_LENGTH ) {
                    var errorDescr = getTranslation( 'Zbyt długi identyfikator definicji zadania' );
                    errorDescr += ', ';
                    errorDescr += getTranslation( 'maksymalna długość' );
                    errorDescr += ': ';
                    errorDescr += Ext.ux.suncode.Constants.ACTIVITY_DEF_ID_MAX_LENGTH;
                    errorDescr += ' ';
                    errorDescr += getTranslation( 'znaków' );

                    Ext.ux.suncode.XpdlErrors.addError( {
                        object: getTranslation( 'Zadanie' ),
                        processDefId: config.initialProcessDefId,
                        activityDefId: el.Id,
                        descr: errorDescr,
                        correction: 'n/a'
                    } );
                }
            } else if ( el.Name ) {
                actDef = Ext.apply( {
                    activityName: decodeTextFromXpdl( el.Name )
                }, actDef );
            } else if ( el.Implementation ) {
                var appEls = el.Implementation;
                for ( var k = 0; k < appEls.length; k++ ) {
                    var appEl = appEls[k];

                    if ( appEl.Tool ) {
                        hasImplementationTool = true;
                        var toolDef = new Object();
                        var toolParams = new Array();
                        var toolCondition = null;
                        var toolCustomDescription = null;
                        var toolErrorHandling = null;
                        var toolInactive = false;
                        var toolCreationDate = null;
                        var toolModificationDate = null;

                        var toolEls = appEl.Tool;
                        for ( var l = 0; l < toolEls.length; l++ ) {
                            var toolEl = toolEls[l];

                            if ( toolEl.Id ) {
                                toolDef = Ext.apply( {
                                    id: toolEl.Id,
                                    name: processApplications.get( toolEl.Id ).name,
                                    appType: processApplications.get( toolEl.Id ).appType
                                }, toolDef );
                                break;
                            }
                        }

                        for ( var l = 0; l < toolEls.length; l++ ) {
                            var toolEl = toolEls[l];

                            if ( toolEl.ActualParameters ) {
                                var aParams = toolEl.ActualParameters;
                                for ( var m = 0; m < aParams.length; m++ ) {
                                    var aParam = aParams[m];
                                    var aParamValue = aParam.ActualParameter[0] ? decodeTextFromXpdl( aParam.ActualParameter[0].XPDLNODEVALUE ) : '';

                                    toolParams.push( {
                                        varId: aParamValue
                                    } );
                                }
                            } else if ( toolEl.ExtendedAttributes ) {
                            	var extAttrs = decomposeExtendedAttributes( toolEl.ExtendedAttributes );

                                for ( var m = 0; m < extAttrs.length; m++ ) {
                                    var ea = extAttrs[m];
                                    var eaName = ea.NAME;
                                    var eaValue = ea.VALUE;

                                    switch ( eaName ) {
                                        case 'PARAMETERS':
                                        	toolDef = Ext.apply( {
                                                integrationComponent: true
                                            }, toolDef );

                                        	toolParams = Ext.util.JSON.decode( decodeTextFromXpdl( eaValue ) );
                                        	break;
                                        case 'CONDITION':
                                        	toolCondition = Ext.util.JSON.decode( decodeTextFromXpdl( eaValue ) );
                                        	break;
                                        case 'CUSTOM_DESCRIPTION':
                                        	toolCustomDescription = decodeTextFromXpdl( eaValue );
                                        	break;
                                        case 'ERROR_HANDLER':
                                        	toolErrorHandling = Ext.util.JSON.decode( decodeTextFromXpdl( eaValue ) );
                                        	break;
                                        case 'INACTIVE':
                                        	if ( eaValue.toLowerCase() == 'true' ) {
                                        		toolInactive = true;
                                            }
                                        	break;
                                        case 'CREATION_DATE':
                                          toolCreationDate = decodeTextFromXpdl( eaValue );
                                          break;
                                        case 'MODIFICATION_DATE':
                                          toolModificationDate = decodeTextFromXpdl( eaValue );
                                          break;
                                        default:
                                        	break;
                                    }
                                }
                            }
                        }

                        toolDef = Ext.apply( {
                        	customDescription: toolCustomDescription,
                        	condition: toolCondition,
                        	errorHandling: toolErrorHandling,
                        	inactive: toolInactive,
                          creationDate: toolCreationDate,
                          modificationDate: toolModificationDate,
                          parameters: toolParams
                        }, toolDef );

                        applications.push( toolDef );
                    } else if ( appEl.SubFlow ) {
                        isSubflow = true;

                        var subFlowEls = appEl.SubFlow;
                        for ( var l = 0; l < subFlowEls.length; l++ ) {
                            var subFlowEl = subFlowEls[l];

                            if ( subFlowEl.Id ) {
                                subflow.id = subFlowEl.Id;
                            } else if ( subFlowEl.ActualParameters ) {
                                var subflowParams = new Array();

                                var sParams = subFlowEl.ActualParameters;
                                for ( var m = 0; m < sParams.length; m++ ) {
                                    var sParam = sParams[m];

                                    subflowParams.push( {
                                        actualParam: sParam.ActualParameter[0].XPDLNODEVALUE
                                    } );
                                }

                                subflow.params = subflowParams;
                            }
                        }
                    }
                }
            } else if ( el.TransitionRestrictions ) {
                var tr = el.TransitionRestrictions[0].TransitionRestriction;
                var connJoin = null;
                var connSplit = null;

                for ( var k = 0; k < tr.length; k++ ) {
                    var trEl = tr[k];

                    if ( trEl.Split ) {
                        connSplit = trEl.Split;
                    } else if ( trEl.Join ) {
                        connJoin = trEl.Join;
                    }
                }

                if ( connJoin ) {
                    var conditionType = connJoin[0].Type;
                    transitionRestriction.join = conditionType;
                }

                if ( connSplit ) {
                    var conditionType = connSplit[0].Type;
                    transitionRestriction.split = conditionType;
                    var refs = connSplit[1].TransitionRefs;

                    if ( refs ) {
                        var order = new Array();

                        for ( var k = 0; k < refs.length; k++ ) {
                            var transitionId = refs[k].TransitionRef[0].Id;
                            conditionTypes.put( transitionId, conditionType );
                            order.push( transitionId );
                        }

                        transitionsOrder.put( actDef.activityDefId, order );
                    }
                }
            } else if ( el.ExtendedAttributes ) {
                var extAttrs = decomposeExtendedAttributes( el.ExtendedAttributes );
                var addedFormVariablesIds = new HashMap();
                var xOffset = -1;
                var yOffset = -1;

                for ( var k = 0; k < extAttrs.length; k++ ) {
                    var ea = extAttrs[k];
                    var eaName = ea.NAME;
                    var eaValue = ea.VALUE;

                    switch ( eaName ) {
                        case 'JaWE_GRAPH_PARTICIPANT_ID':
                            if ( Ext.isEmpty( participantId ) ) {
                                if ( participantsTypes.get( eaValue ) == 'SYSTEM' ) {
                                    isTool = true;
                                } else if ( hasImplementationTool ) {
                                    Ext.ux.suncode.XpdlErrors.addError( {
                                        object: getTranslation( 'Zadanie' ),
                                        processDefId: config.initialProcessDefId,
                                        activityDefId: actDef.activityDefId,
                                        descr: getTranslation( 'Narzędzie nie jest wykonywane przez uczestnika typu "SYSTEM"' ),
                                        correction: getTranslation( 'Zmiana typu zadania' )
                                    } );
                                }
                                participantId = eaValue;
                            }
                            break;
                        case 'JaWE_GRAPH_OFFSET':
                            if ( Ext.isEmpty( actDef.x ) && Ext.isEmpty( actDef.y ) ) {
                                var xy = eaValue.split( ',' );
                                xOffset = parseInt( xy[0] );
                                yOffset = parseInt( xy[1] );
                                actDef = Ext.apply( {
                                    x: xOffset,
                                    y: yOffset
                                }, actDef );
                            }
                            break;
                        case 'VariableToProcess_VIEW':
                            eaValueSplit = eaValue.split( '\n' );
                            var varId = eaValueSplit[0];
                            var dataFieldDef = processDataFields.get( varId );

                            if ( dataFieldDef && !addedFormVariablesIds.get( varId ) ) {
                                formVariables.push( {
                                    varId: varId,
                                    name: dataFieldDef.name,
                                    type: dataFieldDef.type,
                                    hidden: false,
                                    editable: false,
                                    autoUpdates: new Array(),
                                    formActions: new Array(),
                                    eventActions: new Array(),
                                    genre: 'VARIABLE'
                                } );
                                addedFormVariablesIds.put( varId, true );
                            } else {
                                if ( dataFieldDef ) {
                                    Ext.ux.suncode.XpdlErrors.addError( {
                                        object: getTranslation( 'Zmienna formularza' ) + ': ' + varId,
                                        processDefId: config.initialProcessDefId,
                                        activityDefId: actDef.activityDefId,
                                        descr: getTranslation( 'Duplikat zmiennej formularza' ),
                                        correction: getTranslation( 'Usunięcie duplikatu' )
                                    } );
                                } else {
                                    Ext.ux.suncode.XpdlErrors.addError( {
                                        object: getTranslation( 'Zmienna formularza' ) + ': ' + varId,
                                        processDefId: config.initialProcessDefId,
                                        activityDefId: actDef.activityDefId,
                                        descr: getTranslation( 'Użycie nieistniejącej zmiennej procesu na formularzu' ),
                                        correction: getTranslation( 'Pominięcie zmiennej formularza' )
                                    } );
                                }
                            }
                            break;
                        case 'VariableToProcess_UPDATE':
                            eaValueSplit = eaValue.split( '\n' );
                            var varId = eaValueSplit[0];
                            var dataFieldDef = processDataFields.get( varId );

                            if ( dataFieldDef && !addedFormVariablesIds.get( varId ) ) {
                                var formVariableDef = {
                                    varId: varId,
                                    name: dataFieldDef.name,
                                    type: dataFieldDef.type,
                                    hidden: false,
                                    editable: true,
                                    autoUpdates: new Array(),
                                    formActions: new Array(),
                                    eventActions: new Array(),
                                    genre: 'VARIABLE'
                                };
                                if ( eaValueSplit.length > 1 ) {
                                    var roleusersFilters = new Array();
                                    var roleusersConjunction = false;

                                    for ( var l = 1; l < eaValueSplit.length; l++ ) {
                                        var equalSplit = eaValueSplit[l].split( '=' );

                                        if ( equalSplit.length > 1 ) {
                                            if ( equalSplit[0] == 'conjunction' ) {
                                              roleusersConjunction = parseBoolean( equalSplit[1] );
                                            } else {
                                              roleusersFilters.push( {
                                                type: equalSplit[0],
                                                value: equalSplit[1]
                                              } );
                                            }
                                        }
                                    }

                                    formVariableDef = Ext.apply( {
                                        roleusersFilters: roleusersFilters,
                                        roleusersConjunction: roleusersConjunction
                                    }, formVariableDef );
                                }
                                formVariables.push( formVariableDef );
                                addedFormVariablesIds.put( varId, true );
                            } else {
                                if ( dataFieldDef ) {
                                    Ext.ux.suncode.XpdlErrors.addError( {
                                        object: getTranslation( 'Zmienna formularza' ) + ': ' + varId,
                                        processDefId: config.initialProcessDefId,
                                        activityDefId: actDef.activityDefId,
                                        descr: getTranslation( 'Duplikat zmiennej formularza' ),
                                        correction: getTranslation( 'Usunięcie duplikatu' )
                                    } );
                                } else {
                                    Ext.ux.suncode.XpdlErrors.addError( {
                                        object: getTranslation( 'Zmienna formularza' ) + ': ' + varId,
                                        processDefId: config.initialProcessDefId,
                                        activityDefId: actDef.activityDefId,
                                        descr: getTranslation( 'Użycie nieistniejącej zmiennej procesu na formularzu' ),
                                        correction: getTranslation( 'Pominięcie zmiennej formularza' )
                                    } );
                                }
                            }
                            break;
                        case 'VariableToProcess_HIDDEN':
                            eaValueSplit = eaValue.split( '\n' );
                            var varId = eaValueSplit[0];
                            var dataFieldDef = processDataFields.get( varId );

                            if ( dataFieldDef && !addedFormVariablesIds.get( varId ) ) {
                                formVariables.push( {
                                    varId: varId,
                                    name: dataFieldDef.name,
                                    type: dataFieldDef.type,
                                    hidden: true,
                                    editable: true,
                                    autoUpdates: new Array(),
                                    formActions: new Array(),
                                    eventActions: new Array(),
                                    genre: 'VARIABLE'
                                } );
                                addedFormVariablesIds.put( varId, true );
                            } else {
                                if ( dataFieldDef ) {
                                    Ext.ux.suncode.XpdlErrors.addError( {
                                        object: getTranslation( 'Zmienna formularza' ) + ': ' + varId,
                                        processDefId: config.initialProcessDefId,
                                        activityDefId: actDef.activityDefId,
                                        descr: getTranslation( 'Duplikat zmiennej formularza' ),
                                        correction: getTranslation( 'Usunięcie duplikatu' )
                                    } );
                                } else {
                                    Ext.ux.suncode.XpdlErrors.addError( {
                                        object: getTranslation( 'Zmienna formularza' ) + ': ' + varId,
                                        processDefId: config.initialProcessDefId,
                                        activityDefId: actDef.activityDefId,
                                        descr: getTranslation( 'Użycie nieistniejącej zmiennej procesu na formularzu' ),
                                        correction: getTranslation( 'Pominięcie zmiennej formularza' )
                                    } );
                                }
                            }
                            break;
                        case 'VARIABLE_SET':
                            formVariables.push( handleVariableSet( config.initialProcessDefId, actDef.activityDefId, eaValue, false ) );
                            break;
                        case 'VARIABLE_SET_VIEW':
                            formVariables.push( handleVariableSet( config.initialProcessDefId, actDef.activityDefId, eaValue, true ) );
                            break;
                        case 'DT_BUTTON':
                            var dtButtonDef = handleDTButton( config.initialProcessDefId, actDef.activityDefId, eaValue );
                            dtButtons.push( dtButtonDef );
                            break;
                        case 'HTTP_LINK':
                            var hlDef = {
                                actionName: '',
                                buttonName: '',
                                destination: 'TASKFORM',
                                location: '',
                                type: '',
                                url: '',
                                color: '',
                                saveForm: false,
                                params: new Array(),
                                formActions: new Array(),
                                eventActions: new Array(),
                                genre: 'HTTP_LINK'
                            };

                            var httpLinkLines = eaValue.split( '\n' );

                            for ( var l = 0; l < httpLinkLines.length; l++ ) {
                                hlDef = handleHttpLinkConfLine( config.initialProcessDefId, actDef.activityDefId, hlDef, httpLinkLines[l] );
                            }

                            httpLinks.push( hlDef );
                            break;
                        case 'ACTIONBUTTON':
                            var hlDef = {
                                actionName: '',
                                buttonName: '',
                                destination: 'TASKFORM',
                                location: '',
                                type: '',
                                url: '',
                                color: '',
                                saveForm: false,
                                params: new Array(),
                                formActions: new Array(),
                                eventActions: new Array(),
                                genre: 'HTTP_LINK'
                            };

                            var actionButtonLines = eaValue.split( '\n' );

                            for ( var l = 0; l < actionButtonLines.length; l++ ) {
                                hlDef = handleActionButtonConfLine( config.initialProcessDefId, actDef.activityDefId, hlDef, actionButtonLines[l] );
                            }

                            httpLinks.push( hlDef );
                            break;
                        case 'ACTION_ACCEPT_BUTTON':
                            var btnDef = {
                                actionName: '',
                                buttonName: '',
                                jsAction: '',
                                checkForm: false,
                                saveBeforeAccept: false,
                                destination: '',
                                forwartTo: '',
                                icon: '',
                                color: '',
                                acceptConcurrently: '',
                                nextActivity: '',
                                acceptedNextActivities: new Array(),
                                filled: false,
                                hideFrame: false,
                                width: null,
                                height: null,
                                actions: new Array(),
                                dcIncludes: new Array(),
                                dcExcludes: new Array(),
                                validators: new Array(),
                                oldValidators: new Array(),
                                validatorsTemplates: new Array(),
                                variablesSetters: new Array(),
                                oldVariablesSetters: new Array(),
                                variablesSettersTemplates: new Array(),
                                formActions: new Array(),
                                eventActions: new Array(),
                                genre: eaName
                            };

                            var acceptBtnLines = eaValue.split( '\n' );

                            for ( var l = 0; l < acceptBtnLines.length; l++ ) {
                                btnDef = handleAcceptBtnConfLine( config.initialProcessDefId, actDef.activityDefId, btnDef, acceptBtnLines[l] );
                            }

                            formButtons.push( btnDef );
                            break;
                        case 'GENERATE_PDF_BUTTON':
                            var btnDef = {
                                actionName: '',
                                buttonName: '',
                                docClassName: '',
                                templateName: '',
                                color: '',
                                checkForm: false,
                                genre: eaName
                            };

                            var generatePdfBtnLines = eaValue.split( '\n' );

                            for ( var l = 0; l < generatePdfBtnLines.length; l++ ) {
                                btnDef = handleGeneratePdfBtnConfLine( config.initialProcessDefId, actDef.activityDefId, btnDef,
                                                generatePdfBtnLines[l] );
                            }

                            btnDef.actionName = generateId( btnDef.buttonName );

                            formButtons.push( btnDef );
                            break;
                        case 'ADD_FILE_BUTTON':
                            var btnDef = {
                                actionName: '',
                                buttonName: '',
                                icon: '',
                                color: '',
                                docClassName: '',
                                sourceName: '',
                                checkForm: false,
                                genre: eaName
                            };

                            var addFileBtnLines = eaValue.split( '\n' );

                            for ( var l = 0; l < addFileBtnLines.length; l++ ) {
                                btnDef = handleAddFileBtnConfLine( config.initialProcessDefId, actDef.activityDefId, btnDef, addFileBtnLines[l] );
                            }

                            btnDef.actionName = generateId( btnDef.buttonName );

                            formButtons.push( btnDef );
                            break;
                        case 'BARCODE_PRINT':
                            var btnDef = {
                                actionName: 'drukuj_kod_kreskowy',
                                buttonName: getTranslation( 'Drukuj kod kreskowy' ),
                                labelPath: '',
                                labelTextVar: '',
                                color: '',
                                checkForm: false,
                                genre: eaName
                            };

                            var barcodePrintBtnLines = eaValue.split( '\n' );

                            for ( var l = 0; l < barcodePrintBtnLines.length; l++ ) {
                                btnDef = handleBarcodePrintBtnConfLine( config.initialProcessDefId, actDef.activityDefId, btnDef,
                                                barcodePrintBtnLines[l] );
                            }

                            formButtons.push( btnDef );
                            break;
                        case 'NEXT_ACTIVITY':
                            nextActivity = true;

                            if ( !Ext.isEmpty( eaValue ) ) {
                                var enterSplit = eaValue.split( '\n' );

                                for ( var l = 0; l < enterSplit.length; l++ ) {
                                    acceptedNextActivities.push( {
                                        activityDefId: enterSplit[l]
                                    } );
                                }
                            }
                            break;
                        case 'ACCEPT_CONCURRENTLY':
                            acceptConcurrently = parseBoolean( eaValue );
                            break;
                        case 'ACCEPT_SEQUENTIALLY':
                            acceptSequentially = parseBoolean( eaValue );
                            break;
                        case 'NEW_DOCUMENT_ACCEPT':
                            newDocumentAccept = parseBoolean( eaValue );
                            break;
                        case 'CONFIGURATION':
                            var enterSplit = eaValue.split( '\n' );

                            for ( var l = 0; l < enterSplit.length; l++ ) {
                                var equalSplit = enterSplit[l].split( '=' );
                                var configOption = equalSplit[0];

                                switch ( configOption ) {
                                    case 'allowMultipleActiveActivities':
                                        allowMultipleActiveActivities = parseBoolean( equalSplit[1] );
                                        break;
                                    default:
                                        break;
                                }
                            }
                            break;
                        case 'SET_ASSIGNMENT':
                            var enterSplit = eaValue.split( '\n' );
                            var assignSplit = enterSplit[0].split( '=' );
                            var assignmentType = handleAssignmentType( assignSplit[0] );
                            assignment.type = assignmentType;
                            assignment.value = assignmentType != 'role' ? assignSplit[1] : '';
                            var startIndex = assignmentType != 'role' ? 1 : 0;

                            for ( var l = startIndex; l < enterSplit.length; l++ ) {
                                var equalSplit = enterSplit[l].split( '=' );
                                var equalSplitType = equalSplit[0];

                                switch ( equalSplitType ) {
                                    case 'Exception':
                                        if ( !Ext.isEmpty( equalSplit[1] ) ) {
                                            assignment.exception = equalSplit[1];
                                        }
                                        break;
                                    case 'ou':
                                    case 'OU':
                                    case 'ou_direct':
                                    case 'OU_DIRECT':
                                    case 'ou_symbol':
                                    case 'OU_SYMBOL':
                                    case 'ou_direct_symbol':
                                    case 'OU_DIRECT_SYMBOL':
                                        if ( !Ext.isEmpty( equalSplit[1] ) ) {
                                            assignment.filters.push( {
                                                type: equalSplitType.toLowerCase(),
                                                value: equalSplit[1]
                                            } );
                                        }
                                        break;
                                    default:
                                        Ext.ux.suncode.XpdlErrors.addError( {
                                            object: getTranslation( 'Przypisanie zadania' ),
                                            processDefId: config.initialProcessDefId,
                                            activityDefId: actDef.activityDefId,
                                            descr: getTranslation( 'Nieznany parametr konfiguracyjny' ) + ': ' + equalSplitType,
                                            correction: getTranslation( 'Usunięcie parametru' )
                                        } );
                                        break;
                                }
                            }
                            break;
                        case 'AUTO_UPDATE':
                            var auDef = {
                                actionsource: '',
                                datasource: '',
                                destination: '',
                                taskName: '',
                                eventType: 'blur'
                            };

                            var autoUpdateLines = eaValue.split( '\n' );

                            for ( var l = 0; l < autoUpdateLines.length; l++ ) {
                                auDef = handleAutoUpdateConfLine( config.initialProcessDefId, actDef.activityDefId, auDef, autoUpdateLines[l] );
                            }

                            autoUpdates.push( auDef );
                            break;
                        case 'CHECK_ACCEPTATION':
                            var acceptanceDef = {
                                id: Ext.id(),
                                acceptVar: '',
                                acceptVarValue: '',
                                checkVar: '',
                                checkVarValue: '',
                                resultVar: '',
                                buttonName: ''
                            };

                            var acceptanceLines = eaValue.split( '\n' );

                            for ( var l = 0; l < acceptanceLines.length; l++ ) {
                                acceptanceDef = handleAcceptanceConfLine( config.initialProcessDefId, actDef.activityDefId, acceptanceDef,
                                                acceptanceLines[l] );
                            }

                            acceptances.push( acceptanceDef );
                            break;
                        case 'SET_DEFAULT':
                            var defaultsSplit = eaValue.split( '=', 2 );
                            additionals.defaults.push( {
                                varId: defaultsSplit[0],
                                varValue: decodeTextFromXpdl( defaultsSplit[1] )
                            } );
                            break;
                        case 'CHECK_APPENDICES':
                            var checkAppendicesLines = eaValue.split( '\n' );

                            for ( var l = 0; l < checkAppendicesLines.length; l++ ) {
                                additionals.checkAppendices.push( {
                                    docClassName: decodeTextFromXpdl( checkAppendicesLines[l] )
                                } );
                            }
                            break;
                        case 'ADDITIONAL_JS_CHECK':
                            var additionalJsCheck = decodeTextFromXpdl( eaValue );
                            if ( additionalJsCheck.endsWith( '()' ) ) {
                                additionalJsCheck = additionalJsCheck.substring( 0, additionalJsCheck.length - 2 );
                            }

                            additionals.additionalJsChecks.push( {
                                additionalJsCheck: additionalJsCheck
                            } );
                            break;
                        case 'DATA_CHOOSER':
                            var extraConfig = handleExtraDataChooserConfig( config.initialProcessDefId, actDef.activityDefId, eaValue );

                            if ( extraConfig ) {
                                additionals.extraDataChooserConfigs.push( extraConfig );
                            }
                            break;
                        case 'ACTIONS':
                            formActions = Ext.util.JSON.decode( decodeTextFromXpdl( eaValue ) );
                            break;
                        case 'EVENTS':
                            eventActions = Ext.util.JSON.decode( decodeTextFromXpdl( eaValue ) );
                            break;
                        case 'VALIDATORS':
                            validators = Ext.util.JSON.decode( decodeTextFromXpdl( eaValue ) );
                            break;
                        case 'VALIDATOR_TEMPLATES':
                        	  validatorsTemplates = Ext.util.JSON.decode( decodeTextFromXpdl( eaValue ) )
                        	  break;
                        case 'VARIABLES_SETTERS':
                            variablesSetters = Ext.util.JSON.decode( decodeTextFromXpdl( eaValue ) );
                            break;
                        case 'VARIABLES_SETTER_TEMPLATES':
                        	  variablesSettersTemplates = Ext.util.JSON.decode( decodeTextFromXpdl( eaValue ) )
                        	  break;
                        default:
                            Ext.ux.suncode.XpdlErrors.addError( {
                                object: getTranslation( 'Zadanie' ),
                                processDefId: config.initialProcessDefId,
                                activityDefId: actDef.activityDefId,
                                descr: getTranslation( 'Nieznany atrybut rozszerzony' ) + ': ' + eaName,
                                correction: getTranslation( 'Pominięcie atrybutu' )
                            } );
                            break;
                    }
                }

                if ( !rolesXLocationRelations[participantId] || rolesXLocationRelations[participantId] < xOffset ) {
                    rolesXLocationRelations[participantId] = xOffset;
                }
                if ( !rolesYLocationRelations[participantId] || rolesYLocationRelations[participantId] < yOffset ) {
                    rolesYLocationRelations[participantId] = yOffset;
                }
            } else if ( el.Deadline ) {
                var deadlineEls = el.Deadline;
                var deadline = {
                    exceptionName: '',
                    execution: '',
                    varId: '',
                    amount: '',
                    unit: '',
                    condition: ''
                };

                for ( var k = 0; k < deadlineEls.length; k++ ) {
                    var deadlineEl = deadlineEls[k];

                    if ( deadlineEl.DeadlineCondition ) {
                        var deadlineCond = decodeTextFromXpdl( deadlineEl.DeadlineCondition[0].XPDLNODEVALUE );
                        var sharkPackageTag = 'Packages.com.suncode.pwfl.shark.Deadlines.';

                        if ( deadlineCond.indexOf( sharkPackageTag ) != -1 ) {
                          var sharkPackageIdx = deadlineCond.indexOf( sharkPackageTag );
                          var openBracketIdx = deadlineCond.indexOf( '(', sharkPackageIdx + sharkPackageTag.length );
                          var unit = deadlineCond.substring( sharkPackageIdx + sharkPackageTag.length, openBracketIdx - 1 );
                          var unitFound = false;
                          var deadlineVarId = '';
                          var amount = '';
                          var skipWeekends = false;
                          var skipHolidays = false;

                          switch( unit ) {
                            case 'second':
                            case 'minute':
                            case 'hour':
                            case 'day':
                            case 'week':
                            case 'month':
                              unitFound = true;
                              break;
                            default:
                               break;
                          }

                          var closeBracketIdx = deadlineCond.indexOf( ')', openBracketIdx + 1 );
                          var deadlineParameters = deadlineCond.substring( openBracketIdx + 1, closeBracketIdx );
                          var splittedDeadlineParameters = deadlineParameters.split( ',' );

                          if ( splittedDeadlineParameters.length == 4 ) {
                            deadlineVarId = splittedDeadlineParameters[0];
                            amount = splittedDeadlineParameters[1];
                            skipWeekends = parseBoolean( splittedDeadlineParameters[2] );
                            skipHolidays = parseBoolean( splittedDeadlineParameters[3] );
                          }

                          if ( unitFound && isCorrectDeadlineVariable( deadlineVarId ) && isInteger( amount ) ) {
                            deadline.varId = deadlineVarId;
                            deadline.amount = amount;
                            deadline.unit = unit;
                            deadline.skipWeekends = skipWeekends;
                            deadline.skipHolidays = skipHolidays;
                          } else {
                            deadline.condition = deadlineCond;
                          }
                        } else {
                          var setTimeTag = '.setTime(';
                          var getTimeTag = '.getTime()';
                          var thousandTag = '1000';
                          var setTimeIdx = deadlineCond.indexOf( setTimeTag );
                          var getTimeIdx = deadlineCond.indexOf( getTimeTag );
                          var bracketIdx = deadlineCond.indexOf( ')', getTimeIdx + getTimeTag.length );
                          var addedTime = deadlineCond.substring( getTimeIdx + getTimeTag.length, bracketIdx );
                          var amount = addedTime.substring( addedTime.lastIndexOf( '*' ) + 1, addedTime.length );
                          var deadlineVarId = deadlineCond.substring( setTimeIdx + setTimeTag.length, getTimeIdx );
                          var thousandIdx = addedTime.indexOf( thousandTag );
                          var unit = addedTime.substring( thousandIdx, addedTime.length - amount.length );
                          var skipWeekends = false;
                          var skipHolidays = false;
                          var unitFound = true;

                          switch ( unit ) {
                            case '1000*':
                              deadline.unit = 'second';
                              break;
                            case '1000*60*':
                              deadline.unit = 'minute';
                              break;
                            case '1000*3600*':
                            case '1000*60*60*':
                              deadline.unit = 'hour';
                              break;
                            case '1000*3600*24*':
                            case '1000*60*60*24*':
                              deadline.unit = 'day';
                              break;
                            case '1000*3600*24*7*':
                            case '1000*60*60*24*7*':
                              deadline.unit = 'week';
                              break;
                            case '1000*3600*24*30*':
                            case '1000*60*60*24*30*':
                              deadline.unit = 'month';
                              break;
                            default:
                              unitFound = false;
                              break;
                          }

                          if ( unitFound && isCorrectDeadlineVariable( deadlineVarId ) && isInteger( amount )
                              && deadlineCond.indexOf( setTimeTag, getTimeIdx ) == -1 ) {
                            deadline.varId = deadlineVarId;
                            deadline.amount = amount;
                            deadline.skipWeekends = skipWeekends;
                            deadline.skipHolidays = skipHolidays;
                          } else {
                            deadline.condition = deadlineCond;
                          }
                        }
                    } else if ( deadlineEl.Execution ) {
                        deadline.execution = deadlineEl.Execution;
                    } else if ( deadlineEl.ExceptionName && deadlineEl.ExceptionName[0] ) {
                        if ( deadlineEl.ExceptionName[0] && deadlineEl.ExceptionName[0].XPDLNODEVALUE ) {
                            deadline.exceptionName = deadlineEl.ExceptionName[0].XPDLNODEVALUE;
                        }
                    }
                }

                if ( Ext.isEmpty( deadline.exceptionName ) ) {
                    deadline.exceptionName = 'Deadline_' + Ext.id();
                }

                deadlines.push( deadline );
                deadlineInfos.put( deadline.exceptionName, {
                  execution: deadline.execution,
                  activityDefId: actDef.activityDefId
                } );
            } else if ( el.Description ) {
                descr = decodeTextFromXpdl( el.Description[0].XPDLNODEVALUE );
            } else if ( el.Route ) {
                isRoute = true;
            } else if ( el.Documentation ) {
                Ext.ux.suncode.XpdlErrors.addError( {
                    object: getTranslation( 'Element "Documentation"' ),
                    processDefId: config.initialProcessDefId,
                    activityDefId: actDef.activityDefId,
                    descr: getTranslation( 'Dokumentacja została przeniesiona do specyfikacji zadania' ),
                    correction: getTranslation( 'Pominięcie elementu' )
                } );
            }
        }

        for ( var j = 0; j < dtButtons.length; j++ ) {
            var dtb = dtButtons[j];
            var vsId = dtb.vsId;
            var vsConnectionTable = dtb.vsConnection.split( ';' );
            vsConnectionTable.sort( function( a, b ) {
                return a > b;
            } );
            var vsConnection = vsConnectionTable.join( ';' );
            var attached = false;

            for ( var k = 0; k < formVariables.length; k++ ) {
                var fv = formVariables[k];

                if ( fv.type == 'VARIABLE_SET' ) {
                    if ( fv.varId == vsId ) {
                        fv.DTButtons.push( dtb );
                        attached = true;
                        break;
                    } else {
                        var sortedVsCols = [].concat( fv.columns );
                        sortedVsCols.sort( function( a, b ) {
                            return a.varId > b.varId;
                        } );
                        var thisVsConnection = '';

                        for ( var l = 0; l < sortedVsCols.length; l++ ) {
                            if ( l == sortedVsCols.length - 1 ) {
                                thisVsConnection += sortedVsCols[l].varId;
                            } else {
                                thisVsConnection += sortedVsCols[l].varId + ';';
                            }
                        }

                        if ( thisVsConnection == vsConnection ) {
                            dtb.vsId = fv.varId;
                            fv.DTButtons.push( dtb );
                            attached = true;
                            break;
                        }
                    }
                }
            }

            if ( !attached ) {
                Ext.ux.suncode.XpdlErrors.addError( {
                    object: getTranslation( 'Przycisk w tabeli dynamicznej' ) + ': ' + dtb.name,
                    processDefId: config.initialProcessDefId,
                    activityDefId: actDef.activityDefId,
                    descr: getTranslation( 'Brak odpowiadającej tabeli dynamicznej' ),
                    correction: getTranslation( 'Pominięcie przycisku' )
                } );
            }
        }

        for ( var j = 0; j < autoUpdates.length; j++ ) {
            var au = autoUpdates[j];
            var varIds = au.actionsource.split( ',' );

            for ( var k = 0; k < varIds.length; k++ ) {
                var varId = varIds[k];

                for ( var l = 0; l < formVariables.length; l++ ) {
                    var fv = formVariables[l];

                    if ( fv.varId == varId ) {
                        var auDef = {
                            id: '',
                            taskNameType: '',
                            taskName: '',
                            eventType: '',
                            buttonName: '',
                            dataSources: new Array(),
                            destinations: new Array()
                        };
                        auDef.eventType = au.eventType;
                        auDef.buttonName = au.buttonName;

                        var dss = au.datasource.split( ',' );
                        for ( var m = 0; m < dss.length; m++ ) {
                            auDef.dataSources.push( {
                                varId: dss[m]
                            } );
                        }

                        var dests = new Array();
                        if ( au.destination.indexOf( ',' ) != -1 ) {
                            dests = au.destination.split( ',' );
                        } else {
                            dests = au.destination.split( ';' );
                        }

                        for ( var m = 0; m < dests.length; m++ ) {
                            if ( processDataFields.get( dests[m] ) ) {
                                auDef.destinations.push( {
                                    varId: dests[m]
                                } );
                            }
                        }

                        if ( au.eventType.toLowerCase() == 'applet' ) {
                            auDef.taskName = au.taskName;
                            auDef.taskNameType = 'Applet';
                        } else {
                            if ( au.taskName.endsWith( '.do' ) ) {
                                auDef.taskName = au.taskName.substring( 0, au.taskName.lastIndexOf( '.do' ) );
                                auDef.taskNameType = 'Struts';
                            } else if ( au.taskName.endsWith( '.customServlet' ) ) {
                                auDef.taskName = au.taskName.substring( 0, au.taskName.lastIndexOf( '.customServlet' ) );
                                auDef.taskNameType = 'Servlet';
                            } else if ( au.taskName.startsWith( 'api/' ) ) {
                                var restfulPrefix = 'api/';
                                auDef.taskName = au.taskName.substring( restfulPrefix.length, au.taskName.length );
                                auDef.taskNameType = 'RESTful';
                            }
                        }

                        auDef.id = generateAutoUpdateId( auDef );
                        fv.autoUpdates.push( auDef );

                        break;
                    }
                }
            }
        }

        for ( var j = 0; j < formActions.length; j++ ) {
            var formAction = formActions[j];
            var target = formAction.target;
            var globalId = formAction.globalId;

            if ( !Ext.isEmpty( target ) ) {
                switch ( target.type ) {
                    case Ext.ux.suncode.IntegrationComponentService.FORM_DESTINATION:
                        formFormActions.push( {
                            id: formAction.id,
                            customDescription: formAction.customDescription,
                            condition: formAction.condition,
                            inactive: formAction.inactive,
                            creationDate: formAction.creationDate,
                            modificationDate: formAction.modificationDate,
                            parameters: formAction.parameters
                        } );
                        break;
                    case Ext.ux.suncode.IntegrationComponentService.VARIABLE_DESTINATION:
                    case Ext.ux.suncode.IntegrationComponentService.VARIABLE_SET_DESTINATION:
                        for ( var k = 0; k < formVariables.length; k++ ) {
                            var fv = formVariables[k];

                            if ( target.id == fv.varId ) {
                                fv.formActions.push( {
                                    id: formAction.id,
                                    customDescription: formAction.customDescription,
                                    condition: formAction.condition,
                                    inactive: formAction.inactive,
                                    creationDate: formAction.creationDate,
                                    modificationDate: formAction.modificationDate,
                                    globalId: formAction.globalId,
                                    parameters: formAction.parameters
                                } );
                                break;
                            }
                        }
                        break;
                    case Ext.ux.suncode.IntegrationComponentService.BUTTON_DESTINATION:
                        for ( var k = 0; k < formButtons.length; k++ ) {
                            var button = formButtons[k];

                            if ( button.genre == 'ACTION_ACCEPT_BUTTON' && target.id == button.actionName ) {
                                button.formActions.push( {
                                    id: formAction.id,
                                    customDescription: formAction.customDescription,
                                    condition: formAction.condition,
                                    inactive: formAction.inactive,
                                    creationDate: formAction.creationDate,
                                    modificationDate: formAction.modificationDate,
                                    parameters: formAction.parameters
                                } );
                                break;
                            }
                        }
                        for ( var k = 0; k < httpLinks.length; k++ ) {
                            var button = httpLinks[k];

                            if ( target.id == button.actionName ) {
                                button.formActions.push( {
                                    id: formAction.id,
                                    customDescription: formAction.customDescription,
                                    condition: formAction.condition,
                                    inactive: formAction.inactive,
                                    modificationDate: formAction.modificationDate,
                                    parameters: formAction.parameters
                                } );
                                break;
                            }
                        }
                        break;
                    case Ext.ux.suncode.IntegrationComponentService.DT_BUTTON_DESTINATION:
                      for ( var k = 0; k < formVariables.length; k++ ) {
                        var fv = formVariables[k];

                        if ( fv.genre == 'VARIABLE_SET' && !Ext.isEmpty( fv.DTButtons ) ) {
                          var variableSetDtButtons = fv.DTButtons;

                          for ( var l = 0; l < variableSetDtButtons.length; l++ ) {
                            var variableSetDtButton = variableSetDtButtons[l];

                            if ( target.id == variableSetDtButton.buttonId ) {
                              variableSetDtButton.formActions.push( {
                                id: formAction.id,
                                customDescription: formAction.customDescription,
                                condition: formAction.condition,
                                inactive: formAction.inactive,
                                modificationDate: formAction.modificationDate,
                                globalId: formAction.globalId,
                                parameters: formAction.parameters
                              } );
                              break;
                            }
                          }
                        }
                      }
                      break;
                    case Ext.ux.suncode.IntegrationComponentService.LABEL_DESTINATION:
                    	var added = false;
                    	var formActionDef = {
                			id: formAction.id,
                			customDescription: formAction.customDescription,
                			condition: formAction.condition,
                			inactive: formAction.inactive,
                        modificationDate: formAction.modificationDate,
                        globalId: formAction.globalId,
                			parameters: formAction.parameters
                		};

                    	for ( var k = 0; k < labelActions.length; k++ ) {
                    		if ( labelActions[k].labelId == target.id ) {
                    			labelActions[k].formActions.push( formActionDef );
                    			added = true;
                    			break;
                    		}
                    	}

                    	if ( !added ) {
                    		labelActions.push( {
                				labelId: target.id,
                				formActions: [ formActionDef ]
                			} );
                    	}
                        break;
                    default:
                        break;
                }
            }
        }

        if ( !Ext.isEmpty( eventActions.FORM ) ) {
          formEventActions = handleEventActions( eventActions.FORM, null );
        }
        if ( !Ext.isEmpty( eventActions.VARIABLE ) ) {
          distributeEventActions( eventActions.VARIABLE, formVariables, 'varId' );
        }
        if ( !Ext.isEmpty( eventActions.GRID ) ) {
          distributeEventActions( eventActions.GRID, formVariables, 'varId' );
        }
        if ( !Ext.isEmpty( eventActions.DT_BUTTON ) ) {
          distributeEventActions( eventActions.DT_BUTTON, dtButtons, 'buttonId' );
        }
        if ( !Ext.isEmpty( eventActions.ACTION_BUTTON ) ) {
          distributeEventActions( eventActions.ACTION_BUTTON, httpLinks, 'actionName' );
        }
        if ( !Ext.isEmpty( eventActions.ACCEPT_BUTTON ) ) {
          distributeEventActions( eventActions.ACCEPT_BUTTON, formButtons, 'actionName' );
        }

        for ( var j = 0; j < validators.length; j++ ) {
            var validator = validators[j];
            var action = validator.action;

            if ( !Ext.isEmpty( action ) ) {
            	for ( var k = 0; k < formButtons.length; k++ ) {
                    var button = formButtons[k];

                    if ( action == button.actionName ) {
                        button.validators.push( {
                            id: validator.id,
                            customDescription: validator.customDescription,
                            condition: validator.condition,
                            confirmation: validator.confirmation,
                            error: validator.error,
                            inactive: validator.inactive,
                            modificationDate: validator.modificationDate,
                            parameters: validator.parameters
                        } );
                        break;
                    }
                }
            }
        }

        for ( var j = 0; j < validatorsTemplates.length; j++ ) {
            var validatorsTemplate = validatorsTemplates[j];
            var action = validatorsTemplate.action;

            if ( !Ext.isEmpty( action ) ) {
            	for ( var k = 0; k < formButtons.length; k++ ) {
                    var button = formButtons[k];

                    if ( action == button.actionName ) {
                        button.validatorsTemplates.push( {
                            id: validatorsTemplate.id,
                            components: validatorsTemplate.components
                        } );
                        break;
                    }
                }
            }
        }

        for ( var j = 0; j < variablesSetters.length; j++ ) {
            var variablesSetter = variablesSetters[j];
            var action = variablesSetter.action;

            if ( !Ext.isEmpty( action ) ) {
            	for ( var k = 0; k < formButtons.length; k++ ) {
                    var button = formButtons[k];

                    if ( action == button.actionName ) {
                        button.variablesSetters.push( {
                            id: variablesSetter.id,
                            customDescription: variablesSetter.customDescription,
                            condition: variablesSetter.condition,
                            inactive: variablesSetter.inactive,
                            modificationDate: variablesSetter.modificationDate,
                            parameters: variablesSetter.parameters
                        } );
                        break;
                    }
                }
            }
        }

        for ( var j = 0; j < variablesSettersTemplates.length; j++ ) {
            var variablesSettersTemplate = variablesSettersTemplates[j];
            var action = variablesSettersTemplate.action;

            if ( !Ext.isEmpty( action ) ) {
            	for ( var k = 0; k < formButtons.length; k++ ) {
                    var button = formButtons[k];

                    if ( action == button.actionName ) {
                        button.variablesSettersTemplates.push( {
                            id: variablesSettersTemplate.id,
                            components: variablesSettersTemplate.components
                        } );
                        break;
                    }
                }
            }
        }

        actDef = Ext.apply( {
            participantId: participantId,
            isRoute: isRoute,
            isTool: isTool,
            isSubflow: isSubflow,
            descr: descr,
            nextActivity: nextActivity,
            acceptedNextActivities: acceptedNextActivities,
            acceptConcurrently: nextActivity ? false : acceptConcurrently,
            acceptSequentially: acceptSequentially,
            newDocumentAccept: newDocumentAccept,
            allowMultipleActiveActivities: allowMultipleActiveActivities,
            assignment: assignment,
            formVariables: formVariables,
            formButtons: formButtons,
            httpLinks: httpLinks,
            applications: applications,
            transitionRestriction: transitionRestriction,
            deadlines: deadlines,
            acceptances: acceptances,
            subflow: subflow,
            additionals: additionals,
            labelActions: labelActions,
            formFormActions: formFormActions,
            formEventActions: formEventActions,
            validatorsTemplates: validatorsTemplates,
            variablesSettersTemplates: variablesSettersTemplates
        }, actDef );

        activities.push( actDef );
    }

    config = Ext.apply( {
        activities: activities,
        rolesXLocationRelations: rolesXLocationRelations,
        rolesYLocationRelations: rolesYLocationRelations
    }, config );

    return config;
}

function distributeEventActions( events, elements, idKey ) {
  Ext.iterate( events, function( elementId, eventNamesWithActions, all ) {
    for ( var i = 0; i < elements.length; i++ ) {
      var element = elements[i];

      if ( elementId == element[idKey] ) {
        element.eventActions = element.eventActions.concat( handleEventActions( eventNamesWithActions ) );
        break;
      }
    }
  } );
}

function handleEventActions( eventNamesWithActions, eventParentId ) {
  var elementEventActions = new Array();

  Ext.iterate( eventNamesWithActions, function( eventName, eventActions, allEventNames ) {
    Ext.each( eventActions, function( eventAction, index, allEventAction ) {
      var action = eventAction.action;
      var eventOwnerId = eventAction.id;
      var globalId = eventAction.globalId;

      elementEventActions.splice( index, 0, {
        id: action.id,
        eventName: eventName,
        eventOwnerId: eventOwnerId,
        eventParentId: !Ext.isEmpty( eventParentId ) ? eventParentId : null,
        customDescription: action.customDescription,
        condition: action.condition,
        inactive: action.inactive,
        modificationDate: action.modificationDate,
        globalId: globalId,
        parameters: action.parameters
      } );

      if ( !Ext.isEmpty( eventAction.on ) ) {
        elementEventActions = elementEventActions.concat( handleEventActions( eventAction.on, eventOwnerId ) );
      }
    } );
  } );

  return elementEventActions;
}

function handleAcceptBtnConfLine( processDefId, activityDefId, btnDef, line ) {
    var lineSplit = line.split( '=', -1 );
    var confName = lineSplit[0];

    if ( confName.isAcceptBtnAction() ) {
        var connectedLineSplit = connectEqualSplit( lineSplit );
        var comaSplit = connectedLineSplit.split( ',' );
        var attributions = new Array();

        for ( var i = 0; i < comaSplit.length; i++ ) {
            var secondEqualSplit = comaSplit[i].split( '=', -1 );

            attributions.push( {
                varId: secondEqualSplit[0],
                value: secondEqualSplit[1]
            } );
        }

        btnDef.actions.push( {
            attributions: attributions,
            conditions: []
        } );

        return btnDef;
    }

    switch ( confName ) {
        case 'actionName':
            btnDef.actionName = lineSplit[1];
            break;
        case 'buttonName':
            btnDef.buttonName = decodeTextFromXpdl( connectEqualSplit( lineSplit ) );
            break;
        case 'tooltip':
          btnDef.tooltip = decodeTextFromXpdl( connectEqualSplit( lineSplit ) );
          break;
        case 'jsAction':
            var jsAction = decodeTextFromXpdl( lineSplit[1] );
            if ( jsAction.endsWith( '()' ) ) {
                jsAction = jsAction.substring( 0, jsAction.length - 2 );
            }

            btnDef.jsAction = jsAction;
            break;
        case 'checkForm':
            btnDef.checkForm = parseBoolean( lineSplit[1] );
            break;
        case 'saveBeforeAccept':
          btnDef.saveBeforeAccept = parseBoolean( lineSplit[1] );
          break;
        case 'destination':
            btnDef.destination = lineSplit[1];
            break;
        case 'forwardTo':
            btnDef.forwardTo = lineSplit[1];
            break;
        case 'acceptConcurrently':
            btnDef.acceptConcurrently = lineSplit[1];
            break;
        case 'nextActivity':
        	var nextActivityValue = lineSplit[1];

        	if ( nextActivityValue == 'true' || nextActivityValue == 'false' ) {
        		btnDef.nextActivity = nextActivityValue;
        	} else {
        		var acceptedNextActivities = new Array();
        		var semicolonSplit = nextActivityValue.split( ';' );

        	    for ( var i = 0; i < semicolonSplit.length; i++ ) {
        	        var oneSplit = semicolonSplit[i];

        	        acceptedNextActivities.push( {
                        activityDefId: oneSplit
                    } );
        	    }

        	    btnDef.nextActivity = 'true';
        	    btnDef.acceptedNextActivities = acceptedNextActivities;
        	}
            break;
        case 'condition':
        case 'Condition':
            var indexOfEqual = line.indexOf( '=' );
            var andSplit = line.substring( indexOfEqual + 1 ).split( 'AND' );
            var operatorsStart = [ '==', '<=', '>=', '!=', '<', '>' ];
            var conditions = new Array();

            Ext.each( andSplit, function( el, idx, els ) {
                el = decodeTextFromXpdl( el );
                var indexOfOperatorStart = -1;
                var operator = '';

                for ( var i = 0; i < operatorsStart.length; i++ ) {
                    indexOfOperatorStart = el.indexOf( operatorsStart[i] );

                    if ( indexOfOperatorStart != -1 ) {
                        operator = operatorsStart[i];
                        break;
                    }
                }

                var value = el.substring( indexOfOperatorStart + operator.length, el.length );
                value = value.replaceAll( '\'', '' );

                conditions.push( {
                    varId: el.substring( 0, indexOfOperatorStart ).trim(),
                    operator: operator.trim(),
                    value: value.trim()
                } );
            } );

            const actions = btnDef.actions;
            const lastAction = actions && actions.length > 0 ? actions[actions.length - 1] : undefined;
            if ( lastAction ) {
                lastAction.conditions = conditions;
            }
            break;
        case 'dcIncludes':
            var dcIncludes = new Array();
            var comaSplit = lineSplit[1].split( ',' );

            for ( var i = 0; i < comaSplit.length; i++ ) {
                dcIncludes.push( {
                    dataChooserId: comaSplit[i]
                } );
            }
            btnDef.dcIncludes = dcIncludes;
            break;
        case 'dcExcludes':
            var dcExcludes = new Array();
            var comaSplit = lineSplit[1].split( ',' );

            for ( var i = 0; i < comaSplit.length; i++ ) {
                dcExcludes.push( {
                    dataChooserId: comaSplit[i]
                } );
            }
            btnDef.dcExcludes = dcExcludes;
            break;
        case 'validators':
            btnDef.oldValidators = handleClasses( connectEqualSplit( lineSplit ) );
            break;
        case 'variablesSetters':
            btnDef.oldVariablesSetters = handleClasses( connectEqualSplit( lineSplit ) );
            break;
        case 'filled':
          btnDef.filled = parseBoolean( lineSplit[1] );
          break;
        case 'hideFrame':
          btnDef.hideFrame = parseBoolean( lineSplit[1] );
          break;
        case 'buttonWidth':
          btnDef.width = parseInt( lineSplit[1] );
          break;
        case 'buttonHeight':
          btnDef.height = parseInt( lineSplit[1] );
          break;
        default:
            Ext.ux.suncode.XpdlErrors.addError( {
                object: getTranslation( 'Przycisk akceptacji' ) + ': ' + btnDef.buttonName,
                processDefId: processDefId,
                activityDefId: activityDefId,
                descr: getTranslation( 'Nieznany parametr konfiguracyjny' ) + ': ' + confName,
                correction: getTranslation( 'Usunięcie parametru' )
            } );
            break;
    }

    return btnDef;
}

function handleClasses( value ) {
    var classes = new Array();
    var semicolonSplit = value.split( ';' );
    var classpathRegex = new RegExp( /^(.*?)\(/i );

    for ( var i = 0; i < semicolonSplit.length; i++ ) {
        var oneSplit = semicolonSplit[i];
        var classpath = classpathRegex.exec( oneSplit );

        if ( classpath && classpath[1] ) {
            var clazz = new Object();
            clazz = Ext.apply( {
                classpath: classpath[1],
                parameters: handleClassParameters( oneSplit )
            }, clazz );

            classes.push( clazz );
        }
    }

    return classes;
}

function handleClassParameters( value ) {
    var parameters = new Array();
    var parametersRegex = new RegExp( /\((.*?)\)/i );
    var params = parametersRegex.exec( value );

    if ( params && params[1] ) {
        var paramsSplit = params[1].split( ',' );

        for ( var j = 0; j < paramsSplit.length; j++ ) {
            var parameter = new Object();
            parameter = Ext.apply( {
                id: paramsSplit[j]
            }, parameter );

            parameters.push( parameter );
        }
    }

    return parameters;
}

function handleGeneratePdfBtnConfLine( processDefId, activityDefId, btnDef, line ) {
    var lineSplit = line.split( '=', -1 );
    var confName = lineSplit[0];

    switch ( confName ) {
        case 'buttonName':
            btnDef.buttonName = decodeTextFromXpdl( connectEqualSplit( lineSplit ) );
            break;
        case 'DocClass':
            btnDef.docClassName = decodeTextFromXpdl( lineSplit[1] );
            break;
        case 'Template':
            btnDef.templateName = decodeTextFromXpdl( lineSplit[1] );
            break;
        case 'checkForm':
            btnDef.checkForm = parseBoolean( lineSplit[1] );
            break;
        default:
            Ext.ux.suncode.XpdlErrors.addError( {
                object: getTranslation( 'Przycisk generowania PDF' ) + ': ' + decodeTextFromXpdl( btnDef.buttonName ),
                processDefId: processDefId,
                activityDefId: activityDefId,
                descr: getTranslation( 'Nieznany parametr konfiguracyjny' ) + ': ' + confName,
                correction: getTranslation( 'Usunięcie parametru' )
            } );
            break;
    }

    return btnDef;
}

function handleAddFileBtnConfLine( processDefId, activityDefId, btnDef, line ) {
    var lineSplit = line.split( '=', -1 );
    var confName = lineSplit[0];

    switch ( confName ) {
        case 'buttonName':
            btnDef.buttonName = decodeTextFromXpdl( connectEqualSplit( lineSplit ) );
            break;
        case 'ClassName':
            btnDef.docClassName = decodeTextFromXpdl( lineSplit[1] );
            break;
        case 'sourceName':
            btnDef.templateName = decodeTextFromXpdl( lineSplit[1] );
            break;
        default:
            Ext.ux.suncode.XpdlErrors.addError( {
                object: getTranslation( 'Przycisk podłączania pliku' ) + ': ' + btnDef.buttonName,
                processDefId: processDefId,
                activityDefId: activityDefId,
                descr: getTranslation( 'Nieznany parametr konfiguracyjny' ) + ': ' + confName,
                correction: getTranslation( 'Usunięcie parametru' )
            } );
            break;
    }

    return btnDef;
}

function handleBarcodePrintBtnConfLine( processDefId, activityDefId, btnDef, line ) {
    var lineSplit = line.split( '=', -1 );

    if ( lineSplit.length == 1 ) {
        btnDef.labelTextVar = lineSplit[0];
        return btnDef;
    }

    var confName = lineSplit[0];

    switch ( confName ) {
        case 'LabelPath':
            btnDef.labelPath = lineSplit[1];
            break;
        default:
            Ext.ux.suncode.XpdlErrors.addError( {
                object: getTranslation( 'Przycisk drukowania kodu kreskowego' ) + ': ' + btnDef.buttonName,
                processDefId: processDefId,
                activityDefId: activityDefId,
                descr: getTranslation( 'Nieznany parametr konfiguracyjny' ) + ': ' + confName,
                correction: getTranslation( 'Usunięcie parametru' )
            } );
            break;
    }

    return btnDef;
}

function handleAutoUpdateConfLine( processDefId, activityDefId, auDef, line ) {
    var lineSplit = line.split( '=', -1 );
    var confName = lineSplit[0];

    switch ( confName ) {
        case 'actionsource':
            auDef.actionsource = lineSplit[1];
            break;
        case 'datasource':
            auDef.datasource = lineSplit[1];
            break;
        case 'destination':
            auDef.destination = lineSplit[1];
            break;
        case 'taskName':
            auDef.taskName = lineSplit[1];
            break;
        case 'eventType':
            auDef.eventType = lineSplit[1];
            break;
        case 'buttonName':
            auDef.buttonName = decodeTextFromXpdl( lineSplit[1] );
            break;
        default:
            Ext.ux.suncode.XpdlErrors.addError( {
                object: getTranslation( 'Akcja dla zmiennej formularza' ) + ': ' + auDef.actionsource,
                processDefId: processDefId,
                activityDefId: activityDefId,
                descr: getTranslation( 'Nieznany parametr konfiguracyjny' ) + ': ' + confName,
                correction: getTranslation( 'Usunięcie parametru' )
            } );
            break;
    }

    return auDef;
}

function handleAcceptanceConfLine( processDefId, activityDefId, acceptanceDef, line ) {
    var lineSplit = line.split( '=', -1 );
    var confName = lineSplit[0];

    switch ( confName ) {
        case 'acceptVar':
            acceptanceDef.acceptVar = lineSplit[1];
            break;
        case 'checkVar':
            acceptanceDef.checkVar = lineSplit[1];
            break;
        case 'setVar':
            var qMarkSplit = decodeTextFromXpdl( lineSplit[1] ).split( '?' );
            var dotSplit = qMarkSplit[0].split( ':' );
            acceptanceDef.resultVar = dotSplit[0].trim();
            acceptanceDef.acceptVarValue = dotSplit[1].trim();
            acceptanceDef.checkVarValue = qMarkSplit[1].trim();
            break;
        case 'actionName':
            acceptanceDef.buttonName = lineSplit[1];
            break;
        default:
            Ext.ux.suncode.XpdlErrors.addError( {
                object: getTranslation( 'Akceptacja' ),
                processDefId: processDefId,
                activityDefId: activityDefId,
                descr: getTranslation( 'Nieznany parametr konfiguracyjny' ) + ': ' + confName,
                correction: getTranslation( 'Usunięcie parametru' )
            } );
            break;
    }

    return acceptanceDef;
}

function handleHttpLinkConfLine( processDefId, activityDefId, hlDef, line ) {
    var lineSplit = line.split( '=', -1 );
    var confName = lineSplit[0];

    switch ( confName ) {
        case 'type':
            hlDef.type = lineSplit[1];
            break;
        case 'Name':
        	var connected = connectEqualSplit( lineSplit );
            hlDef.actionName = generateId( connected );
            hlDef.buttonName = decodeTextFromXpdl( connected );
            break;
        case 'Tooltip':
          hlDef.tooltip = decodeTextFromXpdl( connectEqualSplit( lineSplit ) );
          break;
        case 'Url':
            hlDef.url = decodeTextFromXpdl( connectEqualSplit( lineSplit ) );
            break;
        case 'Params':
            if ( !Ext.isEmpty( lineSplit[1] ) ) {
              var params = lineSplit[1].split( ',' );

              for ( var i = 0; i < params.length; i++ ) {
                hlDef.params.push( {
                  varId: params[i]
                } );
              }
            }

            break;
        case 'VariableId':
            hlDef.location = lineSplit[1];
            break;
        case 'saveForm':
            hlDef.saveForm = parseBoolean( lineSplit[1] );
            break;
        case 'destination':
            hlDef.destination = lineSplit[1];
            break;
        default:
            Ext.ux.suncode.XpdlErrors.addError( {
                object: getTranslation( 'Przycisk formularza' ) + ': ' + hlDef.buttonName,
                processDefId: processDefId,
                activityDefId: activityDefId,
                descr: getTranslation( 'Nieznany parametr konfiguracyjny' ) + ': ' + confName,
                correction: getTranslation( 'Usunięcie parametru' )
            } );
            break;
    }

    return hlDef;
}

function handleActionButtonConfLine( processDefId, activityDefId, hlDef, line ) {
    var lineSplit = line.split( '=', -1 );
    var confName = lineSplit[0];

    switch ( confName ) {
        case 'buttonName':
            hlDef.actionName = generateId( lineSplit[1] );
            hlDef.buttonName = decodeTextFromXpdl( lineSplit[1] );
            break;
        case 'actionLink':
            hlDef.type = 'ActionLink';
            hlDef.url = decodeTextFromXpdl( lineSplit[1] );
            break;
        case 'tooltip':
          hlDef.tooltip = decodeTextFromXpdl( lineSplit[1] );
          break;
        case 'windowConf':
            hlDef.type = 'WindowConf';
            hlDef.url = decodeTextFromXpdl( lineSplit[1] );
            break;
        case 'variableName':
            hlDef.location = lineSplit[1];
            break;
        case 'type':
            break;
        case 'destination':
            hlDef.destination = lineSplit[1];
            break;
        default:
            Ext.ux.suncode.XpdlErrors.addError( {
                object: getTranslation( 'Przycisk formularza' ) + ': ' + hlDef.buttonName,
                processDefId: processDefId,
                activityDefId: activityDefId,
                descr: getTranslation( 'Nieznany parametr konfiguracyjny' ) + ': ' + confName,
                correction: getTranslation( 'Usunięcie parametru' )
            } );
            break;
    }

    return hlDef;
}

function handleVariableSet( processDefId, activityDefId, vs, toView ) {
    var vsDef = new Object();
    vsDef = Ext.apply( {
        varId: generateId( 'variable_set_' + Ext.id() ),
        name: '',
        type: 'VARIABLE_SET',
        columns: new Array(),
        local: 'DEFAULT',
        collapsible: true,
        stateful: true,
        autoHeight: false,
        autoHeightMin: '',
        autoHeightMax: '',
        hideRowNumber: false,
        headerFontSize: null,
    	  cellFontSize: null,
        actions: new Array(),
        groupers: new Array(),
        DTButtons: new Array(),
        formActions: new Array(),
        eventActions: new Array(),
        genre: 'VARIABLE_SET'
    }, vsDef );
    var dtConfs = new Array();

    var vsLines = vs.split( '\n' );

    for ( var i = 0; i < vsLines.length; i++ ) {
        var line = vsLines[i];

        if ( line.startsWith( 'DT_TABLE_ID' ) ) {
            vsDef.varId = line.split( '=' )[1];
        } else if ( line.startsWith( 'DT_TABLE_NAME' ) ) {
            vsDef.name = decodeTextFromXpdl( connectEqualSplit( line.split( '=' ) ) );
        } else if ( line.startsWith( 'DT_LOCAL' ) ) {
            vsDef.local = line.split( '=' )[1].toUpperCase();
        } else if ( line.startsWith( 'DT_COLLAPSIBLE' ) ) {
            vsDef.collapsible = parseBoolean( line.split( '=' )[1] );
        } else if ( line.startsWith( 'DT_STATEFUL' ) ) {
            vsDef.stateful = parseBoolean( line.split( '=' )[1] );
        } else if ( line.startsWith( 'DT_EVENT' ) ) {
            var event = line.split( '=', -1 );
            vsDef.actions.push( {
                source: event[0],
                func: event[1]
            } );
        } else if ( line.startsWith( 'DT_CONF' ) ) {
            var dtConfText = 'DT_CONF_';
            var hiddenText = '_DT_HIDDEN=';
            var differentHiddenTrueText = '_DIFFERENT_HIDDEN=true';
            var readonlyText = '_READONLY=';
            var differentReadonlyTrueText = '_DIFFERENT_READONLY=true';
            var dtConfVarId = '';

            if ( line.lastIndexOf( hiddenText ) != -1 ) {
                dtConfVarId = line.substring( dtConfText.length, line.lastIndexOf( hiddenText ) );
                var columnDtConfs = dtConfs[dtConfVarId];
                var differentHidden = false;
                if ( Ext.isEmpty( columnDtConfs ) ) {
                    columnDtConfs = new Array();
                }

                for ( var j = 0; j < vsLines.length; j++ ) {
                  if ( vsLines[j].lastIndexOf( dtConfVarId + differentHiddenTrueText ) != -1 ) {
                    differentHidden = true;
                    break;
                  }
                }

                columnDtConfs.push( {
                    hidden: parseBoolean( line.substring( line.lastIndexOf( hiddenText ) + hiddenText.length, line.length ) ),
                    differentHidden: differentHidden
                } );

                dtConfs[dtConfVarId] = columnDtConfs;
            } else if ( line.lastIndexOf( readonlyText ) != -1 ) {
                dtConfVarId = line.substring( dtConfText.length, line.lastIndexOf( readonlyText ) );
                var columnDtConfs = dtConfs[dtConfVarId];
                var differentReadonly = false;
                if ( Ext.isEmpty( columnDtConfs ) ) {
                    columnDtConfs = new Array();
                }

                for ( var j = 0; j < vsLines.length; j++ ) {
                  if ( vsLines[j].lastIndexOf( dtConfVarId + differentReadonlyTrueText ) != -1 ) {
                    differentReadonly = true;
                    break;
                  }
                }

                columnDtConfs.push( {
                    readonly: parseBoolean( line.substring( line.lastIndexOf( readonlyText ) + readonlyText.length, line.length ) ),
                    differentReadonly: differentReadonly
                } );

                dtConfs[dtConfVarId] = columnDtConfs;
            }
        } else if ( line.startsWith( 'DT_TABLE_AUTO_HEIGHT' ) ) {
            vsDef.autoHeight = parseBoolean( line.split( '=' )[1] );
        } else if ( line.startsWith( 'DT_TABLE_MIN_HEIGHT' ) ) {
            vsDef.autoHeightMin = line.split( '=' )[1];
        } else if ( line.startsWith( 'DT_TABLE_MAX_HEIGHT' ) ) {
            vsDef.autoHeightMax = line.split( '=' )[1];
        } else if ( line.startsWith( 'DT_BUTTONS_FILL_POSITION' ) ) {
            vsDef.dtButtonsFillPosition = parseInt( line.split( '=' )[1] );
        } else if ( line.startsWith( 'DT_TABLE_SHOW_DELETE_CONFIRMATION' ) ) {
            vsDef.showDeleteConfirmation = parseBoolean( line.split( '=' )[1] );
        } else if ( line.startsWith( 'DT_TABLE_HIDE_ROW_NUMBER' ) ) {
            vsDef.hideRowNumber = parseBoolean( line.split( '=' )[1] );
        } else if ( line.startsWith( 'DT_GROUPER' ) ) {
            var dtGrouperText = 'DT_GROUPER_';
            var columnId = line.split( '=' )[1];
            var direction = line.substring( dtGrouperText.length, line.indexOf( '=' ) );

            vsDef.groupers.push( {
                columnId: columnId,
                direction: direction
            } );
        } else if ( line.startsWith( 'DT_CLICKS_TO_EDIT' ) ) {
          vsDef.clicksToEdit = line.split( '=' )[1];
        } else {
            var dataFieldDef = processDataFields.get( line );

            if ( dataFieldDef ) {
                vsDef.columns.push( {
                    varId: line,
                    name: dataFieldDef.name,
                    readonly: false,
                    hidden: false,
                    differentReadonly: false,
                    differentHidden: false
                } );
            } else {
                Ext.ux.suncode.XpdlErrors.addError( {
                    object: getTranslation( 'Tabela dynamiczna' ),
                    processDefId: processDefId,
                    activityDefId: activityDefId,
                    descr: getTranslation( 'Użycie nieistniejącej zmiennej procesu w tabeli dynamicznej' ) + ': ' + line,
                    correction: getTranslation( 'Pominięcie zmiennej' )
                } );
            }
        }
    }

    for ( var i = 0; i < vsDef.columns.length; i++ ) {
        var column = vsDef.columns[i];
        var columnVarId = column.varId;
        var columnDtConfs = dtConfs[columnVarId];

        if ( !Ext.isEmpty( columnDtConfs ) ) {
            for ( var j = 0; j < columnDtConfs.length; j++ ) {
                var dtConf = columnDtConfs[j];

                if ( Ext.isDefined( dtConf.hidden ) ) {
                  column.hidden = dtConf.hidden;
                }
                if ( Ext.isDefined( dtConf.differentHidden ) ) {
                  column.differentHidden = dtConf.differentHidden;
                }
                if ( Ext.isDefined( dtConf.readonly ) ) {
                  column.readonly = dtConf.readonly;
                }
                if ( Ext.isDefined( dtConf.differentReadonly ) ) {
                  column.differentReadonly = dtConf.differentReadonly;
                }
            }
        } else {
          var dataFieldDef = processDataFields.get( columnVarId );
          var tableColumns = processTablesColumns.get( vsDef.varId );
          var tableColumn = !Ext.isEmpty( tableColumns ) ? tableColumns.get( columnVarId ) : null;

          column.hidden = !Ext.isEmpty( tableColumn ) ? tableColumn.hidden : dataFieldDef.dtHidden;
          column.readonly = !Ext.isEmpty( tableColumn ) ? tableColumn.readonly : dataFieldDef.readonly;
        }
    }

    if ( toView ) {
        vsDef = Ext.apply( {
            editable: false
        }, vsDef );
    } else {
        vsDef = Ext.apply( {
            editable: true
        }, vsDef );
    }

    if ( Ext.isEmpty( vsDef.clicksToEdit ) ) {
      vsDef = Ext.apply( {
        clicksToEdit: 2
      }, vsDef );
    }

    if ( Ext.isEmpty( vsDef.showDeleteConfirmation ) ) {
      vsDef = Ext.apply( {
        showDeleteConfirmation: false
      }, vsDef );
    }

    if ( Ext.isEmpty( vsDef.hideRowNumber ) ) {
      vsDef = Ext.apply( {
        hideRowNumber: false
      }, vsDef );
    }

    return vsDef;
}

function handleDTButton( processDefId, activityDefId, dtBtn ) {
    var dtBtnDef = new Object();
    dtBtnDef = Ext.apply( {
        genre: 'DT_BUTTON',
        buttonId: '',
        destination: 'TASKFORM',
        name: '',
        icon: '',
        color: '',
        tooltip: '',
        handler: '',
        disabled: false,
        formActions: new Array(),
        eventActions: new Array(),
        buttonDefId: '',
        parameterized: false
    }, dtBtnDef );
    var params = new Array();

    var dtBtnLines = dtBtn.split( '\n' );

    for ( var i = 0; i < dtBtnLines.length; i++ ) {
        var line = dtBtnLines[i];
        var lineSplit = line.split( '=', -1 );
        var confName = lineSplit[0];

        switch ( confName ) {
            case 'variable_set':
                dtBtnDef.vsConnection = lineSplit[1];
                break;
            case 'variableSetId':
                dtBtnDef.vsId = lineSplit[1];
                break;
            case 'disabled':
                dtBtnDef.disabled = parseBoolean( lineSplit[1] );
                break;
            case 'handler':
                dtBtnDef.handler = lineSplit[1];
                break;
            case 'id':
                dtBtnDef.buttonId = lineSplit[1];
                break;
            case 'text':
                dtBtnDef.name = connectEqualSplit( lineSplit );
                break;
            case 'icon':
                dtBtnDef.icon = lineSplit[1];
                break;
            case 'color':
                dtBtnDef.color = lineSplit[1];
                break;
            case 'tooltip':
                dtBtnDef.tooltip = connectEqualSplit( lineSplit );
                break;
            case 'globalId':
                var globalId = lineSplit[1];
                dtBtnDef.globalId = globalId;
              break;
            case 'buttonDefId':
                dtBtnDef.buttonDefId = connectEqualSplit( lineSplit );
                break;
            case 'cls':
                break;
            case 'destination':
                dtBtnDef.destination = lineSplit[1];
                break;
            default:
                if ( confName.isBtnParam() ) {
                    var paramNameValueSection = connectEqualSplit( lineSplit );
                    var paramNameValueSectionSplit = paramNameValueSection.split( '=', -1 );

                    params.push( {
                        realName: paramNameValueSectionSplit[0],
                        value: connectEqualSplit( paramNameValueSectionSplit )
                    } );
                } else {
                    Ext.ux.suncode.XpdlErrors.addError( {
                        object: getTranslation( 'Przycisk w tabeli dynamicznej' ) + ': ' + dtBtnDef.name,
                        processDefId: processDefId,
                        activityDefId: activityDefId,
                        descr: getTranslation( 'Nieznany parametr konfiguracyjny' ) + ': ' + confName,
                        correction: getTranslation( 'Usunięcie parametru' )
                    } );
                }
                break;
        }
    }

    if ( !Ext.isEmpty( params ) ) {
        dtBtnDef.parameterized = true;
        dtBtnDef.params = params;
    }

    return dtBtnDef;
}

function handleExtraDataChooserConfig( processDefId, activityDefId, extraDataChooserConfig ) {
    var dataChooserId = '';
    var attributes = new Array();

    var lines = extraDataChooserConfig.split( '\n' );

    for ( var i = 0; i < lines.length; i++ ) {
        var line = lines[i];
        var lineSplit = line.split( '=', -1 );

        if ( lineSplit.length == 1 ) {
            dataChooserId = lineSplit[0];
        } else {
            attributes.push( {
                key: decodeTextFromXpdl( lineSplit[0] ),
                value: connectEqualSplit( lineSplit )
            } );
        }
    }

    if ( processDataFields.get( dataChooserId ) ) {
        return {
            dataChooserId: dataChooserId,
            attributes: attributes
        };
    } else {
        Ext.ux.suncode.XpdlErrors.addError( {
            object: getTranslation( 'Zadanie' ),
            processDefId: processDefId,
            activityDefId: activityDefId,
            descr: getTranslation( 'Atrybut DATA_CHOOSER odnosi się do nieistniejącej dynamicznej listy' ),
            correction: getTranslation( 'Pominięcie atrybutu' )
        } );

        return null;
    }
}

function handleAssignmentType( type ) {
    switch ( type ) {
        case 'NewAssignment':
        case 'newAssignment':
            return 'newAssignment';
        case 'Superior':
        case 'superior':
            return 'superior';
        case 'Superior_role':
        case 'superior_role':
            return 'superior_role';
        default:
            return 'role';
    }
}

function isCorrectDeadlineVariable( varId ) {
    return ( !Ext.isEmpty( varId ) && ( processDataFields.get( varId ) || varId == 'PROCESS_STARTED_TIME' || varId == 'ACTIVITY_ACTIVATED_TIME' || varId == 'ACTIVITY_ACCEPTED_TIME' ) );
}

function readXpdlProcessTransitions( config, connections ) {
    var transitions = new Array();
    var mainPanel = Ext.getCmp( 'main_panel' );

    for ( var i = 0; i < connections.length; i++ ) {
        var t = connections[i];
        var transitionDef = new Object();
        var isBasic = true;
        var isOtherwise = false;
        var isDeadline = false;
        var boxPaths = new Array();
        var linePaths = new Array();

        var els = t.Transition;
        for ( var j = 0; j < els.length; j++ ) {
            var el = els[j];

            if ( el.Id ) {
                var transitionId = el.Id;
                transitionDef = Ext.apply( {
                    tId: transitionId
                }, transitionDef );
              mainPanel.storeTransitionId( transitionId );
            } else if ( el.From ) {
                transitionDef = Ext.apply( {
                    from: el.From
                }, transitionDef );
            } else if ( el.To ) {
                transitionDef = Ext.apply( {
                    to: el.To
                }, transitionDef );
            } else if ( el.Condition ) {
                var conditionValue = '';

                for ( var k = 0; k < el.Condition.length; k++ ) {
                    if ( el.Condition[k].XPDLNODEVALUE ) {
                        isBasic = false;
                        conditionValue = el.Condition[k].XPDLNODEVALUE;
                    } else if ( el.Condition[k].Type == 'OTHERWISE' ) {
                        isBasic = false;
                        isOtherwise = true;
                    } else if ( el.Condition[k].Type == 'EXCEPTION' ) {
                        isBasic = false;
                        isDeadline = true;
                    }
                }

                if ( !Ext.isEmpty( conditionValue ) ) {
                    if ( isDeadline ) {
                        var exceptionName = decodeTextFromXpdl( conditionValue );
                        var deadlineInfo = deadlineInfos.get( exceptionName );

                        if ( !Ext.isEmpty( deadlineInfo ) && deadlineInfo.execution === 'SYNCHR' ) {
                          Ext.ux.suncode.XpdlErrors.addError( {
                            object: getTranslation( 'Połączenie' ),
                            processDefId: config.initialProcessDefId,
                            activityDefId: deadlineInfo.activityDefId,
                            descr: getTranslation( 'Wykorzystano synchroniczny termin ostateczny w połączeniu' ) + ': ' + transitionDef.tId,
                            correction: getTranslation( 'Usunięcie wykorzystania terminu ostatecznego z połączenia' )
                          } );
                        } else {
                          transitionDef = Ext.apply( {
                            exceptionName: exceptionName
                          }, transitionDef );
                        }
                    } else if ( !( isBasic || isOtherwise ) ) {
                        transitionDef = Ext.apply( {
                            condition: decodeTextFromXpdl( conditionValue )
                        }, transitionDef );
                    }
                }
            } else if ( el.ExtendedAttributes ) {
                var extAttrs = decomposeExtendedAttributes( el.ExtendedAttributes );

                for ( var k = 0; k < extAttrs.length; k++ ) {
                    var ea = extAttrs[k];
                    var eaName = ea.NAME;
                    var eaValue = ea.VALUE;

                    switch ( eaName ) {
                        case 'BOX_DIRECTION':
                            transitionDef = Ext.apply( {
                                boxDirection: eaValue
                            }, transitionDef );
                            break;
                        case 'FIRST_LINE_DIRECTION':
                            transitionDef = Ext.apply( {
                                firstLineDirection: eaValue
                            }, transitionDef );
                            break;
                        case 'SECOND_LINE_DIRECTION':
                            transitionDef = Ext.apply( {
                                secondLineDirection: eaValue
                            }, transitionDef );
                            break;
                        case 'BOX_PATH_DEF':
                            isBasic = false;
                            boxPaths.push( eaValue );
                            break;
                        case 'LINE_PATH_DEF':
                            linePaths.push( eaValue );
                            break;
                        default:
                            break;
                    }
                }
            }
        }

        if ( linePaths.length > 0 ) {
            transitionDef = Ext.apply( {
                linePaths: linePaths
            }, transitionDef );
        }

        if ( boxPaths.length > 0 ) {
            transitionDef = Ext.apply( {
                boxPaths: boxPaths
            }, transitionDef );
        }

        transitionDef = Ext.apply( {
            isBasic: isBasic,
            isOtherwise: isOtherwise,
            isDeadline: isDeadline
        }, transitionDef );

        transitions.push( transitionDef );
    }

    config = Ext.apply( {
        transitions: transitions
    }, config );

    return config;
}

function decomposeExtendedAttributes( extendedAttributes ) {
    var extAttrs = new Array();

    for ( var i = 0; i < extendedAttributes.length; i++ ) {
        var name = '';
        var value = '';

        var els = extendedAttributes[i].ExtendedAttribute;
        for ( var j = 0; j < els.length; j++ ) {
            var el = els[j];

            if ( el.Name ) {
                name = el.Name;
            } else if ( el.Value ) {
                value = el.Value;
            }
        }

        extAttrs.push( {
            NAME: name,
            VALUE: value
        } );
    }

    return extAttrs;
}